/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class FileHandler
extends StreamHandler {
    private final int limit;
    private final int count;
    private final String pattern;
    private final boolean append;

    public FileHandler() throws IOException, SecurityException {
        this(null, LogManager.getIntProperty("java.util.logging.FileHandler.limit", 0), LogManager.getIntProperty("java.util.logging.FileHandler.count", 1), LogManager.getBooleanProperty("java.util.logging.FileHandler.append", false));
    }

    public FileHandler(String pattern) throws IOException, SecurityException {
        this(pattern, 0, 1, false);
    }

    public FileHandler(String pattern, boolean append) throws IOException, SecurityException {
        this(pattern, 0, 1, append);
    }

    public FileHandler(String pattern, int limit, int count) throws IOException, SecurityException {
        this(pattern, limit, count, LogManager.getBooleanProperty("java.util.logging.FileHandler.append", false));
    }

    public FileHandler(String pattern, int limit, int count, boolean append) throws IOException, SecurityException {
        super(FileHandler.createFileStream(pattern, limit, count, append, 0), "java.util.logging.FileHandler", Level.ALL, null, FileHandler.class$("java.util.logging.XMLFormatter"));
        if (limit < 0 || count < 1) {
            throw new IllegalArgumentException();
        }
        this.pattern = pattern;
        this.limit = limit;
        this.count = count;
        this.append = append;
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    private static OutputStream createFileStream(String pattern, int limit, int count, boolean append, int generation) {
        int unique = 0;
        LogManager.getLogManager().checkAccess();
        if (pattern == null) {
            pattern = LogManager.getLogManager().getProperty("java.util.logging.FileHandler.pattern");
        }
        if (pattern == null) {
            pattern = "%h/java%u.log";
        }
        while (true) {
            String path = FileHandler.replaceFileNameEscapes(pattern, generation, unique, count);
            try {
                File file = new File(path);
                if (file.createNewFile()) {
                    return new FileOutputStream(path, append);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++unique;
            if (pattern.indexOf("%u") >= 0) continue;
            pattern = pattern + ".%u";
        }
    }

    private static String replaceFileNameEscapes(String pattern, int generation, int uniqueNumber, int count) {
        StringBuffer buf = new StringBuffer(pattern);
        boolean foundGeneration = false;
        int pos = 0;
        do {
            String replaceWith;
            if (buf.charAt(pos) == '/') {
                replaceWith = System.getProperty("file.separator");
                buf.replace(pos, pos + 1, replaceWith);
                pos = pos + replaceWith.length() - 1;
                continue;
            }
            if (buf.charAt(pos) != '%') continue;
            switch (buf.charAt(pos + 1)) {
                case 't': {
                    replaceWith = System.getProperty("java.io.tmpdir");
                    break;
                }
                case 'h': {
                    replaceWith = System.getProperty("user.home");
                    break;
                }
                case 'g': {
                    replaceWith = Integer.toString(generation);
                    foundGeneration = true;
                    break;
                }
                case 'u': {
                    replaceWith = Integer.toString(uniqueNumber);
                    break;
                }
                case '%': {
                    replaceWith = "%";
                    break;
                }
                default: {
                    replaceWith = "??";
                }
            }
            buf.replace(pos, pos + 2, replaceWith);
            pos = pos + replaceWith.length() - 1;
        } while (++pos < buf.length() - 1);
        if (!foundGeneration && count > 1) {
            buf.append('.');
            buf.append(generation);
        }
        return buf.toString();
    }

    public void publish(LogRecord record) {
        super.publish(record);
    }
}

