#ifndef _KATE_JS_BINDINGS_H_
#define _KATE_JS_BINDINGS_H_

#include <kjsembed/jsbindingplugin.h>
#include <kjsembed/jsproxy_imp.h>
#include <kjsembed/jsobjectproxy.h>

class PluginKateKJSWrapper;

namespace Kate {
	namespace JS {
		class Bindings: public KJSEmbed::Bindings::JSBindingPlugin {
		public:
			Bindings(QObject *parent);
			virtual ~Bindings();
			KJS::Object createBinding(KJSEmbed::KJSEmbedPart *jspart, KJS::ExecState *exec, const KJS::List &args) const;
			void addBindings(KJS::ExecState *exec, KJS::Object &target) const;
		};

		class DocumentManager: public KJSEmbed::JSProxyImp {
		public:
			enum MethodID {
				Document,
				ActiveDocument,
				DocumentWithID,
				FindDocument,
				IsOpen,
				OpenURL,
				Documents,
				CloseDocument,
				CloseAllDocuments
			};
			virtual bool implementsCall() const { return true; }
		    	virtual KJS::Value call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args );
			static void addBindings(KJS::ExecState *exec, KJSEmbed::JSObjectProxy *proxy,KJS::Object &target);
			private:
			DocumentManager( KJS::ExecState *exec, int id, KJSEmbed::JSObjectProxy *parent );

		private:
			int m_id;
			KJSEmbed::JSObjectProxy *m_proxy;

		};

		class Management: public KJSEmbed::JSProxyImp {
		public:
			enum MethodID {
				AddConfigPage,
				RemoveConfigPage,
				SetWindowConfiguration
			};
			Management( KJS::ExecState *exec, int id, class PluginKateKJSWrapper *kateplug);
			virtual bool implementsCall() const { return true; }
		    	virtual KJS::Value call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args );

		private:
			int m_id;
			class PluginKateKJSWrapper *m_wrapper;

		};
		
		class Application: public KJSEmbed::JSProxyImp {
		public:
			enum MethodID {
				ToolView
			};
			virtual bool implementsCall() const { return true; }
		    	virtual KJS::Value call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args );
			static void addBindings(KJS::ExecState *exec, KJSEmbed::JSObjectProxy *proxy,KJS::Object &target);
			private:
			Application( KJS::ExecState *exec, int id, KJSEmbed::JSObjectProxy *parent );

		private:
			int m_id;
			KJSEmbed::JSObjectProxy *m_proxy;

		};

	}
}

#endif
