/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;

public class CharArrayWriter
extends Writer {
    private static final int DEFAULT_INITIAL_BUFFER_SIZE = 32;
    protected char[] buf;
    protected int count;

    public CharArrayWriter() {
        this(32);
    }

    public CharArrayWriter(int size) {
        this.buf = new char[size];
    }

    public void close() {
    }

    public void flush() {
    }

    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.count = 0;
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    public int size() {
        return this.count;
    }

    public char[] toCharArray() {
        Object object = this.lock;
        synchronized (object) {
            try {
                char[] nc = new char[this.count];
                System.arraycopy(this.buf, 0, nc, 0, this.count);
                char[] cArray = nc;
                Object var4_4 = null;
                return cArray;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                throw throwable;
            }
        }
    }

    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            try {
                String string = new String(this.buf, 0, this.count);
                Object var3_3 = null;
                return string;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public void write(int oneChar) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.resize(1);
                this.buf[this.count++] = (char)oneChar;
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    public void write(char[] buffer, int offset, int len) {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (len >= 0) {
                    this.resize(len);
                }
                System.arraycopy(buffer, offset, this.buf, this.count, len);
                this.count += len;
            }
            finally {
                Object var5_5 = null;
            }
            return;
        }
    }

    public void write(String str, int offset, int len) {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (len >= 0) {
                    this.resize(len);
                }
                str.getChars(offset, offset + len, this.buf, this.count);
                this.count += len;
            }
            finally {
                Object var5_5 = null;
            }
            return;
        }
    }

    public void writeTo(Writer out) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                out.write(this.buf, 0, this.count);
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    private final void resize(int len) {
        if (this.count + len >= this.buf.length) {
            int newlen = this.buf.length * 2;
            if (this.count + len > newlen) {
                newlen = this.count + len;
            }
            char[] newbuf = new char[newlen];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
    }
}

