/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;

public final class AccessController {
    private AccessController() {
    }

    public static void checkPermission(Permission perm) throws AccessControlException {
        AccessController.getContext().checkPermission(perm);
    }

    public static Object doPrivileged(PrivilegedAction action) {
        return action.run();
    }

    public static Object doPrivileged(PrivilegedAction action, AccessControlContext context) {
        return action.run();
    }

    public static Object doPrivileged(PrivilegedExceptionAction action) throws PrivilegedActionException {
        try {
            return action.run();
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
    }

    public static Object doPrivileged(PrivilegedExceptionAction action, AccessControlContext context) throws PrivilegedActionException {
        try {
            return action.run();
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
    }

    public static AccessControlContext getContext() {
        return new AccessControlContext(new ProtectionDomain[0]);
    }
}

