/*
 * Copyright (C) 2003 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifdef USE_SMB_BRANCH

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <signal.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#include <errno.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>


#include "glade_support.h"

#include "constants.h"
#include "types.h"
#include "smb_module.h"

#include "basic_row.h"

#include "smb_open.h"

#include "master_lookup.h"
#include "misc.h"
#include "smb_list.h"
#include "smblookup.h"
#include "smb_misc.h"
#include "password_dialog.h"

void *smb_object=NULL;
GtkTreeView *smb_treeview=NULL;
unsigned net_root_type;


int smb_stderr(int n, void *data)
{
    char *line;
    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
    print_diagnostics("xfce/error", line, NULL);
    return TRUE;
}


G_MODULE_EXPORT
int open_smb(GtkTreeView * treeview, 
		GtkTreeIter * iter, 
		GtkTreePath * treepath, 
		gpointer user_data){

  char *checkfiles[]={
	  "nmblookup",
	  "smbclient",
	  NULL
  };
  int i;
  GtkTreeIter root_iter;
  GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
  tree_entry_t *en;
  
  get_network_root(treeview, &root_iter, &en);
  net_root_type=en->type;

  for (i=0;checkfiles[i];i++){
	gchar *test;
	test=g_find_program_in_path(checkfiles[i]);
	if (!test) {
	  print_diagnostics("xfce/error",
			  _("File not found"),": ",
			  checkfiles[i],"\n",
			  NULL);
	  return (0);
	} else {
		g_free(test);
		test=NULL;
	}
  }
  gtk_tree_model_get(GTK_TREE_MODEL(treemodel), iter, ENTRY_COLUMN, &en, -1);
  if (IS_ROOT_TYPE(en->type)) {
	  NMBmastersLookup(treeview);
  }
  else if (IS_XF_NETWG(en->subtype)){
	  SMBLookup(treeview,en->path,iter,FALSE,NULL);
  }
  else if (IS_XF_NETWS(en->subtype)){
	  int r;
	  char *c=getenv("SMB_USER");
	  
	  if (!en->tag) {
            if (c && strlen(c)){
		if (!strchr(c,'%')){
		    en->tag=g_strconcat(c,"%","challenge_me",NULL);
		}
		else en->tag=g_strconcat(c,"challenge_me",NULL);	
	    }
            else en->tag=g_strconcat("GUEST","%%",NULL);
	  }
	  
	  if (strncmp(en->tag,"GUEST",strlen("GUEST"))!=0){
	      if (*(strchr(en->tag,'%')+1) == 0){
		  c=en->tag;
		  en->tag=g_strconcat(c,"%","challenge_me",NULL);
		  g_free(c);
	      }	  
	  }
 
ask_again:
	  r=SMBLookup(treeview,en->path,iter,TRUE,en->tag);
	  if (r==CHALLENGED){
	       const char *p;
	       p=get_smbuserpass(tree_details->window,en);
       	       if (p && strlen(p)) {
		       g_free(en->tag);
		       en->tag=g_strdup(p);
		       goto ask_again;
	       } else {
		       reset_dummy_row(treemodel,iter,NULL,en,"xfce/error",_("Load failed"));
	       }

	  }
  } 
  else if (IS_XF_NETSHARE(en->subtype) || IS_NETDIR(en->subtype)){
	  int r;
	  char *c=getenv("SMB_USER");
	  
	  if (!en->tag) {
            if (c && strlen(c)){
		if (!strchr(c,'%')){
		    en->tag=g_strconcat(c,"%","challenge_me",NULL);
		}
		else en->tag=g_strconcat(c,"challenge_me",NULL);	
	    }
            else en->tag=g_strconcat("GUEST","%%",NULL);
	  }
	  
	  if (strncmp(en->tag,"GUEST",strlen("GUEST"))!=0){
	      if (*(strchr(en->tag,'%')+1) == 0){
		  c=en->tag;
		  en->tag=g_strconcat(c,"%","challenge_me",NULL);
		  g_free(c);
	      }	  
	  }
and_ask_again:
	  r=SMBList(treeview,en->path,iter,en->tag,SHOWS_HIDDEN(en->type));
	  if (r==CHALLENGED){
	       const char *p;
	       p=get_smbuserpass(tree_details->window,en);
       	       if (p && strlen(p)) {
		       g_free(en->tag);
		       en->tag=g_strdup(p);
		       goto and_ask_again;
	       } else {
		       reset_dummy_row(treemodel,iter,NULL,en,"xfce/error",_("Load failed"));
	       }
	  }
  } 
  SET_LOADED(en->type);
  return(1);
}
#endif

