/*
 * Copyright (C) 2003-4 Edscott Wilson Garcia
 * EMail: edscott@xfce.org
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define SPLIT_VIEW
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <gtk/gtk.h>
#include <sys/types.h>

#include "constants.h"
#include "types.h"

#define __BASIC_COLOURS_C__ 
#include "basic_colours.h"

#include "misc.h" /* for get_iter_from_reference() */

/* even for dark, odd for light: */
#define THE_COLOR(x) ((x)*2 + ((light_background)?0:1))
#define NUM_TYPE_COLOURS (sizeof(o_type_colours) / sizeof(o_type_colours[0]))
static gchar *o_type_colours[] = {
	"#000077","#9999ff",	/*DIR_COLOR*/
	"#006666","#00ffff",	/*FSTAB_COLOR*/
	"#444444","#cccccc",	/*PIPE_COLOR*/
	"#ff00ff","#ff00ff",	/*SOCK_COLOR*/
	"#006000","#00ff00",	/*EXEC_COLOR*/
	"#660000","#ff9999",	/*BOOKMARK_COLOR*/
	"#444444","#aaaaaa",	/*TRASH_COLOR*/
};
static 
GdkColor type_colours[NUM_TYPE_COLOURS];
/* XXX used at options.c. */
/*static*/
gboolean light_background=TRUE;

static 
gboolean 
switch_colors(		GtkTreeModel * treemodel, 
			GtkTreePath * treepath, 
			GtkTreeIter * iter, 
			gpointer data)
{
	GdkColor *c=NULL;
	tree_entry_t *en;
    
	gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
	if (!en) return FALSE;

	if (!(tree_details->preferences & DISABLE_TEXT_COLOR)){
	  if(IS_XF_FSTAB(en->type)) c=&type_colours[THE_COLOR(FSTAB_COLOR)];	
	  else if (IS_DIR(en->type)||IS_XF_NETSHARE(en->subtype)||IS_NETDIR(en->subtype)) 
	    c= &type_colours[THE_COLOR(DIR_COLOR)];
	  else if(IS_EXE(en->type)) c=&type_colours[THE_COLOR(EXEC_COLOR)];
	  else if(IS_XF_SOCK(en->type)) c=&type_colours[THE_COLOR(SOCK_COLOR)];
	  else if(IS_XF_FIFO(en->type)) c=&type_colours[THE_COLOR(PIPE_COLOR)];
	  else if(IS_TOP_BOOKMARK(en->subtype)) c=&type_colours[THE_COLOR(BOOKMARK_COLOR)];
	  else if(IS_TRASH_TYPE(en->type)) c=&type_colours[THE_COLOR(TRASH_COLOR)];
	}
       	gtk_tree_store_set((GtkTreeStore *) treemodel, iter, COLOUR_COLUMN,c, -1);
	return FALSE;
}

G_MODULE_EXPORT
void 
parse_colours(		void)
{
    int i;
    gboolean success[NUM_TYPE_COLOURS];
    for (i = 0; i < NUM_TYPE_COLOURS; i++)	{
        gdk_color_parse(o_type_colours[i], &type_colours[i]);
    }
    gdk_colormap_alloc_colors(gdk_rgb_get_colormap(),
		type_colours, NUM_TYPE_COLOURS,
		FALSE, TRUE, success);
}

G_MODULE_EXPORT
gint 
set_treeview_colours(	GtkTreeView * treeview)
{
    GtkStyle *style=gtk_rc_get_style ((GtkWidget *)treeview);  
    GdkColor base=style->base[GTK_STATE_NORMAL];
    int sum=base.red+base.green+base.blue;
    gboolean colors_changed=FALSE;
    
    if (sum < 3*32768) {
	if (light_background) colors_changed=TRUE;
	light_background=FALSE;
    }
    else {
	if (!light_background) colors_changed=TRUE;
	light_background=TRUE;
    }
    if (colors_changed){
	/* re-render colors */ 
	GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
	gtk_tree_model_foreach(treemodel, switch_colors, treeview);
    }
	   /* printf("DBG**:bg sum is %d (%d) light_background=%d\n",
	    sum,256*256*3/2,light_background);*/ 
     return TRUE;
}

G_MODULE_EXPORT
gboolean
set_row_colours(	GtkTreeModel * treemodel, 
		        GtkTreeIter * iter, 
			GtkTreeRowReference *reference,
			gint colour_code)
{
    if (!iter) {
	if ((iter=get_iter_from_reference(treemodel,reference))==NULL)
	    return FALSE;
    }
    if (!(tree_details->preferences & DISABLE_TEXT_COLOR))  {
	gtk_tree_store_set((GtkTreeStore *) treemodel, iter, 
		COLOUR_COLUMN,&type_colours[THE_COLOR(colour_code)], -1);
    } else {
       	gtk_tree_store_set((GtkTreeStore *) treemodel, iter, 
		COLOUR_COLUMN,NULL, -1);
    }
    return TRUE;
}


