/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.rmic;

import gnu.java.rmi.rmic.Compiler;
import gnu.java.rmi.rmic.TabbedWriter;
import gnu.java.rmi.server.RMIHashes;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

public class RMIC {
    private String[] args;
    private int next;
    private Exception exception;
    private boolean keep;
    private boolean need11Stubs;
    private boolean need12Stubs;
    private boolean compile;
    private boolean verbose;
    private String destination;
    private PrintWriter out;
    private TabbedWriter ctrl;
    private Class clazz;
    private String classname;
    private String fullclassname;
    private MethodRef[] remotemethods;
    private String stubname;
    private String skelname;
    private int errorCount;
    private Class mRemoteInterface;

    private /* synthetic */ void finit$() {
        this.keep = false;
        this.need11Stubs = true;
        this.need12Stubs = true;
        this.compile = true;
        this.errorCount = 0;
    }

    public RMIC(String[] a) {
        this.finit$();
        this.args = a;
    }

    public static void main(String[] args) {
        RMIC r = new RMIC(args);
        if (!r.run()) {
            Exception exception = r.getException();
            if (exception != null) {
                exception.printStackTrace();
            } else {
                System.exit(1);
            }
        }
    }

    public boolean run() {
        this.parseOptions();
        if (this.next >= this.args.length) {
            RMIC.error("no class names found");
        }
        for (int i = this.next; i < this.args.length; ++i) {
            try {
                if (this.verbose) {
                    System.out.println("[Processing class " + this.args[i] + ".class]");
                }
                this.processClass(this.args[i].replace(File.separatorChar, '.'));
                continue;
            }
            catch (Exception e) {
                this.exception = e;
                return false;
            }
        }
        return true;
    }

    private boolean processClass(String classname) throws Exception {
        this.errorCount = 0;
        this.analyzeClass(classname);
        if (this.errorCount > 0) {
            System.exit(1);
        }
        this.generateStub();
        if (this.need11Stubs) {
            this.generateSkel();
        }
        if (this.compile) {
            this.compile(this.stubname.replace('.', File.separatorChar) + ".java");
            if (this.need11Stubs) {
                this.compile(this.skelname.replace('.', File.separatorChar) + ".java");
            }
        }
        if (!this.keep) {
            new File(this.stubname.replace('.', File.separatorChar) + ".java").delete();
            if (this.need11Stubs) {
                new File(this.skelname.replace('.', File.separatorChar) + ".java").delete();
            }
        }
        return true;
    }

    private void analyzeClass(String cname) throws Exception {
        int p;
        if (this.verbose) {
            System.out.println("[analyze class " + cname + "]");
        }
        this.classname = (p = cname.lastIndexOf(46)) != -1 ? cname.substring(p + 1) : cname;
        this.fullclassname = cname;
        HashSet rmeths = new HashSet();
        this.findClass();
        this.mRemoteInterface = this.getRemoteInterface(this.clazz);
        if (this.mRemoteInterface == null) {
            return;
        }
        if (this.verbose) {
            System.out.println("[implements " + this.mRemoteInterface.getName() + "]");
        }
        Method[] meths = this.mRemoteInterface.getDeclaredMethods();
        for (int i = 0; i < meths.length; ++i) {
            int index;
            Class[] exceptions = meths[i].getExceptionTypes();
            for (index = 0; index < exceptions.length && !exceptions[index].equals(RMIC.class$("java.rmi.RemoteException")); ++index) {
            }
            if (index < exceptions.length) {
                rmeths.add(meths[i]);
                continue;
            }
            this.logError("Method " + meths[i] + " does not throw a java.rmi.RemoteException");
        }
        this.remotemethods = new MethodRef[rmeths.size()];
        int c = 0;
        Iterator i = rmeths.iterator();
        while (i.hasNext()) {
            this.remotemethods[c++] = new MethodRef((Method)i.next());
        }
        Arrays.sort(this.remotemethods);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public Exception getException() {
        return this.exception;
    }

    private void findClass() throws ClassNotFoundException {
        this.clazz = Class.forName(this.fullclassname, true, ClassLoader.getSystemClassLoader());
    }

    private void generateStub() throws IOException {
        int j;
        Class[] sig;
        Method m;
        Class iface;
        this.stubname = this.fullclassname + "_Stub";
        String stubclassname = this.classname + "_Stub";
        this.ctrl = new TabbedWriter(new FileWriter((this.destination == null ? "" : this.destination + File.separator) + this.stubname.replace('.', File.separatorChar) + ".java"));
        this.out = new PrintWriter(this.ctrl);
        if (this.verbose) {
            System.out.println("[Generating class " + this.stubname + ".java]");
        }
        this.out.println("// Stub class generated by rmic - DO NOT EDIT!");
        this.out.println();
        if (this.fullclassname != this.classname) {
            String pname = this.fullclassname.substring(0, this.fullclassname.lastIndexOf(46));
            this.out.println("package " + pname + ";");
            this.out.println();
        }
        this.out.print("public final class " + stubclassname);
        this.ctrl.indent();
        this.out.println("extends java.rmi.server.RemoteStub");
        this.out.print("implements ");
        Class[] ifaces = this.clazz.getInterfaces();
        HashSet remoteIfaces = new HashSet();
        for (int i = 0; i < ifaces.length; ++i) {
            iface = ifaces[i];
            if (!RMIC.class$("java.rmi.Remote").isAssignableFrom(iface)) continue;
            remoteIfaces.add(iface);
        }
        Iterator iter = remoteIfaces.iterator();
        while (iter.hasNext()) {
            iface = (Class)iter.next();
            this.out.print(iface.getName());
            if (!iter.hasNext()) continue;
            this.out.print(", ");
        }
        this.ctrl.unindent();
        this.out.print("{");
        this.ctrl.indent();
        if (this.need12Stubs) {
            this.out.println("private static final long serialVersionUID = 2L;");
            this.out.println();
        }
        if (this.need11Stubs) {
            this.out.println("private static final long interfaceHash = " + RMIHashes.getInterfaceHash(this.clazz) + "L;");
            this.out.println();
            if (this.need12Stubs) {
                this.out.println("private static boolean useNewInvoke;");
                this.out.println();
            }
            this.out.print("private static final java.rmi.server.Operation[] operations = {");
            this.ctrl.indent();
            for (int i = 0; i < this.remotemethods.length; ++i) {
                m = this.remotemethods[i].meth;
                this.out.print("new java.rmi.server.Operation(\"");
                this.out.print(RMIC.getPrettyName(m.getReturnType()) + " ");
                this.out.print(m.getName() + "(");
                sig = m.getParameterTypes();
                for (j = 0; j < sig.length; ++j) {
                    this.out.print(RMIC.getPrettyName(sig[j]));
                    if (j + 1 >= sig.length) continue;
                    this.out.print(", ");
                }
                this.out.print(")\")");
                if (i + 1 >= this.remotemethods.length) continue;
                this.out.println(",");
            }
            this.ctrl.unindent();
            this.out.println("};");
            this.out.println();
        }
        if (this.need12Stubs) {
            int i;
            for (i = 0; i < this.remotemethods.length; ++i) {
                m = this.remotemethods[i].meth;
                this.out.println("private static java.lang.reflect.Method $method_" + m.getName() + "_" + i + ";");
            }
            this.out.println();
            this.out.print("static {");
            this.ctrl.indent();
            this.out.print("try {");
            this.ctrl.indent();
            if (this.need11Stubs) {
                this.out.println("java.rmi.server.RemoteRef.class.getMethod(\"invoke\", new java.lang.Class[] { java.rmi.Remote.class, java.lang.reflect.Method.class, java.lang.Object[].class, long.class });");
                this.out.println("useNewInvoke = true;");
            }
            for (i = 0; i < this.remotemethods.length; ++i) {
                m = this.remotemethods[i].meth;
                this.out.print("$method_" + m.getName() + "_" + i + " = ");
                this.out.print(this.mRemoteInterface.getName() + ".class.getMethod(\"" + m.getName() + "\"");
                this.out.print(", new java.lang.Class[] {");
                sig = m.getParameterTypes();
                for (j = 0; j < sig.length; ++j) {
                    this.out.print(RMIC.getPrettyName(sig[j]) + ".class");
                    if (j + 1 >= sig.length) continue;
                    this.out.print(", ");
                }
                this.out.println("});");
            }
            this.ctrl.unindent();
            this.out.println("}");
            this.out.print("catch (java.lang.NoSuchMethodException e) {");
            this.ctrl.indent();
            if (this.need11Stubs) {
                this.out.print("useNewInvoke = false;");
            } else {
                this.out.print("throw new java.lang.NoSuchMethodError(\"stub class initialization failed\");");
            }
            this.ctrl.unindent();
            this.out.print("}");
            this.ctrl.unindent();
            this.out.println("}");
            this.out.println();
        }
        if (this.need11Stubs) {
            this.out.print("public " + stubclassname + "() {");
            this.ctrl.indent();
            this.out.print("super();");
            this.ctrl.unindent();
            this.out.println("}");
        }
        if (this.need12Stubs) {
            this.out.print("public " + stubclassname + "(java.rmi.server.RemoteRef ref) {");
            this.ctrl.indent();
            this.out.print("super(ref);");
            this.ctrl.unindent();
            this.out.println("}");
        }
        for (int i = 0; i < this.remotemethods.length; ++i) {
            int j2;
            m = this.remotemethods[i].meth;
            sig = m.getParameterTypes();
            Class returntype = m.getReturnType();
            Class[] except = this.sortExceptions(m.getExceptionTypes());
            this.out.println();
            this.out.print("public " + RMIC.getPrettyName(returntype) + " " + m.getName() + "(");
            for (j2 = 0; j2 < sig.length; ++j2) {
                this.out.print(RMIC.getPrettyName(sig[j2]));
                this.out.print(" $param_" + j2);
                if (j2 + 1 >= sig.length) continue;
                this.out.print(", ");
            }
            this.out.print(") ");
            this.out.print("throws ");
            for (j2 = 0; j2 < except.length; ++j2) {
                this.out.print(RMIC.getPrettyName(except[j2]));
                if (j2 + 1 >= except.length) continue;
                this.out.print(", ");
            }
            this.out.print(" {");
            this.ctrl.indent();
            this.out.print("try {");
            this.ctrl.indent();
            if (this.need12Stubs) {
                if (this.need11Stubs) {
                    this.out.print("if (useNewInvoke) {");
                    this.ctrl.indent();
                }
                if (returntype != Void.TYPE) {
                    this.out.print("java.lang.Object $result = ");
                }
                this.out.print("ref.invoke(this, $method_" + m.getName() + "_" + i + ", ");
                if (sig.length == 0) {
                    this.out.print("null, ");
                } else {
                    this.out.print("new java.lang.Object[] {");
                    for (j2 = 0; j2 < sig.length; ++j2) {
                        if (sig[j2] == Boolean.TYPE) {
                            this.out.print("new java.lang.Boolean($param_" + j2 + ")");
                        } else if (sig[j2] == Byte.TYPE) {
                            this.out.print("new java.lang.Byte($param_" + j2 + ")");
                        } else if (sig[j2] == Character.TYPE) {
                            this.out.print("new java.lang.Character($param_" + j2 + ")");
                        } else if (sig[j2] == Short.TYPE) {
                            this.out.print("new java.lang.Short($param_" + j2 + ")");
                        } else if (sig[j2] == Integer.TYPE) {
                            this.out.print("new java.lang.Integer($param_" + j2 + ")");
                        } else if (sig[j2] == Long.TYPE) {
                            this.out.print("new java.lang.Long($param_" + j2 + ")");
                        } else if (sig[j2] == Float.TYPE) {
                            this.out.print("new java.lang.Float($param_" + j2 + ")");
                        } else if (sig[j2] == Double.TYPE) {
                            this.out.print("new java.lang.Double($param_" + j2 + ")");
                        } else {
                            this.out.print("$param_" + j2);
                        }
                        if (j2 + 1 >= sig.length) continue;
                        this.out.print(", ");
                    }
                    this.out.print("}, ");
                }
                this.out.print(Long.toString(this.remotemethods[i].hash) + "L");
                this.out.print(");");
                if (returntype != Void.TYPE) {
                    this.out.println();
                    this.out.print("return (");
                    if (returntype == Boolean.TYPE) {
                        this.out.print("((java.lang.Boolean)$result).booleanValue()");
                    } else if (returntype == Byte.TYPE) {
                        this.out.print("((java.lang.Byte)$result).byteValue()");
                    } else if (returntype == Character.TYPE) {
                        this.out.print("((java.lang.Character)$result).charValue()");
                    } else if (returntype == Short.TYPE) {
                        this.out.print("((java.lang.Short)$result).shortValue()");
                    } else if (returntype == Integer.TYPE) {
                        this.out.print("((java.lang.Integer)$result).intValue()");
                    } else if (returntype == Long.TYPE) {
                        this.out.print("((java.lang.Long)$result).longValue()");
                    } else if (returntype == Float.TYPE) {
                        this.out.print("((java.lang.Float)$result).floatValue()");
                    } else if (returntype == Double.TYPE) {
                        this.out.print("((java.lang.Double)$result).doubleValue()");
                    } else {
                        this.out.print("(" + RMIC.getPrettyName(returntype) + ")$result");
                    }
                    this.out.print(");");
                }
                if (this.need11Stubs) {
                    this.ctrl.unindent();
                    this.out.println("}");
                    this.out.print("else {");
                    this.ctrl.indent();
                }
            }
            if (this.need11Stubs) {
                this.out.println("java.rmi.server.RemoteCall call = ref.newCall((java.rmi.server.RemoteObject)this, operations, " + i + ", interfaceHash);");
                this.out.print("try {");
                this.ctrl.indent();
                this.out.print("java.io.ObjectOutput out = call.getOutputStream();");
                for (j2 = 0; j2 < sig.length; ++j2) {
                    this.out.println();
                    if (sig[j2] == Boolean.TYPE) {
                        this.out.print("out.writeBoolean(");
                    } else if (sig[j2] == Byte.TYPE) {
                        this.out.print("out.writeByte(");
                    } else if (sig[j2] == Character.TYPE) {
                        this.out.print("out.writeChar(");
                    } else if (sig[j2] == Short.TYPE) {
                        this.out.print("out.writeShort(");
                    } else if (sig[j2] == Integer.TYPE) {
                        this.out.print("out.writeInt(");
                    } else if (sig[j2] == Long.TYPE) {
                        this.out.print("out.writeLong(");
                    } else if (sig[j2] == Float.TYPE) {
                        this.out.print("out.writeFloat(");
                    } else if (sig[j2] == Double.TYPE) {
                        this.out.print("out.writeDouble(");
                    } else {
                        this.out.print("out.writeObject(");
                    }
                    this.out.print("$param_" + j2 + ");");
                }
                this.ctrl.unindent();
                this.out.println("}");
                this.out.print("catch (java.io.IOException e) {");
                this.ctrl.indent();
                this.out.print("throw new java.rmi.MarshalException(\"error marshalling arguments\", e);");
                this.ctrl.unindent();
                this.out.println("}");
                this.out.println("ref.invoke(call);");
                if (returntype != Void.TYPE) {
                    this.out.println(RMIC.getPrettyName(returntype) + " $result;");
                }
                this.out.print("try {");
                this.ctrl.indent();
                this.out.print("java.io.ObjectInput in = call.getInputStream();");
                boolean needcastcheck = false;
                if (returntype != Void.TYPE) {
                    this.out.println();
                    this.out.print("$result = ");
                    if (returntype == Boolean.TYPE) {
                        this.out.print("in.readBoolean();");
                    } else if (returntype == Byte.TYPE) {
                        this.out.print("in.readByte();");
                    } else if (returntype == Character.TYPE) {
                        this.out.print("in.readChar();");
                    } else if (returntype == Short.TYPE) {
                        this.out.print("in.readShort();");
                    } else if (returntype == Integer.TYPE) {
                        this.out.print("in.readInt();");
                    } else if (returntype == Long.TYPE) {
                        this.out.print("in.readLong();");
                    } else if (returntype == Float.TYPE) {
                        this.out.print("in.readFloat();");
                    } else if (returntype == Double.TYPE) {
                        this.out.print("in.readDouble();");
                    } else {
                        if (returntype != RMIC.class$("java.lang.Object")) {
                            this.out.print("(" + RMIC.getPrettyName(returntype) + ")");
                        } else {
                            needcastcheck = true;
                        }
                        this.out.print("in.readObject();");
                    }
                    this.out.println();
                    this.out.print("return ($result);");
                }
                this.ctrl.unindent();
                this.out.println("}");
                this.out.print("catch (java.io.IOException e) {");
                this.ctrl.indent();
                this.out.print("throw new java.rmi.UnmarshalException(\"error unmarshalling return\", e);");
                this.ctrl.unindent();
                this.out.println("}");
                if (needcastcheck) {
                    this.out.print("catch (java.lang.ClassNotFoundException e) {");
                    this.ctrl.indent();
                    this.out.print("throw new java.rmi.UnmarshalException(\"error unmarshalling return\", e);");
                    this.ctrl.unindent();
                    this.out.println("}");
                }
                this.out.print("finally {");
                this.ctrl.indent();
                this.out.print("ref.done(call);");
                this.ctrl.unindent();
                this.out.print("}");
                if (this.need12Stubs && this.need11Stubs) {
                    this.ctrl.unindent();
                    this.out.print("}");
                }
            }
            this.ctrl.unindent();
            this.out.print("}");
            boolean needgeneral = true;
            for (int j3 = 0; j3 < except.length; ++j3) {
                this.out.println();
                this.out.print("catch (" + RMIC.getPrettyName(except[j3]) + " e) {");
                this.ctrl.indent();
                this.out.print("throw e;");
                this.ctrl.unindent();
                this.out.print("}");
                if (except[j3] != RMIC.class$("java.lang.Exception")) continue;
                needgeneral = false;
            }
            if (needgeneral) {
                this.out.println();
                this.out.print("catch (java.lang.Exception e) {");
                this.ctrl.indent();
                this.out.print("throw new java.rmi.UnexpectedException(\"undeclared checked exception\", e);");
                this.ctrl.unindent();
                this.out.print("}");
            }
            this.ctrl.unindent();
            this.out.print("}");
            this.out.println();
        }
        this.ctrl.unindent();
        this.out.println("}");
        this.out.close();
    }

    private void generateSkel() throws IOException {
        int j;
        Class[] sig;
        Method m;
        int i;
        this.skelname = this.fullclassname + "_Skel";
        String skelclassname = this.classname + "_Skel";
        this.ctrl = new TabbedWriter(new FileWriter((this.destination == null ? "" : this.destination + File.separator) + this.skelname.replace('.', File.separatorChar) + ".java"));
        this.out = new PrintWriter(this.ctrl);
        if (this.verbose) {
            System.out.println("[Generating class " + this.skelname + ".java]");
        }
        this.out.println("// Skel class generated by rmic - DO NOT EDIT!");
        this.out.println();
        if (this.fullclassname != this.classname) {
            String pname = this.fullclassname.substring(0, this.fullclassname.lastIndexOf(46));
            this.out.println("package " + pname + ";");
            this.out.println();
        }
        this.out.print("public final class " + skelclassname);
        this.ctrl.indent();
        this.out.print("implements java.rmi.server.Skeleton");
        this.ctrl.unindent();
        this.out.print("{");
        this.ctrl.indent();
        this.out.println("private static final long interfaceHash = " + RMIHashes.getInterfaceHash(this.clazz) + "L;");
        this.out.println();
        this.out.print("private static final java.rmi.server.Operation[] operations = {");
        this.ctrl.indent();
        for (i = 0; i < this.remotemethods.length; ++i) {
            m = this.remotemethods[i].meth;
            this.out.print("new java.rmi.server.Operation(\"");
            this.out.print(RMIC.getPrettyName(m.getReturnType()) + " ");
            this.out.print(m.getName() + "(");
            sig = m.getParameterTypes();
            for (j = 0; j < sig.length; ++j) {
                this.out.print(RMIC.getPrettyName(sig[j]));
                if (j + 1 >= sig.length) continue;
                this.out.print(", ");
            }
            this.out.print("\")");
            if (i + 1 >= this.remotemethods.length) continue;
            this.out.println(",");
        }
        this.ctrl.unindent();
        this.out.println("};");
        this.out.println();
        this.out.print("public java.rmi.server.Operation[] getOperations() {");
        this.ctrl.indent();
        this.out.print("return ((java.rmi.server.Operation[]) operations.clone());");
        this.ctrl.unindent();
        this.out.println("}");
        this.out.println();
        this.out.print("public void dispatch(java.rmi.Remote obj, java.rmi.server.RemoteCall call, int opnum, long hash) throws java.lang.Exception {");
        this.ctrl.indent();
        this.out.print("if (opnum < 0) {");
        this.ctrl.indent();
        for (i = 0; i < this.remotemethods.length; ++i) {
            this.out.print("if (hash == " + Long.toString(this.remotemethods[i].hash) + "L) {");
            this.ctrl.indent();
            this.out.print("opnum = " + i + ";");
            this.ctrl.unindent();
            this.out.println("}");
            this.out.print("else ");
        }
        this.out.print("{");
        this.ctrl.indent();
        this.out.print("throw new java.rmi.server.SkeletonMismatchException(\"interface hash mismatch\");");
        this.ctrl.unindent();
        this.out.print("}");
        this.ctrl.unindent();
        this.out.println("}");
        this.out.print("else if (hash != interfaceHash) {");
        this.ctrl.indent();
        this.out.print("throw new java.rmi.server.SkeletonMismatchException(\"interface hash mismatch\");");
        this.ctrl.unindent();
        this.out.println("}");
        this.out.println();
        this.out.println(this.fullclassname + " server = (" + this.fullclassname + ")obj;");
        this.out.println("switch (opnum) {");
        for (i = 0; i < this.remotemethods.length; ++i) {
            m = this.remotemethods[i].meth;
            this.out.println("case " + i + ":");
            this.out.print("{");
            this.ctrl.indent();
            sig = m.getParameterTypes();
            for (j = 0; j < sig.length; ++j) {
                this.out.print(RMIC.getPrettyName(sig[j]));
                this.out.println(" $param_" + j + ";");
            }
            this.out.print("try {");
            boolean needcastcheck = false;
            this.ctrl.indent();
            this.out.println("java.io.ObjectInput in = call.getInputStream();");
            for (int j2 = 0; j2 < sig.length; ++j2) {
                this.out.print("$param_" + j2 + " = ");
                if (sig[j2] == Boolean.TYPE) {
                    this.out.print("in.readBoolean();");
                } else if (sig[j2] == Byte.TYPE) {
                    this.out.print("in.readByte();");
                } else if (sig[j2] == Character.TYPE) {
                    this.out.print("in.readChar();");
                } else if (sig[j2] == Short.TYPE) {
                    this.out.print("in.readShort();");
                } else if (sig[j2] == Integer.TYPE) {
                    this.out.print("in.readInt();");
                } else if (sig[j2] == Long.TYPE) {
                    this.out.print("in.readLong();");
                } else if (sig[j2] == Float.TYPE) {
                    this.out.print("in.readFloat();");
                } else if (sig[j2] == Double.TYPE) {
                    this.out.print("in.readDouble();");
                } else {
                    if (sig[j2] != RMIC.class$("java.lang.Object")) {
                        this.out.print("(" + RMIC.getPrettyName(sig[j2]) + ")");
                        needcastcheck = true;
                    }
                    this.out.print("in.readObject();");
                }
                this.out.println();
            }
            this.ctrl.unindent();
            this.out.println("}");
            this.out.print("catch (java.io.IOException e) {");
            this.ctrl.indent();
            this.out.print("throw new java.rmi.UnmarshalException(\"error unmarshalling arguments\", e);");
            this.ctrl.unindent();
            this.out.println("}");
            if (needcastcheck) {
                this.out.print("catch (java.lang.ClassCastException e) {");
                this.ctrl.indent();
                this.out.print("throw new java.rmi.UnmarshalException(\"error unmarshalling arguments\", e);");
                this.ctrl.unindent();
                this.out.println("}");
            }
            this.out.print("finally {");
            this.ctrl.indent();
            this.out.print("call.releaseInputStream();");
            this.ctrl.unindent();
            this.out.println("}");
            Class returntype = m.getReturnType();
            if (returntype != Void.TYPE) {
                this.out.print(RMIC.getPrettyName(returntype) + " $result = ");
            }
            this.out.print("server." + m.getName() + "(");
            for (int j3 = 0; j3 < sig.length; ++j3) {
                this.out.print("$param_" + j3);
                if (j3 + 1 >= sig.length) continue;
                this.out.print(", ");
            }
            this.out.println(");");
            this.out.print("try {");
            this.ctrl.indent();
            this.out.print("java.io.ObjectOutput out = call.getResultStream(true);");
            if (returntype != Void.TYPE) {
                this.out.println();
                if (returntype == Boolean.TYPE) {
                    this.out.print("out.writeBoolean($result);");
                } else if (returntype == Byte.TYPE) {
                    this.out.print("out.writeByte($result);");
                } else if (returntype == Character.TYPE) {
                    this.out.print("out.writeChar($result);");
                } else if (returntype == Short.TYPE) {
                    this.out.print("out.writeShort($result);");
                } else if (returntype == Integer.TYPE) {
                    this.out.print("out.writeInt($result);");
                } else if (returntype == Long.TYPE) {
                    this.out.print("out.writeLong($result);");
                } else if (returntype == Float.TYPE) {
                    this.out.print("out.writeFloat($result);");
                } else if (returntype == Double.TYPE) {
                    this.out.print("out.writeDouble($result);");
                } else {
                    this.out.print("out.writeObject($result);");
                }
            }
            this.ctrl.unindent();
            this.out.println("}");
            this.out.print("catch (java.io.IOException e) {");
            this.ctrl.indent();
            this.out.print("throw new java.rmi.MarshalException(\"error marshalling return\", e);");
            this.ctrl.unindent();
            this.out.println("}");
            this.out.print("break;");
            this.ctrl.unindent();
            this.out.println("}");
            this.out.println();
        }
        this.out.print("default:");
        this.ctrl.indent();
        this.out.print("throw new java.rmi.UnmarshalException(\"invalid method number\");");
        this.ctrl.unindent();
        this.out.print("}");
        this.ctrl.unindent();
        this.out.print("}");
        this.ctrl.unindent();
        this.out.println("}");
        this.out.close();
    }

    private void compile(String name) throws Exception {
        Compiler comp = Compiler.getInstance();
        if (this.verbose) {
            System.out.println("[Compiling class " + name + "]");
        }
        comp.setDestination(this.destination);
        comp.compile(name);
    }

    private static String getPrettyName(Class cls) {
        StringBuffer str = new StringBuffer();
        int count = 0;
        while (true) {
            if (!cls.isArray()) {
                str.append(cls.getName());
                while (count > 0) {
                    str.append("[]");
                    --count;
                }
                return str.toString();
            }
            cls = cls.getComponentType();
            ++count;
        }
    }

    private Class[] sortExceptions(Class[] except) {
        for (int i = 0; i < except.length; ++i) {
            for (int j = i + 1; j < except.length; ++j) {
                if (!except[i].isAssignableFrom(except[j])) continue;
                Class tmp = except[i];
                except[i] = except[j];
                except[j] = tmp;
            }
        }
        return except;
    }

    private void parseOptions() {
        while (this.next < this.args.length && this.args[this.next].charAt(0) == '-') {
            String arg = this.args[this.next];
            ++this.next;
            if (arg.length() > 3 && arg.charAt(0) == '-' && arg.charAt(1) == '-') {
                arg = arg.substring(1);
            }
            if (arg.equals("-keep")) {
                this.keep = true;
                continue;
            }
            if (arg.equals("-keepgenerated")) {
                this.keep = true;
                continue;
            }
            if (arg.equals("-v1.1")) {
                this.need11Stubs = true;
                this.need12Stubs = false;
                continue;
            }
            if (arg.equals("-vcompat")) {
                this.need11Stubs = true;
                this.need12Stubs = true;
                continue;
            }
            if (arg.equals("-v1.2")) {
                this.need11Stubs = false;
                this.need12Stubs = true;
                continue;
            }
            if (arg.equals("-g") || arg.equals("-depend") || arg.equals("-nowarn")) continue;
            if (arg.equals("-verbose")) {
                this.verbose = true;
                continue;
            }
            if (arg.equals("-nocompile")) {
                this.compile = false;
                continue;
            }
            if (arg.equals("-classpath")) {
                ++this.next;
                continue;
            }
            if (arg.equals("-help")) {
                RMIC.usage();
                continue;
            }
            if (arg.equals("-version")) {
                System.out.println("rmic (" + System.getProperty("java.vm.name") + ") " + System.getProperty("java.vm.version"));
                System.out.println();
                System.out.println("Copyright 2002 Free Software Foundation, Inc.");
                System.out.println("This is free software; see the source for copying conditions.  There is NO");
                System.out.println("warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.");
                System.exit(0);
                continue;
            }
            if (arg.equals("-d")) {
                this.destination = this.args[this.next];
                ++this.next;
                continue;
            }
            if (arg.charAt(1) == 'J') continue;
            RMIC.error("unrecognized option `" + arg + "'");
        }
    }

    private Class getRemoteInterface(Class theClazz) {
        Class[] interfaces = theClazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!RMIC.class$("java.rmi.Remote").isAssignableFrom(interfaces[i])) continue;
            return interfaces[i];
        }
        this.logError("Class " + theClazz.getName() + " is not a remote object. It does not implement an interface that is a java.rmi.Remote-interface.");
        return null;
    }

    private void logError(String theError) {
        ++this.errorCount;
        System.err.println("error:" + theError);
    }

    private static void error(String message) {
        System.err.println("rmic: " + message);
        System.err.println("Try `rmic --help' for more information.");
        System.exit(1);
    }

    private static void usage() {
        System.out.println("Usage: rmic [OPTION]... CLASS...\n\n\t-keep \t\t\tDon't delete any intermediate files\n\t-keepgenerated \t\tSame as -keep\n\t-v1.1\t\t\tJava 1.1 style stubs only\n\t-vcompat\t\tJava 1.1 & Java 1.2 stubs\n\t-v1.2\t\t\tJava 1.2 style stubs only\n\t-g *\t\t\tGenerated debugging information\n\t-depend *\t\tRecompile out-of-date files\n\t-nowarn\t*\t\tSuppress warning messages\n\t-nocompile\t\tDon't compile the generated files\n\t-verbose \t\tOutput what's going on\n\t-classpath <path> *\tUse given path as classpath\n\t-d <directory> \t\tSpecify where to place generated classes\n\t-J<flag> *\t\tPass flag to Java\n\t-help\t\t\tPrint this help, then exit\n\t-version\t\tPrint version number, then exit\n\n  * Option currently ignored\nLong options can be used with `--option' form as well.");
        System.exit(0);
    }

    static class MethodRef
    implements Comparable {
        Method meth;
        String sig;
        long hash;

        MethodRef(Method m) {
            this.meth = m;
            this.sig = m.getName();
            this.hash = RMIHashes.getMethodHash(m);
        }

        public int compareTo(Object obj) {
            MethodRef that = (MethodRef)obj;
            return this.sig.compareTo(that.sig);
        }
    }
}

