/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.ReadOnlyBufferException;

final class DoubleBufferImpl
extends DoubleBuffer {
    private boolean readOnly;

    DoubleBufferImpl(int capacity) {
        this(new double[capacity], 0, capacity, capacity, 0, -1, false);
    }

    DoubleBufferImpl(double[] buffer, int offset, int capacity, int limit, int position, int mark, boolean readOnly) {
        super(buffer, offset, capacity, limit, position, mark);
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public DoubleBuffer slice() {
        return new DoubleBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    public DoubleBuffer duplicate() {
        return new DoubleBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    public DoubleBuffer asReadOnlyBuffer() {
        return new DoubleBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    public DoubleBuffer compact() {
        int copied = 0;
        while (this.remaining() > 0) {
            this.put(copied, this.get());
            ++copied;
        }
        this.position(copied);
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public final double get() {
        double result = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return result;
    }

    public final DoubleBuffer put(double value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[this.position()] = value;
        this.position(this.position() + 1);
        return this;
    }

    public final double get(int index) {
        return this.backing_buffer[index];
    }

    public final DoubleBuffer put(int index, double value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[index] = value;
        return this;
    }

    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

