/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import gnu.java.text.CharacterBreakIterator;
import gnu.java.text.LineBreakIterator;
import gnu.java.text.SentenceBreakIterator;
import gnu.java.text.WordBreakIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class BreakIterator
implements Cloneable {
    public static final int DONE = -1;

    protected BreakIterator() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public abstract int current();

    public abstract int first();

    public abstract int following(int var1);

    public static synchronized Locale[] getAvailableLocales() {
        Locale[] l = new Locale[]{Locale.US};
        return l;
    }

    private static BreakIterator getInstance(String type, Locale loc) {
        String className;
        try {
            ResourceBundle res = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", loc);
            className = res.getString(type);
        }
        catch (MissingResourceException x) {
            return null;
        }
        try {
            Class k = Class.forName(className);
            return (BreakIterator)k.newInstance();
        }
        catch (ClassNotFoundException x1) {
            return null;
        }
        catch (InstantiationException x2) {
            return null;
        }
        catch (IllegalAccessException x3) {
            return null;
        }
    }

    public static BreakIterator getCharacterInstance() {
        return BreakIterator.getCharacterInstance(Locale.getDefault());
    }

    public static BreakIterator getCharacterInstance(Locale loc) {
        BreakIterator r = BreakIterator.getInstance("CharacterIterator", loc);
        if (r == null) {
            r = new CharacterBreakIterator();
        }
        return r;
    }

    public static BreakIterator getLineInstance() {
        return BreakIterator.getLineInstance(Locale.getDefault());
    }

    public static BreakIterator getLineInstance(Locale loc) {
        BreakIterator r = BreakIterator.getInstance("LineIterator", loc);
        if (r == null) {
            r = new LineBreakIterator();
        }
        return r;
    }

    public static BreakIterator getSentenceInstance() {
        return BreakIterator.getSentenceInstance(Locale.getDefault());
    }

    public static BreakIterator getSentenceInstance(Locale loc) {
        BreakIterator r = BreakIterator.getInstance("SentenceIterator", loc);
        if (r == null) {
            r = new SentenceBreakIterator();
        }
        return r;
    }

    public abstract CharacterIterator getText();

    public static BreakIterator getWordInstance() {
        return BreakIterator.getWordInstance(Locale.getDefault());
    }

    public static BreakIterator getWordInstance(Locale loc) {
        BreakIterator r = BreakIterator.getInstance("WordIterator", loc);
        if (r == null) {
            r = new WordBreakIterator();
        }
        return r;
    }

    public boolean isBoundary(int pos) {
        if (pos == 0) {
            return true;
        }
        return this.following(pos - 1) == pos;
    }

    public abstract int last();

    public abstract int next();

    public abstract int next(int var1);

    public int preceding(int pos) {
        if (this.following(pos) == -1) {
            this.last();
        }
        while (this.previous() >= pos) {
        }
        return this.current();
    }

    public abstract int previous();

    public void setText(String newText) {
        this.setText(new StringCharacterIterator(newText));
    }

    public abstract void setText(CharacterIterator var1);
}

