#!/bin/sh

test_description='basic clone options'
. ./test-lib.sh

test_expect_success 'setup' '

	mkdir parent &&
	(cd parent && git init &&
	 echo one >file && git add file &&
	 git commit -m one)

'

test_expect_success 'clone -o' '

	git clone -o foo parent clone-o &&
	(cd clone-o && git rev-parse --verify refs/remotes/foo/master)

'

test_expect_success 'redirected clone' '

	git clone "file://$(pwd)/parent" clone-redirected >out 2>err &&
	test ! -s err

'
test_expect_success 'redirected clone -v' '

	git clone -v "file://$(pwd)/parent" clone-redirected-v >out 2>err &&
	test -s err

'

test_done
