/*
 * Copyright (c) 2003 Olivier Fourdan <fourdan@xfce.org>
 * Copyright (c) 2003 Benedikt Meurer <benedikt.meurer@unix-ag.uni-siegen.de>
 * All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Copyright © 2001 Red Hat, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Red Hat not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Red Hat makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * RED HAT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL RED HAT
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Owen Taylor, Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include <glib.h>

#include "mcs-channel.h"
#include "mcs-common.h"

McsChannel *
_mcs_channel_new (const gchar *name, 
                  Display     *dpy)
{
    McsChannel *channel;
    gchar *buffer;

    g_return_val_if_fail (name != NULL, NULL);

    if ((channel = g_new (McsChannel, 1)) == NULL)
        return (NULL);

    if ((channel->channel_name = g_ascii_strup (name, strlen (name))) == NULL)
    {
        g_free (channel);
        return (NULL);
    }

    buffer = g_strdup_printf ("_XSETTINGS_%s", channel->channel_name);
    channel->channel_atom = XInternAtom (dpy, buffer, FALSE);
    channel->settings = NULL;
    channel->ref_count = 1;
    channel->raw = FALSE;
    g_free (buffer);

    return (channel);
}

McsChannel *
_mcs_channel_lookup (McsChannelList *channels, 
                     const gchar    *name)
{
    g_return_val_if_fail (name != NULL, NULL);

    while (channels != NULL)
    {
        if (!g_ascii_strncasecmp (name, channels->channel->channel_name, strlen (name)))
            return (channels->channel);

        channels = channels->next;
    }

    return (NULL);
}

void
_mcs_channel_delete (McsChannelList **list, 
                     McsChannel      *channel)
{
    McsChannelList *channels;
    McsChannelList *previous;

    g_return_if_fail (channel != NULL);
    g_return_if_fail (list != NULL);

    channels = *list;
    previous = NULL;

    while (channels != NULL && channels->channel != channel)
    {
        previous = channels;
        channels = channels->next;
    }

    if (channels != NULL)
    {
        if (previous != NULL)
            previous->next = channels->next;
        else
            *list = channels->next;

        if (channels->channel != NULL)
        {
            mcs_list_free (channels->channel->settings);
            g_free (channels->channel->channel_name);
            g_free (channels->channel);
        }

        g_free (channels);
    }
}
