#include "librpc/gen_ndr/ndr_winreg.h"
#ifndef __CLI_WINREG__
#define __CLI_WINREG__
NTSTATUS rpccli_winreg_OpenHKCR(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				uint16_t *system_name /* [in] [unique] */,
				uint32_t access_mask /* [in]  */,
				struct policy_handle *handle /* [out] [ref] */,
				WERROR *werror);
NTSTATUS rpccli_winreg_OpenHKCU(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				uint16_t *system_name /* [in] [unique] */,
				uint32_t access_mask /* [in]  */,
				struct policy_handle *handle /* [out] [ref] */,
				WERROR *werror);
NTSTATUS rpccli_winreg_OpenHKLM(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				uint16_t *system_name /* [in] [unique] */,
				uint32_t access_mask /* [in]  */,
				struct policy_handle *handle /* [out] [ref] */,
				WERROR *werror);
NTSTATUS rpccli_winreg_OpenHKPD(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				uint16_t *system_name /* [in] [unique] */,
				uint32_t access_mask /* [in]  */,
				struct policy_handle *handle /* [out] [ref] */,
				WERROR *werror);
NTSTATUS rpccli_winreg_OpenHKU(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       uint16_t *system_name /* [in] [unique] */,
			       uint32_t access_mask /* [in]  */,
			       struct policy_handle *handle /* [out] [ref] */,
			       WERROR *werror);
NTSTATUS rpccli_winreg_CloseKey(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *handle /* [in,out] [ref] */,
				WERROR *werror);
NTSTATUS rpccli_winreg_CreateKey(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *handle /* [in] [ref] */,
				 struct winreg_String name /* [in]  */,
				 struct winreg_String keyclass /* [in]  */,
				 uint32_t options /* [in]  */,
				 uint32_t access_mask /* [in]  */,
				 struct winreg_SecBuf *secdesc /* [in] [unique] */,
				 struct policy_handle *new_handle /* [out] [ref] */,
				 enum winreg_CreateAction *action_taken /* [in,out] [unique] */,
				 WERROR *werror);
NTSTATUS rpccli_winreg_DeleteKey(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *handle /* [in] [ref] */,
				 struct winreg_String key /* [in]  */,
				 WERROR *werror);
NTSTATUS rpccli_winreg_DeleteValue(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *handle /* [in] [ref] */,
				   struct winreg_String value /* [in]  */,
				   WERROR *werror);
NTSTATUS rpccli_winreg_EnumKey(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *handle /* [in] [ref] */,
			       uint32_t enum_index /* [in]  */,
			       struct winreg_StringBuf *name /* [in,out] [ref] */,
			       struct winreg_StringBuf *keyclass /* [in,out] [unique] */,
			       NTTIME *last_changed_time /* [in,out] [unique] */,
			       WERROR *werror);
NTSTATUS rpccli_winreg_EnumValue(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *handle /* [in] [ref] */,
				 uint32_t enum_index /* [in]  */,
				 struct winreg_ValNameBuf *name /* [in,out] [ref] */,
				 enum winreg_Type *type /* [in,out] [unique] */,
				 uint8_t *value /* [in,out] [unique,length_is(*length),size_is(*size)] */,
				 uint32_t *size /* [in,out] [unique] */,
				 uint32_t *length /* [in,out] [unique] */,
				 WERROR *werror);
NTSTATUS rpccli_winreg_FlushKey(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *handle /* [in] [ref] */,
				WERROR *werror);
NTSTATUS rpccli_winreg_GetKeySecurity(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *handle /* [in] [ref] */,
				      uint32_t sec_info /* [in]  */,
				      struct KeySecurityData *sd /* [in,out] [ref] */,
				      WERROR *werror);
NTSTATUS rpccli_winreg_LoadKey(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *handle /* [in] [ref] */,
			       struct winreg_String *keyname /* [in] [unique] */,
			       struct winreg_String *filename /* [in] [unique] */,
			       WERROR *werror);
NTSTATUS rpccli_winreg_NotifyChangeKeyValue(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *handle /* [in] [ref] */,
					    uint8_t watch_subtree /* [in]  */,
					    uint32_t notify_filter /* [in]  */,
					    uint32_t unknown /* [in]  */,
					    struct winreg_String string1 /* [in]  */,
					    struct winreg_String string2 /* [in]  */,
					    uint32_t unknown2 /* [in]  */,
					    WERROR *werror);
NTSTATUS rpccli_winreg_OpenKey(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *parent_handle /* [in] [ref] */,
			       struct winreg_String keyname /* [in]  */,
			       uint32_t unknown /* [in]  */,
			       uint32_t access_mask /* [in]  */,
			       struct policy_handle *handle /* [out] [ref] */,
			       WERROR *werror);
NTSTATUS rpccli_winreg_QueryInfoKey(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *handle /* [in] [ref] */,
				    struct winreg_String *classname /* [in,out] [ref] */,
				    uint32_t *num_subkeys /* [out] [ref] */,
				    uint32_t *max_subkeylen /* [out] [ref] */,
				    uint32_t *max_classlen /* [out] [ref] */,
				    uint32_t *num_values /* [out] [ref] */,
				    uint32_t *max_valnamelen /* [out] [ref] */,
				    uint32_t *max_valbufsize /* [out] [ref] */,
				    uint32_t *secdescsize /* [out] [ref] */,
				    NTTIME *last_changed_time /* [out] [ref] */,
				    WERROR *werror);
NTSTATUS rpccli_winreg_QueryValue(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *handle /* [in] [ref] */,
				  struct winreg_String *value_name /* [in] [ref] */,
				  enum winreg_Type *type /* [in,out] [unique] */,
				  uint8_t *data /* [in,out] [unique,length_is(*value_length),size_is(*data_size)] */,
				  uint32_t *data_size /* [in,out] [unique] */,
				  uint32_t *value_length /* [in,out] [unique] */,
				  WERROR *werror);
NTSTATUS rpccli_winreg_ReplaceKey(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  WERROR *werror);
NTSTATUS rpccli_winreg_RestoreKey(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *handle /* [in] [ref] */,
				  struct winreg_String *filename /* [in] [ref] */,
				  uint32_t flags /* [in]  */,
				  WERROR *werror);
NTSTATUS rpccli_winreg_SaveKey(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *handle /* [in] [ref] */,
			       struct winreg_String *filename /* [in] [ref] */,
			       struct KeySecurityAttribute *sec_attrib /* [in] [unique] */,
			       WERROR *werror);
NTSTATUS rpccli_winreg_SetKeySecurity(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *handle /* [in] [ref] */,
				      uint32_t access_mask /* [in]  */,
				      struct KeySecurityData *sd /* [in] [ref] */,
				      WERROR *werror);
NTSTATUS rpccli_winreg_SetValue(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *handle /* [in] [ref] */,
				struct winreg_String name /* [in]  */,
				enum winreg_Type type /* [in]  */,
				uint8_t *data /* [in] [ref,size_is(size)] */,
				uint32_t size /* [in]  */,
				WERROR *werror);
NTSTATUS rpccli_winreg_UnLoadKey(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 WERROR *werror);
NTSTATUS rpccli_winreg_InitiateSystemShutdown(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      uint16_t *hostname /* [in] [unique] */,
					      struct initshutdown_String *message /* [in] [unique] */,
					      uint32_t timeout /* [in]  */,
					      uint8_t force_apps /* [in]  */,
					      uint8_t reboot /* [in]  */,
					      WERROR *werror);
NTSTATUS rpccli_winreg_AbortSystemShutdown(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   uint16_t *server /* [in] [unique] */,
					   WERROR *werror);
NTSTATUS rpccli_winreg_GetVersion(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *handle /* [in] [ref] */,
				  uint32_t *version /* [out] [ref] */,
				  WERROR *werror);
NTSTATUS rpccli_winreg_OpenHKCC(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				uint16_t *system_name /* [in] [unique] */,
				uint32_t access_mask /* [in]  */,
				struct policy_handle *handle /* [out] [ref] */,
				WERROR *werror);
NTSTATUS rpccli_winreg_OpenHKDD(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				uint16_t *system_name /* [in] [unique] */,
				uint32_t access_mask /* [in]  */,
				struct policy_handle *handle /* [out] [ref] */,
				WERROR *werror);
NTSTATUS rpccli_winreg_QueryMultipleValues(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *key_handle /* [in] [ref] */,
					   struct QueryMultipleValue *values /* [in,out] [ref,length_is(num_values),size_is(num_values)] */,
					   uint32_t num_values /* [in]  */,
					   uint8_t *buffer /* [in,out] [unique,length_is(*buffer_size),size_is(*buffer_size)] */,
					   uint32_t *buffer_size /* [in,out] [ref] */,
					   WERROR *werror);
NTSTATUS rpccli_winreg_InitiateSystemShutdownEx(struct rpc_pipe_client *cli,
						TALLOC_CTX *mem_ctx,
						uint16_t *hostname /* [in] [unique] */,
						struct initshutdown_String *message /* [in] [unique] */,
						uint32_t timeout /* [in]  */,
						uint8_t force_apps /* [in]  */,
						uint8_t reboot /* [in]  */,
						uint32_t reason /* [in]  */,
						WERROR *werror);
NTSTATUS rpccli_winreg_SaveKeyEx(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 WERROR *werror);
NTSTATUS rpccli_winreg_OpenHKPT(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				uint16_t *system_name /* [in] [unique] */,
				uint32_t access_mask /* [in]  */,
				struct policy_handle *handle /* [out] [ref] */,
				WERROR *werror);
NTSTATUS rpccli_winreg_OpenHKPN(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				uint16_t *system_name /* [in] [unique] */,
				uint32_t access_mask /* [in]  */,
				struct policy_handle *handle /* [out] [ref] */,
				WERROR *werror);
NTSTATUS rpccli_winreg_QueryMultipleValues2(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    WERROR *werror);
#endif /* __CLI_WINREG__ */
