/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef nsICharRepresentable_h__
#define nsICharRepresentable_h__

#include "nscore.h"
#include "nsISupports.h"

// {A4D9A521-185A-11d3-B3BD-00805F8A6670}
#define NS_ICHARREPRESENTABLE_IID \
{ 0xa4d9a521, 0x185a, 0x11d3, { 0xb3, 0xbd, 0x0, 0x80, 0x5f, 0x8a, 0x66, 0x70 } }


/* 
   The following two macro have been duplicate in umap.c. 
   You need to change both place to make it work 
*/
#define IS_REPRESENTABLE(info, c) (((info)[(c) >> 5] >> ((c) & 0x1f)) & 1L)
#define SET_REPRESENTABLE(info, c)  (info)[(c) >> 5] |= (1L << ((c) & 0x1f))
#define CLEAR_REPRESENTABLE(info, c)  (info)[(c) >> 5] &= (~(1L << ((c) & 0x1f)))

// number of PRUint32 in the 64Kbit char map
#define UCS2_MAP_LEN 2048

/**
 */
class nsICharRepresentable : public nsISupports
{
public:
  NS_DECLARE_STATIC_IID_ACCESSOR(NS_ICHARREPRESENTABLE_IID)

  NS_IMETHOD FillInfo(PRUint32* aInfo) = 0;

};

NS_DEFINE_STATIC_IID_ACCESSOR(nsICharRepresentable, NS_ICHARREPRESENTABLE_IID)

#endif /* nsIUnicodeDecoder_h__ */
