<?xml version="1.0" encoding="utf-8"?>
<!--
  ** Author: Marco Ladermann <marco.ladermann@gmx.de>
  ** Date: Thu Sep 12 21:57:42 CEST 2002 @873 /Internet Time/
  ** 
  ** This software is free software. It is released under the terms of the
  ** GNU Lesser General Public Licence (LGPL)
  ** see http://www.gnu.org/copyleft/lesser.html
  **
  ** These stylesheets are distributed in the hope that they will be useful,
  ** but WITHOUT ANY WARRANTY; without even the implied warranty of
  ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  -->
<xsl:stylesheet 
    version="1.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:exsl="http://exslt.org/common"
    xmlns:kde="http://kde.org/functions"
>

    <!-- call user hook for string property -->
    <xsl:template match="string" mode="property">
        <xsl:param name="name"/>
        <xsl:param name="data"/>
        <xsl:call-template name="putStringProperty">
            <xsl:with-param name="property" select="$name"/>
            <xsl:with-param name="data" select="$data"/>
        </xsl:call-template>
    </xsl:template>

    <!-- call user hook for string property -->
    <xsl:template match="stringlist" mode="property">
        <xsl:param name="name"/>
        <xsl:param name="data"/>
        <xsl:call-template name="putStringlistProperty">
            <xsl:with-param name="property" select="$name"/>
            <xsl:with-param name="data" select="$data"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template match="comment" mode="property"/>

    <!-- call user hook for boolean property -->
    <xsl:template match="bool" mode="property">
        <xsl:param name="name"/>
        <xsl:param name="data"/>
        <xsl:call-template name="putBoolProperty">
            <xsl:with-param name="property" select="$name"/>
            <xsl:with-param name="data" select="$data"/>
        </xsl:call-template>
    </xsl:template>

    <!-- call user hook for a cstring property-->
    <xsl:template match="cstring" mode="property">
        <xsl:param name="name"/>
        <xsl:param name="data"/>
        <xsl:call-template name="putCstringProperty">
            <xsl:with-param name="property" select="$name"/>
            <xsl:with-param name="data" select="$data"/>
        </xsl:call-template>
    </xsl:template>

    <!-- call user hook for a color property-->
    <xsl:template match="color" mode="property">
        <xsl:param name="name"/>
        <xsl:param name="data"/>
        <xsl:call-template name="putColorProperty">
            <xsl:with-param name="property" select="$name"/>
            <xsl:with-param name="data" select="$data"/>
        </xsl:call-template>
    </xsl:template>

    <!-- call user hook for cursor value properties -->
    <xsl:template match="cursor" mode="property">
        <xsl:param name="name"/>
        <xsl:param name="data"/>
        <xsl:call-template name="putCursorProperty">
            <xsl:with-param name="property" select="$name"/>
            <xsl:with-param name="data" select="$data"/>
        </xsl:call-template>
    </xsl:template>

    <!-- call user hook for integer value properties -->
    <xsl:template match="number" mode="property">
        <xsl:param name="name"/>
        <xsl:param name="data"/>
        <xsl:call-template name="putNumberProperty">
            <xsl:with-param name="property" select="$name"/>
            <xsl:with-param name="data" select="$data"/>
        </xsl:call-template>
    </xsl:template>

    <!-- call user hook for enum value properties -->
    <xsl:template match="enum" mode="property">
        <xsl:param name="name"/>
        <xsl:param name="data"/>
        <xsl:call-template name="putEnumProperty">
            <xsl:with-param name="property" select="$name"/>
            <xsl:with-param name="data" select="$data"/>
        </xsl:call-template>
    </xsl:template>

    <!-- call user hook for pixmap value properties -->
    <xsl:template match="pixmap" mode="property">
        <xsl:param name="name"/>
        <xsl:param name="data"/>
        <xsl:call-template name="putPixmapProperty">
            <xsl:with-param name="property" select="$name"/>
            <xsl:with-param name="data" select="$data"/>
        </xsl:call-template>
    </xsl:template>

    <!-- call user hook for point value properties -->
    <xsl:template match="point" mode="property">
        <xsl:param name="data"/>
        <xsl:param name="name"/>
        <xsl:call-template name="putPointProperty">
            <xsl:with-param name="property" select="$name"/>
            <xsl:with-param name="data" select="$data"/>
        </xsl:call-template>
    </xsl:template>

    <!-- call user hook for rectangular value properties -->
    <xsl:template match="rect" mode="property">
        <xsl:param name="name"/>
        <xsl:param name="data"/>
        <xsl:call-template name="putRectProperty">
            <xsl:with-param name="property" select="$name"/>
            <xsl:with-param name="data" select="$data"/>
        </xsl:call-template>
    </xsl:template>

    <!-- call user hook for set value properties -->
    <xsl:template match="set" mode="property">
        <xsl:param name="name"/>
        <xsl:param name="data"/>
        <xsl:call-template name="putSetProperty">
            <xsl:with-param name="property" select="$name"/>
            <xsl:with-param name="data" select="$data"/>
        </xsl:call-template>
    </xsl:template>

    <!-- call user hook for size value properties -->
    <xsl:template match="size" mode="property">
        <xsl:param name="name"/>
        <xsl:param name="data"/>
        <xsl:call-template name="putSizeProperty">
            <xsl:with-param name="property" select="$name"/>
            <xsl:with-param name="data" select="$data"/>
        </xsl:call-template>
    </xsl:template>

    <!-- call user hook for sizepolicy properties -->
    <xsl:template match="sizepolicy" mode="property">
        <xsl:param name="name"/>
        <xsl:param name="data"/>
        <xsl:call-template name="putSizepolicyProperty">
            <xsl:with-param name="property" select="$name"/>
            <xsl:with-param name="data" select="$data"/>
        </xsl:call-template>
    </xsl:template>

    <!-- call user hook for font properties -->
    <xsl:template match="font" mode="property">
        <xsl:param name="name"/>
        <xsl:param name="data"/>
        <xsl:call-template name="putFontProperty">
            <xsl:with-param name="property" select="$name"/>
            <xsl:with-param name="data" select="$data"/>
        </xsl:call-template>
    </xsl:template>

    <!-- call user hook for palette properties -->
    <xsl:template match="palette" mode="property">
        <xsl:param name="name"/>
        <xsl:param name="data"/>
        <xsl:call-template name="putPaletteProperty">
            <xsl:with-param name="property" select="$name"/>
            <xsl:with-param name="data" select="$data"/>
        </xsl:call-template>
    </xsl:template>

    <!-- call user hook for iconSet properties -->
    <xsl:template match="iconset" mode="property">
        <xsl:param name="name"/>
        <xsl:param name="data"/>
        <xsl:call-template name="putIconsetProperty">
            <xsl:with-param name="property" select="$name"/>
            <xsl:with-param name="data" select="$data"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="*" mode="property">
        <xsl:message>WARNING: Unknown property type "<xsl:value-of select="name()"/>" at <xsl:value-of select="kde:printPath(.)"/></xsl:message>
    </xsl:template>
    <xsl:template match="@*|text()" mode="property"/>
</xsl:stylesheet>

