/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio;

import org.openrdf.OpenRDFException;

public class RDFParseException
extends OpenRDFException {
    private static final long serialVersionUID = -4686126837948873012L;
    private final int lineNo;
    private final int columnNo;

    public RDFParseException(String msg) {
        this(msg, -1, -1);
    }

    public RDFParseException(String msg, int lineNo, int columnNo) {
        super(msg + RDFParseException.getLocationString(lineNo, columnNo));
        this.lineNo = lineNo;
        this.columnNo = columnNo;
    }

    public RDFParseException(Throwable t) {
        this(t, -1, -1);
    }

    public RDFParseException(Throwable t, int lineNo, int columnNo) {
        super(t.getMessage() + RDFParseException.getLocationString(lineNo, columnNo), t);
        this.lineNo = lineNo;
        this.columnNo = columnNo;
    }

    public int getLineNumber() {
        return this.lineNo;
    }

    public int getColumnNumber() {
        return this.columnNo;
    }

    public static String getLocationString(int lineNo, int columnNo) {
        if (lineNo < 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(16);
        sb.append(" [line ");
        sb.append(lineNo);
        if (columnNo >= 0) {
            sb.append(", column ");
            sb.append(columnNo);
        }
        sb.append("]");
        return sb.toString();
    }
}

