//  (C) Copyright John Maddock 2006-7.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

   static const boost::array<boost::array<T, 3>, 500> erf_data = { {
      {{ SC_(-7.954905033111572265625), SC_(-0.9999999999999999999999999999768236114552), SC_(1.999999999999999999999999999976823611455) }}, 
      {{ SC_(-7.925852298736572265625), SC_(-0.9999999999999999999999999999631035087875), SC_(1.999999999999999999999999999963103508787) }}, 
      {{ SC_(-7.923464298248291015625), SC_(-0.9999999999999999999999999999616689085769), SC_(1.999999999999999999999999999961668908577) }}, 
      {{ SC_(-7.870497226715087890625), SC_(-0.999999999999999999999999999910929780403), SC_(1.999999999999999999999999999910929780403) }}, 
      {{ SC_(-7.809566974639892578125), SC_(-0.9999999999999999999999999997666672740312), SC_(1.999999999999999999999999999766667274031) }}, 
      {{ SC_(-7.78337383270263671875), SC_(-0.9999999999999999999999999996477997000614), SC_(1.999999999999999999999999999647799700061) }}, 
      {{ SC_(-7.75354480743408203125), SC_(-0.9999999999999999999999999994380404842296), SC_(1.99999999999999999999999999943804048423) }}, 
      {{ SC_(-7.735670566558837890625), SC_(-0.9999999999999999999999999992571019874276), SC_(1.999999999999999999999999999257101987428) }}, 
      {{ SC_(-7.715617656707763671875), SC_(-0.9999999999999999999999999989846832415537), SC_(1.999999999999999999999999998984683241554) }}, 
      {{ SC_(-7.7047863006591796875), SC_(-0.999999999999999999999999998798456908148), SC_(1.999999999999999999999999998798456908148) }}, 
      {{ SC_(-7.53247547149658203125), SC_(-0.9999999999999999999999999830308685738632), SC_(1.999999999999999999999999983030868573863) }}, 
      {{ SC_(-7.490674495697021484375), SC_(-0.9999999999999999999999999680283814121658), SC_(1.999999999999999999999999968028381412166) }}, 
      {{ SC_(-7.4677028656005859375), SC_(-0.9999999999999999999999999547824309252063), SC_(1.999999999999999999999999954782430925206) }}, 
      {{ SC_(-7.45092296600341796875), SC_(-0.9999999999999999999999999417916071317633), SC_(1.999999999999999999999999941791607131763) }}, 
      {{ SC_(-7.448862552642822265625), SC_(-0.999999999999999999999999939960596846754), SC_(1.999999999999999999999999939960596846754) }}, 
      {{ SC_(-7.428613185882568359375), SC_(-0.9999999999999999999999999186357837637381), SC_(1.999999999999999999999999918635783763738) }}, 
      {{ SC_(-7.41693973541259765625), SC_(-0.9999999999999999999999999030902896226869), SC_(1.999999999999999999999999903090289622687) }}, 
      {{ SC_(-7.352462291717529296875), SC_(-0.9999999999999999999999997466806221320354), SC_(1.999999999999999999999999746680622132035) }}, 
      {{ SC_(-7.32713413238525390625), SC_(-0.9999999999999999999999996313499781458314), SC_(1.999999999999999999999999631349978145831) }}, 
      {{ SC_(-7.311619281768798828125), SC_(-0.9999999999999999999999995363881484604713), SC_(1.999999999999999999999999536388148460471) }}, 
      {{ SC_(-7.279047489166259765625), SC_(-0.9999999999999999999999992510468758087201), SC_(1.99999999999999999999999925104687580872) }}, 
      {{ SC_(-7.261257648468017578125), SC_(-0.999999999999999999999999027617901396665), SC_(1.999999999999999999999999027617901396665) }}, 
      {{ SC_(-7.232891559600830078125), SC_(-0.9999999999999999999999985274747006541921), SC_(1.999999999999999999999998527474700654192) }}, 
      {{ SC_(-7.20552921295166015625), SC_(-0.9999999999999999999999978059072279635353), SC_(1.999999999999999999999997805907227963535) }}, 
      {{ SC_(-7.18053722381591796875), SC_(-0.9999999999999999999999968458614521146074), SC_(1.999999999999999999999996845861452114607) }}, 
      {{ SC_(-7.14955902099609375), SC_(-0.9999999999999999999999950624010083082766), SC_(1.999999999999999999999995062401008308277) }}, 
      {{ SC_(-7.13679790496826171875), SC_(-0.9999999999999999999999940645544114571544), SC_(1.999999999999999999999994064554411457154) }}, 
      {{ SC_(-7.043527126312255859375), SC_(-0.9999999999999999999999774337000610083234), SC_(1.999999999999999999999977433700061008323) }}, 
      {{ SC_(-6.9184741973876953125), SC_(-0.9999999999999999999998683679500951423272), SC_(1.999999999999999999999868367950095142327) }}, 
      {{ SC_(-6.7863311767578125), SC_(-0.9999999999999999999991795120414840889856), SC_(1.999999999999999999999179512041484088986) }}, 
      {{ SC_(-6.784533023834228515625), SC_(-0.9999999999999999999991590255661336519112), SC_(1.999999999999999999999159025566133651911) }}, 
      {{ SC_(-6.75908756256103515625), SC_(-0.9999999999999999999988086234364717344992), SC_(1.999999999999999999998808623436471734499) }}, 
      {{ SC_(-6.7491912841796875), SC_(-0.9999999999999999999986362669470340916908), SC_(1.999999999999999999998636266947034091691) }}, 
      {{ SC_(-6.701987743377685546875), SC_(-0.999999999999999999997409009041632256952), SC_(1.999999999999999999997409009041632256952) }}, 
      {{ SC_(-6.658857822418212890625), SC_(-0.9999999999999999999953604766205454848685), SC_(1.999999999999999999995360476620545484869) }}, 
      {{ SC_(-6.649026393890380859375), SC_(-0.9999999999999999999947043111854298902328), SC_(1.999999999999999999994704311185429890233) }}, 
      {{ SC_(-6.63174724578857421875), SC_(-0.9999999999999999999933213242713558320894), SC_(1.999999999999999999993321324271355832089) }}, 
      {{ SC_(-6.562829494476318359375), SC_(-0.9999999999999999999832486398825313868824), SC_(1.999999999999999999983248639882531386882) }}, 
      {{ SC_(-6.474317073822021484375), SC_(-0.9999999999999999999461767620323245787117), SC_(1.999999999999999999946176762032324578712) }}, 
      {{ SC_(-6.456727504730224609375), SC_(-0.9999999999999999999322505846330688168028), SC_(1.999999999999999999932250584633068816803) }}, 
      {{ SC_(-6.44589138031005859375), SC_(-0.9999999999999999999219560784452381988458), SC_(1.999999999999999999921956078445238198846) }}, 
      {{ SC_(-6.439353466033935546875), SC_(-0.9999999999999999999150123383981949772306), SC_(1.999999999999999999915012338398194977231) }}, 
      {{ SC_(-6.388184070587158203125), SC_(-0.9999999999999999998348790206445813875893), SC_(1.999999999999999999834879020644581387589) }}, 
      {{ SC_(-6.293555736541748046875), SC_(-0.9999999999999999994437019971919548391819), SC_(1.999999999999999999443701997191954839182) }}, 
      {{ SC_(-6.2710094451904296875), SC_(-0.9999999999999999992589325173780715980195), SC_(1.99999999999999999925893251737807159802) }}, 
      {{ SC_(-6.242211818695068359375), SC_(-0.9999999999999999989326493643877411691996), SC_(1.9999999999999999989326493643877411692) }}, 
      {{ SC_(-6.22209262847900390625), SC_(-0.999999999999999998624109280849850203527), SC_(1.999999999999999998624109280849850203527) }}, 
      {{ SC_(-6.220756053924560546875), SC_(-0.9999999999999999986007425210281758251292), SC_(1.999999999999999998600742521028175825129) }}, 
      {{ SC_(-6.200567722320556640625), SC_(-0.9999999999999999981962301352174253788249), SC_(1.999999999999999998196230135217425378825) }}, 
      {{ SC_(-6.188919544219970703125), SC_(-0.9999999999999999979123729253091532478511), SC_(1.999999999999999997912372925309153247851) }}, 
      {{ SC_(-6.121317386627197265625), SC_(-0.9999999999999999951502004864042604960246), SC_(1.999999999999999995150200486404260496025) }}, 
      {{ SC_(-6.0960369110107421875), SC_(-0.999999999999999993368492031514234286194), SC_(1.999999999999999993368492031514234286194) }}, 
      {{ SC_(-6.08724498748779296875), SC_(-0.9999999999999999926083315666932664549236), SC_(1.999999999999999992608331566693266454924) }}, 
      {{ SC_(-6.026896953582763671875), SC_(-0.9999999999999999844955556006137776564529), SC_(1.999999999999999984495555600613777656453) }}, 
      {{ SC_(-5.9970760345458984375), SC_(-0.9999999999999999777013911828554459912853), SC_(1.999999999999999977701391182855445991285) }}, 
      {{ SC_(-5.98565387725830078125), SC_(-0.9999999999999999743831687415390670278399), SC_(1.99999999999999997438316874153906702784) }}, 
      {{ SC_(-5.96821117401123046875), SC_(-0.999999999999999968354398455085434720569), SC_(1.999999999999999968354398455085434720569) }}, 
      {{ SC_(-5.92245578765869140625), SC_(-0.9999999999999999450648430800723663224774), SC_(1.999999999999999945064843080072366322477) }}, 
      {{ SC_(-5.921500682830810546875), SC_(-0.9999999999999999444311537798288144041217), SC_(1.999999999999999944431153779828814404122) }}, 
      {{ SC_(-5.888427257537841796875), SC_(-0.9999999999999999174281958873362911444154), SC_(1.999999999999999917428195887336291144415) }}, 
      {{ SC_(-5.87206363677978515625), SC_(-0.9999999999999998996343433163177337705717), SC_(1.999999999999999899634343316317733770572) }}, 
      {{ SC_(-5.860218048095703125), SC_(-0.9999999999999998844434106367807360220097), SC_(1.99999999999999988444341063678073602201) }}, 
      {{ SC_(-5.83236789703369140625), SC_(-0.9999999999999998392204407202278816953224), SC_(1.999999999999999839220440720227881695322) }}, 
      {{ SC_(-5.822903156280517578125), SC_(-0.9999999999999998201851297606348078114632), SC_(1.999999999999999820185129760634807811463) }}, 
      {{ SC_(-5.7919788360595703125), SC_(-0.9999999999999997411398900200191738483065), SC_(1.999999999999999741139890020019173848306) }}, 
      {{ SC_(-5.782009124755859375), SC_(-0.9999999999999997089916610994263590057672), SC_(1.999999999999999708991661099426359005767) }}, 
      {{ SC_(-5.757698535919189453125), SC_(-0.9999999999999996131703510337485986984616), SC_(1.999999999999999613170351033748598698462) }}, 
      {{ SC_(-5.7298183441162109375), SC_(-0.9999999999999994646206751994613491480939), SC_(1.999999999999999464620675199461349148094) }}, 
      {{ SC_(-5.6807231903076171875), SC_(-0.9999999999999990546672380240389993944094), SC_(1.999999999999999054667238024038999394409) }}, 
      {{ SC_(-5.67137622833251953125), SC_(-0.9999999999999989471628690116228142127541), SC_(1.999999999999998947162869011622814212754) }}, 
      {{ SC_(-5.63473606109619140625), SC_(-0.9999999999999983967395492779530149899861), SC_(1.999999999999998396739549277953014989986) }}, 
      {{ SC_(-5.614176273345947265625), SC_(-0.9999999999999979723800510435190721967745), SC_(1.999999999999997972380051043519072196774) }}, 
      {{ SC_(-5.6112957000732421875), SC_(-0.9999999999999979047003987118507997439545), SC_(1.999999999999997904700398711850799743955) }}, 
      {{ SC_(-5.56195163726806640625), SC_(-0.9999999999999963321711826091909555528649), SC_(1.999999999999996332171182609190955552865) }}, 
      {{ SC_(-5.52898502349853515625), SC_(-0.999999999999994682538283828212635195642), SC_(1.999999999999994682538283828212635195642) }}, 
      {{ SC_(-5.47819042205810546875), SC_(-0.9999999999999906156035801749079852647386), SC_(1.999999999999990615603580174907985264739) }}, 
      {{ SC_(-5.4710788726806640625), SC_(-0.9999999999999898428944822493616106985002), SC_(1.9999999999999898428944822493616106985) }}, 
      {{ SC_(-5.405083179473876953125), SC_(-0.9999999999999789329565303176610969074478), SC_(1.999999999999978932956530317661096907448) }}, 
      {{ SC_(-5.402743816375732421875), SC_(-0.9999999999999783844591899263947698611185), SC_(1.999999999999978384459189926394769861119) }}, 
      {{ SC_(-5.398212432861328125), SC_(-0.9999999999999772817558127269992185563875), SC_(1.999999999999977281755812726999218556388) }}, 
      {{ SC_(-5.39404582977294921875), SC_(-0.9999999999999762190932060075070452678252), SC_(1.999999999999976219093206007507045267825) }}, 
      {{ SC_(-5.349620342254638671875), SC_(-0.9999999999999613641252395001102021837028), SC_(1.999999999999961364125239500110202183703) }}, 
      {{ SC_(-5.3191070556640625), SC_(-0.9999999999999462010476635137780577801192), SC_(1.999999999999946201047663513778057780119) }}, 
      {{ SC_(-5.2961597442626953125), SC_(-0.9999999999999310743837318684932169157806), SC_(1.999999999999931074383731868493216915781) }}, 
      {{ SC_(-5.2686710357666015625), SC_(-0.9999999999999073829182184635550018139178), SC_(1.999999999999907382918218463555001813918) }}, 
      {{ SC_(-5.261013031005859375), SC_(-0.999999999999899463963517023463646064969), SC_(1.999999999999899463963517023463646064969) }}, 
      {{ SC_(-5.218157291412353515625), SC_(-0.999999999999841220863178602997391812622), SC_(1.999999999999841220863178602997391812622) }}, 
      {{ SC_(-5.09483242034912109375), SC_(-0.9999999999994203324744342031290577923874), SC_(1.999999999999420332474434203129057792387) }}, 
      {{ SC_(-5.09044742584228515625), SC_(-0.9999999999993933525823679657367786914755), SC_(1.999999999999393352582367965736778691476) }}, 
      {{ SC_(-5.0638217926025390625), SC_(-0.9999999999992009929816947679454761069971), SC_(1.999999999999200992981694767945476106997) }}, 
      {{ SC_(-5.05747509002685546875), SC_(-0.9999999999991469518921467092111635858909), SC_(1.999999999999146951892146709211163585891) }}, 
      {{ SC_(-5.04293918609619140625), SC_(-0.9999999999990093020187848982236516240641), SC_(1.999999999999009302018784898223651624064) }}, 
      {{ SC_(-5.0100383758544921875), SC_(-0.9999999999986122073654265981749793751861), SC_(1.999999999998612207365426598174979375186) }}, 
      {{ SC_(-4.98588848114013671875), SC_(-0.9999999999982250531272305424718207921526), SC_(1.999999999998225053127230542471820792153) }}, 
      {{ SC_(-4.97671985626220703125), SC_(-0.999999999998051837006412113097549508585), SC_(1.999999999998051837006412113097549508585) }}, 
      {{ SC_(-4.88807392120361328125), SC_(-0.9999999999952475475430397811200299233621), SC_(1.999999999995247547543039781120029923362) }}, 
      {{ SC_(-4.883771419525146484375), SC_(-0.999999999995039278283384091602446410145), SC_(1.999999999995039278283384091602446410145) }}, 
      {{ SC_(-4.85447597503662109375), SC_(-0.9999999999933632419317336295299664149692), SC_(1.999999999993363241931733629529966414969) }}, 
      {{ SC_(-4.8071804046630859375), SC_(-0.9999999999894197712585954179441600183832), SC_(1.999999999989419771258595417944160018383) }}, 
      {{ SC_(-4.8020343780517578125), SC_(-0.999999999988871990172530478547610656837), SC_(1.999999999988871990172530478547610656837) }}, 
      {{ SC_(-4.67612361907958984375), SC_(-0.9999999999623486826561914023506448369931), SC_(1.999999999962348682656191402350644836993) }}, 
      {{ SC_(-4.67091083526611328125), SC_(-0.9999999999604264343616001426261420203042), SC_(1.999999999960426434361600142626142020304) }}, 
      {{ SC_(-4.63665485382080078125), SC_(-0.9999999999451799554409023277165162445309), SC_(1.999999999945179955440902327716516244531) }}, 
      {{ SC_(-4.63516998291015625), SC_(-0.9999999999444029440920085430347846425569), SC_(1.999999999944402944092008543034784642557) }}, 
      {{ SC_(-4.609210968017578125), SC_(-0.9999999999289428162110384732949528732821), SC_(1.999999999928942816211038473294952873282) }}, 
      {{ SC_(-4.579636096954345703125), SC_(-0.9999999999061772810501309067972710348531), SC_(1.999999999906177281050130906797271034853) }}, 
      {{ SC_(-4.5241947174072265625), SC_(-0.9999999998427575929141653776733036798231), SC_(1.999999999842757592914165377673303679823) }}, 
      {{ SC_(-4.4634552001953125), SC_(-0.9999999997250438347478646951934940057007), SC_(1.999999999725043834747864695193494005701) }}, 
      {{ SC_(-4.45205211639404296875), SC_(-0.9999999996948757672104213971222453301401), SC_(1.99999999969487576721042139712224533014) }}, 
      {{ SC_(-4.42528057098388671875), SC_(-0.9999999996107829436098873733936274863483), SC_(1.999999999610782943609887373393627486348) }}, 
      {{ SC_(-4.41900920867919921875), SC_(-0.9999999995880275737192502467322057148997), SC_(1.9999999995880275737192502467322057149) }}, 
      {{ SC_(-4.385251522064208984375), SC_(-0.9999999994413719520612921019983336162185), SC_(1.999999999441371952061292101998333616218) }}, 
      {{ SC_(-4.35737133026123046875), SC_(-0.9999999992828314119867337542458504771416), SC_(1.999999999282831411986733754245850477142) }}, 
      {{ SC_(-4.336368560791015625), SC_(-0.9999999991351915352325599843092928507457), SC_(1.999999999135191535232559984309292850746) }}, 
      {{ SC_(-4.3175029754638671875), SC_(-0.9999999989775860530323911767706859733538), SC_(1.999999998977586053032391176770685973354) }}, 
      {{ SC_(-4.3121891021728515625), SC_(-0.9999999989283533546777667686892314376364), SC_(1.999999998928353354677766768689231437636) }}, 
      {{ SC_(-4.24352169036865234375), SC_(-0.9999999980419084658739942819306906184851), SC_(1.999999998041908465873994281930690618485) }}, 
      {{ SC_(-4.2034626007080078125), SC_(-0.9999999972285679690220595850552637350437), SC_(1.999999997228567969022059585055263735044) }}, 
      {{ SC_(-4.167960643768310546875), SC_(-0.9999999962392394571627954662587140061652), SC_(1.999999996239239457162795466258714006165) }}, 
      {{ SC_(-4.16134166717529296875), SC_(-0.9999999960200815333961445529473170709169), SC_(1.999999996020081533396144552947317070917) }}, 
      {{ SC_(-4.16075992584228515625), SC_(-0.9999999960002360604729678479207669714279), SC_(1.999999996000236060472967847920766971428) }}, 
      {{ SC_(-4.1587848663330078125), SC_(-0.9999999959321378359433584056353681610608), SC_(1.999999995932137835943358405635368161061) }}, 
      {{ SC_(-4.13293933868408203125), SC_(-0.9999999949300206910645246208514668562552), SC_(1.999999994930020691064524620851466856255) }}, 
      {{ SC_(-4.10360050201416015625), SC_(-0.9999999935003875691498030735774774570481), SC_(1.999999993500387569149803073577477457048) }}, 
      {{ SC_(-4.093787670135498046875), SC_(-0.9999999929399558954302260075393445424033), SC_(1.999999992939955895430226007539344542403) }}, 
      {{ SC_(-4.03443813323974609375), SC_(-0.9999999884036843046875049228478172494175), SC_(1.999999988403684304687504922847817249418) }}, 
      {{ SC_(-3.98265838623046875), SC_(-0.9999999822208421118305103285259015091646), SC_(1.999999982220842111830510328525901509165) }}, 
      {{ SC_(-3.95270442962646484375), SC_(-0.999999977288881596788417317605289657808), SC_(1.999999977288881596788417317605289657808) }}, 
      {{ SC_(-3.93148517608642578125), SC_(-0.9999999730162981717884382202253382435415), SC_(1.999999973016298171788438220225338243541) }}, 
      {{ SC_(-3.9184780120849609375), SC_(-0.9999999700219312753222765854504223837405), SC_(1.999999970021931275322276585450422383741) }}, 
      {{ SC_(-3.879868030548095703125), SC_(-0.9999999591094922703532983235991568008465), SC_(1.999999959109492270353298323599156800846) }}, 
      {{ SC_(-3.87096500396728515625), SC_(-0.9999999560932170720769359018836285296472), SC_(1.999999956093217072076935901883628529647) }}, 
      {{ SC_(-3.8672657012939453125), SC_(-0.9999999547774543398438306972996188616961), SC_(1.999999954777454339843830697299618861696) }}, 
      {{ SC_(-3.8420734405517578125), SC_(-0.9999999447445478718542012659151234910068), SC_(1.999999944744547871854201265915123491007) }}, 
      {{ SC_(-3.80461215972900390625), SC_(-0.9999999257348372704254553693981655561718), SC_(1.999999925734837270425455369398165556172) }}, 
      {{ SC_(-3.80028438568115234375), SC_(-0.9999999231677373273547880220190103959364), SC_(1.999999923167737327354788022019010395936) }}, 
      {{ SC_(-3.7924594879150390625), SC_(-0.9999999183064389713690424963266578644364), SC_(1.999999918306438971369042496326657864436) }}, 
      {{ SC_(-3.779153347015380859375), SC_(-0.9999999093479967587842599992485780175831), SC_(1.999999909347996758784259999248578017583) }}, 
      {{ SC_(-3.745269298553466796875), SC_(-0.9999998820281274980831886027456911311136), SC_(1.999999882028127498083188602745691131114) }}, 
      {{ SC_(-3.635951519012451171875), SC_(-0.9999997281881766345956227352142649973655), SC_(1.999999728188176634595622735214264997366) }}, 
      {{ SC_(-3.583598613739013671875), SC_(-0.9999995979271880120576416299198266820133), SC_(1.999999597927188012057641629919826682013) }}, 
      {{ SC_(-3.569232463836669921875), SC_(-0.9999995527387093906657265121528897426977), SC_(1.999999552738709390665726512152889742698) }}, 
      {{ SC_(-3.54402828216552734375), SC_(-0.9999994613639729253001570644107494201161), SC_(1.999999461363972925300157064410749420116) }}, 
      {{ SC_(-3.493962764739990234375), SC_(-0.9999992236058222995205263652341878797772), SC_(1.999999223605822299520526365234187879777) }}, 
      {{ SC_(-3.47722721099853515625), SC_(-0.9999991236228879726907047497841004833717), SC_(1.999999123622887972690704749784100483372) }}, 
      {{ SC_(-3.42657566070556640625), SC_(-0.9999987396721107155880129044796731448843), SC_(1.999998739672110715588012904479673144884) }}, 
      {{ SC_(-3.395120143890380859375), SC_(-0.9999984245945048910106563425119028396989), SC_(1.999998424594504891010656342511902839699) }}, 
      {{ SC_(-3.2588672637939453125), SC_(-0.9999959487230642521321857857111066240831), SC_(1.999995948723064252132185785711106624083) }}, 
      {{ SC_(-3.25318622589111328125), SC_(-0.9999957892666030355025210909109288232829), SC_(1.999995789266603035502521090910928823283) }}, 
      {{ SC_(-3.24752902984619140625), SC_(-0.9999956245131483542950695952847663629895), SC_(1.999995624513148354295069595284766362989) }}, 
      {{ SC_(-3.202692508697509765625), SC_(-0.999994081810816371407042912866658069023), SC_(1.999994081810816371407042912866658069023) }}, 
      {{ SC_(-3.18005847930908203125), SC_(-0.9999931172272250183599071058385709997756), SC_(1.999993117227225018359907105838570999776) }}, 
      {{ SC_(-3.1707630157470703125), SC_(-0.9999926790059947731109719912653300431319), SC_(1.999992679005994773110971991265330043132) }}, 
      {{ SC_(-3.169390201568603515625), SC_(-0.9999926120675897748726975211646249757192), SC_(1.999992612067589774872697521164624975719) }}, 
      {{ SC_(-3.14217662811279296875), SC_(-0.9999911578738950876912019671208070065199), SC_(1.99999115787389508769120196712080700652) }}, 
      {{ SC_(-3.098408222198486328125), SC_(-0.9999882303073587594668534541884135423388), SC_(1.999988230307358759466853454188413542339) }}, 
      {{ SC_(-3.06932735443115234375), SC_(-0.999985796037084204485104304979662919637), SC_(1.999985796037084204485104304979662919637) }}, 
      {{ SC_(-3.022363185882568359375), SC_(-0.9999808232882432626861296621474557768078), SC_(1.999980823288243262686129662147455776808) }}, 
      {{ SC_(-3.0205593109130859375), SC_(-0.99998060254361354516950352566536112825), SC_(1.99998060254361354516950352566536112825) }}, 
      {{ SC_(-2.9998722076416015625), SC_(-0.9999778917007014674907019090992903927905), SC_(1.99997789170070146749070190909929039279) }}, 
      {{ SC_(-2.93519306182861328125), SC_(-0.9999668959531720126596587741439225107667), SC_(1.999966895953172012659658774143922510767) }}, 
      {{ SC_(-2.926408290863037109375), SC_(-0.9999650517107016922239378838021163842873), SC_(1.999965051710701692223937883802116384287) }}, 
      {{ SC_(-2.899547100067138671875), SC_(-0.999958788198949955666474096263902253671), SC_(1.999958788198949955666474096263902253671) }}, 
      {{ SC_(-2.839828014373779296875), SC_(-0.9999408366877163447694128978591340253067), SC_(1.999940836687716344769412897859134025307) }}, 
      {{ SC_(-2.800583362579345703125), SC_(-0.999925245516783962943949700531260241058), SC_(1.999925245516783962943949700531260241058) }}, 
      {{ SC_(-2.680827617645263671875), SC_(-0.9998501167313102825068480156096308901785), SC_(1.999850116731310282506848015609630890178) }}, 
      {{ SC_(-2.606037616729736328125), SC_(-0.9997717403084130424047446475974562075669), SC_(1.999771740308413042404744647597456207567) }}, 
      {{ SC_(-2.596489429473876953125), SC_(-0.9997593314310112494727877345037418013218), SC_(1.999759331431011249472787734503741801322) }}, 
      {{ SC_(-2.556484699249267578125), SC_(-0.9997001335302201489942673149686527944858), SC_(1.999700133530220148994267314968652794486) }}, 
      {{ SC_(-2.55382823944091796875), SC_(-0.9996957549944839552321892922320479894269), SC_(1.999695754994483955232189292232047989427) }}, 
      {{ SC_(-2.4985675811767578125), SC_(-0.9995899165690053281055967168476241365437), SC_(1.999589916569005328105596716847624136544) }}, 
      {{ SC_(-2.497124195098876953125), SC_(-0.9995867384254941652801786367398089660165), SC_(1.999586738425494165280178636739808966017) }}, 
      {{ SC_(-2.490753173828125), SC_(-0.9995724334726506448073869548176702294685), SC_(1.999572433472650644807386954817670229469) }}, 
      {{ SC_(-2.460265636444091796875), SC_(-0.9994973515109755881934536091311894641618), SC_(1.999497351510975588193453609131189464162) }}, 
      {{ SC_(-2.40025997161865234375), SC_(-0.9993124098945743590409442455200430144501), SC_(1.99931240989457435904094424552004301445) }}, 
      {{ SC_(-2.388366222381591796875), SC_(-0.9992689456487626816982924092483781182671), SC_(1.999268945648762681698292409248378118267) }}, 
      {{ SC_(-2.384761810302734375), SC_(-0.9992552781640235711505276307965871326558), SC_(1.999255278164023571150527630796587132656) }}, 
      {{ SC_(-2.373447895050048828125), SC_(-0.9992108203337266317630339931581723787703), SC_(1.99921082033372663176303399315817237877) }}, 
      {{ SC_(-2.35580158233642578125), SC_(-0.9991365376081490204083636912804528578856), SC_(1.999136537608149020408363691280452857886) }}, 
      {{ SC_(-2.349462985992431640625), SC_(-0.9991083086054509601980729014412256941765), SC_(1.999108308605450960198072901441225694177) }}, 
      {{ SC_(-2.325789928436279296875), SC_(-0.9989951442451653569033517704201324436285), SC_(1.998995144245165356903351770420132443629) }}, 
      {{ SC_(-2.298477649688720703125), SC_(-0.9988481323367447342223184498893246720825), SC_(1.998848132336744734222318449889324672082) }}, 
      {{ SC_(-2.2262287139892578125), SC_(-0.9983581224514242039282878472715945919025), SC_(1.998358122451424203928287847271594591902) }}, 
      {{ SC_(-2.219295978546142578125), SC_(-0.998302189420417444109741372233572205265), SC_(1.998302189420417444109741372233572205265) }}, 
      {{ SC_(-2.189016819000244140625), SC_(-0.9980367577158553307156976632350258375259), SC_(1.998036757715855330715697663235025837526) }}, 
      {{ SC_(-2.104246616363525390625), SC_(-0.9970782617526262805996280944999396165258), SC_(1.997078261752626280599628094499939616526) }}, 
      {{ SC_(-2.09205150604248046875), SC_(-0.996909676793369814528976371166247129793), SC_(1.996909676793369814528976371166247129793) }}, 
      {{ SC_(-1.943993091583251953125), SC_(-0.9940262977790097894466206756466888367063), SC_(1.994026297779009789446620675646688836706) }}, 
      {{ SC_(-1.942249774932861328125), SC_(-0.9939812101597516949958261235233631934366), SC_(1.993981210159751694995826123523363193437) }}, 
      {{ SC_(-1.92929840087890625), SC_(-0.9936365327754943109828903386026580883517), SC_(1.993636532775494310982890338602658088352) }}, 
      {{ SC_(-1.9128665924072265625), SC_(-0.9931737109637705201269656939986887652236), SC_(1.993173710963770520126965693998688765224) }}, 
      {{ SC_(-1.895064830780029296875), SC_(-0.9926383642753156425388548860773597376898), SC_(1.99263836427531564253885488607735973769) }}, 
      {{ SC_(-1.882672786712646484375), SC_(-0.9922437750397196518941448785374711511261), SC_(1.992243775039719651894144878537471151126) }}, 
      {{ SC_(-1.828631877899169921875), SC_(-0.9902924477378445174333029970634342529452), SC_(1.990292447737844517433302997063434252945) }}, 
      {{ SC_(-1.80326557159423828125), SC_(-0.9892339674123972616044498747407170334529), SC_(1.989233967412397261604449874740717033453) }}, 
      {{ SC_(-1.782883167266845703125), SC_(-0.9883103648996334893102564452420811120219), SC_(1.988310364899633489310256445242081112022) }}, 
      {{ SC_(-1.782157421112060546875), SC_(-0.9882762203088354892421983954567744612798), SC_(1.98827622030883548924219839545677446128) }}, 
      {{ SC_(-1.764178752899169921875), SC_(-0.9874016428696177596270555371821625326888), SC_(1.987401642869617759627055537182162532689) }}, 
      {{ SC_(-1.724367618560791015625), SC_(-0.9852567034182150765341946638967494699071), SC_(1.985256703418215076534194663896749469907) }}, 
      {{ SC_(-1.72287273406982421875), SC_(-0.9851702400474429438625280403202433838526), SC_(1.985170240047442943862528040320243383853) }}, 
      {{ SC_(-1.7025623321533203125), SC_(-0.9839504468402545890671810248015208820884), SC_(1.983950446840254589067181024801520882088) }}, 
      {{ SC_(-1.681468486785888671875), SC_(-0.9825910751286767851758755186900841221579), SC_(1.982591075128676785175875518690084122158) }}, 
      {{ SC_(-1.620183467864990234375), SC_(-0.9780530894885187264467073421784139736619), SC_(1.978053089488518726446707342178413973662) }}, 
      {{ SC_(-1.60347747802734375), SC_(-0.9766500377526993846072575680069692660948), SC_(1.976650037752699384607257568006969266095) }}, 
      {{ SC_(-1.571071624755859375), SC_(-0.9737052575465025934260968149501583467125), SC_(1.973705257546502593426096814950158346713) }}, 
      {{ SC_(-1.53740596771240234375), SC_(-0.9703114107420642954692014594922082792993), SC_(1.970311410742064295469201459492208279299) }}, 
      {{ SC_(-1.532663822174072265625), SC_(-0.9698043138855053203894778295822038830362), SC_(1.969804313885505320389477829582203883036) }}, 
      {{ SC_(-1.520298004150390625), SC_(-0.9684468462170278589593123134293666728451), SC_(1.968446846217027858959312313429366672845) }}, 
      {{ SC_(-1.46048259735107421875), SC_(-0.9611180737284418513301177062365441297047), SC_(1.961118073728441851330117706236544129705) }}, 
      {{ SC_(-1.46030139923095703125), SC_(-0.9610938428333207830423176962413277320147), SC_(1.961093842833320783042317696241327732015) }}, 
      {{ SC_(-1.397335529327392578125), SC_(-0.95186004156783627938149047892729029742), SC_(1.95186004156783627938149047892729029742) }}, 
      {{ SC_(-1.323727130889892578125), SC_(-0.9387979426539853054753709161513664166231), SC_(1.938797942653985305475370916151366416623) }}, 
      {{ SC_(-1.276960849761962890625), SC_(-0.9290653127836001839333487555304113443469), SC_(1.929065312783600183933348755530411344347) }}, 
      {{ SC_(-1.251819610595703125), SC_(-0.9233295267095685592936382247773245095211), SC_(1.923329526709568559293638224777324509521) }}, 
      {{ SC_(-1.2465972900390625), SC_(-0.922091885695169724540643322054908203716), SC_(1.922091885695169724540643322054908203716) }}, 
      {{ SC_(-1.229358196258544921875), SC_(-0.9178904588743834920391721278905832368302), SC_(1.91789045887438349203917212789058323683) }}, 
      {{ SC_(-1.213331699371337890625), SC_(-0.9138215103657655632884642680979616998362), SC_(1.913821510365765563288464268097961699836) }}, 
      {{ SC_(-1.116681575775146484375), SC_(-0.8857158242630258840771197321511943815897), SC_(1.88571582426302588407711973215119438159) }}, 
      {{ SC_(-1.09737873077392578125), SC_(-0.8793205199265164668934947879280656428528), SC_(1.879320519926516466893494787928065642853) }}, 
      {{ SC_(-1.03606891632080078125), SC_(-0.8571398352791599842463927101183584004108), SC_(1.857139835279159984246392710118358400411) }}, 
      {{ SC_(-1.02882099151611328125), SC_(-0.8543231526950909266263537903698694334291), SC_(1.854323152695090926626353790369869433429) }}, 
      {{ SC_(-1.026262760162353515625), SC_(-0.8533188869429530167338078137781125122721), SC_(1.853318886942953016733807813778112512272) }}, 
      {{ SC_(-1.022119045257568359375), SC_(-0.8516809958278677712657998641436434438829), SC_(1.851680995827867771265799864143643443883) }}, 
      {{ SC_(-0.98133087158203125), SC_(-0.8348055259299460511418008829670873610918), SC_(1.834805525929946051141800882967087361092) }}, 
      {{ SC_(-0.98009014129638671875), SC_(-0.8342704307251498046946024215096246227333), SC_(1.834270430725149804694602421509624622733) }}, 
      {{ SC_(-0.978080272674560546875), SC_(-0.8334008602869646802889203803617335510339), SC_(1.833400860286964680288920380361733551034) }}, 
      {{ SC_(-0.940424442291259765625), SC_(-0.8164688788909394484793384087716057083799), SC_(1.81646887889093944847933840877160570838) }}, 
      {{ SC_(-0.91714763641357421875), SC_(-0.8053834793732810256405554109602821691384), SC_(1.805383479373281025640555410960282169138) }}, 
      {{ SC_(-0.8706207275390625), SC_(-0.781768246143243039204234681706396017802), SC_(1.781768246143243039204234681706396017802) }}, 
      {{ SC_(-0.851459980010986328125), SC_(-0.7714669440617130962820390740100194505811), SC_(1.771466944061713096282039074010019450581) }}, 
      {{ SC_(-0.838649749755859375), SC_(-0.7643894884988580737761809305277678222351), SC_(1.764389488498858073776180930527767822235) }}, 
      {{ SC_(-0.807102680206298828125), SC_(-0.7463029660131220821356233145746604568211), SC_(1.746302966013122082135623314574660456821) }}, 
      {{ SC_(-0.791334629058837890625), SC_(-0.736909415458981852160328895368373188263), SC_(1.736909415458981852160328895368373188263) }}, 
      {{ SC_(-0.785220623016357421875), SC_(-0.733203302564899727070457054931447622963), SC_(1.733203302564899727070457054931447622963) }}, 
      {{ SC_(-0.70347499847412109375), SC_(-0.6801975294548325529556721796784430699978), SC_(1.680197529454832552955672179678443069998) }}, 
      {{ SC_(-0.67217350006103515625), SC_(-0.6581909469611049063385748815906001209893), SC_(1.658190946961104906338574881590600120989) }}, 
      {{ SC_(-0.664049625396728515625), SC_(-0.6523246956990475458808567744402919677512), SC_(1.652324695699047545880856774440291967751) }}, 
      {{ SC_(-0.6584186553955078125), SC_(-0.6482212253745081770626529427408934017486), SC_(1.648221225374508177062652942740893401749) }}, 
      {{ SC_(-0.600412845611572265625), SC_(-0.6041810203314129078699785592786899867966), SC_(1.604181020331412907869978559278689986797) }}, 
      {{ SC_(-0.489749908447265625), SC_(-0.511446271301716371110680826950617647501), SC_(1.511446271301716371110680826950617647501) }}, 
      {{ SC_(-0.465226650238037109375), SC_(-0.4894167837515200466665783301747412934405), SC_(1.489416783751520046666578330174741293441) }}, 
      {{ SC_(-0.44869136810302734375), SC_(-0.4742750638478986908270201721978810099748), SC_(1.474275063847898690827020172197881009975) }}, 
      {{ SC_(-0.431758880615234375), SC_(-0.4585350903554068789999156737476376374281), SC_(1.458535090355406878999915673747637637428) }}, 
      {{ SC_(-0.42737865447998046875), SC_(-0.4544253812246350465277000224478606192938), SC_(1.454425381224635046527700022447860619294) }}, 
      {{ SC_(-0.40386104583740234375), SC_(-0.432099163831203009522492134188633143318), SC_(1.432099163831203009522492134188633143318) }}, 
      {{ SC_(-0.373790740966796875), SC_(-0.4029308717684010449096733839740115560375), SC_(1.402930871768401044909673383974011556038) }}, 
      {{ SC_(-0.233989715576171875), SC_(-0.2592886113836899036561306247377429906331), SC_(1.259288611383689903656130624737742990633) }}, 
      {{ SC_(-0.211333751678466796875), SC_(-0.2349615691289957823240891523819732686167), SC_(1.234961569128995782324089152381973268617) }}, 
      {{ SC_(-0.19889736175537109375), SC_(-0.2215069175571250998650947268880775414973), SC_(1.221506917557125099865094726888077541497) }}, 
      {{ SC_(-0.182256221771240234375), SC_(-0.2033995434419099358670147911035329678187), SC_(1.203399543441909935867014791103532967819) }}, 
      {{ SC_(-0.18211650848388671875), SC_(-0.2032470406749777206160247638754155004452), SC_(1.203247040674977720616024763875415500445) }}, 
      {{ SC_(-0.17195796966552734375), SC_(-0.1921381404648513701112796196929619853574), SC_(1.192138140464851370111279619692961985357) }}, 
      {{ SC_(-0.16376972198486328125), SC_(-0.1831554574798521513436655145245684061007), SC_(1.183155457479852151343665514524568406101) }}, 
      {{ SC_(-0.1551761627197265625), SC_(-0.1737022152361176281597084824103780401593), SC_(1.173702215236117628159708482410378040159) }}, 
      {{ SC_(-0.150575160980224609375), SC_(-0.1686304768425467295981309155148784764793), SC_(1.168630476842546729598130915514878476479) }}, 
      {{ SC_(-0.14617443084716796875), SC_(-0.1637729176827752878270766458400701270093), SC_(1.163772917682775287827076645840070127009) }}, 
      {{ SC_(-0.120928287506103515625), SC_(-0.1357907214549539753359678326306578109211), SC_(1.135790721454953975335967832630657810921) }}, 
      {{ SC_(-0.10677051544189453125), SC_(-0.120021374070160212148900319045677271623), SC_(1.120021374070160212148900319045677271623) }}, 
      {{ SC_(-0.026175022125244140625), SC_(-0.02952860584830764246354187242063295294678), SC_(1.029528605848307642463541872420632952947) }}, 
      {{ SC_(-0.023293018341064453125), SC_(-0.02627860393458503686138222115868091914281), SC_(1.026278603934585036861382221158680919143) }}, 
      {{ SC_(0.0510406494140625), SC_(0.05754323159766276460633141130734206381764), SC_(0.9424567684023372353936685886926579361824) }}, 
      {{ SC_(0.0586032867431640625), SC_(0.06605110514470391012871050500624176400922), SC_(0.9339488948552960898712894949937582359908) }}, 
      {{ SC_(0.076335906982421875), SC_(0.0859688297890711056959299022462129164399), SC_(0.9140311702109288943040700977537870835601) }}, 
      {{ SC_(0.0879764556884765625), SC_(0.09901527946158023583191911912735088560206), SC_(0.9009847205384197641680808808726491143979) }}, 
      {{ SC_(0.09531307220458984375), SC_(0.1072244906212039889473333509272810724811), SC_(0.8927755093787960110526666490727189275189) }}, 
      {{ SC_(0.125732421875), SC_(0.141129766841816338386433828128425005518), SC_(0.858870233158183661613566171871574994482) }}, 
      {{ SC_(0.136138916015625), SC_(0.1526725386198208366577407509841325704749), SC_(0.8473274613801791633422592490158674295251) }}, 
      {{ SC_(0.17234516143798828125), SC_(0.1925622815596925250765701529203770551484), SC_(0.8074377184403074749234298470796229448516) }}, 
      {{ SC_(0.2119922637939453125), SC_(0.2356720655395377271770852173917242884116), SC_(0.7643279344604622728229147826082757115884) }}, 
      {{ SC_(0.43794345855712890625), SC_(0.4643112756462460685205691813402852159015), SC_(0.5356887243537539314794308186597147840985) }}, 
      {{ SC_(0.45653057098388671875), SC_(0.4814821136114279472122846649867025115386), SC_(0.5185178863885720527877153350132974884614) }}, 
      {{ SC_(0.47747135162353515625), SC_(0.5004808072450297309682843640858704431896), SC_(0.4995191927549702690317156359141295568104) }}, 
      {{ SC_(0.49276065826416015625), SC_(0.5141150988347504841569692774090664542419), SC_(0.4858849011652495158430307225909335457581) }}, 
      {{ SC_(0.5252094268798828125), SC_(0.5423719706469999625701008732557153279125), SC_(0.4576280293530000374298991267442846720875) }}, 
      {{ SC_(0.54292964935302734375), SC_(0.5574049622516386907232939533524308087156), SC_(0.4425950377483613092767060466475691912844) }}, 
      {{ SC_(0.61347866058349609375), SC_(0.6143810907170157257383288013023603675948), SC_(0.3856189092829842742616711986976396324052) }}, 
      {{ SC_(0.642208099365234375), SC_(0.6362376857636366143813206114170006573371), SC_(0.3637623142363633856186793885829993426629) }}, 
      {{ SC_(0.7008876800537109375), SC_(0.6784144434439739073654322843049904496467), SC_(0.3215855565560260926345677156950095503533) }}, 
      {{ SC_(0.70489788055419921875), SC_(0.6811753668779429503087291745627064840922), SC_(0.3188246331220570496912708254372935159078) }}, 
      {{ SC_(0.74547100067138671875), SC_(0.7082339060756917047499724898172912878096), SC_(0.2917660939243082952500275101827087121904) }}, 
      {{ SC_(0.75010395050048828125), SC_(0.7112224614494741974710200961895796339406), SC_(0.2887775385505258025289799038104203660594) }}, 
      {{ SC_(0.7521419525146484375), SC_(0.7125305494335531148908418692735599063945), SC_(0.2874694505664468851091581307264400936055) }}, 
      {{ SC_(0.75544834136962890625), SC_(0.7146442322820387669270602166159252715355), SC_(0.2853557677179612330729397833840747284645) }}, 
      {{ SC_(0.7555294036865234375), SC_(0.7146959208691246816716474590070080412476), SC_(0.2853040791308753183283525409929919587524) }}, 
      {{ SC_(0.7955780029296875), SC_(0.7394606270451848746421982649233401081581), SC_(0.2605393729548151253578017350766598918419) }}, 
      {{ SC_(0.79776287078857421875), SC_(0.7407675218037960090659350830732732644233), SC_(0.2592324781962039909340649169267267355767) }}, 
      {{ SC_(0.802501678466796875), SC_(0.7435864497870381244667241506381330984847), SC_(0.2564135502129618755332758493618669015153) }}, 
      {{ SC_(0.84609889984130859375), SC_(0.7685236710399025207372546246556089909706), SC_(0.2314763289600974792627453753443910090294) }}, 
      {{ SC_(0.932300567626953125), SC_(0.812654343559088650769418669744883116426), SC_(0.187345656440911349230581330255116883574) }}, 
      {{ SC_(0.98491954803466796875), SC_(0.8363459095960576788409384172057128987876), SC_(0.1636540904039423211590615827942871012124) }}, 
      {{ SC_(1.0851459503173828125), SC_(0.8751247987335964581036476838295929858233), SC_(0.1248752012664035418963523161704070141767) }}, 
      {{ SC_(1.10117816925048828125), SC_(0.8806009859824617559963680716051525866734), SC_(0.1193990140175382440036319283948474133266) }}, 
      {{ SC_(1.1800746917724609375), SC_(0.9048583669746933087439482567321779057712), SC_(0.09514163302530669125605174326782209422885) }}, 
      {{ SC_(1.20333766937255859375), SC_(0.9112027176275558226265541876273530718072), SC_(0.08879728237244417737344581237264692819278) }}, 
      {{ SC_(1.25640106201171875), SC_(0.924402044657034973439387794208329304664), SC_(0.07559795534296502656061220579167069533596) }}, 
      {{ SC_(1.27527332305908203125), SC_(0.9286916599172518912865347736903588888277), SC_(0.07130834008274810871346522630964111117231) }}, 
      {{ SC_(1.295307159423828125), SC_(0.9330248800657541920348036618074490968745), SC_(0.06697511993424580796519633819255090312553) }}, 
      {{ SC_(1.35011577606201171875), SC_(0.9437833069017625783094606605709502627745), SC_(0.05621669309823742169053933942904973722551) }}, 
      {{ SC_(1.3642253875732421875), SC_(0.9463071202862943362652946301000630969371), SC_(0.05369287971370566373470536989993690306286) }}, 
      {{ SC_(1.36428356170654296875), SC_(0.9463173268680031585168957431066720358209), SC_(0.05368267313199684148310425689332796417912) }}, 
      {{ SC_(1.3927154541015625), SC_(0.9511154338502067564077082935533756107928), SC_(0.04888456614979324359229170644662438920721) }}, 
      {{ SC_(1.4851818084716796875), SC_(0.9643031892104382293515834445221352837052), SC_(0.03569681078956177064841655547786471629478) }}, 
      {{ SC_(1.51205730438232421875), SC_(0.9675134325647516868759572291075083838452), SC_(0.03248656743524831312404277089249161615477) }}, 
      {{ SC_(1.518337249755859375), SC_(0.9682268650544353738887342889004292746917), SC_(0.03177313494556462611126571109957072530829) }}, 
      {{ SC_(1.63171100616455078125), SC_(0.9789779282245029251422213871074674302737), SC_(0.02102207177549707485777861289253256972629) }}, 
      {{ SC_(1.64548969268798828125), SC_(0.9800386644418555265242976627229641636655), SC_(0.0199613355581444734757023372770358363345) }}, 
      {{ SC_(1.6677036285400390625), SC_(0.9816505008209075157523253425835050946976), SC_(0.01834949917909248424767465741649490530242) }}, 
      {{ SC_(1.85671520233154296875), SC_(0.9913552328828875044489090206698996138703), SC_(0.008644767117112495551090979330100386129716) }}, 
      {{ SC_(1.9257602691650390625), SC_(0.9935393324839248670687761360401723108545), SC_(0.006460667516075132931223863959827689145547) }}, 
      {{ SC_(1.95288181304931640625), SC_(0.994251490289876205808362023378052652071), SC_(0.005748509710123794191637976621947347929005) }}, 
      {{ SC_(1.95960140228271484375), SC_(0.994416616212766790816043281256924957545), SC_(0.005583383787233209183956718743075042454991) }}, 
      {{ SC_(1.97496891021728515625), SC_(0.9947782798791369498659664217390766721303), SC_(0.005221720120863050134033578260923327869708) }}, 
      {{ SC_(2.0098972320556640625), SC_(0.9955228085136240355207293005308942804012), SC_(0.004477191486375964479270699469105719598846) }}, 
      {{ SC_(2.03814983367919921875), SC_(0.9960531548179094257423200852703746881917), SC_(0.003946845182090574257679914729625311808335) }}, 
      {{ SC_(2.117748260498046875), SC_(0.9972550864787919269607935067171569551311), SC_(0.002744913521208073039206493282843044868944) }}, 
      {{ SC_(2.1290187835693359375), SC_(0.9973951443272600509200163541924012381496), SC_(0.002604855672739949079983645807598761850375) }}, 
      {{ SC_(2.23621368408203125), SC_(0.9984357051823096237088846035455957333292), SC_(0.00156429481769037629111539645440426667076) }}, 
      {{ SC_(2.303375244140625), SC_(0.9988758768562388876948647459384863503014), SC_(0.001124123143761112305135254061513649698603) }}, 
      {{ SC_(2.30908966064453125), SC_(0.9989074670835471212637911004565234713734), SC_(0.001092532916452878736208899543476528626611) }}, 
      {{ SC_(2.312808990478515625), SC_(0.9989275848915122403637796954988403953277), SC_(0.001072415108487759636220304501159604672322) }}, 
      {{ SC_(2.34100818634033203125), SC_(0.9990693226518036651484626523819889432217), SC_(0.0009306773481963348515373476180110567783143) }}, 
      {{ SC_(2.3639354705810546875), SC_(0.9991715482831704962257608094466908648703), SC_(0.0008284517168295037742391905533091351296536) }}, 
      {{ SC_(2.38584804534912109375), SC_(0.999259421812066783311382896374381171103), SC_(0.0007405781879332166886171036256188288969614) }}, 
      {{ SC_(2.43149852752685546875), SC_(0.9994153951428661086310888659892606189344), SC_(0.0005846048571338913689111340107393810656404) }}, 
      {{ SC_(2.4652652740478515625), SC_(0.9995104528238484099433299313593918017795), SC_(0.0004895471761515900566700686406081982204819) }}, 
      {{ SC_(2.48156833648681640625), SC_(0.99955099523573386718480702374077607517), SC_(0.0004490047642661328151929762592239248300062) }}, 
      {{ SC_(2.4876461029052734375), SC_(0.9995652906194901943292532623705382603416), SC_(0.0004347093805098056707467376294617396584017) }}, 
      {{ SC_(2.49185085296630859375), SC_(0.9995749306249868850890104144222839530978), SC_(0.000425069375013114910989585577716046902164) }}, 
      {{ SC_(2.49247837066650390625), SC_(0.9995763520644124185897036893206316527169), SC_(0.0004236479355875814102963106793683472830707) }}, 
      {{ SC_(2.56191158294677734375), SC_(0.9997088956437770874696680503820402085636), SC_(0.000291104356222912530331949617959791436386) }}, 
      {{ SC_(2.61768817901611328125), SC_(0.9997860681867462115075444425791486024542), SC_(0.0002139318132537884924555574208513975457818) }}, 
      {{ SC_(2.70856189727783203125), SC_(0.9998721090543402843946579280477699469948), SC_(0.0001278909456597156053420719522300530052477) }}, 
      {{ SC_(2.8597621917724609375), SC_(0.9999475235569074621407329404065298036302), SC_(0.5247644309253785926705959347019636981165e-4) }}, 
      {{ SC_(2.87231540679931640625), SC_(0.9999513599726121814302460826437500121134), SC_(0.486400273878185697539173562499878865947e-4) }}, 
      {{ SC_(2.87524318695068359375), SC_(0.9999522156906622409531206227837709057555), SC_(0.4778430933775904687937721622909424451951e-4) }}, 
      {{ SC_(2.87711620330810546875), SC_(0.9999527556197749239828920225935109603346), SC_(0.4724438022507601710797740648903966540875e-4) }}, 
      {{ SC_(2.88459300994873046875), SC_(0.9999548538467674878672671151663947818517), SC_(0.451461532325121327328848336052181482513e-4) }}, 
      {{ SC_(2.88650608062744140625), SC_(0.9999553763394753402536287360321951606741), SC_(0.4462366052465974637126396780483932586128e-4) }}, 
      {{ SC_(2.901752471923828125), SC_(0.9999593401316765560335455180271069550107), SC_(0.4065986832344396645448197289304498930035e-4) }}, 
      {{ SC_(2.988407135009765625), SC_(0.9999762377681189955434156740468765476593), SC_(0.2376223188100445658432595312345234070632e-4) }}, 
      {{ SC_(3.02743244171142578125), SC_(0.9999814308884347491833058360756432747941), SC_(0.1856911156525081669416392435672520592555e-4) }}, 
      {{ SC_(3.1172580718994140625), SC_(0.9999895895910693287857223981230233990902), SC_(0.1041040893067121427760187697660090977657e-4) }}, 
      {{ SC_(3.12372589111328125), SC_(0.9999900204264126334086680667418726148844), SC_(0.9979573587366591331933258127385115606816e-5) }}, 
      {{ SC_(3.18522739410400390625), SC_(0.9999933499347420108074901348507827945904), SC_(0.6650065257989192509865149217205409606005e-5) }}, 
      {{ SC_(3.29238796234130859375), SC_(0.9999967780665854867942389973420946273526), SC_(0.3221933414513205761002657905372647420117e-5) }}, 
      {{ SC_(3.2967376708984375), SC_(0.9999968729159633477071268771660526947916), SC_(0.3127084036652292873122833947305208397749e-5) }}, 
      {{ SC_(3.3171443939208984375), SC_(0.9999972832708583409073345432090835972393), SC_(0.2716729141659092665456790916402760700865e-5) }}, 
      {{ SC_(3.34983730316162109375), SC_(0.999997835067334282029598175811562644485), SC_(0.2164932665717970401824188437355514979697e-5) }}, 
      {{ SC_(3.3712615966796875), SC_(0.9999981364410852287169607711094884146581), SC_(0.1863558914771283039228890511585341885627e-5) }}, 
      {{ SC_(3.37945270538330078125), SC_(0.9999982406531561474633390199540623493194), SC_(0.1759346843852536660980045937650680642258e-5) }}, 
      {{ SC_(3.457611083984375), SC_(0.999998990617699127730974245504433748246), SC_(0.1009382300872269025754495566251753996237e-5) }}, 
      {{ SC_(3.4955196380615234375), SC_(0.9999992323270584793476652090838719488337), SC_(0.7676729415206523347909161280511663428336e-6) }}, 
      {{ SC_(3.5278949737548828125), SC_(0.9999993936918195198146685207850760783309), SC_(0.6063081804801853314792149239216690531313e-6) }}, 
      {{ SC_(3.61342334747314453125), SC_(0.9999996781007930814251486740993849897074), SC_(0.3218992069185748513259006150102926275088e-6) }}, 
      {{ SC_(3.6264705657958984375), SC_(0.9999997081011520562826605602874202304177), SC_(0.2918988479437173394397125797695823038285e-6) }}, 
      {{ SC_(3.631275177001953125), SC_(0.9999997184533550254224618089830656023236), SC_(0.2815466449745775381910169343976763508771e-6) }}, 
      {{ SC_(3.68529415130615234375), SC_(0.9999998129758023803895471307314617042189), SC_(0.1870241976196104528692685382957810818761e-6) }}, 
      {{ SC_(3.70755863189697265625), SC_(0.9999998422528716665807398297179388578707), SC_(0.1577471283334192601702820611421293094744e-6) }}, 
      {{ SC_(3.7247791290283203125), SC_(0.9999998618060870277521151678834001759796), SC_(0.1381939129722478848321165998240204186296e-6) }}, 
      {{ SC_(3.85035610198974609375), SC_(0.9999999482602965422579575137240309686828), SC_(0.517397034577420424862759690313172362617e-7) }}, 
      {{ SC_(3.8901195526123046875), SC_(0.9999999623340564928678105257711087384931), SC_(0.3766594350713218947422889126150691316762e-7) }}, 
      {{ SC_(3.9150848388671875), SC_(0.9999999691892380022718296491207196532311), SC_(0.3081076199772817035087928034676891629959e-7) }}, 
      {{ SC_(3.97042560577392578125), SC_(0.9999999803471559662108676689373849556513), SC_(0.1965284403378913233106261504434869643474e-7) }}, 
      {{ SC_(3.9990558624267578125), SC_(0.9999999844623994226841345546976315715757), SC_(0.1553760057731586544530236842842427928529e-7) }}, 
      {{ SC_(4.0202732086181640625), SC_(0.9999999869588516313974107653969576328928), SC_(0.1304114836860258923460304236710719133298e-7) }}, 
      {{ SC_(4.059665679931640625), SC_(0.9999999906011039329440428181500764654351), SC_(0.9398896067055957181849923534564871471163e-8) }}, 
      {{ SC_(4.07498645782470703125), SC_(0.9999999917319758181060151635650756156136), SC_(0.826802418189398483643492438438638626357e-8) }}, 
      {{ SC_(4.0926380157470703125), SC_(0.9999999928712989950214740371563331235804), SC_(0.712870100497852596284366687641963609073e-8) }}, 
      {{ SC_(4.115203857421875), SC_(0.9999999941073845432394979591533284778705), SC_(0.5892615456760502040846671522129518138003e-8) }}, 
      {{ SC_(4.1200580596923828125), SC_(0.999999994344624655910219644297408134312), SC_(0.5655375344089780355702591865688007494418e-8) }}, 
      {{ SC_(4.1238422393798828125), SC_(0.9999999945230987630125942263956192615149), SC_(0.5476901236987405773604380738485137636205e-8) }}, 
      {{ SC_(4.18769931793212890625), SC_(0.999999996825324701191836773808018915496), SC_(0.3174675298808163226191981084503971517082e-8) }}, 
      {{ SC_(4.19874095916748046875), SC_(0.9999999971133285173570966406051015581972), SC_(0.2886671482642903359394898441802794211932e-8) }}, 
      {{ SC_(4.20690250396728515625), SC_(0.9999999973096908466694080193834019387566), SC_(0.2690309153330591980616598061243415309299e-8) }}, 
      {{ SC_(4.22000026702880859375), SC_(0.999999997597935669219902570917607920444), SC_(0.2402064330780097429082392079555956337119e-8) }}, 
      {{ SC_(4.24826908111572265625), SC_(0.9999999981212753683849542506366834896337), SC_(0.1878724631615045749363316510366333537567e-8) }}, 
      {{ SC_(4.38267421722412109375), SC_(0.9999999994282841249115685789971164547536), SC_(0.5717158750884314210028835452464447445326e-9) }}, 
      {{ SC_(4.39856719970703125), SC_(0.9999999995044692226766877552910187174272), SC_(0.4955307773233122447089812825728300182121e-9) }}, 
      {{ SC_(4.41140270233154296875), SC_(0.9999999995586805369524462894635438947331), SC_(0.4413194630475537105364561052668571821336e-9) }}, 
      {{ SC_(4.46236324310302734375), SC_(0.9999999997222859477763385026053465470885), SC_(0.2777140522236614973946534529114539167313e-9) }}, 
      {{ SC_(4.46667575836181640625), SC_(0.9999999997330229427656384209340139818838), SC_(0.2669770572343615790659860181161641325611e-9) }}, 
      {{ SC_(4.47502994537353515625), SC_(0.9999999997526814932597596604866425689186), SC_(0.2473185067402403395133574310814301241976e-9) }}, 
      {{ SC_(4.483638763427734375), SC_(0.999999999771458639310503189444558378199), SC_(0.2285413606894968105554416218009889101498e-9) }}, 
      {{ SC_(4.48403263092041015625), SC_(0.9999999997722835544847406994462153715198), SC_(0.2277164455152593005537846284801644209053e-9) }}, 
      {{ SC_(4.51054668426513671875), SC_(0.9999999998216079429645380731036969585483), SC_(0.1783920570354619268963030414516833989782e-9) }}, 
      {{ SC_(4.67531681060791015625), SC_(0.9999999999620572592624488052520567621063), SC_(0.3794274073755119474794323789371137879806e-10) }}, 
      {{ SC_(4.6975612640380859375), SC_(0.999999999969337756904297867060374000221), SC_(0.3066224309570213293962599977898805627251e-10) }}, 
      {{ SC_(4.7035999298095703125), SC_(0.9999999999710656528628511442036423007801), SC_(0.289343471371488557963576992198893036785e-10) }}, 
      {{ SC_(4.70855236053466796875), SC_(0.9999999999724112829756039222900224238312), SC_(0.2758871702439607770997757616876384504719e-10) }}, 
      {{ SC_(4.7173023223876953125), SC_(0.9999999999746405889607731362343521159649), SC_(0.2535941103922686376564788403511585907718e-10) }}, 
      {{ SC_(4.72319889068603515625), SC_(0.9999999999760424196780308137523103887781), SC_(0.2395758032196918624768961122193089155665e-10) }}, 
      {{ SC_(4.75647830963134765625), SC_(0.9999999999826417500285260584857944861917), SC_(0.1735824997147394151420551380832331628646e-10) }}, 
      {{ SC_(4.7578258514404296875), SC_(0.9999999999828675379559186553605097933328), SC_(0.1713246204408134463949020666719436603364e-10) }}, 
      {{ SC_(4.76685810089111328125), SC_(0.9999999999843084121078261289867881913554), SC_(0.1569158789217387101321180864461434335413e-10) }}, 
      {{ SC_(4.7696933746337890625), SC_(0.999999999984735725688693624461200005215), SC_(0.1526427431130637553879999478501051129862e-10) }}, 
      {{ SC_(4.7944507598876953125), SC_(0.9999999999880137552217601142622348550727), SC_(0.1198624477823988573776514492731315953542e-10) }}, 
      {{ SC_(4.8010959625244140625), SC_(0.9999999999887691458776479444900639126969), SC_(0.1123085412235205550993608730307459147162e-10) }}, 
      {{ SC_(4.8044872283935546875), SC_(0.9999999999891364693161538500903435641699), SC_(0.1086353068384614990965643583011596109973e-10) }}, 
      {{ SC_(4.81623363494873046875), SC_(0.999999999990320054976935784005315704344), SC_(0.9679945023064215994684295656048935330699e-11) }}, 
      {{ SC_(4.83378314971923828125), SC_(0.9999999999918566015822786881415506967502), SC_(0.8143398417721311858449303249839611412579e-11) }}, 
      {{ SC_(4.9204959869384765625), SC_(0.9999999999965640766819005108029784331824), SC_(0.3435923318099489197021566817649105671184e-11) }}, 
      {{ SC_(4.93080806732177734375), SC_(0.9999999999969022277087461656235776754241), SC_(0.3097772291253834376422324575851562900089e-11) }}, 
      {{ SC_(4.9461956024169921875), SC_(0.9999999999973469736805588663004234322273), SC_(0.2653026319441133699576567772727096047411e-11) }}, 
      {{ SC_(4.95575237274169921875), SC_(0.9999999999975909997954754364337223859339), SC_(0.2409000204524563566277614066144810071518e-11) }}, 
      {{ SC_(4.98528766632080078125), SC_(0.9999999999982141805054615991904787167496), SC_(0.1785819494538400809521283250366820400389e-11) }}, 
      {{ SC_(4.98998355865478515625), SC_(0.9999999999982974491525865962396432033197), SC_(0.1702550847413403760356796680337710810069e-11) }}, 
      {{ SC_(5.02855682373046875), SC_(0.9999999999988517264956378980619258324192), SC_(0.1148273504362101938074167580787042639038e-11) }}, 
      {{ SC_(5.03557872772216796875), SC_(0.9999999999989315115047508105969225357869), SC_(0.1068488495249189403077464213064479671328e-11) }}, 
      {{ SC_(5.0523052215576171875), SC_(0.9999999999991002937379749143926146803551), SC_(0.8997062620250856073853196449004253366533e-12) }}, 
      {{ SC_(5.07685184478759765625), SC_(0.9999999999993016238951734186597928920516), SC_(0.6983761048265813402071079483580106775973e-12) }}, 
      {{ SC_(5.08204364776611328125), SC_(0.9999999999993381566276206363690381882733), SC_(0.6618433723793636309618117267347844272082e-12) }}, 
      {{ SC_(5.13345241546630859375), SC_(0.999999999999612331260405493647794650402), SC_(0.3876687395945063522053495979737659683032e-12) }}, 
      {{ SC_(5.1391048431396484375), SC_(0.999999999999634588517990564238879426641), SC_(0.3654114820094357611205733589988913877604e-12) }}, 
      {{ SC_(5.13993549346923828125), SC_(0.9999999999996377517440695332277429140254), SC_(0.3622482559304667722570859745677578023379e-12) }}, 
      {{ SC_(5.15045261383056640625), SC_(0.9999999999996755500658564562474091399993), SC_(0.3244499341435437525908600006936606245925e-12) }}, 
      {{ SC_(5.16167926788330078125), SC_(0.9999999999997116260010072844300443598171), SC_(0.2883739989927155699556401829053926593583e-12) }}, 
      {{ SC_(5.17528629302978515625), SC_(0.9999999999997501000542008628351256583835), SC_(0.2498999457991371648743416165426368804179e-12) }}, 
      {{ SC_(5.1753253936767578125), SC_(0.9999999999997502029947677817117184848968), SC_(0.2497970052322182882815151031630978773029e-12) }}, 
      {{ SC_(5.2130718231201171875), SC_(0.9999999999998324127754807945970261376527), SC_(0.1675872245192054029738623472857515088274e-12) }}, 
      {{ SC_(5.29325771331787109375), SC_(0.9999999999999288856738052204016145340166), SC_(0.7111432619477959838546598339183116790691e-13) }}, 
      {{ SC_(5.2994289398193359375), SC_(0.9999999999999334607492711678557262715706), SC_(0.665392507288321442737284293716776963984e-13) }}, 
      {{ SC_(5.36013698577880859375), SC_(0.9999999999999655451494392296744414479568), SC_(0.344548505607703255585520432106041683721e-13) }}, 
      {{ SC_(5.45147609710693359375), SC_(0.9999999999999873739267894844232513365118), SC_(0.1262607321051557674866348821792628557972e-13) }}, 
      {{ SC_(5.50894069671630859375), SC_(0.9999999999999933423585918075134713785513), SC_(0.6657641408192486528621448736888188965298e-14) }}, 
      {{ SC_(5.57548427581787109375), SC_(0.9999999999999968527672544482246160644115), SC_(0.314723274555177538393558852118569471685e-14) }}, 
      {{ SC_(5.5860691070556640625), SC_(0.9999999999999972086083536154872247664216), SC_(0.2791391646384512775233578379487718997086e-14) }}, 
      {{ SC_(5.64849758148193359375), SC_(0.9999999999999986305669378936272102876212), SC_(0.136943306210637278971237882925180230156e-14) }}, 
      {{ SC_(5.67121601104736328125), SC_(0.9999999999999989452188942213501238951865), SC_(0.1054781105778649876104813506873549674391e-14) }}, 
      {{ SC_(5.6940021514892578125), SC_(0.9999999999999991890350782086923335431393), SC_(0.8109649217913076664568606728738587613782e-15) }}, 
      {{ SC_(5.8028507232666015625), SC_(0.9999999999999997722139370566709142078876), SC_(0.2277860629433290857921123973267448027079e-15) }}, 
      {{ SC_(5.89911556243896484375), SC_(0.9999999999999999273310114171591943570055), SC_(0.7266898858284080564299449379332489531228e-16) }}, 
      {{ SC_(5.90867519378662109375), SC_(0.9999999999999999351899407560267583020934), SC_(0.6481005924397324169790663469831296572444e-16) }}, 
      {{ SC_(5.92298793792724609375), SC_(0.9999999999999999454148146455550046656746), SC_(0.5458518535444499533432536380511720243893e-16) }}, 
      {{ SC_(5.95886135101318359375), SC_(0.9999999999999999645670653382102726138283), SC_(0.3543293466178972738617174425389934295203e-16) }}, 
      {{ SC_(6.0150852203369140625), SC_(0.9999999999999999820915182893228664770405), SC_(0.1790848171067713352295947212902047549442e-16) }}, 
      {{ SC_(6.02811908721923828125), SC_(0.9999999999999999847253231421033886323739), SC_(0.1527467685789661136762605508631698629412e-16) }}, 
      {{ SC_(6.037822723388671875), SC_(0.9999999999999999864342825303533563325582), SC_(0.1356571746964664366744180012364556731983e-16) }}, 
      {{ SC_(6.05489063262939453125), SC_(0.9999999999999999889944678766415576341472), SC_(0.1100553212335844236585283710674808407408e-16) }}, 
      {{ SC_(6.1759700775146484375), SC_(0.9999999999999999975448452162650769292541), SC_(0.245515478373492307074589212037218914569e-17) }}, 
      {{ SC_(6.20361804962158203125), SC_(0.9999999999999999982640371408095169271104), SC_(0.1735962859190483072889644262633920675422e-17) }}, 
      {{ SC_(6.254451751708984375), SC_(0.9999999999999999990857858792087275530364), SC_(0.9142141207912724469636044315135167092246e-18) }}, 
      {{ SC_(6.4008617401123046875), SC_(0.999999999999999999859864992644041031821), SC_(0.1401350073559589681790226673644335192431e-18) }}, 
      {{ SC_(6.40293121337890625), SC_(0.9999999999999999998635724949753329988618), SC_(0.1364275050246670011381531339230014520635e-18) }}, 
      {{ SC_(6.44345760345458984375), SC_(0.9999999999999999999194393258289466407135), SC_(0.805606741710533592864585458434444068011e-19) }}, 
      {{ SC_(6.47809505462646484375), SC_(0.9999999999999999999487763610108722858332), SC_(0.5122363898912771416675345659572395374372e-19) }}, 
      {{ SC_(6.49267101287841796875), SC_(0.9999999999999999999576934136067901865991), SC_(0.423065863932098134009397058320083027927e-19) }}, 
      {{ SC_(6.5178356170654296875), SC_(0.9999999999999999999696208471565094820618), SC_(0.3037915284349051793818500085981039089403e-19) }}, 
      {{ SC_(6.53493785858154296875), SC_(0.9999999999999999999757610063637445566877), SC_(0.2423899363625544331226481168890701986164e-19) }}, 
      {{ SC_(6.56903934478759765625), SC_(0.9999999999999999999845747232345600776473), SC_(0.1542527676543992235266715952300598475537e-19) }}, 
      {{ SC_(6.57036113739013671875), SC_(0.9999999999999999999848432925940364693913), SC_(0.1515670740596353060870931696674263406445e-19) }}, 
      {{ SC_(6.6012401580810546875), SC_(0.9999999999999999999899544411087670709063), SC_(0.1004555889123292909367535592918549282524e-19) }}, 
      {{ SC_(6.6133975982666015625), SC_(0.9999999999999999999914607396914475599695), SC_(0.8539260308552440030489025187766437033893e-20) }}, 
      {{ SC_(6.614013671875), SC_(0.9999999999999999999915308157266726582396), SC_(0.846918427332734176038950311387000199938e-20) }}, 
      {{ SC_(6.65176868438720703125), SC_(0.9999999999999999999948960492295407549616), SC_(0.5103950770459245038373864424994355232744e-20) }}, 
      {{ SC_(6.67388629913330078125), SC_(0.9999999999999999999962112561597774386166), SC_(0.3788743840222561383427898405609521135209e-20) }}, 
      {{ SC_(6.675098419189453125), SC_(0.9999999999999999999962727294431245722943), SC_(0.3727270556875427705686833997971476711389e-20) }}, 
      {{ SC_(6.73399639129638671875), SC_(0.9999999999999999999983224938408648373451), SC_(0.1677506159135162654937097106857586013789e-20) }}, 
      {{ SC_(6.774074554443359375), SC_(0.9999999999999999999990294388848823039468), SC_(0.9705611151176960532165924022124182051181e-21) }}, 
      {{ SC_(6.839885711669921875), SC_(0.9999999999999999999996075324506377418898), SC_(0.3924675493622581101992853509398975667702e-21) }}, 
      {{ SC_(6.86166667938232421875), SC_(0.9999999999999999999997097026235625653255), SC_(0.2902973764374346745366897115310349140629e-21) }}, 
      {{ SC_(6.86821842193603515625), SC_(0.9999999999999999999997349241430742071849), SC_(0.2650758569257928151403169457718795390422e-21) }}, 
      {{ SC_(6.87017536163330078125), SC_(0.9999999999999999999997420278370314862565), SC_(0.2579721629685137435110698159577792881e-21) }}, 
      {{ SC_(6.9438915252685546875), SC_(0.999999999999999999999907789706111134148), SC_(0.9221029388886585196730336935045033388208e-22) }}, 
      {{ SC_(6.94417095184326171875), SC_(0.9999999999999999999999081504757103419795), SC_(0.9184952428965802049788611864563591946226e-22) }}, 
      {{ SC_(7.02402496337890625), SC_(0.999999999999999999999970229303356580071), SC_(0.2977069664341992903453738993900401285503e-22) }}, 
      {{ SC_(7.04118442535400390625), SC_(0.9999999999999999999999766690647347813976), SC_(0.2333093526521860243876854475410979262103e-22) }}, 
      {{ SC_(7.0728092193603515625), SC_(0.9999999999999999999999851346580378971058), SC_(0.1486534196210289422461831541803890066821e-22) }}, 
      {{ SC_(7.11659526824951171875), SC_(0.9999999999999999999999920618538775044464), SC_(0.7938146122495553642615968497016709781571e-23) }}, 
      {{ SC_(7.18280124664306640625), SC_(0.9999999999999999999999969477254268593726), SC_(0.3052274573140627399432973240733715500213e-23) }}, 
      {{ SC_(7.20355319976806640625), SC_(0.9999999999999999999999977419301284355623), SC_(0.2258069871564437709331260570315365949665e-23) }}, 
      {{ SC_(7.27909374237060546875), SC_(0.9999999999999999999999992515556916792261), SC_(0.7484443083207738734503483608935021035732e-24) }}, 
      {{ SC_(7.28028106689453125), SC_(0.9999999999999999999999992645004451770347), SC_(0.7354995548229653146869970523781527988642e-24) }}, 
      {{ SC_(7.298152923583984375), SC_(0.9999999999999999999999994345631928770567), SC_(0.5654368071229432894992332067407147179749e-24) }}, 
      {{ SC_(7.31467151641845703125), SC_(0.9999999999999999999999995568116259996168), SC_(0.4431883740003831823890539135951501761503e-24) }}, 
      {{ SC_(7.32010936737060546875), SC_(0.9999999999999999999999995910130381669911), SC_(0.4089869618330089157685151201949087925479e-24) }}, 
      {{ SC_(7.34866237640380859375), SC_(0.9999999999999999999999997319906448357093), SC_(0.268009355164290673339087031887057715089e-24) }}, 
      {{ SC_(7.351879119873046875), SC_(0.9999999999999999999999997444791197223142), SC_(0.2555208802776857586959896180952785091403e-24) }}, 
      {{ SC_(7.35590362548828125), SC_(0.9999999999999999999999997592943074733691), SC_(0.2407056925266308623391590746789683246709e-24) }}, 
      {{ SC_(7.390369415283203125), SC_(0.9999999999999999999999998558663763263787), SC_(0.1441336236736213391389793807586759175995e-24) }}, 
      {{ SC_(7.43821620941162109375), SC_(0.9999999999999999999999999295502581038212), SC_(0.7044974189617879705218727765406635153304e-25) }}, 
      {{ SC_(7.43946170806884765625), SC_(0.9999999999999999999999999308550578406467), SC_(0.6914494215935333790398074475111218230458e-25) }}, 
      {{ SC_(7.48311901092529296875), SC_(0.999999999999999999999999964163218913179), SC_(0.3583678108682102561152351850893798856277e-25) }}, 
      {{ SC_(7.49824619293212890625), SC_(0.9999999999999999999999999714868908856129), SC_(0.2851310911438713788012919629820992423858e-25) }}, 
      {{ SC_(7.50188446044921875), SC_(0.9999999999999999999999999730141507157818), SC_(0.2698584928421822020035304290073321597406e-25) }}, 
      {{ SC_(7.52948474884033203125), SC_(0.9999999999999999999999999822420651220879), SC_(0.1775793487791212989839150755243583008096e-25) }}, 
      {{ SC_(7.6320323944091796875), SC_(0.9999999999999999999999999962984458271673), SC_(0.3701554172832712513006017529906907914499e-26) }}, 
      {{ SC_(7.6759738922119140625), SC_(0.9999999999999999999999999981215459672183), SC_(0.1878454032781689292876320094611621328422e-26) }}, 
      {{ SC_(7.67881011962890625), SC_(0.999999999999999999999999998202249704333), SC_(0.1797750295667047232713633441478606640198e-26) }}, 
      {{ SC_(7.69775485992431640625), SC_(0.9999999999999999999999999986598159749852), SC_(0.1340184025014838921678286365792744470017e-26) }}, 
      {{ SC_(7.70757007598876953125), SC_(0.9999999999999999999999999988493273258458), SC_(0.1150672674154231530685408186230565876878e-26) }}, 
      {{ SC_(7.71776866912841796875), SC_(0.9999999999999999999999999990181051135537), SC_(0.9818948864462603043818495768683861311821e-27) }}, 
      {{ SC_(7.79935359954833984375), SC_(0.9999999999999999999999999997259876414039), SC_(0.2740123585961319556857387807076098785701e-27) }}, 
      {{ SC_(7.81407070159912109375), SC_(0.9999999999999999999999999997826446873284), SC_(0.2173553126715507615629930753265485721298e-27) }}, 
      {{ SC_(7.81634521484375), SC_(0.9999999999999999999999999997902963473516), SC_(0.209703652648431358354620963217352346183e-27) }}, 
      {{ SC_(7.84175968170166015625), SC_(0.9999999999999999999999999998595912638039), SC_(0.1404087361960659424532579514219630734144e-27) }}, 
      {{ SC_(7.88610076904296875), SC_(0.9999999999999999999999999999304798650663), SC_(0.6952013493370366965787168537834557597352e-28) }}, 
      {{ SC_(7.89655590057373046875), SC_(0.9999999999999999999999999999411317291543), SC_(0.5886827084565561878281328421149862522402e-28) }}, 
      {{ SC_(7.9050960540771484375), SC_(0.9999999999999999999999999999486179207741), SC_(0.513820792259039401977061154556515432295e-28) }}, 
      {{ SC_(7.93815517425537109375), SC_(0.9999999999999999999999999999696918627742), SC_(0.3030813722580726383815315462367670870671e-28) }}, 
      {{ SC_(7.94338130950927734375), SC_(0.9999999999999999999999999999721239170155), SC_(0.2787608298449905464917225531595312562447e-28) }}
   } };
