/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/*
 * Derived from the IANA language subtag registry by genLanguageTagList.pl.
 *
 * Created on Mon Nov  7 14:52:44 2011.
 *
 * * * * * This file contains MACHINE-GENERATED DATA, do not edit! * * * * *
 */

// Based on IANA registry dated 2011-08-25

static const PRUint32 sLanguageTagList[] = {
  TRUETYPE_TAG('a','a', 0 , 0 ), // aa = Afar
  TRUETYPE_TAG('a','b', 0 , 0 ), // ab = Abkhazian
  TRUETYPE_TAG('a','e', 0 , 0 ), // ae = Avestan
  TRUETYPE_TAG('a','f', 0 , 0 ), // af = Afrikaans
  TRUETYPE_TAG('a','k', 0 , 0 ), // ak = Akan
  TRUETYPE_TAG('a','m', 0 , 0 ), // am = Amharic
  TRUETYPE_TAG('a','n', 0 , 0 ), // an = Aragonese
  TRUETYPE_TAG('a','r', 0 , 0 ), // ar = Arabic
  TRUETYPE_TAG('a','s', 0 , 0 ), // as = Assamese
  TRUETYPE_TAG('a','v', 0 , 0 ), // av = Avaric
  TRUETYPE_TAG('a','y', 0 , 0 ), // ay = Aymara
  TRUETYPE_TAG('a','z', 0 , 0 ), // az = Azerbaijani
  TRUETYPE_TAG('b','a', 0 , 0 ), // ba = Bashkir
  TRUETYPE_TAG('b','e', 0 , 0 ), // be = Belarusian
  TRUETYPE_TAG('b','g', 0 , 0 ), // bg = Bulgarian
  TRUETYPE_TAG('b','h', 0 , 0 ), // bh = Bihari languages
  TRUETYPE_TAG('b','i', 0 , 0 ), // bi = Bislama
  TRUETYPE_TAG('b','m', 0 , 0 ), // bm = Bambara
  TRUETYPE_TAG('b','n', 0 , 0 ), // bn = Bengali
  TRUETYPE_TAG('b','o', 0 , 0 ), // bo = Tibetan
  TRUETYPE_TAG('b','r', 0 , 0 ), // br = Breton
  TRUETYPE_TAG('b','s', 0 , 0 ), // bs = Bosnian
  TRUETYPE_TAG('c','a', 0 , 0 ), // ca = Catalan
  TRUETYPE_TAG('c','e', 0 , 0 ), // ce = Chechen
  TRUETYPE_TAG('c','h', 0 , 0 ), // ch = Chamorro
  TRUETYPE_TAG('c','o', 0 , 0 ), // co = Corsican
  TRUETYPE_TAG('c','r', 0 , 0 ), // cr = Cree
  TRUETYPE_TAG('c','s', 0 , 0 ), // cs = Czech
  TRUETYPE_TAG('c','u', 0 , 0 ), // cu = Church Slavic
  TRUETYPE_TAG('c','v', 0 , 0 ), // cv = Chuvash
  TRUETYPE_TAG('c','y', 0 , 0 ), // cy = Welsh
  TRUETYPE_TAG('d','a', 0 , 0 ), // da = Danish
  TRUETYPE_TAG('d','e', 0 , 0 ), // de = German
  TRUETYPE_TAG('d','v', 0 , 0 ), // dv = Dhivehi
  TRUETYPE_TAG('d','z', 0 , 0 ), // dz = Dzongkha
  TRUETYPE_TAG('e','e', 0 , 0 ), // ee = Ewe
  TRUETYPE_TAG('e','l', 0 , 0 ), // el = Modern Greek (1453-)
  TRUETYPE_TAG('e','n', 0 , 0 ), // en = English
  TRUETYPE_TAG('e','o', 0 , 0 ), // eo = Esperanto
  TRUETYPE_TAG('e','s', 0 , 0 ), // es = Spanish
  TRUETYPE_TAG('e','t', 0 , 0 ), // et = Estonian
  TRUETYPE_TAG('e','u', 0 , 0 ), // eu = Basque
  TRUETYPE_TAG('f','a', 0 , 0 ), // fa = Persian
  TRUETYPE_TAG('f','f', 0 , 0 ), // ff = Fulah
  TRUETYPE_TAG('f','i', 0 , 0 ), // fi = Finnish
  TRUETYPE_TAG('f','j', 0 , 0 ), // fj = Fijian
  TRUETYPE_TAG('f','o', 0 , 0 ), // fo = Faroese
  TRUETYPE_TAG('f','r', 0 , 0 ), // fr = French
  TRUETYPE_TAG('f','y', 0 , 0 ), // fy = Western Frisian
  TRUETYPE_TAG('g','a', 0 , 0 ), // ga = Irish
  TRUETYPE_TAG('g','d', 0 , 0 ), // gd = Scottish Gaelic
  TRUETYPE_TAG('g','l', 0 , 0 ), // gl = Galician
  TRUETYPE_TAG('g','n', 0 , 0 ), // gn = Guarani
  TRUETYPE_TAG('g','u', 0 , 0 ), // gu = Gujarati
  TRUETYPE_TAG('g','v', 0 , 0 ), // gv = Manx
  TRUETYPE_TAG('h','a', 0 , 0 ), // ha = Hausa
  TRUETYPE_TAG('h','e', 0 , 0 ), // he = Hebrew
  TRUETYPE_TAG('h','i', 0 , 0 ), // hi = Hindi
  TRUETYPE_TAG('h','o', 0 , 0 ), // ho = Hiri Motu
  TRUETYPE_TAG('h','r', 0 , 0 ), // hr = Croatian
  TRUETYPE_TAG('h','t', 0 , 0 ), // ht = Haitian
  TRUETYPE_TAG('h','u', 0 , 0 ), // hu = Hungarian
  TRUETYPE_TAG('h','y', 0 , 0 ), // hy = Armenian
  TRUETYPE_TAG('h','z', 0 , 0 ), // hz = Herero
  TRUETYPE_TAG('i','a', 0 , 0 ), // ia = Interlingua (International Auxiliary Language
  TRUETYPE_TAG('i','d', 0 , 0 ), // id = Indonesian
  TRUETYPE_TAG('i','e', 0 , 0 ), // ie = Interlingue
  TRUETYPE_TAG('i','g', 0 , 0 ), // ig = Igbo
  TRUETYPE_TAG('i','i', 0 , 0 ), // ii = Sichuan Yi
  TRUETYPE_TAG('i','k', 0 , 0 ), // ik = Inupiaq
  TRUETYPE_TAG('i','n', 0 , 0 ), // in = Indonesian
  TRUETYPE_TAG('i','o', 0 , 0 ), // io = Ido
  TRUETYPE_TAG('i','s', 0 , 0 ), // is = Icelandic
  TRUETYPE_TAG('i','t', 0 , 0 ), // it = Italian
  TRUETYPE_TAG('i','u', 0 , 0 ), // iu = Inuktitut
  TRUETYPE_TAG('i','w', 0 , 0 ), // iw = Hebrew
  TRUETYPE_TAG('j','a', 0 , 0 ), // ja = Japanese
  TRUETYPE_TAG('j','i', 0 , 0 ), // ji = Yiddish
  TRUETYPE_TAG('j','v', 0 , 0 ), // jv = Javanese
  TRUETYPE_TAG('j','w', 0 , 0 ), // jw = Javanese
  TRUETYPE_TAG('k','a', 0 , 0 ), // ka = Georgian
  TRUETYPE_TAG('k','g', 0 , 0 ), // kg = Kongo
  TRUETYPE_TAG('k','i', 0 , 0 ), // ki = Kikuyu
  TRUETYPE_TAG('k','j', 0 , 0 ), // kj = Kuanyama
  TRUETYPE_TAG('k','k', 0 , 0 ), // kk = Kazakh
  TRUETYPE_TAG('k','l', 0 , 0 ), // kl = Kalaallisut
  TRUETYPE_TAG('k','m', 0 , 0 ), // km = Central Khmer
  TRUETYPE_TAG('k','n', 0 , 0 ), // kn = Kannada
  TRUETYPE_TAG('k','o', 0 , 0 ), // ko = Korean
  TRUETYPE_TAG('k','r', 0 , 0 ), // kr = Kanuri
  TRUETYPE_TAG('k','s', 0 , 0 ), // ks = Kashmiri
  TRUETYPE_TAG('k','u', 0 , 0 ), // ku = Kurdish
  TRUETYPE_TAG('k','v', 0 , 0 ), // kv = Komi
  TRUETYPE_TAG('k','w', 0 , 0 ), // kw = Cornish
  TRUETYPE_TAG('k','y', 0 , 0 ), // ky = Kirghiz
  TRUETYPE_TAG('l','a', 0 , 0 ), // la = Latin
  TRUETYPE_TAG('l','b', 0 , 0 ), // lb = Luxembourgish
  TRUETYPE_TAG('l','g', 0 , 0 ), // lg = Ganda
  TRUETYPE_TAG('l','i', 0 , 0 ), // li = Limburgan
  TRUETYPE_TAG('l','n', 0 , 0 ), // ln = Lingala
  TRUETYPE_TAG('l','o', 0 , 0 ), // lo = Lao
  TRUETYPE_TAG('l','t', 0 , 0 ), // lt = Lithuanian
  TRUETYPE_TAG('l','u', 0 , 0 ), // lu = Luba-Katanga
  TRUETYPE_TAG('l','v', 0 , 0 ), // lv = Latvian
  TRUETYPE_TAG('m','g', 0 , 0 ), // mg = Malagasy
  TRUETYPE_TAG('m','h', 0 , 0 ), // mh = Marshallese
  TRUETYPE_TAG('m','i', 0 , 0 ), // mi = Maori
  TRUETYPE_TAG('m','k', 0 , 0 ), // mk = Macedonian
  TRUETYPE_TAG('m','l', 0 , 0 ), // ml = Malayalam
  TRUETYPE_TAG('m','n', 0 , 0 ), // mn = Mongolian
  TRUETYPE_TAG('m','o', 0 , 0 ), // mo = Moldavian
  TRUETYPE_TAG('m','r', 0 , 0 ), // mr = Marathi
  TRUETYPE_TAG('m','s', 0 , 0 ), // ms = Malay (macrolanguage)
  TRUETYPE_TAG('m','t', 0 , 0 ), // mt = Maltese
  TRUETYPE_TAG('m','y', 0 , 0 ), // my = Burmese
  TRUETYPE_TAG('n','a', 0 , 0 ), // na = Nauru
  TRUETYPE_TAG('n','b', 0 , 0 ), // nb = Norwegian Bokmål
  TRUETYPE_TAG('n','d', 0 , 0 ), // nd = North Ndebele
  TRUETYPE_TAG('n','e', 0 , 0 ), // ne = Nepali
  TRUETYPE_TAG('n','g', 0 , 0 ), // ng = Ndonga
  TRUETYPE_TAG('n','l', 0 , 0 ), // nl = Dutch
  TRUETYPE_TAG('n','n', 0 , 0 ), // nn = Norwegian Nynorsk
  TRUETYPE_TAG('n','o', 0 , 0 ), // no = Norwegian
  TRUETYPE_TAG('n','r', 0 , 0 ), // nr = South Ndebele
  TRUETYPE_TAG('n','v', 0 , 0 ), // nv = Navajo
  TRUETYPE_TAG('n','y', 0 , 0 ), // ny = Nyanja
  TRUETYPE_TAG('o','c', 0 , 0 ), // oc = Occitan (post 1500)
  TRUETYPE_TAG('o','j', 0 , 0 ), // oj = Ojibwa
  TRUETYPE_TAG('o','m', 0 , 0 ), // om = Oromo
  TRUETYPE_TAG('o','r', 0 , 0 ), // or = Oriya
  TRUETYPE_TAG('o','s', 0 , 0 ), // os = Ossetian
  TRUETYPE_TAG('p','a', 0 , 0 ), // pa = Panjabi
  TRUETYPE_TAG('p','i', 0 , 0 ), // pi = Pali
  TRUETYPE_TAG('p','l', 0 , 0 ), // pl = Polish
  TRUETYPE_TAG('p','s', 0 , 0 ), // ps = Pushto
  TRUETYPE_TAG('p','t', 0 , 0 ), // pt = Portuguese
  TRUETYPE_TAG('q','u', 0 , 0 ), // qu = Quechua
  TRUETYPE_TAG('r','m', 0 , 0 ), // rm = Romansh
  TRUETYPE_TAG('r','n', 0 , 0 ), // rn = Rundi
  TRUETYPE_TAG('r','o', 0 , 0 ), // ro = Romanian
  TRUETYPE_TAG('r','u', 0 , 0 ), // ru = Russian
  TRUETYPE_TAG('r','w', 0 , 0 ), // rw = Kinyarwanda
  TRUETYPE_TAG('s','a', 0 , 0 ), // sa = Sanskrit
  TRUETYPE_TAG('s','c', 0 , 0 ), // sc = Sardinian
  TRUETYPE_TAG('s','d', 0 , 0 ), // sd = Sindhi
  TRUETYPE_TAG('s','e', 0 , 0 ), // se = Northern Sami
  TRUETYPE_TAG('s','g', 0 , 0 ), // sg = Sango
  TRUETYPE_TAG('s','h', 0 , 0 ), // sh = Serbo-Croatian
  TRUETYPE_TAG('s','i', 0 , 0 ), // si = Sinhala
  TRUETYPE_TAG('s','k', 0 , 0 ), // sk = Slovak
  TRUETYPE_TAG('s','l', 0 , 0 ), // sl = Slovenian
  TRUETYPE_TAG('s','m', 0 , 0 ), // sm = Samoan
  TRUETYPE_TAG('s','n', 0 , 0 ), // sn = Shona
  TRUETYPE_TAG('s','o', 0 , 0 ), // so = Somali
  TRUETYPE_TAG('s','q', 0 , 0 ), // sq = Albanian
  TRUETYPE_TAG('s','r', 0 , 0 ), // sr = Serbian
  TRUETYPE_TAG('s','s', 0 , 0 ), // ss = Swati
  TRUETYPE_TAG('s','t', 0 , 0 ), // st = Southern Sotho
  TRUETYPE_TAG('s','u', 0 , 0 ), // su = Sundanese
  TRUETYPE_TAG('s','v', 0 , 0 ), // sv = Swedish
  TRUETYPE_TAG('s','w', 0 , 0 ), // sw = Swahili (macrolanguage)
  TRUETYPE_TAG('t','a', 0 , 0 ), // ta = Tamil
  TRUETYPE_TAG('t','e', 0 , 0 ), // te = Telugu
  TRUETYPE_TAG('t','g', 0 , 0 ), // tg = Tajik
  TRUETYPE_TAG('t','h', 0 , 0 ), // th = Thai
  TRUETYPE_TAG('t','i', 0 , 0 ), // ti = Tigrinya
  TRUETYPE_TAG('t','k', 0 , 0 ), // tk = Turkmen
  TRUETYPE_TAG('t','l', 0 , 0 ), // tl = Tagalog
  TRUETYPE_TAG('t','n', 0 , 0 ), // tn = Tswana
  TRUETYPE_TAG('t','o', 0 , 0 ), // to = Tonga (Tonga Islands)
  TRUETYPE_TAG('t','r', 0 , 0 ), // tr = Turkish
  TRUETYPE_TAG('t','s', 0 , 0 ), // ts = Tsonga
  TRUETYPE_TAG('t','t', 0 , 0 ), // tt = Tatar
  TRUETYPE_TAG('t','w', 0 , 0 ), // tw = Twi
  TRUETYPE_TAG('t','y', 0 , 0 ), // ty = Tahitian
  TRUETYPE_TAG('u','g', 0 , 0 ), // ug = Uighur
  TRUETYPE_TAG('u','k', 0 , 0 ), // uk = Ukrainian
  TRUETYPE_TAG('u','r', 0 , 0 ), // ur = Urdu
  TRUETYPE_TAG('u','z', 0 , 0 ), // uz = Uzbek
  TRUETYPE_TAG('v','e', 0 , 0 ), // ve = Venda
  TRUETYPE_TAG('v','i', 0 , 0 ), // vi = Vietnamese
  TRUETYPE_TAG('v','o', 0 , 0 ), // vo = Volapük
  TRUETYPE_TAG('w','a', 0 , 0 ), // wa = Walloon
  TRUETYPE_TAG('w','o', 0 , 0 ), // wo = Wolof
  TRUETYPE_TAG('x','h', 0 , 0 ), // xh = Xhosa
  TRUETYPE_TAG('y','i', 0 , 0 ), // yi = Yiddish
  TRUETYPE_TAG('y','o', 0 , 0 ), // yo = Yoruba
  TRUETYPE_TAG('z','a', 0 , 0 ), // za = Zhuang
  TRUETYPE_TAG('z','h', 0 , 0 ), // zh = Chinese
  TRUETYPE_TAG('z','u', 0 , 0 ), // zu = Zulu
  TRUETYPE_TAG('a','a','a', 0 ), // aaa = Ghotuo
  TRUETYPE_TAG('a','a','b', 0 ), // aab = Alumu-Tesu
  TRUETYPE_TAG('a','a','c', 0 ), // aac = Ari
  TRUETYPE_TAG('a','a','d', 0 ), // aad = Amal
  TRUETYPE_TAG('a','a','e', 0 ), // aae = Arbëreshë Albanian
  TRUETYPE_TAG('a','a','f', 0 ), // aaf = Aranadan
  TRUETYPE_TAG('a','a','g', 0 ), // aag = Ambrak
  TRUETYPE_TAG('a','a','h', 0 ), // aah = Abu' Arapesh
  TRUETYPE_TAG('a','a','i', 0 ), // aai = Arifama-Miniafia
  TRUETYPE_TAG('a','a','k', 0 ), // aak = Ankave
  TRUETYPE_TAG('a','a','l', 0 ), // aal = Afade
  TRUETYPE_TAG('a','a','m', 0 ), // aam = Aramanik
  TRUETYPE_TAG('a','a','n', 0 ), // aan = Anambé
  TRUETYPE_TAG('a','a','o', 0 ), // aao = Algerian Saharan Arabic
  TRUETYPE_TAG('a','a','p', 0 ), // aap = Pará Arára
  TRUETYPE_TAG('a','a','q', 0 ), // aaq = Eastern Abnaki
  TRUETYPE_TAG('a','a','s', 0 ), // aas = Aasáx
  TRUETYPE_TAG('a','a','t', 0 ), // aat = Arvanitika Albanian
  TRUETYPE_TAG('a','a','u', 0 ), // aau = Abau
  TRUETYPE_TAG('a','a','v', 0 ), // aav = Austro-Asiatic languages
  TRUETYPE_TAG('a','a','w', 0 ), // aaw = Solong
  TRUETYPE_TAG('a','a','x', 0 ), // aax = Mandobo Atas
  TRUETYPE_TAG('a','a','z', 0 ), // aaz = Amarasi
  TRUETYPE_TAG('a','b','a', 0 ), // aba = Abé
  TRUETYPE_TAG('a','b','b', 0 ), // abb = Bankon
  TRUETYPE_TAG('a','b','c', 0 ), // abc = Ambala Ayta
  TRUETYPE_TAG('a','b','d', 0 ), // abd = Manide
  TRUETYPE_TAG('a','b','e', 0 ), // abe = Western Abnaki
  TRUETYPE_TAG('a','b','f', 0 ), // abf = Abai Sungai
  TRUETYPE_TAG('a','b','g', 0 ), // abg = Abaga
  TRUETYPE_TAG('a','b','h', 0 ), // abh = Tajiki Arabic
  TRUETYPE_TAG('a','b','i', 0 ), // abi = Abidji
  TRUETYPE_TAG('a','b','j', 0 ), // abj = Aka-Bea
  TRUETYPE_TAG('a','b','l', 0 ), // abl = Lampung Nyo
  TRUETYPE_TAG('a','b','m', 0 ), // abm = Abanyom
  TRUETYPE_TAG('a','b','n', 0 ), // abn = Abua
  TRUETYPE_TAG('a','b','o', 0 ), // abo = Abon
  TRUETYPE_TAG('a','b','p', 0 ), // abp = Abellen Ayta
  TRUETYPE_TAG('a','b','q', 0 ), // abq = Abaza
  TRUETYPE_TAG('a','b','r', 0 ), // abr = Abron
  TRUETYPE_TAG('a','b','s', 0 ), // abs = Ambonese Malay
  TRUETYPE_TAG('a','b','t', 0 ), // abt = Ambulas
  TRUETYPE_TAG('a','b','u', 0 ), // abu = Abure
  TRUETYPE_TAG('a','b','v', 0 ), // abv = Baharna Arabic
  TRUETYPE_TAG('a','b','w', 0 ), // abw = Pal
  TRUETYPE_TAG('a','b','x', 0 ), // abx = Inabaknon
  TRUETYPE_TAG('a','b','y', 0 ), // aby = Aneme Wake
  TRUETYPE_TAG('a','b','z', 0 ), // abz = Abui
  TRUETYPE_TAG('a','c','a', 0 ), // aca = Achagua
  TRUETYPE_TAG('a','c','b', 0 ), // acb = Áncá
  TRUETYPE_TAG('a','c','d', 0 ), // acd = Gikyode
  TRUETYPE_TAG('a','c','e', 0 ), // ace = Achinese
  TRUETYPE_TAG('a','c','f', 0 ), // acf = Saint Lucian Creole French
  TRUETYPE_TAG('a','c','h', 0 ), // ach = Acoli
  TRUETYPE_TAG('a','c','i', 0 ), // aci = Aka-Cari
  TRUETYPE_TAG('a','c','k', 0 ), // ack = Aka-Kora
  TRUETYPE_TAG('a','c','l', 0 ), // acl = Akar-Bale
  TRUETYPE_TAG('a','c','m', 0 ), // acm = Mesopotamian Arabic
  TRUETYPE_TAG('a','c','n', 0 ), // acn = Achang
  TRUETYPE_TAG('a','c','p', 0 ), // acp = Eastern Acipa
  TRUETYPE_TAG('a','c','q', 0 ), // acq = Ta'izzi-Adeni Arabic
  TRUETYPE_TAG('a','c','r', 0 ), // acr = Achi
  TRUETYPE_TAG('a','c','s', 0 ), // acs = Acroá
  TRUETYPE_TAG('a','c','t', 0 ), // act = Achterhoeks
  TRUETYPE_TAG('a','c','u', 0 ), // acu = Achuar-Shiwiar
  TRUETYPE_TAG('a','c','v', 0 ), // acv = Achumawi
  TRUETYPE_TAG('a','c','w', 0 ), // acw = Hijazi Arabic
  TRUETYPE_TAG('a','c','x', 0 ), // acx = Omani Arabic
  TRUETYPE_TAG('a','c','y', 0 ), // acy = Cypriot Arabic
  TRUETYPE_TAG('a','c','z', 0 ), // acz = Acheron
  TRUETYPE_TAG('a','d','a', 0 ), // ada = Adangme
  TRUETYPE_TAG('a','d','b', 0 ), // adb = Adabe
  TRUETYPE_TAG('a','d','d', 0 ), // add = Dzodinka
  TRUETYPE_TAG('a','d','e', 0 ), // ade = Adele
  TRUETYPE_TAG('a','d','f', 0 ), // adf = Dhofari Arabic
  TRUETYPE_TAG('a','d','g', 0 ), // adg = Andegerebinha
  TRUETYPE_TAG('a','d','h', 0 ), // adh = Adhola
  TRUETYPE_TAG('a','d','i', 0 ), // adi = Adi
  TRUETYPE_TAG('a','d','j', 0 ), // adj = Adioukrou
  TRUETYPE_TAG('a','d','l', 0 ), // adl = Galo
  TRUETYPE_TAG('a','d','n', 0 ), // adn = Adang
  TRUETYPE_TAG('a','d','o', 0 ), // ado = Abu
  TRUETYPE_TAG('a','d','p', 0 ), // adp = Adap
  TRUETYPE_TAG('a','d','q', 0 ), // adq = Adangbe
  TRUETYPE_TAG('a','d','r', 0 ), // adr = Adonara
  TRUETYPE_TAG('a','d','s', 0 ), // ads = Adamorobe Sign Language
  TRUETYPE_TAG('a','d','t', 0 ), // adt = Adnyamathanha
  TRUETYPE_TAG('a','d','u', 0 ), // adu = Aduge
  TRUETYPE_TAG('a','d','w', 0 ), // adw = Amundava
  TRUETYPE_TAG('a','d','x', 0 ), // adx = Amdo Tibetan
  TRUETYPE_TAG('a','d','y', 0 ), // ady = Adyghe
  TRUETYPE_TAG('a','d','z', 0 ), // adz = Adzera
  TRUETYPE_TAG('a','e','a', 0 ), // aea = Areba
  TRUETYPE_TAG('a','e','b', 0 ), // aeb = Tunisian Arabic
  TRUETYPE_TAG('a','e','c', 0 ), // aec = Saidi Arabic
  TRUETYPE_TAG('a','e','d', 0 ), // aed = Argentine Sign Language
  TRUETYPE_TAG('a','e','e', 0 ), // aee = Northeast Pashayi
  TRUETYPE_TAG('a','e','k', 0 ), // aek = Haeke
  TRUETYPE_TAG('a','e','l', 0 ), // ael = Ambele
  TRUETYPE_TAG('a','e','m', 0 ), // aem = Arem
  TRUETYPE_TAG('a','e','n', 0 ), // aen = Armenian Sign Language
  TRUETYPE_TAG('a','e','q', 0 ), // aeq = Aer
  TRUETYPE_TAG('a','e','r', 0 ), // aer = Eastern Arrernte
  TRUETYPE_TAG('a','e','s', 0 ), // aes = Alsea
  TRUETYPE_TAG('a','e','u', 0 ), // aeu = Akeu
  TRUETYPE_TAG('a','e','w', 0 ), // aew = Ambakich
  TRUETYPE_TAG('a','e','y', 0 ), // aey = Amele
  TRUETYPE_TAG('a','e','z', 0 ), // aez = Aeka
  TRUETYPE_TAG('a','f','a', 0 ), // afa = Afro-Asiatic languages
  TRUETYPE_TAG('a','f','b', 0 ), // afb = Gulf Arabic
  TRUETYPE_TAG('a','f','d', 0 ), // afd = Andai
  TRUETYPE_TAG('a','f','e', 0 ), // afe = Putukwam
  TRUETYPE_TAG('a','f','g', 0 ), // afg = Afghan Sign Language
  TRUETYPE_TAG('a','f','h', 0 ), // afh = Afrihili
  TRUETYPE_TAG('a','f','i', 0 ), // afi = Akrukay
  TRUETYPE_TAG('a','f','k', 0 ), // afk = Nanubae
  TRUETYPE_TAG('a','f','n', 0 ), // afn = Defaka
  TRUETYPE_TAG('a','f','o', 0 ), // afo = Eloyi
  TRUETYPE_TAG('a','f','p', 0 ), // afp = Tapei
  TRUETYPE_TAG('a','f','s', 0 ), // afs = Afro-Seminole Creole
  TRUETYPE_TAG('a','f','t', 0 ), // aft = Afitti
  TRUETYPE_TAG('a','f','u', 0 ), // afu = Awutu
  TRUETYPE_TAG('a','f','z', 0 ), // afz = Obokuitai
  TRUETYPE_TAG('a','g','a', 0 ), // aga = Aguano
  TRUETYPE_TAG('a','g','b', 0 ), // agb = Legbo
  TRUETYPE_TAG('a','g','c', 0 ), // agc = Agatu
  TRUETYPE_TAG('a','g','d', 0 ), // agd = Agarabi
  TRUETYPE_TAG('a','g','e', 0 ), // age = Angal
  TRUETYPE_TAG('a','g','f', 0 ), // agf = Arguni
  TRUETYPE_TAG('a','g','g', 0 ), // agg = Angor
  TRUETYPE_TAG('a','g','h', 0 ), // agh = Ngelima
  TRUETYPE_TAG('a','g','i', 0 ), // agi = Agariya
  TRUETYPE_TAG('a','g','j', 0 ), // agj = Argobba
  TRUETYPE_TAG('a','g','k', 0 ), // agk = Isarog Agta
  TRUETYPE_TAG('a','g','l', 0 ), // agl = Fembe
  TRUETYPE_TAG('a','g','m', 0 ), // agm = Angaataha
  TRUETYPE_TAG('a','g','n', 0 ), // agn = Agutaynen
  TRUETYPE_TAG('a','g','o', 0 ), // ago = Tainae
  TRUETYPE_TAG('a','g','p', 0 ), // agp = Paranan
  TRUETYPE_TAG('a','g','q', 0 ), // agq = Aghem
  TRUETYPE_TAG('a','g','r', 0 ), // agr = Aguaruna
  TRUETYPE_TAG('a','g','s', 0 ), // ags = Esimbi
  TRUETYPE_TAG('a','g','t', 0 ), // agt = Central Cagayan Agta
  TRUETYPE_TAG('a','g','u', 0 ), // agu = Aguacateco
  TRUETYPE_TAG('a','g','v', 0 ), // agv = Remontado Dumagat
  TRUETYPE_TAG('a','g','w', 0 ), // agw = Kahua
  TRUETYPE_TAG('a','g','x', 0 ), // agx = Aghul
  TRUETYPE_TAG('a','g','y', 0 ), // agy = Southern Alta
  TRUETYPE_TAG('a','g','z', 0 ), // agz = Mt. Iriga Agta
  TRUETYPE_TAG('a','h','a', 0 ), // aha = Ahanta
  TRUETYPE_TAG('a','h','b', 0 ), // ahb = Axamb
  TRUETYPE_TAG('a','h','g', 0 ), // ahg = Qimant
  TRUETYPE_TAG('a','h','h', 0 ), // ahh = Aghu
  TRUETYPE_TAG('a','h','i', 0 ), // ahi = Tiagbamrin Aizi
  TRUETYPE_TAG('a','h','k', 0 ), // ahk = Akha
  TRUETYPE_TAG('a','h','l', 0 ), // ahl = Igo
  TRUETYPE_TAG('a','h','m', 0 ), // ahm = Mobumrin Aizi
  TRUETYPE_TAG('a','h','n', 0 ), // ahn = Àhàn
  TRUETYPE_TAG('a','h','o', 0 ), // aho = Ahom
  TRUETYPE_TAG('a','h','p', 0 ), // ahp = Aproumu Aizi
  TRUETYPE_TAG('a','h','r', 0 ), // ahr = Ahirani
  TRUETYPE_TAG('a','h','s', 0 ), // ahs = Ashe
  TRUETYPE_TAG('a','h','t', 0 ), // aht = Ahtena
  TRUETYPE_TAG('a','i','a', 0 ), // aia = Arosi
  TRUETYPE_TAG('a','i','b', 0 ), // aib = Ainu (China)
  TRUETYPE_TAG('a','i','c', 0 ), // aic = Ainbai
  TRUETYPE_TAG('a','i','d', 0 ), // aid = Alngith
  TRUETYPE_TAG('a','i','e', 0 ), // aie = Amara
  TRUETYPE_TAG('a','i','f', 0 ), // aif = Agi
  TRUETYPE_TAG('a','i','g', 0 ), // aig = Antigua and Barbuda Creole English
  TRUETYPE_TAG('a','i','h', 0 ), // aih = Ai-Cham
  TRUETYPE_TAG('a','i','i', 0 ), // aii = Assyrian Neo-Aramaic
  TRUETYPE_TAG('a','i','j', 0 ), // aij = Lishanid Noshan
  TRUETYPE_TAG('a','i','k', 0 ), // aik = Ake
  TRUETYPE_TAG('a','i','l', 0 ), // ail = Aimele
  TRUETYPE_TAG('a','i','m', 0 ), // aim = Aimol
  TRUETYPE_TAG('a','i','n', 0 ), // ain = Ainu (Japan)
  TRUETYPE_TAG('a','i','o', 0 ), // aio = Aiton
  TRUETYPE_TAG('a','i','p', 0 ), // aip = Burumakok
  TRUETYPE_TAG('a','i','q', 0 ), // aiq = Aimaq
  TRUETYPE_TAG('a','i','r', 0 ), // air = Airoran
  TRUETYPE_TAG('a','i','s', 0 ), // ais = Nataoran Amis
  TRUETYPE_TAG('a','i','t', 0 ), // ait = Arikem
  TRUETYPE_TAG('a','i','w', 0 ), // aiw = Aari
  TRUETYPE_TAG('a','i','x', 0 ), // aix = Aighon
  TRUETYPE_TAG('a','i','y', 0 ), // aiy = Ali
  TRUETYPE_TAG('a','j','a', 0 ), // aja = Aja (Sudan)
  TRUETYPE_TAG('a','j','g', 0 ), // ajg = Aja (Benin)
  TRUETYPE_TAG('a','j','i', 0 ), // aji = Ajië
  TRUETYPE_TAG('a','j','p', 0 ), // ajp = South Levantine Arabic
  TRUETYPE_TAG('a','j','t', 0 ), // ajt = Judeo-Tunisian Arabic
  TRUETYPE_TAG('a','j','u', 0 ), // aju = Judeo-Moroccan Arabic
  TRUETYPE_TAG('a','j','w', 0 ), // ajw = Ajawa
  TRUETYPE_TAG('a','j','z', 0 ), // ajz = Amri Karbi
  TRUETYPE_TAG('a','k','b', 0 ), // akb = Batak Angkola
  TRUETYPE_TAG('a','k','c', 0 ), // akc = Mpur
  TRUETYPE_TAG('a','k','d', 0 ), // akd = Ukpet-Ehom
  TRUETYPE_TAG('a','k','e', 0 ), // ake = Akawaio
  TRUETYPE_TAG('a','k','f', 0 ), // akf = Akpa
  TRUETYPE_TAG('a','k','g', 0 ), // akg = Anakalangu
  TRUETYPE_TAG('a','k','h', 0 ), // akh = Angal Heneng
  TRUETYPE_TAG('a','k','i', 0 ), // aki = Aiome
  TRUETYPE_TAG('a','k','j', 0 ), // akj = Aka-Jeru
  TRUETYPE_TAG('a','k','k', 0 ), // akk = Akkadian
  TRUETYPE_TAG('a','k','l', 0 ), // akl = Aklanon
  TRUETYPE_TAG('a','k','m', 0 ), // akm = Aka-Bo
  TRUETYPE_TAG('a','k','o', 0 ), // ako = Akurio
  TRUETYPE_TAG('a','k','p', 0 ), // akp = Siwu
  TRUETYPE_TAG('a','k','q', 0 ), // akq = Ak
  TRUETYPE_TAG('a','k','r', 0 ), // akr = Araki
  TRUETYPE_TAG('a','k','s', 0 ), // aks = Akaselem
  TRUETYPE_TAG('a','k','t', 0 ), // akt = Akolet
  TRUETYPE_TAG('a','k','u', 0 ), // aku = Akum
  TRUETYPE_TAG('a','k','v', 0 ), // akv = Akhvakh
  TRUETYPE_TAG('a','k','w', 0 ), // akw = Akwa
  TRUETYPE_TAG('a','k','x', 0 ), // akx = Aka-Kede
  TRUETYPE_TAG('a','k','y', 0 ), // aky = Aka-Kol
  TRUETYPE_TAG('a','k','z', 0 ), // akz = Alabama
  TRUETYPE_TAG('a','l','a', 0 ), // ala = Alago
  TRUETYPE_TAG('a','l','c', 0 ), // alc = Qawasqar
  TRUETYPE_TAG('a','l','d', 0 ), // ald = Alladian
  TRUETYPE_TAG('a','l','e', 0 ), // ale = Aleut
  TRUETYPE_TAG('a','l','f', 0 ), // alf = Alege
  TRUETYPE_TAG('a','l','g', 0 ), // alg = Algonquian languages
  TRUETYPE_TAG('a','l','h', 0 ), // alh = Alawa
  TRUETYPE_TAG('a','l','i', 0 ), // ali = Amaimon
  TRUETYPE_TAG('a','l','j', 0 ), // alj = Alangan
  TRUETYPE_TAG('a','l','k', 0 ), // alk = Alak
  TRUETYPE_TAG('a','l','l', 0 ), // all = Allar
  TRUETYPE_TAG('a','l','m', 0 ), // alm = Amblong
  TRUETYPE_TAG('a','l','n', 0 ), // aln = Gheg Albanian
  TRUETYPE_TAG('a','l','o', 0 ), // alo = Larike-Wakasihu
  TRUETYPE_TAG('a','l','p', 0 ), // alp = Alune
  TRUETYPE_TAG('a','l','q', 0 ), // alq = Algonquin
  TRUETYPE_TAG('a','l','r', 0 ), // alr = Alutor
  TRUETYPE_TAG('a','l','s', 0 ), // als = Tosk Albanian
  TRUETYPE_TAG('a','l','t', 0 ), // alt = Southern Altai
  TRUETYPE_TAG('a','l','u', 0 ), // alu = 'Are'are
  TRUETYPE_TAG('a','l','v', 0 ), // alv = Atlantic-Congo languages
  TRUETYPE_TAG('a','l','w', 0 ), // alw = Alaba-K’abeena
  TRUETYPE_TAG('a','l','x', 0 ), // alx = Amol
  TRUETYPE_TAG('a','l','y', 0 ), // aly = Alyawarr
  TRUETYPE_TAG('a','l','z', 0 ), // alz = Alur
  TRUETYPE_TAG('a','m','a', 0 ), // ama = Amanayé
  TRUETYPE_TAG('a','m','b', 0 ), // amb = Ambo
  TRUETYPE_TAG('a','m','c', 0 ), // amc = Amahuaca
  TRUETYPE_TAG('a','m','e', 0 ), // ame = Yanesha'
  TRUETYPE_TAG('a','m','f', 0 ), // amf = Hamer-Banna
  TRUETYPE_TAG('a','m','g', 0 ), // amg = Amarag
  TRUETYPE_TAG('a','m','i', 0 ), // ami = Amis
  TRUETYPE_TAG('a','m','j', 0 ), // amj = Amdang
  TRUETYPE_TAG('a','m','k', 0 ), // amk = Ambai
  TRUETYPE_TAG('a','m','l', 0 ), // aml = War-Jaintia
  TRUETYPE_TAG('a','m','m', 0 ), // amm = Ama (Papua New Guinea)
  TRUETYPE_TAG('a','m','n', 0 ), // amn = Amanab
  TRUETYPE_TAG('a','m','o', 0 ), // amo = Amo
  TRUETYPE_TAG('a','m','p', 0 ), // amp = Alamblak
  TRUETYPE_TAG('a','m','q', 0 ), // amq = Amahai
  TRUETYPE_TAG('a','m','r', 0 ), // amr = Amarakaeri
  TRUETYPE_TAG('a','m','s', 0 ), // ams = Southern Amami-Oshima
  TRUETYPE_TAG('a','m','t', 0 ), // amt = Amto
  TRUETYPE_TAG('a','m','u', 0 ), // amu = Guerrero Amuzgo
  TRUETYPE_TAG('a','m','v', 0 ), // amv = Ambelau
  TRUETYPE_TAG('a','m','w', 0 ), // amw = Western Neo-Aramaic
  TRUETYPE_TAG('a','m','x', 0 ), // amx = Anmatyerre
  TRUETYPE_TAG('a','m','y', 0 ), // amy = Ami
  TRUETYPE_TAG('a','m','z', 0 ), // amz = Atampaya
  TRUETYPE_TAG('a','n','a', 0 ), // ana = Andaqui
  TRUETYPE_TAG('a','n','b', 0 ), // anb = Andoa
  TRUETYPE_TAG('a','n','c', 0 ), // anc = Ngas
  TRUETYPE_TAG('a','n','d', 0 ), // and = Ansus
  TRUETYPE_TAG('a','n','e', 0 ), // ane = Xârâcùù
  TRUETYPE_TAG('a','n','f', 0 ), // anf = Animere
  TRUETYPE_TAG('a','n','g', 0 ), // ang = Old English (ca. 450-1100)
  TRUETYPE_TAG('a','n','h', 0 ), // anh = Nend
  TRUETYPE_TAG('a','n','i', 0 ), // ani = Andi
  TRUETYPE_TAG('a','n','j', 0 ), // anj = Anor
  TRUETYPE_TAG('a','n','k', 0 ), // ank = Goemai
  TRUETYPE_TAG('a','n','l', 0 ), // anl = Anu
  TRUETYPE_TAG('a','n','m', 0 ), // anm = Anal
  TRUETYPE_TAG('a','n','n', 0 ), // ann = Obolo
  TRUETYPE_TAG('a','n','o', 0 ), // ano = Andoque
  TRUETYPE_TAG('a','n','p', 0 ), // anp = Angika
  TRUETYPE_TAG('a','n','q', 0 ), // anq = Jarawa (India)
  TRUETYPE_TAG('a','n','r', 0 ), // anr = Andh
  TRUETYPE_TAG('a','n','s', 0 ), // ans = Anserma
  TRUETYPE_TAG('a','n','t', 0 ), // ant = Antakarinya
  TRUETYPE_TAG('a','n','u', 0 ), // anu = Anuak
  TRUETYPE_TAG('a','n','v', 0 ), // anv = Denya
  TRUETYPE_TAG('a','n','w', 0 ), // anw = Anaang
  TRUETYPE_TAG('a','n','x', 0 ), // anx = Andra-Hus
  TRUETYPE_TAG('a','n','y', 0 ), // any = Anyin
  TRUETYPE_TAG('a','n','z', 0 ), // anz = Anem
  TRUETYPE_TAG('a','o','a', 0 ), // aoa = Angolar
  TRUETYPE_TAG('a','o','b', 0 ), // aob = Abom
  TRUETYPE_TAG('a','o','c', 0 ), // aoc = Pemon
  TRUETYPE_TAG('a','o','d', 0 ), // aod = Andarum
  TRUETYPE_TAG('a','o','e', 0 ), // aoe = Angal Enen
  TRUETYPE_TAG('a','o','f', 0 ), // aof = Bragat
  TRUETYPE_TAG('a','o','g', 0 ), // aog = Angoram
  TRUETYPE_TAG('a','o','h', 0 ), // aoh = Arma
  TRUETYPE_TAG('a','o','i', 0 ), // aoi = Anindilyakwa
  TRUETYPE_TAG('a','o','j', 0 ), // aoj = Mufian
  TRUETYPE_TAG('a','o','k', 0 ), // aok = Arhö
  TRUETYPE_TAG('a','o','l', 0 ), // aol = Alor
  TRUETYPE_TAG('a','o','m', 0 ), // aom = Ömie
  TRUETYPE_TAG('a','o','n', 0 ), // aon = Bumbita Arapesh
  TRUETYPE_TAG('a','o','r', 0 ), // aor = Aore
  TRUETYPE_TAG('a','o','s', 0 ), // aos = Taikat
  TRUETYPE_TAG('a','o','t', 0 ), // aot = A'tong
  TRUETYPE_TAG('a','o','x', 0 ), // aox = Atorada
  TRUETYPE_TAG('a','o','z', 0 ), // aoz = Uab Meto
  TRUETYPE_TAG('a','p','a', 0 ), // apa = Apache languages
  TRUETYPE_TAG('a','p','b', 0 ), // apb = Sa'a
  TRUETYPE_TAG('a','p','c', 0 ), // apc = North Levantine Arabic
  TRUETYPE_TAG('a','p','d', 0 ), // apd = Sudanese Arabic
  TRUETYPE_TAG('a','p','e', 0 ), // ape = Bukiyip
  TRUETYPE_TAG('a','p','f', 0 ), // apf = Pahanan Agta
  TRUETYPE_TAG('a','p','g', 0 ), // apg = Ampanang
  TRUETYPE_TAG('a','p','h', 0 ), // aph = Athpariya
  TRUETYPE_TAG('a','p','i', 0 ), // api = Apiaká
  TRUETYPE_TAG('a','p','j', 0 ), // apj = Jicarilla Apache
  TRUETYPE_TAG('a','p','k', 0 ), // apk = Kiowa Apache
  TRUETYPE_TAG('a','p','l', 0 ), // apl = Lipan Apache
  TRUETYPE_TAG('a','p','m', 0 ), // apm = Mescalero-Chiricahua Apache
  TRUETYPE_TAG('a','p','n', 0 ), // apn = Apinayé
  TRUETYPE_TAG('a','p','o', 0 ), // apo = Ambul
  TRUETYPE_TAG('a','p','p', 0 ), // app = Apma
  TRUETYPE_TAG('a','p','q', 0 ), // apq = A-Pucikwar
  TRUETYPE_TAG('a','p','r', 0 ), // apr = Arop-Lokep
  TRUETYPE_TAG('a','p','s', 0 ), // aps = Arop-Sissano
  TRUETYPE_TAG('a','p','t', 0 ), // apt = Apatani
  TRUETYPE_TAG('a','p','u', 0 ), // apu = Apurinã
  TRUETYPE_TAG('a','p','v', 0 ), // apv = Alapmunte
  TRUETYPE_TAG('a','p','w', 0 ), // apw = Western Apache
  TRUETYPE_TAG('a','p','x', 0 ), // apx = Aputai
  TRUETYPE_TAG('a','p','y', 0 ), // apy = Apalaí
  TRUETYPE_TAG('a','p','z', 0 ), // apz = Safeyoka
  TRUETYPE_TAG('a','q','a', 0 ), // aqa = Alacalufan languages
  TRUETYPE_TAG('a','q','c', 0 ), // aqc = Archi
  TRUETYPE_TAG('a','q','d', 0 ), // aqd = Ampari Dogon
  TRUETYPE_TAG('a','q','g', 0 ), // aqg = Arigidi
  TRUETYPE_TAG('a','q','l', 0 ), // aql = Algic languages
  TRUETYPE_TAG('a','q','m', 0 ), // aqm = Atohwaim
  TRUETYPE_TAG('a','q','n', 0 ), // aqn = Northern Alta
  TRUETYPE_TAG('a','q','p', 0 ), // aqp = Atakapa
  TRUETYPE_TAG('a','q','r', 0 ), // aqr = Arhâ
  TRUETYPE_TAG('a','q','z', 0 ), // aqz = Akuntsu
  TRUETYPE_TAG('a','r','b', 0 ), // arb = Standard Arabic
  TRUETYPE_TAG('a','r','c', 0 ), // arc = Official Aramaic (700-300 BCE)
  TRUETYPE_TAG('a','r','d', 0 ), // ard = Arabana
  TRUETYPE_TAG('a','r','e', 0 ), // are = Western Arrarnta
  TRUETYPE_TAG('a','r','h', 0 ), // arh = Arhuaco
  TRUETYPE_TAG('a','r','i', 0 ), // ari = Arikara
  TRUETYPE_TAG('a','r','j', 0 ), // arj = Arapaso
  TRUETYPE_TAG('a','r','k', 0 ), // ark = Arikapú
  TRUETYPE_TAG('a','r','l', 0 ), // arl = Arabela
  TRUETYPE_TAG('a','r','n', 0 ), // arn = Mapudungun
  TRUETYPE_TAG('a','r','o', 0 ), // aro = Araona
  TRUETYPE_TAG('a','r','p', 0 ), // arp = Arapaho
  TRUETYPE_TAG('a','r','q', 0 ), // arq = Algerian Arabic
  TRUETYPE_TAG('a','r','r', 0 ), // arr = Karo (Brazil)
  TRUETYPE_TAG('a','r','s', 0 ), // ars = Najdi Arabic
  TRUETYPE_TAG('a','r','t', 0 ), // art = Artificial languages
  TRUETYPE_TAG('a','r','u', 0 ), // aru = Aruá (Amazonas State)
  TRUETYPE_TAG('a','r','v', 0 ), // arv = Arbore
  TRUETYPE_TAG('a','r','w', 0 ), // arw = Arawak
  TRUETYPE_TAG('a','r','x', 0 ), // arx = Aruá (Rodonia State)
  TRUETYPE_TAG('a','r','y', 0 ), // ary = Moroccan Arabic
  TRUETYPE_TAG('a','r','z', 0 ), // arz = Egyptian Arabic
  TRUETYPE_TAG('a','s','a', 0 ), // asa = Asu (Tanzania)
  TRUETYPE_TAG('a','s','b', 0 ), // asb = Assiniboine
  TRUETYPE_TAG('a','s','c', 0 ), // asc = Casuarina Coast Asmat
  TRUETYPE_TAG('a','s','d', 0 ), // asd = Asas
  TRUETYPE_TAG('a','s','e', 0 ), // ase = American Sign Language
  TRUETYPE_TAG('a','s','f', 0 ), // asf = Australian Sign Language
  TRUETYPE_TAG('a','s','g', 0 ), // asg = Cishingini
  TRUETYPE_TAG('a','s','h', 0 ), // ash = Abishira
  TRUETYPE_TAG('a','s','i', 0 ), // asi = Buruwai
  TRUETYPE_TAG('a','s','j', 0 ), // asj = Nsari
  TRUETYPE_TAG('a','s','k', 0 ), // ask = Ashkun
  TRUETYPE_TAG('a','s','l', 0 ), // asl = Asilulu
  TRUETYPE_TAG('a','s','n', 0 ), // asn = Xingú Asuriní
  TRUETYPE_TAG('a','s','o', 0 ), // aso = Dano
  TRUETYPE_TAG('a','s','p', 0 ), // asp = Algerian Sign Language
  TRUETYPE_TAG('a','s','q', 0 ), // asq = Austrian Sign Language
  TRUETYPE_TAG('a','s','r', 0 ), // asr = Asuri
  TRUETYPE_TAG('a','s','s', 0 ), // ass = Ipulo
  TRUETYPE_TAG('a','s','t', 0 ), // ast = Asturian
  TRUETYPE_TAG('a','s','u', 0 ), // asu = Tocantins Asurini
  TRUETYPE_TAG('a','s','v', 0 ), // asv = Asoa
  TRUETYPE_TAG('a','s','w', 0 ), // asw = Australian Aborigines Sign Language
  TRUETYPE_TAG('a','s','x', 0 ), // asx = Muratayak
  TRUETYPE_TAG('a','s','y', 0 ), // asy = Yaosakor Asmat
  TRUETYPE_TAG('a','s','z', 0 ), // asz = As
  TRUETYPE_TAG('a','t','a', 0 ), // ata = Pele-Ata
  TRUETYPE_TAG('a','t','b', 0 ), // atb = Zaiwa
  TRUETYPE_TAG('a','t','c', 0 ), // atc = Atsahuaca
  TRUETYPE_TAG('a','t','d', 0 ), // atd = Ata Manobo
  TRUETYPE_TAG('a','t','e', 0 ), // ate = Atemble
  TRUETYPE_TAG('a','t','g', 0 ), // atg = Ivbie North-Okpela-Arhe
  TRUETYPE_TAG('a','t','h', 0 ), // ath = Athapascan languages
  TRUETYPE_TAG('a','t','i', 0 ), // ati = Attié
  TRUETYPE_TAG('a','t','j', 0 ), // atj = Atikamekw
  TRUETYPE_TAG('a','t','k', 0 ), // atk = Ati
  TRUETYPE_TAG('a','t','l', 0 ), // atl = Mt. Iraya Agta
  TRUETYPE_TAG('a','t','m', 0 ), // atm = Ata
  TRUETYPE_TAG('a','t','n', 0 ), // atn = Ashtiani
  TRUETYPE_TAG('a','t','o', 0 ), // ato = Atong
  TRUETYPE_TAG('a','t','p', 0 ), // atp = Pudtol Atta
  TRUETYPE_TAG('a','t','q', 0 ), // atq = Aralle-Tabulahan
  TRUETYPE_TAG('a','t','r', 0 ), // atr = Waimiri-Atroari
  TRUETYPE_TAG('a','t','s', 0 ), // ats = Gros Ventre
  TRUETYPE_TAG('a','t','t', 0 ), // att = Pamplona Atta
  TRUETYPE_TAG('a','t','u', 0 ), // atu = Reel
  TRUETYPE_TAG('a','t','v', 0 ), // atv = Northern Altai
  TRUETYPE_TAG('a','t','w', 0 ), // atw = Atsugewi
  TRUETYPE_TAG('a','t','x', 0 ), // atx = Arutani
  TRUETYPE_TAG('a','t','y', 0 ), // aty = Aneityum
  TRUETYPE_TAG('a','t','z', 0 ), // atz = Arta
  TRUETYPE_TAG('a','u','a', 0 ), // aua = Asumboa
  TRUETYPE_TAG('a','u','b', 0 ), // aub = Alugu
  TRUETYPE_TAG('a','u','c', 0 ), // auc = Waorani
  TRUETYPE_TAG('a','u','d', 0 ), // aud = Anuta
  TRUETYPE_TAG('a','u','e', 0 ), // aue = =/Kx'au//'ein
  TRUETYPE_TAG('a','u','f', 0 ), // auf = Arauan languages
  TRUETYPE_TAG('a','u','g', 0 ), // aug = Aguna
  TRUETYPE_TAG('a','u','h', 0 ), // auh = Aushi
  TRUETYPE_TAG('a','u','i', 0 ), // aui = Anuki
  TRUETYPE_TAG('a','u','j', 0 ), // auj = Awjilah
  TRUETYPE_TAG('a','u','k', 0 ), // auk = Heyo
  TRUETYPE_TAG('a','u','l', 0 ), // aul = Aulua
  TRUETYPE_TAG('a','u','m', 0 ), // aum = Asu (Nigeria)
  TRUETYPE_TAG('a','u','n', 0 ), // aun = Molmo One
  TRUETYPE_TAG('a','u','o', 0 ), // auo = Auyokawa
  TRUETYPE_TAG('a','u','p', 0 ), // aup = Makayam
  TRUETYPE_TAG('a','u','q', 0 ), // auq = Anus
  TRUETYPE_TAG('a','u','r', 0 ), // aur = Aruek
  TRUETYPE_TAG('a','u','s', 0 ), // aus = Australian languages
  TRUETYPE_TAG('a','u','t', 0 ), // aut = Austral
  TRUETYPE_TAG('a','u','u', 0 ), // auu = Auye
  TRUETYPE_TAG('a','u','w', 0 ), // auw = Awyi
  TRUETYPE_TAG('a','u','x', 0 ), // aux = Aurá
  TRUETYPE_TAG('a','u','y', 0 ), // auy = Awiyaana
  TRUETYPE_TAG('a','u','z', 0 ), // auz = Uzbeki Arabic
  TRUETYPE_TAG('a','v','b', 0 ), // avb = Avau
  TRUETYPE_TAG('a','v','d', 0 ), // avd = Alviri-Vidari
  TRUETYPE_TAG('a','v','i', 0 ), // avi = Avikam
  TRUETYPE_TAG('a','v','k', 0 ), // avk = Kotava
  TRUETYPE_TAG('a','v','l', 0 ), // avl = Eastern Egyptian Bedawi Arabic
  TRUETYPE_TAG('a','v','n', 0 ), // avn = Avatime
  TRUETYPE_TAG('a','v','o', 0 ), // avo = Agavotaguerra
  TRUETYPE_TAG('a','v','s', 0 ), // avs = Aushiri
  TRUETYPE_TAG('a','v','t', 0 ), // avt = Au
  TRUETYPE_TAG('a','v','u', 0 ), // avu = Avokaya
  TRUETYPE_TAG('a','v','v', 0 ), // avv = Avá-Canoeiro
  TRUETYPE_TAG('a','w','a', 0 ), // awa = Awadhi
  TRUETYPE_TAG('a','w','b', 0 ), // awb = Awa (Papua New Guinea)
  TRUETYPE_TAG('a','w','c', 0 ), // awc = Cicipu
  TRUETYPE_TAG('a','w','d', 0 ), // awd = Arawakan languages
  TRUETYPE_TAG('a','w','e', 0 ), // awe = Awetí
  TRUETYPE_TAG('a','w','h', 0 ), // awh = Awbono
  TRUETYPE_TAG('a','w','i', 0 ), // awi = Aekyom
  TRUETYPE_TAG('a','w','k', 0 ), // awk = Awabakal
  TRUETYPE_TAG('a','w','m', 0 ), // awm = Arawum
  TRUETYPE_TAG('a','w','n', 0 ), // awn = Awngi
  TRUETYPE_TAG('a','w','o', 0 ), // awo = Awak
  TRUETYPE_TAG('a','w','r', 0 ), // awr = Awera
  TRUETYPE_TAG('a','w','s', 0 ), // aws = South Awyu
  TRUETYPE_TAG('a','w','t', 0 ), // awt = Araweté
  TRUETYPE_TAG('a','w','u', 0 ), // awu = Central Awyu
  TRUETYPE_TAG('a','w','v', 0 ), // awv = Jair Awyu
  TRUETYPE_TAG('a','w','w', 0 ), // aww = Awun
  TRUETYPE_TAG('a','w','x', 0 ), // awx = Awara
  TRUETYPE_TAG('a','w','y', 0 ), // awy = Edera Awyu
  TRUETYPE_TAG('a','x','b', 0 ), // axb = Abipon
  TRUETYPE_TAG('a','x','g', 0 ), // axg = Mato Grosso Arára
  TRUETYPE_TAG('a','x','k', 0 ), // axk = Yaka (Central African Republic)
  TRUETYPE_TAG('a','x','m', 0 ), // axm = Middle Armenian
  TRUETYPE_TAG('a','x','x', 0 ), // axx = Xaragure
  TRUETYPE_TAG('a','y','a', 0 ), // aya = Awar
  TRUETYPE_TAG('a','y','b', 0 ), // ayb = Ayizo Gbe
  TRUETYPE_TAG('a','y','c', 0 ), // ayc = Southern Aymara
  TRUETYPE_TAG('a','y','d', 0 ), // ayd = Ayabadhu
  TRUETYPE_TAG('a','y','e', 0 ), // aye = Ayere
  TRUETYPE_TAG('a','y','g', 0 ), // ayg = Ginyanga
  TRUETYPE_TAG('a','y','h', 0 ), // ayh = Hadrami Arabic
  TRUETYPE_TAG('a','y','i', 0 ), // ayi = Leyigha
  TRUETYPE_TAG('a','y','k', 0 ), // ayk = Akuku
  TRUETYPE_TAG('a','y','l', 0 ), // ayl = Libyan Arabic
  TRUETYPE_TAG('a','y','n', 0 ), // ayn = Sanaani Arabic
  TRUETYPE_TAG('a','y','o', 0 ), // ayo = Ayoreo
  TRUETYPE_TAG('a','y','p', 0 ), // ayp = North Mesopotamian Arabic
  TRUETYPE_TAG('a','y','q', 0 ), // ayq = Ayi (Papua New Guinea)
  TRUETYPE_TAG('a','y','r', 0 ), // ayr = Central Aymara
  TRUETYPE_TAG('a','y','s', 0 ), // ays = Sorsogon Ayta
  TRUETYPE_TAG('a','y','t', 0 ), // ayt = Magbukun Ayta
  TRUETYPE_TAG('a','y','u', 0 ), // ayu = Ayu
  TRUETYPE_TAG('a','y','x', 0 ), // ayx = Ayi (China)
  TRUETYPE_TAG('a','y','y', 0 ), // ayy = Tayabas Ayta
  TRUETYPE_TAG('a','y','z', 0 ), // ayz = Mai Brat
  TRUETYPE_TAG('a','z','a', 0 ), // aza = Azha
  TRUETYPE_TAG('a','z','b', 0 ), // azb = South Azerbaijani
  TRUETYPE_TAG('a','z','c', 0 ), // azc = Uto-Aztecan languages
  TRUETYPE_TAG('a','z','g', 0 ), // azg = San Pedro Amuzgos Amuzgo
  TRUETYPE_TAG('a','z','j', 0 ), // azj = North Azerbaijani
  TRUETYPE_TAG('a','z','m', 0 ), // azm = Ipalapa Amuzgo
  TRUETYPE_TAG('a','z','o', 0 ), // azo = Awing
  TRUETYPE_TAG('a','z','t', 0 ), // azt = Faire Atta
  TRUETYPE_TAG('a','z','z', 0 ), // azz = Highland Puebla Nahuatl
  TRUETYPE_TAG('b','a','a', 0 ), // baa = Babatana
  TRUETYPE_TAG('b','a','b', 0 ), // bab = Bainouk-Gunyuño
  TRUETYPE_TAG('b','a','c', 0 ), // bac = Badui
  TRUETYPE_TAG('b','a','d', 0 ), // bad = Banda languages
  TRUETYPE_TAG('b','a','e', 0 ), // bae = Baré
  TRUETYPE_TAG('b','a','f', 0 ), // baf = Nubaca
  TRUETYPE_TAG('b','a','g', 0 ), // bag = Tuki
  TRUETYPE_TAG('b','a','h', 0 ), // bah = Bahamas Creole English
  TRUETYPE_TAG('b','a','i', 0 ), // bai = Bamileke languages
  TRUETYPE_TAG('b','a','j', 0 ), // baj = Barakai
  TRUETYPE_TAG('b','a','l', 0 ), // bal = Baluchi
  TRUETYPE_TAG('b','a','n', 0 ), // ban = Balinese
  TRUETYPE_TAG('b','a','o', 0 ), // bao = Waimaha
  TRUETYPE_TAG('b','a','p', 0 ), // bap = Bantawa
  TRUETYPE_TAG('b','a','r', 0 ), // bar = Bavarian
  TRUETYPE_TAG('b','a','s', 0 ), // bas = Basa (Cameroon)
  TRUETYPE_TAG('b','a','t', 0 ), // bat = Baltic languages
  TRUETYPE_TAG('b','a','u', 0 ), // bau = Bada (Nigeria)
  TRUETYPE_TAG('b','a','v', 0 ), // bav = Vengo
  TRUETYPE_TAG('b','a','w', 0 ), // baw = Bambili-Bambui
  TRUETYPE_TAG('b','a','x', 0 ), // bax = Bamun
  TRUETYPE_TAG('b','a','y', 0 ), // bay = Batuley
  TRUETYPE_TAG('b','a','z', 0 ), // baz = Tunen
  TRUETYPE_TAG('b','b','a', 0 ), // bba = Baatonum
  TRUETYPE_TAG('b','b','b', 0 ), // bbb = Barai
  TRUETYPE_TAG('b','b','c', 0 ), // bbc = Batak Toba
  TRUETYPE_TAG('b','b','d', 0 ), // bbd = Bau
  TRUETYPE_TAG('b','b','e', 0 ), // bbe = Bangba
  TRUETYPE_TAG('b','b','f', 0 ), // bbf = Baibai
  TRUETYPE_TAG('b','b','g', 0 ), // bbg = Barama
  TRUETYPE_TAG('b','b','h', 0 ), // bbh = Bugan
  TRUETYPE_TAG('b','b','i', 0 ), // bbi = Barombi
  TRUETYPE_TAG('b','b','j', 0 ), // bbj = Ghomálá'
  TRUETYPE_TAG('b','b','k', 0 ), // bbk = Babanki
  TRUETYPE_TAG('b','b','l', 0 ), // bbl = Bats
  TRUETYPE_TAG('b','b','m', 0 ), // bbm = Babango
  TRUETYPE_TAG('b','b','n', 0 ), // bbn = Uneapa
  TRUETYPE_TAG('b','b','o', 0 ), // bbo = Northern Bobo Madaré
  TRUETYPE_TAG('b','b','p', 0 ), // bbp = West Central Banda
  TRUETYPE_TAG('b','b','q', 0 ), // bbq = Bamali
  TRUETYPE_TAG('b','b','r', 0 ), // bbr = Girawa
  TRUETYPE_TAG('b','b','s', 0 ), // bbs = Bakpinka
  TRUETYPE_TAG('b','b','t', 0 ), // bbt = Mburku
  TRUETYPE_TAG('b','b','u', 0 ), // bbu = Kulung (Nigeria)
  TRUETYPE_TAG('b','b','v', 0 ), // bbv = Karnai
  TRUETYPE_TAG('b','b','w', 0 ), // bbw = Baba
  TRUETYPE_TAG('b','b','x', 0 ), // bbx = Bubia
  TRUETYPE_TAG('b','b','y', 0 ), // bby = Befang
  TRUETYPE_TAG('b','b','z', 0 ), // bbz = Babalia Creole Arabic
  TRUETYPE_TAG('b','c','a', 0 ), // bca = Central Bai
  TRUETYPE_TAG('b','c','b', 0 ), // bcb = Bainouk-Samik
  TRUETYPE_TAG('b','c','c', 0 ), // bcc = Southern Balochi
  TRUETYPE_TAG('b','c','d', 0 ), // bcd = North Babar
  TRUETYPE_TAG('b','c','e', 0 ), // bce = Bamenyam
  TRUETYPE_TAG('b','c','f', 0 ), // bcf = Bamu
  TRUETYPE_TAG('b','c','g', 0 ), // bcg = Baga Binari
  TRUETYPE_TAG('b','c','h', 0 ), // bch = Bariai
  TRUETYPE_TAG('b','c','i', 0 ), // bci = Baoulé
  TRUETYPE_TAG('b','c','j', 0 ), // bcj = Bardi
  TRUETYPE_TAG('b','c','k', 0 ), // bck = Bunaba
  TRUETYPE_TAG('b','c','l', 0 ), // bcl = Central Bicolano
  TRUETYPE_TAG('b','c','m', 0 ), // bcm = Bannoni
  TRUETYPE_TAG('b','c','n', 0 ), // bcn = Bali (Nigeria)
  TRUETYPE_TAG('b','c','o', 0 ), // bco = Kaluli
  TRUETYPE_TAG('b','c','p', 0 ), // bcp = Bali (Democratic Republic of Congo)
  TRUETYPE_TAG('b','c','q', 0 ), // bcq = Bench
  TRUETYPE_TAG('b','c','r', 0 ), // bcr = Babine
  TRUETYPE_TAG('b','c','s', 0 ), // bcs = Kohumono
  TRUETYPE_TAG('b','c','t', 0 ), // bct = Bendi
  TRUETYPE_TAG('b','c','u', 0 ), // bcu = Awad Bing
  TRUETYPE_TAG('b','c','v', 0 ), // bcv = Shoo-Minda-Nye
  TRUETYPE_TAG('b','c','w', 0 ), // bcw = Bana
  TRUETYPE_TAG('b','c','y', 0 ), // bcy = Bacama
  TRUETYPE_TAG('b','c','z', 0 ), // bcz = Bainouk-Gunyaamolo
  TRUETYPE_TAG('b','d','a', 0 ), // bda = Bayot
  TRUETYPE_TAG('b','d','b', 0 ), // bdb = Basap
  TRUETYPE_TAG('b','d','c', 0 ), // bdc = Emberá-Baudó
  TRUETYPE_TAG('b','d','d', 0 ), // bdd = Bunama
  TRUETYPE_TAG('b','d','e', 0 ), // bde = Bade
  TRUETYPE_TAG('b','d','f', 0 ), // bdf = Biage
  TRUETYPE_TAG('b','d','g', 0 ), // bdg = Bonggi
  TRUETYPE_TAG('b','d','h', 0 ), // bdh = Baka (Sudan)
  TRUETYPE_TAG('b','d','i', 0 ), // bdi = Burun
  TRUETYPE_TAG('b','d','j', 0 ), // bdj = Bai
  TRUETYPE_TAG('b','d','k', 0 ), // bdk = Budukh
  TRUETYPE_TAG('b','d','l', 0 ), // bdl = Indonesian Bajau
  TRUETYPE_TAG('b','d','m', 0 ), // bdm = Buduma
  TRUETYPE_TAG('b','d','n', 0 ), // bdn = Baldemu
  TRUETYPE_TAG('b','d','o', 0 ), // bdo = Morom
  TRUETYPE_TAG('b','d','p', 0 ), // bdp = Bende
  TRUETYPE_TAG('b','d','q', 0 ), // bdq = Bahnar
  TRUETYPE_TAG('b','d','r', 0 ), // bdr = West Coast Bajau
  TRUETYPE_TAG('b','d','s', 0 ), // bds = Burunge
  TRUETYPE_TAG('b','d','t', 0 ), // bdt = Bokoto
  TRUETYPE_TAG('b','d','u', 0 ), // bdu = Oroko
  TRUETYPE_TAG('b','d','v', 0 ), // bdv = Bodo Parja
  TRUETYPE_TAG('b','d','w', 0 ), // bdw = Baham
  TRUETYPE_TAG('b','d','x', 0 ), // bdx = Budong-Budong
  TRUETYPE_TAG('b','d','y', 0 ), // bdy = Bandjalang
  TRUETYPE_TAG('b','d','z', 0 ), // bdz = Badeshi
  TRUETYPE_TAG('b','e','a', 0 ), // bea = Beaver
  TRUETYPE_TAG('b','e','b', 0 ), // beb = Bebele
  TRUETYPE_TAG('b','e','c', 0 ), // bec = Iceve-Maci
  TRUETYPE_TAG('b','e','d', 0 ), // bed = Bedoanas
  TRUETYPE_TAG('b','e','e', 0 ), // bee = Byangsi
  TRUETYPE_TAG('b','e','f', 0 ), // bef = Benabena
  TRUETYPE_TAG('b','e','g', 0 ), // beg = Belait
  TRUETYPE_TAG('b','e','h', 0 ), // beh = Biali
  TRUETYPE_TAG('b','e','i', 0 ), // bei = Bekati'
  TRUETYPE_TAG('b','e','j', 0 ), // bej = Beja
  TRUETYPE_TAG('b','e','k', 0 ), // bek = Bebeli
  TRUETYPE_TAG('b','e','m', 0 ), // bem = Bemba (Zambia)
  TRUETYPE_TAG('b','e','o', 0 ), // beo = Beami
  TRUETYPE_TAG('b','e','p', 0 ), // bep = Besoa
  TRUETYPE_TAG('b','e','q', 0 ), // beq = Beembe
  TRUETYPE_TAG('b','e','r', 0 ), // ber = Berber languages
  TRUETYPE_TAG('b','e','s', 0 ), // bes = Besme
  TRUETYPE_TAG('b','e','t', 0 ), // bet = Guiberoua Béte
  TRUETYPE_TAG('b','e','u', 0 ), // beu = Blagar
  TRUETYPE_TAG('b','e','v', 0 ), // bev = Daloa Bété
  TRUETYPE_TAG('b','e','w', 0 ), // bew = Betawi
  TRUETYPE_TAG('b','e','x', 0 ), // bex = Jur Modo
  TRUETYPE_TAG('b','e','y', 0 ), // bey = Beli (Papua New Guinea)
  TRUETYPE_TAG('b','e','z', 0 ), // bez = Bena (Tanzania)
  TRUETYPE_TAG('b','f','a', 0 ), // bfa = Bari
  TRUETYPE_TAG('b','f','b', 0 ), // bfb = Pauri Bareli
  TRUETYPE_TAG('b','f','c', 0 ), // bfc = Northern Bai
  TRUETYPE_TAG('b','f','d', 0 ), // bfd = Bafut
  TRUETYPE_TAG('b','f','e', 0 ), // bfe = Betaf
  TRUETYPE_TAG('b','f','f', 0 ), // bff = Bofi
  TRUETYPE_TAG('b','f','g', 0 ), // bfg = Busang Kayan
  TRUETYPE_TAG('b','f','h', 0 ), // bfh = Blafe
  TRUETYPE_TAG('b','f','i', 0 ), // bfi = British Sign Language
  TRUETYPE_TAG('b','f','j', 0 ), // bfj = Bafanji
  TRUETYPE_TAG('b','f','k', 0 ), // bfk = Ban Khor Sign Language
  TRUETYPE_TAG('b','f','l', 0 ), // bfl = Banda-Ndélé
  TRUETYPE_TAG('b','f','m', 0 ), // bfm = Mmen
  TRUETYPE_TAG('b','f','n', 0 ), // bfn = Bunak
  TRUETYPE_TAG('b','f','o', 0 ), // bfo = Malba Birifor
  TRUETYPE_TAG('b','f','p', 0 ), // bfp = Beba
  TRUETYPE_TAG('b','f','q', 0 ), // bfq = Badaga
  TRUETYPE_TAG('b','f','r', 0 ), // bfr = Bazigar
  TRUETYPE_TAG('b','f','s', 0 ), // bfs = Southern Bai
  TRUETYPE_TAG('b','f','t', 0 ), // bft = Balti
  TRUETYPE_TAG('b','f','u', 0 ), // bfu = Gahri
  TRUETYPE_TAG('b','f','w', 0 ), // bfw = Bondo
  TRUETYPE_TAG('b','f','x', 0 ), // bfx = Bantayanon
  TRUETYPE_TAG('b','f','y', 0 ), // bfy = Bagheli
  TRUETYPE_TAG('b','f','z', 0 ), // bfz = Mahasu Pahari
  TRUETYPE_TAG('b','g','a', 0 ), // bga = Gwamhi-Wuri
  TRUETYPE_TAG('b','g','b', 0 ), // bgb = Bobongko
  TRUETYPE_TAG('b','g','c', 0 ), // bgc = Haryanvi
  TRUETYPE_TAG('b','g','d', 0 ), // bgd = Rathwi Bareli
  TRUETYPE_TAG('b','g','e', 0 ), // bge = Bauria
  TRUETYPE_TAG('b','g','f', 0 ), // bgf = Bangandu
  TRUETYPE_TAG('b','g','g', 0 ), // bgg = Bugun
  TRUETYPE_TAG('b','g','i', 0 ), // bgi = Giangan
  TRUETYPE_TAG('b','g','j', 0 ), // bgj = Bangolan
  TRUETYPE_TAG('b','g','k', 0 ), // bgk = Bit
  TRUETYPE_TAG('b','g','l', 0 ), // bgl = Bo (Laos)
  TRUETYPE_TAG('b','g','m', 0 ), // bgm = Baga Mboteni
  TRUETYPE_TAG('b','g','n', 0 ), // bgn = Western Balochi
  TRUETYPE_TAG('b','g','o', 0 ), // bgo = Baga Koga
  TRUETYPE_TAG('b','g','p', 0 ), // bgp = Eastern Balochi
  TRUETYPE_TAG('b','g','q', 0 ), // bgq = Bagri
  TRUETYPE_TAG('b','g','r', 0 ), // bgr = Bawm Chin
  TRUETYPE_TAG('b','g','s', 0 ), // bgs = Tagabawa
  TRUETYPE_TAG('b','g','t', 0 ), // bgt = Bughotu
  TRUETYPE_TAG('b','g','u', 0 ), // bgu = Mbongno
  TRUETYPE_TAG('b','g','v', 0 ), // bgv = Warkay-Bipim
  TRUETYPE_TAG('b','g','w', 0 ), // bgw = Bhatri
  TRUETYPE_TAG('b','g','x', 0 ), // bgx = Balkan Gagauz Turkish
  TRUETYPE_TAG('b','g','y', 0 ), // bgy = Benggoi
  TRUETYPE_TAG('b','g','z', 0 ), // bgz = Banggai
  TRUETYPE_TAG('b','h','a', 0 ), // bha = Bharia
  TRUETYPE_TAG('b','h','b', 0 ), // bhb = Bhili
  TRUETYPE_TAG('b','h','c', 0 ), // bhc = Biga
  TRUETYPE_TAG('b','h','d', 0 ), // bhd = Bhadrawahi
  TRUETYPE_TAG('b','h','e', 0 ), // bhe = Bhaya
  TRUETYPE_TAG('b','h','f', 0 ), // bhf = Odiai
  TRUETYPE_TAG('b','h','g', 0 ), // bhg = Binandere
  TRUETYPE_TAG('b','h','h', 0 ), // bhh = Bukharic
  TRUETYPE_TAG('b','h','i', 0 ), // bhi = Bhilali
  TRUETYPE_TAG('b','h','j', 0 ), // bhj = Bahing
  TRUETYPE_TAG('b','h','k', 0 ), // bhk = Albay Bicolano
  TRUETYPE_TAG('b','h','l', 0 ), // bhl = Bimin
  TRUETYPE_TAG('b','h','m', 0 ), // bhm = Bathari
  TRUETYPE_TAG('b','h','n', 0 ), // bhn = Bohtan Neo-Aramaic
  TRUETYPE_TAG('b','h','o', 0 ), // bho = Bhojpuri
  TRUETYPE_TAG('b','h','p', 0 ), // bhp = Bima
  TRUETYPE_TAG('b','h','q', 0 ), // bhq = Tukang Besi South
  TRUETYPE_TAG('b','h','r', 0 ), // bhr = Bara Malagasy
  TRUETYPE_TAG('b','h','s', 0 ), // bhs = Buwal
  TRUETYPE_TAG('b','h','t', 0 ), // bht = Bhattiyali
  TRUETYPE_TAG('b','h','u', 0 ), // bhu = Bhunjia
  TRUETYPE_TAG('b','h','v', 0 ), // bhv = Bahau
  TRUETYPE_TAG('b','h','w', 0 ), // bhw = Biak
  TRUETYPE_TAG('b','h','x', 0 ), // bhx = Bhalay
  TRUETYPE_TAG('b','h','y', 0 ), // bhy = Bhele
  TRUETYPE_TAG('b','h','z', 0 ), // bhz = Bada (Indonesia)
  TRUETYPE_TAG('b','i','a', 0 ), // bia = Badimaya
  TRUETYPE_TAG('b','i','b', 0 ), // bib = Bissa
  TRUETYPE_TAG('b','i','c', 0 ), // bic = Bikaru
  TRUETYPE_TAG('b','i','d', 0 ), // bid = Bidiyo
  TRUETYPE_TAG('b','i','e', 0 ), // bie = Bepour
  TRUETYPE_TAG('b','i','f', 0 ), // bif = Biafada
  TRUETYPE_TAG('b','i','g', 0 ), // big = Biangai
  TRUETYPE_TAG('b','i','j', 0 ), // bij = Vaghat-Ya-Bijim-Legeri
  TRUETYPE_TAG('b','i','k', 0 ), // bik = Bikol
  TRUETYPE_TAG('b','i','l', 0 ), // bil = Bile
  TRUETYPE_TAG('b','i','m', 0 ), // bim = Bimoba
  TRUETYPE_TAG('b','i','n', 0 ), // bin = Bini
  TRUETYPE_TAG('b','i','o', 0 ), // bio = Nai
  TRUETYPE_TAG('b','i','p', 0 ), // bip = Bila
  TRUETYPE_TAG('b','i','q', 0 ), // biq = Bipi
  TRUETYPE_TAG('b','i','r', 0 ), // bir = Bisorio
  TRUETYPE_TAG('b','i','t', 0 ), // bit = Berinomo
  TRUETYPE_TAG('b','i','u', 0 ), // biu = Biete
  TRUETYPE_TAG('b','i','v', 0 ), // biv = Southern Birifor
  TRUETYPE_TAG('b','i','w', 0 ), // biw = Kol (Cameroon)
  TRUETYPE_TAG('b','i','x', 0 ), // bix = Bijori
  TRUETYPE_TAG('b','i','y', 0 ), // biy = Birhor
  TRUETYPE_TAG('b','i','z', 0 ), // biz = Baloi
  TRUETYPE_TAG('b','j','a', 0 ), // bja = Budza
  TRUETYPE_TAG('b','j','b', 0 ), // bjb = Banggarla
  TRUETYPE_TAG('b','j','c', 0 ), // bjc = Bariji
  TRUETYPE_TAG('b','j','d', 0 ), // bjd = Bandjigali
  TRUETYPE_TAG('b','j','e', 0 ), // bje = Biao-Jiao Mien
  TRUETYPE_TAG('b','j','f', 0 ), // bjf = Barzani Jewish Neo-Aramaic
  TRUETYPE_TAG('b','j','g', 0 ), // bjg = Bidyogo
  TRUETYPE_TAG('b','j','h', 0 ), // bjh = Bahinemo
  TRUETYPE_TAG('b','j','i', 0 ), // bji = Burji
  TRUETYPE_TAG('b','j','j', 0 ), // bjj = Kanauji
  TRUETYPE_TAG('b','j','k', 0 ), // bjk = Barok
  TRUETYPE_TAG('b','j','l', 0 ), // bjl = Bulu (Papua New Guinea)
  TRUETYPE_TAG('b','j','m', 0 ), // bjm = Bajelani
  TRUETYPE_TAG('b','j','n', 0 ), // bjn = Banjar
  TRUETYPE_TAG('b','j','o', 0 ), // bjo = Mid-Southern Banda
  TRUETYPE_TAG('b','j','q', 0 ), // bjq = Southern Betsimisaraka Malagasy
  TRUETYPE_TAG('b','j','r', 0 ), // bjr = Binumarien
  TRUETYPE_TAG('b','j','s', 0 ), // bjs = Bajan
  TRUETYPE_TAG('b','j','t', 0 ), // bjt = Balanta-Ganja
  TRUETYPE_TAG('b','j','u', 0 ), // bju = Busuu
  TRUETYPE_TAG('b','j','v', 0 ), // bjv = Bedjond
  TRUETYPE_TAG('b','j','w', 0 ), // bjw = Bakwé
  TRUETYPE_TAG('b','j','x', 0 ), // bjx = Banao Itneg
  TRUETYPE_TAG('b','j','y', 0 ), // bjy = Bayali
  TRUETYPE_TAG('b','j','z', 0 ), // bjz = Baruga
  TRUETYPE_TAG('b','k','a', 0 ), // bka = Kyak
  TRUETYPE_TAG('b','k','b', 0 ), // bkb = Finallig
  TRUETYPE_TAG('b','k','c', 0 ), // bkc = Baka (Cameroon)
  TRUETYPE_TAG('b','k','d', 0 ), // bkd = Binukid
  TRUETYPE_TAG('b','k','f', 0 ), // bkf = Beeke
  TRUETYPE_TAG('b','k','g', 0 ), // bkg = Buraka
  TRUETYPE_TAG('b','k','h', 0 ), // bkh = Bakoko
  TRUETYPE_TAG('b','k','i', 0 ), // bki = Baki
  TRUETYPE_TAG('b','k','j', 0 ), // bkj = Pande
  TRUETYPE_TAG('b','k','k', 0 ), // bkk = Brokskat
  TRUETYPE_TAG('b','k','l', 0 ), // bkl = Berik
  TRUETYPE_TAG('b','k','m', 0 ), // bkm = Kom (Cameroon)
  TRUETYPE_TAG('b','k','n', 0 ), // bkn = Bukitan
  TRUETYPE_TAG('b','k','o', 0 ), // bko = Kwa'
  TRUETYPE_TAG('b','k','p', 0 ), // bkp = Boko (Democratic Republic of Congo)
  TRUETYPE_TAG('b','k','q', 0 ), // bkq = Bakairí
  TRUETYPE_TAG('b','k','r', 0 ), // bkr = Bakumpai
  TRUETYPE_TAG('b','k','s', 0 ), // bks = Northern Sorsoganon
  TRUETYPE_TAG('b','k','t', 0 ), // bkt = Boloki
  TRUETYPE_TAG('b','k','u', 0 ), // bku = Buhid
  TRUETYPE_TAG('b','k','v', 0 ), // bkv = Bekwarra
  TRUETYPE_TAG('b','k','w', 0 ), // bkw = Bekwel
  TRUETYPE_TAG('b','k','x', 0 ), // bkx = Baikeno
  TRUETYPE_TAG('b','k','y', 0 ), // bky = Bokyi
  TRUETYPE_TAG('b','k','z', 0 ), // bkz = Bungku
  TRUETYPE_TAG('b','l','a', 0 ), // bla = Siksika
  TRUETYPE_TAG('b','l','b', 0 ), // blb = Bilua
  TRUETYPE_TAG('b','l','c', 0 ), // blc = Bella Coola
  TRUETYPE_TAG('b','l','d', 0 ), // bld = Bolango
  TRUETYPE_TAG('b','l','e', 0 ), // ble = Balanta-Kentohe
  TRUETYPE_TAG('b','l','f', 0 ), // blf = Buol
  TRUETYPE_TAG('b','l','g', 0 ), // blg = Balau
  TRUETYPE_TAG('b','l','h', 0 ), // blh = Kuwaa
  TRUETYPE_TAG('b','l','i', 0 ), // bli = Bolia
  TRUETYPE_TAG('b','l','j', 0 ), // blj = Bolongan
  TRUETYPE_TAG('b','l','k', 0 ), // blk = Pa'o Karen
  TRUETYPE_TAG('b','l','l', 0 ), // bll = Biloxi
  TRUETYPE_TAG('b','l','m', 0 ), // blm = Beli (Sudan)
  TRUETYPE_TAG('b','l','n', 0 ), // bln = Southern Catanduanes Bicolano
  TRUETYPE_TAG('b','l','o', 0 ), // blo = Anii
  TRUETYPE_TAG('b','l','p', 0 ), // blp = Blablanga
  TRUETYPE_TAG('b','l','q', 0 ), // blq = Baluan-Pam
  TRUETYPE_TAG('b','l','r', 0 ), // blr = Blang
  TRUETYPE_TAG('b','l','s', 0 ), // bls = Balaesang
  TRUETYPE_TAG('b','l','t', 0 ), // blt = Tai Dam
  TRUETYPE_TAG('b','l','v', 0 ), // blv = Bolo
  TRUETYPE_TAG('b','l','w', 0 ), // blw = Balangao
  TRUETYPE_TAG('b','l','x', 0 ), // blx = Mag-Indi Ayta
  TRUETYPE_TAG('b','l','y', 0 ), // bly = Notre
  TRUETYPE_TAG('b','l','z', 0 ), // blz = Balantak
  TRUETYPE_TAG('b','m','a', 0 ), // bma = Lame
  TRUETYPE_TAG('b','m','b', 0 ), // bmb = Bembe
  TRUETYPE_TAG('b','m','c', 0 ), // bmc = Biem
  TRUETYPE_TAG('b','m','d', 0 ), // bmd = Baga Manduri
  TRUETYPE_TAG('b','m','e', 0 ), // bme = Limassa
  TRUETYPE_TAG('b','m','f', 0 ), // bmf = Bom
  TRUETYPE_TAG('b','m','g', 0 ), // bmg = Bamwe
  TRUETYPE_TAG('b','m','h', 0 ), // bmh = Kein
  TRUETYPE_TAG('b','m','i', 0 ), // bmi = Bagirmi
  TRUETYPE_TAG('b','m','j', 0 ), // bmj = Bote-Majhi
  TRUETYPE_TAG('b','m','k', 0 ), // bmk = Ghayavi
  TRUETYPE_TAG('b','m','l', 0 ), // bml = Bomboli
  TRUETYPE_TAG('b','m','m', 0 ), // bmm = Northern Betsimisaraka Malagasy
  TRUETYPE_TAG('b','m','n', 0 ), // bmn = Bina (Papua New Guinea)
  TRUETYPE_TAG('b','m','o', 0 ), // bmo = Bambalang
  TRUETYPE_TAG('b','m','p', 0 ), // bmp = Bulgebi
  TRUETYPE_TAG('b','m','q', 0 ), // bmq = Bomu
  TRUETYPE_TAG('b','m','r', 0 ), // bmr = Muinane
  TRUETYPE_TAG('b','m','s', 0 ), // bms = Bilma Kanuri
  TRUETYPE_TAG('b','m','t', 0 ), // bmt = Biao Mon
  TRUETYPE_TAG('b','m','u', 0 ), // bmu = Somba-Siawari
  TRUETYPE_TAG('b','m','v', 0 ), // bmv = Bum
  TRUETYPE_TAG('b','m','w', 0 ), // bmw = Bomwali
  TRUETYPE_TAG('b','m','x', 0 ), // bmx = Baimak
  TRUETYPE_TAG('b','m','y', 0 ), // bmy = Bemba (Democratic Republic of Congo)
  TRUETYPE_TAG('b','m','z', 0 ), // bmz = Baramu
  TRUETYPE_TAG('b','n','a', 0 ), // bna = Bonerate
  TRUETYPE_TAG('b','n','b', 0 ), // bnb = Bookan
  TRUETYPE_TAG('b','n','c', 0 ), // bnc = Bontok
  TRUETYPE_TAG('b','n','d', 0 ), // bnd = Banda (Indonesia)
  TRUETYPE_TAG('b','n','e', 0 ), // bne = Bintauna
  TRUETYPE_TAG('b','n','f', 0 ), // bnf = Masiwang
  TRUETYPE_TAG('b','n','g', 0 ), // bng = Benga
  TRUETYPE_TAG('b','n','i', 0 ), // bni = Bangi
  TRUETYPE_TAG('b','n','j', 0 ), // bnj = Eastern Tawbuid
  TRUETYPE_TAG('b','n','k', 0 ), // bnk = Bierebo
  TRUETYPE_TAG('b','n','l', 0 ), // bnl = Boon
  TRUETYPE_TAG('b','n','m', 0 ), // bnm = Batanga
  TRUETYPE_TAG('b','n','n', 0 ), // bnn = Bunun
  TRUETYPE_TAG('b','n','o', 0 ), // bno = Bantoanon
  TRUETYPE_TAG('b','n','p', 0 ), // bnp = Bola
  TRUETYPE_TAG('b','n','q', 0 ), // bnq = Bantik
  TRUETYPE_TAG('b','n','r', 0 ), // bnr = Butmas-Tur
  TRUETYPE_TAG('b','n','s', 0 ), // bns = Bundeli
  TRUETYPE_TAG('b','n','t', 0 ), // bnt = Bantu languages
  TRUETYPE_TAG('b','n','u', 0 ), // bnu = Bentong
  TRUETYPE_TAG('b','n','v', 0 ), // bnv = Bonerif
  TRUETYPE_TAG('b','n','w', 0 ), // bnw = Bisis
  TRUETYPE_TAG('b','n','x', 0 ), // bnx = Bangubangu
  TRUETYPE_TAG('b','n','y', 0 ), // bny = Bintulu
  TRUETYPE_TAG('b','n','z', 0 ), // bnz = Beezen
  TRUETYPE_TAG('b','o','a', 0 ), // boa = Bora
  TRUETYPE_TAG('b','o','b', 0 ), // bob = Aweer
  TRUETYPE_TAG('b','o','e', 0 ), // boe = Mundabli
  TRUETYPE_TAG('b','o','f', 0 ), // bof = Bolon
  TRUETYPE_TAG('b','o','g', 0 ), // bog = Bamako Sign Language
  TRUETYPE_TAG('b','o','h', 0 ), // boh = Boma
  TRUETYPE_TAG('b','o','i', 0 ), // boi = Barbareño
  TRUETYPE_TAG('b','o','j', 0 ), // boj = Anjam
  TRUETYPE_TAG('b','o','k', 0 ), // bok = Bonjo
  TRUETYPE_TAG('b','o','l', 0 ), // bol = Bole
  TRUETYPE_TAG('b','o','m', 0 ), // bom = Berom
  TRUETYPE_TAG('b','o','n', 0 ), // bon = Bine
  TRUETYPE_TAG('b','o','o', 0 ), // boo = Tiemacèwè Bozo
  TRUETYPE_TAG('b','o','p', 0 ), // bop = Bonkiman
  TRUETYPE_TAG('b','o','q', 0 ), // boq = Bogaya
  TRUETYPE_TAG('b','o','r', 0 ), // bor = Borôro
  TRUETYPE_TAG('b','o','t', 0 ), // bot = Bongo
  TRUETYPE_TAG('b','o','u', 0 ), // bou = Bondei
  TRUETYPE_TAG('b','o','v', 0 ), // bov = Tuwuli
  TRUETYPE_TAG('b','o','w', 0 ), // bow = Rema
  TRUETYPE_TAG('b','o','x', 0 ), // box = Buamu
  TRUETYPE_TAG('b','o','y', 0 ), // boy = Bodo (Central African Republic)
  TRUETYPE_TAG('b','o','z', 0 ), // boz = Tiéyaxo Bozo
  TRUETYPE_TAG('b','p','a', 0 ), // bpa = Dakaka
  TRUETYPE_TAG('b','p','b', 0 ), // bpb = Barbacoas
  TRUETYPE_TAG('b','p','d', 0 ), // bpd = Banda-Banda
  TRUETYPE_TAG('b','p','g', 0 ), // bpg = Bonggo
  TRUETYPE_TAG('b','p','h', 0 ), // bph = Botlikh
  TRUETYPE_TAG('b','p','i', 0 ), // bpi = Bagupi
  TRUETYPE_TAG('b','p','j', 0 ), // bpj = Binji
  TRUETYPE_TAG('b','p','k', 0 ), // bpk = Orowe
  TRUETYPE_TAG('b','p','l', 0 ), // bpl = Broome Pearling Lugger Pidgin
  TRUETYPE_TAG('b','p','m', 0 ), // bpm = Biyom
  TRUETYPE_TAG('b','p','n', 0 ), // bpn = Dzao Min
  TRUETYPE_TAG('b','p','o', 0 ), // bpo = Anasi
  TRUETYPE_TAG('b','p','p', 0 ), // bpp = Kaure
  TRUETYPE_TAG('b','p','q', 0 ), // bpq = Banda Malay
  TRUETYPE_TAG('b','p','r', 0 ), // bpr = Koronadal Blaan
  TRUETYPE_TAG('b','p','s', 0 ), // bps = Sarangani Blaan
  TRUETYPE_TAG('b','p','t', 0 ), // bpt = Barrow Point
  TRUETYPE_TAG('b','p','u', 0 ), // bpu = Bongu
  TRUETYPE_TAG('b','p','v', 0 ), // bpv = Bian Marind
  TRUETYPE_TAG('b','p','w', 0 ), // bpw = Bo (Papua New Guinea)
  TRUETYPE_TAG('b','p','x', 0 ), // bpx = Palya Bareli
  TRUETYPE_TAG('b','p','y', 0 ), // bpy = Bishnupriya
  TRUETYPE_TAG('b','p','z', 0 ), // bpz = Bilba
  TRUETYPE_TAG('b','q','a', 0 ), // bqa = Tchumbuli
  TRUETYPE_TAG('b','q','b', 0 ), // bqb = Bagusa
  TRUETYPE_TAG('b','q','c', 0 ), // bqc = Boko (Benin)
  TRUETYPE_TAG('b','q','d', 0 ), // bqd = Bung
  TRUETYPE_TAG('b','q','f', 0 ), // bqf = Baga Kaloum
  TRUETYPE_TAG('b','q','g', 0 ), // bqg = Bago-Kusuntu
  TRUETYPE_TAG('b','q','h', 0 ), // bqh = Baima
  TRUETYPE_TAG('b','q','i', 0 ), // bqi = Bakhtiari
  TRUETYPE_TAG('b','q','j', 0 ), // bqj = Bandial
  TRUETYPE_TAG('b','q','k', 0 ), // bqk = Banda-Mbrès
  TRUETYPE_TAG('b','q','l', 0 ), // bql = Bilakura
  TRUETYPE_TAG('b','q','m', 0 ), // bqm = Wumboko
  TRUETYPE_TAG('b','q','n', 0 ), // bqn = Bulgarian Sign Language
  TRUETYPE_TAG('b','q','o', 0 ), // bqo = Balo
  TRUETYPE_TAG('b','q','p', 0 ), // bqp = Busa
  TRUETYPE_TAG('b','q','q', 0 ), // bqq = Biritai
  TRUETYPE_TAG('b','q','r', 0 ), // bqr = Burusu
  TRUETYPE_TAG('b','q','s', 0 ), // bqs = Bosngun
  TRUETYPE_TAG('b','q','t', 0 ), // bqt = Bamukumbit
  TRUETYPE_TAG('b','q','u', 0 ), // bqu = Boguru
  TRUETYPE_TAG('b','q','v', 0 ), // bqv = Begbere-Ejar
  TRUETYPE_TAG('b','q','w', 0 ), // bqw = Buru (Nigeria)
  TRUETYPE_TAG('b','q','x', 0 ), // bqx = Baangi
  TRUETYPE_TAG('b','q','y', 0 ), // bqy = Bengkala Sign Language
  TRUETYPE_TAG('b','q','z', 0 ), // bqz = Bakaka
  TRUETYPE_TAG('b','r','a', 0 ), // bra = Braj
  TRUETYPE_TAG('b','r','b', 0 ), // brb = Lave
  TRUETYPE_TAG('b','r','c', 0 ), // brc = Berbice Creole Dutch
  TRUETYPE_TAG('b','r','d', 0 ), // brd = Baraamu
  TRUETYPE_TAG('b','r','f', 0 ), // brf = Bera
  TRUETYPE_TAG('b','r','g', 0 ), // brg = Baure
  TRUETYPE_TAG('b','r','h', 0 ), // brh = Brahui
  TRUETYPE_TAG('b','r','i', 0 ), // bri = Mokpwe
  TRUETYPE_TAG('b','r','j', 0 ), // brj = Bieria
  TRUETYPE_TAG('b','r','k', 0 ), // brk = Birked
  TRUETYPE_TAG('b','r','l', 0 ), // brl = Birwa
  TRUETYPE_TAG('b','r','m', 0 ), // brm = Barambu
  TRUETYPE_TAG('b','r','n', 0 ), // brn = Boruca
  TRUETYPE_TAG('b','r','o', 0 ), // bro = Brokkat
  TRUETYPE_TAG('b','r','p', 0 ), // brp = Barapasi
  TRUETYPE_TAG('b','r','q', 0 ), // brq = Breri
  TRUETYPE_TAG('b','r','r', 0 ), // brr = Birao
  TRUETYPE_TAG('b','r','s', 0 ), // brs = Baras
  TRUETYPE_TAG('b','r','t', 0 ), // brt = Bitare
  TRUETYPE_TAG('b','r','u', 0 ), // bru = Eastern Bru
  TRUETYPE_TAG('b','r','v', 0 ), // brv = Western Bru
  TRUETYPE_TAG('b','r','w', 0 ), // brw = Bellari
  TRUETYPE_TAG('b','r','x', 0 ), // brx = Bodo (India)
  TRUETYPE_TAG('b','r','y', 0 ), // bry = Burui
  TRUETYPE_TAG('b','r','z', 0 ), // brz = Bilbil
  TRUETYPE_TAG('b','s','a', 0 ), // bsa = Abinomn
  TRUETYPE_TAG('b','s','b', 0 ), // bsb = Brunei Bisaya
  TRUETYPE_TAG('b','s','c', 0 ), // bsc = Bassari
  TRUETYPE_TAG('b','s','e', 0 ), // bse = Wushi
  TRUETYPE_TAG('b','s','f', 0 ), // bsf = Bauchi
  TRUETYPE_TAG('b','s','g', 0 ), // bsg = Bashkardi
  TRUETYPE_TAG('b','s','h', 0 ), // bsh = Kati
  TRUETYPE_TAG('b','s','i', 0 ), // bsi = Bassossi
  TRUETYPE_TAG('b','s','j', 0 ), // bsj = Bangwinji
  TRUETYPE_TAG('b','s','k', 0 ), // bsk = Burushaski
  TRUETYPE_TAG('b','s','l', 0 ), // bsl = Basa-Gumna
  TRUETYPE_TAG('b','s','m', 0 ), // bsm = Busami
  TRUETYPE_TAG('b','s','n', 0 ), // bsn = Barasana-Eduria
  TRUETYPE_TAG('b','s','o', 0 ), // bso = Buso
  TRUETYPE_TAG('b','s','p', 0 ), // bsp = Baga Sitemu
  TRUETYPE_TAG('b','s','q', 0 ), // bsq = Bassa
  TRUETYPE_TAG('b','s','r', 0 ), // bsr = Bassa-Kontagora
  TRUETYPE_TAG('b','s','s', 0 ), // bss = Akoose
  TRUETYPE_TAG('b','s','t', 0 ), // bst = Basketo
  TRUETYPE_TAG('b','s','u', 0 ), // bsu = Bahonsuai
  TRUETYPE_TAG('b','s','v', 0 ), // bsv = Baga Sobané
  TRUETYPE_TAG('b','s','w', 0 ), // bsw = Baiso
  TRUETYPE_TAG('b','s','x', 0 ), // bsx = Yangkam
  TRUETYPE_TAG('b','s','y', 0 ), // bsy = Sabah Bisaya
  TRUETYPE_TAG('b','t','a', 0 ), // bta = Bata
  TRUETYPE_TAG('b','t','b', 0 ), // btb = Beti (Cameroon)
  TRUETYPE_TAG('b','t','c', 0 ), // btc = Bati (Cameroon)
  TRUETYPE_TAG('b','t','d', 0 ), // btd = Batak Dairi
  TRUETYPE_TAG('b','t','e', 0 ), // bte = Gamo-Ningi
  TRUETYPE_TAG('b','t','f', 0 ), // btf = Birgit
  TRUETYPE_TAG('b','t','g', 0 ), // btg = Gagnoa Bété
  TRUETYPE_TAG('b','t','h', 0 ), // bth = Biatah Bidayuh
  TRUETYPE_TAG('b','t','i', 0 ), // bti = Burate
  TRUETYPE_TAG('b','t','j', 0 ), // btj = Bacanese Malay
  TRUETYPE_TAG('b','t','k', 0 ), // btk = Batak languages
  TRUETYPE_TAG('b','t','l', 0 ), // btl = Bhatola
  TRUETYPE_TAG('b','t','m', 0 ), // btm = Batak Mandailing
  TRUETYPE_TAG('b','t','n', 0 ), // btn = Ratagnon
  TRUETYPE_TAG('b','t','o', 0 ), // bto = Rinconada Bikol
  TRUETYPE_TAG('b','t','p', 0 ), // btp = Budibud
  TRUETYPE_TAG('b','t','q', 0 ), // btq = Batek
  TRUETYPE_TAG('b','t','r', 0 ), // btr = Baetora
  TRUETYPE_TAG('b','t','s', 0 ), // bts = Batak Simalungun
  TRUETYPE_TAG('b','t','t', 0 ), // btt = Bete-Bendi
  TRUETYPE_TAG('b','t','u', 0 ), // btu = Batu
  TRUETYPE_TAG('b','t','v', 0 ), // btv = Bateri
  TRUETYPE_TAG('b','t','w', 0 ), // btw = Butuanon
  TRUETYPE_TAG('b','t','x', 0 ), // btx = Batak Karo
  TRUETYPE_TAG('b','t','y', 0 ), // bty = Bobot
  TRUETYPE_TAG('b','t','z', 0 ), // btz = Batak Alas-Kluet
  TRUETYPE_TAG('b','u','a', 0 ), // bua = Buriat
  TRUETYPE_TAG('b','u','b', 0 ), // bub = Bua
  TRUETYPE_TAG('b','u','c', 0 ), // buc = Bushi
  TRUETYPE_TAG('b','u','d', 0 ), // bud = Ntcham
  TRUETYPE_TAG('b','u','e', 0 ), // bue = Beothuk
  TRUETYPE_TAG('b','u','f', 0 ), // buf = Bushoong
  TRUETYPE_TAG('b','u','g', 0 ), // bug = Buginese
  TRUETYPE_TAG('b','u','h', 0 ), // buh = Younuo Bunu
  TRUETYPE_TAG('b','u','i', 0 ), // bui = Bongili
  TRUETYPE_TAG('b','u','j', 0 ), // buj = Basa-Gurmana
  TRUETYPE_TAG('b','u','k', 0 ), // buk = Bugawac
  TRUETYPE_TAG('b','u','m', 0 ), // bum = Bulu (Cameroon)
  TRUETYPE_TAG('b','u','n', 0 ), // bun = Sherbro
  TRUETYPE_TAG('b','u','o', 0 ), // buo = Terei
  TRUETYPE_TAG('b','u','p', 0 ), // bup = Busoa
  TRUETYPE_TAG('b','u','q', 0 ), // buq = Brem
  TRUETYPE_TAG('b','u','s', 0 ), // bus = Bokobaru
  TRUETYPE_TAG('b','u','t', 0 ), // but = Bungain
  TRUETYPE_TAG('b','u','u', 0 ), // buu = Budu
  TRUETYPE_TAG('b','u','v', 0 ), // buv = Bun
  TRUETYPE_TAG('b','u','w', 0 ), // buw = Bubi
  TRUETYPE_TAG('b','u','x', 0 ), // bux = Boghom
  TRUETYPE_TAG('b','u','y', 0 ), // buy = Bullom So
  TRUETYPE_TAG('b','u','z', 0 ), // buz = Bukwen
  TRUETYPE_TAG('b','v','a', 0 ), // bva = Barein
  TRUETYPE_TAG('b','v','b', 0 ), // bvb = Bube
  TRUETYPE_TAG('b','v','c', 0 ), // bvc = Baelelea
  TRUETYPE_TAG('b','v','d', 0 ), // bvd = Baeggu
  TRUETYPE_TAG('b','v','e', 0 ), // bve = Berau Malay
  TRUETYPE_TAG('b','v','f', 0 ), // bvf = Boor
  TRUETYPE_TAG('b','v','g', 0 ), // bvg = Bonkeng
  TRUETYPE_TAG('b','v','h', 0 ), // bvh = Bure
  TRUETYPE_TAG('b','v','i', 0 ), // bvi = Belanda Viri
  TRUETYPE_TAG('b','v','j', 0 ), // bvj = Baan
  TRUETYPE_TAG('b','v','k', 0 ), // bvk = Bukat
  TRUETYPE_TAG('b','v','l', 0 ), // bvl = Bolivian Sign Language
  TRUETYPE_TAG('b','v','m', 0 ), // bvm = Bamunka
  TRUETYPE_TAG('b','v','n', 0 ), // bvn = Buna
  TRUETYPE_TAG('b','v','o', 0 ), // bvo = Bolgo
  TRUETYPE_TAG('b','v','q', 0 ), // bvq = Birri
  TRUETYPE_TAG('b','v','r', 0 ), // bvr = Burarra
  TRUETYPE_TAG('b','v','t', 0 ), // bvt = Bati (Indonesia)
  TRUETYPE_TAG('b','v','u', 0 ), // bvu = Bukit Malay
  TRUETYPE_TAG('b','v','v', 0 ), // bvv = Baniva
  TRUETYPE_TAG('b','v','w', 0 ), // bvw = Boga
  TRUETYPE_TAG('b','v','x', 0 ), // bvx = Dibole
  TRUETYPE_TAG('b','v','y', 0 ), // bvy = Baybayanon
  TRUETYPE_TAG('b','v','z', 0 ), // bvz = Bauzi
  TRUETYPE_TAG('b','w','a', 0 ), // bwa = Bwatoo
  TRUETYPE_TAG('b','w','b', 0 ), // bwb = Namosi-Naitasiri-Serua
  TRUETYPE_TAG('b','w','c', 0 ), // bwc = Bwile
  TRUETYPE_TAG('b','w','d', 0 ), // bwd = Bwaidoka
  TRUETYPE_TAG('b','w','e', 0 ), // bwe = Bwe Karen
  TRUETYPE_TAG('b','w','f', 0 ), // bwf = Boselewa
  TRUETYPE_TAG('b','w','g', 0 ), // bwg = Barwe
  TRUETYPE_TAG('b','w','h', 0 ), // bwh = Bishuo
  TRUETYPE_TAG('b','w','i', 0 ), // bwi = Baniwa
  TRUETYPE_TAG('b','w','j', 0 ), // bwj = Láá Láá Bwamu
  TRUETYPE_TAG('b','w','k', 0 ), // bwk = Bauwaki
  TRUETYPE_TAG('b','w','l', 0 ), // bwl = Bwela
  TRUETYPE_TAG('b','w','m', 0 ), // bwm = Biwat
  TRUETYPE_TAG('b','w','n', 0 ), // bwn = Wunai Bunu
  TRUETYPE_TAG('b','w','o', 0 ), // bwo = Boro (Ethiopia)
  TRUETYPE_TAG('b','w','p', 0 ), // bwp = Mandobo Bawah
  TRUETYPE_TAG('b','w','q', 0 ), // bwq = Southern Bobo Madaré
  TRUETYPE_TAG('b','w','r', 0 ), // bwr = Bura-Pabir
  TRUETYPE_TAG('b','w','s', 0 ), // bws = Bomboma
  TRUETYPE_TAG('b','w','t', 0 ), // bwt = Bafaw-Balong
  TRUETYPE_TAG('b','w','u', 0 ), // bwu = Buli (Ghana)
  TRUETYPE_TAG('b','w','w', 0 ), // bww = Bwa
  TRUETYPE_TAG('b','w','x', 0 ), // bwx = Bu-Nao Bunu
  TRUETYPE_TAG('b','w','y', 0 ), // bwy = Cwi Bwamu
  TRUETYPE_TAG('b','w','z', 0 ), // bwz = Bwisi
  TRUETYPE_TAG('b','x','a', 0 ), // bxa = Bauro
  TRUETYPE_TAG('b','x','b', 0 ), // bxb = Belanda Bor
  TRUETYPE_TAG('b','x','c', 0 ), // bxc = Molengue
  TRUETYPE_TAG('b','x','d', 0 ), // bxd = Pela
  TRUETYPE_TAG('b','x','e', 0 ), // bxe = Birale
  TRUETYPE_TAG('b','x','f', 0 ), // bxf = Bilur
  TRUETYPE_TAG('b','x','g', 0 ), // bxg = Bangala
  TRUETYPE_TAG('b','x','h', 0 ), // bxh = Buhutu
  TRUETYPE_TAG('b','x','i', 0 ), // bxi = Pirlatapa
  TRUETYPE_TAG('b','x','j', 0 ), // bxj = Bayungu
  TRUETYPE_TAG('b','x','k', 0 ), // bxk = Bukusu
  TRUETYPE_TAG('b','x','l', 0 ), // bxl = Jalkunan
  TRUETYPE_TAG('b','x','m', 0 ), // bxm = Mongolia Buriat
  TRUETYPE_TAG('b','x','n', 0 ), // bxn = Burduna
  TRUETYPE_TAG('b','x','o', 0 ), // bxo = Barikanchi
  TRUETYPE_TAG('b','x','p', 0 ), // bxp = Bebil
  TRUETYPE_TAG('b','x','q', 0 ), // bxq = Beele
  TRUETYPE_TAG('b','x','r', 0 ), // bxr = Russia Buriat
  TRUETYPE_TAG('b','x','s', 0 ), // bxs = Busam
  TRUETYPE_TAG('b','x','u', 0 ), // bxu = China Buriat
  TRUETYPE_TAG('b','x','v', 0 ), // bxv = Berakou
  TRUETYPE_TAG('b','x','w', 0 ), // bxw = Bankagooma
  TRUETYPE_TAG('b','x','x', 0 ), // bxx = Borna (Democratic Republic of Congo)
  TRUETYPE_TAG('b','x','z', 0 ), // bxz = Binahari
  TRUETYPE_TAG('b','y','a', 0 ), // bya = Batak
  TRUETYPE_TAG('b','y','b', 0 ), // byb = Bikya
  TRUETYPE_TAG('b','y','c', 0 ), // byc = Ubaghara
  TRUETYPE_TAG('b','y','d', 0 ), // byd = Benyadu'
  TRUETYPE_TAG('b','y','e', 0 ), // bye = Pouye
  TRUETYPE_TAG('b','y','f', 0 ), // byf = Bete
  TRUETYPE_TAG('b','y','g', 0 ), // byg = Baygo
  TRUETYPE_TAG('b','y','h', 0 ), // byh = Bhujel
  TRUETYPE_TAG('b','y','i', 0 ), // byi = Buyu
  TRUETYPE_TAG('b','y','j', 0 ), // byj = Bina (Nigeria)
  TRUETYPE_TAG('b','y','k', 0 ), // byk = Biao
  TRUETYPE_TAG('b','y','l', 0 ), // byl = Bayono
  TRUETYPE_TAG('b','y','m', 0 ), // bym = Bidyara
  TRUETYPE_TAG('b','y','n', 0 ), // byn = Bilin
  TRUETYPE_TAG('b','y','o', 0 ), // byo = Biyo
  TRUETYPE_TAG('b','y','p', 0 ), // byp = Bumaji
  TRUETYPE_TAG('b','y','q', 0 ), // byq = Basay
  TRUETYPE_TAG('b','y','r', 0 ), // byr = Baruya
  TRUETYPE_TAG('b','y','s', 0 ), // bys = Burak
  TRUETYPE_TAG('b','y','t', 0 ), // byt = Berti
  TRUETYPE_TAG('b','y','v', 0 ), // byv = Medumba
  TRUETYPE_TAG('b','y','w', 0 ), // byw = Belhariya
  TRUETYPE_TAG('b','y','x', 0 ), // byx = Qaqet
  TRUETYPE_TAG('b','y','y', 0 ), // byy = Buya
  TRUETYPE_TAG('b','y','z', 0 ), // byz = Banaro
  TRUETYPE_TAG('b','z','a', 0 ), // bza = Bandi
  TRUETYPE_TAG('b','z','b', 0 ), // bzb = Andio
  TRUETYPE_TAG('b','z','c', 0 ), // bzc = Southern Betsimisaraka Malagasy
  TRUETYPE_TAG('b','z','d', 0 ), // bzd = Bribri
  TRUETYPE_TAG('b','z','e', 0 ), // bze = Jenaama Bozo
  TRUETYPE_TAG('b','z','f', 0 ), // bzf = Boikin
  TRUETYPE_TAG('b','z','g', 0 ), // bzg = Babuza
  TRUETYPE_TAG('b','z','h', 0 ), // bzh = Mapos Buang
  TRUETYPE_TAG('b','z','i', 0 ), // bzi = Bisu
  TRUETYPE_TAG('b','z','j', 0 ), // bzj = Belize Kriol English
  TRUETYPE_TAG('b','z','k', 0 ), // bzk = Nicaragua Creole English
  TRUETYPE_TAG('b','z','l', 0 ), // bzl = Boano (Sulawesi)
  TRUETYPE_TAG('b','z','m', 0 ), // bzm = Bolondo
  TRUETYPE_TAG('b','z','n', 0 ), // bzn = Boano (Maluku)
  TRUETYPE_TAG('b','z','o', 0 ), // bzo = Bozaba
  TRUETYPE_TAG('b','z','p', 0 ), // bzp = Kemberano
  TRUETYPE_TAG('b','z','q', 0 ), // bzq = Buli (Indonesia)
  TRUETYPE_TAG('b','z','r', 0 ), // bzr = Biri
  TRUETYPE_TAG('b','z','s', 0 ), // bzs = Brazilian Sign Language
  TRUETYPE_TAG('b','z','t', 0 ), // bzt = Brithenig
  TRUETYPE_TAG('b','z','u', 0 ), // bzu = Burmeso
  TRUETYPE_TAG('b','z','v', 0 ), // bzv = Bebe
  TRUETYPE_TAG('b','z','w', 0 ), // bzw = Basa (Nigeria)
  TRUETYPE_TAG('b','z','x', 0 ), // bzx = Kɛlɛngaxo Bozo
  TRUETYPE_TAG('b','z','y', 0 ), // bzy = Obanliku
  TRUETYPE_TAG('b','z','z', 0 ), // bzz = Evant
  TRUETYPE_TAG('c','a','a', 0 ), // caa = Chortí
  TRUETYPE_TAG('c','a','b', 0 ), // cab = Garifuna
  TRUETYPE_TAG('c','a','c', 0 ), // cac = Chuj
  TRUETYPE_TAG('c','a','d', 0 ), // cad = Caddo
  TRUETYPE_TAG('c','a','e', 0 ), // cae = Lehar
  TRUETYPE_TAG('c','a','f', 0 ), // caf = Southern Carrier
  TRUETYPE_TAG('c','a','g', 0 ), // cag = Nivaclé
  TRUETYPE_TAG('c','a','h', 0 ), // cah = Cahuarano
  TRUETYPE_TAG('c','a','i', 0 ), // cai = Central American Indian languages
  TRUETYPE_TAG('c','a','j', 0 ), // caj = Chané
  TRUETYPE_TAG('c','a','k', 0 ), // cak = Kaqchikel
  TRUETYPE_TAG('c','a','l', 0 ), // cal = Carolinian
  TRUETYPE_TAG('c','a','m', 0 ), // cam = Cemuhî
  TRUETYPE_TAG('c','a','n', 0 ), // can = Chambri
  TRUETYPE_TAG('c','a','o', 0 ), // cao = Chácobo
  TRUETYPE_TAG('c','a','p', 0 ), // cap = Chipaya
  TRUETYPE_TAG('c','a','q', 0 ), // caq = Car Nicobarese
  TRUETYPE_TAG('c','a','r', 0 ), // car = Galibi Carib
  TRUETYPE_TAG('c','a','s', 0 ), // cas = Tsimané
  TRUETYPE_TAG('c','a','u', 0 ), // cau = Caucasian languages
  TRUETYPE_TAG('c','a','v', 0 ), // cav = Cavineña
  TRUETYPE_TAG('c','a','w', 0 ), // caw = Callawalla
  TRUETYPE_TAG('c','a','x', 0 ), // cax = Chiquitano
  TRUETYPE_TAG('c','a','y', 0 ), // cay = Cayuga
  TRUETYPE_TAG('c','a','z', 0 ), // caz = Canichana
  TRUETYPE_TAG('c','b','a', 0 ), // cba = Chibchan languages
  TRUETYPE_TAG('c','b','b', 0 ), // cbb = Cabiyarí
  TRUETYPE_TAG('c','b','c', 0 ), // cbc = Carapana
  TRUETYPE_TAG('c','b','d', 0 ), // cbd = Carijona
  TRUETYPE_TAG('c','b','e', 0 ), // cbe = Chipiajes
  TRUETYPE_TAG('c','b','g', 0 ), // cbg = Chimila
  TRUETYPE_TAG('c','b','h', 0 ), // cbh = Cagua
  TRUETYPE_TAG('c','b','i', 0 ), // cbi = Chachi
  TRUETYPE_TAG('c','b','j', 0 ), // cbj = Ede Cabe
  TRUETYPE_TAG('c','b','k', 0 ), // cbk = Chavacano
  TRUETYPE_TAG('c','b','l', 0 ), // cbl = Bualkhaw Chin
  TRUETYPE_TAG('c','b','n', 0 ), // cbn = Nyahkur
  TRUETYPE_TAG('c','b','o', 0 ), // cbo = Izora
  TRUETYPE_TAG('c','b','r', 0 ), // cbr = Cashibo-Cacataibo
  TRUETYPE_TAG('c','b','s', 0 ), // cbs = Cashinahua
  TRUETYPE_TAG('c','b','t', 0 ), // cbt = Chayahuita
  TRUETYPE_TAG('c','b','u', 0 ), // cbu = Candoshi-Shapra
  TRUETYPE_TAG('c','b','v', 0 ), // cbv = Cacua
  TRUETYPE_TAG('c','b','w', 0 ), // cbw = Kinabalian
  TRUETYPE_TAG('c','b','y', 0 ), // cby = Carabayo
  TRUETYPE_TAG('c','c','a', 0 ), // cca = Cauca
  TRUETYPE_TAG('c','c','c', 0 ), // ccc = Chamicuro
  TRUETYPE_TAG('c','c','d', 0 ), // ccd = Cafundo Creole
  TRUETYPE_TAG('c','c','e', 0 ), // cce = Chopi
  TRUETYPE_TAG('c','c','g', 0 ), // ccg = Samba Daka
  TRUETYPE_TAG('c','c','h', 0 ), // cch = Atsam
  TRUETYPE_TAG('c','c','j', 0 ), // ccj = Kasanga
  TRUETYPE_TAG('c','c','l', 0 ), // ccl = Cutchi-Swahili
  TRUETYPE_TAG('c','c','m', 0 ), // ccm = Malaccan Creole Malay
  TRUETYPE_TAG('c','c','n', 0 ), // ccn = North Caucasian languages
  TRUETYPE_TAG('c','c','o', 0 ), // cco = Comaltepec Chinantec
  TRUETYPE_TAG('c','c','p', 0 ), // ccp = Chakma
  TRUETYPE_TAG('c','c','q', 0 ), // ccq = Chaungtha
  TRUETYPE_TAG('c','c','r', 0 ), // ccr = Cacaopera
  TRUETYPE_TAG('c','c','s', 0 ), // ccs = South Caucasian languages
  TRUETYPE_TAG('c','d','a', 0 ), // cda = Choni
  TRUETYPE_TAG('c','d','c', 0 ), // cdc = Chadic languages
  TRUETYPE_TAG('c','d','d', 0 ), // cdd = Caddoan languages
  TRUETYPE_TAG('c','d','e', 0 ), // cde = Chenchu
  TRUETYPE_TAG('c','d','f', 0 ), // cdf = Chiru
  TRUETYPE_TAG('c','d','g', 0 ), // cdg = Chamari
  TRUETYPE_TAG('c','d','h', 0 ), // cdh = Chambeali
  TRUETYPE_TAG('c','d','i', 0 ), // cdi = Chodri
  TRUETYPE_TAG('c','d','j', 0 ), // cdj = Churahi
  TRUETYPE_TAG('c','d','m', 0 ), // cdm = Chepang
  TRUETYPE_TAG('c','d','n', 0 ), // cdn = Chaudangsi
  TRUETYPE_TAG('c','d','o', 0 ), // cdo = Min Dong Chinese
  TRUETYPE_TAG('c','d','r', 0 ), // cdr = Cinda-Regi-Tiyal
  TRUETYPE_TAG('c','d','s', 0 ), // cds = Chadian Sign Language
  TRUETYPE_TAG('c','d','y', 0 ), // cdy = Chadong
  TRUETYPE_TAG('c','d','z', 0 ), // cdz = Koda
  TRUETYPE_TAG('c','e','a', 0 ), // cea = Lower Chehalis
  TRUETYPE_TAG('c','e','b', 0 ), // ceb = Cebuano
  TRUETYPE_TAG('c','e','g', 0 ), // ceg = Chamacoco
  TRUETYPE_TAG('c','e','l', 0 ), // cel = Celtic languages
  TRUETYPE_TAG('c','e','n', 0 ), // cen = Cen
  TRUETYPE_TAG('c','e','t', 0 ), // cet = Centúúm
  TRUETYPE_TAG('c','f','a', 0 ), // cfa = Dijim-Bwilim
  TRUETYPE_TAG('c','f','d', 0 ), // cfd = Cara
  TRUETYPE_TAG('c','f','g', 0 ), // cfg = Como Karim
  TRUETYPE_TAG('c','f','m', 0 ), // cfm = Falam Chin
  TRUETYPE_TAG('c','g','a', 0 ), // cga = Changriwa
  TRUETYPE_TAG('c','g','c', 0 ), // cgc = Kagayanen
  TRUETYPE_TAG('c','g','g', 0 ), // cgg = Chiga
  TRUETYPE_TAG('c','g','k', 0 ), // cgk = Chocangacakha
  TRUETYPE_TAG('c','h','b', 0 ), // chb = Chibcha
  TRUETYPE_TAG('c','h','c', 0 ), // chc = Catawba
  TRUETYPE_TAG('c','h','d', 0 ), // chd = Highland Oaxaca Chontal
  TRUETYPE_TAG('c','h','f', 0 ), // chf = Tabasco Chontal
  TRUETYPE_TAG('c','h','g', 0 ), // chg = Chagatai
  TRUETYPE_TAG('c','h','h', 0 ), // chh = Chinook
  TRUETYPE_TAG('c','h','j', 0 ), // chj = Ojitlán Chinantec
  TRUETYPE_TAG('c','h','k', 0 ), // chk = Chuukese
  TRUETYPE_TAG('c','h','l', 0 ), // chl = Cahuilla
  TRUETYPE_TAG('c','h','m', 0 ), // chm = Mari (Russia)
  TRUETYPE_TAG('c','h','n', 0 ), // chn = Chinook jargon
  TRUETYPE_TAG('c','h','o', 0 ), // cho = Choctaw
  TRUETYPE_TAG('c','h','p', 0 ), // chp = Chipewyan
  TRUETYPE_TAG('c','h','q', 0 ), // chq = Quiotepec Chinantec
  TRUETYPE_TAG('c','h','r', 0 ), // chr = Cherokee
  TRUETYPE_TAG('c','h','t', 0 ), // cht = Cholón
  TRUETYPE_TAG('c','h','w', 0 ), // chw = Chuwabu
  TRUETYPE_TAG('c','h','x', 0 ), // chx = Chantyal
  TRUETYPE_TAG('c','h','y', 0 ), // chy = Cheyenne
  TRUETYPE_TAG('c','h','z', 0 ), // chz = Ozumacín Chinantec
  TRUETYPE_TAG('c','i','a', 0 ), // cia = Cia-Cia
  TRUETYPE_TAG('c','i','b', 0 ), // cib = Ci Gbe
  TRUETYPE_TAG('c','i','c', 0 ), // cic = Chickasaw
  TRUETYPE_TAG('c','i','d', 0 ), // cid = Chimariko
  TRUETYPE_TAG('c','i','e', 0 ), // cie = Cineni
  TRUETYPE_TAG('c','i','h', 0 ), // cih = Chinali
  TRUETYPE_TAG('c','i','k', 0 ), // cik = Chitkuli Kinnauri
  TRUETYPE_TAG('c','i','m', 0 ), // cim = Cimbrian
  TRUETYPE_TAG('c','i','n', 0 ), // cin = Cinta Larga
  TRUETYPE_TAG('c','i','p', 0 ), // cip = Chiapanec
  TRUETYPE_TAG('c','i','r', 0 ), // cir = Tiri
  TRUETYPE_TAG('c','i','w', 0 ), // ciw = Chippewa
  TRUETYPE_TAG('c','i','y', 0 ), // ciy = Chaima
  TRUETYPE_TAG('c','j','a', 0 ), // cja = Western Cham
  TRUETYPE_TAG('c','j','e', 0 ), // cje = Chru
  TRUETYPE_TAG('c','j','h', 0 ), // cjh = Upper Chehalis
  TRUETYPE_TAG('c','j','i', 0 ), // cji = Chamalal
  TRUETYPE_TAG('c','j','k', 0 ), // cjk = Chokwe
  TRUETYPE_TAG('c','j','m', 0 ), // cjm = Eastern Cham
  TRUETYPE_TAG('c','j','n', 0 ), // cjn = Chenapian
  TRUETYPE_TAG('c','j','o', 0 ), // cjo = Ashéninka Pajonal
  TRUETYPE_TAG('c','j','p', 0 ), // cjp = Cabécar
  TRUETYPE_TAG('c','j','r', 0 ), // cjr = Chorotega
  TRUETYPE_TAG('c','j','s', 0 ), // cjs = Shor
  TRUETYPE_TAG('c','j','v', 0 ), // cjv = Chuave
  TRUETYPE_TAG('c','j','y', 0 ), // cjy = Jinyu Chinese
  TRUETYPE_TAG('c','k','a', 0 ), // cka = Khumi Awa Chin
  TRUETYPE_TAG('c','k','b', 0 ), // ckb = Central Kurdish
  TRUETYPE_TAG('c','k','h', 0 ), // ckh = Chak
  TRUETYPE_TAG('c','k','l', 0 ), // ckl = Cibak
  TRUETYPE_TAG('c','k','o', 0 ), // cko = Anufo
  TRUETYPE_TAG('c','k','q', 0 ), // ckq = Kajakse
  TRUETYPE_TAG('c','k','r', 0 ), // ckr = Kairak
  TRUETYPE_TAG('c','k','s', 0 ), // cks = Tayo
  TRUETYPE_TAG('c','k','t', 0 ), // ckt = Chukot
  TRUETYPE_TAG('c','k','u', 0 ), // cku = Koasati
  TRUETYPE_TAG('c','k','v', 0 ), // ckv = Kavalan
  TRUETYPE_TAG('c','k','x', 0 ), // ckx = Caka
  TRUETYPE_TAG('c','k','y', 0 ), // cky = Cakfem-Mushere
  TRUETYPE_TAG('c','k','z', 0 ), // ckz = Cakchiquel-Quiché Mixed Language
  TRUETYPE_TAG('c','l','a', 0 ), // cla = Ron
  TRUETYPE_TAG('c','l','c', 0 ), // clc = Chilcotin
  TRUETYPE_TAG('c','l','d', 0 ), // cld = Chaldean Neo-Aramaic
  TRUETYPE_TAG('c','l','e', 0 ), // cle = Lealao Chinantec
  TRUETYPE_TAG('c','l','h', 0 ), // clh = Chilisso
  TRUETYPE_TAG('c','l','i', 0 ), // cli = Chakali
  TRUETYPE_TAG('c','l','k', 0 ), // clk = Idu-Mishmi
  TRUETYPE_TAG('c','l','l', 0 ), // cll = Chala
  TRUETYPE_TAG('c','l','m', 0 ), // clm = Clallam
  TRUETYPE_TAG('c','l','o', 0 ), // clo = Lowland Oaxaca Chontal
  TRUETYPE_TAG('c','l','u', 0 ), // clu = Caluyanun
  TRUETYPE_TAG('c','l','w', 0 ), // clw = Chulym
  TRUETYPE_TAG('c','l','y', 0 ), // cly = Eastern Highland Chatino
  TRUETYPE_TAG('c','m','a', 0 ), // cma = Maa
  TRUETYPE_TAG('c','m','c', 0 ), // cmc = Chamic languages
  TRUETYPE_TAG('c','m','e', 0 ), // cme = Cerma
  TRUETYPE_TAG('c','m','g', 0 ), // cmg = Classical Mongolian
  TRUETYPE_TAG('c','m','i', 0 ), // cmi = Emberá-Chamí
  TRUETYPE_TAG('c','m','k', 0 ), // cmk = Chimakum
  TRUETYPE_TAG('c','m','l', 0 ), // cml = Campalagian
  TRUETYPE_TAG('c','m','m', 0 ), // cmm = Michigamea
  TRUETYPE_TAG('c','m','n', 0 ), // cmn = Mandarin Chinese
  TRUETYPE_TAG('c','m','o', 0 ), // cmo = Central Mnong
  TRUETYPE_TAG('c','m','r', 0 ), // cmr = Mro Chin
  TRUETYPE_TAG('c','m','s', 0 ), // cms = Messapic
  TRUETYPE_TAG('c','m','t', 0 ), // cmt = Camtho
  TRUETYPE_TAG('c','n','a', 0 ), // cna = Changthang
  TRUETYPE_TAG('c','n','b', 0 ), // cnb = Chinbon Chin
  TRUETYPE_TAG('c','n','c', 0 ), // cnc = Côông
  TRUETYPE_TAG('c','n','g', 0 ), // cng = Northern Qiang
  TRUETYPE_TAG('c','n','h', 0 ), // cnh = Haka Chin
  TRUETYPE_TAG('c','n','i', 0 ), // cni = Asháninka
  TRUETYPE_TAG('c','n','k', 0 ), // cnk = Khumi Chin
  TRUETYPE_TAG('c','n','l', 0 ), // cnl = Lalana Chinantec
  TRUETYPE_TAG('c','n','o', 0 ), // cno = Con
  TRUETYPE_TAG('c','n','s', 0 ), // cns = Central Asmat
  TRUETYPE_TAG('c','n','t', 0 ), // cnt = Tepetotutla Chinantec
  TRUETYPE_TAG('c','n','u', 0 ), // cnu = Chenoua
  TRUETYPE_TAG('c','n','w', 0 ), // cnw = Ngawn Chin
  TRUETYPE_TAG('c','n','x', 0 ), // cnx = Middle Cornish
  TRUETYPE_TAG('c','o','a', 0 ), // coa = Cocos Islands Malay
  TRUETYPE_TAG('c','o','b', 0 ), // cob = Chicomuceltec
  TRUETYPE_TAG('c','o','c', 0 ), // coc = Cocopa
  TRUETYPE_TAG('c','o','d', 0 ), // cod = Cocama-Cocamilla
  TRUETYPE_TAG('c','o','e', 0 ), // coe = Koreguaje
  TRUETYPE_TAG('c','o','f', 0 ), // cof = Colorado
  TRUETYPE_TAG('c','o','g', 0 ), // cog = Chong
  TRUETYPE_TAG('c','o','h', 0 ), // coh = Chonyi-Dzihana-Kauma
  TRUETYPE_TAG('c','o','j', 0 ), // coj = Cochimi
  TRUETYPE_TAG('c','o','k', 0 ), // cok = Santa Teresa Cora
  TRUETYPE_TAG('c','o','l', 0 ), // col = Columbia-Wenatchi
  TRUETYPE_TAG('c','o','m', 0 ), // com = Comanche
  TRUETYPE_TAG('c','o','n', 0 ), // con = Cofán
  TRUETYPE_TAG('c','o','o', 0 ), // coo = Comox
  TRUETYPE_TAG('c','o','p', 0 ), // cop = Coptic
  TRUETYPE_TAG('c','o','q', 0 ), // coq = Coquille
  TRUETYPE_TAG('c','o','t', 0 ), // cot = Caquinte
  TRUETYPE_TAG('c','o','u', 0 ), // cou = Wamey
  TRUETYPE_TAG('c','o','v', 0 ), // cov = Cao Miao
  TRUETYPE_TAG('c','o','w', 0 ), // cow = Cowlitz
  TRUETYPE_TAG('c','o','x', 0 ), // cox = Nanti
  TRUETYPE_TAG('c','o','y', 0 ), // coy = Coyaima
  TRUETYPE_TAG('c','o','z', 0 ), // coz = Chochotec
  TRUETYPE_TAG('c','p','a', 0 ), // cpa = Palantla Chinantec
  TRUETYPE_TAG('c','p','b', 0 ), // cpb = Ucayali-Yurúa Ashéninka
  TRUETYPE_TAG('c','p','c', 0 ), // cpc = Ajyíninka Apurucayali
  TRUETYPE_TAG('c','p','e', 0 ), // cpe = English-based creoles and pidgins
  TRUETYPE_TAG('c','p','f', 0 ), // cpf = French-based creoles and pidgins
  TRUETYPE_TAG('c','p','g', 0 ), // cpg = Cappadocian Greek
  TRUETYPE_TAG('c','p','i', 0 ), // cpi = Chinese Pidgin English
  TRUETYPE_TAG('c','p','n', 0 ), // cpn = Cherepon
  TRUETYPE_TAG('c','p','p', 0 ), // cpp = Portuguese-based creoles and pidgins
  TRUETYPE_TAG('c','p','s', 0 ), // cps = Capiznon
  TRUETYPE_TAG('c','p','u', 0 ), // cpu = Pichis Ashéninka
  TRUETYPE_TAG('c','p','x', 0 ), // cpx = Pu-Xian Chinese
  TRUETYPE_TAG('c','p','y', 0 ), // cpy = South Ucayali Ashéninka
  TRUETYPE_TAG('c','q','d', 0 ), // cqd = Chuanqiandian Cluster Miao
  TRUETYPE_TAG('c','q','u', 0 ), // cqu = Chilean Quechua
  TRUETYPE_TAG('c','r','a', 0 ), // cra = Chara
  TRUETYPE_TAG('c','r','b', 0 ), // crb = Island Carib
  TRUETYPE_TAG('c','r','c', 0 ), // crc = Lonwolwol
  TRUETYPE_TAG('c','r','d', 0 ), // crd = Coeur d'Alene
  TRUETYPE_TAG('c','r','f', 0 ), // crf = Caramanta
  TRUETYPE_TAG('c','r','g', 0 ), // crg = Michif
  TRUETYPE_TAG('c','r','h', 0 ), // crh = Crimean Tatar
  TRUETYPE_TAG('c','r','i', 0 ), // cri = Sãotomense
  TRUETYPE_TAG('c','r','j', 0 ), // crj = Southern East Cree
  TRUETYPE_TAG('c','r','k', 0 ), // crk = Plains Cree
  TRUETYPE_TAG('c','r','l', 0 ), // crl = Northern East Cree
  TRUETYPE_TAG('c','r','m', 0 ), // crm = Moose Cree
  TRUETYPE_TAG('c','r','n', 0 ), // crn = El Nayar Cora
  TRUETYPE_TAG('c','r','o', 0 ), // cro = Crow
  TRUETYPE_TAG('c','r','p', 0 ), // crp = Creoles and pidgins
  TRUETYPE_TAG('c','r','q', 0 ), // crq = Iyo'wujwa Chorote
  TRUETYPE_TAG('c','r','r', 0 ), // crr = Carolina Algonquian
  TRUETYPE_TAG('c','r','s', 0 ), // crs = Seselwa Creole French
  TRUETYPE_TAG('c','r','t', 0 ), // crt = Iyojwa'ja Chorote
  TRUETYPE_TAG('c','r','v', 0 ), // crv = Chaura
  TRUETYPE_TAG('c','r','w', 0 ), // crw = Chrau
  TRUETYPE_TAG('c','r','x', 0 ), // crx = Carrier
  TRUETYPE_TAG('c','r','y', 0 ), // cry = Cori
  TRUETYPE_TAG('c','r','z', 0 ), // crz = Cruzeño
  TRUETYPE_TAG('c','s','a', 0 ), // csa = Chiltepec Chinantec
  TRUETYPE_TAG('c','s','b', 0 ), // csb = Kashubian
  TRUETYPE_TAG('c','s','c', 0 ), // csc = Catalan Sign Language
  TRUETYPE_TAG('c','s','d', 0 ), // csd = Chiangmai Sign Language
  TRUETYPE_TAG('c','s','e', 0 ), // cse = Czech Sign Language
  TRUETYPE_TAG('c','s','f', 0 ), // csf = Cuba Sign Language
  TRUETYPE_TAG('c','s','g', 0 ), // csg = Chilean Sign Language
  TRUETYPE_TAG('c','s','h', 0 ), // csh = Asho Chin
  TRUETYPE_TAG('c','s','i', 0 ), // csi = Coast Miwok
  TRUETYPE_TAG('c','s','k', 0 ), // csk = Jola-Kasa
  TRUETYPE_TAG('c','s','l', 0 ), // csl = Chinese Sign Language
  TRUETYPE_TAG('c','s','m', 0 ), // csm = Central Sierra Miwok
  TRUETYPE_TAG('c','s','n', 0 ), // csn = Colombian Sign Language
  TRUETYPE_TAG('c','s','o', 0 ), // cso = Sochiapam Chinantec
  TRUETYPE_TAG('c','s','q', 0 ), // csq = Croatia Sign Language
  TRUETYPE_TAG('c','s','r', 0 ), // csr = Costa Rican Sign Language
  TRUETYPE_TAG('c','s','s', 0 ), // css = Southern Ohlone
  TRUETYPE_TAG('c','s','t', 0 ), // cst = Northern Ohlone
  TRUETYPE_TAG('c','s','u', 0 ), // csu = Central Sudanic languages
  TRUETYPE_TAG('c','s','w', 0 ), // csw = Swampy Cree
  TRUETYPE_TAG('c','s','y', 0 ), // csy = Siyin Chin
  TRUETYPE_TAG('c','s','z', 0 ), // csz = Coos
  TRUETYPE_TAG('c','t','a', 0 ), // cta = Tataltepec Chatino
  TRUETYPE_TAG('c','t','c', 0 ), // ctc = Chetco
  TRUETYPE_TAG('c','t','d', 0 ), // ctd = Tedim Chin
  TRUETYPE_TAG('c','t','e', 0 ), // cte = Tepinapa Chinantec
  TRUETYPE_TAG('c','t','g', 0 ), // ctg = Chittagonian
  TRUETYPE_TAG('c','t','l', 0 ), // ctl = Tlacoatzintepec Chinantec
  TRUETYPE_TAG('c','t','m', 0 ), // ctm = Chitimacha
  TRUETYPE_TAG('c','t','n', 0 ), // ctn = Chhintange
  TRUETYPE_TAG('c','t','o', 0 ), // cto = Emberá-Catío
  TRUETYPE_TAG('c','t','p', 0 ), // ctp = Western Highland Chatino
  TRUETYPE_TAG('c','t','s', 0 ), // cts = Northern Catanduanes Bicolano
  TRUETYPE_TAG('c','t','t', 0 ), // ctt = Wayanad Chetti
  TRUETYPE_TAG('c','t','u', 0 ), // ctu = Chol
  TRUETYPE_TAG('c','t','z', 0 ), // ctz = Zacatepec Chatino
  TRUETYPE_TAG('c','u','a', 0 ), // cua = Cua
  TRUETYPE_TAG('c','u','b', 0 ), // cub = Cubeo
  TRUETYPE_TAG('c','u','c', 0 ), // cuc = Usila Chinantec
  TRUETYPE_TAG('c','u','g', 0 ), // cug = Cung
  TRUETYPE_TAG('c','u','h', 0 ), // cuh = Chuka
  TRUETYPE_TAG('c','u','i', 0 ), // cui = Cuiba
  TRUETYPE_TAG('c','u','j', 0 ), // cuj = Mashco Piro
  TRUETYPE_TAG('c','u','k', 0 ), // cuk = San Blas Kuna
  TRUETYPE_TAG('c','u','l', 0 ), // cul = Culina
  TRUETYPE_TAG('c','u','m', 0 ), // cum = Cumeral
  TRUETYPE_TAG('c','u','o', 0 ), // cuo = Cumanagoto
  TRUETYPE_TAG('c','u','p', 0 ), // cup = Cupeño
  TRUETYPE_TAG('c','u','q', 0 ), // cuq = Cun
  TRUETYPE_TAG('c','u','r', 0 ), // cur = Chhulung
  TRUETYPE_TAG('c','u','s', 0 ), // cus = Cushitic languages
  TRUETYPE_TAG('c','u','t', 0 ), // cut = Teutila Cuicatec
  TRUETYPE_TAG('c','u','u', 0 ), // cuu = Tai Ya
  TRUETYPE_TAG('c','u','v', 0 ), // cuv = Cuvok
  TRUETYPE_TAG('c','u','w', 0 ), // cuw = Chukwa
  TRUETYPE_TAG('c','u','x', 0 ), // cux = Tepeuxila Cuicatec
  TRUETYPE_TAG('c','v','g', 0 ), // cvg = Chug
  TRUETYPE_TAG('c','v','n', 0 ), // cvn = Valle Nacional Chinantec
  TRUETYPE_TAG('c','w','a', 0 ), // cwa = Kabwa
  TRUETYPE_TAG('c','w','b', 0 ), // cwb = Maindo
  TRUETYPE_TAG('c','w','d', 0 ), // cwd = Woods Cree
  TRUETYPE_TAG('c','w','e', 0 ), // cwe = Kwere
  TRUETYPE_TAG('c','w','g', 0 ), // cwg = Chewong
  TRUETYPE_TAG('c','w','t', 0 ), // cwt = Kuwaataay
  TRUETYPE_TAG('c','y','a', 0 ), // cya = Nopala Chatino
  TRUETYPE_TAG('c','y','b', 0 ), // cyb = Cayubaba
  TRUETYPE_TAG('c','y','o', 0 ), // cyo = Cuyonon
  TRUETYPE_TAG('c','z','h', 0 ), // czh = Huizhou Chinese
  TRUETYPE_TAG('c','z','k', 0 ), // czk = Knaanic
  TRUETYPE_TAG('c','z','n', 0 ), // czn = Zenzontepec Chatino
  TRUETYPE_TAG('c','z','o', 0 ), // czo = Min Zhong Chinese
  TRUETYPE_TAG('c','z','t', 0 ), // czt = Zotung Chin
  TRUETYPE_TAG('d','a','a', 0 ), // daa = Dangaléat
  TRUETYPE_TAG('d','a','c', 0 ), // dac = Dambi
  TRUETYPE_TAG('d','a','d', 0 ), // dad = Marik
  TRUETYPE_TAG('d','a','e', 0 ), // dae = Duupa
  TRUETYPE_TAG('d','a','f', 0 ), // daf = Dan
  TRUETYPE_TAG('d','a','g', 0 ), // dag = Dagbani
  TRUETYPE_TAG('d','a','h', 0 ), // dah = Gwahatike
  TRUETYPE_TAG('d','a','i', 0 ), // dai = Day
  TRUETYPE_TAG('d','a','j', 0 ), // daj = Dar Fur Daju
  TRUETYPE_TAG('d','a','k', 0 ), // dak = Dakota
  TRUETYPE_TAG('d','a','l', 0 ), // dal = Dahalo
  TRUETYPE_TAG('d','a','m', 0 ), // dam = Damakawa
  TRUETYPE_TAG('d','a','o', 0 ), // dao = Daai Chin
  TRUETYPE_TAG('d','a','p', 0 ), // dap = Nisi (India)
  TRUETYPE_TAG('d','a','q', 0 ), // daq = Dandami Maria
  TRUETYPE_TAG('d','a','r', 0 ), // dar = Dargwa
  TRUETYPE_TAG('d','a','s', 0 ), // das = Daho-Doo
  TRUETYPE_TAG('d','a','u', 0 ), // dau = Dar Sila Daju
  TRUETYPE_TAG('d','a','v', 0 ), // dav = Taita
  TRUETYPE_TAG('d','a','w', 0 ), // daw = Davawenyo
  TRUETYPE_TAG('d','a','x', 0 ), // dax = Dayi
  TRUETYPE_TAG('d','a','y', 0 ), // day = Land Dayak languages
  TRUETYPE_TAG('d','a','z', 0 ), // daz = Dao
  TRUETYPE_TAG('d','b','a', 0 ), // dba = Bangi Me
  TRUETYPE_TAG('d','b','b', 0 ), // dbb = Deno
  TRUETYPE_TAG('d','b','d', 0 ), // dbd = Dadiya
  TRUETYPE_TAG('d','b','e', 0 ), // dbe = Dabe
  TRUETYPE_TAG('d','b','f', 0 ), // dbf = Edopi
  TRUETYPE_TAG('d','b','g', 0 ), // dbg = Dogul Dom Dogon
  TRUETYPE_TAG('d','b','i', 0 ), // dbi = Doka
  TRUETYPE_TAG('d','b','j', 0 ), // dbj = Ida'an
  TRUETYPE_TAG('d','b','l', 0 ), // dbl = Dyirbal
  TRUETYPE_TAG('d','b','m', 0 ), // dbm = Duguri
  TRUETYPE_TAG('d','b','n', 0 ), // dbn = Duriankere
  TRUETYPE_TAG('d','b','o', 0 ), // dbo = Dulbu
  TRUETYPE_TAG('d','b','p', 0 ), // dbp = Duwai
  TRUETYPE_TAG('d','b','q', 0 ), // dbq = Daba
  TRUETYPE_TAG('d','b','r', 0 ), // dbr = Dabarre
  TRUETYPE_TAG('d','b','u', 0 ), // dbu = Bondum Dom Dogon
  TRUETYPE_TAG('d','b','v', 0 ), // dbv = Dungu
  TRUETYPE_TAG('d','b','y', 0 ), // dby = Dibiyaso
  TRUETYPE_TAG('d','c','c', 0 ), // dcc = Deccan
  TRUETYPE_TAG('d','c','r', 0 ), // dcr = Negerhollands
  TRUETYPE_TAG('d','d','d', 0 ), // ddd = Dongotono
  TRUETYPE_TAG('d','d','e', 0 ), // dde = Doondo
  TRUETYPE_TAG('d','d','g', 0 ), // ddg = Fataluku
  TRUETYPE_TAG('d','d','i', 0 ), // ddi = West Goodenough
  TRUETYPE_TAG('d','d','j', 0 ), // ddj = Jaru
  TRUETYPE_TAG('d','d','n', 0 ), // ddn = Dendi (Benin)
  TRUETYPE_TAG('d','d','o', 0 ), // ddo = Dido
  TRUETYPE_TAG('d','d','s', 0 ), // dds = Donno So Dogon
  TRUETYPE_TAG('d','d','w', 0 ), // ddw = Dawera-Daweloor
  TRUETYPE_TAG('d','e','c', 0 ), // dec = Dagik
  TRUETYPE_TAG('d','e','d', 0 ), // ded = Dedua
  TRUETYPE_TAG('d','e','e', 0 ), // dee = Dewoin
  TRUETYPE_TAG('d','e','f', 0 ), // def = Dezfuli
  TRUETYPE_TAG('d','e','g', 0 ), // deg = Degema
  TRUETYPE_TAG('d','e','h', 0 ), // deh = Dehwari
  TRUETYPE_TAG('d','e','i', 0 ), // dei = Demisa
  TRUETYPE_TAG('d','e','k', 0 ), // dek = Dek
  TRUETYPE_TAG('d','e','l', 0 ), // del = Delaware
  TRUETYPE_TAG('d','e','m', 0 ), // dem = Dem
  TRUETYPE_TAG('d','e','n', 0 ), // den = Slave (Athapascan)
  TRUETYPE_TAG('d','e','p', 0 ), // dep = Pidgin Delaware
  TRUETYPE_TAG('d','e','q', 0 ), // deq = Dendi (Central African Republic)
  TRUETYPE_TAG('d','e','r', 0 ), // der = Deori
  TRUETYPE_TAG('d','e','s', 0 ), // des = Desano
  TRUETYPE_TAG('d','e','v', 0 ), // dev = Domung
  TRUETYPE_TAG('d','e','z', 0 ), // dez = Dengese
  TRUETYPE_TAG('d','g','a', 0 ), // dga = Southern Dagaare
  TRUETYPE_TAG('d','g','b', 0 ), // dgb = Bunoge Dogon
  TRUETYPE_TAG('d','g','c', 0 ), // dgc = Casiguran Dumagat Agta
  TRUETYPE_TAG('d','g','d', 0 ), // dgd = Dagaari Dioula
  TRUETYPE_TAG('d','g','e', 0 ), // dge = Degenan
  TRUETYPE_TAG('d','g','g', 0 ), // dgg = Doga
  TRUETYPE_TAG('d','g','h', 0 ), // dgh = Dghwede
  TRUETYPE_TAG('d','g','i', 0 ), // dgi = Northern Dagara
  TRUETYPE_TAG('d','g','k', 0 ), // dgk = Dagba
  TRUETYPE_TAG('d','g','n', 0 ), // dgn = Dagoman
  TRUETYPE_TAG('d','g','o', 0 ), // dgo = Dogri (individual language)
  TRUETYPE_TAG('d','g','r', 0 ), // dgr = Dogrib
  TRUETYPE_TAG('d','g','s', 0 ), // dgs = Dogoso
  TRUETYPE_TAG('d','g','u', 0 ), // dgu = Degaru
  TRUETYPE_TAG('d','g','x', 0 ), // dgx = Doghoro
  TRUETYPE_TAG('d','g','z', 0 ), // dgz = Daga
  TRUETYPE_TAG('d','h','a', 0 ), // dha = Dhanwar (India)
  TRUETYPE_TAG('d','h','d', 0 ), // dhd = Dhundari
  TRUETYPE_TAG('d','h','g', 0 ), // dhg = Dhangu
  TRUETYPE_TAG('d','h','i', 0 ), // dhi = Dhimal
  TRUETYPE_TAG('d','h','l', 0 ), // dhl = Dhalandji
  TRUETYPE_TAG('d','h','m', 0 ), // dhm = Zemba
  TRUETYPE_TAG('d','h','n', 0 ), // dhn = Dhanki
  TRUETYPE_TAG('d','h','o', 0 ), // dho = Dhodia
  TRUETYPE_TAG('d','h','r', 0 ), // dhr = Dhargari
  TRUETYPE_TAG('d','h','s', 0 ), // dhs = Dhaiso
  TRUETYPE_TAG('d','h','u', 0 ), // dhu = Dhurga
  TRUETYPE_TAG('d','h','v', 0 ), // dhv = Dehu
  TRUETYPE_TAG('d','h','w', 0 ), // dhw = Dhanwar (Nepal)
  TRUETYPE_TAG('d','i','a', 0 ), // dia = Dia
  TRUETYPE_TAG('d','i','b', 0 ), // dib = South Central Dinka
  TRUETYPE_TAG('d','i','c', 0 ), // dic = Lakota Dida
  TRUETYPE_TAG('d','i','d', 0 ), // did = Didinga
  TRUETYPE_TAG('d','i','f', 0 ), // dif = Dieri
  TRUETYPE_TAG('d','i','g', 0 ), // dig = Digo
  TRUETYPE_TAG('d','i','h', 0 ), // dih = Kumiai
  TRUETYPE_TAG('d','i','i', 0 ), // dii = Dimbong
  TRUETYPE_TAG('d','i','j', 0 ), // dij = Dai
  TRUETYPE_TAG('d','i','k', 0 ), // dik = Southwestern Dinka
  TRUETYPE_TAG('d','i','l', 0 ), // dil = Dilling
  TRUETYPE_TAG('d','i','m', 0 ), // dim = Dime
  TRUETYPE_TAG('d','i','n', 0 ), // din = Dinka
  TRUETYPE_TAG('d','i','o', 0 ), // dio = Dibo
  TRUETYPE_TAG('d','i','p', 0 ), // dip = Northeastern Dinka
  TRUETYPE_TAG('d','i','q', 0 ), // diq = Dimli (individual language)
  TRUETYPE_TAG('d','i','r', 0 ), // dir = Dirim
  TRUETYPE_TAG('d','i','s', 0 ), // dis = Dimasa
  TRUETYPE_TAG('d','i','t', 0 ), // dit = Dirari
  TRUETYPE_TAG('d','i','u', 0 ), // diu = Diriku
  TRUETYPE_TAG('d','i','w', 0 ), // diw = Northwestern Dinka
  TRUETYPE_TAG('d','i','x', 0 ), // dix = Dixon Reef
  TRUETYPE_TAG('d','i','y', 0 ), // diy = Diuwe
  TRUETYPE_TAG('d','i','z', 0 ), // diz = Ding
  TRUETYPE_TAG('d','j','b', 0 ), // djb = Djinba
  TRUETYPE_TAG('d','j','c', 0 ), // djc = Dar Daju Daju
  TRUETYPE_TAG('d','j','d', 0 ), // djd = Djamindjung
  TRUETYPE_TAG('d','j','e', 0 ), // dje = Zarma
  TRUETYPE_TAG('d','j','f', 0 ), // djf = Djangun
  TRUETYPE_TAG('d','j','i', 0 ), // dji = Djinang
  TRUETYPE_TAG('d','j','j', 0 ), // djj = Djeebbana
  TRUETYPE_TAG('d','j','k', 0 ), // djk = Eastern Maroon Creole
  TRUETYPE_TAG('d','j','l', 0 ), // djl = Djiwarli
  TRUETYPE_TAG('d','j','m', 0 ), // djm = Jamsay Dogon
  TRUETYPE_TAG('d','j','n', 0 ), // djn = Djauan
  TRUETYPE_TAG('d','j','o', 0 ), // djo = Jangkang
  TRUETYPE_TAG('d','j','r', 0 ), // djr = Djambarrpuyngu
  TRUETYPE_TAG('d','j','u', 0 ), // dju = Kapriman
  TRUETYPE_TAG('d','j','w', 0 ), // djw = Djawi
  TRUETYPE_TAG('d','k','a', 0 ), // dka = Dakpakha
  TRUETYPE_TAG('d','k','k', 0 ), // dkk = Dakka
  TRUETYPE_TAG('d','k','l', 0 ), // dkl = Kolum So Dogon
  TRUETYPE_TAG('d','k','r', 0 ), // dkr = Kuijau
  TRUETYPE_TAG('d','k','s', 0 ), // dks = Southeastern Dinka
  TRUETYPE_TAG('d','k','x', 0 ), // dkx = Mazagway
  TRUETYPE_TAG('d','l','g', 0 ), // dlg = Dolgan
  TRUETYPE_TAG('d','l','m', 0 ), // dlm = Dalmatian
  TRUETYPE_TAG('d','l','n', 0 ), // dln = Darlong
  TRUETYPE_TAG('d','m','a', 0 ), // dma = Duma
  TRUETYPE_TAG('d','m','b', 0 ), // dmb = Mombo Dogon
  TRUETYPE_TAG('d','m','c', 0 ), // dmc = Dimir
  TRUETYPE_TAG('d','m','e', 0 ), // dme = Dugwor
  TRUETYPE_TAG('d','m','g', 0 ), // dmg = Upper Kinabatangan
  TRUETYPE_TAG('d','m','k', 0 ), // dmk = Domaaki
  TRUETYPE_TAG('d','m','l', 0 ), // dml = Dameli
  TRUETYPE_TAG('d','m','m', 0 ), // dmm = Dama
  TRUETYPE_TAG('d','m','n', 0 ), // dmn = Mande languages
  TRUETYPE_TAG('d','m','o', 0 ), // dmo = Kemezung
  TRUETYPE_TAG('d','m','r', 0 ), // dmr = East Damar
  TRUETYPE_TAG('d','m','s', 0 ), // dms = Dampelas
  TRUETYPE_TAG('d','m','u', 0 ), // dmu = Dubu
  TRUETYPE_TAG('d','m','v', 0 ), // dmv = Dumpas
  TRUETYPE_TAG('d','m','x', 0 ), // dmx = Dema
  TRUETYPE_TAG('d','m','y', 0 ), // dmy = Demta
  TRUETYPE_TAG('d','n','a', 0 ), // dna = Upper Grand Valley Dani
  TRUETYPE_TAG('d','n','d', 0 ), // dnd = Daonda
  TRUETYPE_TAG('d','n','e', 0 ), // dne = Ndendeule
  TRUETYPE_TAG('d','n','g', 0 ), // dng = Dungan
  TRUETYPE_TAG('d','n','i', 0 ), // dni = Lower Grand Valley Dani
  TRUETYPE_TAG('d','n','k', 0 ), // dnk = Dengka
  TRUETYPE_TAG('d','n','n', 0 ), // dnn = Dzùùngoo
  TRUETYPE_TAG('d','n','r', 0 ), // dnr = Danaru
  TRUETYPE_TAG('d','n','t', 0 ), // dnt = Mid Grand Valley Dani
  TRUETYPE_TAG('d','n','u', 0 ), // dnu = Danau
  TRUETYPE_TAG('d','n','w', 0 ), // dnw = Western Dani
  TRUETYPE_TAG('d','n','y', 0 ), // dny = Dení
  TRUETYPE_TAG('d','o','a', 0 ), // doa = Dom
  TRUETYPE_TAG('d','o','b', 0 ), // dob = Dobu
  TRUETYPE_TAG('d','o','c', 0 ), // doc = Northern Dong
  TRUETYPE_TAG('d','o','e', 0 ), // doe = Doe
  TRUETYPE_TAG('d','o','f', 0 ), // dof = Domu
  TRUETYPE_TAG('d','o','h', 0 ), // doh = Dong
  TRUETYPE_TAG('d','o','i', 0 ), // doi = Dogri (macrolanguage)
  TRUETYPE_TAG('d','o','k', 0 ), // dok = Dondo
  TRUETYPE_TAG('d','o','l', 0 ), // dol = Doso
  TRUETYPE_TAG('d','o','n', 0 ), // don = Toura (Papua New Guinea)
  TRUETYPE_TAG('d','o','o', 0 ), // doo = Dongo
  TRUETYPE_TAG('d','o','p', 0 ), // dop = Lukpa
  TRUETYPE_TAG('d','o','q', 0 ), // doq = Dominican Sign Language
  TRUETYPE_TAG('d','o','r', 0 ), // dor = Dori'o
  TRUETYPE_TAG('d','o','s', 0 ), // dos = Dogosé
  TRUETYPE_TAG('d','o','t', 0 ), // dot = Dass
  TRUETYPE_TAG('d','o','v', 0 ), // dov = Dombe
  TRUETYPE_TAG('d','o','w', 0 ), // dow = Doyayo
  TRUETYPE_TAG('d','o','x', 0 ), // dox = Bussa
  TRUETYPE_TAG('d','o','y', 0 ), // doy = Dompo
  TRUETYPE_TAG('d','o','z', 0 ), // doz = Dorze
  TRUETYPE_TAG('d','p','p', 0 ), // dpp = Papar
  TRUETYPE_TAG('d','r','a', 0 ), // dra = Dravidian languages
  TRUETYPE_TAG('d','r','b', 0 ), // drb = Dair
  TRUETYPE_TAG('d','r','c', 0 ), // drc = Minderico
  TRUETYPE_TAG('d','r','d', 0 ), // drd = Darmiya
  TRUETYPE_TAG('d','r','e', 0 ), // dre = Dolpo
  TRUETYPE_TAG('d','r','g', 0 ), // drg = Rungus
  TRUETYPE_TAG('d','r','h', 0 ), // drh = Darkhat
  TRUETYPE_TAG('d','r','i', 0 ), // dri = C'lela
  TRUETYPE_TAG('d','r','l', 0 ), // drl = Darling
  TRUETYPE_TAG('d','r','n', 0 ), // drn = West Damar
  TRUETYPE_TAG('d','r','o', 0 ), // dro = Daro-Matu Melanau
  TRUETYPE_TAG('d','r','q', 0 ), // drq = Dura
  TRUETYPE_TAG('d','r','r', 0 ), // drr = Dororo
  TRUETYPE_TAG('d','r','s', 0 ), // drs = Gedeo
  TRUETYPE_TAG('d','r','t', 0 ), // drt = Drents
  TRUETYPE_TAG('d','r','u', 0 ), // dru = Rukai
  TRUETYPE_TAG('d','r','w', 0 ), // drw = Darwazi
  TRUETYPE_TAG('d','r','y', 0 ), // dry = Darai
  TRUETYPE_TAG('d','s','b', 0 ), // dsb = Lower Sorbian
  TRUETYPE_TAG('d','s','e', 0 ), // dse = Dutch Sign Language
  TRUETYPE_TAG('d','s','h', 0 ), // dsh = Daasanach
  TRUETYPE_TAG('d','s','i', 0 ), // dsi = Disa
  TRUETYPE_TAG('d','s','l', 0 ), // dsl = Danish Sign Language
  TRUETYPE_TAG('d','s','n', 0 ), // dsn = Dusner
  TRUETYPE_TAG('d','s','o', 0 ), // dso = Desiya
  TRUETYPE_TAG('d','s','q', 0 ), // dsq = Tadaksahak
  TRUETYPE_TAG('d','t','a', 0 ), // dta = Daur
  TRUETYPE_TAG('d','t','b', 0 ), // dtb = Labuk-Kinabatangan Kadazan
  TRUETYPE_TAG('d','t','d', 0 ), // dtd = Ditidaht
  TRUETYPE_TAG('d','t','i', 0 ), // dti = Ana Tinga Dogon
  TRUETYPE_TAG('d','t','k', 0 ), // dtk = Tene Kan Dogon
  TRUETYPE_TAG('d','t','m', 0 ), // dtm = Tomo Kan Dogon
  TRUETYPE_TAG('d','t','p', 0 ), // dtp = Central Dusun
  TRUETYPE_TAG('d','t','r', 0 ), // dtr = Lotud
  TRUETYPE_TAG('d','t','s', 0 ), // dts = Toro So Dogon
  TRUETYPE_TAG('d','t','t', 0 ), // dtt = Toro Tegu Dogon
  TRUETYPE_TAG('d','t','u', 0 ), // dtu = Tebul Ure Dogon
  TRUETYPE_TAG('d','u','a', 0 ), // dua = Duala
  TRUETYPE_TAG('d','u','b', 0 ), // dub = Dubli
  TRUETYPE_TAG('d','u','c', 0 ), // duc = Duna
  TRUETYPE_TAG('d','u','d', 0 ), // dud = Hun-Saare
  TRUETYPE_TAG('d','u','e', 0 ), // due = Umiray Dumaget Agta
  TRUETYPE_TAG('d','u','f', 0 ), // duf = Dumbea
  TRUETYPE_TAG('d','u','g', 0 ), // dug = Duruma
  TRUETYPE_TAG('d','u','h', 0 ), // duh = Dungra Bhil
  TRUETYPE_TAG('d','u','i', 0 ), // dui = Dumun
  TRUETYPE_TAG('d','u','j', 0 ), // duj = Dhuwal
  TRUETYPE_TAG('d','u','k', 0 ), // duk = Uyajitaya
  TRUETYPE_TAG('d','u','l', 0 ), // dul = Alabat Island Agta
  TRUETYPE_TAG('d','u','m', 0 ), // dum = Middle Dutch (ca. 1050-1350)
  TRUETYPE_TAG('d','u','n', 0 ), // dun = Dusun Deyah
  TRUETYPE_TAG('d','u','o', 0 ), // duo = Dupaninan Agta
  TRUETYPE_TAG('d','u','p', 0 ), // dup = Duano
  TRUETYPE_TAG('d','u','q', 0 ), // duq = Dusun Malang
  TRUETYPE_TAG('d','u','r', 0 ), // dur = Dii
  TRUETYPE_TAG('d','u','s', 0 ), // dus = Dumi
  TRUETYPE_TAG('d','u','u', 0 ), // duu = Drung
  TRUETYPE_TAG('d','u','v', 0 ), // duv = Duvle
  TRUETYPE_TAG('d','u','w', 0 ), // duw = Dusun Witu
  TRUETYPE_TAG('d','u','x', 0 ), // dux = Duungooma
  TRUETYPE_TAG('d','u','y', 0 ), // duy = Dicamay Agta
  TRUETYPE_TAG('d','u','z', 0 ), // duz = Duli
  TRUETYPE_TAG('d','v','a', 0 ), // dva = Duau
  TRUETYPE_TAG('d','w','a', 0 ), // dwa = Diri
  TRUETYPE_TAG('d','w','l', 0 ), // dwl = Walo Kumbe Dogon
  TRUETYPE_TAG('d','w','r', 0 ), // dwr = Dawro
  TRUETYPE_TAG('d','w','s', 0 ), // dws = Dutton World Speedwords
  TRUETYPE_TAG('d','w','w', 0 ), // dww = Dawawa
  TRUETYPE_TAG('d','y','a', 0 ), // dya = Dyan
  TRUETYPE_TAG('d','y','b', 0 ), // dyb = Dyaberdyaber
  TRUETYPE_TAG('d','y','d', 0 ), // dyd = Dyugun
  TRUETYPE_TAG('d','y','g', 0 ), // dyg = Villa Viciosa Agta
  TRUETYPE_TAG('d','y','i', 0 ), // dyi = Djimini Senoufo
  TRUETYPE_TAG('d','y','m', 0 ), // dym = Yanda Dom Dogon
  TRUETYPE_TAG('d','y','n', 0 ), // dyn = Dyangadi
  TRUETYPE_TAG('d','y','o', 0 ), // dyo = Jola-Fonyi
  TRUETYPE_TAG('d','y','u', 0 ), // dyu = Dyula
  TRUETYPE_TAG('d','y','y', 0 ), // dyy = Dyaabugay
  TRUETYPE_TAG('d','z','a', 0 ), // dza = Tunzu
  TRUETYPE_TAG('d','z','d', 0 ), // dzd = Daza
  TRUETYPE_TAG('d','z','g', 0 ), // dzg = Dazaga
  TRUETYPE_TAG('d','z','l', 0 ), // dzl = Dzalakha
  TRUETYPE_TAG('d','z','n', 0 ), // dzn = Dzando
  TRUETYPE_TAG('e','b','g', 0 ), // ebg = Ebughu
  TRUETYPE_TAG('e','b','k', 0 ), // ebk = Eastern Bontok
  TRUETYPE_TAG('e','b','o', 0 ), // ebo = Teke-Ebo
  TRUETYPE_TAG('e','b','r', 0 ), // ebr = Ebrié
  TRUETYPE_TAG('e','b','u', 0 ), // ebu = Embu
  TRUETYPE_TAG('e','c','r', 0 ), // ecr = Eteocretan
  TRUETYPE_TAG('e','c','s', 0 ), // ecs = Ecuadorian Sign Language
  TRUETYPE_TAG('e','c','y', 0 ), // ecy = Eteocypriot
  TRUETYPE_TAG('e','e','e', 0 ), // eee = E
  TRUETYPE_TAG('e','f','a', 0 ), // efa = Efai
  TRUETYPE_TAG('e','f','e', 0 ), // efe = Efe
  TRUETYPE_TAG('e','f','i', 0 ), // efi = Efik
  TRUETYPE_TAG('e','g','a', 0 ), // ega = Ega
  TRUETYPE_TAG('e','g','l', 0 ), // egl = Emilian
  TRUETYPE_TAG('e','g','o', 0 ), // ego = Eggon
  TRUETYPE_TAG('e','g','x', 0 ), // egx = Egyptian languages
  TRUETYPE_TAG('e','g','y', 0 ), // egy = Egyptian (Ancient)
  TRUETYPE_TAG('e','h','u', 0 ), // ehu = Ehueun
  TRUETYPE_TAG('e','i','p', 0 ), // eip = Eipomek
  TRUETYPE_TAG('e','i','t', 0 ), // eit = Eitiep
  TRUETYPE_TAG('e','i','v', 0 ), // eiv = Askopan
  TRUETYPE_TAG('e','j','a', 0 ), // eja = Ejamat
  TRUETYPE_TAG('e','k','a', 0 ), // eka = Ekajuk
  TRUETYPE_TAG('e','k','e', 0 ), // eke = Ekit
  TRUETYPE_TAG('e','k','g', 0 ), // ekg = Ekari
  TRUETYPE_TAG('e','k','i', 0 ), // eki = Eki
  TRUETYPE_TAG('e','k','k', 0 ), // ekk = Standard Estonian
  TRUETYPE_TAG('e','k','l', 0 ), // ekl = Kol
  TRUETYPE_TAG('e','k','m', 0 ), // ekm = Elip
  TRUETYPE_TAG('e','k','o', 0 ), // eko = Koti
  TRUETYPE_TAG('e','k','p', 0 ), // ekp = Ekpeye
  TRUETYPE_TAG('e','k','r', 0 ), // ekr = Yace
  TRUETYPE_TAG('e','k','y', 0 ), // eky = Eastern Kayah
  TRUETYPE_TAG('e','l','e', 0 ), // ele = Elepi
  TRUETYPE_TAG('e','l','h', 0 ), // elh = El Hugeirat
  TRUETYPE_TAG('e','l','i', 0 ), // eli = Nding
  TRUETYPE_TAG('e','l','k', 0 ), // elk = Elkei
  TRUETYPE_TAG('e','l','m', 0 ), // elm = Eleme
  TRUETYPE_TAG('e','l','o', 0 ), // elo = El Molo
  TRUETYPE_TAG('e','l','p', 0 ), // elp = Elpaputih
  TRUETYPE_TAG('e','l','u', 0 ), // elu = Elu
  TRUETYPE_TAG('e','l','x', 0 ), // elx = Elamite
  TRUETYPE_TAG('e','m','a', 0 ), // ema = Emai-Iuleha-Ora
  TRUETYPE_TAG('e','m','b', 0 ), // emb = Embaloh
  TRUETYPE_TAG('e','m','e', 0 ), // eme = Emerillon
  TRUETYPE_TAG('e','m','g', 0 ), // emg = Eastern Meohang
  TRUETYPE_TAG('e','m','i', 0 ), // emi = Mussau-Emira
  TRUETYPE_TAG('e','m','k', 0 ), // emk = Eastern Maninkakan
  TRUETYPE_TAG('e','m','m', 0 ), // emm = Mamulique
  TRUETYPE_TAG('e','m','n', 0 ), // emn = Eman
  TRUETYPE_TAG('e','m','o', 0 ), // emo = Emok
  TRUETYPE_TAG('e','m','p', 0 ), // emp = Northern Emberá
  TRUETYPE_TAG('e','m','s', 0 ), // ems = Pacific Gulf Yupik
  TRUETYPE_TAG('e','m','u', 0 ), // emu = Eastern Muria
  TRUETYPE_TAG('e','m','w', 0 ), // emw = Emplawas
  TRUETYPE_TAG('e','m','x', 0 ), // emx = Erromintxela
  TRUETYPE_TAG('e','m','y', 0 ), // emy = Epigraphic Mayan
  TRUETYPE_TAG('e','n','a', 0 ), // ena = Apali
  TRUETYPE_TAG('e','n','b', 0 ), // enb = Markweeta
  TRUETYPE_TAG('e','n','c', 0 ), // enc = En
  TRUETYPE_TAG('e','n','d', 0 ), // end = Ende
  TRUETYPE_TAG('e','n','f', 0 ), // enf = Forest Enets
  TRUETYPE_TAG('e','n','h', 0 ), // enh = Tundra Enets
  TRUETYPE_TAG('e','n','m', 0 ), // enm = Middle English (1100-1500)
  TRUETYPE_TAG('e','n','n', 0 ), // enn = Engenni
  TRUETYPE_TAG('e','n','o', 0 ), // eno = Enggano
  TRUETYPE_TAG('e','n','q', 0 ), // enq = Enga
  TRUETYPE_TAG('e','n','r', 0 ), // enr = Emumu
  TRUETYPE_TAG('e','n','u', 0 ), // enu = Enu
  TRUETYPE_TAG('e','n','v', 0 ), // env = Enwan (Edu State)
  TRUETYPE_TAG('e','n','w', 0 ), // enw = Enwan (Akwa Ibom State)
  TRUETYPE_TAG('e','o','t', 0 ), // eot = Beti (Côte d'Ivoire)
  TRUETYPE_TAG('e','p','i', 0 ), // epi = Epie
  TRUETYPE_TAG('e','r','a', 0 ), // era = Eravallan
  TRUETYPE_TAG('e','r','g', 0 ), // erg = Sie
  TRUETYPE_TAG('e','r','h', 0 ), // erh = Eruwa
  TRUETYPE_TAG('e','r','i', 0 ), // eri = Ogea
  TRUETYPE_TAG('e','r','k', 0 ), // erk = South Efate
  TRUETYPE_TAG('e','r','o', 0 ), // ero = Horpa
  TRUETYPE_TAG('e','r','r', 0 ), // err = Erre
  TRUETYPE_TAG('e','r','s', 0 ), // ers = Ersu
  TRUETYPE_TAG('e','r','t', 0 ), // ert = Eritai
  TRUETYPE_TAG('e','r','w', 0 ), // erw = Erokwanas
  TRUETYPE_TAG('e','s','e', 0 ), // ese = Ese Ejja
  TRUETYPE_TAG('e','s','h', 0 ), // esh = Eshtehardi
  TRUETYPE_TAG('e','s','i', 0 ), // esi = North Alaskan Inupiatun
  TRUETYPE_TAG('e','s','k', 0 ), // esk = Northwest Alaska Inupiatun
  TRUETYPE_TAG('e','s','l', 0 ), // esl = Egypt Sign Language
  TRUETYPE_TAG('e','s','m', 0 ), // esm = Esuma
  TRUETYPE_TAG('e','s','n', 0 ), // esn = Salvadoran Sign Language
  TRUETYPE_TAG('e','s','o', 0 ), // eso = Estonian Sign Language
  TRUETYPE_TAG('e','s','q', 0 ), // esq = Esselen
  TRUETYPE_TAG('e','s','s', 0 ), // ess = Central Siberian Yupik
  TRUETYPE_TAG('e','s','u', 0 ), // esu = Central Yupik
  TRUETYPE_TAG('e','s','x', 0 ), // esx = Eskimo-Aleut languages
  TRUETYPE_TAG('e','t','b', 0 ), // etb = Etebi
  TRUETYPE_TAG('e','t','c', 0 ), // etc = Etchemin
  TRUETYPE_TAG('e','t','h', 0 ), // eth = Ethiopian Sign Language
  TRUETYPE_TAG('e','t','n', 0 ), // etn = Eton (Vanuatu)
  TRUETYPE_TAG('e','t','o', 0 ), // eto = Eton (Cameroon)
  TRUETYPE_TAG('e','t','r', 0 ), // etr = Edolo
  TRUETYPE_TAG('e','t','s', 0 ), // ets = Yekhee
  TRUETYPE_TAG('e','t','t', 0 ), // ett = Etruscan
  TRUETYPE_TAG('e','t','u', 0 ), // etu = Ejagham
  TRUETYPE_TAG('e','t','x', 0 ), // etx = Eten
  TRUETYPE_TAG('e','t','z', 0 ), // etz = Semimi
  TRUETYPE_TAG('e','u','q', 0 ), // euq = Basque (family)
  TRUETYPE_TAG('e','v','e', 0 ), // eve = Even
  TRUETYPE_TAG('e','v','h', 0 ), // evh = Uvbie
  TRUETYPE_TAG('e','v','n', 0 ), // evn = Evenki
  TRUETYPE_TAG('e','w','o', 0 ), // ewo = Ewondo
  TRUETYPE_TAG('e','x','t', 0 ), // ext = Extremaduran
  TRUETYPE_TAG('e','y','a', 0 ), // eya = Eyak
  TRUETYPE_TAG('e','y','o', 0 ), // eyo = Keiyo
  TRUETYPE_TAG('e','z','e', 0 ), // eze = Uzekwe
  TRUETYPE_TAG('f','a','a', 0 ), // faa = Fasu
  TRUETYPE_TAG('f','a','b', 0 ), // fab = Fa D'ambu
  TRUETYPE_TAG('f','a','d', 0 ), // fad = Wagi
  TRUETYPE_TAG('f','a','f', 0 ), // faf = Fagani
  TRUETYPE_TAG('f','a','g', 0 ), // fag = Finongan
  TRUETYPE_TAG('f','a','h', 0 ), // fah = Baissa Fali
  TRUETYPE_TAG('f','a','i', 0 ), // fai = Faiwol
  TRUETYPE_TAG('f','a','j', 0 ), // faj = Faita
  TRUETYPE_TAG('f','a','k', 0 ), // fak = Fang (Cameroon)
  TRUETYPE_TAG('f','a','l', 0 ), // fal = South Fali
  TRUETYPE_TAG('f','a','m', 0 ), // fam = Fam
  TRUETYPE_TAG('f','a','n', 0 ), // fan = Fang (Equatorial Guinea)
  TRUETYPE_TAG('f','a','p', 0 ), // fap = Palor
  TRUETYPE_TAG('f','a','r', 0 ), // far = Fataleka
  TRUETYPE_TAG('f','a','t', 0 ), // fat = Fanti
  TRUETYPE_TAG('f','a','u', 0 ), // fau = Fayu
  TRUETYPE_TAG('f','a','x', 0 ), // fax = Fala
  TRUETYPE_TAG('f','a','y', 0 ), // fay = Southwestern Fars
  TRUETYPE_TAG('f','a','z', 0 ), // faz = Northwestern Fars
  TRUETYPE_TAG('f','b','l', 0 ), // fbl = West Albay Bikol
  TRUETYPE_TAG('f','c','s', 0 ), // fcs = Quebec Sign Language
  TRUETYPE_TAG('f','e','r', 0 ), // fer = Feroge
  TRUETYPE_TAG('f','f','i', 0 ), // ffi = Foia Foia
  TRUETYPE_TAG('f','f','m', 0 ), // ffm = Maasina Fulfulde
  TRUETYPE_TAG('f','g','r', 0 ), // fgr = Fongoro
  TRUETYPE_TAG('f','i','a', 0 ), // fia = Nobiin
  TRUETYPE_TAG('f','i','e', 0 ), // fie = Fyer
  TRUETYPE_TAG('f','i','l', 0 ), // fil = Filipino
  TRUETYPE_TAG('f','i','p', 0 ), // fip = Fipa
  TRUETYPE_TAG('f','i','r', 0 ), // fir = Firan
  TRUETYPE_TAG('f','i','t', 0 ), // fit = Tornedalen Finnish
  TRUETYPE_TAG('f','i','u', 0 ), // fiu = Finno-Ugrian languages
  TRUETYPE_TAG('f','i','w', 0 ), // fiw = Fiwaga
  TRUETYPE_TAG('f','k','v', 0 ), // fkv = Kven Finnish
  TRUETYPE_TAG('f','l','a', 0 ), // fla = Kalispel-Pend d'Oreille
  TRUETYPE_TAG('f','l','h', 0 ), // flh = Foau
  TRUETYPE_TAG('f','l','i', 0 ), // fli = Fali
  TRUETYPE_TAG('f','l','l', 0 ), // fll = North Fali
  TRUETYPE_TAG('f','l','n', 0 ), // fln = Flinders Island
  TRUETYPE_TAG('f','l','r', 0 ), // flr = Fuliiru
  TRUETYPE_TAG('f','l','y', 0 ), // fly = Tsotsitaal
  TRUETYPE_TAG('f','m','p', 0 ), // fmp = Fe'fe'
  TRUETYPE_TAG('f','m','u', 0 ), // fmu = Far Western Muria
  TRUETYPE_TAG('f','n','g', 0 ), // fng = Fanagalo
  TRUETYPE_TAG('f','n','i', 0 ), // fni = Fania
  TRUETYPE_TAG('f','o','d', 0 ), // fod = Foodo
  TRUETYPE_TAG('f','o','i', 0 ), // foi = Foi
  TRUETYPE_TAG('f','o','m', 0 ), // fom = Foma
  TRUETYPE_TAG('f','o','n', 0 ), // fon = Fon
  TRUETYPE_TAG('f','o','r', 0 ), // for = Fore
  TRUETYPE_TAG('f','o','s', 0 ), // fos = Siraya
  TRUETYPE_TAG('f','o','x', 0 ), // fox = Formosan languages
  TRUETYPE_TAG('f','p','e', 0 ), // fpe = Fernando Po Creole English
  TRUETYPE_TAG('f','q','s', 0 ), // fqs = Fas
  TRUETYPE_TAG('f','r','c', 0 ), // frc = Cajun French
  TRUETYPE_TAG('f','r','d', 0 ), // frd = Fordata
  TRUETYPE_TAG('f','r','k', 0 ), // frk = Frankish
  TRUETYPE_TAG('f','r','m', 0 ), // frm = Middle French (ca. 1400-1600)
  TRUETYPE_TAG('f','r','o', 0 ), // fro = Old French (842-ca. 1400)
  TRUETYPE_TAG('f','r','p', 0 ), // frp = Arpitan
  TRUETYPE_TAG('f','r','q', 0 ), // frq = Forak
  TRUETYPE_TAG('f','r','r', 0 ), // frr = Northern Frisian
  TRUETYPE_TAG('f','r','s', 0 ), // frs = Eastern Frisian
  TRUETYPE_TAG('f','r','t', 0 ), // frt = Fortsenal
  TRUETYPE_TAG('f','s','e', 0 ), // fse = Finnish Sign Language
  TRUETYPE_TAG('f','s','l', 0 ), // fsl = French Sign Language
  TRUETYPE_TAG('f','s','s', 0 ), // fss = Finland-Swedish Sign Language
  TRUETYPE_TAG('f','u','b', 0 ), // fub = Adamawa Fulfulde
  TRUETYPE_TAG('f','u','c', 0 ), // fuc = Pulaar
  TRUETYPE_TAG('f','u','d', 0 ), // fud = East Futuna
  TRUETYPE_TAG('f','u','e', 0 ), // fue = Borgu Fulfulde
  TRUETYPE_TAG('f','u','f', 0 ), // fuf = Pular
  TRUETYPE_TAG('f','u','h', 0 ), // fuh = Western Niger Fulfulde
  TRUETYPE_TAG('f','u','i', 0 ), // fui = Bagirmi Fulfulde
  TRUETYPE_TAG('f','u','j', 0 ), // fuj = Ko
  TRUETYPE_TAG('f','u','m', 0 ), // fum = Fum
  TRUETYPE_TAG('f','u','n', 0 ), // fun = Fulniô
  TRUETYPE_TAG('f','u','q', 0 ), // fuq = Central-Eastern Niger Fulfulde
  TRUETYPE_TAG('f','u','r', 0 ), // fur = Friulian
  TRUETYPE_TAG('f','u','t', 0 ), // fut = Futuna-Aniwa
  TRUETYPE_TAG('f','u','u', 0 ), // fuu = Furu
  TRUETYPE_TAG('f','u','v', 0 ), // fuv = Nigerian Fulfulde
  TRUETYPE_TAG('f','u','y', 0 ), // fuy = Fuyug
  TRUETYPE_TAG('f','v','r', 0 ), // fvr = Fur
  TRUETYPE_TAG('f','w','a', 0 ), // fwa = Fwâi
  TRUETYPE_TAG('f','w','e', 0 ), // fwe = Fwe
  TRUETYPE_TAG('g','a','a', 0 ), // gaa = Ga
  TRUETYPE_TAG('g','a','b', 0 ), // gab = Gabri
  TRUETYPE_TAG('g','a','c', 0 ), // gac = Mixed Great Andamanese
  TRUETYPE_TAG('g','a','d', 0 ), // gad = Gaddang
  TRUETYPE_TAG('g','a','e', 0 ), // gae = Guarequena
  TRUETYPE_TAG('g','a','f', 0 ), // gaf = Gende
  TRUETYPE_TAG('g','a','g', 0 ), // gag = Gagauz
  TRUETYPE_TAG('g','a','h', 0 ), // gah = Alekano
  TRUETYPE_TAG('g','a','i', 0 ), // gai = Borei
  TRUETYPE_TAG('g','a','j', 0 ), // gaj = Gadsup
  TRUETYPE_TAG('g','a','k', 0 ), // gak = Gamkonora
  TRUETYPE_TAG('g','a','l', 0 ), // gal = Galoli
  TRUETYPE_TAG('g','a','m', 0 ), // gam = Kandawo
  TRUETYPE_TAG('g','a','n', 0 ), // gan = Gan Chinese
  TRUETYPE_TAG('g','a','o', 0 ), // gao = Gants
  TRUETYPE_TAG('g','a','p', 0 ), // gap = Gal
  TRUETYPE_TAG('g','a','q', 0 ), // gaq = Gata'
  TRUETYPE_TAG('g','a','r', 0 ), // gar = Galeya
  TRUETYPE_TAG('g','a','s', 0 ), // gas = Adiwasi Garasia
  TRUETYPE_TAG('g','a','t', 0 ), // gat = Kenati
  TRUETYPE_TAG('g','a','u', 0 ), // gau = Mudhili Gadaba
  TRUETYPE_TAG('g','a','v', 0 ), // gav = Gabutamon
  TRUETYPE_TAG('g','a','w', 0 ), // gaw = Nobonob
  TRUETYPE_TAG('g','a','x', 0 ), // gax = Borana-Arsi-Guji Oromo
  TRUETYPE_TAG('g','a','y', 0 ), // gay = Gayo
  TRUETYPE_TAG('g','a','z', 0 ), // gaz = West Central Oromo
  TRUETYPE_TAG('g','b','a', 0 ), // gba = Gbaya (Central African Republic)
  TRUETYPE_TAG('g','b','b', 0 ), // gbb = Kaytetye
  TRUETYPE_TAG('g','b','c', 0 ), // gbc = Garawa
  TRUETYPE_TAG('g','b','d', 0 ), // gbd = Karadjeri
  TRUETYPE_TAG('g','b','e', 0 ), // gbe = Niksek
  TRUETYPE_TAG('g','b','f', 0 ), // gbf = Gaikundi
  TRUETYPE_TAG('g','b','g', 0 ), // gbg = Gbanziri
  TRUETYPE_TAG('g','b','h', 0 ), // gbh = Defi Gbe
  TRUETYPE_TAG('g','b','i', 0 ), // gbi = Galela
  TRUETYPE_TAG('g','b','j', 0 ), // gbj = Bodo Gadaba
  TRUETYPE_TAG('g','b','k', 0 ), // gbk = Gaddi
  TRUETYPE_TAG('g','b','l', 0 ), // gbl = Gamit
  TRUETYPE_TAG('g','b','m', 0 ), // gbm = Garhwali
  TRUETYPE_TAG('g','b','n', 0 ), // gbn = Mo'da
  TRUETYPE_TAG('g','b','o', 0 ), // gbo = Northern Grebo
  TRUETYPE_TAG('g','b','p', 0 ), // gbp = Gbaya-Bossangoa
  TRUETYPE_TAG('g','b','q', 0 ), // gbq = Gbaya-Bozoum
  TRUETYPE_TAG('g','b','r', 0 ), // gbr = Gbagyi
  TRUETYPE_TAG('g','b','s', 0 ), // gbs = Gbesi Gbe
  TRUETYPE_TAG('g','b','u', 0 ), // gbu = Gagadu
  TRUETYPE_TAG('g','b','v', 0 ), // gbv = Gbanu
  TRUETYPE_TAG('g','b','x', 0 ), // gbx = Eastern Xwla Gbe
  TRUETYPE_TAG('g','b','y', 0 ), // gby = Gbari
  TRUETYPE_TAG('g','b','z', 0 ), // gbz = Zoroastrian Dari
  TRUETYPE_TAG('g','c','c', 0 ), // gcc = Mali
  TRUETYPE_TAG('g','c','d', 0 ), // gcd = Ganggalida
  TRUETYPE_TAG('g','c','e', 0 ), // gce = Galice
  TRUETYPE_TAG('g','c','f', 0 ), // gcf = Guadeloupean Creole French
  TRUETYPE_TAG('g','c','l', 0 ), // gcl = Grenadian Creole English
  TRUETYPE_TAG('g','c','n', 0 ), // gcn = Gaina
  TRUETYPE_TAG('g','c','r', 0 ), // gcr = Guianese Creole French
  TRUETYPE_TAG('g','c','t', 0 ), // gct = Colonia Tovar German
  TRUETYPE_TAG('g','d','a', 0 ), // gda = Gade Lohar
  TRUETYPE_TAG('g','d','b', 0 ), // gdb = Pottangi Ollar Gadaba
  TRUETYPE_TAG('g','d','c', 0 ), // gdc = Gugu Badhun
  TRUETYPE_TAG('g','d','d', 0 ), // gdd = Gedaged
  TRUETYPE_TAG('g','d','e', 0 ), // gde = Gude
  TRUETYPE_TAG('g','d','f', 0 ), // gdf = Guduf-Gava
  TRUETYPE_TAG('g','d','g', 0 ), // gdg = Ga'dang
  TRUETYPE_TAG('g','d','h', 0 ), // gdh = Gadjerawang
  TRUETYPE_TAG('g','d','i', 0 ), // gdi = Gundi
  TRUETYPE_TAG('g','d','j', 0 ), // gdj = Gurdjar
  TRUETYPE_TAG('g','d','k', 0 ), // gdk = Gadang
  TRUETYPE_TAG('g','d','l', 0 ), // gdl = Dirasha
  TRUETYPE_TAG('g','d','m', 0 ), // gdm = Laal
  TRUETYPE_TAG('g','d','n', 0 ), // gdn = Umanakaina
  TRUETYPE_TAG('g','d','o', 0 ), // gdo = Ghodoberi
  TRUETYPE_TAG('g','d','q', 0 ), // gdq = Mehri
  TRUETYPE_TAG('g','d','r', 0 ), // gdr = Wipi
  TRUETYPE_TAG('g','d','u', 0 ), // gdu = Gudu
  TRUETYPE_TAG('g','d','x', 0 ), // gdx = Godwari
  TRUETYPE_TAG('g','e','a', 0 ), // gea = Geruma
  TRUETYPE_TAG('g','e','b', 0 ), // geb = Kire
  TRUETYPE_TAG('g','e','c', 0 ), // gec = Gboloo Grebo
  TRUETYPE_TAG('g','e','d', 0 ), // ged = Gade
  TRUETYPE_TAG('g','e','g', 0 ), // geg = Gengle
  TRUETYPE_TAG('g','e','h', 0 ), // geh = Hutterite German
  TRUETYPE_TAG('g','e','i', 0 ), // gei = Gebe
  TRUETYPE_TAG('g','e','j', 0 ), // gej = Gen
  TRUETYPE_TAG('g','e','k', 0 ), // gek = Yiwom
  TRUETYPE_TAG('g','e','l', 0 ), // gel = ut-Ma'in
  TRUETYPE_TAG('g','e','m', 0 ), // gem = Germanic languages
  TRUETYPE_TAG('g','e','q', 0 ), // geq = Geme
  TRUETYPE_TAG('g','e','s', 0 ), // ges = Geser-Gorom
  TRUETYPE_TAG('g','e','w', 0 ), // gew = Gera
  TRUETYPE_TAG('g','e','x', 0 ), // gex = Garre
  TRUETYPE_TAG('g','e','y', 0 ), // gey = Enya
  TRUETYPE_TAG('g','e','z', 0 ), // gez = Geez
  TRUETYPE_TAG('g','f','k', 0 ), // gfk = Patpatar
  TRUETYPE_TAG('g','f','t', 0 ), // gft = Gafat
  TRUETYPE_TAG('g','g','a', 0 ), // gga = Gao
  TRUETYPE_TAG('g','g','b', 0 ), // ggb = Gbii
  TRUETYPE_TAG('g','g','d', 0 ), // ggd = Gugadj
  TRUETYPE_TAG('g','g','e', 0 ), // gge = Guragone
  TRUETYPE_TAG('g','g','g', 0 ), // ggg = Gurgula
  TRUETYPE_TAG('g','g','k', 0 ), // ggk = Kungarakany
  TRUETYPE_TAG('g','g','l', 0 ), // ggl = Ganglau
  TRUETYPE_TAG('g','g','n', 0 ), // ggn = Eastern Gurung
  TRUETYPE_TAG('g','g','o', 0 ), // ggo = Southern Gondi
  TRUETYPE_TAG('g','g','r', 0 ), // ggr = Aghu Tharnggalu
  TRUETYPE_TAG('g','g','t', 0 ), // ggt = Gitua
  TRUETYPE_TAG('g','g','u', 0 ), // ggu = Gagu
  TRUETYPE_TAG('g','g','w', 0 ), // ggw = Gogodala
  TRUETYPE_TAG('g','h','a', 0 ), // gha = Ghadamès
  TRUETYPE_TAG('g','h','c', 0 ), // ghc = Hiberno-Scottish Gaelic
  TRUETYPE_TAG('g','h','e', 0 ), // ghe = Southern Ghale
  TRUETYPE_TAG('g','h','h', 0 ), // ghh = Northern Ghale
  TRUETYPE_TAG('g','h','k', 0 ), // ghk = Geko Karen
  TRUETYPE_TAG('g','h','l', 0 ), // ghl = Ghulfan
  TRUETYPE_TAG('g','h','n', 0 ), // ghn = Ghanongga
  TRUETYPE_TAG('g','h','o', 0 ), // gho = Ghomara
  TRUETYPE_TAG('g','h','r', 0 ), // ghr = Ghera
  TRUETYPE_TAG('g','h','s', 0 ), // ghs = Guhu-Samane
  TRUETYPE_TAG('g','h','t', 0 ), // ght = Kutang Ghale
  TRUETYPE_TAG('g','i','a', 0 ), // gia = Kitja
  TRUETYPE_TAG('g','i','b', 0 ), // gib = Gibanawa
  TRUETYPE_TAG('g','i','c', 0 ), // gic = Gail
  TRUETYPE_TAG('g','i','d', 0 ), // gid = Gidar
  TRUETYPE_TAG('g','i','g', 0 ), // gig = Goaria
  TRUETYPE_TAG('g','i','l', 0 ), // gil = Gilbertese
  TRUETYPE_TAG('g','i','m', 0 ), // gim = Gimi (Eastern Highlands)
  TRUETYPE_TAG('g','i','n', 0 ), // gin = Hinukh
  TRUETYPE_TAG('g','i','o', 0 ), // gio = Gelao
  TRUETYPE_TAG('g','i','p', 0 ), // gip = Gimi (West New Britain)
  TRUETYPE_TAG('g','i','q', 0 ), // giq = Green Gelao
  TRUETYPE_TAG('g','i','r', 0 ), // gir = Red Gelao
  TRUETYPE_TAG('g','i','s', 0 ), // gis = North Giziga
  TRUETYPE_TAG('g','i','t', 0 ), // git = Gitxsan
  TRUETYPE_TAG('g','i','w', 0 ), // giw = White Gelao
  TRUETYPE_TAG('g','i','x', 0 ), // gix = Gilima
  TRUETYPE_TAG('g','i','y', 0 ), // giy = Giyug
  TRUETYPE_TAG('g','i','z', 0 ), // giz = South Giziga
  TRUETYPE_TAG('g','j','i', 0 ), // gji = Geji
  TRUETYPE_TAG('g','j','k', 0 ), // gjk = Kachi Koli
  TRUETYPE_TAG('g','j','n', 0 ), // gjn = Gonja
  TRUETYPE_TAG('g','j','u', 0 ), // gju = Gujari
  TRUETYPE_TAG('g','k','a', 0 ), // gka = Guya
  TRUETYPE_TAG('g','k','e', 0 ), // gke = Ndai
  TRUETYPE_TAG('g','k','n', 0 ), // gkn = Gokana
  TRUETYPE_TAG('g','k','p', 0 ), // gkp = Guinea Kpelle
  TRUETYPE_TAG('g','l','c', 0 ), // glc = Bon Gula
  TRUETYPE_TAG('g','l','d', 0 ), // gld = Nanai
  TRUETYPE_TAG('g','l','h', 0 ), // glh = Northwest Pashayi
  TRUETYPE_TAG('g','l','i', 0 ), // gli = Guliguli
  TRUETYPE_TAG('g','l','j', 0 ), // glj = Gula Iro
  TRUETYPE_TAG('g','l','k', 0 ), // glk = Gilaki
  TRUETYPE_TAG('g','l','o', 0 ), // glo = Galambu
  TRUETYPE_TAG('g','l','r', 0 ), // glr = Glaro-Twabo
  TRUETYPE_TAG('g','l','u', 0 ), // glu = Gula (Chad)
  TRUETYPE_TAG('g','l','w', 0 ), // glw = Glavda
  TRUETYPE_TAG('g','l','y', 0 ), // gly = Gule
  TRUETYPE_TAG('g','m','a', 0 ), // gma = Gambera
  TRUETYPE_TAG('g','m','b', 0 ), // gmb = Gula'alaa
  TRUETYPE_TAG('g','m','d', 0 ), // gmd = Mághdì
  TRUETYPE_TAG('g','m','e', 0 ), // gme = East Germanic languages
  TRUETYPE_TAG('g','m','h', 0 ), // gmh = Middle High German (ca. 1050-1500)
  TRUETYPE_TAG('g','m','l', 0 ), // gml = Middle Low German
  TRUETYPE_TAG('g','m','m', 0 ), // gmm = Gbaya-Mbodomo
  TRUETYPE_TAG('g','m','n', 0 ), // gmn = Gimnime
  TRUETYPE_TAG('g','m','q', 0 ), // gmq = North Germanic languages
  TRUETYPE_TAG('g','m','u', 0 ), // gmu = Gumalu
  TRUETYPE_TAG('g','m','v', 0 ), // gmv = Gamo
  TRUETYPE_TAG('g','m','w', 0 ), // gmw = West Germanic languages
  TRUETYPE_TAG('g','m','x', 0 ), // gmx = Magoma
  TRUETYPE_TAG('g','m','y', 0 ), // gmy = Mycenaean Greek
  TRUETYPE_TAG('g','n','a', 0 ), // gna = Kaansa
  TRUETYPE_TAG('g','n','b', 0 ), // gnb = Gangte
  TRUETYPE_TAG('g','n','c', 0 ), // gnc = Guanche
  TRUETYPE_TAG('g','n','d', 0 ), // gnd = Zulgo-Gemzek
  TRUETYPE_TAG('g','n','e', 0 ), // gne = Ganang
  TRUETYPE_TAG('g','n','g', 0 ), // gng = Ngangam
  TRUETYPE_TAG('g','n','h', 0 ), // gnh = Lere
  TRUETYPE_TAG('g','n','i', 0 ), // gni = Gooniyandi
  TRUETYPE_TAG('g','n','k', 0 ), // gnk = //Gana
  TRUETYPE_TAG('g','n','l', 0 ), // gnl = Gangulu
  TRUETYPE_TAG('g','n','m', 0 ), // gnm = Ginuman
  TRUETYPE_TAG('g','n','n', 0 ), // gnn = Gumatj
  TRUETYPE_TAG('g','n','o', 0 ), // gno = Northern Gondi
  TRUETYPE_TAG('g','n','q', 0 ), // gnq = Gana
  TRUETYPE_TAG('g','n','r', 0 ), // gnr = Gureng Gureng
  TRUETYPE_TAG('g','n','t', 0 ), // gnt = Guntai
  TRUETYPE_TAG('g','n','u', 0 ), // gnu = Gnau
  TRUETYPE_TAG('g','n','w', 0 ), // gnw = Western Bolivian Guaraní
  TRUETYPE_TAG('g','n','z', 0 ), // gnz = Ganzi
  TRUETYPE_TAG('g','o','a', 0 ), // goa = Guro
  TRUETYPE_TAG('g','o','b', 0 ), // gob = Playero
  TRUETYPE_TAG('g','o','c', 0 ), // goc = Gorakor
  TRUETYPE_TAG('g','o','d', 0 ), // god = Godié
  TRUETYPE_TAG('g','o','e', 0 ), // goe = Gongduk
  TRUETYPE_TAG('g','o','f', 0 ), // gof = Gofa
  TRUETYPE_TAG('g','o','g', 0 ), // gog = Gogo
  TRUETYPE_TAG('g','o','h', 0 ), // goh = Old High German (ca. 750-1050)
  TRUETYPE_TAG('g','o','i', 0 ), // goi = Gobasi
  TRUETYPE_TAG('g','o','j', 0 ), // goj = Gowlan
  TRUETYPE_TAG('g','o','k', 0 ), // gok = Gowli
  TRUETYPE_TAG('g','o','l', 0 ), // gol = Gola
  TRUETYPE_TAG('g','o','m', 0 ), // gom = Goan Konkani
  TRUETYPE_TAG('g','o','n', 0 ), // gon = Gondi
  TRUETYPE_TAG('g','o','o', 0 ), // goo = Gone Dau
  TRUETYPE_TAG('g','o','p', 0 ), // gop = Yeretuar
  TRUETYPE_TAG('g','o','q', 0 ), // goq = Gorap
  TRUETYPE_TAG('g','o','r', 0 ), // gor = Gorontalo
  TRUETYPE_TAG('g','o','s', 0 ), // gos = Gronings
  TRUETYPE_TAG('g','o','t', 0 ), // got = Gothic
  TRUETYPE_TAG('g','o','u', 0 ), // gou = Gavar
  TRUETYPE_TAG('g','o','w', 0 ), // gow = Gorowa
  TRUETYPE_TAG('g','o','x', 0 ), // gox = Gobu
  TRUETYPE_TAG('g','o','y', 0 ), // goy = Goundo
  TRUETYPE_TAG('g','o','z', 0 ), // goz = Gozarkhani
  TRUETYPE_TAG('g','p','a', 0 ), // gpa = Gupa-Abawa
  TRUETYPE_TAG('g','p','n', 0 ), // gpn = Taiap
  TRUETYPE_TAG('g','q','a', 0 ), // gqa = Ga'anda
  TRUETYPE_TAG('g','q','i', 0 ), // gqi = Guiqiong
  TRUETYPE_TAG('g','q','n', 0 ), // gqn = Guana (Brazil)
  TRUETYPE_TAG('g','q','r', 0 ), // gqr = Gor
  TRUETYPE_TAG('g','r','a', 0 ), // gra = Rajput Garasia
  TRUETYPE_TAG('g','r','b', 0 ), // grb = Grebo
  TRUETYPE_TAG('g','r','c', 0 ), // grc = Ancient Greek (to 1453)
  TRUETYPE_TAG('g','r','d', 0 ), // grd = Guruntum-Mbaaru
  TRUETYPE_TAG('g','r','g', 0 ), // grg = Madi
  TRUETYPE_TAG('g','r','h', 0 ), // grh = Gbiri-Niragu
  TRUETYPE_TAG('g','r','i', 0 ), // gri = Ghari
  TRUETYPE_TAG('g','r','j', 0 ), // grj = Southern Grebo
  TRUETYPE_TAG('g','r','k', 0 ), // grk = Greek languages
  TRUETYPE_TAG('g','r','m', 0 ), // grm = Kota Marudu Talantang
  TRUETYPE_TAG('g','r','o', 0 ), // gro = Groma
  TRUETYPE_TAG('g','r','q', 0 ), // grq = Gorovu
  TRUETYPE_TAG('g','r','r', 0 ), // grr = Taznatit
  TRUETYPE_TAG('g','r','s', 0 ), // grs = Gresi
  TRUETYPE_TAG('g','r','t', 0 ), // grt = Garo
  TRUETYPE_TAG('g','r','u', 0 ), // gru = Kistane
  TRUETYPE_TAG('g','r','v', 0 ), // grv = Central Grebo
  TRUETYPE_TAG('g','r','w', 0 ), // grw = Gweda
  TRUETYPE_TAG('g','r','x', 0 ), // grx = Guriaso
  TRUETYPE_TAG('g','r','y', 0 ), // gry = Barclayville Grebo
  TRUETYPE_TAG('g','r','z', 0 ), // grz = Guramalum
  TRUETYPE_TAG('g','s','e', 0 ), // gse = Ghanaian Sign Language
  TRUETYPE_TAG('g','s','g', 0 ), // gsg = German Sign Language
  TRUETYPE_TAG('g','s','l', 0 ), // gsl = Gusilay
  TRUETYPE_TAG('g','s','m', 0 ), // gsm = Guatemalan Sign Language
  TRUETYPE_TAG('g','s','n', 0 ), // gsn = Gusan
  TRUETYPE_TAG('g','s','o', 0 ), // gso = Southwest Gbaya
  TRUETYPE_TAG('g','s','p', 0 ), // gsp = Wasembo
  TRUETYPE_TAG('g','s','s', 0 ), // gss = Greek Sign Language
  TRUETYPE_TAG('g','s','w', 0 ), // gsw = Swiss German
  TRUETYPE_TAG('g','t','a', 0 ), // gta = Guató
  TRUETYPE_TAG('g','t','i', 0 ), // gti = Gbati-ri
  TRUETYPE_TAG('g','u','a', 0 ), // gua = Shiki
  TRUETYPE_TAG('g','u','b', 0 ), // gub = Guajajára
  TRUETYPE_TAG('g','u','c', 0 ), // guc = Wayuu
  TRUETYPE_TAG('g','u','d', 0 ), // gud = Yocoboué Dida
  TRUETYPE_TAG('g','u','e', 0 ), // gue = Gurinji
  TRUETYPE_TAG('g','u','f', 0 ), // guf = Gupapuyngu
  TRUETYPE_TAG('g','u','g', 0 ), // gug = Paraguayan Guaraní
  TRUETYPE_TAG('g','u','h', 0 ), // guh = Guahibo
  TRUETYPE_TAG('g','u','i', 0 ), // gui = Eastern Bolivian Guaraní
  TRUETYPE_TAG('g','u','k', 0 ), // guk = Gumuz
  TRUETYPE_TAG('g','u','l', 0 ), // gul = Sea Island Creole English
  TRUETYPE_TAG('g','u','m', 0 ), // gum = Guambiano
  TRUETYPE_TAG('g','u','n', 0 ), // gun = Mbyá Guaraní
  TRUETYPE_TAG('g','u','o', 0 ), // guo = Guayabero
  TRUETYPE_TAG('g','u','p', 0 ), // gup = Gunwinggu
  TRUETYPE_TAG('g','u','q', 0 ), // guq = Aché
  TRUETYPE_TAG('g','u','r', 0 ), // gur = Farefare
  TRUETYPE_TAG('g','u','s', 0 ), // gus = Guinean Sign Language
  TRUETYPE_TAG('g','u','t', 0 ), // gut = Maléku Jaíka
  TRUETYPE_TAG('g','u','u', 0 ), // guu = Yanomamö
  TRUETYPE_TAG('g','u','v', 0 ), // guv = Gey
  TRUETYPE_TAG('g','u','w', 0 ), // guw = Gun
  TRUETYPE_TAG('g','u','x', 0 ), // gux = Gourmanchéma
  TRUETYPE_TAG('g','u','z', 0 ), // guz = Gusii
  TRUETYPE_TAG('g','v','a', 0 ), // gva = Guana (Paraguay)
  TRUETYPE_TAG('g','v','c', 0 ), // gvc = Guanano
  TRUETYPE_TAG('g','v','e', 0 ), // gve = Duwet
  TRUETYPE_TAG('g','v','f', 0 ), // gvf = Golin
  TRUETYPE_TAG('g','v','j', 0 ), // gvj = Guajá
  TRUETYPE_TAG('g','v','l', 0 ), // gvl = Gulay
  TRUETYPE_TAG('g','v','m', 0 ), // gvm = Gurmana
  TRUETYPE_TAG('g','v','n', 0 ), // gvn = Kuku-Yalanji
  TRUETYPE_TAG('g','v','o', 0 ), // gvo = Gavião Do Jiparaná
  TRUETYPE_TAG('g','v','p', 0 ), // gvp = Pará Gavião
  TRUETYPE_TAG('g','v','r', 0 ), // gvr = Western Gurung
  TRUETYPE_TAG('g','v','s', 0 ), // gvs = Gumawana
  TRUETYPE_TAG('g','v','y', 0 ), // gvy = Guyani
  TRUETYPE_TAG('g','w','a', 0 ), // gwa = Mbato
  TRUETYPE_TAG('g','w','b', 0 ), // gwb = Gwa
  TRUETYPE_TAG('g','w','c', 0 ), // gwc = Kalami
  TRUETYPE_TAG('g','w','d', 0 ), // gwd = Gawwada
  TRUETYPE_TAG('g','w','e', 0 ), // gwe = Gweno
  TRUETYPE_TAG('g','w','f', 0 ), // gwf = Gowro
  TRUETYPE_TAG('g','w','g', 0 ), // gwg = Moo
  TRUETYPE_TAG('g','w','i', 0 ), // gwi = Gwichʼin
  TRUETYPE_TAG('g','w','j', 0 ), // gwj = /Gwi
  TRUETYPE_TAG('g','w','n', 0 ), // gwn = Gwandara
  TRUETYPE_TAG('g','w','r', 0 ), // gwr = Gwere
  TRUETYPE_TAG('g','w','t', 0 ), // gwt = Gawar-Bati
  TRUETYPE_TAG('g','w','u', 0 ), // gwu = Guwamu
  TRUETYPE_TAG('g','w','w', 0 ), // gww = Kwini
  TRUETYPE_TAG('g','w','x', 0 ), // gwx = Gua
  TRUETYPE_TAG('g','x','x', 0 ), // gxx = Wè Southern
  TRUETYPE_TAG('g','y','a', 0 ), // gya = Northwest Gbaya
  TRUETYPE_TAG('g','y','b', 0 ), // gyb = Garus
  TRUETYPE_TAG('g','y','d', 0 ), // gyd = Kayardild
  TRUETYPE_TAG('g','y','e', 0 ), // gye = Gyem
  TRUETYPE_TAG('g','y','f', 0 ), // gyf = Gungabula
  TRUETYPE_TAG('g','y','g', 0 ), // gyg = Gbayi
  TRUETYPE_TAG('g','y','i', 0 ), // gyi = Gyele
  TRUETYPE_TAG('g','y','l', 0 ), // gyl = Gayil
  TRUETYPE_TAG('g','y','m', 0 ), // gym = Ngäbere
  TRUETYPE_TAG('g','y','n', 0 ), // gyn = Guyanese Creole English
  TRUETYPE_TAG('g','y','r', 0 ), // gyr = Guarayu
  TRUETYPE_TAG('g','y','y', 0 ), // gyy = Gunya
  TRUETYPE_TAG('g','z','a', 0 ), // gza = Ganza
  TRUETYPE_TAG('g','z','i', 0 ), // gzi = Gazi
  TRUETYPE_TAG('g','z','n', 0 ), // gzn = Gane
  TRUETYPE_TAG('h','a','a', 0 ), // haa = Han
  TRUETYPE_TAG('h','a','b', 0 ), // hab = Hanoi Sign Language
  TRUETYPE_TAG('h','a','c', 0 ), // hac = Gurani
  TRUETYPE_TAG('h','a','d', 0 ), // had = Hatam
  TRUETYPE_TAG('h','a','e', 0 ), // hae = Eastern Oromo
  TRUETYPE_TAG('h','a','f', 0 ), // haf = Haiphong Sign Language
  TRUETYPE_TAG('h','a','g', 0 ), // hag = Hanga
  TRUETYPE_TAG('h','a','h', 0 ), // hah = Hahon
  TRUETYPE_TAG('h','a','i', 0 ), // hai = Haida
  TRUETYPE_TAG('h','a','j', 0 ), // haj = Hajong
  TRUETYPE_TAG('h','a','k', 0 ), // hak = Hakka Chinese
  TRUETYPE_TAG('h','a','l', 0 ), // hal = Halang
  TRUETYPE_TAG('h','a','m', 0 ), // ham = Hewa
  TRUETYPE_TAG('h','a','n', 0 ), // han = Hangaza
  TRUETYPE_TAG('h','a','o', 0 ), // hao = Hakö
  TRUETYPE_TAG('h','a','p', 0 ), // hap = Hupla
  TRUETYPE_TAG('h','a','q', 0 ), // haq = Ha
  TRUETYPE_TAG('h','a','r', 0 ), // har = Harari
  TRUETYPE_TAG('h','a','s', 0 ), // has = Haisla
  TRUETYPE_TAG('h','a','v', 0 ), // hav = Havu
  TRUETYPE_TAG('h','a','w', 0 ), // haw = Hawaiian
  TRUETYPE_TAG('h','a','x', 0 ), // hax = Southern Haida
  TRUETYPE_TAG('h','a','y', 0 ), // hay = Haya
  TRUETYPE_TAG('h','a','z', 0 ), // haz = Hazaragi
  TRUETYPE_TAG('h','b','a', 0 ), // hba = Hamba
  TRUETYPE_TAG('h','b','b', 0 ), // hbb = Huba
  TRUETYPE_TAG('h','b','n', 0 ), // hbn = Heiban
  TRUETYPE_TAG('h','b','o', 0 ), // hbo = Ancient Hebrew
  TRUETYPE_TAG('h','b','u', 0 ), // hbu = Habu
  TRUETYPE_TAG('h','c','a', 0 ), // hca = Andaman Creole Hindi
  TRUETYPE_TAG('h','c','h', 0 ), // hch = Huichol
  TRUETYPE_TAG('h','d','n', 0 ), // hdn = Northern Haida
  TRUETYPE_TAG('h','d','s', 0 ), // hds = Honduras Sign Language
  TRUETYPE_TAG('h','d','y', 0 ), // hdy = Hadiyya
  TRUETYPE_TAG('h','e','a', 0 ), // hea = Northern Qiandong Miao
  TRUETYPE_TAG('h','e','d', 0 ), // hed = Herdé
  TRUETYPE_TAG('h','e','g', 0 ), // heg = Helong
  TRUETYPE_TAG('h','e','h', 0 ), // heh = Hehe
  TRUETYPE_TAG('h','e','i', 0 ), // hei = Heiltsuk
  TRUETYPE_TAG('h','e','m', 0 ), // hem = Hemba
  TRUETYPE_TAG('h','g','m', 0 ), // hgm = Hai//om
  TRUETYPE_TAG('h','g','w', 0 ), // hgw = Haigwai
  TRUETYPE_TAG('h','h','i', 0 ), // hhi = Hoia Hoia
  TRUETYPE_TAG('h','h','r', 0 ), // hhr = Kerak
  TRUETYPE_TAG('h','h','y', 0 ), // hhy = Hoyahoya
  TRUETYPE_TAG('h','i','a', 0 ), // hia = Lamang
  TRUETYPE_TAG('h','i','b', 0 ), // hib = Hibito
  TRUETYPE_TAG('h','i','d', 0 ), // hid = Hidatsa
  TRUETYPE_TAG('h','i','f', 0 ), // hif = Fiji Hindi
  TRUETYPE_TAG('h','i','g', 0 ), // hig = Kamwe
  TRUETYPE_TAG('h','i','h', 0 ), // hih = Pamosu
  TRUETYPE_TAG('h','i','i', 0 ), // hii = Hinduri
  TRUETYPE_TAG('h','i','j', 0 ), // hij = Hijuk
  TRUETYPE_TAG('h','i','k', 0 ), // hik = Seit-Kaitetu
  TRUETYPE_TAG('h','i','l', 0 ), // hil = Hiligaynon
  TRUETYPE_TAG('h','i','m', 0 ), // him = Himachali languages
  TRUETYPE_TAG('h','i','o', 0 ), // hio = Tsoa
  TRUETYPE_TAG('h','i','r', 0 ), // hir = Himarimã
  TRUETYPE_TAG('h','i','t', 0 ), // hit = Hittite
  TRUETYPE_TAG('h','i','w', 0 ), // hiw = Hiw
  TRUETYPE_TAG('h','i','x', 0 ), // hix = Hixkaryána
  TRUETYPE_TAG('h','j','i', 0 ), // hji = Haji
  TRUETYPE_TAG('h','k','a', 0 ), // hka = Kahe
  TRUETYPE_TAG('h','k','e', 0 ), // hke = Hunde
  TRUETYPE_TAG('h','k','k', 0 ), // hkk = Hunjara-Kaina Ke
  TRUETYPE_TAG('h','k','s', 0 ), // hks = Hong Kong Sign Language
  TRUETYPE_TAG('h','l','a', 0 ), // hla = Halia
  TRUETYPE_TAG('h','l','b', 0 ), // hlb = Halbi
  TRUETYPE_TAG('h','l','d', 0 ), // hld = Halang Doan
  TRUETYPE_TAG('h','l','e', 0 ), // hle = Hlersu
  TRUETYPE_TAG('h','l','t', 0 ), // hlt = Nga La
  TRUETYPE_TAG('h','l','u', 0 ), // hlu = Hieroglyphic Luwian
  TRUETYPE_TAG('h','m','a', 0 ), // hma = Southern Mashan Hmong
  TRUETYPE_TAG('h','m','b', 0 ), // hmb = Humburi Senni Songhay
  TRUETYPE_TAG('h','m','c', 0 ), // hmc = Central Huishui Hmong
  TRUETYPE_TAG('h','m','d', 0 ), // hmd = Large Flowery Miao
  TRUETYPE_TAG('h','m','e', 0 ), // hme = Eastern Huishui Hmong
  TRUETYPE_TAG('h','m','f', 0 ), // hmf = Hmong Don
  TRUETYPE_TAG('h','m','g', 0 ), // hmg = Southwestern Guiyang Hmong
  TRUETYPE_TAG('h','m','h', 0 ), // hmh = Southwestern Huishui Hmong
  TRUETYPE_TAG('h','m','i', 0 ), // hmi = Northern Huishui Hmong
  TRUETYPE_TAG('h','m','j', 0 ), // hmj = Ge
  TRUETYPE_TAG('h','m','k', 0 ), // hmk = Maek
  TRUETYPE_TAG('h','m','l', 0 ), // hml = Luopohe Hmong
  TRUETYPE_TAG('h','m','m', 0 ), // hmm = Central Mashan Hmong
  TRUETYPE_TAG('h','m','n', 0 ), // hmn = Hmong
  TRUETYPE_TAG('h','m','p', 0 ), // hmp = Northern Mashan Hmong
  TRUETYPE_TAG('h','m','q', 0 ), // hmq = Eastern Qiandong Miao
  TRUETYPE_TAG('h','m','r', 0 ), // hmr = Hmar
  TRUETYPE_TAG('h','m','s', 0 ), // hms = Southern Qiandong Miao
  TRUETYPE_TAG('h','m','t', 0 ), // hmt = Hamtai
  TRUETYPE_TAG('h','m','u', 0 ), // hmu = Hamap
  TRUETYPE_TAG('h','m','v', 0 ), // hmv = Hmong Dô
  TRUETYPE_TAG('h','m','w', 0 ), // hmw = Western Mashan Hmong
  TRUETYPE_TAG('h','m','x', 0 ), // hmx = Hmong-Mien languages
  TRUETYPE_TAG('h','m','y', 0 ), // hmy = Southern Guiyang Hmong
  TRUETYPE_TAG('h','m','z', 0 ), // hmz = Hmong Shua
  TRUETYPE_TAG('h','n','a', 0 ), // hna = Mina (Cameroon)
  TRUETYPE_TAG('h','n','d', 0 ), // hnd = Southern Hindko
  TRUETYPE_TAG('h','n','e', 0 ), // hne = Chhattisgarhi
  TRUETYPE_TAG('h','n','h', 0 ), // hnh = //Ani
  TRUETYPE_TAG('h','n','i', 0 ), // hni = Hani
  TRUETYPE_TAG('h','n','j', 0 ), // hnj = Hmong Njua
  TRUETYPE_TAG('h','n','n', 0 ), // hnn = Hanunoo
  TRUETYPE_TAG('h','n','o', 0 ), // hno = Northern Hindko
  TRUETYPE_TAG('h','n','s', 0 ), // hns = Caribbean Hindustani
  TRUETYPE_TAG('h','n','u', 0 ), // hnu = Hung
  TRUETYPE_TAG('h','o','a', 0 ), // hoa = Hoava
  TRUETYPE_TAG('h','o','b', 0 ), // hob = Mari (Madang Province)
  TRUETYPE_TAG('h','o','c', 0 ), // hoc = Ho
  TRUETYPE_TAG('h','o','d', 0 ), // hod = Holma
  TRUETYPE_TAG('h','o','e', 0 ), // hoe = Horom
  TRUETYPE_TAG('h','o','h', 0 ), // hoh = Hobyót
  TRUETYPE_TAG('h','o','i', 0 ), // hoi = Holikachuk
  TRUETYPE_TAG('h','o','j', 0 ), // hoj = Hadothi
  TRUETYPE_TAG('h','o','k', 0 ), // hok = Hokan languages
  TRUETYPE_TAG('h','o','l', 0 ), // hol = Holu
  TRUETYPE_TAG('h','o','m', 0 ), // hom = Homa
  TRUETYPE_TAG('h','o','o', 0 ), // hoo = Holoholo
  TRUETYPE_TAG('h','o','p', 0 ), // hop = Hopi
  TRUETYPE_TAG('h','o','r', 0 ), // hor = Horo
  TRUETYPE_TAG('h','o','s', 0 ), // hos = Ho Chi Minh City Sign Language
  TRUETYPE_TAG('h','o','t', 0 ), // hot = Hote
  TRUETYPE_TAG('h','o','v', 0 ), // hov = Hovongan
  TRUETYPE_TAG('h','o','w', 0 ), // how = Honi
  TRUETYPE_TAG('h','o','y', 0 ), // hoy = Holiya
  TRUETYPE_TAG('h','o','z', 0 ), // hoz = Hozo
  TRUETYPE_TAG('h','p','o', 0 ), // hpo = Hpon
  TRUETYPE_TAG('h','p','s', 0 ), // hps = Hawai'i Pidgin Sign Language
  TRUETYPE_TAG('h','r','a', 0 ), // hra = Hrangkhol
  TRUETYPE_TAG('h','r','e', 0 ), // hre = Hre
  TRUETYPE_TAG('h','r','k', 0 ), // hrk = Haruku
  TRUETYPE_TAG('h','r','m', 0 ), // hrm = Horned Miao
  TRUETYPE_TAG('h','r','o', 0 ), // hro = Haroi
  TRUETYPE_TAG('h','r','r', 0 ), // hrr = Horuru
  TRUETYPE_TAG('h','r','t', 0 ), // hrt = Hértevin
  TRUETYPE_TAG('h','r','u', 0 ), // hru = Hruso
  TRUETYPE_TAG('h','r','x', 0 ), // hrx = Hunsrik
  TRUETYPE_TAG('h','r','z', 0 ), // hrz = Harzani
  TRUETYPE_TAG('h','s','b', 0 ), // hsb = Upper Sorbian
  TRUETYPE_TAG('h','s','h', 0 ), // hsh = Hungarian Sign Language
  TRUETYPE_TAG('h','s','l', 0 ), // hsl = Hausa Sign Language
  TRUETYPE_TAG('h','s','n', 0 ), // hsn = Xiang Chinese
  TRUETYPE_TAG('h','s','s', 0 ), // hss = Harsusi
  TRUETYPE_TAG('h','t','i', 0 ), // hti = Hoti
  TRUETYPE_TAG('h','t','o', 0 ), // hto = Minica Huitoto
  TRUETYPE_TAG('h','t','s', 0 ), // hts = Hadza
  TRUETYPE_TAG('h','t','u', 0 ), // htu = Hitu
  TRUETYPE_TAG('h','t','x', 0 ), // htx = Middle Hittite
  TRUETYPE_TAG('h','u','b', 0 ), // hub = Huambisa
  TRUETYPE_TAG('h','u','c', 0 ), // huc = =/Hua
  TRUETYPE_TAG('h','u','d', 0 ), // hud = Huaulu
  TRUETYPE_TAG('h','u','e', 0 ), // hue = San Francisco Del Mar Huave
  TRUETYPE_TAG('h','u','f', 0 ), // huf = Humene
  TRUETYPE_TAG('h','u','g', 0 ), // hug = Huachipaeri
  TRUETYPE_TAG('h','u','h', 0 ), // huh = Huilliche
  TRUETYPE_TAG('h','u','i', 0 ), // hui = Huli
  TRUETYPE_TAG('h','u','j', 0 ), // huj = Northern Guiyang Hmong
  TRUETYPE_TAG('h','u','k', 0 ), // huk = Hulung
  TRUETYPE_TAG('h','u','l', 0 ), // hul = Hula
  TRUETYPE_TAG('h','u','m', 0 ), // hum = Hungana
  TRUETYPE_TAG('h','u','o', 0 ), // huo = Hu
  TRUETYPE_TAG('h','u','p', 0 ), // hup = Hupa
  TRUETYPE_TAG('h','u','q', 0 ), // huq = Tsat
  TRUETYPE_TAG('h','u','r', 0 ), // hur = Halkomelem
  TRUETYPE_TAG('h','u','s', 0 ), // hus = Huastec
  TRUETYPE_TAG('h','u','t', 0 ), // hut = Humla
  TRUETYPE_TAG('h','u','u', 0 ), // huu = Murui Huitoto
  TRUETYPE_TAG('h','u','v', 0 ), // huv = San Mateo Del Mar Huave
  TRUETYPE_TAG('h','u','w', 0 ), // huw = Hukumina
  TRUETYPE_TAG('h','u','x', 0 ), // hux = Nüpode Huitoto
  TRUETYPE_TAG('h','u','y', 0 ), // huy = Hulaulá
  TRUETYPE_TAG('h','u','z', 0 ), // huz = Hunzib
  TRUETYPE_TAG('h','v','c', 0 ), // hvc = Haitian Vodoun Culture Language
  TRUETYPE_TAG('h','v','e', 0 ), // hve = San Dionisio Del Mar Huave
  TRUETYPE_TAG('h','v','k', 0 ), // hvk = Haveke
  TRUETYPE_TAG('h','v','n', 0 ), // hvn = Sabu
  TRUETYPE_TAG('h','v','v', 0 ), // hvv = Santa María Del Mar Huave
  TRUETYPE_TAG('h','w','a', 0 ), // hwa = Wané
  TRUETYPE_TAG('h','w','c', 0 ), // hwc = Hawai'i Creole English
  TRUETYPE_TAG('h','w','o', 0 ), // hwo = Hwana
  TRUETYPE_TAG('h','y','a', 0 ), // hya = Hya
  TRUETYPE_TAG('h','y','x', 0 ), // hyx = Armenian (family)
  TRUETYPE_TAG('i','a','i', 0 ), // iai = Iaai
  TRUETYPE_TAG('i','a','n', 0 ), // ian = Iatmul
  TRUETYPE_TAG('i','a','p', 0 ), // iap = Iapama
  TRUETYPE_TAG('i','a','r', 0 ), // iar = Purari
  TRUETYPE_TAG('i','b','a', 0 ), // iba = Iban
  TRUETYPE_TAG('i','b','b', 0 ), // ibb = Ibibio
  TRUETYPE_TAG('i','b','d', 0 ), // ibd = Iwaidja
  TRUETYPE_TAG('i','b','e', 0 ), // ibe = Akpes
  TRUETYPE_TAG('i','b','g', 0 ), // ibg = Ibanag
  TRUETYPE_TAG('i','b','i', 0 ), // ibi = Ibilo
  TRUETYPE_TAG('i','b','l', 0 ), // ibl = Ibaloi
  TRUETYPE_TAG('i','b','m', 0 ), // ibm = Agoi
  TRUETYPE_TAG('i','b','n', 0 ), // ibn = Ibino
  TRUETYPE_TAG('i','b','r', 0 ), // ibr = Ibuoro
  TRUETYPE_TAG('i','b','u', 0 ), // ibu = Ibu
  TRUETYPE_TAG('i','b','y', 0 ), // iby = Ibani
  TRUETYPE_TAG('i','c','a', 0 ), // ica = Ede Ica
  TRUETYPE_TAG('i','c','h', 0 ), // ich = Etkywan
  TRUETYPE_TAG('i','c','l', 0 ), // icl = Icelandic Sign Language
  TRUETYPE_TAG('i','c','r', 0 ), // icr = Islander Creole English
  TRUETYPE_TAG('i','d','a', 0 ), // ida = Idakho-Isukha-Tiriki
  TRUETYPE_TAG('i','d','b', 0 ), // idb = Indo-Portuguese
  TRUETYPE_TAG('i','d','c', 0 ), // idc = Idon
  TRUETYPE_TAG('i','d','d', 0 ), // idd = Ede Idaca
  TRUETYPE_TAG('i','d','e', 0 ), // ide = Idere
  TRUETYPE_TAG('i','d','i', 0 ), // idi = Idi
  TRUETYPE_TAG('i','d','r', 0 ), // idr = Indri
  TRUETYPE_TAG('i','d','s', 0 ), // ids = Idesa
  TRUETYPE_TAG('i','d','t', 0 ), // idt = Idaté
  TRUETYPE_TAG('i','d','u', 0 ), // idu = Idoma
  TRUETYPE_TAG('i','f','a', 0 ), // ifa = Amganad Ifugao
  TRUETYPE_TAG('i','f','b', 0 ), // ifb = Batad Ifugao
  TRUETYPE_TAG('i','f','e', 0 ), // ife = Ifè
  TRUETYPE_TAG('i','f','f', 0 ), // iff = Ifo
  TRUETYPE_TAG('i','f','k', 0 ), // ifk = Tuwali Ifugao
  TRUETYPE_TAG('i','f','m', 0 ), // ifm = Teke-Fuumu
  TRUETYPE_TAG('i','f','u', 0 ), // ifu = Mayoyao Ifugao
  TRUETYPE_TAG('i','f','y', 0 ), // ify = Keley-I Kallahan
  TRUETYPE_TAG('i','g','b', 0 ), // igb = Ebira
  TRUETYPE_TAG('i','g','e', 0 ), // ige = Igede
  TRUETYPE_TAG('i','g','g', 0 ), // igg = Igana
  TRUETYPE_TAG('i','g','l', 0 ), // igl = Igala
  TRUETYPE_TAG('i','g','m', 0 ), // igm = Kanggape
  TRUETYPE_TAG('i','g','n', 0 ), // ign = Ignaciano
  TRUETYPE_TAG('i','g','o', 0 ), // igo = Isebe
  TRUETYPE_TAG('i','g','s', 0 ), // igs = Interglossa
  TRUETYPE_TAG('i','g','w', 0 ), // igw = Igwe
  TRUETYPE_TAG('i','h','b', 0 ), // ihb = Iha Based Pidgin
  TRUETYPE_TAG('i','h','i', 0 ), // ihi = Ihievbe
  TRUETYPE_TAG('i','h','p', 0 ), // ihp = Iha
  TRUETYPE_TAG('i','i','r', 0 ), // iir = Indo-Iranian languages
  TRUETYPE_TAG('i','j','c', 0 ), // ijc = Izon
  TRUETYPE_TAG('i','j','e', 0 ), // ije = Biseni
  TRUETYPE_TAG('i','j','j', 0 ), // ijj = Ede Ije
  TRUETYPE_TAG('i','j','n', 0 ), // ijn = Kalabari
  TRUETYPE_TAG('i','j','o', 0 ), // ijo = Ijo languages
  TRUETYPE_TAG('i','j','s', 0 ), // ijs = Southeast Ijo
  TRUETYPE_TAG('i','k','e', 0 ), // ike = Eastern Canadian Inuktitut
  TRUETYPE_TAG('i','k','i', 0 ), // iki = Iko
  TRUETYPE_TAG('i','k','k', 0 ), // ikk = Ika
  TRUETYPE_TAG('i','k','l', 0 ), // ikl = Ikulu
  TRUETYPE_TAG('i','k','o', 0 ), // iko = Olulumo-Ikom
  TRUETYPE_TAG('i','k','p', 0 ), // ikp = Ikpeshi
  TRUETYPE_TAG('i','k','t', 0 ), // ikt = Western Canadian Inuktitut
  TRUETYPE_TAG('i','k','v', 0 ), // ikv = Iku-Gora-Ankwa
  TRUETYPE_TAG('i','k','w', 0 ), // ikw = Ikwere
  TRUETYPE_TAG('i','k','x', 0 ), // ikx = Ik
  TRUETYPE_TAG('i','k','z', 0 ), // ikz = Ikizu
  TRUETYPE_TAG('i','l','a', 0 ), // ila = Ile Ape
  TRUETYPE_TAG('i','l','b', 0 ), // ilb = Ila
  TRUETYPE_TAG('i','l','g', 0 ), // ilg = Garig-Ilgar
  TRUETYPE_TAG('i','l','i', 0 ), // ili = Ili Turki
  TRUETYPE_TAG('i','l','k', 0 ), // ilk = Ilongot
  TRUETYPE_TAG('i','l','l', 0 ), // ill = Iranun
  TRUETYPE_TAG('i','l','o', 0 ), // ilo = Iloko
  TRUETYPE_TAG('i','l','s', 0 ), // ils = International Sign
  TRUETYPE_TAG('i','l','u', 0 ), // ilu = Ili'uun
  TRUETYPE_TAG('i','l','v', 0 ), // ilv = Ilue
  TRUETYPE_TAG('i','l','w', 0 ), // ilw = Talur
  TRUETYPE_TAG('i','m','a', 0 ), // ima = Mala Malasar
  TRUETYPE_TAG('i','m','e', 0 ), // ime = Imeraguen
  TRUETYPE_TAG('i','m','i', 0 ), // imi = Anamgura
  TRUETYPE_TAG('i','m','l', 0 ), // iml = Miluk
  TRUETYPE_TAG('i','m','n', 0 ), // imn = Imonda
  TRUETYPE_TAG('i','m','o', 0 ), // imo = Imbongu
  TRUETYPE_TAG('i','m','r', 0 ), // imr = Imroing
  TRUETYPE_TAG('i','m','s', 0 ), // ims = Marsian
  TRUETYPE_TAG('i','m','y', 0 ), // imy = Milyan
  TRUETYPE_TAG('i','n','b', 0 ), // inb = Inga
  TRUETYPE_TAG('i','n','c', 0 ), // inc = Indic languages
  TRUETYPE_TAG('i','n','e', 0 ), // ine = Indo-European languages
  TRUETYPE_TAG('i','n','g', 0 ), // ing = Degexit'an
  TRUETYPE_TAG('i','n','h', 0 ), // inh = Ingush
  TRUETYPE_TAG('i','n','j', 0 ), // inj = Jungle Inga
  TRUETYPE_TAG('i','n','l', 0 ), // inl = Indonesian Sign Language
  TRUETYPE_TAG('i','n','m', 0 ), // inm = Minaean
  TRUETYPE_TAG('i','n','n', 0 ), // inn = Isinai
  TRUETYPE_TAG('i','n','o', 0 ), // ino = Inoke-Yate
  TRUETYPE_TAG('i','n','p', 0 ), // inp = Iñapari
  TRUETYPE_TAG('i','n','s', 0 ), // ins = Indian Sign Language
  TRUETYPE_TAG('i','n','t', 0 ), // int = Intha
  TRUETYPE_TAG('i','n','z', 0 ), // inz = Ineseño
  TRUETYPE_TAG('i','o','r', 0 ), // ior = Inor
  TRUETYPE_TAG('i','o','u', 0 ), // iou = Tuma-Irumu
  TRUETYPE_TAG('i','o','w', 0 ), // iow = Iowa-Oto
  TRUETYPE_TAG('i','p','i', 0 ), // ipi = Ipili
  TRUETYPE_TAG('i','p','o', 0 ), // ipo = Ipiko
  TRUETYPE_TAG('i','q','u', 0 ), // iqu = Iquito
  TRUETYPE_TAG('i','r','a', 0 ), // ira = Iranian languages
  TRUETYPE_TAG('i','r','e', 0 ), // ire = Iresim
  TRUETYPE_TAG('i','r','h', 0 ), // irh = Irarutu
  TRUETYPE_TAG('i','r','i', 0 ), // iri = Irigwe
  TRUETYPE_TAG('i','r','k', 0 ), // irk = Iraqw
  TRUETYPE_TAG('i','r','n', 0 ), // irn = Irántxe
  TRUETYPE_TAG('i','r','o', 0 ), // iro = Iroquoian languages
  TRUETYPE_TAG('i','r','r', 0 ), // irr = Ir
  TRUETYPE_TAG('i','r','u', 0 ), // iru = Irula
  TRUETYPE_TAG('i','r','x', 0 ), // irx = Kamberau
  TRUETYPE_TAG('i','r','y', 0 ), // iry = Iraya
  TRUETYPE_TAG('i','s','a', 0 ), // isa = Isabi
  TRUETYPE_TAG('i','s','c', 0 ), // isc = Isconahua
  TRUETYPE_TAG('i','s','d', 0 ), // isd = Isnag
  TRUETYPE_TAG('i','s','e', 0 ), // ise = Italian Sign Language
  TRUETYPE_TAG('i','s','g', 0 ), // isg = Irish Sign Language
  TRUETYPE_TAG('i','s','h', 0 ), // ish = Esan
  TRUETYPE_TAG('i','s','i', 0 ), // isi = Nkem-Nkum
  TRUETYPE_TAG('i','s','k', 0 ), // isk = Ishkashimi
  TRUETYPE_TAG('i','s','m', 0 ), // ism = Masimasi
  TRUETYPE_TAG('i','s','n', 0 ), // isn = Isanzu
  TRUETYPE_TAG('i','s','o', 0 ), // iso = Isoko
  TRUETYPE_TAG('i','s','r', 0 ), // isr = Israeli Sign Language
  TRUETYPE_TAG('i','s','t', 0 ), // ist = Istriot
  TRUETYPE_TAG('i','s','u', 0 ), // isu = Isu (Menchum Division)
  TRUETYPE_TAG('i','t','b', 0 ), // itb = Binongan Itneg
  TRUETYPE_TAG('i','t','c', 0 ), // itc = Italic languages
  TRUETYPE_TAG('i','t','e', 0 ), // ite = Itene
  TRUETYPE_TAG('i','t','i', 0 ), // iti = Inlaod Itneg
  TRUETYPE_TAG('i','t','k', 0 ), // itk = Judeo-Italian
  TRUETYPE_TAG('i','t','l', 0 ), // itl = Itelmen
  TRUETYPE_TAG('i','t','m', 0 ), // itm = Itu Mbon Uzo
  TRUETYPE_TAG('i','t','o', 0 ), // ito = Itonama
  TRUETYPE_TAG('i','t','r', 0 ), // itr = Iteri
  TRUETYPE_TAG('i','t','s', 0 ), // its = Isekiri
  TRUETYPE_TAG('i','t','t', 0 ), // itt = Maeng Itneg
  TRUETYPE_TAG('i','t','v', 0 ), // itv = Itawit
  TRUETYPE_TAG('i','t','w', 0 ), // itw = Ito
  TRUETYPE_TAG('i','t','x', 0 ), // itx = Itik
  TRUETYPE_TAG('i','t','y', 0 ), // ity = Moyadan Itneg
  TRUETYPE_TAG('i','t','z', 0 ), // itz = Itzá
  TRUETYPE_TAG('i','u','m', 0 ), // ium = Iu Mien
  TRUETYPE_TAG('i','v','b', 0 ), // ivb = Ibatan
  TRUETYPE_TAG('i','v','v', 0 ), // ivv = Ivatan
  TRUETYPE_TAG('i','w','k', 0 ), // iwk = I-Wak
  TRUETYPE_TAG('i','w','m', 0 ), // iwm = Iwam
  TRUETYPE_TAG('i','w','o', 0 ), // iwo = Iwur
  TRUETYPE_TAG('i','w','s', 0 ), // iws = Sepik Iwam
  TRUETYPE_TAG('i','x','c', 0 ), // ixc = Ixcatec
  TRUETYPE_TAG('i','x','l', 0 ), // ixl = Ixil
  TRUETYPE_TAG('i','y','a', 0 ), // iya = Iyayu
  TRUETYPE_TAG('i','y','o', 0 ), // iyo = Mesaka
  TRUETYPE_TAG('i','y','x', 0 ), // iyx = Yaka (Congo)
  TRUETYPE_TAG('i','z','h', 0 ), // izh = Ingrian
  TRUETYPE_TAG('i','z','i', 0 ), // izi = Izi-Ezaa-Ikwo-Mgbo
  TRUETYPE_TAG('i','z','r', 0 ), // izr = Izere
  TRUETYPE_TAG('j','a','a', 0 ), // jaa = Jamamadí
  TRUETYPE_TAG('j','a','b', 0 ), // jab = Hyam
  TRUETYPE_TAG('j','a','c', 0 ), // jac = Popti'
  TRUETYPE_TAG('j','a','d', 0 ), // jad = Jahanka
  TRUETYPE_TAG('j','a','e', 0 ), // jae = Yabem
  TRUETYPE_TAG('j','a','f', 0 ), // jaf = Jara
  TRUETYPE_TAG('j','a','h', 0 ), // jah = Jah Hut
  TRUETYPE_TAG('j','a','j', 0 ), // jaj = Zazao
  TRUETYPE_TAG('j','a','k', 0 ), // jak = Jakun
  TRUETYPE_TAG('j','a','l', 0 ), // jal = Yalahatan
  TRUETYPE_TAG('j','a','m', 0 ), // jam = Jamaican Creole English
  TRUETYPE_TAG('j','a','o', 0 ), // jao = Yanyuwa
  TRUETYPE_TAG('j','a','q', 0 ), // jaq = Yaqay
  TRUETYPE_TAG('j','a','r', 0 ), // jar = Jarawa (Nigeria)
  TRUETYPE_TAG('j','a','s', 0 ), // jas = New Caledonian Javanese
  TRUETYPE_TAG('j','a','t', 0 ), // jat = Jakati
  TRUETYPE_TAG('j','a','u', 0 ), // jau = Yaur
  TRUETYPE_TAG('j','a','x', 0 ), // jax = Jambi Malay
  TRUETYPE_TAG('j','a','y', 0 ), // jay = Yan-nhangu
  TRUETYPE_TAG('j','a','z', 0 ), // jaz = Jawe
  TRUETYPE_TAG('j','b','e', 0 ), // jbe = Judeo-Berber
  TRUETYPE_TAG('j','b','j', 0 ), // jbj = Arandai
  TRUETYPE_TAG('j','b','n', 0 ), // jbn = Nafusi
  TRUETYPE_TAG('j','b','o', 0 ), // jbo = Lojban
  TRUETYPE_TAG('j','b','r', 0 ), // jbr = Jofotek-Bromnya
  TRUETYPE_TAG('j','b','t', 0 ), // jbt = Jabutí
  TRUETYPE_TAG('j','b','u', 0 ), // jbu = Jukun Takum
  TRUETYPE_TAG('j','c','s', 0 ), // jcs = Jamaican Country Sign Language
  TRUETYPE_TAG('j','c','t', 0 ), // jct = Krymchak
  TRUETYPE_TAG('j','d','a', 0 ), // jda = Jad
  TRUETYPE_TAG('j','d','g', 0 ), // jdg = Jadgali
  TRUETYPE_TAG('j','d','t', 0 ), // jdt = Judeo-Tat
  TRUETYPE_TAG('j','e','b', 0 ), // jeb = Jebero
  TRUETYPE_TAG('j','e','e', 0 ), // jee = Jerung
  TRUETYPE_TAG('j','e','g', 0 ), // jeg = Jeng
  TRUETYPE_TAG('j','e','h', 0 ), // jeh = Jeh
  TRUETYPE_TAG('j','e','i', 0 ), // jei = Yei
  TRUETYPE_TAG('j','e','k', 0 ), // jek = Jeri Kuo
  TRUETYPE_TAG('j','e','l', 0 ), // jel = Yelmek
  TRUETYPE_TAG('j','e','n', 0 ), // jen = Dza
  TRUETYPE_TAG('j','e','r', 0 ), // jer = Jere
  TRUETYPE_TAG('j','e','t', 0 ), // jet = Manem
  TRUETYPE_TAG('j','e','u', 0 ), // jeu = Jonkor Bourmataguil
  TRUETYPE_TAG('j','g','b', 0 ), // jgb = Ngbee
  TRUETYPE_TAG('j','g','e', 0 ), // jge = Judeo-Georgian
  TRUETYPE_TAG('j','g','o', 0 ), // jgo = Ngomba
  TRUETYPE_TAG('j','h','i', 0 ), // jhi = Jehai
  TRUETYPE_TAG('j','h','s', 0 ), // jhs = Jhankot Sign Language
  TRUETYPE_TAG('j','i','a', 0 ), // jia = Jina
  TRUETYPE_TAG('j','i','b', 0 ), // jib = Jibu
  TRUETYPE_TAG('j','i','c', 0 ), // jic = Tol
  TRUETYPE_TAG('j','i','d', 0 ), // jid = Bu
  TRUETYPE_TAG('j','i','e', 0 ), // jie = Jilbe
  TRUETYPE_TAG('j','i','g', 0 ), // jig = Djingili
  TRUETYPE_TAG('j','i','h', 0 ), // jih = Shangzhai
  TRUETYPE_TAG('j','i','i', 0 ), // jii = Jiiddu
  TRUETYPE_TAG('j','i','l', 0 ), // jil = Jilim
  TRUETYPE_TAG('j','i','m', 0 ), // jim = Jimi (Cameroon)
  TRUETYPE_TAG('j','i','o', 0 ), // jio = Jiamao
  TRUETYPE_TAG('j','i','q', 0 ), // jiq = Guanyinqiao
  TRUETYPE_TAG('j','i','t', 0 ), // jit = Jita
  TRUETYPE_TAG('j','i','u', 0 ), // jiu = Youle Jinuo
  TRUETYPE_TAG('j','i','v', 0 ), // jiv = Shuar
  TRUETYPE_TAG('j','i','y', 0 ), // jiy = Buyuan Jinuo
  TRUETYPE_TAG('j','k','o', 0 ), // jko = Kubo
  TRUETYPE_TAG('j','k','u', 0 ), // jku = Labir
  TRUETYPE_TAG('j','l','e', 0 ), // jle = Ngile
  TRUETYPE_TAG('j','l','s', 0 ), // jls = Jamaican Sign Language
  TRUETYPE_TAG('j','m','a', 0 ), // jma = Dima
  TRUETYPE_TAG('j','m','b', 0 ), // jmb = Zumbun
  TRUETYPE_TAG('j','m','c', 0 ), // jmc = Machame
  TRUETYPE_TAG('j','m','d', 0 ), // jmd = Yamdena
  TRUETYPE_TAG('j','m','i', 0 ), // jmi = Jimi (Nigeria)
  TRUETYPE_TAG('j','m','l', 0 ), // jml = Jumli
  TRUETYPE_TAG('j','m','n', 0 ), // jmn = Makuri Naga
  TRUETYPE_TAG('j','m','r', 0 ), // jmr = Kamara
  TRUETYPE_TAG('j','m','s', 0 ), // jms = Mashi (Nigeria)
  TRUETYPE_TAG('j','m','x', 0 ), // jmx = Western Juxtlahuaca Mixtec
  TRUETYPE_TAG('j','n','a', 0 ), // jna = Jangshung
  TRUETYPE_TAG('j','n','d', 0 ), // jnd = Jandavra
  TRUETYPE_TAG('j','n','g', 0 ), // jng = Yangman
  TRUETYPE_TAG('j','n','i', 0 ), // jni = Janji
  TRUETYPE_TAG('j','n','j', 0 ), // jnj = Yemsa
  TRUETYPE_TAG('j','n','l', 0 ), // jnl = Rawat
  TRUETYPE_TAG('j','n','s', 0 ), // jns = Jaunsari
  TRUETYPE_TAG('j','o','b', 0 ), // job = Joba
  TRUETYPE_TAG('j','o','d', 0 ), // jod = Wojenaka
  TRUETYPE_TAG('j','o','r', 0 ), // jor = Jorá
  TRUETYPE_TAG('j','o','s', 0 ), // jos = Jordanian Sign Language
  TRUETYPE_TAG('j','o','w', 0 ), // jow = Jowulu
  TRUETYPE_TAG('j','p','a', 0 ), // jpa = Jewish Palestinian Aramaic
  TRUETYPE_TAG('j','p','r', 0 ), // jpr = Judeo-Persian
  TRUETYPE_TAG('j','p','x', 0 ), // jpx = Japanese (family)
  TRUETYPE_TAG('j','q','r', 0 ), // jqr = Jaqaru
  TRUETYPE_TAG('j','r','a', 0 ), // jra = Jarai
  TRUETYPE_TAG('j','r','b', 0 ), // jrb = Judeo-Arabic
  TRUETYPE_TAG('j','r','r', 0 ), // jrr = Jiru
  TRUETYPE_TAG('j','r','t', 0 ), // jrt = Jorto
  TRUETYPE_TAG('j','r','u', 0 ), // jru = Japrería
  TRUETYPE_TAG('j','s','l', 0 ), // jsl = Japanese Sign Language
  TRUETYPE_TAG('j','u','a', 0 ), // jua = Júma
  TRUETYPE_TAG('j','u','b', 0 ), // jub = Wannu
  TRUETYPE_TAG('j','u','c', 0 ), // juc = Jurchen
  TRUETYPE_TAG('j','u','d', 0 ), // jud = Worodougou
  TRUETYPE_TAG('j','u','h', 0 ), // juh = Hõne
  TRUETYPE_TAG('j','u','k', 0 ), // juk = Wapan
  TRUETYPE_TAG('j','u','l', 0 ), // jul = Jirel
  TRUETYPE_TAG('j','u','m', 0 ), // jum = Jumjum
  TRUETYPE_TAG('j','u','n', 0 ), // jun = Juang
  TRUETYPE_TAG('j','u','o', 0 ), // juo = Jiba
  TRUETYPE_TAG('j','u','p', 0 ), // jup = Hupdë
  TRUETYPE_TAG('j','u','r', 0 ), // jur = Jurúna
  TRUETYPE_TAG('j','u','s', 0 ), // jus = Jumla Sign Language
  TRUETYPE_TAG('j','u','t', 0 ), // jut = Jutish
  TRUETYPE_TAG('j','u','u', 0 ), // juu = Ju
  TRUETYPE_TAG('j','u','w', 0 ), // juw = Wãpha
  TRUETYPE_TAG('j','u','y', 0 ), // juy = Juray
  TRUETYPE_TAG('j','v','d', 0 ), // jvd = Javindo
  TRUETYPE_TAG('j','v','n', 0 ), // jvn = Caribbean Javanese
  TRUETYPE_TAG('j','w','i', 0 ), // jwi = Jwira-Pepesa
  TRUETYPE_TAG('j','y','a', 0 ), // jya = Jiarong
  TRUETYPE_TAG('j','y','e', 0 ), // jye = Judeo-Yemeni Arabic
  TRUETYPE_TAG('j','y','y', 0 ), // jyy = Jaya
  TRUETYPE_TAG('k','a','a', 0 ), // kaa = Kara-Kalpak
  TRUETYPE_TAG('k','a','b', 0 ), // kab = Kabyle
  TRUETYPE_TAG('k','a','c', 0 ), // kac = Kachin
  TRUETYPE_TAG('k','a','d', 0 ), // kad = Kadara
  TRUETYPE_TAG('k','a','e', 0 ), // kae = Ketangalan
  TRUETYPE_TAG('k','a','f', 0 ), // kaf = Katso
  TRUETYPE_TAG('k','a','g', 0 ), // kag = Kajaman
  TRUETYPE_TAG('k','a','h', 0 ), // kah = Kara (Central African Republic)
  TRUETYPE_TAG('k','a','i', 0 ), // kai = Karekare
  TRUETYPE_TAG('k','a','j', 0 ), // kaj = Jju
  TRUETYPE_TAG('k','a','k', 0 ), // kak = Kayapa Kallahan
  TRUETYPE_TAG('k','a','m', 0 ), // kam = Kamba (Kenya)
  TRUETYPE_TAG('k','a','o', 0 ), // kao = Xaasongaxango
  TRUETYPE_TAG('k','a','p', 0 ), // kap = Bezhta
  TRUETYPE_TAG('k','a','q', 0 ), // kaq = Capanahua
  TRUETYPE_TAG('k','a','r', 0 ), // kar = Karen languages
  TRUETYPE_TAG('k','a','v', 0 ), // kav = Katukína
  TRUETYPE_TAG('k','a','w', 0 ), // kaw = Kawi
  TRUETYPE_TAG('k','a','x', 0 ), // kax = Kao
  TRUETYPE_TAG('k','a','y', 0 ), // kay = Kamayurá
  TRUETYPE_TAG('k','b','a', 0 ), // kba = Kalarko
  TRUETYPE_TAG('k','b','b', 0 ), // kbb = Kaxuiâna
  TRUETYPE_TAG('k','b','c', 0 ), // kbc = Kadiwéu
  TRUETYPE_TAG('k','b','d', 0 ), // kbd = Kabardian
  TRUETYPE_TAG('k','b','e', 0 ), // kbe = Kanju
  TRUETYPE_TAG('k','b','f', 0 ), // kbf = Kakauhua
  TRUETYPE_TAG('k','b','g', 0 ), // kbg = Khamba
  TRUETYPE_TAG('k','b','h', 0 ), // kbh = Camsá
  TRUETYPE_TAG('k','b','i', 0 ), // kbi = Kaptiau
  TRUETYPE_TAG('k','b','j', 0 ), // kbj = Kari
  TRUETYPE_TAG('k','b','k', 0 ), // kbk = Grass Koiari
  TRUETYPE_TAG('k','b','l', 0 ), // kbl = Kanembu
  TRUETYPE_TAG('k','b','m', 0 ), // kbm = Iwal
  TRUETYPE_TAG('k','b','n', 0 ), // kbn = Kare (Central African Republic)
  TRUETYPE_TAG('k','b','o', 0 ), // kbo = Keliko
  TRUETYPE_TAG('k','b','p', 0 ), // kbp = Kabiyè
  TRUETYPE_TAG('k','b','q', 0 ), // kbq = Kamano
  TRUETYPE_TAG('k','b','r', 0 ), // kbr = Kafa
  TRUETYPE_TAG('k','b','s', 0 ), // kbs = Kande
  TRUETYPE_TAG('k','b','t', 0 ), // kbt = Abadi
  TRUETYPE_TAG('k','b','u', 0 ), // kbu = Kabutra
  TRUETYPE_TAG('k','b','v', 0 ), // kbv = Dera (Indonesia)
  TRUETYPE_TAG('k','b','w', 0 ), // kbw = Kaiep
  TRUETYPE_TAG('k','b','x', 0 ), // kbx = Ap Ma
  TRUETYPE_TAG('k','b','y', 0 ), // kby = Manga Kanuri
  TRUETYPE_TAG('k','b','z', 0 ), // kbz = Duhwa
  TRUETYPE_TAG('k','c','a', 0 ), // kca = Khanty
  TRUETYPE_TAG('k','c','b', 0 ), // kcb = Kawacha
  TRUETYPE_TAG('k','c','c', 0 ), // kcc = Lubila
  TRUETYPE_TAG('k','c','d', 0 ), // kcd = Ngkâlmpw Kanum
  TRUETYPE_TAG('k','c','e', 0 ), // kce = Kaivi
  TRUETYPE_TAG('k','c','f', 0 ), // kcf = Ukaan
  TRUETYPE_TAG('k','c','g', 0 ), // kcg = Tyap
  TRUETYPE_TAG('k','c','h', 0 ), // kch = Vono
  TRUETYPE_TAG('k','c','i', 0 ), // kci = Kamantan
  TRUETYPE_TAG('k','c','j', 0 ), // kcj = Kobiana
  TRUETYPE_TAG('k','c','k', 0 ), // kck = Kalanga
  TRUETYPE_TAG('k','c','l', 0 ), // kcl = Kela (Papua New Guinea)
  TRUETYPE_TAG('k','c','m', 0 ), // kcm = Gula (Central African Republic)
  TRUETYPE_TAG('k','c','n', 0 ), // kcn = Nubi
  TRUETYPE_TAG('k','c','o', 0 ), // kco = Kinalakna
  TRUETYPE_TAG('k','c','p', 0 ), // kcp = Kanga
  TRUETYPE_TAG('k','c','q', 0 ), // kcq = Kamo
  TRUETYPE_TAG('k','c','r', 0 ), // kcr = Katla
  TRUETYPE_TAG('k','c','s', 0 ), // kcs = Koenoem
  TRUETYPE_TAG('k','c','t', 0 ), // kct = Kaian
  TRUETYPE_TAG('k','c','u', 0 ), // kcu = Kami (Tanzania)
  TRUETYPE_TAG('k','c','v', 0 ), // kcv = Kete
  TRUETYPE_TAG('k','c','w', 0 ), // kcw = Kabwari
  TRUETYPE_TAG('k','c','x', 0 ), // kcx = Kachama-Ganjule
  TRUETYPE_TAG('k','c','y', 0 ), // kcy = Korandje
  TRUETYPE_TAG('k','c','z', 0 ), // kcz = Konongo
  TRUETYPE_TAG('k','d','a', 0 ), // kda = Worimi
  TRUETYPE_TAG('k','d','c', 0 ), // kdc = Kutu
  TRUETYPE_TAG('k','d','d', 0 ), // kdd = Yankunytjatjara
  TRUETYPE_TAG('k','d','e', 0 ), // kde = Makonde
  TRUETYPE_TAG('k','d','f', 0 ), // kdf = Mamusi
  TRUETYPE_TAG('k','d','g', 0 ), // kdg = Seba
  TRUETYPE_TAG('k','d','h', 0 ), // kdh = Tem
  TRUETYPE_TAG('k','d','i', 0 ), // kdi = Kumam
  TRUETYPE_TAG('k','d','j', 0 ), // kdj = Karamojong
  TRUETYPE_TAG('k','d','k', 0 ), // kdk = Numee
  TRUETYPE_TAG('k','d','l', 0 ), // kdl = Tsikimba
  TRUETYPE_TAG('k','d','m', 0 ), // kdm = Kagoma
  TRUETYPE_TAG('k','d','n', 0 ), // kdn = Kunda
  TRUETYPE_TAG('k','d','o', 0 ), // kdo = Kordofanian languages
  TRUETYPE_TAG('k','d','p', 0 ), // kdp = Kaningdon-Nindem
  TRUETYPE_TAG('k','d','q', 0 ), // kdq = Koch
  TRUETYPE_TAG('k','d','r', 0 ), // kdr = Karaim
  TRUETYPE_TAG('k','d','t', 0 ), // kdt = Kuy
  TRUETYPE_TAG('k','d','u', 0 ), // kdu = Kadaru
  TRUETYPE_TAG('k','d','v', 0 ), // kdv = Kado
  TRUETYPE_TAG('k','d','w', 0 ), // kdw = Koneraw
  TRUETYPE_TAG('k','d','x', 0 ), // kdx = Kam
  TRUETYPE_TAG('k','d','y', 0 ), // kdy = Keder
  TRUETYPE_TAG('k','d','z', 0 ), // kdz = Kwaja
  TRUETYPE_TAG('k','e','a', 0 ), // kea = Kabuverdianu
  TRUETYPE_TAG('k','e','b', 0 ), // keb = Kélé
  TRUETYPE_TAG('k','e','c', 0 ), // kec = Keiga
  TRUETYPE_TAG('k','e','d', 0 ), // ked = Kerewe
  TRUETYPE_TAG('k','e','e', 0 ), // kee = Eastern Keres
  TRUETYPE_TAG('k','e','f', 0 ), // kef = Kpessi
  TRUETYPE_TAG('k','e','g', 0 ), // keg = Tese
  TRUETYPE_TAG('k','e','h', 0 ), // keh = Keak
  TRUETYPE_TAG('k','e','i', 0 ), // kei = Kei
  TRUETYPE_TAG('k','e','j', 0 ), // kej = Kadar
  TRUETYPE_TAG('k','e','k', 0 ), // kek = Kekchí
  TRUETYPE_TAG('k','e','l', 0 ), // kel = Kela (Democratic Republic of Congo)
  TRUETYPE_TAG('k','e','m', 0 ), // kem = Kemak
  TRUETYPE_TAG('k','e','n', 0 ), // ken = Kenyang
  TRUETYPE_TAG('k','e','o', 0 ), // keo = Kakwa
  TRUETYPE_TAG('k','e','p', 0 ), // kep = Kaikadi
  TRUETYPE_TAG('k','e','q', 0 ), // keq = Kamar
  TRUETYPE_TAG('k','e','r', 0 ), // ker = Kera
  TRUETYPE_TAG('k','e','s', 0 ), // kes = Kugbo
  TRUETYPE_TAG('k','e','t', 0 ), // ket = Ket
  TRUETYPE_TAG('k','e','u', 0 ), // keu = Akebu
  TRUETYPE_TAG('k','e','v', 0 ), // kev = Kanikkaran
  TRUETYPE_TAG('k','e','w', 0 ), // kew = West Kewa
  TRUETYPE_TAG('k','e','x', 0 ), // kex = Kukna
  TRUETYPE_TAG('k','e','y', 0 ), // key = Kupia
  TRUETYPE_TAG('k','e','z', 0 ), // kez = Kukele
  TRUETYPE_TAG('k','f','a', 0 ), // kfa = Kodava
  TRUETYPE_TAG('k','f','b', 0 ), // kfb = Northwestern Kolami
  TRUETYPE_TAG('k','f','c', 0 ), // kfc = Konda-Dora
  TRUETYPE_TAG('k','f','d', 0 ), // kfd = Korra Koraga
  TRUETYPE_TAG('k','f','e', 0 ), // kfe = Kota (India)
  TRUETYPE_TAG('k','f','f', 0 ), // kff = Koya
  TRUETYPE_TAG('k','f','g', 0 ), // kfg = Kudiya
  TRUETYPE_TAG('k','f','h', 0 ), // kfh = Kurichiya
  TRUETYPE_TAG('k','f','i', 0 ), // kfi = Kannada Kurumba
  TRUETYPE_TAG('k','f','j', 0 ), // kfj = Kemiehua
  TRUETYPE_TAG('k','f','k', 0 ), // kfk = Kinnauri
  TRUETYPE_TAG('k','f','l', 0 ), // kfl = Kung
  TRUETYPE_TAG('k','f','m', 0 ), // kfm = Khunsari
  TRUETYPE_TAG('k','f','n', 0 ), // kfn = Kuk
  TRUETYPE_TAG('k','f','o', 0 ), // kfo = Koro (Côte d'Ivoire)
  TRUETYPE_TAG('k','f','p', 0 ), // kfp = Korwa
  TRUETYPE_TAG('k','f','q', 0 ), // kfq = Korku
  TRUETYPE_TAG('k','f','r', 0 ), // kfr = Kachchi
  TRUETYPE_TAG('k','f','s', 0 ), // kfs = Bilaspuri
  TRUETYPE_TAG('k','f','t', 0 ), // kft = Kanjari
  TRUETYPE_TAG('k','f','u', 0 ), // kfu = Katkari
  TRUETYPE_TAG('k','f','v', 0 ), // kfv = Kurmukar
  TRUETYPE_TAG('k','f','w', 0 ), // kfw = Kharam Naga
  TRUETYPE_TAG('k','f','x', 0 ), // kfx = Kullu Pahari
  TRUETYPE_TAG('k','f','y', 0 ), // kfy = Kumaoni
  TRUETYPE_TAG('k','f','z', 0 ), // kfz = Koromfé
  TRUETYPE_TAG('k','g','a', 0 ), // kga = Koyaga
  TRUETYPE_TAG('k','g','b', 0 ), // kgb = Kawe
  TRUETYPE_TAG('k','g','c', 0 ), // kgc = Kasseng
  TRUETYPE_TAG('k','g','d', 0 ), // kgd = Kataang
  TRUETYPE_TAG('k','g','e', 0 ), // kge = Komering
  TRUETYPE_TAG('k','g','f', 0 ), // kgf = Kube
  TRUETYPE_TAG('k','g','g', 0 ), // kgg = Kusunda
  TRUETYPE_TAG('k','g','h', 0 ), // kgh = Upper Tanudan Kalinga
  TRUETYPE_TAG('k','g','i', 0 ), // kgi = Selangor Sign Language
  TRUETYPE_TAG('k','g','j', 0 ), // kgj = Gamale Kham
  TRUETYPE_TAG('k','g','k', 0 ), // kgk = Kaiwá
  TRUETYPE_TAG('k','g','l', 0 ), // kgl = Kunggari
  TRUETYPE_TAG('k','g','m', 0 ), // kgm = Karipúna
  TRUETYPE_TAG('k','g','n', 0 ), // kgn = Karingani
  TRUETYPE_TAG('k','g','o', 0 ), // kgo = Krongo
  TRUETYPE_TAG('k','g','p', 0 ), // kgp = Kaingang
  TRUETYPE_TAG('k','g','q', 0 ), // kgq = Kamoro
  TRUETYPE_TAG('k','g','r', 0 ), // kgr = Abun
  TRUETYPE_TAG('k','g','s', 0 ), // kgs = Kumbainggar
  TRUETYPE_TAG('k','g','t', 0 ), // kgt = Somyev
  TRUETYPE_TAG('k','g','u', 0 ), // kgu = Kobol
  TRUETYPE_TAG('k','g','v', 0 ), // kgv = Karas
  TRUETYPE_TAG('k','g','w', 0 ), // kgw = Karon Dori
  TRUETYPE_TAG('k','g','x', 0 ), // kgx = Kamaru
  TRUETYPE_TAG('k','g','y', 0 ), // kgy = Kyerung
  TRUETYPE_TAG('k','h','a', 0 ), // kha = Khasi
  TRUETYPE_TAG('k','h','b', 0 ), // khb = Lü
  TRUETYPE_TAG('k','h','c', 0 ), // khc = Tukang Besi North
  TRUETYPE_TAG('k','h','d', 0 ), // khd = Bädi Kanum
  TRUETYPE_TAG('k','h','e', 0 ), // khe = Korowai
  TRUETYPE_TAG('k','h','f', 0 ), // khf = Khuen
  TRUETYPE_TAG('k','h','g', 0 ), // khg = Khams Tibetan
  TRUETYPE_TAG('k','h','h', 0 ), // khh = Kehu
  TRUETYPE_TAG('k','h','i', 0 ), // khi = Khoisan languages
  TRUETYPE_TAG('k','h','j', 0 ), // khj = Kuturmi
  TRUETYPE_TAG('k','h','k', 0 ), // khk = Halh Mongolian
  TRUETYPE_TAG('k','h','l', 0 ), // khl = Lusi
  TRUETYPE_TAG('k','h','n', 0 ), // khn = Khandesi
  TRUETYPE_TAG('k','h','o', 0 ), // kho = Khotanese
  TRUETYPE_TAG('k','h','p', 0 ), // khp = Kapori
  TRUETYPE_TAG('k','h','q', 0 ), // khq = Koyra Chiini Songhay
  TRUETYPE_TAG('k','h','r', 0 ), // khr = Kharia
  TRUETYPE_TAG('k','h','s', 0 ), // khs = Kasua
  TRUETYPE_TAG('k','h','t', 0 ), // kht = Khamti
  TRUETYPE_TAG('k','h','u', 0 ), // khu = Nkhumbi
  TRUETYPE_TAG('k','h','v', 0 ), // khv = Khvarshi
  TRUETYPE_TAG('k','h','w', 0 ), // khw = Khowar
  TRUETYPE_TAG('k','h','x', 0 ), // khx = Kanu
  TRUETYPE_TAG('k','h','y', 0 ), // khy = Kele (Democratic Republic of Congo)
  TRUETYPE_TAG('k','h','z', 0 ), // khz = Keapara
  TRUETYPE_TAG('k','i','a', 0 ), // kia = Kim
  TRUETYPE_TAG('k','i','b', 0 ), // kib = Koalib
  TRUETYPE_TAG('k','i','c', 0 ), // kic = Kickapoo
  TRUETYPE_TAG('k','i','d', 0 ), // kid = Koshin
  TRUETYPE_TAG('k','i','e', 0 ), // kie = Kibet
  TRUETYPE_TAG('k','i','f', 0 ), // kif = Eastern Parbate Kham
  TRUETYPE_TAG('k','i','g', 0 ), // kig = Kimaama
  TRUETYPE_TAG('k','i','h', 0 ), // kih = Kilmeri
  TRUETYPE_TAG('k','i','i', 0 ), // kii = Kitsai
  TRUETYPE_TAG('k','i','j', 0 ), // kij = Kilivila
  TRUETYPE_TAG('k','i','l', 0 ), // kil = Kariya
  TRUETYPE_TAG('k','i','m', 0 ), // kim = Karagas
  TRUETYPE_TAG('k','i','o', 0 ), // kio = Kiowa
  TRUETYPE_TAG('k','i','p', 0 ), // kip = Sheshi Kham
  TRUETYPE_TAG('k','i','q', 0 ), // kiq = Kosadle
  TRUETYPE_TAG('k','i','s', 0 ), // kis = Kis
  TRUETYPE_TAG('k','i','t', 0 ), // kit = Agob
  TRUETYPE_TAG('k','i','u', 0 ), // kiu = Kirmanjki (individual language)
  TRUETYPE_TAG('k','i','v', 0 ), // kiv = Kimbu
  TRUETYPE_TAG('k','i','w', 0 ), // kiw = Northeast Kiwai
  TRUETYPE_TAG('k','i','x', 0 ), // kix = Khiamniungan Naga
  TRUETYPE_TAG('k','i','y', 0 ), // kiy = Kirikiri
  TRUETYPE_TAG('k','i','z', 0 ), // kiz = Kisi
  TRUETYPE_TAG('k','j','a', 0 ), // kja = Mlap
  TRUETYPE_TAG('k','j','b', 0 ), // kjb = Q'anjob'al
  TRUETYPE_TAG('k','j','c', 0 ), // kjc = Coastal Konjo
  TRUETYPE_TAG('k','j','d', 0 ), // kjd = Southern Kiwai
  TRUETYPE_TAG('k','j','e', 0 ), // kje = Kisar
  TRUETYPE_TAG('k','j','f', 0 ), // kjf = Khalaj
  TRUETYPE_TAG('k','j','g', 0 ), // kjg = Khmu
  TRUETYPE_TAG('k','j','h', 0 ), // kjh = Khakas
  TRUETYPE_TAG('k','j','i', 0 ), // kji = Zabana
  TRUETYPE_TAG('k','j','j', 0 ), // kjj = Khinalugh
  TRUETYPE_TAG('k','j','k', 0 ), // kjk = Highland Konjo
  TRUETYPE_TAG('k','j','l', 0 ), // kjl = Western Parbate Kham
  TRUETYPE_TAG('k','j','m', 0 ), // kjm = Kháng
  TRUETYPE_TAG('k','j','n', 0 ), // kjn = Kunjen
  TRUETYPE_TAG('k','j','o', 0 ), // kjo = Harijan Kinnauri
  TRUETYPE_TAG('k','j','p', 0 ), // kjp = Pwo Eastern Karen
  TRUETYPE_TAG('k','j','q', 0 ), // kjq = Western Keres
  TRUETYPE_TAG('k','j','r', 0 ), // kjr = Kurudu
  TRUETYPE_TAG('k','j','s', 0 ), // kjs = East Kewa
  TRUETYPE_TAG('k','j','t', 0 ), // kjt = Phrae Pwo Karen
  TRUETYPE_TAG('k','j','u', 0 ), // kju = Kashaya
  TRUETYPE_TAG('k','j','x', 0 ), // kjx = Ramopa
  TRUETYPE_TAG('k','j','y', 0 ), // kjy = Erave
  TRUETYPE_TAG('k','j','z', 0 ), // kjz = Bumthangkha
  TRUETYPE_TAG('k','k','a', 0 ), // kka = Kakanda
  TRUETYPE_TAG('k','k','b', 0 ), // kkb = Kwerisa
  TRUETYPE_TAG('k','k','c', 0 ), // kkc = Odoodee
  TRUETYPE_TAG('k','k','d', 0 ), // kkd = Kinuku
  TRUETYPE_TAG('k','k','e', 0 ), // kke = Kakabe
  TRUETYPE_TAG('k','k','f', 0 ), // kkf = Kalaktang Monpa
  TRUETYPE_TAG('k','k','g', 0 ), // kkg = Mabaka Valley Kalinga
  TRUETYPE_TAG('k','k','h', 0 ), // kkh = Khün
  TRUETYPE_TAG('k','k','i', 0 ), // kki = Kagulu
  TRUETYPE_TAG('k','k','j', 0 ), // kkj = Kako
  TRUETYPE_TAG('k','k','k', 0 ), // kkk = Kokota
  TRUETYPE_TAG('k','k','l', 0 ), // kkl = Kosarek Yale
  TRUETYPE_TAG('k','k','m', 0 ), // kkm = Kiong
  TRUETYPE_TAG('k','k','n', 0 ), // kkn = Kon Keu
  TRUETYPE_TAG('k','k','o', 0 ), // kko = Karko
  TRUETYPE_TAG('k','k','p', 0 ), // kkp = Gugubera
  TRUETYPE_TAG('k','k','q', 0 ), // kkq = Kaiku
  TRUETYPE_TAG('k','k','r', 0 ), // kkr = Kir-Balar
  TRUETYPE_TAG('k','k','s', 0 ), // kks = Giiwo
  TRUETYPE_TAG('k','k','t', 0 ), // kkt = Koi
  TRUETYPE_TAG('k','k','u', 0 ), // kku = Tumi
  TRUETYPE_TAG('k','k','v', 0 ), // kkv = Kangean
  TRUETYPE_TAG('k','k','w', 0 ), // kkw = Teke-Kukuya
  TRUETYPE_TAG('k','k','x', 0 ), // kkx = Kohin
  TRUETYPE_TAG('k','k','y', 0 ), // kky = Guguyimidjir
  TRUETYPE_TAG('k','k','z', 0 ), // kkz = Kaska
  TRUETYPE_TAG('k','l','a', 0 ), // kla = Klamath-Modoc
  TRUETYPE_TAG('k','l','b', 0 ), // klb = Kiliwa
  TRUETYPE_TAG('k','l','c', 0 ), // klc = Kolbila
  TRUETYPE_TAG('k','l','d', 0 ), // kld = Gamilaraay
  TRUETYPE_TAG('k','l','e', 0 ), // kle = Kulung (Nepal)
  TRUETYPE_TAG('k','l','f', 0 ), // klf = Kendeje
  TRUETYPE_TAG('k','l','g', 0 ), // klg = Tagakaulo
  TRUETYPE_TAG('k','l','h', 0 ), // klh = Weliki
  TRUETYPE_TAG('k','l','i', 0 ), // kli = Kalumpang
  TRUETYPE_TAG('k','l','j', 0 ), // klj = Turkic Khalaj
  TRUETYPE_TAG('k','l','k', 0 ), // klk = Kono (Nigeria)
  TRUETYPE_TAG('k','l','l', 0 ), // kll = Kagan Kalagan
  TRUETYPE_TAG('k','l','m', 0 ), // klm = Migum
  TRUETYPE_TAG('k','l','n', 0 ), // kln = Kalenjin
  TRUETYPE_TAG('k','l','o', 0 ), // klo = Kapya
  TRUETYPE_TAG('k','l','p', 0 ), // klp = Kamasa
  TRUETYPE_TAG('k','l','q', 0 ), // klq = Rumu
  TRUETYPE_TAG('k','l','r', 0 ), // klr = Khaling
  TRUETYPE_TAG('k','l','s', 0 ), // kls = Kalasha
  TRUETYPE_TAG('k','l','t', 0 ), // klt = Nukna
  TRUETYPE_TAG('k','l','u', 0 ), // klu = Klao
  TRUETYPE_TAG('k','l','v', 0 ), // klv = Maskelynes
  TRUETYPE_TAG('k','l','w', 0 ), // klw = Lindu
  TRUETYPE_TAG('k','l','x', 0 ), // klx = Koluwawa
  TRUETYPE_TAG('k','l','y', 0 ), // kly = Kalao
  TRUETYPE_TAG('k','l','z', 0 ), // klz = Kabola
  TRUETYPE_TAG('k','m','a', 0 ), // kma = Konni
  TRUETYPE_TAG('k','m','b', 0 ), // kmb = Kimbundu
  TRUETYPE_TAG('k','m','c', 0 ), // kmc = Southern Dong
  TRUETYPE_TAG('k','m','d', 0 ), // kmd = Majukayang Kalinga
  TRUETYPE_TAG('k','m','e', 0 ), // kme = Bakole
  TRUETYPE_TAG('k','m','f', 0 ), // kmf = Kare (Papua New Guinea)
  TRUETYPE_TAG('k','m','g', 0 ), // kmg = Kâte
  TRUETYPE_TAG('k','m','h', 0 ), // kmh = Kalam
  TRUETYPE_TAG('k','m','i', 0 ), // kmi = Kami (Nigeria)
  TRUETYPE_TAG('k','m','j', 0 ), // kmj = Kumarbhag Paharia
  TRUETYPE_TAG('k','m','k', 0 ), // kmk = Limos Kalinga
  TRUETYPE_TAG('k','m','l', 0 ), // kml = Lower Tanudan Kalinga
  TRUETYPE_TAG('k','m','m', 0 ), // kmm = Kom (India)
  TRUETYPE_TAG('k','m','n', 0 ), // kmn = Awtuw
  TRUETYPE_TAG('k','m','o', 0 ), // kmo = Kwoma
  TRUETYPE_TAG('k','m','p', 0 ), // kmp = Gimme
  TRUETYPE_TAG('k','m','q', 0 ), // kmq = Kwama
  TRUETYPE_TAG('k','m','r', 0 ), // kmr = Northern Kurdish
  TRUETYPE_TAG('k','m','s', 0 ), // kms = Kamasau
  TRUETYPE_TAG('k','m','t', 0 ), // kmt = Kemtuik
  TRUETYPE_TAG('k','m','u', 0 ), // kmu = Kanite
  TRUETYPE_TAG('k','m','v', 0 ), // kmv = Karipúna Creole French
  TRUETYPE_TAG('k','m','w', 0 ), // kmw = Komo (Democratic Republic of Congo)
  TRUETYPE_TAG('k','m','x', 0 ), // kmx = Waboda
  TRUETYPE_TAG('k','m','y', 0 ), // kmy = Koma
  TRUETYPE_TAG('k','m','z', 0 ), // kmz = Khorasani Turkish
  TRUETYPE_TAG('k','n','a', 0 ), // kna = Dera (Nigeria)
  TRUETYPE_TAG('k','n','b', 0 ), // knb = Lubuagan Kalinga
  TRUETYPE_TAG('k','n','c', 0 ), // knc = Central Kanuri
  TRUETYPE_TAG('k','n','d', 0 ), // knd = Konda
  TRUETYPE_TAG('k','n','e', 0 ), // kne = Kankanaey
  TRUETYPE_TAG('k','n','f', 0 ), // knf = Mankanya
  TRUETYPE_TAG('k','n','g', 0 ), // kng = Koongo
  TRUETYPE_TAG('k','n','i', 0 ), // kni = Kanufi
  TRUETYPE_TAG('k','n','j', 0 ), // knj = Western Kanjobal
  TRUETYPE_TAG('k','n','k', 0 ), // knk = Kuranko
  TRUETYPE_TAG('k','n','l', 0 ), // knl = Keninjal
  TRUETYPE_TAG('k','n','m', 0 ), // knm = Kanamarí
  TRUETYPE_TAG('k','n','n', 0 ), // knn = Konkani (individual language)
  TRUETYPE_TAG('k','n','o', 0 ), // kno = Kono (Sierra Leone)
  TRUETYPE_TAG('k','n','p', 0 ), // knp = Kwanja
  TRUETYPE_TAG('k','n','q', 0 ), // knq = Kintaq
  TRUETYPE_TAG('k','n','r', 0 ), // knr = Kaningra
  TRUETYPE_TAG('k','n','s', 0 ), // kns = Kensiu
  TRUETYPE_TAG('k','n','t', 0 ), // knt = Panoan Katukína
  TRUETYPE_TAG('k','n','u', 0 ), // knu = Kono (Guinea)
  TRUETYPE_TAG('k','n','v', 0 ), // knv = Tabo
  TRUETYPE_TAG('k','n','w', 0 ), // knw = Kung-Ekoka
  TRUETYPE_TAG('k','n','x', 0 ), // knx = Kendayan
  TRUETYPE_TAG('k','n','y', 0 ), // kny = Kanyok
  TRUETYPE_TAG('k','n','z', 0 ), // knz = Kalamsé
  TRUETYPE_TAG('k','o','a', 0 ), // koa = Konomala
  TRUETYPE_TAG('k','o','c', 0 ), // koc = Kpati
  TRUETYPE_TAG('k','o','d', 0 ), // kod = Kodi
  TRUETYPE_TAG('k','o','e', 0 ), // koe = Kacipo-Balesi
  TRUETYPE_TAG('k','o','f', 0 ), // kof = Kubi
  TRUETYPE_TAG('k','o','g', 0 ), // kog = Cogui
  TRUETYPE_TAG('k','o','h', 0 ), // koh = Koyo
  TRUETYPE_TAG('k','o','i', 0 ), // koi = Komi-Permyak
  TRUETYPE_TAG('k','o','j', 0 ), // koj = Sara Dunjo
  TRUETYPE_TAG('k','o','k', 0 ), // kok = Konkani (macrolanguage)
  TRUETYPE_TAG('k','o','l', 0 ), // kol = Kol (Papua New Guinea)
  TRUETYPE_TAG('k','o','o', 0 ), // koo = Konzo
  TRUETYPE_TAG('k','o','p', 0 ), // kop = Waube
  TRUETYPE_TAG('k','o','q', 0 ), // koq = Kota (Gabon)
  TRUETYPE_TAG('k','o','s', 0 ), // kos = Kosraean
  TRUETYPE_TAG('k','o','t', 0 ), // kot = Lagwan
  TRUETYPE_TAG('k','o','u', 0 ), // kou = Koke
  TRUETYPE_TAG('k','o','v', 0 ), // kov = Kudu-Camo
  TRUETYPE_TAG('k','o','w', 0 ), // kow = Kugama
  TRUETYPE_TAG('k','o','x', 0 ), // kox = Coxima
  TRUETYPE_TAG('k','o','y', 0 ), // koy = Koyukon
  TRUETYPE_TAG('k','o','z', 0 ), // koz = Korak
  TRUETYPE_TAG('k','p','a', 0 ), // kpa = Kutto
  TRUETYPE_TAG('k','p','b', 0 ), // kpb = Mullu Kurumba
  TRUETYPE_TAG('k','p','c', 0 ), // kpc = Curripaco
  TRUETYPE_TAG('k','p','d', 0 ), // kpd = Koba
  TRUETYPE_TAG('k','p','e', 0 ), // kpe = Kpelle
  TRUETYPE_TAG('k','p','f', 0 ), // kpf = Komba
  TRUETYPE_TAG('k','p','g', 0 ), // kpg = Kapingamarangi
  TRUETYPE_TAG('k','p','h', 0 ), // kph = Kplang
  TRUETYPE_TAG('k','p','i', 0 ), // kpi = Kofei
  TRUETYPE_TAG('k','p','j', 0 ), // kpj = Karajá
  TRUETYPE_TAG('k','p','k', 0 ), // kpk = Kpan
  TRUETYPE_TAG('k','p','l', 0 ), // kpl = Kpala
  TRUETYPE_TAG('k','p','m', 0 ), // kpm = Koho
  TRUETYPE_TAG('k','p','n', 0 ), // kpn = Kepkiriwát
  TRUETYPE_TAG('k','p','o', 0 ), // kpo = Ikposo
  TRUETYPE_TAG('k','p','p', 0 ), // kpp = Paku Karen
  TRUETYPE_TAG('k','p','q', 0 ), // kpq = Korupun-Sela
  TRUETYPE_TAG('k','p','r', 0 ), // kpr = Korafe-Yegha
  TRUETYPE_TAG('k','p','s', 0 ), // kps = Tehit
  TRUETYPE_TAG('k','p','t', 0 ), // kpt = Karata
  TRUETYPE_TAG('k','p','u', 0 ), // kpu = Kafoa
  TRUETYPE_TAG('k','p','v', 0 ), // kpv = Komi-Zyrian
  TRUETYPE_TAG('k','p','w', 0 ), // kpw = Kobon
  TRUETYPE_TAG('k','p','x', 0 ), // kpx = Mountain Koiali
  TRUETYPE_TAG('k','p','y', 0 ), // kpy = Koryak
  TRUETYPE_TAG('k','p','z', 0 ), // kpz = Kupsabiny
  TRUETYPE_TAG('k','q','a', 0 ), // kqa = Mum
  TRUETYPE_TAG('k','q','b', 0 ), // kqb = Kovai
  TRUETYPE_TAG('k','q','c', 0 ), // kqc = Doromu-Koki
  TRUETYPE_TAG('k','q','d', 0 ), // kqd = Koy Sanjaq Surat
  TRUETYPE_TAG('k','q','e', 0 ), // kqe = Kalagan
  TRUETYPE_TAG('k','q','f', 0 ), // kqf = Kakabai
  TRUETYPE_TAG('k','q','g', 0 ), // kqg = Khe
  TRUETYPE_TAG('k','q','h', 0 ), // kqh = Kisankasa
  TRUETYPE_TAG('k','q','i', 0 ), // kqi = Koitabu
  TRUETYPE_TAG('k','q','j', 0 ), // kqj = Koromira
  TRUETYPE_TAG('k','q','k', 0 ), // kqk = Kotafon Gbe
  TRUETYPE_TAG('k','q','l', 0 ), // kql = Kyenele
  TRUETYPE_TAG('k','q','m', 0 ), // kqm = Khisa
  TRUETYPE_TAG('k','q','n', 0 ), // kqn = Kaonde
  TRUETYPE_TAG('k','q','o', 0 ), // kqo = Eastern Krahn
  TRUETYPE_TAG('k','q','p', 0 ), // kqp = Kimré
  TRUETYPE_TAG('k','q','q', 0 ), // kqq = Krenak
  TRUETYPE_TAG('k','q','r', 0 ), // kqr = Kimaragang
  TRUETYPE_TAG('k','q','s', 0 ), // kqs = Northern Kissi
  TRUETYPE_TAG('k','q','t', 0 ), // kqt = Klias River Kadazan
  TRUETYPE_TAG('k','q','u', 0 ), // kqu = Seroa
  TRUETYPE_TAG('k','q','v', 0 ), // kqv = Okolod
  TRUETYPE_TAG('k','q','w', 0 ), // kqw = Kandas
  TRUETYPE_TAG('k','q','x', 0 ), // kqx = Mser
  TRUETYPE_TAG('k','q','y', 0 ), // kqy = Koorete
  TRUETYPE_TAG('k','q','z', 0 ), // kqz = Korana
  TRUETYPE_TAG('k','r','a', 0 ), // kra = Kumhali
  TRUETYPE_TAG('k','r','b', 0 ), // krb = Karkin
  TRUETYPE_TAG('k','r','c', 0 ), // krc = Karachay-Balkar
  TRUETYPE_TAG('k','r','d', 0 ), // krd = Kairui-Midiki
  TRUETYPE_TAG('k','r','e', 0 ), // kre = Panará
  TRUETYPE_TAG('k','r','f', 0 ), // krf = Koro (Vanuatu)
  TRUETYPE_TAG('k','r','h', 0 ), // krh = Kurama
  TRUETYPE_TAG('k','r','i', 0 ), // kri = Krio
  TRUETYPE_TAG('k','r','j', 0 ), // krj = Kinaray-A
  TRUETYPE_TAG('k','r','k', 0 ), // krk = Kerek
  TRUETYPE_TAG('k','r','l', 0 ), // krl = Karelian
  TRUETYPE_TAG('k','r','m', 0 ), // krm = Krim
  TRUETYPE_TAG('k','r','n', 0 ), // krn = Sapo
  TRUETYPE_TAG('k','r','o', 0 ), // kro = Kru languages
  TRUETYPE_TAG('k','r','p', 0 ), // krp = Korop
  TRUETYPE_TAG('k','r','r', 0 ), // krr = Kru'ng 2
  TRUETYPE_TAG('k','r','s', 0 ), // krs = Gbaya (Sudan)
  TRUETYPE_TAG('k','r','t', 0 ), // krt = Tumari Kanuri
  TRUETYPE_TAG('k','r','u', 0 ), // kru = Kurukh
  TRUETYPE_TAG('k','r','v', 0 ), // krv = Kavet
  TRUETYPE_TAG('k','r','w', 0 ), // krw = Western Krahn
  TRUETYPE_TAG('k','r','x', 0 ), // krx = Karon
  TRUETYPE_TAG('k','r','y', 0 ), // kry = Kryts
  TRUETYPE_TAG('k','r','z', 0 ), // krz = Sota Kanum
  TRUETYPE_TAG('k','s','a', 0 ), // ksa = Shuwa-Zamani
  TRUETYPE_TAG('k','s','b', 0 ), // ksb = Shambala
  TRUETYPE_TAG('k','s','c', 0 ), // ksc = Southern Kalinga
  TRUETYPE_TAG('k','s','d', 0 ), // ksd = Kuanua
  TRUETYPE_TAG('k','s','e', 0 ), // kse = Kuni
  TRUETYPE_TAG('k','s','f', 0 ), // ksf = Bafia
  TRUETYPE_TAG('k','s','g', 0 ), // ksg = Kusaghe
  TRUETYPE_TAG('k','s','h', 0 ), // ksh = Kölsch
  TRUETYPE_TAG('k','s','i', 0 ), // ksi = Krisa
  TRUETYPE_TAG('k','s','j', 0 ), // ksj = Uare
  TRUETYPE_TAG('k','s','k', 0 ), // ksk = Kansa
  TRUETYPE_TAG('k','s','l', 0 ), // ksl = Kumalu
  TRUETYPE_TAG('k','s','m', 0 ), // ksm = Kumba
  TRUETYPE_TAG('k','s','n', 0 ), // ksn = Kasiguranin
  TRUETYPE_TAG('k','s','o', 0 ), // kso = Kofa
  TRUETYPE_TAG('k','s','p', 0 ), // ksp = Kaba
  TRUETYPE_TAG('k','s','q', 0 ), // ksq = Kwaami
  TRUETYPE_TAG('k','s','r', 0 ), // ksr = Borong
  TRUETYPE_TAG('k','s','s', 0 ), // kss = Southern Kisi
  TRUETYPE_TAG('k','s','t', 0 ), // kst = Winyé
  TRUETYPE_TAG('k','s','u', 0 ), // ksu = Khamyang
  TRUETYPE_TAG('k','s','v', 0 ), // ksv = Kusu
  TRUETYPE_TAG('k','s','w', 0 ), // ksw = S'gaw Karen
  TRUETYPE_TAG('k','s','x', 0 ), // ksx = Kedang
  TRUETYPE_TAG('k','s','y', 0 ), // ksy = Kharia Thar
  TRUETYPE_TAG('k','s','z', 0 ), // ksz = Kodaku
  TRUETYPE_TAG('k','t','a', 0 ), // kta = Katua
  TRUETYPE_TAG('k','t','b', 0 ), // ktb = Kambaata
  TRUETYPE_TAG('k','t','c', 0 ), // ktc = Kholok
  TRUETYPE_TAG('k','t','d', 0 ), // ktd = Kokata
  TRUETYPE_TAG('k','t','e', 0 ), // kte = Nubri
  TRUETYPE_TAG('k','t','f', 0 ), // ktf = Kwami
  TRUETYPE_TAG('k','t','g', 0 ), // ktg = Kalkutung
  TRUETYPE_TAG('k','t','h', 0 ), // kth = Karanga
  TRUETYPE_TAG('k','t','i', 0 ), // kti = North Muyu
  TRUETYPE_TAG('k','t','j', 0 ), // ktj = Plapo Krumen
  TRUETYPE_TAG('k','t','k', 0 ), // ktk = Kaniet
  TRUETYPE_TAG('k','t','l', 0 ), // ktl = Koroshi
  TRUETYPE_TAG('k','t','m', 0 ), // ktm = Kurti
  TRUETYPE_TAG('k','t','n', 0 ), // ktn = Karitiâna
  TRUETYPE_TAG('k','t','o', 0 ), // kto = Kuot
  TRUETYPE_TAG('k','t','p', 0 ), // ktp = Kaduo
  TRUETYPE_TAG('k','t','q', 0 ), // ktq = Katabaga
  TRUETYPE_TAG('k','t','r', 0 ), // ktr = Kota Marudu Tinagas
  TRUETYPE_TAG('k','t','s', 0 ), // kts = South Muyu
  TRUETYPE_TAG('k','t','t', 0 ), // ktt = Ketum
  TRUETYPE_TAG('k','t','u', 0 ), // ktu = Kituba (Democratic Republic of Congo)
  TRUETYPE_TAG('k','t','v', 0 ), // ktv = Eastern Katu
  TRUETYPE_TAG('k','t','w', 0 ), // ktw = Kato
  TRUETYPE_TAG('k','t','x', 0 ), // ktx = Kaxararí
  TRUETYPE_TAG('k','t','y', 0 ), // kty = Kango (Bas-Uélé District)
  TRUETYPE_TAG('k','t','z', 0 ), // ktz = Ju/'hoan
  TRUETYPE_TAG('k','u','b', 0 ), // kub = Kutep
  TRUETYPE_TAG('k','u','c', 0 ), // kuc = Kwinsu
  TRUETYPE_TAG('k','u','d', 0 ), // kud = 'Auhelawa
  TRUETYPE_TAG('k','u','e', 0 ), // kue = Kuman
  TRUETYPE_TAG('k','u','f', 0 ), // kuf = Western Katu
  TRUETYPE_TAG('k','u','g', 0 ), // kug = Kupa
  TRUETYPE_TAG('k','u','h', 0 ), // kuh = Kushi
  TRUETYPE_TAG('k','u','i', 0 ), // kui = Kuikúro-Kalapálo
  TRUETYPE_TAG('k','u','j', 0 ), // kuj = Kuria
  TRUETYPE_TAG('k','u','k', 0 ), // kuk = Kepo'
  TRUETYPE_TAG('k','u','l', 0 ), // kul = Kulere
  TRUETYPE_TAG('k','u','m', 0 ), // kum = Kumyk
  TRUETYPE_TAG('k','u','n', 0 ), // kun = Kunama
  TRUETYPE_TAG('k','u','o', 0 ), // kuo = Kumukio
  TRUETYPE_TAG('k','u','p', 0 ), // kup = Kunimaipa
  TRUETYPE_TAG('k','u','q', 0 ), // kuq = Karipuna
  TRUETYPE_TAG('k','u','s', 0 ), // kus = Kusaal
  TRUETYPE_TAG('k','u','t', 0 ), // kut = Kutenai
  TRUETYPE_TAG('k','u','u', 0 ), // kuu = Upper Kuskokwim
  TRUETYPE_TAG('k','u','v', 0 ), // kuv = Kur
  TRUETYPE_TAG('k','u','w', 0 ), // kuw = Kpagua
  TRUETYPE_TAG('k','u','x', 0 ), // kux = Kukatja
  TRUETYPE_TAG('k','u','y', 0 ), // kuy = Kuuku-Ya'u
  TRUETYPE_TAG('k','u','z', 0 ), // kuz = Kunza
  TRUETYPE_TAG('k','v','a', 0 ), // kva = Bagvalal
  TRUETYPE_TAG('k','v','b', 0 ), // kvb = Kubu
  TRUETYPE_TAG('k','v','c', 0 ), // kvc = Kove
  TRUETYPE_TAG('k','v','d', 0 ), // kvd = Kui (Indonesia)
  TRUETYPE_TAG('k','v','e', 0 ), // kve = Kalabakan
  TRUETYPE_TAG('k','v','f', 0 ), // kvf = Kabalai
  TRUETYPE_TAG('k','v','g', 0 ), // kvg = Kuni-Boazi
  TRUETYPE_TAG('k','v','h', 0 ), // kvh = Komodo
  TRUETYPE_TAG('k','v','i', 0 ), // kvi = Kwang
  TRUETYPE_TAG('k','v','j', 0 ), // kvj = Psikye
  TRUETYPE_TAG('k','v','k', 0 ), // kvk = Korean Sign Language
  TRUETYPE_TAG('k','v','l', 0 ), // kvl = Brek Karen
  TRUETYPE_TAG('k','v','m', 0 ), // kvm = Kendem
  TRUETYPE_TAG('k','v','n', 0 ), // kvn = Border Kuna
  TRUETYPE_TAG('k','v','o', 0 ), // kvo = Dobel
  TRUETYPE_TAG('k','v','p', 0 ), // kvp = Kompane
  TRUETYPE_TAG('k','v','q', 0 ), // kvq = Geba Karen
  TRUETYPE_TAG('k','v','r', 0 ), // kvr = Kerinci
  TRUETYPE_TAG('k','v','s', 0 ), // kvs = Kunggara
  TRUETYPE_TAG('k','v','t', 0 ), // kvt = Lahta Karen
  TRUETYPE_TAG('k','v','u', 0 ), // kvu = Yinbaw Karen
  TRUETYPE_TAG('k','v','v', 0 ), // kvv = Kola
  TRUETYPE_TAG('k','v','w', 0 ), // kvw = Wersing
  TRUETYPE_TAG('k','v','x', 0 ), // kvx = Parkari Koli
  TRUETYPE_TAG('k','v','y', 0 ), // kvy = Yintale Karen
  TRUETYPE_TAG('k','v','z', 0 ), // kvz = Tsakwambo
  TRUETYPE_TAG('k','w','a', 0 ), // kwa = Dâw
  TRUETYPE_TAG('k','w','b', 0 ), // kwb = Kwa
  TRUETYPE_TAG('k','w','c', 0 ), // kwc = Likwala
  TRUETYPE_TAG('k','w','d', 0 ), // kwd = Kwaio
  TRUETYPE_TAG('k','w','e', 0 ), // kwe = Kwerba
  TRUETYPE_TAG('k','w','f', 0 ), // kwf = Kwara'ae
  TRUETYPE_TAG('k','w','g', 0 ), // kwg = Sara Kaba Deme
  TRUETYPE_TAG('k','w','h', 0 ), // kwh = Kowiai
  TRUETYPE_TAG('k','w','i', 0 ), // kwi = Awa-Cuaiquer
  TRUETYPE_TAG('k','w','j', 0 ), // kwj = Kwanga
  TRUETYPE_TAG('k','w','k', 0 ), // kwk = Kwakiutl
  TRUETYPE_TAG('k','w','l', 0 ), // kwl = Kofyar
  TRUETYPE_TAG('k','w','m', 0 ), // kwm = Kwambi
  TRUETYPE_TAG('k','w','n', 0 ), // kwn = Kwangali
  TRUETYPE_TAG('k','w','o', 0 ), // kwo = Kwomtari
  TRUETYPE_TAG('k','w','p', 0 ), // kwp = Kodia
  TRUETYPE_TAG('k','w','q', 0 ), // kwq = Kwak
  TRUETYPE_TAG('k','w','r', 0 ), // kwr = Kwer
  TRUETYPE_TAG('k','w','s', 0 ), // kws = Kwese
  TRUETYPE_TAG('k','w','t', 0 ), // kwt = Kwesten
  TRUETYPE_TAG('k','w','u', 0 ), // kwu = Kwakum
  TRUETYPE_TAG('k','w','v', 0 ), // kwv = Sara Kaba Náà
  TRUETYPE_TAG('k','w','w', 0 ), // kww = Kwinti
  TRUETYPE_TAG('k','w','x', 0 ), // kwx = Khirwar
  TRUETYPE_TAG('k','w','y', 0 ), // kwy = San Salvador Kongo
  TRUETYPE_TAG('k','w','z', 0 ), // kwz = Kwadi
  TRUETYPE_TAG('k','x','a', 0 ), // kxa = Kairiru
  TRUETYPE_TAG('k','x','b', 0 ), // kxb = Krobu
  TRUETYPE_TAG('k','x','c', 0 ), // kxc = Konso
  TRUETYPE_TAG('k','x','d', 0 ), // kxd = Brunei
  TRUETYPE_TAG('k','x','e', 0 ), // kxe = Kakihum
  TRUETYPE_TAG('k','x','f', 0 ), // kxf = Manumanaw Karen
  TRUETYPE_TAG('k','x','h', 0 ), // kxh = Karo (Ethiopia)
  TRUETYPE_TAG('k','x','i', 0 ), // kxi = Keningau Murut
  TRUETYPE_TAG('k','x','j', 0 ), // kxj = Kulfa
  TRUETYPE_TAG('k','x','k', 0 ), // kxk = Zayein Karen
  TRUETYPE_TAG('k','x','l', 0 ), // kxl = Nepali Kurux
  TRUETYPE_TAG('k','x','m', 0 ), // kxm = Northern Khmer
  TRUETYPE_TAG('k','x','n', 0 ), // kxn = Kanowit-Tanjong Melanau
  TRUETYPE_TAG('k','x','o', 0 ), // kxo = Kanoé
  TRUETYPE_TAG('k','x','p', 0 ), // kxp = Wadiyara Koli
  TRUETYPE_TAG('k','x','q', 0 ), // kxq = Smärky Kanum
  TRUETYPE_TAG('k','x','r', 0 ), // kxr = Koro (Papua New Guinea)
  TRUETYPE_TAG('k','x','s', 0 ), // kxs = Kangjia
  TRUETYPE_TAG('k','x','t', 0 ), // kxt = Koiwat
  TRUETYPE_TAG('k','x','u', 0 ), // kxu = Kui (India)
  TRUETYPE_TAG('k','x','v', 0 ), // kxv = Kuvi
  TRUETYPE_TAG('k','x','w', 0 ), // kxw = Konai
  TRUETYPE_TAG('k','x','x', 0 ), // kxx = Likuba
  TRUETYPE_TAG('k','x','y', 0 ), // kxy = Kayong
  TRUETYPE_TAG('k','x','z', 0 ), // kxz = Kerewo
  TRUETYPE_TAG('k','y','a', 0 ), // kya = Kwaya
  TRUETYPE_TAG('k','y','b', 0 ), // kyb = Butbut Kalinga
  TRUETYPE_TAG('k','y','c', 0 ), // kyc = Kyaka
  TRUETYPE_TAG('k','y','d', 0 ), // kyd = Karey
  TRUETYPE_TAG('k','y','e', 0 ), // kye = Krache
  TRUETYPE_TAG('k','y','f', 0 ), // kyf = Kouya
  TRUETYPE_TAG('k','y','g', 0 ), // kyg = Keyagana
  TRUETYPE_TAG('k','y','h', 0 ), // kyh = Karok
  TRUETYPE_TAG('k','y','i', 0 ), // kyi = Kiput
  TRUETYPE_TAG('k','y','j', 0 ), // kyj = Karao
  TRUETYPE_TAG('k','y','k', 0 ), // kyk = Kamayo
  TRUETYPE_TAG('k','y','l', 0 ), // kyl = Kalapuya
  TRUETYPE_TAG('k','y','m', 0 ), // kym = Kpatili
  TRUETYPE_TAG('k','y','n', 0 ), // kyn = Northern Binukidnon
  TRUETYPE_TAG('k','y','o', 0 ), // kyo = Kelon
  TRUETYPE_TAG('k','y','p', 0 ), // kyp = Kang
  TRUETYPE_TAG('k','y','q', 0 ), // kyq = Kenga
  TRUETYPE_TAG('k','y','r', 0 ), // kyr = Kuruáya
  TRUETYPE_TAG('k','y','s', 0 ), // kys = Baram Kayan
  TRUETYPE_TAG('k','y','t', 0 ), // kyt = Kayagar
  TRUETYPE_TAG('k','y','u', 0 ), // kyu = Western Kayah
  TRUETYPE_TAG('k','y','v', 0 ), // kyv = Kayort
  TRUETYPE_TAG('k','y','w', 0 ), // kyw = Kudmali
  TRUETYPE_TAG('k','y','x', 0 ), // kyx = Rapoisi
  TRUETYPE_TAG('k','y','y', 0 ), // kyy = Kambaira
  TRUETYPE_TAG('k','y','z', 0 ), // kyz = Kayabí
  TRUETYPE_TAG('k','z','a', 0 ), // kza = Western Karaboro
  TRUETYPE_TAG('k','z','b', 0 ), // kzb = Kaibobo
  TRUETYPE_TAG('k','z','c', 0 ), // kzc = Bondoukou Kulango
  TRUETYPE_TAG('k','z','d', 0 ), // kzd = Kadai
  TRUETYPE_TAG('k','z','e', 0 ), // kze = Kosena
  TRUETYPE_TAG('k','z','f', 0 ), // kzf = Da'a Kaili
  TRUETYPE_TAG('k','z','g', 0 ), // kzg = Kikai
  TRUETYPE_TAG('k','z','h', 0 ), // kzh = Kenuzi-Dongola
  TRUETYPE_TAG('k','z','i', 0 ), // kzi = Kelabit
  TRUETYPE_TAG('k','z','j', 0 ), // kzj = Coastal Kadazan
  TRUETYPE_TAG('k','z','k', 0 ), // kzk = Kazukuru
  TRUETYPE_TAG('k','z','l', 0 ), // kzl = Kayeli
  TRUETYPE_TAG('k','z','m', 0 ), // kzm = Kais
  TRUETYPE_TAG('k','z','n', 0 ), // kzn = Kokola
  TRUETYPE_TAG('k','z','o', 0 ), // kzo = Kaningi
  TRUETYPE_TAG('k','z','p', 0 ), // kzp = Kaidipang
  TRUETYPE_TAG('k','z','q', 0 ), // kzq = Kaike
  TRUETYPE_TAG('k','z','r', 0 ), // kzr = Karang
  TRUETYPE_TAG('k','z','s', 0 ), // kzs = Sugut Dusun
  TRUETYPE_TAG('k','z','t', 0 ), // kzt = Tambunan Dusun
  TRUETYPE_TAG('k','z','u', 0 ), // kzu = Kayupulau
  TRUETYPE_TAG('k','z','v', 0 ), // kzv = Komyandaret
  TRUETYPE_TAG('k','z','w', 0 ), // kzw = Karirí-Xocó
  TRUETYPE_TAG('k','z','x', 0 ), // kzx = Kamarian
  TRUETYPE_TAG('k','z','y', 0 ), // kzy = Kango (Tshopo District)
  TRUETYPE_TAG('k','z','z', 0 ), // kzz = Kalabra
  TRUETYPE_TAG('l','a','a', 0 ), // laa = Southern Subanen
  TRUETYPE_TAG('l','a','b', 0 ), // lab = Linear A
  TRUETYPE_TAG('l','a','c', 0 ), // lac = Lacandon
  TRUETYPE_TAG('l','a','d', 0 ), // lad = Ladino
  TRUETYPE_TAG('l','a','e', 0 ), // lae = Pattani
  TRUETYPE_TAG('l','a','f', 0 ), // laf = Lafofa
  TRUETYPE_TAG('l','a','g', 0 ), // lag = Langi
  TRUETYPE_TAG('l','a','h', 0 ), // lah = Lahnda
  TRUETYPE_TAG('l','a','i', 0 ), // lai = Lambya
  TRUETYPE_TAG('l','a','j', 0 ), // laj = Lango (Uganda)
  TRUETYPE_TAG('l','a','k', 0 ), // lak = Laka (Nigeria)
  TRUETYPE_TAG('l','a','l', 0 ), // lal = Lalia
  TRUETYPE_TAG('l','a','m', 0 ), // lam = Lamba
  TRUETYPE_TAG('l','a','n', 0 ), // lan = Laru
  TRUETYPE_TAG('l','a','p', 0 ), // lap = Laka (Chad)
  TRUETYPE_TAG('l','a','q', 0 ), // laq = Qabiao
  TRUETYPE_TAG('l','a','r', 0 ), // lar = Larteh
  TRUETYPE_TAG('l','a','s', 0 ), // las = Lama (Togo)
  TRUETYPE_TAG('l','a','u', 0 ), // lau = Laba
  TRUETYPE_TAG('l','a','w', 0 ), // law = Lauje
  TRUETYPE_TAG('l','a','x', 0 ), // lax = Tiwa
  TRUETYPE_TAG('l','a','y', 0 ), // lay = Lama (Myanmar)
  TRUETYPE_TAG('l','a','z', 0 ), // laz = Aribwatsa
  TRUETYPE_TAG('l','b','a', 0 ), // lba = Lui
  TRUETYPE_TAG('l','b','b', 0 ), // lbb = Label
  TRUETYPE_TAG('l','b','c', 0 ), // lbc = Lakkia
  TRUETYPE_TAG('l','b','e', 0 ), // lbe = Lak
  TRUETYPE_TAG('l','b','f', 0 ), // lbf = Tinani
  TRUETYPE_TAG('l','b','g', 0 ), // lbg = Laopang
  TRUETYPE_TAG('l','b','i', 0 ), // lbi = La'bi
  TRUETYPE_TAG('l','b','j', 0 ), // lbj = Ladakhi
  TRUETYPE_TAG('l','b','k', 0 ), // lbk = Central Bontok
  TRUETYPE_TAG('l','b','l', 0 ), // lbl = Libon Bikol
  TRUETYPE_TAG('l','b','m', 0 ), // lbm = Lodhi
  TRUETYPE_TAG('l','b','n', 0 ), // lbn = Lamet
  TRUETYPE_TAG('l','b','o', 0 ), // lbo = Laven
  TRUETYPE_TAG('l','b','q', 0 ), // lbq = Wampar
  TRUETYPE_TAG('l','b','r', 0 ), // lbr = Northern Lorung
  TRUETYPE_TAG('l','b','s', 0 ), // lbs = Libyan Sign Language
  TRUETYPE_TAG('l','b','t', 0 ), // lbt = Lachi
  TRUETYPE_TAG('l','b','u', 0 ), // lbu = Labu
  TRUETYPE_TAG('l','b','v', 0 ), // lbv = Lavatbura-Lamusong
  TRUETYPE_TAG('l','b','w', 0 ), // lbw = Tolaki
  TRUETYPE_TAG('l','b','x', 0 ), // lbx = Lawangan
  TRUETYPE_TAG('l','b','y', 0 ), // lby = Lamu-Lamu
  TRUETYPE_TAG('l','b','z', 0 ), // lbz = Lardil
  TRUETYPE_TAG('l','c','c', 0 ), // lcc = Legenyem
  TRUETYPE_TAG('l','c','d', 0 ), // lcd = Lola
  TRUETYPE_TAG('l','c','e', 0 ), // lce = Loncong
  TRUETYPE_TAG('l','c','f', 0 ), // lcf = Lubu
  TRUETYPE_TAG('l','c','h', 0 ), // lch = Luchazi
  TRUETYPE_TAG('l','c','l', 0 ), // lcl = Lisela
  TRUETYPE_TAG('l','c','m', 0 ), // lcm = Tungag
  TRUETYPE_TAG('l','c','p', 0 ), // lcp = Western Lawa
  TRUETYPE_TAG('l','c','q', 0 ), // lcq = Luhu
  TRUETYPE_TAG('l','c','s', 0 ), // lcs = Lisabata-Nuniali
  TRUETYPE_TAG('l','d','b', 0 ), // ldb = Idun
  TRUETYPE_TAG('l','d','d', 0 ), // ldd = Luri
  TRUETYPE_TAG('l','d','g', 0 ), // ldg = Lenyima
  TRUETYPE_TAG('l','d','h', 0 ), // ldh = Lamja-Dengsa-Tola
  TRUETYPE_TAG('l','d','i', 0 ), // ldi = Laari
  TRUETYPE_TAG('l','d','j', 0 ), // ldj = Lemoro
  TRUETYPE_TAG('l','d','k', 0 ), // ldk = Leelau
  TRUETYPE_TAG('l','d','l', 0 ), // ldl = Kaan
  TRUETYPE_TAG('l','d','m', 0 ), // ldm = Landoma
  TRUETYPE_TAG('l','d','n', 0 ), // ldn = Láadan
  TRUETYPE_TAG('l','d','o', 0 ), // ldo = Loo
  TRUETYPE_TAG('l','d','p', 0 ), // ldp = Tso
  TRUETYPE_TAG('l','d','q', 0 ), // ldq = Lufu
  TRUETYPE_TAG('l','e','a', 0 ), // lea = Lega-Shabunda
  TRUETYPE_TAG('l','e','b', 0 ), // leb = Lala-Bisa
  TRUETYPE_TAG('l','e','c', 0 ), // lec = Leco
  TRUETYPE_TAG('l','e','d', 0 ), // led = Lendu
  TRUETYPE_TAG('l','e','e', 0 ), // lee = Lyélé
  TRUETYPE_TAG('l','e','f', 0 ), // lef = Lelemi
  TRUETYPE_TAG('l','e','g', 0 ), // leg = Lengua
  TRUETYPE_TAG('l','e','h', 0 ), // leh = Lenje
  TRUETYPE_TAG('l','e','i', 0 ), // lei = Lemio
  TRUETYPE_TAG('l','e','j', 0 ), // lej = Lengola
  TRUETYPE_TAG('l','e','k', 0 ), // lek = Leipon
  TRUETYPE_TAG('l','e','l', 0 ), // lel = Lele (Democratic Republic of Congo)
  TRUETYPE_TAG('l','e','m', 0 ), // lem = Nomaande
  TRUETYPE_TAG('l','e','n', 0 ), // len = Lenca
  TRUETYPE_TAG('l','e','o', 0 ), // leo = Leti (Cameroon)
  TRUETYPE_TAG('l','e','p', 0 ), // lep = Lepcha
  TRUETYPE_TAG('l','e','q', 0 ), // leq = Lembena
  TRUETYPE_TAG('l','e','r', 0 ), // ler = Lenkau
  TRUETYPE_TAG('l','e','s', 0 ), // les = Lese
  TRUETYPE_TAG('l','e','t', 0 ), // let = Lesing-Gelimi
  TRUETYPE_TAG('l','e','u', 0 ), // leu = Kara (Papua New Guinea)
  TRUETYPE_TAG('l','e','v', 0 ), // lev = Lamma
  TRUETYPE_TAG('l','e','w', 0 ), // lew = Ledo Kaili
  TRUETYPE_TAG('l','e','x', 0 ), // lex = Luang
  TRUETYPE_TAG('l','e','y', 0 ), // ley = Lemolang
  TRUETYPE_TAG('l','e','z', 0 ), // lez = Lezghian
  TRUETYPE_TAG('l','f','a', 0 ), // lfa = Lefa
  TRUETYPE_TAG('l','f','n', 0 ), // lfn = Lingua Franca Nova
  TRUETYPE_TAG('l','g','a', 0 ), // lga = Lungga
  TRUETYPE_TAG('l','g','b', 0 ), // lgb = Laghu
  TRUETYPE_TAG('l','g','g', 0 ), // lgg = Lugbara
  TRUETYPE_TAG('l','g','h', 0 ), // lgh = Laghuu
  TRUETYPE_TAG('l','g','i', 0 ), // lgi = Lengilu
  TRUETYPE_TAG('l','g','k', 0 ), // lgk = Lingarak
  TRUETYPE_TAG('l','g','l', 0 ), // lgl = Wala
  TRUETYPE_TAG('l','g','m', 0 ), // lgm = Lega-Mwenga
  TRUETYPE_TAG('l','g','n', 0 ), // lgn = Opuuo
  TRUETYPE_TAG('l','g','q', 0 ), // lgq = Logba
  TRUETYPE_TAG('l','g','r', 0 ), // lgr = Lengo
  TRUETYPE_TAG('l','g','t', 0 ), // lgt = Pahi
  TRUETYPE_TAG('l','g','u', 0 ), // lgu = Longgu
  TRUETYPE_TAG('l','g','z', 0 ), // lgz = Ligenza
  TRUETYPE_TAG('l','h','a', 0 ), // lha = Laha (Viet Nam)
  TRUETYPE_TAG('l','h','h', 0 ), // lhh = Laha (Indonesia)
  TRUETYPE_TAG('l','h','i', 0 ), // lhi = Lahu Shi
  TRUETYPE_TAG('l','h','l', 0 ), // lhl = Lahul Lohar
  TRUETYPE_TAG('l','h','m', 0 ), // lhm = Lhomi
  TRUETYPE_TAG('l','h','n', 0 ), // lhn = Lahanan
  TRUETYPE_TAG('l','h','p', 0 ), // lhp = Lhokpu
  TRUETYPE_TAG('l','h','s', 0 ), // lhs = Mlahsö
  TRUETYPE_TAG('l','h','t', 0 ), // lht = Lo-Toga
  TRUETYPE_TAG('l','h','u', 0 ), // lhu = Lahu
  TRUETYPE_TAG('l','i','a', 0 ), // lia = West-Central Limba
  TRUETYPE_TAG('l','i','b', 0 ), // lib = Likum
  TRUETYPE_TAG('l','i','c', 0 ), // lic = Hlai
  TRUETYPE_TAG('l','i','d', 0 ), // lid = Nyindrou
  TRUETYPE_TAG('l','i','e', 0 ), // lie = Likila
  TRUETYPE_TAG('l','i','f', 0 ), // lif = Limbu
  TRUETYPE_TAG('l','i','g', 0 ), // lig = Ligbi
  TRUETYPE_TAG('l','i','h', 0 ), // lih = Lihir
  TRUETYPE_TAG('l','i','i', 0 ), // lii = Lingkhim
  TRUETYPE_TAG('l','i','j', 0 ), // lij = Ligurian
  TRUETYPE_TAG('l','i','k', 0 ), // lik = Lika
  TRUETYPE_TAG('l','i','l', 0 ), // lil = Lillooet
  TRUETYPE_TAG('l','i','o', 0 ), // lio = Liki
  TRUETYPE_TAG('l','i','p', 0 ), // lip = Sekpele
  TRUETYPE_TAG('l','i','q', 0 ), // liq = Libido
  TRUETYPE_TAG('l','i','r', 0 ), // lir = Liberian English
  TRUETYPE_TAG('l','i','s', 0 ), // lis = Lisu
  TRUETYPE_TAG('l','i','u', 0 ), // liu = Logorik
  TRUETYPE_TAG('l','i','v', 0 ), // liv = Liv
  TRUETYPE_TAG('l','i','w', 0 ), // liw = Col
  TRUETYPE_TAG('l','i','x', 0 ), // lix = Liabuku
  TRUETYPE_TAG('l','i','y', 0 ), // liy = Banda-Bambari
  TRUETYPE_TAG('l','i','z', 0 ), // liz = Libinza
  TRUETYPE_TAG('l','j','e', 0 ), // lje = Rampi
  TRUETYPE_TAG('l','j','i', 0 ), // lji = Laiyolo
  TRUETYPE_TAG('l','j','l', 0 ), // ljl = Li'o
  TRUETYPE_TAG('l','j','p', 0 ), // ljp = Lampung Api
  TRUETYPE_TAG('l','k','a', 0 ), // lka = Lakalei
  TRUETYPE_TAG('l','k','b', 0 ), // lkb = Kabras
  TRUETYPE_TAG('l','k','c', 0 ), // lkc = Kucong
  TRUETYPE_TAG('l','k','d', 0 ), // lkd = Lakondê
  TRUETYPE_TAG('l','k','e', 0 ), // lke = Kenyi
  TRUETYPE_TAG('l','k','h', 0 ), // lkh = Lakha
  TRUETYPE_TAG('l','k','i', 0 ), // lki = Laki
  TRUETYPE_TAG('l','k','j', 0 ), // lkj = Remun
  TRUETYPE_TAG('l','k','l', 0 ), // lkl = Laeko-Libuat
  TRUETYPE_TAG('l','k','n', 0 ), // lkn = Lakon
  TRUETYPE_TAG('l','k','o', 0 ), // lko = Khayo
  TRUETYPE_TAG('l','k','r', 0 ), // lkr = Päri
  TRUETYPE_TAG('l','k','s', 0 ), // lks = Kisa
  TRUETYPE_TAG('l','k','t', 0 ), // lkt = Lakota
  TRUETYPE_TAG('l','k','y', 0 ), // lky = Lokoya
  TRUETYPE_TAG('l','l','a', 0 ), // lla = Lala-Roba
  TRUETYPE_TAG('l','l','b', 0 ), // llb = Lolo
  TRUETYPE_TAG('l','l','c', 0 ), // llc = Lele (Guinea)
  TRUETYPE_TAG('l','l','d', 0 ), // lld = Ladin
  TRUETYPE_TAG('l','l','e', 0 ), // lle = Lele (Papua New Guinea)
  TRUETYPE_TAG('l','l','f', 0 ), // llf = Hermit
  TRUETYPE_TAG('l','l','g', 0 ), // llg = Lole
  TRUETYPE_TAG('l','l','h', 0 ), // llh = Lamu
  TRUETYPE_TAG('l','l','i', 0 ), // lli = Teke-Laali
  TRUETYPE_TAG('l','l','k', 0 ), // llk = Lelak
  TRUETYPE_TAG('l','l','l', 0 ), // lll = Lilau
  TRUETYPE_TAG('l','l','m', 0 ), // llm = Lasalimu
  TRUETYPE_TAG('l','l','n', 0 ), // lln = Lele (Chad)
  TRUETYPE_TAG('l','l','o', 0 ), // llo = Khlor
  TRUETYPE_TAG('l','l','p', 0 ), // llp = North Efate
  TRUETYPE_TAG('l','l','q', 0 ), // llq = Lolak
  TRUETYPE_TAG('l','l','s', 0 ), // lls = Lithuanian Sign Language
  TRUETYPE_TAG('l','l','u', 0 ), // llu = Lau
  TRUETYPE_TAG('l','l','x', 0 ), // llx = Lauan
  TRUETYPE_TAG('l','m','a', 0 ), // lma = East Limba
  TRUETYPE_TAG('l','m','b', 0 ), // lmb = Merei
  TRUETYPE_TAG('l','m','c', 0 ), // lmc = Limilngan
  TRUETYPE_TAG('l','m','d', 0 ), // lmd = Lumun
  TRUETYPE_TAG('l','m','e', 0 ), // lme = Pévé
  TRUETYPE_TAG('l','m','f', 0 ), // lmf = South Lembata
  TRUETYPE_TAG('l','m','g', 0 ), // lmg = Lamogai
  TRUETYPE_TAG('l','m','h', 0 ), // lmh = Lambichhong
  TRUETYPE_TAG('l','m','i', 0 ), // lmi = Lombi
  TRUETYPE_TAG('l','m','j', 0 ), // lmj = West Lembata
  TRUETYPE_TAG('l','m','k', 0 ), // lmk = Lamkang
  TRUETYPE_TAG('l','m','l', 0 ), // lml = Hano
  TRUETYPE_TAG('l','m','m', 0 ), // lmm = Lamam
  TRUETYPE_TAG('l','m','n', 0 ), // lmn = Lambadi
  TRUETYPE_TAG('l','m','o', 0 ), // lmo = Lombard
  TRUETYPE_TAG('l','m','p', 0 ), // lmp = Limbum
  TRUETYPE_TAG('l','m','q', 0 ), // lmq = Lamatuka
  TRUETYPE_TAG('l','m','r', 0 ), // lmr = Lamalera
  TRUETYPE_TAG('l','m','u', 0 ), // lmu = Lamenu
  TRUETYPE_TAG('l','m','v', 0 ), // lmv = Lomaiviti
  TRUETYPE_TAG('l','m','w', 0 ), // lmw = Lake Miwok
  TRUETYPE_TAG('l','m','x', 0 ), // lmx = Laimbue
  TRUETYPE_TAG('l','m','y', 0 ), // lmy = Lamboya
  TRUETYPE_TAG('l','m','z', 0 ), // lmz = Lumbee
  TRUETYPE_TAG('l','n','a', 0 ), // lna = Langbashe
  TRUETYPE_TAG('l','n','b', 0 ), // lnb = Mbalanhu
  TRUETYPE_TAG('l','n','d', 0 ), // lnd = Lundayeh
  TRUETYPE_TAG('l','n','g', 0 ), // lng = Langobardic
  TRUETYPE_TAG('l','n','h', 0 ), // lnh = Lanoh
  TRUETYPE_TAG('l','n','i', 0 ), // lni = Daantanai'
  TRUETYPE_TAG('l','n','j', 0 ), // lnj = Leningitij
  TRUETYPE_TAG('l','n','l', 0 ), // lnl = South Central Banda
  TRUETYPE_TAG('l','n','m', 0 ), // lnm = Langam
  TRUETYPE_TAG('l','n','n', 0 ), // lnn = Lorediakarkar
  TRUETYPE_TAG('l','n','o', 0 ), // lno = Lango (Sudan)
  TRUETYPE_TAG('l','n','s', 0 ), // lns = Lamnso'
  TRUETYPE_TAG('l','n','u', 0 ), // lnu = Longuda
  TRUETYPE_TAG('l','n','z', 0 ), // lnz = Lonzo
  TRUETYPE_TAG('l','o','a', 0 ), // loa = Loloda
  TRUETYPE_TAG('l','o','b', 0 ), // lob = Lobi
  TRUETYPE_TAG('l','o','c', 0 ), // loc = Inonhan
  TRUETYPE_TAG('l','o','e', 0 ), // loe = Saluan
  TRUETYPE_TAG('l','o','f', 0 ), // lof = Logol
  TRUETYPE_TAG('l','o','g', 0 ), // log = Logo
  TRUETYPE_TAG('l','o','h', 0 ), // loh = Narim
  TRUETYPE_TAG('l','o','i', 0 ), // loi = Loma (Côte d'Ivoire)
  TRUETYPE_TAG('l','o','j', 0 ), // loj = Lou
  TRUETYPE_TAG('l','o','k', 0 ), // lok = Loko
  TRUETYPE_TAG('l','o','l', 0 ), // lol = Mongo
  TRUETYPE_TAG('l','o','m', 0 ), // lom = Loma (Liberia)
  TRUETYPE_TAG('l','o','n', 0 ), // lon = Malawi Lomwe
  TRUETYPE_TAG('l','o','o', 0 ), // loo = Lombo
  TRUETYPE_TAG('l','o','p', 0 ), // lop = Lopa
  TRUETYPE_TAG('l','o','q', 0 ), // loq = Lobala
  TRUETYPE_TAG('l','o','r', 0 ), // lor = Téén
  TRUETYPE_TAG('l','o','s', 0 ), // los = Loniu
  TRUETYPE_TAG('l','o','t', 0 ), // lot = Otuho
  TRUETYPE_TAG('l','o','u', 0 ), // lou = Louisiana Creole French
  TRUETYPE_TAG('l','o','v', 0 ), // lov = Lopi
  TRUETYPE_TAG('l','o','w', 0 ), // low = Tampias Lobu
  TRUETYPE_TAG('l','o','x', 0 ), // lox = Loun
  TRUETYPE_TAG('l','o','y', 0 ), // loy = Lowa
  TRUETYPE_TAG('l','o','z', 0 ), // loz = Lozi
  TRUETYPE_TAG('l','p','a', 0 ), // lpa = Lelepa
  TRUETYPE_TAG('l','p','e', 0 ), // lpe = Lepki
  TRUETYPE_TAG('l','p','n', 0 ), // lpn = Long Phuri Naga
  TRUETYPE_TAG('l','p','o', 0 ), // lpo = Lipo
  TRUETYPE_TAG('l','p','x', 0 ), // lpx = Lopit
  TRUETYPE_TAG('l','r','a', 0 ), // lra = Rara Bakati'
  TRUETYPE_TAG('l','r','c', 0 ), // lrc = Northern Luri
  TRUETYPE_TAG('l','r','e', 0 ), // lre = Laurentian
  TRUETYPE_TAG('l','r','g', 0 ), // lrg = Laragia
  TRUETYPE_TAG('l','r','i', 0 ), // lri = Marachi
  TRUETYPE_TAG('l','r','k', 0 ), // lrk = Loarki
  TRUETYPE_TAG('l','r','l', 0 ), // lrl = Lari
  TRUETYPE_TAG('l','r','m', 0 ), // lrm = Marama
  TRUETYPE_TAG('l','r','n', 0 ), // lrn = Lorang
  TRUETYPE_TAG('l','r','o', 0 ), // lro = Laro
  TRUETYPE_TAG('l','r','r', 0 ), // lrr = Southern Lorung
  TRUETYPE_TAG('l','r','t', 0 ), // lrt = Larantuka Malay
  TRUETYPE_TAG('l','r','v', 0 ), // lrv = Larevat
  TRUETYPE_TAG('l','r','z', 0 ), // lrz = Lemerig
  TRUETYPE_TAG('l','s','a', 0 ), // lsa = Lasgerdi
  TRUETYPE_TAG('l','s','d', 0 ), // lsd = Lishana Deni
  TRUETYPE_TAG('l','s','e', 0 ), // lse = Lusengo
  TRUETYPE_TAG('l','s','g', 0 ), // lsg = Lyons Sign Language
  TRUETYPE_TAG('l','s','h', 0 ), // lsh = Lish
  TRUETYPE_TAG('l','s','i', 0 ), // lsi = Lashi
  TRUETYPE_TAG('l','s','l', 0 ), // lsl = Latvian Sign Language
  TRUETYPE_TAG('l','s','m', 0 ), // lsm = Saamia
  TRUETYPE_TAG('l','s','o', 0 ), // lso = Laos Sign Language
  TRUETYPE_TAG('l','s','p', 0 ), // lsp = Panamanian Sign Language
  TRUETYPE_TAG('l','s','r', 0 ), // lsr = Aruop
  TRUETYPE_TAG('l','s','s', 0 ), // lss = Lasi
  TRUETYPE_TAG('l','s','t', 0 ), // lst = Trinidad and Tobago Sign Language
  TRUETYPE_TAG('l','s','y', 0 ), // lsy = Mauritian Sign Language
  TRUETYPE_TAG('l','t','c', 0 ), // ltc = Late Middle Chinese
  TRUETYPE_TAG('l','t','g', 0 ), // ltg = Latgalian
  TRUETYPE_TAG('l','t','i', 0 ), // lti = Leti (Indonesia)
  TRUETYPE_TAG('l','t','n', 0 ), // ltn = Latundê
  TRUETYPE_TAG('l','t','o', 0 ), // lto = Tsotso
  TRUETYPE_TAG('l','t','s', 0 ), // lts = Tachoni
  TRUETYPE_TAG('l','t','u', 0 ), // ltu = Latu
  TRUETYPE_TAG('l','u','a', 0 ), // lua = Luba-Lulua
  TRUETYPE_TAG('l','u','c', 0 ), // luc = Aringa
  TRUETYPE_TAG('l','u','d', 0 ), // lud = Ludian
  TRUETYPE_TAG('l','u','e', 0 ), // lue = Luvale
  TRUETYPE_TAG('l','u','f', 0 ), // luf = Laua
  TRUETYPE_TAG('l','u','i', 0 ), // lui = Luiseno
  TRUETYPE_TAG('l','u','j', 0 ), // luj = Luna
  TRUETYPE_TAG('l','u','k', 0 ), // luk = Lunanakha
  TRUETYPE_TAG('l','u','l', 0 ), // lul = Olu'bo
  TRUETYPE_TAG('l','u','m', 0 ), // lum = Luimbi
  TRUETYPE_TAG('l','u','n', 0 ), // lun = Lunda
  TRUETYPE_TAG('l','u','o', 0 ), // luo = Luo (Kenya and Tanzania)
  TRUETYPE_TAG('l','u','p', 0 ), // lup = Lumbu
  TRUETYPE_TAG('l','u','q', 0 ), // luq = Lucumi
  TRUETYPE_TAG('l','u','r', 0 ), // lur = Laura
  TRUETYPE_TAG('l','u','s', 0 ), // lus = Lushai
  TRUETYPE_TAG('l','u','t', 0 ), // lut = Lushootseed
  TRUETYPE_TAG('l','u','u', 0 ), // luu = Lumba-Yakkha
  TRUETYPE_TAG('l','u','v', 0 ), // luv = Luwati
  TRUETYPE_TAG('l','u','w', 0 ), // luw = Luo (Cameroon)
  TRUETYPE_TAG('l','u','y', 0 ), // luy = Luyia
  TRUETYPE_TAG('l','u','z', 0 ), // luz = Southern Luri
  TRUETYPE_TAG('l','v','a', 0 ), // lva = Maku'a
  TRUETYPE_TAG('l','v','k', 0 ), // lvk = Lavukaleve
  TRUETYPE_TAG('l','v','s', 0 ), // lvs = Standard Latvian
  TRUETYPE_TAG('l','v','u', 0 ), // lvu = Levuka
  TRUETYPE_TAG('l','w','a', 0 ), // lwa = Lwalu
  TRUETYPE_TAG('l','w','e', 0 ), // lwe = Lewo Eleng
  TRUETYPE_TAG('l','w','g', 0 ), // lwg = Wanga
  TRUETYPE_TAG('l','w','h', 0 ), // lwh = White Lachi
  TRUETYPE_TAG('l','w','l', 0 ), // lwl = Eastern Lawa
  TRUETYPE_TAG('l','w','m', 0 ), // lwm = Laomian
  TRUETYPE_TAG('l','w','o', 0 ), // lwo = Luwo
  TRUETYPE_TAG('l','w','t', 0 ), // lwt = Lewotobi
  TRUETYPE_TAG('l','w','w', 0 ), // lww = Lewo
  TRUETYPE_TAG('l','y','a', 0 ), // lya = Layakha
  TRUETYPE_TAG('l','y','g', 0 ), // lyg = Lyngngam
  TRUETYPE_TAG('l','y','n', 0 ), // lyn = Luyana
  TRUETYPE_TAG('l','z','h', 0 ), // lzh = Literary Chinese
  TRUETYPE_TAG('l','z','l', 0 ), // lzl = Litzlitz
  TRUETYPE_TAG('l','z','n', 0 ), // lzn = Leinong Naga
  TRUETYPE_TAG('l','z','z', 0 ), // lzz = Laz
  TRUETYPE_TAG('m','a','a', 0 ), // maa = San Jerónimo Tecóatl Mazatec
  TRUETYPE_TAG('m','a','b', 0 ), // mab = Yutanduchi Mixtec
  TRUETYPE_TAG('m','a','d', 0 ), // mad = Madurese
  TRUETYPE_TAG('m','a','e', 0 ), // mae = Bo-Rukul
  TRUETYPE_TAG('m','a','f', 0 ), // maf = Mafa
  TRUETYPE_TAG('m','a','g', 0 ), // mag = Magahi
  TRUETYPE_TAG('m','a','i', 0 ), // mai = Maithili
  TRUETYPE_TAG('m','a','j', 0 ), // maj = Jalapa De Díaz Mazatec
  TRUETYPE_TAG('m','a','k', 0 ), // mak = Makasar
  TRUETYPE_TAG('m','a','m', 0 ), // mam = Mam
  TRUETYPE_TAG('m','a','n', 0 ), // man = Mandingo
  TRUETYPE_TAG('m','a','p', 0 ), // map = Austronesian languages
  TRUETYPE_TAG('m','a','q', 0 ), // maq = Chiquihuitlán Mazatec
  TRUETYPE_TAG('m','a','s', 0 ), // mas = Masai
  TRUETYPE_TAG('m','a','t', 0 ), // mat = San Francisco Matlatzinca
  TRUETYPE_TAG('m','a','u', 0 ), // mau = Huautla Mazatec
  TRUETYPE_TAG('m','a','v', 0 ), // mav = Sateré-Mawé
  TRUETYPE_TAG('m','a','w', 0 ), // maw = Mampruli
  TRUETYPE_TAG('m','a','x', 0 ), // max = North Moluccan Malay
  TRUETYPE_TAG('m','a','z', 0 ), // maz = Central Mazahua
  TRUETYPE_TAG('m','b','a', 0 ), // mba = Higaonon
  TRUETYPE_TAG('m','b','b', 0 ), // mbb = Western Bukidnon Manobo
  TRUETYPE_TAG('m','b','c', 0 ), // mbc = Macushi
  TRUETYPE_TAG('m','b','d', 0 ), // mbd = Dibabawon Manobo
  TRUETYPE_TAG('m','b','e', 0 ), // mbe = Molale
  TRUETYPE_TAG('m','b','f', 0 ), // mbf = Baba Malay
  TRUETYPE_TAG('m','b','h', 0 ), // mbh = Mangseng
  TRUETYPE_TAG('m','b','i', 0 ), // mbi = Ilianen Manobo
  TRUETYPE_TAG('m','b','j', 0 ), // mbj = Nadëb
  TRUETYPE_TAG('m','b','k', 0 ), // mbk = Malol
  TRUETYPE_TAG('m','b','l', 0 ), // mbl = Maxakalí
  TRUETYPE_TAG('m','b','m', 0 ), // mbm = Ombamba
  TRUETYPE_TAG('m','b','n', 0 ), // mbn = Macaguán
  TRUETYPE_TAG('m','b','o', 0 ), // mbo = Mbo (Cameroon)
  TRUETYPE_TAG('m','b','p', 0 ), // mbp = Malayo
  TRUETYPE_TAG('m','b','q', 0 ), // mbq = Maisin
  TRUETYPE_TAG('m','b','r', 0 ), // mbr = Nukak Makú
  TRUETYPE_TAG('m','b','s', 0 ), // mbs = Sarangani Manobo
  TRUETYPE_TAG('m','b','t', 0 ), // mbt = Matigsalug Manobo
  TRUETYPE_TAG('m','b','u', 0 ), // mbu = Mbula-Bwazza
  TRUETYPE_TAG('m','b','v', 0 ), // mbv = Mbulungish
  TRUETYPE_TAG('m','b','w', 0 ), // mbw = Maring
  TRUETYPE_TAG('m','b','x', 0 ), // mbx = Mari (East Sepik Province)
  TRUETYPE_TAG('m','b','y', 0 ), // mby = Memoni
  TRUETYPE_TAG('m','b','z', 0 ), // mbz = Amoltepec Mixtec
  TRUETYPE_TAG('m','c','a', 0 ), // mca = Maca
  TRUETYPE_TAG('m','c','b', 0 ), // mcb = Machiguenga
  TRUETYPE_TAG('m','c','c', 0 ), // mcc = Bitur
  TRUETYPE_TAG('m','c','d', 0 ), // mcd = Sharanahua
  TRUETYPE_TAG('m','c','e', 0 ), // mce = Itundujia Mixtec
  TRUETYPE_TAG('m','c','f', 0 ), // mcf = Matsés
  TRUETYPE_TAG('m','c','g', 0 ), // mcg = Mapoyo
  TRUETYPE_TAG('m','c','h', 0 ), // mch = Maquiritari
  TRUETYPE_TAG('m','c','i', 0 ), // mci = Mese
  TRUETYPE_TAG('m','c','j', 0 ), // mcj = Mvanip
  TRUETYPE_TAG('m','c','k', 0 ), // mck = Mbunda
  TRUETYPE_TAG('m','c','l', 0 ), // mcl = Macaguaje
  TRUETYPE_TAG('m','c','m', 0 ), // mcm = Malaccan Creole Portuguese
  TRUETYPE_TAG('m','c','n', 0 ), // mcn = Masana
  TRUETYPE_TAG('m','c','o', 0 ), // mco = Coatlán Mixe
  TRUETYPE_TAG('m','c','p', 0 ), // mcp = Makaa
  TRUETYPE_TAG('m','c','q', 0 ), // mcq = Ese
  TRUETYPE_TAG('m','c','r', 0 ), // mcr = Menya
  TRUETYPE_TAG('m','c','s', 0 ), // mcs = Mambai
  TRUETYPE_TAG('m','c','t', 0 ), // mct = Mengisa
  TRUETYPE_TAG('m','c','u', 0 ), // mcu = Cameroon Mambila
  TRUETYPE_TAG('m','c','v', 0 ), // mcv = Minanibai
  TRUETYPE_TAG('m','c','w', 0 ), // mcw = Mawa (Chad)
  TRUETYPE_TAG('m','c','x', 0 ), // mcx = Mpiemo
  TRUETYPE_TAG('m','c','y', 0 ), // mcy = South Watut
  TRUETYPE_TAG('m','c','z', 0 ), // mcz = Mawan
  TRUETYPE_TAG('m','d','a', 0 ), // mda = Mada (Nigeria)
  TRUETYPE_TAG('m','d','b', 0 ), // mdb = Morigi
  TRUETYPE_TAG('m','d','c', 0 ), // mdc = Male (Papua New Guinea)
  TRUETYPE_TAG('m','d','d', 0 ), // mdd = Mbum
  TRUETYPE_TAG('m','d','e', 0 ), // mde = Maba (Chad)
  TRUETYPE_TAG('m','d','f', 0 ), // mdf = Moksha
  TRUETYPE_TAG('m','d','g', 0 ), // mdg = Massalat
  TRUETYPE_TAG('m','d','h', 0 ), // mdh = Maguindanaon
  TRUETYPE_TAG('m','d','i', 0 ), // mdi = Mamvu
  TRUETYPE_TAG('m','d','j', 0 ), // mdj = Mangbetu
  TRUETYPE_TAG('m','d','k', 0 ), // mdk = Mangbutu
  TRUETYPE_TAG('m','d','l', 0 ), // mdl = Maltese Sign Language
  TRUETYPE_TAG('m','d','m', 0 ), // mdm = Mayogo
  TRUETYPE_TAG('m','d','n', 0 ), // mdn = Mbati
  TRUETYPE_TAG('m','d','p', 0 ), // mdp = Mbala
  TRUETYPE_TAG('m','d','q', 0 ), // mdq = Mbole
  TRUETYPE_TAG('m','d','r', 0 ), // mdr = Mandar
  TRUETYPE_TAG('m','d','s', 0 ), // mds = Maria (Papua New Guinea)
  TRUETYPE_TAG('m','d','t', 0 ), // mdt = Mbere
  TRUETYPE_TAG('m','d','u', 0 ), // mdu = Mboko
  TRUETYPE_TAG('m','d','v', 0 ), // mdv = Santa Lucía Monteverde Mixtec
  TRUETYPE_TAG('m','d','w', 0 ), // mdw = Mbosi
  TRUETYPE_TAG('m','d','x', 0 ), // mdx = Dizin
  TRUETYPE_TAG('m','d','y', 0 ), // mdy = Male (Ethiopia)
  TRUETYPE_TAG('m','d','z', 0 ), // mdz = Suruí Do Pará
  TRUETYPE_TAG('m','e','a', 0 ), // mea = Menka
  TRUETYPE_TAG('m','e','b', 0 ), // meb = Ikobi-Mena
  TRUETYPE_TAG('m','e','c', 0 ), // mec = Mara
  TRUETYPE_TAG('m','e','d', 0 ), // med = Melpa
  TRUETYPE_TAG('m','e','e', 0 ), // mee = Mengen
  TRUETYPE_TAG('m','e','f', 0 ), // mef = Megam
  TRUETYPE_TAG('m','e','g', 0 ), // meg = Mea
  TRUETYPE_TAG('m','e','h', 0 ), // meh = Southwestern Tlaxiaco Mixtec
  TRUETYPE_TAG('m','e','i', 0 ), // mei = Midob
  TRUETYPE_TAG('m','e','j', 0 ), // mej = Meyah
  TRUETYPE_TAG('m','e','k', 0 ), // mek = Mekeo
  TRUETYPE_TAG('m','e','l', 0 ), // mel = Central Melanau
  TRUETYPE_TAG('m','e','m', 0 ), // mem = Mangala
  TRUETYPE_TAG('m','e','n', 0 ), // men = Mende (Sierra Leone)
  TRUETYPE_TAG('m','e','o', 0 ), // meo = Kedah Malay
  TRUETYPE_TAG('m','e','p', 0 ), // mep = Miriwung
  TRUETYPE_TAG('m','e','q', 0 ), // meq = Merey
  TRUETYPE_TAG('m','e','r', 0 ), // mer = Meru
  TRUETYPE_TAG('m','e','s', 0 ), // mes = Masmaje
  TRUETYPE_TAG('m','e','t', 0 ), // met = Mato
  TRUETYPE_TAG('m','e','u', 0 ), // meu = Motu
  TRUETYPE_TAG('m','e','v', 0 ), // mev = Mann
  TRUETYPE_TAG('m','e','w', 0 ), // mew = Maaka
  TRUETYPE_TAG('m','e','y', 0 ), // mey = Hassaniyya
  TRUETYPE_TAG('m','e','z', 0 ), // mez = Menominee
  TRUETYPE_TAG('m','f','a', 0 ), // mfa = Pattani Malay
  TRUETYPE_TAG('m','f','b', 0 ), // mfb = Bangka
  TRUETYPE_TAG('m','f','c', 0 ), // mfc = Mba
  TRUETYPE_TAG('m','f','d', 0 ), // mfd = Mendankwe-Nkwen
  TRUETYPE_TAG('m','f','e', 0 ), // mfe = Morisyen
  TRUETYPE_TAG('m','f','f', 0 ), // mff = Naki
  TRUETYPE_TAG('m','f','g', 0 ), // mfg = Mixifore
  TRUETYPE_TAG('m','f','h', 0 ), // mfh = Matal
  TRUETYPE_TAG('m','f','i', 0 ), // mfi = Wandala
  TRUETYPE_TAG('m','f','j', 0 ), // mfj = Mefele
  TRUETYPE_TAG('m','f','k', 0 ), // mfk = North Mofu
  TRUETYPE_TAG('m','f','l', 0 ), // mfl = Putai
  TRUETYPE_TAG('m','f','m', 0 ), // mfm = Marghi South
  TRUETYPE_TAG('m','f','n', 0 ), // mfn = Cross River Mbembe
  TRUETYPE_TAG('m','f','o', 0 ), // mfo = Mbe
  TRUETYPE_TAG('m','f','p', 0 ), // mfp = Makassar Malay
  TRUETYPE_TAG('m','f','q', 0 ), // mfq = Moba
  TRUETYPE_TAG('m','f','r', 0 ), // mfr = Marithiel
  TRUETYPE_TAG('m','f','s', 0 ), // mfs = Mexican Sign Language
  TRUETYPE_TAG('m','f','t', 0 ), // mft = Mokerang
  TRUETYPE_TAG('m','f','u', 0 ), // mfu = Mbwela
  TRUETYPE_TAG('m','f','v', 0 ), // mfv = Mandjak
  TRUETYPE_TAG('m','f','w', 0 ), // mfw = Mulaha
  TRUETYPE_TAG('m','f','x', 0 ), // mfx = Melo
  TRUETYPE_TAG('m','f','y', 0 ), // mfy = Mayo
  TRUETYPE_TAG('m','f','z', 0 ), // mfz = Mabaan
  TRUETYPE_TAG('m','g','a', 0 ), // mga = Middle Irish (900-1200)
  TRUETYPE_TAG('m','g','b', 0 ), // mgb = Mararit
  TRUETYPE_TAG('m','g','c', 0 ), // mgc = Morokodo
  TRUETYPE_TAG('m','g','d', 0 ), // mgd = Moru
  TRUETYPE_TAG('m','g','e', 0 ), // mge = Mango
  TRUETYPE_TAG('m','g','f', 0 ), // mgf = Maklew
  TRUETYPE_TAG('m','g','g', 0 ), // mgg = Mpongmpong
  TRUETYPE_TAG('m','g','h', 0 ), // mgh = Makhuwa-Meetto
  TRUETYPE_TAG('m','g','i', 0 ), // mgi = Lijili
  TRUETYPE_TAG('m','g','j', 0 ), // mgj = Abureni
  TRUETYPE_TAG('m','g','k', 0 ), // mgk = Mawes
  TRUETYPE_TAG('m','g','l', 0 ), // mgl = Maleu-Kilenge
  TRUETYPE_TAG('m','g','m', 0 ), // mgm = Mambae
  TRUETYPE_TAG('m','g','n', 0 ), // mgn = Mbangi
  TRUETYPE_TAG('m','g','o', 0 ), // mgo = Meta'
  TRUETYPE_TAG('m','g','p', 0 ), // mgp = Eastern Magar
  TRUETYPE_TAG('m','g','q', 0 ), // mgq = Malila
  TRUETYPE_TAG('m','g','r', 0 ), // mgr = Mambwe-Lungu
  TRUETYPE_TAG('m','g','s', 0 ), // mgs = Manda (Tanzania)
  TRUETYPE_TAG('m','g','t', 0 ), // mgt = Mongol
  TRUETYPE_TAG('m','g','u', 0 ), // mgu = Mailu
  TRUETYPE_TAG('m','g','v', 0 ), // mgv = Matengo
  TRUETYPE_TAG('m','g','w', 0 ), // mgw = Matumbi
  TRUETYPE_TAG('m','g','x', 0 ), // mgx = Omati
  TRUETYPE_TAG('m','g','y', 0 ), // mgy = Mbunga
  TRUETYPE_TAG('m','g','z', 0 ), // mgz = Mbugwe
  TRUETYPE_TAG('m','h','a', 0 ), // mha = Manda (India)
  TRUETYPE_TAG('m','h','b', 0 ), // mhb = Mahongwe
  TRUETYPE_TAG('m','h','c', 0 ), // mhc = Mocho
  TRUETYPE_TAG('m','h','d', 0 ), // mhd = Mbugu
  TRUETYPE_TAG('m','h','e', 0 ), // mhe = Besisi
  TRUETYPE_TAG('m','h','f', 0 ), // mhf = Mamaa
  TRUETYPE_TAG('m','h','g', 0 ), // mhg = Margu
  TRUETYPE_TAG('m','h','h', 0 ), // mhh = Maskoy Pidgin
  TRUETYPE_TAG('m','h','i', 0 ), // mhi = Ma'di
  TRUETYPE_TAG('m','h','j', 0 ), // mhj = Mogholi
  TRUETYPE_TAG('m','h','k', 0 ), // mhk = Mungaka
  TRUETYPE_TAG('m','h','l', 0 ), // mhl = Mauwake
  TRUETYPE_TAG('m','h','m', 0 ), // mhm = Makhuwa-Moniga
  TRUETYPE_TAG('m','h','n', 0 ), // mhn = Mócheno
  TRUETYPE_TAG('m','h','o', 0 ), // mho = Mashi (Zambia)
  TRUETYPE_TAG('m','h','p', 0 ), // mhp = Balinese Malay
  TRUETYPE_TAG('m','h','q', 0 ), // mhq = Mandan
  TRUETYPE_TAG('m','h','r', 0 ), // mhr = Eastern Mari
  TRUETYPE_TAG('m','h','s', 0 ), // mhs = Buru (Indonesia)
  TRUETYPE_TAG('m','h','t', 0 ), // mht = Mandahuaca
  TRUETYPE_TAG('m','h','u', 0 ), // mhu = Digaro-Mishmi
  TRUETYPE_TAG('m','h','w', 0 ), // mhw = Mbukushu
  TRUETYPE_TAG('m','h','x', 0 ), // mhx = Maru
  TRUETYPE_TAG('m','h','y', 0 ), // mhy = Ma'anyan
  TRUETYPE_TAG('m','h','z', 0 ), // mhz = Mor (Mor Islands)
  TRUETYPE_TAG('m','i','a', 0 ), // mia = Miami
  TRUETYPE_TAG('m','i','b', 0 ), // mib = Atatláhuca Mixtec
  TRUETYPE_TAG('m','i','c', 0 ), // mic = Mi'kmaq
  TRUETYPE_TAG('m','i','d', 0 ), // mid = Mandaic
  TRUETYPE_TAG('m','i','e', 0 ), // mie = Ocotepec Mixtec
  TRUETYPE_TAG('m','i','f', 0 ), // mif = Mofu-Gudur
  TRUETYPE_TAG('m','i','g', 0 ), // mig = San Miguel El Grande Mixtec
  TRUETYPE_TAG('m','i','h', 0 ), // mih = Chayuco Mixtec
  TRUETYPE_TAG('m','i','i', 0 ), // mii = Chigmecatitlán Mixtec
  TRUETYPE_TAG('m','i','j', 0 ), // mij = Abar
  TRUETYPE_TAG('m','i','k', 0 ), // mik = Mikasuki
  TRUETYPE_TAG('m','i','l', 0 ), // mil = Peñoles Mixtec
  TRUETYPE_TAG('m','i','m', 0 ), // mim = Alacatlatzala Mixtec
  TRUETYPE_TAG('m','i','n', 0 ), // min = Minangkabau
  TRUETYPE_TAG('m','i','o', 0 ), // mio = Pinotepa Nacional Mixtec
  TRUETYPE_TAG('m','i','p', 0 ), // mip = Apasco-Apoala Mixtec
  TRUETYPE_TAG('m','i','q', 0 ), // miq = Mískito
  TRUETYPE_TAG('m','i','r', 0 ), // mir = Isthmus Mixe
  TRUETYPE_TAG('m','i','s', 0 ), // mis = Uncoded languages
  TRUETYPE_TAG('m','i','t', 0 ), // mit = Southern Puebla Mixtec
  TRUETYPE_TAG('m','i','u', 0 ), // miu = Cacaloxtepec Mixtec
  TRUETYPE_TAG('m','i','w', 0 ), // miw = Akoye
  TRUETYPE_TAG('m','i','x', 0 ), // mix = Mixtepec Mixtec
  TRUETYPE_TAG('m','i','y', 0 ), // miy = Ayutla Mixtec
  TRUETYPE_TAG('m','i','z', 0 ), // miz = Coatzospan Mixtec
  TRUETYPE_TAG('m','j','a', 0 ), // mja = Mahei
  TRUETYPE_TAG('m','j','c', 0 ), // mjc = San Juan Colorado Mixtec
  TRUETYPE_TAG('m','j','d', 0 ), // mjd = Northwest Maidu
  TRUETYPE_TAG('m','j','e', 0 ), // mje = Muskum
  TRUETYPE_TAG('m','j','g', 0 ), // mjg = Tu
  TRUETYPE_TAG('m','j','h', 0 ), // mjh = Mwera (Nyasa)
  TRUETYPE_TAG('m','j','i', 0 ), // mji = Kim Mun
  TRUETYPE_TAG('m','j','j', 0 ), // mjj = Mawak
  TRUETYPE_TAG('m','j','k', 0 ), // mjk = Matukar
  TRUETYPE_TAG('m','j','l', 0 ), // mjl = Mandeali
  TRUETYPE_TAG('m','j','m', 0 ), // mjm = Medebur
  TRUETYPE_TAG('m','j','n', 0 ), // mjn = Ma (Papua New Guinea)
  TRUETYPE_TAG('m','j','o', 0 ), // mjo = Malankuravan
  TRUETYPE_TAG('m','j','p', 0 ), // mjp = Malapandaram
  TRUETYPE_TAG('m','j','q', 0 ), // mjq = Malaryan
  TRUETYPE_TAG('m','j','r', 0 ), // mjr = Malavedan
  TRUETYPE_TAG('m','j','s', 0 ), // mjs = Miship
  TRUETYPE_TAG('m','j','t', 0 ), // mjt = Sauria Paharia
  TRUETYPE_TAG('m','j','u', 0 ), // mju = Manna-Dora
  TRUETYPE_TAG('m','j','v', 0 ), // mjv = Mannan
  TRUETYPE_TAG('m','j','w', 0 ), // mjw = Karbi
  TRUETYPE_TAG('m','j','x', 0 ), // mjx = Mahali
  TRUETYPE_TAG('m','j','y', 0 ), // mjy = Mahican
  TRUETYPE_TAG('m','j','z', 0 ), // mjz = Majhi
  TRUETYPE_TAG('m','k','a', 0 ), // mka = Mbre
  TRUETYPE_TAG('m','k','b', 0 ), // mkb = Mal Paharia
  TRUETYPE_TAG('m','k','c', 0 ), // mkc = Siliput
  TRUETYPE_TAG('m','k','e', 0 ), // mke = Mawchi
  TRUETYPE_TAG('m','k','f', 0 ), // mkf = Miya
  TRUETYPE_TAG('m','k','g', 0 ), // mkg = Mak (China)
  TRUETYPE_TAG('m','k','h', 0 ), // mkh = Mon-Khmer languages
  TRUETYPE_TAG('m','k','i', 0 ), // mki = Dhatki
  TRUETYPE_TAG('m','k','j', 0 ), // mkj = Mokilese
  TRUETYPE_TAG('m','k','k', 0 ), // mkk = Byep
  TRUETYPE_TAG('m','k','l', 0 ), // mkl = Mokole
  TRUETYPE_TAG('m','k','m', 0 ), // mkm = Moklen
  TRUETYPE_TAG('m','k','n', 0 ), // mkn = Kupang Malay
  TRUETYPE_TAG('m','k','o', 0 ), // mko = Mingang Doso
  TRUETYPE_TAG('m','k','p', 0 ), // mkp = Moikodi
  TRUETYPE_TAG('m','k','q', 0 ), // mkq = Bay Miwok
  TRUETYPE_TAG('m','k','r', 0 ), // mkr = Malas
  TRUETYPE_TAG('m','k','s', 0 ), // mks = Silacayoapan Mixtec
  TRUETYPE_TAG('m','k','t', 0 ), // mkt = Vamale
  TRUETYPE_TAG('m','k','u', 0 ), // mku = Konyanka Maninka
  TRUETYPE_TAG('m','k','v', 0 ), // mkv = Mafea
  TRUETYPE_TAG('m','k','w', 0 ), // mkw = Kituba (Congo)
  TRUETYPE_TAG('m','k','x', 0 ), // mkx = Kinamiging Manobo
  TRUETYPE_TAG('m','k','y', 0 ), // mky = East Makian
  TRUETYPE_TAG('m','k','z', 0 ), // mkz = Makasae
  TRUETYPE_TAG('m','l','a', 0 ), // mla = Malo
  TRUETYPE_TAG('m','l','b', 0 ), // mlb = Mbule
  TRUETYPE_TAG('m','l','c', 0 ), // mlc = Cao Lan
  TRUETYPE_TAG('m','l','d', 0 ), // mld = Malakhel
  TRUETYPE_TAG('m','l','e', 0 ), // mle = Manambu
  TRUETYPE_TAG('m','l','f', 0 ), // mlf = Mal
  TRUETYPE_TAG('m','l','h', 0 ), // mlh = Mape
  TRUETYPE_TAG('m','l','i', 0 ), // mli = Malimpung
  TRUETYPE_TAG('m','l','j', 0 ), // mlj = Miltu
  TRUETYPE_TAG('m','l','k', 0 ), // mlk = Ilwana
  TRUETYPE_TAG('m','l','l', 0 ), // mll = Malua Bay
  TRUETYPE_TAG('m','l','m', 0 ), // mlm = Mulam
  TRUETYPE_TAG('m','l','n', 0 ), // mln = Malango
  TRUETYPE_TAG('m','l','o', 0 ), // mlo = Mlomp
  TRUETYPE_TAG('m','l','p', 0 ), // mlp = Bargam
  TRUETYPE_TAG('m','l','q', 0 ), // mlq = Western Maninkakan
  TRUETYPE_TAG('m','l','r', 0 ), // mlr = Vame
  TRUETYPE_TAG('m','l','s', 0 ), // mls = Masalit
  TRUETYPE_TAG('m','l','u', 0 ), // mlu = To'abaita
  TRUETYPE_TAG('m','l','v', 0 ), // mlv = Motlav
  TRUETYPE_TAG('m','l','w', 0 ), // mlw = Moloko
  TRUETYPE_TAG('m','l','x', 0 ), // mlx = Malfaxal
  TRUETYPE_TAG('m','l','z', 0 ), // mlz = Malaynon
  TRUETYPE_TAG('m','m','a', 0 ), // mma = Mama
  TRUETYPE_TAG('m','m','b', 0 ), // mmb = Momina
  TRUETYPE_TAG('m','m','c', 0 ), // mmc = Michoacán Mazahua
  TRUETYPE_TAG('m','m','d', 0 ), // mmd = Maonan
  TRUETYPE_TAG('m','m','e', 0 ), // mme = Mae
  TRUETYPE_TAG('m','m','f', 0 ), // mmf = Mundat
  TRUETYPE_TAG('m','m','g', 0 ), // mmg = North Ambrym
  TRUETYPE_TAG('m','m','h', 0 ), // mmh = Mehináku
  TRUETYPE_TAG('m','m','i', 0 ), // mmi = Musar
  TRUETYPE_TAG('m','m','j', 0 ), // mmj = Majhwar
  TRUETYPE_TAG('m','m','k', 0 ), // mmk = Mukha-Dora
  TRUETYPE_TAG('m','m','l', 0 ), // mml = Man Met
  TRUETYPE_TAG('m','m','m', 0 ), // mmm = Maii
  TRUETYPE_TAG('m','m','n', 0 ), // mmn = Mamanwa
  TRUETYPE_TAG('m','m','o', 0 ), // mmo = Mangga Buang
  TRUETYPE_TAG('m','m','p', 0 ), // mmp = Siawi
  TRUETYPE_TAG('m','m','q', 0 ), // mmq = Musak
  TRUETYPE_TAG('m','m','r', 0 ), // mmr = Western Xiangxi Miao
  TRUETYPE_TAG('m','m','t', 0 ), // mmt = Malalamai
  TRUETYPE_TAG('m','m','u', 0 ), // mmu = Mmaala
  TRUETYPE_TAG('m','m','v', 0 ), // mmv = Miriti
  TRUETYPE_TAG('m','m','w', 0 ), // mmw = Emae
  TRUETYPE_TAG('m','m','x', 0 ), // mmx = Madak
  TRUETYPE_TAG('m','m','y', 0 ), // mmy = Migaama
  TRUETYPE_TAG('m','m','z', 0 ), // mmz = Mabaale
  TRUETYPE_TAG('m','n','a', 0 ), // mna = Mbula
  TRUETYPE_TAG('m','n','b', 0 ), // mnb = Muna
  TRUETYPE_TAG('m','n','c', 0 ), // mnc = Manchu
  TRUETYPE_TAG('m','n','d', 0 ), // mnd = Mondé
  TRUETYPE_TAG('m','n','e', 0 ), // mne = Naba
  TRUETYPE_TAG('m','n','f', 0 ), // mnf = Mundani
  TRUETYPE_TAG('m','n','g', 0 ), // mng = Eastern Mnong
  TRUETYPE_TAG('m','n','h', 0 ), // mnh = Mono (Democratic Republic of Congo)
  TRUETYPE_TAG('m','n','i', 0 ), // mni = Manipuri
  TRUETYPE_TAG('m','n','j', 0 ), // mnj = Munji
  TRUETYPE_TAG('m','n','k', 0 ), // mnk = Mandinka
  TRUETYPE_TAG('m','n','l', 0 ), // mnl = Tiale
  TRUETYPE_TAG('m','n','m', 0 ), // mnm = Mapena
  TRUETYPE_TAG('m','n','n', 0 ), // mnn = Southern Mnong
  TRUETYPE_TAG('m','n','o', 0 ), // mno = Manobo languages
  TRUETYPE_TAG('m','n','p', 0 ), // mnp = Min Bei Chinese
  TRUETYPE_TAG('m','n','q', 0 ), // mnq = Minriq
  TRUETYPE_TAG('m','n','r', 0 ), // mnr = Mono (USA)
  TRUETYPE_TAG('m','n','s', 0 ), // mns = Mansi
  TRUETYPE_TAG('m','n','t', 0 ), // mnt = Maykulan
  TRUETYPE_TAG('m','n','u', 0 ), // mnu = Mer
  TRUETYPE_TAG('m','n','v', 0 ), // mnv = Rennell-Bellona
  TRUETYPE_TAG('m','n','w', 0 ), // mnw = Mon
  TRUETYPE_TAG('m','n','x', 0 ), // mnx = Manikion
  TRUETYPE_TAG('m','n','y', 0 ), // mny = Manyawa
  TRUETYPE_TAG('m','n','z', 0 ), // mnz = Moni
  TRUETYPE_TAG('m','o','a', 0 ), // moa = Mwan
  TRUETYPE_TAG('m','o','c', 0 ), // moc = Mocoví
  TRUETYPE_TAG('m','o','d', 0 ), // mod = Mobilian
  TRUETYPE_TAG('m','o','e', 0 ), // moe = Montagnais
  TRUETYPE_TAG('m','o','f', 0 ), // mof = Mohegan-Montauk-Narragansett
  TRUETYPE_TAG('m','o','g', 0 ), // mog = Mongondow
  TRUETYPE_TAG('m','o','h', 0 ), // moh = Mohawk
  TRUETYPE_TAG('m','o','i', 0 ), // moi = Mboi
  TRUETYPE_TAG('m','o','j', 0 ), // moj = Monzombo
  TRUETYPE_TAG('m','o','k', 0 ), // mok = Morori
  TRUETYPE_TAG('m','o','m', 0 ), // mom = Mangue
  TRUETYPE_TAG('m','o','o', 0 ), // moo = Monom
  TRUETYPE_TAG('m','o','p', 0 ), // mop = Mopán Maya
  TRUETYPE_TAG('m','o','q', 0 ), // moq = Mor (Bomberai Peninsula)
  TRUETYPE_TAG('m','o','r', 0 ), // mor = Moro
  TRUETYPE_TAG('m','o','s', 0 ), // mos = Mossi
  TRUETYPE_TAG('m','o','t', 0 ), // mot = Barí
  TRUETYPE_TAG('m','o','u', 0 ), // mou = Mogum
  TRUETYPE_TAG('m','o','v', 0 ), // mov = Mohave
  TRUETYPE_TAG('m','o','w', 0 ), // mow = Moi (Congo)
  TRUETYPE_TAG('m','o','x', 0 ), // mox = Molima
  TRUETYPE_TAG('m','o','y', 0 ), // moy = Shekkacho
  TRUETYPE_TAG('m','o','z', 0 ), // moz = Mukulu
  TRUETYPE_TAG('m','p','a', 0 ), // mpa = Mpoto
  TRUETYPE_TAG('m','p','b', 0 ), // mpb = Mullukmulluk
  TRUETYPE_TAG('m','p','c', 0 ), // mpc = Mangarayi
  TRUETYPE_TAG('m','p','d', 0 ), // mpd = Machinere
  TRUETYPE_TAG('m','p','e', 0 ), // mpe = Majang
  TRUETYPE_TAG('m','p','g', 0 ), // mpg = Marba
  TRUETYPE_TAG('m','p','h', 0 ), // mph = Maung
  TRUETYPE_TAG('m','p','i', 0 ), // mpi = Mpade
  TRUETYPE_TAG('m','p','j', 0 ), // mpj = Martu Wangka
  TRUETYPE_TAG('m','p','k', 0 ), // mpk = Mbara (Chad)
  TRUETYPE_TAG('m','p','l', 0 ), // mpl = Middle Watut
  TRUETYPE_TAG('m','p','m', 0 ), // mpm = Yosondúa Mixtec
  TRUETYPE_TAG('m','p','n', 0 ), // mpn = Mindiri
  TRUETYPE_TAG('m','p','o', 0 ), // mpo = Miu
  TRUETYPE_TAG('m','p','p', 0 ), // mpp = Migabac
  TRUETYPE_TAG('m','p','q', 0 ), // mpq = Matís
  TRUETYPE_TAG('m','p','r', 0 ), // mpr = Vangunu
  TRUETYPE_TAG('m','p','s', 0 ), // mps = Dadibi
  TRUETYPE_TAG('m','p','t', 0 ), // mpt = Mian
  TRUETYPE_TAG('m','p','u', 0 ), // mpu = Makuráp
  TRUETYPE_TAG('m','p','v', 0 ), // mpv = Mungkip
  TRUETYPE_TAG('m','p','w', 0 ), // mpw = Mapidian
  TRUETYPE_TAG('m','p','x', 0 ), // mpx = Misima-Paneati
  TRUETYPE_TAG('m','p','y', 0 ), // mpy = Mapia
  TRUETYPE_TAG('m','p','z', 0 ), // mpz = Mpi
  TRUETYPE_TAG('m','q','a', 0 ), // mqa = Maba (Indonesia)
  TRUETYPE_TAG('m','q','b', 0 ), // mqb = Mbuko
  TRUETYPE_TAG('m','q','c', 0 ), // mqc = Mangole
  TRUETYPE_TAG('m','q','e', 0 ), // mqe = Matepi
  TRUETYPE_TAG('m','q','f', 0 ), // mqf = Momuna
  TRUETYPE_TAG('m','q','g', 0 ), // mqg = Kota Bangun Kutai Malay
  TRUETYPE_TAG('m','q','h', 0 ), // mqh = Tlazoyaltepec Mixtec
  TRUETYPE_TAG('m','q','i', 0 ), // mqi = Mariri
  TRUETYPE_TAG('m','q','j', 0 ), // mqj = Mamasa
  TRUETYPE_TAG('m','q','k', 0 ), // mqk = Rajah Kabunsuwan Manobo
  TRUETYPE_TAG('m','q','l', 0 ), // mql = Mbelime
  TRUETYPE_TAG('m','q','m', 0 ), // mqm = South Marquesan
  TRUETYPE_TAG('m','q','n', 0 ), // mqn = Moronene
  TRUETYPE_TAG('m','q','o', 0 ), // mqo = Modole
  TRUETYPE_TAG('m','q','p', 0 ), // mqp = Manipa
  TRUETYPE_TAG('m','q','q', 0 ), // mqq = Minokok
  TRUETYPE_TAG('m','q','r', 0 ), // mqr = Mander
  TRUETYPE_TAG('m','q','s', 0 ), // mqs = West Makian
  TRUETYPE_TAG('m','q','t', 0 ), // mqt = Mok
  TRUETYPE_TAG('m','q','u', 0 ), // mqu = Mandari
  TRUETYPE_TAG('m','q','v', 0 ), // mqv = Mosimo
  TRUETYPE_TAG('m','q','w', 0 ), // mqw = Murupi
  TRUETYPE_TAG('m','q','x', 0 ), // mqx = Mamuju
  TRUETYPE_TAG('m','q','y', 0 ), // mqy = Manggarai
  TRUETYPE_TAG('m','q','z', 0 ), // mqz = Malasanga
  TRUETYPE_TAG('m','r','a', 0 ), // mra = Mlabri
  TRUETYPE_TAG('m','r','b', 0 ), // mrb = Marino
  TRUETYPE_TAG('m','r','c', 0 ), // mrc = Maricopa
  TRUETYPE_TAG('m','r','d', 0 ), // mrd = Western Magar
  TRUETYPE_TAG('m','r','e', 0 ), // mre = Martha's Vineyard Sign Language
  TRUETYPE_TAG('m','r','f', 0 ), // mrf = Elseng
  TRUETYPE_TAG('m','r','g', 0 ), // mrg = Mising
  TRUETYPE_TAG('m','r','h', 0 ), // mrh = Mara Chin
  TRUETYPE_TAG('m','r','j', 0 ), // mrj = Western Mari
  TRUETYPE_TAG('m','r','k', 0 ), // mrk = Hmwaveke
  TRUETYPE_TAG('m','r','l', 0 ), // mrl = Mortlockese
  TRUETYPE_TAG('m','r','m', 0 ), // mrm = Merlav
  TRUETYPE_TAG('m','r','n', 0 ), // mrn = Cheke Holo
  TRUETYPE_TAG('m','r','o', 0 ), // mro = Mru
  TRUETYPE_TAG('m','r','p', 0 ), // mrp = Morouas
  TRUETYPE_TAG('m','r','q', 0 ), // mrq = North Marquesan
  TRUETYPE_TAG('m','r','r', 0 ), // mrr = Maria (India)
  TRUETYPE_TAG('m','r','s', 0 ), // mrs = Maragus
  TRUETYPE_TAG('m','r','t', 0 ), // mrt = Marghi Central
  TRUETYPE_TAG('m','r','u', 0 ), // mru = Mono (Cameroon)
  TRUETYPE_TAG('m','r','v', 0 ), // mrv = Mangareva
  TRUETYPE_TAG('m','r','w', 0 ), // mrw = Maranao
  TRUETYPE_TAG('m','r','x', 0 ), // mrx = Maremgi
  TRUETYPE_TAG('m','r','y', 0 ), // mry = Mandaya
  TRUETYPE_TAG('m','r','z', 0 ), // mrz = Marind
  TRUETYPE_TAG('m','s','b', 0 ), // msb = Masbatenyo
  TRUETYPE_TAG('m','s','c', 0 ), // msc = Sankaran Maninka
  TRUETYPE_TAG('m','s','d', 0 ), // msd = Yucatec Maya Sign Language
  TRUETYPE_TAG('m','s','e', 0 ), // mse = Musey
  TRUETYPE_TAG('m','s','f', 0 ), // msf = Mekwei
  TRUETYPE_TAG('m','s','g', 0 ), // msg = Moraid
  TRUETYPE_TAG('m','s','h', 0 ), // msh = Masikoro Malagasy
  TRUETYPE_TAG('m','s','i', 0 ), // msi = Sabah Malay
  TRUETYPE_TAG('m','s','j', 0 ), // msj = Ma (Democratic Republic of Congo)
  TRUETYPE_TAG('m','s','k', 0 ), // msk = Mansaka
  TRUETYPE_TAG('m','s','l', 0 ), // msl = Molof
  TRUETYPE_TAG('m','s','m', 0 ), // msm = Agusan Manobo
  TRUETYPE_TAG('m','s','n', 0 ), // msn = Vurës
  TRUETYPE_TAG('m','s','o', 0 ), // mso = Mombum
  TRUETYPE_TAG('m','s','p', 0 ), // msp = Maritsauá
  TRUETYPE_TAG('m','s','q', 0 ), // msq = Caac
  TRUETYPE_TAG('m','s','r', 0 ), // msr = Mongolian Sign Language
  TRUETYPE_TAG('m','s','s', 0 ), // mss = West Masela
  TRUETYPE_TAG('m','s','t', 0 ), // mst = Cataelano Mandaya
  TRUETYPE_TAG('m','s','u', 0 ), // msu = Musom
  TRUETYPE_TAG('m','s','v', 0 ), // msv = Maslam
  TRUETYPE_TAG('m','s','w', 0 ), // msw = Mansoanka
  TRUETYPE_TAG('m','s','x', 0 ), // msx = Moresada
  TRUETYPE_TAG('m','s','y', 0 ), // msy = Aruamu
  TRUETYPE_TAG('m','s','z', 0 ), // msz = Momare
  TRUETYPE_TAG('m','t','a', 0 ), // mta = Cotabato Manobo
  TRUETYPE_TAG('m','t','b', 0 ), // mtb = Anyin Morofo
  TRUETYPE_TAG('m','t','c', 0 ), // mtc = Munit
  TRUETYPE_TAG('m','t','d', 0 ), // mtd = Mualang
  TRUETYPE_TAG('m','t','e', 0 ), // mte = Mono (Solomon Islands)
  TRUETYPE_TAG('m','t','f', 0 ), // mtf = Murik (Papua New Guinea)
  TRUETYPE_TAG('m','t','g', 0 ), // mtg = Una
  TRUETYPE_TAG('m','t','h', 0 ), // mth = Munggui
  TRUETYPE_TAG('m','t','i', 0 ), // mti = Maiwa (Papua New Guinea)
  TRUETYPE_TAG('m','t','j', 0 ), // mtj = Moskona
  TRUETYPE_TAG('m','t','k', 0 ), // mtk = Mbe'
  TRUETYPE_TAG('m','t','l', 0 ), // mtl = Montol
  TRUETYPE_TAG('m','t','m', 0 ), // mtm = Mator
  TRUETYPE_TAG('m','t','n', 0 ), // mtn = Matagalpa
  TRUETYPE_TAG('m','t','o', 0 ), // mto = Totontepec Mixe
  TRUETYPE_TAG('m','t','p', 0 ), // mtp = Wichí Lhamtés Nocten
  TRUETYPE_TAG('m','t','q', 0 ), // mtq = Muong
  TRUETYPE_TAG('m','t','r', 0 ), // mtr = Mewari
  TRUETYPE_TAG('m','t','s', 0 ), // mts = Yora
  TRUETYPE_TAG('m','t','t', 0 ), // mtt = Mota
  TRUETYPE_TAG('m','t','u', 0 ), // mtu = Tututepec Mixtec
  TRUETYPE_TAG('m','t','v', 0 ), // mtv = Asaro'o
  TRUETYPE_TAG('m','t','w', 0 ), // mtw = Southern Binukidnon
  TRUETYPE_TAG('m','t','x', 0 ), // mtx = Tidaá Mixtec
  TRUETYPE_TAG('m','t','y', 0 ), // mty = Nabi
  TRUETYPE_TAG('m','u','a', 0 ), // mua = Mundang
  TRUETYPE_TAG('m','u','b', 0 ), // mub = Mubi
  TRUETYPE_TAG('m','u','c', 0 ), // muc = Mbu'
  TRUETYPE_TAG('m','u','d', 0 ), // mud = Mednyj Aleut
  TRUETYPE_TAG('m','u','e', 0 ), // mue = Media Lengua
  TRUETYPE_TAG('m','u','g', 0 ), // mug = Musgu
  TRUETYPE_TAG('m','u','h', 0 ), // muh = Mündü
  TRUETYPE_TAG('m','u','i', 0 ), // mui = Musi
  TRUETYPE_TAG('m','u','j', 0 ), // muj = Mabire
  TRUETYPE_TAG('m','u','k', 0 ), // muk = Mugom
  TRUETYPE_TAG('m','u','l', 0 ), // mul = Multiple languages
  TRUETYPE_TAG('m','u','m', 0 ), // mum = Maiwala
  TRUETYPE_TAG('m','u','n', 0 ), // mun = Munda languages
  TRUETYPE_TAG('m','u','o', 0 ), // muo = Nyong
  TRUETYPE_TAG('m','u','p', 0 ), // mup = Malvi
  TRUETYPE_TAG('m','u','q', 0 ), // muq = Eastern Xiangxi Miao
  TRUETYPE_TAG('m','u','r', 0 ), // mur = Murle
  TRUETYPE_TAG('m','u','s', 0 ), // mus = Creek
  TRUETYPE_TAG('m','u','t', 0 ), // mut = Western Muria
  TRUETYPE_TAG('m','u','u', 0 ), // muu = Yaaku
  TRUETYPE_TAG('m','u','v', 0 ), // muv = Muthuvan
  TRUETYPE_TAG('m','u','x', 0 ), // mux = Bo-Ung
  TRUETYPE_TAG('m','u','y', 0 ), // muy = Muyang
  TRUETYPE_TAG('m','u','z', 0 ), // muz = Mursi
  TRUETYPE_TAG('m','v','a', 0 ), // mva = Manam
  TRUETYPE_TAG('m','v','b', 0 ), // mvb = Mattole
  TRUETYPE_TAG('m','v','d', 0 ), // mvd = Mamboru
  TRUETYPE_TAG('m','v','e', 0 ), // mve = Marwari (Pakistan)
  TRUETYPE_TAG('m','v','f', 0 ), // mvf = Peripheral Mongolian
  TRUETYPE_TAG('m','v','g', 0 ), // mvg = Yucuañe Mixtec
  TRUETYPE_TAG('m','v','h', 0 ), // mvh = Mire
  TRUETYPE_TAG('m','v','i', 0 ), // mvi = Miyako
  TRUETYPE_TAG('m','v','k', 0 ), // mvk = Mekmek
  TRUETYPE_TAG('m','v','l', 0 ), // mvl = Mbara (Australia)
  TRUETYPE_TAG('m','v','m', 0 ), // mvm = Muya
  TRUETYPE_TAG('m','v','n', 0 ), // mvn = Minaveha
  TRUETYPE_TAG('m','v','o', 0 ), // mvo = Marovo
  TRUETYPE_TAG('m','v','p', 0 ), // mvp = Duri
  TRUETYPE_TAG('m','v','q', 0 ), // mvq = Moere
  TRUETYPE_TAG('m','v','r', 0 ), // mvr = Marau
  TRUETYPE_TAG('m','v','s', 0 ), // mvs = Massep
  TRUETYPE_TAG('m','v','t', 0 ), // mvt = Mpotovoro
  TRUETYPE_TAG('m','v','u', 0 ), // mvu = Marfa
  TRUETYPE_TAG('m','v','v', 0 ), // mvv = Tagal Murut
  TRUETYPE_TAG('m','v','w', 0 ), // mvw = Machinga
  TRUETYPE_TAG('m','v','x', 0 ), // mvx = Meoswar
  TRUETYPE_TAG('m','v','y', 0 ), // mvy = Indus Kohistani
  TRUETYPE_TAG('m','v','z', 0 ), // mvz = Mesqan
  TRUETYPE_TAG('m','w','a', 0 ), // mwa = Mwatebu
  TRUETYPE_TAG('m','w','b', 0 ), // mwb = Juwal
  TRUETYPE_TAG('m','w','c', 0 ), // mwc = Are
  TRUETYPE_TAG('m','w','d', 0 ), // mwd = Mudbura
  TRUETYPE_TAG('m','w','e', 0 ), // mwe = Mwera (Chimwera)
  TRUETYPE_TAG('m','w','f', 0 ), // mwf = Murrinh-Patha
  TRUETYPE_TAG('m','w','g', 0 ), // mwg = Aiklep
  TRUETYPE_TAG('m','w','h', 0 ), // mwh = Mouk-Aria
  TRUETYPE_TAG('m','w','i', 0 ), // mwi = Labo
  TRUETYPE_TAG('m','w','j', 0 ), // mwj = Maligo
  TRUETYPE_TAG('m','w','k', 0 ), // mwk = Kita Maninkakan
  TRUETYPE_TAG('m','w','l', 0 ), // mwl = Mirandese
  TRUETYPE_TAG('m','w','m', 0 ), // mwm = Sar
  TRUETYPE_TAG('m','w','n', 0 ), // mwn = Nyamwanga
  TRUETYPE_TAG('m','w','o', 0 ), // mwo = Central Maewo
  TRUETYPE_TAG('m','w','p', 0 ), // mwp = Kala Lagaw Ya
  TRUETYPE_TAG('m','w','q', 0 ), // mwq = Mün Chin
  TRUETYPE_TAG('m','w','r', 0 ), // mwr = Marwari
  TRUETYPE_TAG('m','w','s', 0 ), // mws = Mwimbi-Muthambi
  TRUETYPE_TAG('m','w','t', 0 ), // mwt = Moken
  TRUETYPE_TAG('m','w','u', 0 ), // mwu = Mittu
  TRUETYPE_TAG('m','w','v', 0 ), // mwv = Mentawai
  TRUETYPE_TAG('m','w','w', 0 ), // mww = Hmong Daw
  TRUETYPE_TAG('m','w','x', 0 ), // mwx = Mediak
  TRUETYPE_TAG('m','w','y', 0 ), // mwy = Mosiro
  TRUETYPE_TAG('m','w','z', 0 ), // mwz = Moingi
  TRUETYPE_TAG('m','x','a', 0 ), // mxa = Northwest Oaxaca Mixtec
  TRUETYPE_TAG('m','x','b', 0 ), // mxb = Tezoatlán Mixtec
  TRUETYPE_TAG('m','x','c', 0 ), // mxc = Manyika
  TRUETYPE_TAG('m','x','d', 0 ), // mxd = Modang
  TRUETYPE_TAG('m','x','e', 0 ), // mxe = Mele-Fila
  TRUETYPE_TAG('m','x','f', 0 ), // mxf = Malgbe
  TRUETYPE_TAG('m','x','g', 0 ), // mxg = Mbangala
  TRUETYPE_TAG('m','x','h', 0 ), // mxh = Mvuba
  TRUETYPE_TAG('m','x','i', 0 ), // mxi = Mozarabic
  TRUETYPE_TAG('m','x','j', 0 ), // mxj = Miju-Mishmi
  TRUETYPE_TAG('m','x','k', 0 ), // mxk = Monumbo
  TRUETYPE_TAG('m','x','l', 0 ), // mxl = Maxi Gbe
  TRUETYPE_TAG('m','x','m', 0 ), // mxm = Meramera
  TRUETYPE_TAG('m','x','n', 0 ), // mxn = Moi (Indonesia)
  TRUETYPE_TAG('m','x','o', 0 ), // mxo = Mbowe
  TRUETYPE_TAG('m','x','p', 0 ), // mxp = Tlahuitoltepec Mixe
  TRUETYPE_TAG('m','x','q', 0 ), // mxq = Juquila Mixe
  TRUETYPE_TAG('m','x','r', 0 ), // mxr = Murik (Malaysia)
  TRUETYPE_TAG('m','x','s', 0 ), // mxs = Huitepec Mixtec
  TRUETYPE_TAG('m','x','t', 0 ), // mxt = Jamiltepec Mixtec
  TRUETYPE_TAG('m','x','u', 0 ), // mxu = Mada (Cameroon)
  TRUETYPE_TAG('m','x','v', 0 ), // mxv = Metlatónoc Mixtec
  TRUETYPE_TAG('m','x','w', 0 ), // mxw = Namo
  TRUETYPE_TAG('m','x','x', 0 ), // mxx = Mahou
  TRUETYPE_TAG('m','x','y', 0 ), // mxy = Southeastern Nochixtlán Mixtec
  TRUETYPE_TAG('m','x','z', 0 ), // mxz = Central Masela
  TRUETYPE_TAG('m','y','b', 0 ), // myb = Mbay
  TRUETYPE_TAG('m','y','c', 0 ), // myc = Mayeka
  TRUETYPE_TAG('m','y','d', 0 ), // myd = Maramba
  TRUETYPE_TAG('m','y','e', 0 ), // mye = Myene
  TRUETYPE_TAG('m','y','f', 0 ), // myf = Bambassi
  TRUETYPE_TAG('m','y','g', 0 ), // myg = Manta
  TRUETYPE_TAG('m','y','h', 0 ), // myh = Makah
  TRUETYPE_TAG('m','y','i', 0 ), // myi = Mina (India)
  TRUETYPE_TAG('m','y','j', 0 ), // myj = Mangayat
  TRUETYPE_TAG('m','y','k', 0 ), // myk = Mamara Senoufo
  TRUETYPE_TAG('m','y','l', 0 ), // myl = Moma
  TRUETYPE_TAG('m','y','m', 0 ), // mym = Me'en
  TRUETYPE_TAG('m','y','n', 0 ), // myn = Mayan languages
  TRUETYPE_TAG('m','y','o', 0 ), // myo = Anfillo
  TRUETYPE_TAG('m','y','p', 0 ), // myp = Pirahã
  TRUETYPE_TAG('m','y','q', 0 ), // myq = Forest Maninka
  TRUETYPE_TAG('m','y','r', 0 ), // myr = Muniche
  TRUETYPE_TAG('m','y','s', 0 ), // mys = Mesmes
  TRUETYPE_TAG('m','y','t', 0 ), // myt = Sangab Mandaya
  TRUETYPE_TAG('m','y','u', 0 ), // myu = Mundurukú
  TRUETYPE_TAG('m','y','v', 0 ), // myv = Erzya
  TRUETYPE_TAG('m','y','w', 0 ), // myw = Muyuw
  TRUETYPE_TAG('m','y','x', 0 ), // myx = Masaaba
  TRUETYPE_TAG('m','y','y', 0 ), // myy = Macuna
  TRUETYPE_TAG('m','y','z', 0 ), // myz = Classical Mandaic
  TRUETYPE_TAG('m','z','a', 0 ), // mza = Santa María Zacatepec Mixtec
  TRUETYPE_TAG('m','z','b', 0 ), // mzb = Tumzabt
  TRUETYPE_TAG('m','z','c', 0 ), // mzc = Madagascar Sign Language
  TRUETYPE_TAG('m','z','d', 0 ), // mzd = Malimba
  TRUETYPE_TAG('m','z','e', 0 ), // mze = Morawa
  TRUETYPE_TAG('m','z','g', 0 ), // mzg = Monastic Sign Language
  TRUETYPE_TAG('m','z','h', 0 ), // mzh = Wichí Lhamtés Güisnay
  TRUETYPE_TAG('m','z','i', 0 ), // mzi = Ixcatlán Mazatec
  TRUETYPE_TAG('m','z','j', 0 ), // mzj = Manya
  TRUETYPE_TAG('m','z','k', 0 ), // mzk = Nigeria Mambila
  TRUETYPE_TAG('m','z','l', 0 ), // mzl = Mazatlán Mixe
  TRUETYPE_TAG('m','z','m', 0 ), // mzm = Mumuye
  TRUETYPE_TAG('m','z','n', 0 ), // mzn = Mazanderani
  TRUETYPE_TAG('m','z','o', 0 ), // mzo = Matipuhy
  TRUETYPE_TAG('m','z','p', 0 ), // mzp = Movima
  TRUETYPE_TAG('m','z','q', 0 ), // mzq = Mori Atas
  TRUETYPE_TAG('m','z','r', 0 ), // mzr = Marúbo
  TRUETYPE_TAG('m','z','s', 0 ), // mzs = Macanese
  TRUETYPE_TAG('m','z','t', 0 ), // mzt = Mintil
  TRUETYPE_TAG('m','z','u', 0 ), // mzu = Inapang
  TRUETYPE_TAG('m','z','v', 0 ), // mzv = Manza
  TRUETYPE_TAG('m','z','w', 0 ), // mzw = Deg
  TRUETYPE_TAG('m','z','x', 0 ), // mzx = Mawayana
  TRUETYPE_TAG('m','z','y', 0 ), // mzy = Mozambican Sign Language
  TRUETYPE_TAG('m','z','z', 0 ), // mzz = Maiadomu
  TRUETYPE_TAG('n','a','a', 0 ), // naa = Namla
  TRUETYPE_TAG('n','a','b', 0 ), // nab = Southern Nambikuára
  TRUETYPE_TAG('n','a','c', 0 ), // nac = Narak
  TRUETYPE_TAG('n','a','d', 0 ), // nad = Nijadali
  TRUETYPE_TAG('n','a','e', 0 ), // nae = Naka'ela
  TRUETYPE_TAG('n','a','f', 0 ), // naf = Nabak
  TRUETYPE_TAG('n','a','g', 0 ), // nag = Naga Pidgin
  TRUETYPE_TAG('n','a','h', 0 ), // nah = Nahuatl languages
  TRUETYPE_TAG('n','a','i', 0 ), // nai = North American Indian languages
  TRUETYPE_TAG('n','a','j', 0 ), // naj = Nalu
  TRUETYPE_TAG('n','a','k', 0 ), // nak = Nakanai
  TRUETYPE_TAG('n','a','l', 0 ), // nal = Nalik
  TRUETYPE_TAG('n','a','m', 0 ), // nam = Nangikurrunggurr
  TRUETYPE_TAG('n','a','n', 0 ), // nan = Min Nan Chinese
  TRUETYPE_TAG('n','a','o', 0 ), // nao = Naaba
  TRUETYPE_TAG('n','a','p', 0 ), // nap = Neapolitan
  TRUETYPE_TAG('n','a','q', 0 ), // naq = Nama (Namibia)
  TRUETYPE_TAG('n','a','r', 0 ), // nar = Iguta
  TRUETYPE_TAG('n','a','s', 0 ), // nas = Naasioi
  TRUETYPE_TAG('n','a','t', 0 ), // nat = Hungworo
  TRUETYPE_TAG('n','a','w', 0 ), // naw = Nawuri
  TRUETYPE_TAG('n','a','x', 0 ), // nax = Nakwi
  TRUETYPE_TAG('n','a','y', 0 ), // nay = Narrinyeri
  TRUETYPE_TAG('n','a','z', 0 ), // naz = Coatepec Nahuatl
  TRUETYPE_TAG('n','b','a', 0 ), // nba = Nyemba
  TRUETYPE_TAG('n','b','b', 0 ), // nbb = Ndoe
  TRUETYPE_TAG('n','b','c', 0 ), // nbc = Chang Naga
  TRUETYPE_TAG('n','b','d', 0 ), // nbd = Ngbinda
  TRUETYPE_TAG('n','b','e', 0 ), // nbe = Konyak Naga
  TRUETYPE_TAG('n','b','f', 0 ), // nbf = Naxi
  TRUETYPE_TAG('n','b','g', 0 ), // nbg = Nagarchal
  TRUETYPE_TAG('n','b','h', 0 ), // nbh = Ngamo
  TRUETYPE_TAG('n','b','i', 0 ), // nbi = Mao Naga
  TRUETYPE_TAG('n','b','j', 0 ), // nbj = Ngarinman
  TRUETYPE_TAG('n','b','k', 0 ), // nbk = Nake
  TRUETYPE_TAG('n','b','m', 0 ), // nbm = Ngbaka Ma'bo
  TRUETYPE_TAG('n','b','n', 0 ), // nbn = Kuri
  TRUETYPE_TAG('n','b','o', 0 ), // nbo = Nkukoli
  TRUETYPE_TAG('n','b','p', 0 ), // nbp = Nnam
  TRUETYPE_TAG('n','b','q', 0 ), // nbq = Nggem
  TRUETYPE_TAG('n','b','r', 0 ), // nbr = Numana-Nunku-Gbantu-Numbu
  TRUETYPE_TAG('n','b','s', 0 ), // nbs = Namibian Sign Language
  TRUETYPE_TAG('n','b','t', 0 ), // nbt = Na
  TRUETYPE_TAG('n','b','u', 0 ), // nbu = Rongmei Naga
  TRUETYPE_TAG('n','b','v', 0 ), // nbv = Ngamambo
  TRUETYPE_TAG('n','b','w', 0 ), // nbw = Southern Ngbandi
  TRUETYPE_TAG('n','b','x', 0 ), // nbx = Ngura
  TRUETYPE_TAG('n','b','y', 0 ), // nby = Ningera
  TRUETYPE_TAG('n','c','a', 0 ), // nca = Iyo
  TRUETYPE_TAG('n','c','b', 0 ), // ncb = Central Nicobarese
  TRUETYPE_TAG('n','c','c', 0 ), // ncc = Ponam
  TRUETYPE_TAG('n','c','d', 0 ), // ncd = Nachering
  TRUETYPE_TAG('n','c','e', 0 ), // nce = Yale
  TRUETYPE_TAG('n','c','f', 0 ), // ncf = Notsi
  TRUETYPE_TAG('n','c','g', 0 ), // ncg = Nisga'a
  TRUETYPE_TAG('n','c','h', 0 ), // nch = Central Huasteca Nahuatl
  TRUETYPE_TAG('n','c','i', 0 ), // nci = Classical Nahuatl
  TRUETYPE_TAG('n','c','j', 0 ), // ncj = Northern Puebla Nahuatl
  TRUETYPE_TAG('n','c','k', 0 ), // nck = Nakara
  TRUETYPE_TAG('n','c','l', 0 ), // ncl = Michoacán Nahuatl
  TRUETYPE_TAG('n','c','m', 0 ), // ncm = Nambo
  TRUETYPE_TAG('n','c','n', 0 ), // ncn = Nauna
  TRUETYPE_TAG('n','c','o', 0 ), // nco = Sibe
  TRUETYPE_TAG('n','c','p', 0 ), // ncp = Ndaktup
  TRUETYPE_TAG('n','c','r', 0 ), // ncr = Ncane
  TRUETYPE_TAG('n','c','s', 0 ), // ncs = Nicaraguan Sign Language
  TRUETYPE_TAG('n','c','t', 0 ), // nct = Chothe Naga
  TRUETYPE_TAG('n','c','u', 0 ), // ncu = Chumburung
  TRUETYPE_TAG('n','c','x', 0 ), // ncx = Central Puebla Nahuatl
  TRUETYPE_TAG('n','c','z', 0 ), // ncz = Natchez
  TRUETYPE_TAG('n','d','a', 0 ), // nda = Ndasa
  TRUETYPE_TAG('n','d','b', 0 ), // ndb = Kenswei Nsei
  TRUETYPE_TAG('n','d','c', 0 ), // ndc = Ndau
  TRUETYPE_TAG('n','d','d', 0 ), // ndd = Nde-Nsele-Nta
  TRUETYPE_TAG('n','d','f', 0 ), // ndf = Nadruvian
  TRUETYPE_TAG('n','d','g', 0 ), // ndg = Ndengereko
  TRUETYPE_TAG('n','d','h', 0 ), // ndh = Ndali
  TRUETYPE_TAG('n','d','i', 0 ), // ndi = Samba Leko
  TRUETYPE_TAG('n','d','j', 0 ), // ndj = Ndamba
  TRUETYPE_TAG('n','d','k', 0 ), // ndk = Ndaka
  TRUETYPE_TAG('n','d','l', 0 ), // ndl = Ndolo
  TRUETYPE_TAG('n','d','m', 0 ), // ndm = Ndam
  TRUETYPE_TAG('n','d','n', 0 ), // ndn = Ngundi
  TRUETYPE_TAG('n','d','p', 0 ), // ndp = Ndo
  TRUETYPE_TAG('n','d','q', 0 ), // ndq = Ndombe
  TRUETYPE_TAG('n','d','r', 0 ), // ndr = Ndoola
  TRUETYPE_TAG('n','d','s', 0 ), // nds = Low German
  TRUETYPE_TAG('n','d','t', 0 ), // ndt = Ndunga
  TRUETYPE_TAG('n','d','u', 0 ), // ndu = Dugun
  TRUETYPE_TAG('n','d','v', 0 ), // ndv = Ndut
  TRUETYPE_TAG('n','d','w', 0 ), // ndw = Ndobo
  TRUETYPE_TAG('n','d','x', 0 ), // ndx = Nduga
  TRUETYPE_TAG('n','d','y', 0 ), // ndy = Lutos
  TRUETYPE_TAG('n','d','z', 0 ), // ndz = Ndogo
  TRUETYPE_TAG('n','e','a', 0 ), // nea = Eastern Ngad'a
  TRUETYPE_TAG('n','e','b', 0 ), // neb = Toura (Côte d'Ivoire)
  TRUETYPE_TAG('n','e','c', 0 ), // nec = Nedebang
  TRUETYPE_TAG('n','e','d', 0 ), // ned = Nde-Gbite
  TRUETYPE_TAG('n','e','e', 0 ), // nee = Nêlêmwa-Nixumwak
  TRUETYPE_TAG('n','e','f', 0 ), // nef = Nefamese
  TRUETYPE_TAG('n','e','g', 0 ), // neg = Negidal
  TRUETYPE_TAG('n','e','h', 0 ), // neh = Nyenkha
  TRUETYPE_TAG('n','e','i', 0 ), // nei = Neo-Hittite
  TRUETYPE_TAG('n','e','j', 0 ), // nej = Neko
  TRUETYPE_TAG('n','e','k', 0 ), // nek = Neku
  TRUETYPE_TAG('n','e','m', 0 ), // nem = Nemi
  TRUETYPE_TAG('n','e','n', 0 ), // nen = Nengone
  TRUETYPE_TAG('n','e','o', 0 ), // neo = Ná-Meo
  TRUETYPE_TAG('n','e','q', 0 ), // neq = North Central Mixe
  TRUETYPE_TAG('n','e','r', 0 ), // ner = Yahadian
  TRUETYPE_TAG('n','e','s', 0 ), // nes = Bhoti Kinnauri
  TRUETYPE_TAG('n','e','t', 0 ), // net = Nete
  TRUETYPE_TAG('n','e','v', 0 ), // nev = Nyaheun
  TRUETYPE_TAG('n','e','w', 0 ), // new = Newari
  TRUETYPE_TAG('n','e','x', 0 ), // nex = Neme
  TRUETYPE_TAG('n','e','y', 0 ), // ney = Neyo
  TRUETYPE_TAG('n','e','z', 0 ), // nez = Nez Perce
  TRUETYPE_TAG('n','f','a', 0 ), // nfa = Dhao
  TRUETYPE_TAG('n','f','d', 0 ), // nfd = Ahwai
  TRUETYPE_TAG('n','f','l', 0 ), // nfl = Ayiwo
  TRUETYPE_TAG('n','f','r', 0 ), // nfr = Nafaanra
  TRUETYPE_TAG('n','f','u', 0 ), // nfu = Mfumte
  TRUETYPE_TAG('n','g','a', 0 ), // nga = Ngbaka
  TRUETYPE_TAG('n','g','b', 0 ), // ngb = Northern Ngbandi
  TRUETYPE_TAG('n','g','c', 0 ), // ngc = Ngombe (Democratic Republic of Congo)
  TRUETYPE_TAG('n','g','d', 0 ), // ngd = Ngando (Central African Republic)
  TRUETYPE_TAG('n','g','e', 0 ), // nge = Ngemba
  TRUETYPE_TAG('n','g','f', 0 ), // ngf = Trans-New Guinea languages
  TRUETYPE_TAG('n','g','g', 0 ), // ngg = Ngbaka Manza
  TRUETYPE_TAG('n','g','h', 0 ), // ngh = N/u
  TRUETYPE_TAG('n','g','i', 0 ), // ngi = Ngizim
  TRUETYPE_TAG('n','g','j', 0 ), // ngj = Ngie
  TRUETYPE_TAG('n','g','k', 0 ), // ngk = Ngalkbun
  TRUETYPE_TAG('n','g','l', 0 ), // ngl = Lomwe
  TRUETYPE_TAG('n','g','m', 0 ), // ngm = Ngatik Men's Creole
  TRUETYPE_TAG('n','g','n', 0 ), // ngn = Ngwo
  TRUETYPE_TAG('n','g','o', 0 ), // ngo = Ngoni
  TRUETYPE_TAG('n','g','p', 0 ), // ngp = Ngulu
  TRUETYPE_TAG('n','g','q', 0 ), // ngq = Ngurimi
  TRUETYPE_TAG('n','g','r', 0 ), // ngr = Nanggu
  TRUETYPE_TAG('n','g','s', 0 ), // ngs = Gvoko
  TRUETYPE_TAG('n','g','t', 0 ), // ngt = Ngeq
  TRUETYPE_TAG('n','g','u', 0 ), // ngu = Guerrero Nahuatl
  TRUETYPE_TAG('n','g','v', 0 ), // ngv = Nagumi
  TRUETYPE_TAG('n','g','w', 0 ), // ngw = Ngwaba
  TRUETYPE_TAG('n','g','x', 0 ), // ngx = Nggwahyi
  TRUETYPE_TAG('n','g','y', 0 ), // ngy = Tibea
  TRUETYPE_TAG('n','g','z', 0 ), // ngz = Ngungwel
  TRUETYPE_TAG('n','h','a', 0 ), // nha = Nhanda
  TRUETYPE_TAG('n','h','b', 0 ), // nhb = Beng
  TRUETYPE_TAG('n','h','c', 0 ), // nhc = Tabasco Nahuatl
  TRUETYPE_TAG('n','h','d', 0 ), // nhd = Chiripá
  TRUETYPE_TAG('n','h','e', 0 ), // nhe = Eastern Huasteca Nahuatl
  TRUETYPE_TAG('n','h','f', 0 ), // nhf = Nhuwala
  TRUETYPE_TAG('n','h','g', 0 ), // nhg = Tetelcingo Nahuatl
  TRUETYPE_TAG('n','h','h', 0 ), // nhh = Nahari
  TRUETYPE_TAG('n','h','i', 0 ), // nhi = Zacatlán-Ahuacatlán-Tepetzintla Nahuatl
  TRUETYPE_TAG('n','h','k', 0 ), // nhk = Isthmus-Cosoleacaque Nahuatl
  TRUETYPE_TAG('n','h','m', 0 ), // nhm = Morelos Nahuatl
  TRUETYPE_TAG('n','h','n', 0 ), // nhn = Central Nahuatl
  TRUETYPE_TAG('n','h','o', 0 ), // nho = Takuu
  TRUETYPE_TAG('n','h','p', 0 ), // nhp = Isthmus-Pajapan Nahuatl
  TRUETYPE_TAG('n','h','q', 0 ), // nhq = Huaxcaleca Nahuatl
  TRUETYPE_TAG('n','h','r', 0 ), // nhr = Naro
  TRUETYPE_TAG('n','h','t', 0 ), // nht = Ometepec Nahuatl
  TRUETYPE_TAG('n','h','u', 0 ), // nhu = Noone
  TRUETYPE_TAG('n','h','v', 0 ), // nhv = Temascaltepec Nahuatl
  TRUETYPE_TAG('n','h','w', 0 ), // nhw = Western Huasteca Nahuatl
  TRUETYPE_TAG('n','h','x', 0 ), // nhx = Isthmus-Mecayapan Nahuatl
  TRUETYPE_TAG('n','h','y', 0 ), // nhy = Northern Oaxaca Nahuatl
  TRUETYPE_TAG('n','h','z', 0 ), // nhz = Santa María La Alta Nahuatl
  TRUETYPE_TAG('n','i','a', 0 ), // nia = Nias
  TRUETYPE_TAG('n','i','b', 0 ), // nib = Nakame
  TRUETYPE_TAG('n','i','c', 0 ), // nic = Niger-Kordofanian languages
  TRUETYPE_TAG('n','i','d', 0 ), // nid = Ngandi
  TRUETYPE_TAG('n','i','e', 0 ), // nie = Niellim
  TRUETYPE_TAG('n','i','f', 0 ), // nif = Nek
  TRUETYPE_TAG('n','i','g', 0 ), // nig = Ngalakan
  TRUETYPE_TAG('n','i','h', 0 ), // nih = Nyiha (Tanzania)
  TRUETYPE_TAG('n','i','i', 0 ), // nii = Nii
  TRUETYPE_TAG('n','i','j', 0 ), // nij = Ngaju
  TRUETYPE_TAG('n','i','k', 0 ), // nik = Southern Nicobarese
  TRUETYPE_TAG('n','i','l', 0 ), // nil = Nila
  TRUETYPE_TAG('n','i','m', 0 ), // nim = Nilamba
  TRUETYPE_TAG('n','i','n', 0 ), // nin = Ninzo
  TRUETYPE_TAG('n','i','o', 0 ), // nio = Nganasan
  TRUETYPE_TAG('n','i','q', 0 ), // niq = Nandi
  TRUETYPE_TAG('n','i','r', 0 ), // nir = Nimboran
  TRUETYPE_TAG('n','i','s', 0 ), // nis = Nimi
  TRUETYPE_TAG('n','i','t', 0 ), // nit = Southeastern Kolami
  TRUETYPE_TAG('n','i','u', 0 ), // niu = Niuean
  TRUETYPE_TAG('n','i','v', 0 ), // niv = Gilyak
  TRUETYPE_TAG('n','i','w', 0 ), // niw = Nimo
  TRUETYPE_TAG('n','i','x', 0 ), // nix = Hema
  TRUETYPE_TAG('n','i','y', 0 ), // niy = Ngiti
  TRUETYPE_TAG('n','i','z', 0 ), // niz = Ningil
  TRUETYPE_TAG('n','j','a', 0 ), // nja = Nzanyi
  TRUETYPE_TAG('n','j','b', 0 ), // njb = Nocte Naga
  TRUETYPE_TAG('n','j','d', 0 ), // njd = Ndonde Hamba
  TRUETYPE_TAG('n','j','h', 0 ), // njh = Lotha Naga
  TRUETYPE_TAG('n','j','i', 0 ), // nji = Gudanji
  TRUETYPE_TAG('n','j','j', 0 ), // njj = Njen
  TRUETYPE_TAG('n','j','l', 0 ), // njl = Njalgulgule
  TRUETYPE_TAG('n','j','m', 0 ), // njm = Angami Naga
  TRUETYPE_TAG('n','j','n', 0 ), // njn = Liangmai Naga
  TRUETYPE_TAG('n','j','o', 0 ), // njo = Ao Naga
  TRUETYPE_TAG('n','j','r', 0 ), // njr = Njerep
  TRUETYPE_TAG('n','j','s', 0 ), // njs = Nisa
  TRUETYPE_TAG('n','j','t', 0 ), // njt = Ndyuka-Trio Pidgin
  TRUETYPE_TAG('n','j','u', 0 ), // nju = Ngadjunmaya
  TRUETYPE_TAG('n','j','x', 0 ), // njx = Kunyi
  TRUETYPE_TAG('n','j','y', 0 ), // njy = Njyem
  TRUETYPE_TAG('n','k','a', 0 ), // nka = Nkoya
  TRUETYPE_TAG('n','k','b', 0 ), // nkb = Khoibu Naga
  TRUETYPE_TAG('n','k','c', 0 ), // nkc = Nkongho
  TRUETYPE_TAG('n','k','d', 0 ), // nkd = Koireng
  TRUETYPE_TAG('n','k','e', 0 ), // nke = Duke
  TRUETYPE_TAG('n','k','f', 0 ), // nkf = Inpui Naga
  TRUETYPE_TAG('n','k','g', 0 ), // nkg = Nekgini
  TRUETYPE_TAG('n','k','h', 0 ), // nkh = Khezha Naga
  TRUETYPE_TAG('n','k','i', 0 ), // nki = Thangal Naga
  TRUETYPE_TAG('n','k','j', 0 ), // nkj = Nakai
  TRUETYPE_TAG('n','k','k', 0 ), // nkk = Nokuku
  TRUETYPE_TAG('n','k','m', 0 ), // nkm = Namat
  TRUETYPE_TAG('n','k','n', 0 ), // nkn = Nkangala
  TRUETYPE_TAG('n','k','o', 0 ), // nko = Nkonya
  TRUETYPE_TAG('n','k','p', 0 ), // nkp = Niuatoputapu
  TRUETYPE_TAG('n','k','q', 0 ), // nkq = Nkami
  TRUETYPE_TAG('n','k','r', 0 ), // nkr = Nukuoro
  TRUETYPE_TAG('n','k','s', 0 ), // nks = North Asmat
  TRUETYPE_TAG('n','k','t', 0 ), // nkt = Nyika (Tanzania)
  TRUETYPE_TAG('n','k','u', 0 ), // nku = Bouna Kulango
  TRUETYPE_TAG('n','k','v', 0 ), // nkv = Nyika (Malawi and Zambia)
  TRUETYPE_TAG('n','k','w', 0 ), // nkw = Nkutu
  TRUETYPE_TAG('n','k','x', 0 ), // nkx = Nkoroo
  TRUETYPE_TAG('n','k','z', 0 ), // nkz = Nkari
  TRUETYPE_TAG('n','l','a', 0 ), // nla = Ngombale
  TRUETYPE_TAG('n','l','c', 0 ), // nlc = Nalca
  TRUETYPE_TAG('n','l','e', 0 ), // nle = East Nyala
  TRUETYPE_TAG('n','l','g', 0 ), // nlg = Gela
  TRUETYPE_TAG('n','l','i', 0 ), // nli = Grangali
  TRUETYPE_TAG('n','l','j', 0 ), // nlj = Nyali
  TRUETYPE_TAG('n','l','k', 0 ), // nlk = Ninia Yali
  TRUETYPE_TAG('n','l','l', 0 ), // nll = Nihali
  TRUETYPE_TAG('n','l','n', 0 ), // nln = Durango Nahuatl
  TRUETYPE_TAG('n','l','o', 0 ), // nlo = Ngul
  TRUETYPE_TAG('n','l','r', 0 ), // nlr = Ngarla
  TRUETYPE_TAG('n','l','u', 0 ), // nlu = Nchumbulu
  TRUETYPE_TAG('n','l','v', 0 ), // nlv = Orizaba Nahuatl
  TRUETYPE_TAG('n','l','x', 0 ), // nlx = Nahali
  TRUETYPE_TAG('n','l','y', 0 ), // nly = Nyamal
  TRUETYPE_TAG('n','l','z', 0 ), // nlz = Nalögo
  TRUETYPE_TAG('n','m','a', 0 ), // nma = Maram Naga
  TRUETYPE_TAG('n','m','b', 0 ), // nmb = Big Nambas
  TRUETYPE_TAG('n','m','c', 0 ), // nmc = Ngam
  TRUETYPE_TAG('n','m','d', 0 ), // nmd = Ndumu
  TRUETYPE_TAG('n','m','e', 0 ), // nme = Mzieme Naga
  TRUETYPE_TAG('n','m','f', 0 ), // nmf = Tangkhul Naga
  TRUETYPE_TAG('n','m','g', 0 ), // nmg = Kwasio
  TRUETYPE_TAG('n','m','h', 0 ), // nmh = Monsang Naga
  TRUETYPE_TAG('n','m','i', 0 ), // nmi = Nyam
  TRUETYPE_TAG('n','m','j', 0 ), // nmj = Ngombe (Central African Republic)
  TRUETYPE_TAG('n','m','k', 0 ), // nmk = Namakura
  TRUETYPE_TAG('n','m','l', 0 ), // nml = Ndemli
  TRUETYPE_TAG('n','m','m', 0 ), // nmm = Manangba
  TRUETYPE_TAG('n','m','n', 0 ), // nmn = !Xóõ
  TRUETYPE_TAG('n','m','o', 0 ), // nmo = Moyon Naga
  TRUETYPE_TAG('n','m','p', 0 ), // nmp = Nimanbur
  TRUETYPE_TAG('n','m','q', 0 ), // nmq = Nambya
  TRUETYPE_TAG('n','m','r', 0 ), // nmr = Nimbari
  TRUETYPE_TAG('n','m','s', 0 ), // nms = Letemboi
  TRUETYPE_TAG('n','m','t', 0 ), // nmt = Namonuito
  TRUETYPE_TAG('n','m','u', 0 ), // nmu = Northeast Maidu
  TRUETYPE_TAG('n','m','v', 0 ), // nmv = Ngamini
  TRUETYPE_TAG('n','m','w', 0 ), // nmw = Nimoa
  TRUETYPE_TAG('n','m','x', 0 ), // nmx = Nama (Papua New Guinea)
  TRUETYPE_TAG('n','m','y', 0 ), // nmy = Namuyi
  TRUETYPE_TAG('n','m','z', 0 ), // nmz = Nawdm
  TRUETYPE_TAG('n','n','a', 0 ), // nna = Nyangumarta
  TRUETYPE_TAG('n','n','b', 0 ), // nnb = Nande
  TRUETYPE_TAG('n','n','c', 0 ), // nnc = Nancere
  TRUETYPE_TAG('n','n','d', 0 ), // nnd = West Ambae
  TRUETYPE_TAG('n','n','e', 0 ), // nne = Ngandyera
  TRUETYPE_TAG('n','n','f', 0 ), // nnf = Ngaing
  TRUETYPE_TAG('n','n','g', 0 ), // nng = Maring Naga
  TRUETYPE_TAG('n','n','h', 0 ), // nnh = Ngiemboon
  TRUETYPE_TAG('n','n','i', 0 ), // nni = North Nuaulu
  TRUETYPE_TAG('n','n','j', 0 ), // nnj = Nyangatom
  TRUETYPE_TAG('n','n','k', 0 ), // nnk = Nankina
  TRUETYPE_TAG('n','n','l', 0 ), // nnl = Northern Rengma Naga
  TRUETYPE_TAG('n','n','m', 0 ), // nnm = Namia
  TRUETYPE_TAG('n','n','n', 0 ), // nnn = Ngete
  TRUETYPE_TAG('n','n','p', 0 ), // nnp = Wancho Naga
  TRUETYPE_TAG('n','n','q', 0 ), // nnq = Ngindo
  TRUETYPE_TAG('n','n','r', 0 ), // nnr = Narungga
  TRUETYPE_TAG('n','n','s', 0 ), // nns = Ningye
  TRUETYPE_TAG('n','n','t', 0 ), // nnt = Nanticoke
  TRUETYPE_TAG('n','n','u', 0 ), // nnu = Dwang
  TRUETYPE_TAG('n','n','v', 0 ), // nnv = Nugunu (Australia)
  TRUETYPE_TAG('n','n','w', 0 ), // nnw = Southern Nuni
  TRUETYPE_TAG('n','n','x', 0 ), // nnx = Ngong
  TRUETYPE_TAG('n','n','y', 0 ), // nny = Nyangga
  TRUETYPE_TAG('n','n','z', 0 ), // nnz = Nda'nda'
  TRUETYPE_TAG('n','o','a', 0 ), // noa = Woun Meu
  TRUETYPE_TAG('n','o','c', 0 ), // noc = Nuk
  TRUETYPE_TAG('n','o','d', 0 ), // nod = Northern Thai
  TRUETYPE_TAG('n','o','e', 0 ), // noe = Nimadi
  TRUETYPE_TAG('n','o','f', 0 ), // nof = Nomane
  TRUETYPE_TAG('n','o','g', 0 ), // nog = Nogai
  TRUETYPE_TAG('n','o','h', 0 ), // noh = Nomu
  TRUETYPE_TAG('n','o','i', 0 ), // noi = Noiri
  TRUETYPE_TAG('n','o','j', 0 ), // noj = Nonuya
  TRUETYPE_TAG('n','o','k', 0 ), // nok = Nooksack
  TRUETYPE_TAG('n','o','m', 0 ), // nom = Nocamán
  TRUETYPE_TAG('n','o','n', 0 ), // non = Old Norse
  TRUETYPE_TAG('n','o','o', 0 ), // noo = Nootka
  TRUETYPE_TAG('n','o','p', 0 ), // nop = Numanggang
  TRUETYPE_TAG('n','o','q', 0 ), // noq = Ngongo
  TRUETYPE_TAG('n','o','s', 0 ), // nos = Eastern Nisu
  TRUETYPE_TAG('n','o','t', 0 ), // not = Nomatsiguenga
  TRUETYPE_TAG('n','o','u', 0 ), // nou = Ewage-Notu
  TRUETYPE_TAG('n','o','v', 0 ), // nov = Novial
  TRUETYPE_TAG('n','o','w', 0 ), // now = Nyambo
  TRUETYPE_TAG('n','o','y', 0 ), // noy = Noy
  TRUETYPE_TAG('n','o','z', 0 ), // noz = Nayi
  TRUETYPE_TAG('n','p','a', 0 ), // npa = Nar Phu
  TRUETYPE_TAG('n','p','b', 0 ), // npb = Nupbikha
  TRUETYPE_TAG('n','p','h', 0 ), // nph = Phom Naga
  TRUETYPE_TAG('n','p','l', 0 ), // npl = Southeastern Puebla Nahuatl
  TRUETYPE_TAG('n','p','n', 0 ), // npn = Mondropolon
  TRUETYPE_TAG('n','p','o', 0 ), // npo = Pochuri Naga
  TRUETYPE_TAG('n','p','s', 0 ), // nps = Nipsan
  TRUETYPE_TAG('n','p','u', 0 ), // npu = Puimei Naga
  TRUETYPE_TAG('n','p','y', 0 ), // npy = Napu
  TRUETYPE_TAG('n','q','g', 0 ), // nqg = Southern Nago
  TRUETYPE_TAG('n','q','k', 0 ), // nqk = Kura Ede Nago
  TRUETYPE_TAG('n','q','m', 0 ), // nqm = Ndom
  TRUETYPE_TAG('n','q','n', 0 ), // nqn = Nen
  TRUETYPE_TAG('n','q','o', 0 ), // nqo = N'Ko
  TRUETYPE_TAG('n','r','a', 0 ), // nra = Ngom
  TRUETYPE_TAG('n','r','b', 0 ), // nrb = Nara
  TRUETYPE_TAG('n','r','c', 0 ), // nrc = Noric
  TRUETYPE_TAG('n','r','e', 0 ), // nre = Southern Rengma Naga
  TRUETYPE_TAG('n','r','g', 0 ), // nrg = Narango
  TRUETYPE_TAG('n','r','i', 0 ), // nri = Chokri Naga
  TRUETYPE_TAG('n','r','l', 0 ), // nrl = Ngarluma
  TRUETYPE_TAG('n','r','m', 0 ), // nrm = Narom
  TRUETYPE_TAG('n','r','n', 0 ), // nrn = Norn
  TRUETYPE_TAG('n','r','p', 0 ), // nrp = North Picene
  TRUETYPE_TAG('n','r','r', 0 ), // nrr = Norra
  TRUETYPE_TAG('n','r','t', 0 ), // nrt = Northern Kalapuya
  TRUETYPE_TAG('n','r','u', 0 ), // nru = Narua
  TRUETYPE_TAG('n','r','x', 0 ), // nrx = Ngurmbur
  TRUETYPE_TAG('n','r','z', 0 ), // nrz = Lala
  TRUETYPE_TAG('n','s','a', 0 ), // nsa = Sangtam Naga
  TRUETYPE_TAG('n','s','c', 0 ), // nsc = Nshi
  TRUETYPE_TAG('n','s','d', 0 ), // nsd = Southern Nisu
  TRUETYPE_TAG('n','s','e', 0 ), // nse = Nsenga
  TRUETYPE_TAG('n','s','g', 0 ), // nsg = Ngasa
  TRUETYPE_TAG('n','s','h', 0 ), // nsh = Ngoshie
  TRUETYPE_TAG('n','s','i', 0 ), // nsi = Nigerian Sign Language
  TRUETYPE_TAG('n','s','k', 0 ), // nsk = Naskapi
  TRUETYPE_TAG('n','s','l', 0 ), // nsl = Norwegian Sign Language
  TRUETYPE_TAG('n','s','m', 0 ), // nsm = Sumi Naga
  TRUETYPE_TAG('n','s','n', 0 ), // nsn = Nehan
  TRUETYPE_TAG('n','s','o', 0 ), // nso = Pedi
  TRUETYPE_TAG('n','s','p', 0 ), // nsp = Nepalese Sign Language
  TRUETYPE_TAG('n','s','q', 0 ), // nsq = Northern Sierra Miwok
  TRUETYPE_TAG('n','s','r', 0 ), // nsr = Maritime Sign Language
  TRUETYPE_TAG('n','s','s', 0 ), // nss = Nali
  TRUETYPE_TAG('n','s','t', 0 ), // nst = Tase Naga
  TRUETYPE_TAG('n','s','u', 0 ), // nsu = Sierra Negra Nahuatl
  TRUETYPE_TAG('n','s','v', 0 ), // nsv = Southwestern Nisu
  TRUETYPE_TAG('n','s','w', 0 ), // nsw = Navut
  TRUETYPE_TAG('n','s','x', 0 ), // nsx = Nsongo
  TRUETYPE_TAG('n','s','y', 0 ), // nsy = Nasal
  TRUETYPE_TAG('n','s','z', 0 ), // nsz = Nisenan
  TRUETYPE_TAG('n','t','e', 0 ), // nte = Nathembo
  TRUETYPE_TAG('n','t','i', 0 ), // nti = Natioro
  TRUETYPE_TAG('n','t','j', 0 ), // ntj = Ngaanyatjarra
  TRUETYPE_TAG('n','t','k', 0 ), // ntk = Ikoma-Nata-Isenye
  TRUETYPE_TAG('n','t','m', 0 ), // ntm = Nateni
  TRUETYPE_TAG('n','t','o', 0 ), // nto = Ntomba
  TRUETYPE_TAG('n','t','p', 0 ), // ntp = Northern Tepehuan
  TRUETYPE_TAG('n','t','r', 0 ), // ntr = Delo
  TRUETYPE_TAG('n','t','s', 0 ), // nts = Natagaimas
  TRUETYPE_TAG('n','t','u', 0 ), // ntu = Natügu
  TRUETYPE_TAG('n','t','w', 0 ), // ntw = Nottoway
  TRUETYPE_TAG('n','t','y', 0 ), // nty = Mantsi
  TRUETYPE_TAG('n','t','z', 0 ), // ntz = Natanzi
  TRUETYPE_TAG('n','u','a', 0 ), // nua = Yuaga
  TRUETYPE_TAG('n','u','b', 0 ), // nub = Nubian languages
  TRUETYPE_TAG('n','u','c', 0 ), // nuc = Nukuini
  TRUETYPE_TAG('n','u','d', 0 ), // nud = Ngala
  TRUETYPE_TAG('n','u','e', 0 ), // nue = Ngundu
  TRUETYPE_TAG('n','u','f', 0 ), // nuf = Nusu
  TRUETYPE_TAG('n','u','g', 0 ), // nug = Nungali
  TRUETYPE_TAG('n','u','h', 0 ), // nuh = Ndunda
  TRUETYPE_TAG('n','u','i', 0 ), // nui = Ngumbi
  TRUETYPE_TAG('n','u','j', 0 ), // nuj = Nyole
  TRUETYPE_TAG('n','u','k', 0 ), // nuk = Nuu-chah-nulth
  TRUETYPE_TAG('n','u','l', 0 ), // nul = Nusa Laut
  TRUETYPE_TAG('n','u','m', 0 ), // num = Niuafo'ou
  TRUETYPE_TAG('n','u','n', 0 ), // nun = Anong
  TRUETYPE_TAG('n','u','o', 0 ), // nuo = Nguôn
  TRUETYPE_TAG('n','u','p', 0 ), // nup = Nupe-Nupe-Tako
  TRUETYPE_TAG('n','u','q', 0 ), // nuq = Nukumanu
  TRUETYPE_TAG('n','u','r', 0 ), // nur = Nukuria
  TRUETYPE_TAG('n','u','s', 0 ), // nus = Nuer
  TRUETYPE_TAG('n','u','t', 0 ), // nut = Nung (Viet Nam)
  TRUETYPE_TAG('n','u','u', 0 ), // nuu = Ngbundu
  TRUETYPE_TAG('n','u','v', 0 ), // nuv = Northern Nuni
  TRUETYPE_TAG('n','u','w', 0 ), // nuw = Nguluwan
  TRUETYPE_TAG('n','u','x', 0 ), // nux = Mehek
  TRUETYPE_TAG('n','u','y', 0 ), // nuy = Nunggubuyu
  TRUETYPE_TAG('n','u','z', 0 ), // nuz = Tlamacazapa Nahuatl
  TRUETYPE_TAG('n','v','h', 0 ), // nvh = Nasarian
  TRUETYPE_TAG('n','v','m', 0 ), // nvm = Namiae
  TRUETYPE_TAG('n','w','a', 0 ), // nwa = Nawathinehena
  TRUETYPE_TAG('n','w','b', 0 ), // nwb = Nyabwa
  TRUETYPE_TAG('n','w','c', 0 ), // nwc = Classical Newari
  TRUETYPE_TAG('n','w','e', 0 ), // nwe = Ngwe
  TRUETYPE_TAG('n','w','i', 0 ), // nwi = Southwest Tanna
  TRUETYPE_TAG('n','w','m', 0 ), // nwm = Nyamusa-Molo
  TRUETYPE_TAG('n','w','r', 0 ), // nwr = Nawaru
  TRUETYPE_TAG('n','w','x', 0 ), // nwx = Middle Newar
  TRUETYPE_TAG('n','w','y', 0 ), // nwy = Nottoway-Meherrin
  TRUETYPE_TAG('n','x','a', 0 ), // nxa = Nauete
  TRUETYPE_TAG('n','x','d', 0 ), // nxd = Ngando (Democratic Republic of Congo)
  TRUETYPE_TAG('n','x','e', 0 ), // nxe = Nage
  TRUETYPE_TAG('n','x','g', 0 ), // nxg = Ngad'a
  TRUETYPE_TAG('n','x','i', 0 ), // nxi = Nindi
  TRUETYPE_TAG('n','x','l', 0 ), // nxl = South Nuaulu
  TRUETYPE_TAG('n','x','m', 0 ), // nxm = Numidian
  TRUETYPE_TAG('n','x','n', 0 ), // nxn = Ngawun
  TRUETYPE_TAG('n','x','q', 0 ), // nxq = Naxi
  TRUETYPE_TAG('n','x','r', 0 ), // nxr = Ninggerum
  TRUETYPE_TAG('n','x','u', 0 ), // nxu = Narau
  TRUETYPE_TAG('n','x','x', 0 ), // nxx = Nafri
  TRUETYPE_TAG('n','y','b', 0 ), // nyb = Nyangbo
  TRUETYPE_TAG('n','y','c', 0 ), // nyc = Nyanga-li
  TRUETYPE_TAG('n','y','d', 0 ), // nyd = Nyore
  TRUETYPE_TAG('n','y','e', 0 ), // nye = Nyengo
  TRUETYPE_TAG('n','y','f', 0 ), // nyf = Giryama
  TRUETYPE_TAG('n','y','g', 0 ), // nyg = Nyindu
  TRUETYPE_TAG('n','y','h', 0 ), // nyh = Nyigina
  TRUETYPE_TAG('n','y','i', 0 ), // nyi = Ama (Sudan)
  TRUETYPE_TAG('n','y','j', 0 ), // nyj = Nyanga
  TRUETYPE_TAG('n','y','k', 0 ), // nyk = Nyaneka
  TRUETYPE_TAG('n','y','l', 0 ), // nyl = Nyeu
  TRUETYPE_TAG('n','y','m', 0 ), // nym = Nyamwezi
  TRUETYPE_TAG('n','y','n', 0 ), // nyn = Nyankole
  TRUETYPE_TAG('n','y','o', 0 ), // nyo = Nyoro
  TRUETYPE_TAG('n','y','p', 0 ), // nyp = Nyang'i
  TRUETYPE_TAG('n','y','q', 0 ), // nyq = Nayini
  TRUETYPE_TAG('n','y','r', 0 ), // nyr = Nyiha (Malawi)
  TRUETYPE_TAG('n','y','s', 0 ), // nys = Nyunga
  TRUETYPE_TAG('n','y','t', 0 ), // nyt = Nyawaygi
  TRUETYPE_TAG('n','y','u', 0 ), // nyu = Nyungwe
  TRUETYPE_TAG('n','y','v', 0 ), // nyv = Nyulnyul
  TRUETYPE_TAG('n','y','w', 0 ), // nyw = Nyaw
  TRUETYPE_TAG('n','y','x', 0 ), // nyx = Nganyaywana
  TRUETYPE_TAG('n','y','y', 0 ), // nyy = Nyakyusa-Ngonde
  TRUETYPE_TAG('n','z','a', 0 ), // nza = Tigon Mbembe
  TRUETYPE_TAG('n','z','b', 0 ), // nzb = Njebi
  TRUETYPE_TAG('n','z','i', 0 ), // nzi = Nzima
  TRUETYPE_TAG('n','z','k', 0 ), // nzk = Nzakara
  TRUETYPE_TAG('n','z','m', 0 ), // nzm = Zeme Naga
  TRUETYPE_TAG('n','z','s', 0 ), // nzs = New Zealand Sign Language
  TRUETYPE_TAG('n','z','u', 0 ), // nzu = Teke-Nzikou
  TRUETYPE_TAG('n','z','y', 0 ), // nzy = Nzakambay
  TRUETYPE_TAG('n','z','z', 0 ), // nzz = Nanga Dama Dogon
  TRUETYPE_TAG('o','a','a', 0 ), // oaa = Orok
  TRUETYPE_TAG('o','a','c', 0 ), // oac = Oroch
  TRUETYPE_TAG('o','a','r', 0 ), // oar = Old Aramaic (up to 700 BCE)
  TRUETYPE_TAG('o','a','v', 0 ), // oav = Old Avar
  TRUETYPE_TAG('o','b','i', 0 ), // obi = Obispeño
  TRUETYPE_TAG('o','b','k', 0 ), // obk = Southern Bontok
  TRUETYPE_TAG('o','b','l', 0 ), // obl = Oblo
  TRUETYPE_TAG('o','b','m', 0 ), // obm = Moabite
  TRUETYPE_TAG('o','b','o', 0 ), // obo = Obo Manobo
  TRUETYPE_TAG('o','b','r', 0 ), // obr = Old Burmese
  TRUETYPE_TAG('o','b','t', 0 ), // obt = Old Breton
  TRUETYPE_TAG('o','b','u', 0 ), // obu = Obulom
  TRUETYPE_TAG('o','c','a', 0 ), // oca = Ocaina
  TRUETYPE_TAG('o','c','h', 0 ), // och = Old Chinese
  TRUETYPE_TAG('o','c','o', 0 ), // oco = Old Cornish
  TRUETYPE_TAG('o','c','u', 0 ), // ocu = Atzingo Matlatzinca
  TRUETYPE_TAG('o','d','a', 0 ), // oda = Odut
  TRUETYPE_TAG('o','d','k', 0 ), // odk = Od
  TRUETYPE_TAG('o','d','t', 0 ), // odt = Old Dutch
  TRUETYPE_TAG('o','d','u', 0 ), // odu = Odual
  TRUETYPE_TAG('o','f','o', 0 ), // ofo = Ofo
  TRUETYPE_TAG('o','f','s', 0 ), // ofs = Old Frisian
  TRUETYPE_TAG('o','f','u', 0 ), // ofu = Efutop
  TRUETYPE_TAG('o','g','b', 0 ), // ogb = Ogbia
  TRUETYPE_TAG('o','g','c', 0 ), // ogc = Ogbah
  TRUETYPE_TAG('o','g','e', 0 ), // oge = Old Georgian
  TRUETYPE_TAG('o','g','g', 0 ), // ogg = Ogbogolo
  TRUETYPE_TAG('o','g','o', 0 ), // ogo = Khana
  TRUETYPE_TAG('o','g','u', 0 ), // ogu = Ogbronuagum
  TRUETYPE_TAG('o','h','t', 0 ), // oht = Old Hittite
  TRUETYPE_TAG('o','h','u', 0 ), // ohu = Old Hungarian
  TRUETYPE_TAG('o','i','a', 0 ), // oia = Oirata
  TRUETYPE_TAG('o','i','n', 0 ), // oin = Inebu One
  TRUETYPE_TAG('o','j','b', 0 ), // ojb = Northwestern Ojibwa
  TRUETYPE_TAG('o','j','c', 0 ), // ojc = Central Ojibwa
  TRUETYPE_TAG('o','j','g', 0 ), // ojg = Eastern Ojibwa
  TRUETYPE_TAG('o','j','p', 0 ), // ojp = Old Japanese
  TRUETYPE_TAG('o','j','s', 0 ), // ojs = Severn Ojibwa
  TRUETYPE_TAG('o','j','v', 0 ), // ojv = Ontong Java
  TRUETYPE_TAG('o','j','w', 0 ), // ojw = Western Ojibwa
  TRUETYPE_TAG('o','k','a', 0 ), // oka = Okanagan
  TRUETYPE_TAG('o','k','b', 0 ), // okb = Okobo
  TRUETYPE_TAG('o','k','d', 0 ), // okd = Okodia
  TRUETYPE_TAG('o','k','e', 0 ), // oke = Okpe (Southwestern Edo)
  TRUETYPE_TAG('o','k','h', 0 ), // okh = Koresh-e Rostam
  TRUETYPE_TAG('o','k','i', 0 ), // oki = Okiek
  TRUETYPE_TAG('o','k','j', 0 ), // okj = Oko-Juwoi
  TRUETYPE_TAG('o','k','k', 0 ), // okk = Kwamtim One
  TRUETYPE_TAG('o','k','l', 0 ), // okl = Old Kentish Sign Language
  TRUETYPE_TAG('o','k','m', 0 ), // okm = Middle Korean (10th-16th cent.)
  TRUETYPE_TAG('o','k','n', 0 ), // okn = Oki-No-Erabu
  TRUETYPE_TAG('o','k','o', 0 ), // oko = Old Korean (3rd-9th cent.)
  TRUETYPE_TAG('o','k','r', 0 ), // okr = Kirike
  TRUETYPE_TAG('o','k','s', 0 ), // oks = Oko-Eni-Osayen
  TRUETYPE_TAG('o','k','u', 0 ), // oku = Oku
  TRUETYPE_TAG('o','k','v', 0 ), // okv = Orokaiva
  TRUETYPE_TAG('o','k','x', 0 ), // okx = Okpe (Northwestern Edo)
  TRUETYPE_TAG('o','l','a', 0 ), // ola = Walungge
  TRUETYPE_TAG('o','l','d', 0 ), // old = Mochi
  TRUETYPE_TAG('o','l','e', 0 ), // ole = Olekha
  TRUETYPE_TAG('o','l','m', 0 ), // olm = Oloma
  TRUETYPE_TAG('o','l','o', 0 ), // olo = Livvi
  TRUETYPE_TAG('o','l','r', 0 ), // olr = Olrat
  TRUETYPE_TAG('o','m','a', 0 ), // oma = Omaha-Ponca
  TRUETYPE_TAG('o','m','b', 0 ), // omb = East Ambae
  TRUETYPE_TAG('o','m','c', 0 ), // omc = Mochica
  TRUETYPE_TAG('o','m','e', 0 ), // ome = Omejes
  TRUETYPE_TAG('o','m','g', 0 ), // omg = Omagua
  TRUETYPE_TAG('o','m','i', 0 ), // omi = Omi
  TRUETYPE_TAG('o','m','k', 0 ), // omk = Omok
  TRUETYPE_TAG('o','m','l', 0 ), // oml = Ombo
  TRUETYPE_TAG('o','m','n', 0 ), // omn = Minoan
  TRUETYPE_TAG('o','m','o', 0 ), // omo = Utarmbung
  TRUETYPE_TAG('o','m','p', 0 ), // omp = Old Manipuri
  TRUETYPE_TAG('o','m','q', 0 ), // omq = Oto-Manguean languages
  TRUETYPE_TAG('o','m','r', 0 ), // omr = Old Marathi
  TRUETYPE_TAG('o','m','t', 0 ), // omt = Omotik
  TRUETYPE_TAG('o','m','u', 0 ), // omu = Omurano
  TRUETYPE_TAG('o','m','v', 0 ), // omv = Omotic languages
  TRUETYPE_TAG('o','m','w', 0 ), // omw = South Tairora
  TRUETYPE_TAG('o','m','x', 0 ), // omx = Old Mon
  TRUETYPE_TAG('o','n','a', 0 ), // ona = Ona
  TRUETYPE_TAG('o','n','b', 0 ), // onb = Lingao
  TRUETYPE_TAG('o','n','e', 0 ), // one = Oneida
  TRUETYPE_TAG('o','n','g', 0 ), // ong = Olo
  TRUETYPE_TAG('o','n','i', 0 ), // oni = Onin
  TRUETYPE_TAG('o','n','j', 0 ), // onj = Onjob
  TRUETYPE_TAG('o','n','k', 0 ), // onk = Kabore One
  TRUETYPE_TAG('o','n','n', 0 ), // onn = Onobasulu
  TRUETYPE_TAG('o','n','o', 0 ), // ono = Onondaga
  TRUETYPE_TAG('o','n','p', 0 ), // onp = Sartang
  TRUETYPE_TAG('o','n','r', 0 ), // onr = Northern One
  TRUETYPE_TAG('o','n','s', 0 ), // ons = Ono
  TRUETYPE_TAG('o','n','t', 0 ), // ont = Ontenu
  TRUETYPE_TAG('o','n','u', 0 ), // onu = Unua
  TRUETYPE_TAG('o','n','w', 0 ), // onw = Old Nubian
  TRUETYPE_TAG('o','n','x', 0 ), // onx = Onin Based Pidgin
  TRUETYPE_TAG('o','o','d', 0 ), // ood = Tohono O'odham
  TRUETYPE_TAG('o','o','g', 0 ), // oog = Ong
  TRUETYPE_TAG('o','o','n', 0 ), // oon = Önge
  TRUETYPE_TAG('o','o','r', 0 ), // oor = Oorlams
  TRUETYPE_TAG('o','o','s', 0 ), // oos = Old Ossetic
  TRUETYPE_TAG('o','p','a', 0 ), // opa = Okpamheri
  TRUETYPE_TAG('o','p','k', 0 ), // opk = Kopkaka
  TRUETYPE_TAG('o','p','m', 0 ), // opm = Oksapmin
  TRUETYPE_TAG('o','p','o', 0 ), // opo = Opao
  TRUETYPE_TAG('o','p','t', 0 ), // opt = Opata
  TRUETYPE_TAG('o','p','y', 0 ), // opy = Ofayé
  TRUETYPE_TAG('o','r','a', 0 ), // ora = Oroha
  TRUETYPE_TAG('o','r','c', 0 ), // orc = Orma
  TRUETYPE_TAG('o','r','e', 0 ), // ore = Orejón
  TRUETYPE_TAG('o','r','g', 0 ), // org = Oring
  TRUETYPE_TAG('o','r','h', 0 ), // orh = Oroqen
  TRUETYPE_TAG('o','r','n', 0 ), // orn = Orang Kanaq
  TRUETYPE_TAG('o','r','o', 0 ), // oro = Orokolo
  TRUETYPE_TAG('o','r','r', 0 ), // orr = Oruma
  TRUETYPE_TAG('o','r','s', 0 ), // ors = Orang Seletar
  TRUETYPE_TAG('o','r','t', 0 ), // ort = Adivasi Oriya
  TRUETYPE_TAG('o','r','u', 0 ), // oru = Ormuri
  TRUETYPE_TAG('o','r','v', 0 ), // orv = Old Russian
  TRUETYPE_TAG('o','r','w', 0 ), // orw = Oro Win
  TRUETYPE_TAG('o','r','x', 0 ), // orx = Oro
  TRUETYPE_TAG('o','r','z', 0 ), // orz = Ormu
  TRUETYPE_TAG('o','s','a', 0 ), // osa = Osage
  TRUETYPE_TAG('o','s','c', 0 ), // osc = Oscan
  TRUETYPE_TAG('o','s','i', 0 ), // osi = Osing
  TRUETYPE_TAG('o','s','o', 0 ), // oso = Ososo
  TRUETYPE_TAG('o','s','p', 0 ), // osp = Old Spanish
  TRUETYPE_TAG('o','s','t', 0 ), // ost = Osatu
  TRUETYPE_TAG('o','s','u', 0 ), // osu = Southern One
  TRUETYPE_TAG('o','s','x', 0 ), // osx = Old Saxon
  TRUETYPE_TAG('o','t','a', 0 ), // ota = Ottoman Turkish (1500-1928)
  TRUETYPE_TAG('o','t','b', 0 ), // otb = Old Tibetan
  TRUETYPE_TAG('o','t','d', 0 ), // otd = Ot Danum
  TRUETYPE_TAG('o','t','e', 0 ), // ote = Mezquital Otomi
  TRUETYPE_TAG('o','t','i', 0 ), // oti = Oti
  TRUETYPE_TAG('o','t','k', 0 ), // otk = Old Turkish
  TRUETYPE_TAG('o','t','l', 0 ), // otl = Tilapa Otomi
  TRUETYPE_TAG('o','t','m', 0 ), // otm = Eastern Highland Otomi
  TRUETYPE_TAG('o','t','n', 0 ), // otn = Tenango Otomi
  TRUETYPE_TAG('o','t','o', 0 ), // oto = Otomian languages
  TRUETYPE_TAG('o','t','q', 0 ), // otq = Querétaro Otomi
  TRUETYPE_TAG('o','t','r', 0 ), // otr = Otoro
  TRUETYPE_TAG('o','t','s', 0 ), // ots = Estado de México Otomi
  TRUETYPE_TAG('o','t','t', 0 ), // ott = Temoaya Otomi
  TRUETYPE_TAG('o','t','u', 0 ), // otu = Otuke
  TRUETYPE_TAG('o','t','w', 0 ), // otw = Ottawa
  TRUETYPE_TAG('o','t','x', 0 ), // otx = Texcatepec Otomi
  TRUETYPE_TAG('o','t','y', 0 ), // oty = Old Tamil
  TRUETYPE_TAG('o','t','z', 0 ), // otz = Ixtenco Otomi
  TRUETYPE_TAG('o','u','a', 0 ), // oua = Tagargrent
  TRUETYPE_TAG('o','u','b', 0 ), // oub = Glio-Oubi
  TRUETYPE_TAG('o','u','e', 0 ), // oue = Oune
  TRUETYPE_TAG('o','u','i', 0 ), // oui = Old Uighur
  TRUETYPE_TAG('o','u','m', 0 ), // oum = Ouma
  TRUETYPE_TAG('o','u','n', 0 ), // oun = !O!ung
  TRUETYPE_TAG('o','w','i', 0 ), // owi = Owiniga
  TRUETYPE_TAG('o','w','l', 0 ), // owl = Old Welsh
  TRUETYPE_TAG('o','y','b', 0 ), // oyb = Oy
  TRUETYPE_TAG('o','y','d', 0 ), // oyd = Oyda
  TRUETYPE_TAG('o','y','m', 0 ), // oym = Wayampi
  TRUETYPE_TAG('o','y','y', 0 ), // oyy = Oya'oya
  TRUETYPE_TAG('o','z','m', 0 ), // ozm = Koonzime
  TRUETYPE_TAG('p','a','a', 0 ), // paa = Papuan languages
  TRUETYPE_TAG('p','a','b', 0 ), // pab = Parecís
  TRUETYPE_TAG('p','a','c', 0 ), // pac = Pacoh
  TRUETYPE_TAG('p','a','d', 0 ), // pad = Paumarí
  TRUETYPE_TAG('p','a','e', 0 ), // pae = Pagibete
  TRUETYPE_TAG('p','a','f', 0 ), // paf = Paranawát
  TRUETYPE_TAG('p','a','g', 0 ), // pag = Pangasinan
  TRUETYPE_TAG('p','a','h', 0 ), // pah = Tenharim
  TRUETYPE_TAG('p','a','i', 0 ), // pai = Pe
  TRUETYPE_TAG('p','a','k', 0 ), // pak = Parakanã
  TRUETYPE_TAG('p','a','l', 0 ), // pal = Pahlavi
  TRUETYPE_TAG('p','a','m', 0 ), // pam = Pampanga
  TRUETYPE_TAG('p','a','o', 0 ), // pao = Northern Paiute
  TRUETYPE_TAG('p','a','p', 0 ), // pap = Papiamento
  TRUETYPE_TAG('p','a','q', 0 ), // paq = Parya
  TRUETYPE_TAG('p','a','r', 0 ), // par = Panamint
  TRUETYPE_TAG('p','a','s', 0 ), // pas = Papasena
  TRUETYPE_TAG('p','a','t', 0 ), // pat = Papitalai
  TRUETYPE_TAG('p','a','u', 0 ), // pau = Palauan
  TRUETYPE_TAG('p','a','v', 0 ), // pav = Pakaásnovos
  TRUETYPE_TAG('p','a','w', 0 ), // paw = Pawnee
  TRUETYPE_TAG('p','a','x', 0 ), // pax = Pankararé
  TRUETYPE_TAG('p','a','y', 0 ), // pay = Pech
  TRUETYPE_TAG('p','a','z', 0 ), // paz = Pankararú
  TRUETYPE_TAG('p','b','b', 0 ), // pbb = Páez
  TRUETYPE_TAG('p','b','c', 0 ), // pbc = Patamona
  TRUETYPE_TAG('p','b','e', 0 ), // pbe = Mezontla Popoloca
  TRUETYPE_TAG('p','b','f', 0 ), // pbf = Coyotepec Popoloca
  TRUETYPE_TAG('p','b','g', 0 ), // pbg = Paraujano
  TRUETYPE_TAG('p','b','h', 0 ), // pbh = E'ñapa Woromaipu
  TRUETYPE_TAG('p','b','i', 0 ), // pbi = Parkwa
  TRUETYPE_TAG('p','b','l', 0 ), // pbl = Mak (Nigeria)
  TRUETYPE_TAG('p','b','n', 0 ), // pbn = Kpasam
  TRUETYPE_TAG('p','b','o', 0 ), // pbo = Papel
  TRUETYPE_TAG('p','b','p', 0 ), // pbp = Badyara
  TRUETYPE_TAG('p','b','r', 0 ), // pbr = Pangwa
  TRUETYPE_TAG('p','b','s', 0 ), // pbs = Central Pame
  TRUETYPE_TAG('p','b','t', 0 ), // pbt = Southern Pashto
  TRUETYPE_TAG('p','b','u', 0 ), // pbu = Northern Pashto
  TRUETYPE_TAG('p','b','v', 0 ), // pbv = Pnar
  TRUETYPE_TAG('p','b','y', 0 ), // pby = Pyu
  TRUETYPE_TAG('p','b','z', 0 ), // pbz = Palu
  TRUETYPE_TAG('p','c','a', 0 ), // pca = Santa Inés Ahuatempan Popoloca
  TRUETYPE_TAG('p','c','b', 0 ), // pcb = Pear
  TRUETYPE_TAG('p','c','c', 0 ), // pcc = Bouyei
  TRUETYPE_TAG('p','c','d', 0 ), // pcd = Picard
  TRUETYPE_TAG('p','c','e', 0 ), // pce = Ruching Palaung
  TRUETYPE_TAG('p','c','f', 0 ), // pcf = Paliyan
  TRUETYPE_TAG('p','c','g', 0 ), // pcg = Paniya
  TRUETYPE_TAG('p','c','h', 0 ), // pch = Pardhan
  TRUETYPE_TAG('p','c','i', 0 ), // pci = Duruwa
  TRUETYPE_TAG('p','c','j', 0 ), // pcj = Parenga
  TRUETYPE_TAG('p','c','k', 0 ), // pck = Paite Chin
  TRUETYPE_TAG('p','c','l', 0 ), // pcl = Pardhi
  TRUETYPE_TAG('p','c','m', 0 ), // pcm = Nigerian Pidgin
  TRUETYPE_TAG('p','c','n', 0 ), // pcn = Piti
  TRUETYPE_TAG('p','c','p', 0 ), // pcp = Pacahuara
  TRUETYPE_TAG('p','c','r', 0 ), // pcr = Panang
  TRUETYPE_TAG('p','c','w', 0 ), // pcw = Pyapun
  TRUETYPE_TAG('p','d','a', 0 ), // pda = Anam
  TRUETYPE_TAG('p','d','c', 0 ), // pdc = Pennsylvania German
  TRUETYPE_TAG('p','d','i', 0 ), // pdi = Pa Di
  TRUETYPE_TAG('p','d','n', 0 ), // pdn = Podena
  TRUETYPE_TAG('p','d','o', 0 ), // pdo = Padoe
  TRUETYPE_TAG('p','d','t', 0 ), // pdt = Plautdietsch
  TRUETYPE_TAG('p','d','u', 0 ), // pdu = Kayan
  TRUETYPE_TAG('p','e','a', 0 ), // pea = Peranakan Indonesian
  TRUETYPE_TAG('p','e','b', 0 ), // peb = Eastern Pomo
  TRUETYPE_TAG('p','e','d', 0 ), // ped = Mala (Papua New Guinea)
  TRUETYPE_TAG('p','e','e', 0 ), // pee = Taje
  TRUETYPE_TAG('p','e','f', 0 ), // pef = Northeastern Pomo
  TRUETYPE_TAG('p','e','g', 0 ), // peg = Pengo
  TRUETYPE_TAG('p','e','h', 0 ), // peh = Bonan
  TRUETYPE_TAG('p','e','i', 0 ), // pei = Chichimeca-Jonaz
  TRUETYPE_TAG('p','e','j', 0 ), // pej = Northern Pomo
  TRUETYPE_TAG('p','e','k', 0 ), // pek = Penchal
  TRUETYPE_TAG('p','e','l', 0 ), // pel = Pekal
  TRUETYPE_TAG('p','e','m', 0 ), // pem = Phende
  TRUETYPE_TAG('p','e','o', 0 ), // peo = Old Persian (ca. 600-400 B.C.)
  TRUETYPE_TAG('p','e','p', 0 ), // pep = Kunja
  TRUETYPE_TAG('p','e','q', 0 ), // peq = Southern Pomo
  TRUETYPE_TAG('p','e','s', 0 ), // pes = Iranian Persian
  TRUETYPE_TAG('p','e','v', 0 ), // pev = Pémono
  TRUETYPE_TAG('p','e','x', 0 ), // pex = Petats
  TRUETYPE_TAG('p','e','y', 0 ), // pey = Petjo
  TRUETYPE_TAG('p','e','z', 0 ), // pez = Eastern Penan
  TRUETYPE_TAG('p','f','a', 0 ), // pfa = Pááfang
  TRUETYPE_TAG('p','f','e', 0 ), // pfe = Peere
  TRUETYPE_TAG('p','f','l', 0 ), // pfl = Pfaelzisch
  TRUETYPE_TAG('p','g','a', 0 ), // pga = Sudanese Creole Arabic
  TRUETYPE_TAG('p','g','g', 0 ), // pgg = Pangwali
  TRUETYPE_TAG('p','g','i', 0 ), // pgi = Pagi
  TRUETYPE_TAG('p','g','k', 0 ), // pgk = Rerep
  TRUETYPE_TAG('p','g','l', 0 ), // pgl = Primitive Irish
  TRUETYPE_TAG('p','g','n', 0 ), // pgn = Paelignian
  TRUETYPE_TAG('p','g','s', 0 ), // pgs = Pangseng
  TRUETYPE_TAG('p','g','u', 0 ), // pgu = Pagu
  TRUETYPE_TAG('p','g','y', 0 ), // pgy = Pongyong
  TRUETYPE_TAG('p','h','a', 0 ), // pha = Pa-Hng
  TRUETYPE_TAG('p','h','d', 0 ), // phd = Phudagi
  TRUETYPE_TAG('p','h','g', 0 ), // phg = Phuong
  TRUETYPE_TAG('p','h','h', 0 ), // phh = Phukha
  TRUETYPE_TAG('p','h','i', 0 ), // phi = Philippine languages
  TRUETYPE_TAG('p','h','k', 0 ), // phk = Phake
  TRUETYPE_TAG('p','h','l', 0 ), // phl = Phalura
  TRUETYPE_TAG('p','h','m', 0 ), // phm = Phimbi
  TRUETYPE_TAG('p','h','n', 0 ), // phn = Phoenician
  TRUETYPE_TAG('p','h','o', 0 ), // pho = Phunoi
  TRUETYPE_TAG('p','h','q', 0 ), // phq = Phana'
  TRUETYPE_TAG('p','h','r', 0 ), // phr = Pahari-Potwari
  TRUETYPE_TAG('p','h','t', 0 ), // pht = Phu Thai
  TRUETYPE_TAG('p','h','u', 0 ), // phu = Phuan
  TRUETYPE_TAG('p','h','v', 0 ), // phv = Pahlavani
  TRUETYPE_TAG('p','h','w', 0 ), // phw = Phangduwali
  TRUETYPE_TAG('p','i','a', 0 ), // pia = Pima Bajo
  TRUETYPE_TAG('p','i','b', 0 ), // pib = Yine
  TRUETYPE_TAG('p','i','c', 0 ), // pic = Pinji
  TRUETYPE_TAG('p','i','d', 0 ), // pid = Piaroa
  TRUETYPE_TAG('p','i','e', 0 ), // pie = Piro
  TRUETYPE_TAG('p','i','f', 0 ), // pif = Pingelapese
  TRUETYPE_TAG('p','i','g', 0 ), // pig = Pisabo
  TRUETYPE_TAG('p','i','h', 0 ), // pih = Pitcairn-Norfolk
  TRUETYPE_TAG('p','i','i', 0 ), // pii = Pini
  TRUETYPE_TAG('p','i','j', 0 ), // pij = Pijao
  TRUETYPE_TAG('p','i','l', 0 ), // pil = Yom
  TRUETYPE_TAG('p','i','m', 0 ), // pim = Powhatan
  TRUETYPE_TAG('p','i','n', 0 ), // pin = Piame
  TRUETYPE_TAG('p','i','o', 0 ), // pio = Piapoco
  TRUETYPE_TAG('p','i','p', 0 ), // pip = Pero
  TRUETYPE_TAG('p','i','r', 0 ), // pir = Piratapuyo
  TRUETYPE_TAG('p','i','s', 0 ), // pis = Pijin
  TRUETYPE_TAG('p','i','t', 0 ), // pit = Pitta Pitta
  TRUETYPE_TAG('p','i','u', 0 ), // piu = Pintupi-Luritja
  TRUETYPE_TAG('p','i','v', 0 ), // piv = Pileni
  TRUETYPE_TAG('p','i','w', 0 ), // piw = Pimbwe
  TRUETYPE_TAG('p','i','x', 0 ), // pix = Piu
  TRUETYPE_TAG('p','i','y', 0 ), // piy = Piya-Kwonci
  TRUETYPE_TAG('p','i','z', 0 ), // piz = Pije
  TRUETYPE_TAG('p','j','t', 0 ), // pjt = Pitjantjatjara
  TRUETYPE_TAG('p','k','a', 0 ), // pka = Ardhamāgadhī Prākrit
  TRUETYPE_TAG('p','k','b', 0 ), // pkb = Pokomo
  TRUETYPE_TAG('p','k','c', 0 ), // pkc = Paekche
  TRUETYPE_TAG('p','k','g', 0 ), // pkg = Pak-Tong
  TRUETYPE_TAG('p','k','h', 0 ), // pkh = Pankhu
  TRUETYPE_TAG('p','k','n', 0 ), // pkn = Pakanha
  TRUETYPE_TAG('p','k','o', 0 ), // pko = Pökoot
  TRUETYPE_TAG('p','k','p', 0 ), // pkp = Pukapuka
  TRUETYPE_TAG('p','k','r', 0 ), // pkr = Attapady Kurumba
  TRUETYPE_TAG('p','k','s', 0 ), // pks = Pakistan Sign Language
  TRUETYPE_TAG('p','k','t', 0 ), // pkt = Maleng
  TRUETYPE_TAG('p','k','u', 0 ), // pku = Paku
  TRUETYPE_TAG('p','l','a', 0 ), // pla = Miani
  TRUETYPE_TAG('p','l','b', 0 ), // plb = Polonombauk
  TRUETYPE_TAG('p','l','c', 0 ), // plc = Central Palawano
  TRUETYPE_TAG('p','l','d', 0 ), // pld = Polari
  TRUETYPE_TAG('p','l','e', 0 ), // ple = Palu'e
  TRUETYPE_TAG('p','l','f', 0 ), // plf = Central Malayo-Polynesian languages
  TRUETYPE_TAG('p','l','g', 0 ), // plg = Pilagá
  TRUETYPE_TAG('p','l','h', 0 ), // plh = Paulohi
  TRUETYPE_TAG('p','l','j', 0 ), // plj = Polci
  TRUETYPE_TAG('p','l','k', 0 ), // plk = Kohistani Shina
  TRUETYPE_TAG('p','l','l', 0 ), // pll = Shwe Palaung
  TRUETYPE_TAG('p','l','n', 0 ), // pln = Palenquero
  TRUETYPE_TAG('p','l','o', 0 ), // plo = Oluta Popoluca
  TRUETYPE_TAG('p','l','p', 0 ), // plp = Palpa
  TRUETYPE_TAG('p','l','q', 0 ), // plq = Palaic
  TRUETYPE_TAG('p','l','r', 0 ), // plr = Palaka Senoufo
  TRUETYPE_TAG('p','l','s', 0 ), // pls = San Marcos Tlalcoyalco Popoloca
  TRUETYPE_TAG('p','l','t', 0 ), // plt = Plateau Malagasy
  TRUETYPE_TAG('p','l','u', 0 ), // plu = Palikúr
  TRUETYPE_TAG('p','l','v', 0 ), // plv = Southwest Palawano
  TRUETYPE_TAG('p','l','w', 0 ), // plw = Brooke's Point Palawano
  TRUETYPE_TAG('p','l','y', 0 ), // ply = Bolyu
  TRUETYPE_TAG('p','l','z', 0 ), // plz = Paluan
  TRUETYPE_TAG('p','m','a', 0 ), // pma = Paama
  TRUETYPE_TAG('p','m','b', 0 ), // pmb = Pambia
  TRUETYPE_TAG('p','m','c', 0 ), // pmc = Palumata
  TRUETYPE_TAG('p','m','e', 0 ), // pme = Pwaamei
  TRUETYPE_TAG('p','m','f', 0 ), // pmf = Pamona
  TRUETYPE_TAG('p','m','h', 0 ), // pmh = Māhārāṣṭri Prākrit
  TRUETYPE_TAG('p','m','i', 0 ), // pmi = Northern Pumi
  TRUETYPE_TAG('p','m','j', 0 ), // pmj = Southern Pumi
  TRUETYPE_TAG('p','m','k', 0 ), // pmk = Pamlico
  TRUETYPE_TAG('p','m','l', 0 ), // pml = Lingua Franca
  TRUETYPE_TAG('p','m','m', 0 ), // pmm = Pomo
  TRUETYPE_TAG('p','m','n', 0 ), // pmn = Pam
  TRUETYPE_TAG('p','m','o', 0 ), // pmo = Pom
  TRUETYPE_TAG('p','m','q', 0 ), // pmq = Northern Pame
  TRUETYPE_TAG('p','m','r', 0 ), // pmr = Paynamar
  TRUETYPE_TAG('p','m','s', 0 ), // pms = Piemontese
  TRUETYPE_TAG('p','m','t', 0 ), // pmt = Tuamotuan
  TRUETYPE_TAG('p','m','u', 0 ), // pmu = Mirpur Panjabi
  TRUETYPE_TAG('p','m','w', 0 ), // pmw = Plains Miwok
  TRUETYPE_TAG('p','m','x', 0 ), // pmx = Poumei Naga
  TRUETYPE_TAG('p','m','y', 0 ), // pmy = Papuan Malay
  TRUETYPE_TAG('p','m','z', 0 ), // pmz = Southern Pame
  TRUETYPE_TAG('p','n','a', 0 ), // pna = Punan Bah-Biau
  TRUETYPE_TAG('p','n','b', 0 ), // pnb = Western Panjabi
  TRUETYPE_TAG('p','n','c', 0 ), // pnc = Pannei
  TRUETYPE_TAG('p','n','e', 0 ), // pne = Western Penan
  TRUETYPE_TAG('p','n','g', 0 ), // png = Pongu
  TRUETYPE_TAG('p','n','h', 0 ), // pnh = Penrhyn
  TRUETYPE_TAG('p','n','i', 0 ), // pni = Aoheng
  TRUETYPE_TAG('p','n','m', 0 ), // pnm = Punan Batu 1
  TRUETYPE_TAG('p','n','n', 0 ), // pnn = Pinai-Hagahai
  TRUETYPE_TAG('p','n','o', 0 ), // pno = Panobo
  TRUETYPE_TAG('p','n','p', 0 ), // pnp = Pancana
  TRUETYPE_TAG('p','n','q', 0 ), // pnq = Pana (Burkina Faso)
  TRUETYPE_TAG('p','n','r', 0 ), // pnr = Panim
  TRUETYPE_TAG('p','n','s', 0 ), // pns = Ponosakan
  TRUETYPE_TAG('p','n','t', 0 ), // pnt = Pontic
  TRUETYPE_TAG('p','n','u', 0 ), // pnu = Jiongnai Bunu
  TRUETYPE_TAG('p','n','v', 0 ), // pnv = Pinigura
  TRUETYPE_TAG('p','n','w', 0 ), // pnw = Panytyima
  TRUETYPE_TAG('p','n','x', 0 ), // pnx = Phong-Kniang
  TRUETYPE_TAG('p','n','y', 0 ), // pny = Pinyin
  TRUETYPE_TAG('p','n','z', 0 ), // pnz = Pana (Central African Republic)
  TRUETYPE_TAG('p','o','c', 0 ), // poc = Poqomam
  TRUETYPE_TAG('p','o','d', 0 ), // pod = Ponares
  TRUETYPE_TAG('p','o','e', 0 ), // poe = San Juan Atzingo Popoloca
  TRUETYPE_TAG('p','o','f', 0 ), // pof = Poke
  TRUETYPE_TAG('p','o','g', 0 ), // pog = Potiguára
  TRUETYPE_TAG('p','o','h', 0 ), // poh = Poqomchi'
  TRUETYPE_TAG('p','o','i', 0 ), // poi = Highland Popoluca
  TRUETYPE_TAG('p','o','k', 0 ), // pok = Pokangá
  TRUETYPE_TAG('p','o','m', 0 ), // pom = Southeastern Pomo
  TRUETYPE_TAG('p','o','n', 0 ), // pon = Pohnpeian
  TRUETYPE_TAG('p','o','o', 0 ), // poo = Central Pomo
  TRUETYPE_TAG('p','o','p', 0 ), // pop = Pwapwa
  TRUETYPE_TAG('p','o','q', 0 ), // poq = Texistepec Popoluca
  TRUETYPE_TAG('p','o','s', 0 ), // pos = Sayula Popoluca
  TRUETYPE_TAG('p','o','t', 0 ), // pot = Potawatomi
  TRUETYPE_TAG('p','o','v', 0 ), // pov = Upper Guinea Crioulo
  TRUETYPE_TAG('p','o','w', 0 ), // pow = San Felipe Otlaltepec Popoloca
  TRUETYPE_TAG('p','o','x', 0 ), // pox = Polabian
  TRUETYPE_TAG('p','o','y', 0 ), // poy = Pogolo
  TRUETYPE_TAG('p','o','z', 0 ), // poz = Malayo-Polynesian languages
  TRUETYPE_TAG('p','p','a', 0 ), // ppa = Pao
  TRUETYPE_TAG('p','p','e', 0 ), // ppe = Papi
  TRUETYPE_TAG('p','p','i', 0 ), // ppi = Paipai
  TRUETYPE_TAG('p','p','k', 0 ), // ppk = Uma
  TRUETYPE_TAG('p','p','l', 0 ), // ppl = Pipil
  TRUETYPE_TAG('p','p','m', 0 ), // ppm = Papuma
  TRUETYPE_TAG('p','p','n', 0 ), // ppn = Papapana
  TRUETYPE_TAG('p','p','o', 0 ), // ppo = Folopa
  TRUETYPE_TAG('p','p','p', 0 ), // ppp = Pelende
  TRUETYPE_TAG('p','p','q', 0 ), // ppq = Pei
  TRUETYPE_TAG('p','p','r', 0 ), // ppr = Piru
  TRUETYPE_TAG('p','p','s', 0 ), // pps = San Luís Temalacayuca Popoloca
  TRUETYPE_TAG('p','p','t', 0 ), // ppt = Pare
  TRUETYPE_TAG('p','p','u', 0 ), // ppu = Papora
  TRUETYPE_TAG('p','q','a', 0 ), // pqa = Pa'a
  TRUETYPE_TAG('p','q','e', 0 ), // pqe = Eastern Malayo-Polynesian languages
  TRUETYPE_TAG('p','q','m', 0 ), // pqm = Malecite-Passamaquoddy
  TRUETYPE_TAG('p','q','w', 0 ), // pqw = Western Malayo-Polynesian languages
  TRUETYPE_TAG('p','r','a', 0 ), // pra = Prakrit languages
  TRUETYPE_TAG('p','r','b', 0 ), // prb = Lua'
  TRUETYPE_TAG('p','r','c', 0 ), // prc = Parachi
  TRUETYPE_TAG('p','r','d', 0 ), // prd = Parsi-Dari
  TRUETYPE_TAG('p','r','e', 0 ), // pre = Principense
  TRUETYPE_TAG('p','r','f', 0 ), // prf = Paranan
  TRUETYPE_TAG('p','r','g', 0 ), // prg = Prussian
  TRUETYPE_TAG('p','r','h', 0 ), // prh = Porohanon
  TRUETYPE_TAG('p','r','i', 0 ), // pri = Paicî
  TRUETYPE_TAG('p','r','k', 0 ), // prk = Parauk
  TRUETYPE_TAG('p','r','l', 0 ), // prl = Peruvian Sign Language
  TRUETYPE_TAG('p','r','m', 0 ), // prm = Kibiri
  TRUETYPE_TAG('p','r','n', 0 ), // prn = Prasuni
  TRUETYPE_TAG('p','r','o', 0 ), // pro = Old Provençal (to 1500)
  TRUETYPE_TAG('p','r','p', 0 ), // prp = Parsi
  TRUETYPE_TAG('p','r','q', 0 ), // prq = Ashéninka Perené
  TRUETYPE_TAG('p','r','r', 0 ), // prr = Puri
  TRUETYPE_TAG('p','r','s', 0 ), // prs = Dari
  TRUETYPE_TAG('p','r','t', 0 ), // prt = Phai
  TRUETYPE_TAG('p','r','u', 0 ), // pru = Puragi
  TRUETYPE_TAG('p','r','w', 0 ), // prw = Parawen
  TRUETYPE_TAG('p','r','x', 0 ), // prx = Purik
  TRUETYPE_TAG('p','r','y', 0 ), // pry = Pray 3
  TRUETYPE_TAG('p','r','z', 0 ), // prz = Providencia Sign Language
  TRUETYPE_TAG('p','s','a', 0 ), // psa = Asue Awyu
  TRUETYPE_TAG('p','s','c', 0 ), // psc = Persian Sign Language
  TRUETYPE_TAG('p','s','d', 0 ), // psd = Plains Indian Sign Language
  TRUETYPE_TAG('p','s','e', 0 ), // pse = Central Malay
  TRUETYPE_TAG('p','s','g', 0 ), // psg = Penang Sign Language
  TRUETYPE_TAG('p','s','h', 0 ), // psh = Southwest Pashayi
  TRUETYPE_TAG('p','s','i', 0 ), // psi = Southeast Pashayi
  TRUETYPE_TAG('p','s','l', 0 ), // psl = Puerto Rican Sign Language
  TRUETYPE_TAG('p','s','m', 0 ), // psm = Pauserna
  TRUETYPE_TAG('p','s','n', 0 ), // psn = Panasuan
  TRUETYPE_TAG('p','s','o', 0 ), // pso = Polish Sign Language
  TRUETYPE_TAG('p','s','p', 0 ), // psp = Philippine Sign Language
  TRUETYPE_TAG('p','s','q', 0 ), // psq = Pasi
  TRUETYPE_TAG('p','s','r', 0 ), // psr = Portuguese Sign Language
  TRUETYPE_TAG('p','s','s', 0 ), // pss = Kaulong
  TRUETYPE_TAG('p','s','t', 0 ), // pst = Central Pashto
  TRUETYPE_TAG('p','s','u', 0 ), // psu = Sauraseni Prākrit
  TRUETYPE_TAG('p','s','w', 0 ), // psw = Port Sandwich
  TRUETYPE_TAG('p','s','y', 0 ), // psy = Piscataway
  TRUETYPE_TAG('p','t','a', 0 ), // pta = Pai Tavytera
  TRUETYPE_TAG('p','t','h', 0 ), // pth = Pataxó Hã-Ha-Hãe
  TRUETYPE_TAG('p','t','i', 0 ), // pti = Pintiini
  TRUETYPE_TAG('p','t','n', 0 ), // ptn = Patani
  TRUETYPE_TAG('p','t','o', 0 ), // pto = Zo'é
  TRUETYPE_TAG('p','t','p', 0 ), // ptp = Patep
  TRUETYPE_TAG('p','t','r', 0 ), // ptr = Piamatsina
  TRUETYPE_TAG('p','t','t', 0 ), // ptt = Enrekang
  TRUETYPE_TAG('p','t','u', 0 ), // ptu = Bambam
  TRUETYPE_TAG('p','t','v', 0 ), // ptv = Port Vato
  TRUETYPE_TAG('p','t','w', 0 ), // ptw = Pentlatch
  TRUETYPE_TAG('p','t','y', 0 ), // pty = Pathiya
  TRUETYPE_TAG('p','u','a', 0 ), // pua = Western Highland Purepecha
  TRUETYPE_TAG('p','u','b', 0 ), // pub = Purum
  TRUETYPE_TAG('p','u','c', 0 ), // puc = Punan Merap
  TRUETYPE_TAG('p','u','d', 0 ), // pud = Punan Aput
  TRUETYPE_TAG('p','u','e', 0 ), // pue = Puelche
  TRUETYPE_TAG('p','u','f', 0 ), // puf = Punan Merah
  TRUETYPE_TAG('p','u','g', 0 ), // pug = Phuie
  TRUETYPE_TAG('p','u','i', 0 ), // pui = Puinave
  TRUETYPE_TAG('p','u','j', 0 ), // puj = Punan Tubu
  TRUETYPE_TAG('p','u','k', 0 ), // puk = Pu Ko
  TRUETYPE_TAG('p','u','m', 0 ), // pum = Puma
  TRUETYPE_TAG('p','u','o', 0 ), // puo = Puoc
  TRUETYPE_TAG('p','u','p', 0 ), // pup = Pulabu
  TRUETYPE_TAG('p','u','q', 0 ), // puq = Puquina
  TRUETYPE_TAG('p','u','r', 0 ), // pur = Puruborá
  TRUETYPE_TAG('p','u','t', 0 ), // put = Putoh
  TRUETYPE_TAG('p','u','u', 0 ), // puu = Punu
  TRUETYPE_TAG('p','u','w', 0 ), // puw = Puluwatese
  TRUETYPE_TAG('p','u','x', 0 ), // pux = Puare
  TRUETYPE_TAG('p','u','y', 0 ), // puy = Purisimeño
  TRUETYPE_TAG('p','u','z', 0 ), // puz = Purum Naga
  TRUETYPE_TAG('p','w','a', 0 ), // pwa = Pawaia
  TRUETYPE_TAG('p','w','b', 0 ), // pwb = Panawa
  TRUETYPE_TAG('p','w','g', 0 ), // pwg = Gapapaiwa
  TRUETYPE_TAG('p','w','m', 0 ), // pwm = Molbog
  TRUETYPE_TAG('p','w','n', 0 ), // pwn = Paiwan
  TRUETYPE_TAG('p','w','o', 0 ), // pwo = Pwo Western Karen
  TRUETYPE_TAG('p','w','r', 0 ), // pwr = Powari
  TRUETYPE_TAG('p','w','w', 0 ), // pww = Pwo Northern Karen
  TRUETYPE_TAG('p','x','m', 0 ), // pxm = Quetzaltepec Mixe
  TRUETYPE_TAG('p','y','e', 0 ), // pye = Pye Krumen
  TRUETYPE_TAG('p','y','m', 0 ), // pym = Fyam
  TRUETYPE_TAG('p','y','n', 0 ), // pyn = Poyanáwa
  TRUETYPE_TAG('p','y','s', 0 ), // pys = Paraguayan Sign Language
  TRUETYPE_TAG('p','y','u', 0 ), // pyu = Puyuma
  TRUETYPE_TAG('p','y','x', 0 ), // pyx = Pyu (Myanmar)
  TRUETYPE_TAG('p','y','y', 0 ), // pyy = Pyen
  TRUETYPE_TAG('p','z','n', 0 ), // pzn = Para Naga = Private use
  TRUETYPE_TAG('q','u','a', 0 ), // qua = Quapaw
  TRUETYPE_TAG('q','u','b', 0 ), // qub = Huallaga Huánuco Quechua
  TRUETYPE_TAG('q','u','c', 0 ), // quc = K'iche'
  TRUETYPE_TAG('q','u','d', 0 ), // qud = Calderón Highland Quichua
  TRUETYPE_TAG('q','u','f', 0 ), // quf = Lambayeque Quechua
  TRUETYPE_TAG('q','u','g', 0 ), // qug = Chimborazo Highland Quichua
  TRUETYPE_TAG('q','u','h', 0 ), // quh = South Bolivian Quechua
  TRUETYPE_TAG('q','u','i', 0 ), // qui = Quileute
  TRUETYPE_TAG('q','u','k', 0 ), // quk = Chachapoyas Quechua
  TRUETYPE_TAG('q','u','l', 0 ), // qul = North Bolivian Quechua
  TRUETYPE_TAG('q','u','m', 0 ), // qum = Sipacapense
  TRUETYPE_TAG('q','u','n', 0 ), // qun = Quinault
  TRUETYPE_TAG('q','u','p', 0 ), // qup = Southern Pastaza Quechua
  TRUETYPE_TAG('q','u','q', 0 ), // quq = Quinqui
  TRUETYPE_TAG('q','u','r', 0 ), // qur = Yanahuanca Pasco Quechua
  TRUETYPE_TAG('q','u','s', 0 ), // qus = Santiago del Estero Quichua
  TRUETYPE_TAG('q','u','v', 0 ), // quv = Sacapulteco
  TRUETYPE_TAG('q','u','w', 0 ), // quw = Tena Lowland Quichua
  TRUETYPE_TAG('q','u','x', 0 ), // qux = Yauyos Quechua
  TRUETYPE_TAG('q','u','y', 0 ), // quy = Ayacucho Quechua
  TRUETYPE_TAG('q','u','z', 0 ), // quz = Cusco Quechua
  TRUETYPE_TAG('q','v','a', 0 ), // qva = Ambo-Pasco Quechua
  TRUETYPE_TAG('q','v','c', 0 ), // qvc = Cajamarca Quechua
  TRUETYPE_TAG('q','v','e', 0 ), // qve = Eastern Apurímac Quechua
  TRUETYPE_TAG('q','v','h', 0 ), // qvh = Huamalíes-Dos de Mayo Huánuco Quechua
  TRUETYPE_TAG('q','v','i', 0 ), // qvi = Imbabura Highland Quichua
  TRUETYPE_TAG('q','v','j', 0 ), // qvj = Loja Highland Quichua
  TRUETYPE_TAG('q','v','l', 0 ), // qvl = Cajatambo North Lima Quechua
  TRUETYPE_TAG('q','v','m', 0 ), // qvm = Margos-Yarowilca-Lauricocha Quechua
  TRUETYPE_TAG('q','v','n', 0 ), // qvn = North Junín Quechua
  TRUETYPE_TAG('q','v','o', 0 ), // qvo = Napo Lowland Quechua
  TRUETYPE_TAG('q','v','p', 0 ), // qvp = Pacaraos Quechua
  TRUETYPE_TAG('q','v','s', 0 ), // qvs = San Martín Quechua
  TRUETYPE_TAG('q','v','w', 0 ), // qvw = Huaylla Wanca Quechua
  TRUETYPE_TAG('q','v','y', 0 ), // qvy = Queyu
  TRUETYPE_TAG('q','v','z', 0 ), // qvz = Northern Pastaza Quichua
  TRUETYPE_TAG('q','w','a', 0 ), // qwa = Corongo Ancash Quechua
  TRUETYPE_TAG('q','w','c', 0 ), // qwc = Classical Quechua
  TRUETYPE_TAG('q','w','e', 0 ), // qwe = Quechuan (family)
  TRUETYPE_TAG('q','w','h', 0 ), // qwh = Huaylas Ancash Quechua
  TRUETYPE_TAG('q','w','m', 0 ), // qwm = Kuman (Russia)
  TRUETYPE_TAG('q','w','s', 0 ), // qws = Sihuas Ancash Quechua
  TRUETYPE_TAG('q','w','t', 0 ), // qwt = Kwalhioqua-Tlatskanai
  TRUETYPE_TAG('q','x','a', 0 ), // qxa = Chiquián Ancash Quechua
  TRUETYPE_TAG('q','x','c', 0 ), // qxc = Chincha Quechua
  TRUETYPE_TAG('q','x','h', 0 ), // qxh = Panao Huánuco Quechua
  TRUETYPE_TAG('q','x','l', 0 ), // qxl = Salasaca Highland Quichua
  TRUETYPE_TAG('q','x','n', 0 ), // qxn = Northern Conchucos Ancash Quechua
  TRUETYPE_TAG('q','x','o', 0 ), // qxo = Southern Conchucos Ancash Quechua
  TRUETYPE_TAG('q','x','p', 0 ), // qxp = Puno Quechua
  TRUETYPE_TAG('q','x','q', 0 ), // qxq = Qashqa'i
  TRUETYPE_TAG('q','x','r', 0 ), // qxr = Cañar Highland Quichua
  TRUETYPE_TAG('q','x','s', 0 ), // qxs = Southern Qiang
  TRUETYPE_TAG('q','x','t', 0 ), // qxt = Santa Ana de Tusi Pasco Quechua
  TRUETYPE_TAG('q','x','u', 0 ), // qxu = Arequipa-La Unión Quechua
  TRUETYPE_TAG('q','x','w', 0 ), // qxw = Jauja Wanca Quechua
  TRUETYPE_TAG('q','y','a', 0 ), // qya = Quenya
  TRUETYPE_TAG('q','y','p', 0 ), // qyp = Quiripi
  TRUETYPE_TAG('r','a','a', 0 ), // raa = Dungmali
  TRUETYPE_TAG('r','a','b', 0 ), // rab = Camling
  TRUETYPE_TAG('r','a','c', 0 ), // rac = Rasawa
  TRUETYPE_TAG('r','a','d', 0 ), // rad = Rade
  TRUETYPE_TAG('r','a','f', 0 ), // raf = Western Meohang
  TRUETYPE_TAG('r','a','g', 0 ), // rag = Logooli
  TRUETYPE_TAG('r','a','h', 0 ), // rah = Rabha
  TRUETYPE_TAG('r','a','i', 0 ), // rai = Ramoaaina
  TRUETYPE_TAG('r','a','j', 0 ), // raj = Rajasthani
  TRUETYPE_TAG('r','a','k', 0 ), // rak = Tulu-Bohuai
  TRUETYPE_TAG('r','a','l', 0 ), // ral = Ralte
  TRUETYPE_TAG('r','a','m', 0 ), // ram = Canela
  TRUETYPE_TAG('r','a','n', 0 ), // ran = Riantana
  TRUETYPE_TAG('r','a','o', 0 ), // rao = Rao
  TRUETYPE_TAG('r','a','p', 0 ), // rap = Rapanui
  TRUETYPE_TAG('r','a','q', 0 ), // raq = Saam
  TRUETYPE_TAG('r','a','r', 0 ), // rar = Rarotongan
  TRUETYPE_TAG('r','a','s', 0 ), // ras = Tegali
  TRUETYPE_TAG('r','a','t', 0 ), // rat = Razajerdi
  TRUETYPE_TAG('r','a','u', 0 ), // rau = Raute
  TRUETYPE_TAG('r','a','v', 0 ), // rav = Sampang
  TRUETYPE_TAG('r','a','w', 0 ), // raw = Rawang
  TRUETYPE_TAG('r','a','x', 0 ), // rax = Rang
  TRUETYPE_TAG('r','a','y', 0 ), // ray = Rapa
  TRUETYPE_TAG('r','a','z', 0 ), // raz = Rahambuu
  TRUETYPE_TAG('r','b','b', 0 ), // rbb = Rumai Palaung
  TRUETYPE_TAG('r','b','k', 0 ), // rbk = Northern Bontok
  TRUETYPE_TAG('r','b','l', 0 ), // rbl = Miraya Bikol
  TRUETYPE_TAG('r','c','f', 0 ), // rcf = Réunion Creole French
  TRUETYPE_TAG('r','d','b', 0 ), // rdb = Rudbari
  TRUETYPE_TAG('r','e','a', 0 ), // rea = Rerau
  TRUETYPE_TAG('r','e','b', 0 ), // reb = Rembong
  TRUETYPE_TAG('r','e','e', 0 ), // ree = Rejang Kayan
  TRUETYPE_TAG('r','e','g', 0 ), // reg = Kara (Tanzania)
  TRUETYPE_TAG('r','e','i', 0 ), // rei = Reli
  TRUETYPE_TAG('r','e','j', 0 ), // rej = Rejang
  TRUETYPE_TAG('r','e','l', 0 ), // rel = Rendille
  TRUETYPE_TAG('r','e','m', 0 ), // rem = Remo
  TRUETYPE_TAG('r','e','n', 0 ), // ren = Rengao
  TRUETYPE_TAG('r','e','r', 0 ), // rer = Rer Bare
  TRUETYPE_TAG('r','e','s', 0 ), // res = Reshe
  TRUETYPE_TAG('r','e','t', 0 ), // ret = Retta
  TRUETYPE_TAG('r','e','y', 0 ), // rey = Reyesano
  TRUETYPE_TAG('r','g','a', 0 ), // rga = Roria
  TRUETYPE_TAG('r','g','e', 0 ), // rge = Romano-Greek
  TRUETYPE_TAG('r','g','k', 0 ), // rgk = Rangkas
  TRUETYPE_TAG('r','g','n', 0 ), // rgn = Romagnol
  TRUETYPE_TAG('r','g','r', 0 ), // rgr = Resígaro
  TRUETYPE_TAG('r','g','s', 0 ), // rgs = Southern Roglai
  TRUETYPE_TAG('r','g','u', 0 ), // rgu = Ringgou
  TRUETYPE_TAG('r','h','g', 0 ), // rhg = Rohingya
  TRUETYPE_TAG('r','h','p', 0 ), // rhp = Yahang
  TRUETYPE_TAG('r','i','a', 0 ), // ria = Riang (India)
  TRUETYPE_TAG('r','i','e', 0 ), // rie = Rien
  TRUETYPE_TAG('r','i','f', 0 ), // rif = Tarifit
  TRUETYPE_TAG('r','i','l', 0 ), // ril = Riang (Myanmar)
  TRUETYPE_TAG('r','i','m', 0 ), // rim = Nyaturu
  TRUETYPE_TAG('r','i','n', 0 ), // rin = Nungu
  TRUETYPE_TAG('r','i','r', 0 ), // rir = Ribun
  TRUETYPE_TAG('r','i','t', 0 ), // rit = Ritarungo
  TRUETYPE_TAG('r','i','u', 0 ), // riu = Riung
  TRUETYPE_TAG('r','j','g', 0 ), // rjg = Rajong
  TRUETYPE_TAG('r','j','i', 0 ), // rji = Raji
  TRUETYPE_TAG('r','j','s', 0 ), // rjs = Rajbanshi
  TRUETYPE_TAG('r','k','a', 0 ), // rka = Kraol
  TRUETYPE_TAG('r','k','b', 0 ), // rkb = Rikbaktsa
  TRUETYPE_TAG('r','k','h', 0 ), // rkh = Rakahanga-Manihiki
  TRUETYPE_TAG('r','k','i', 0 ), // rki = Rakhine
  TRUETYPE_TAG('r','k','m', 0 ), // rkm = Marka
  TRUETYPE_TAG('r','k','t', 0 ), // rkt = Rangpuri
  TRUETYPE_TAG('r','m','a', 0 ), // rma = Rama
  TRUETYPE_TAG('r','m','b', 0 ), // rmb = Rembarunga
  TRUETYPE_TAG('r','m','c', 0 ), // rmc = Carpathian Romani
  TRUETYPE_TAG('r','m','d', 0 ), // rmd = Traveller Danish
  TRUETYPE_TAG('r','m','e', 0 ), // rme = Angloromani
  TRUETYPE_TAG('r','m','f', 0 ), // rmf = Kalo Finnish Romani
  TRUETYPE_TAG('r','m','g', 0 ), // rmg = Traveller Norwegian
  TRUETYPE_TAG('r','m','h', 0 ), // rmh = Murkim
  TRUETYPE_TAG('r','m','i', 0 ), // rmi = Lomavren
  TRUETYPE_TAG('r','m','k', 0 ), // rmk = Romkun
  TRUETYPE_TAG('r','m','l', 0 ), // rml = Baltic Romani
  TRUETYPE_TAG('r','m','m', 0 ), // rmm = Roma
  TRUETYPE_TAG('r','m','n', 0 ), // rmn = Balkan Romani
  TRUETYPE_TAG('r','m','o', 0 ), // rmo = Sinte Romani
  TRUETYPE_TAG('r','m','p', 0 ), // rmp = Rempi
  TRUETYPE_TAG('r','m','q', 0 ), // rmq = Caló
  TRUETYPE_TAG('r','m','r', 0 ), // rmr = Caló
  TRUETYPE_TAG('r','m','s', 0 ), // rms = Romanian Sign Language
  TRUETYPE_TAG('r','m','t', 0 ), // rmt = Domari
  TRUETYPE_TAG('r','m','u', 0 ), // rmu = Tavringer Romani
  TRUETYPE_TAG('r','m','v', 0 ), // rmv = Romanova
  TRUETYPE_TAG('r','m','w', 0 ), // rmw = Welsh Romani
  TRUETYPE_TAG('r','m','x', 0 ), // rmx = Romam
  TRUETYPE_TAG('r','m','y', 0 ), // rmy = Vlax Romani
  TRUETYPE_TAG('r','m','z', 0 ), // rmz = Marma
  TRUETYPE_TAG('r','n','a', 0 ), // rna = Runa
  TRUETYPE_TAG('r','n','d', 0 ), // rnd = Ruund
  TRUETYPE_TAG('r','n','g', 0 ), // rng = Ronga
  TRUETYPE_TAG('r','n','l', 0 ), // rnl = Ranglong
  TRUETYPE_TAG('r','n','n', 0 ), // rnn = Roon
  TRUETYPE_TAG('r','n','p', 0 ), // rnp = Rongpo
  TRUETYPE_TAG('r','n','w', 0 ), // rnw = Rungwa
  TRUETYPE_TAG('r','o','a', 0 ), // roa = Romance languages
  TRUETYPE_TAG('r','o','b', 0 ), // rob = Tae'
  TRUETYPE_TAG('r','o','c', 0 ), // roc = Cacgia Roglai
  TRUETYPE_TAG('r','o','d', 0 ), // rod = Rogo
  TRUETYPE_TAG('r','o','e', 0 ), // roe = Ronji
  TRUETYPE_TAG('r','o','f', 0 ), // rof = Rombo
  TRUETYPE_TAG('r','o','g', 0 ), // rog = Northern Roglai
  TRUETYPE_TAG('r','o','l', 0 ), // rol = Romblomanon
  TRUETYPE_TAG('r','o','m', 0 ), // rom = Romany
  TRUETYPE_TAG('r','o','o', 0 ), // roo = Rotokas
  TRUETYPE_TAG('r','o','p', 0 ), // rop = Kriol
  TRUETYPE_TAG('r','o','r', 0 ), // ror = Rongga
  TRUETYPE_TAG('r','o','u', 0 ), // rou = Runga
  TRUETYPE_TAG('r','o','w', 0 ), // row = Dela-Oenale
  TRUETYPE_TAG('r','p','n', 0 ), // rpn = Repanbitip
  TRUETYPE_TAG('r','p','t', 0 ), // rpt = Rapting
  TRUETYPE_TAG('r','r','i', 0 ), // rri = Ririo
  TRUETYPE_TAG('r','r','o', 0 ), // rro = Waima
  TRUETYPE_TAG('r','s','b', 0 ), // rsb = Romano-Serbian
  TRUETYPE_TAG('r','s','i', 0 ), // rsi = Rennellese Sign Language
  TRUETYPE_TAG('r','s','l', 0 ), // rsl = Russian Sign Language
  TRUETYPE_TAG('r','t','h', 0 ), // rth = Ratahan
  TRUETYPE_TAG('r','t','m', 0 ), // rtm = Rotuman
  TRUETYPE_TAG('r','t','w', 0 ), // rtw = Rathawi
  TRUETYPE_TAG('r','u','b', 0 ), // rub = Gungu
  TRUETYPE_TAG('r','u','c', 0 ), // ruc = Ruuli
  TRUETYPE_TAG('r','u','e', 0 ), // rue = Rusyn
  TRUETYPE_TAG('r','u','f', 0 ), // ruf = Luguru
  TRUETYPE_TAG('r','u','g', 0 ), // rug = Roviana
  TRUETYPE_TAG('r','u','h', 0 ), // ruh = Ruga
  TRUETYPE_TAG('r','u','i', 0 ), // rui = Rufiji
  TRUETYPE_TAG('r','u','k', 0 ), // ruk = Che
  TRUETYPE_TAG('r','u','o', 0 ), // ruo = Istro Romanian
  TRUETYPE_TAG('r','u','p', 0 ), // rup = Macedo-Romanian
  TRUETYPE_TAG('r','u','q', 0 ), // ruq = Megleno Romanian
  TRUETYPE_TAG('r','u','t', 0 ), // rut = Rutul
  TRUETYPE_TAG('r','u','u', 0 ), // ruu = Lanas Lobu
  TRUETYPE_TAG('r','u','y', 0 ), // ruy = Mala (Nigeria)
  TRUETYPE_TAG('r','u','z', 0 ), // ruz = Ruma
  TRUETYPE_TAG('r','w','a', 0 ), // rwa = Rawo
  TRUETYPE_TAG('r','w','k', 0 ), // rwk = Rwa
  TRUETYPE_TAG('r','w','m', 0 ), // rwm = Amba (Uganda)
  TRUETYPE_TAG('r','w','o', 0 ), // rwo = Rawa
  TRUETYPE_TAG('r','w','r', 0 ), // rwr = Marwari (India)
  TRUETYPE_TAG('r','y','n', 0 ), // ryn = Northern Amami-Oshima
  TRUETYPE_TAG('r','y','s', 0 ), // rys = Yaeyama
  TRUETYPE_TAG('r','y','u', 0 ), // ryu = Central Okinawan
  TRUETYPE_TAG('s','a','a', 0 ), // saa = Saba
  TRUETYPE_TAG('s','a','b', 0 ), // sab = Buglere
  TRUETYPE_TAG('s','a','c', 0 ), // sac = Meskwaki
  TRUETYPE_TAG('s','a','d', 0 ), // sad = Sandawe
  TRUETYPE_TAG('s','a','e', 0 ), // sae = Sabanê
  TRUETYPE_TAG('s','a','f', 0 ), // saf = Safaliba
  TRUETYPE_TAG('s','a','h', 0 ), // sah = Yakut
  TRUETYPE_TAG('s','a','i', 0 ), // sai = South American Indian languages
  TRUETYPE_TAG('s','a','j', 0 ), // saj = Sahu
  TRUETYPE_TAG('s','a','k', 0 ), // sak = Sake
  TRUETYPE_TAG('s','a','l', 0 ), // sal = Salishan languages
  TRUETYPE_TAG('s','a','m', 0 ), // sam = Samaritan Aramaic
  TRUETYPE_TAG('s','a','o', 0 ), // sao = Sause
  TRUETYPE_TAG('s','a','p', 0 ), // sap = Sanapaná
  TRUETYPE_TAG('s','a','q', 0 ), // saq = Samburu
  TRUETYPE_TAG('s','a','r', 0 ), // sar = Saraveca
  TRUETYPE_TAG('s','a','s', 0 ), // sas = Sasak
  TRUETYPE_TAG('s','a','t', 0 ), // sat = Santali
  TRUETYPE_TAG('s','a','u', 0 ), // sau = Saleman
  TRUETYPE_TAG('s','a','v', 0 ), // sav = Saafi-Saafi
  TRUETYPE_TAG('s','a','w', 0 ), // saw = Sawi
  TRUETYPE_TAG('s','a','x', 0 ), // sax = Sa
  TRUETYPE_TAG('s','a','y', 0 ), // say = Saya
  TRUETYPE_TAG('s','a','z', 0 ), // saz = Saurashtra
  TRUETYPE_TAG('s','b','a', 0 ), // sba = Ngambay
  TRUETYPE_TAG('s','b','b', 0 ), // sbb = Simbo
  TRUETYPE_TAG('s','b','c', 0 ), // sbc = Kele (Papua New Guinea)
  TRUETYPE_TAG('s','b','d', 0 ), // sbd = Southern Samo
  TRUETYPE_TAG('s','b','e', 0 ), // sbe = Saliba
  TRUETYPE_TAG('s','b','f', 0 ), // sbf = Shabo
  TRUETYPE_TAG('s','b','g', 0 ), // sbg = Seget
  TRUETYPE_TAG('s','b','h', 0 ), // sbh = Sori-Harengan
  TRUETYPE_TAG('s','b','i', 0 ), // sbi = Seti
  TRUETYPE_TAG('s','b','j', 0 ), // sbj = Surbakhal
  TRUETYPE_TAG('s','b','k', 0 ), // sbk = Safwa
  TRUETYPE_TAG('s','b','l', 0 ), // sbl = Botolan Sambal
  TRUETYPE_TAG('s','b','m', 0 ), // sbm = Sagala
  TRUETYPE_TAG('s','b','n', 0 ), // sbn = Sindhi Bhil
  TRUETYPE_TAG('s','b','o', 0 ), // sbo = Sabüm
  TRUETYPE_TAG('s','b','p', 0 ), // sbp = Sangu (Tanzania)
  TRUETYPE_TAG('s','b','q', 0 ), // sbq = Sileibi
  TRUETYPE_TAG('s','b','r', 0 ), // sbr = Sembakung Murut
  TRUETYPE_TAG('s','b','s', 0 ), // sbs = Subiya
  TRUETYPE_TAG('s','b','t', 0 ), // sbt = Kimki
  TRUETYPE_TAG('s','b','u', 0 ), // sbu = Stod Bhoti
  TRUETYPE_TAG('s','b','v', 0 ), // sbv = Sabine
  TRUETYPE_TAG('s','b','w', 0 ), // sbw = Simba
  TRUETYPE_TAG('s','b','x', 0 ), // sbx = Seberuang
  TRUETYPE_TAG('s','b','y', 0 ), // sby = Soli
  TRUETYPE_TAG('s','b','z', 0 ), // sbz = Sara Kaba
  TRUETYPE_TAG('s','c','a', 0 ), // sca = Sansu
  TRUETYPE_TAG('s','c','b', 0 ), // scb = Chut
  TRUETYPE_TAG('s','c','e', 0 ), // sce = Dongxiang
  TRUETYPE_TAG('s','c','f', 0 ), // scf = San Miguel Creole French
  TRUETYPE_TAG('s','c','g', 0 ), // scg = Sanggau
  TRUETYPE_TAG('s','c','h', 0 ), // sch = Sakachep
  TRUETYPE_TAG('s','c','i', 0 ), // sci = Sri Lankan Creole Malay
  TRUETYPE_TAG('s','c','k', 0 ), // sck = Sadri
  TRUETYPE_TAG('s','c','l', 0 ), // scl = Shina
  TRUETYPE_TAG('s','c','n', 0 ), // scn = Sicilian
  TRUETYPE_TAG('s','c','o', 0 ), // sco = Scots
  TRUETYPE_TAG('s','c','p', 0 ), // scp = Helambu Sherpa
  TRUETYPE_TAG('s','c','q', 0 ), // scq = Sa'och
  TRUETYPE_TAG('s','c','s', 0 ), // scs = North Slavey
  TRUETYPE_TAG('s','c','u', 0 ), // scu = Shumcho
  TRUETYPE_TAG('s','c','v', 0 ), // scv = Sheni
  TRUETYPE_TAG('s','c','w', 0 ), // scw = Sha
  TRUETYPE_TAG('s','c','x', 0 ), // scx = Sicel
  TRUETYPE_TAG('s','d','a', 0 ), // sda = Toraja-Sa'dan
  TRUETYPE_TAG('s','d','b', 0 ), // sdb = Shabak
  TRUETYPE_TAG('s','d','c', 0 ), // sdc = Sassarese Sardinian
  TRUETYPE_TAG('s','d','e', 0 ), // sde = Surubu
  TRUETYPE_TAG('s','d','f', 0 ), // sdf = Sarli
  TRUETYPE_TAG('s','d','g', 0 ), // sdg = Savi
  TRUETYPE_TAG('s','d','h', 0 ), // sdh = Southern Kurdish
  TRUETYPE_TAG('s','d','j', 0 ), // sdj = Suundi
  TRUETYPE_TAG('s','d','k', 0 ), // sdk = Sos Kundi
  TRUETYPE_TAG('s','d','l', 0 ), // sdl = Saudi Arabian Sign Language
  TRUETYPE_TAG('s','d','m', 0 ), // sdm = Semandang
  TRUETYPE_TAG('s','d','n', 0 ), // sdn = Gallurese Sardinian
  TRUETYPE_TAG('s','d','o', 0 ), // sdo = Bukar-Sadung Bidayuh
  TRUETYPE_TAG('s','d','p', 0 ), // sdp = Sherdukpen
  TRUETYPE_TAG('s','d','r', 0 ), // sdr = Oraon Sadri
  TRUETYPE_TAG('s','d','s', 0 ), // sds = Sened
  TRUETYPE_TAG('s','d','t', 0 ), // sdt = Shuadit
  TRUETYPE_TAG('s','d','u', 0 ), // sdu = Sarudu
  TRUETYPE_TAG('s','d','v', 0 ), // sdv = Eastern Sudanic languages
  TRUETYPE_TAG('s','d','x', 0 ), // sdx = Sibu Melanau
  TRUETYPE_TAG('s','d','z', 0 ), // sdz = Sallands
  TRUETYPE_TAG('s','e','a', 0 ), // sea = Semai
  TRUETYPE_TAG('s','e','b', 0 ), // seb = Shempire Senoufo
  TRUETYPE_TAG('s','e','c', 0 ), // sec = Sechelt
  TRUETYPE_TAG('s','e','d', 0 ), // sed = Sedang
  TRUETYPE_TAG('s','e','e', 0 ), // see = Seneca
  TRUETYPE_TAG('s','e','f', 0 ), // sef = Cebaara Senoufo
  TRUETYPE_TAG('s','e','g', 0 ), // seg = Segeju
  TRUETYPE_TAG('s','e','h', 0 ), // seh = Sena
  TRUETYPE_TAG('s','e','i', 0 ), // sei = Seri
  TRUETYPE_TAG('s','e','j', 0 ), // sej = Sene
  TRUETYPE_TAG('s','e','k', 0 ), // sek = Sekani
  TRUETYPE_TAG('s','e','l', 0 ), // sel = Selkup
  TRUETYPE_TAG('s','e','m', 0 ), // sem = Semitic languages
  TRUETYPE_TAG('s','e','n', 0 ), // sen = Nanerigé Sénoufo
  TRUETYPE_TAG('s','e','o', 0 ), // seo = Suarmin
  TRUETYPE_TAG('s','e','p', 0 ), // sep = Sìcìté Sénoufo
  TRUETYPE_TAG('s','e','q', 0 ), // seq = Senara Sénoufo
  TRUETYPE_TAG('s','e','r', 0 ), // ser = Serrano
  TRUETYPE_TAG('s','e','s', 0 ), // ses = Koyraboro Senni Songhai
  TRUETYPE_TAG('s','e','t', 0 ), // set = Sentani
  TRUETYPE_TAG('s','e','u', 0 ), // seu = Serui-Laut
  TRUETYPE_TAG('s','e','v', 0 ), // sev = Nyarafolo Senoufo
  TRUETYPE_TAG('s','e','w', 0 ), // sew = Sewa Bay
  TRUETYPE_TAG('s','e','y', 0 ), // sey = Secoya
  TRUETYPE_TAG('s','e','z', 0 ), // sez = Senthang Chin
  TRUETYPE_TAG('s','f','b', 0 ), // sfb = Langue des signes de Belgique Francophone
  TRUETYPE_TAG('s','f','m', 0 ), // sfm = Small Flowery Miao
  TRUETYPE_TAG('s','f','s', 0 ), // sfs = South African Sign Language
  TRUETYPE_TAG('s','f','w', 0 ), // sfw = Sehwi
  TRUETYPE_TAG('s','g','a', 0 ), // sga = Old Irish (to 900)
  TRUETYPE_TAG('s','g','b', 0 ), // sgb = Mag-antsi Ayta
  TRUETYPE_TAG('s','g','c', 0 ), // sgc = Kipsigis
  TRUETYPE_TAG('s','g','d', 0 ), // sgd = Surigaonon
  TRUETYPE_TAG('s','g','e', 0 ), // sge = Segai
  TRUETYPE_TAG('s','g','g', 0 ), // sgg = Swiss-German Sign Language
  TRUETYPE_TAG('s','g','h', 0 ), // sgh = Shughni
  TRUETYPE_TAG('s','g','i', 0 ), // sgi = Suga
  TRUETYPE_TAG('s','g','k', 0 ), // sgk = Sangkong
  TRUETYPE_TAG('s','g','l', 0 ), // sgl = Sanglechi-Ishkashimi
  TRUETYPE_TAG('s','g','m', 0 ), // sgm = Singa
  TRUETYPE_TAG('s','g','n', 0 ), // sgn = Sign languages
  TRUETYPE_TAG('s','g','o', 0 ), // sgo = Songa
  TRUETYPE_TAG('s','g','p', 0 ), // sgp = Singpho
  TRUETYPE_TAG('s','g','r', 0 ), // sgr = Sangisari
  TRUETYPE_TAG('s','g','s', 0 ), // sgs = Samogitian
  TRUETYPE_TAG('s','g','t', 0 ), // sgt = Brokpake
  TRUETYPE_TAG('s','g','u', 0 ), // sgu = Salas
  TRUETYPE_TAG('s','g','w', 0 ), // sgw = Sebat Bet Gurage
  TRUETYPE_TAG('s','g','x', 0 ), // sgx = Sierra Leone Sign Language
  TRUETYPE_TAG('s','g','y', 0 ), // sgy = Sanglechi
  TRUETYPE_TAG('s','g','z', 0 ), // sgz = Sursurunga
  TRUETYPE_TAG('s','h','a', 0 ), // sha = Shall-Zwall
  TRUETYPE_TAG('s','h','b', 0 ), // shb = Ninam
  TRUETYPE_TAG('s','h','c', 0 ), // shc = Sonde
  TRUETYPE_TAG('s','h','d', 0 ), // shd = Kundal Shahi
  TRUETYPE_TAG('s','h','e', 0 ), // she = Sheko
  TRUETYPE_TAG('s','h','g', 0 ), // shg = Shua
  TRUETYPE_TAG('s','h','h', 0 ), // shh = Shoshoni
  TRUETYPE_TAG('s','h','i', 0 ), // shi = Tachelhit
  TRUETYPE_TAG('s','h','j', 0 ), // shj = Shatt
  TRUETYPE_TAG('s','h','k', 0 ), // shk = Shilluk
  TRUETYPE_TAG('s','h','l', 0 ), // shl = Shendu
  TRUETYPE_TAG('s','h','m', 0 ), // shm = Shahrudi
  TRUETYPE_TAG('s','h','n', 0 ), // shn = Shan
  TRUETYPE_TAG('s','h','o', 0 ), // sho = Shanga
  TRUETYPE_TAG('s','h','p', 0 ), // shp = Shipibo-Conibo
  TRUETYPE_TAG('s','h','q', 0 ), // shq = Sala
  TRUETYPE_TAG('s','h','r', 0 ), // shr = Shi
  TRUETYPE_TAG('s','h','s', 0 ), // shs = Shuswap
  TRUETYPE_TAG('s','h','t', 0 ), // sht = Shasta
  TRUETYPE_TAG('s','h','u', 0 ), // shu = Chadian Arabic
  TRUETYPE_TAG('s','h','v', 0 ), // shv = Shehri
  TRUETYPE_TAG('s','h','w', 0 ), // shw = Shwai
  TRUETYPE_TAG('s','h','x', 0 ), // shx = She
  TRUETYPE_TAG('s','h','y', 0 ), // shy = Tachawit
  TRUETYPE_TAG('s','h','z', 0 ), // shz = Syenara Senoufo
  TRUETYPE_TAG('s','i','a', 0 ), // sia = Akkala Sami
  TRUETYPE_TAG('s','i','b', 0 ), // sib = Sebop
  TRUETYPE_TAG('s','i','d', 0 ), // sid = Sidamo
  TRUETYPE_TAG('s','i','e', 0 ), // sie = Simaa
  TRUETYPE_TAG('s','i','f', 0 ), // sif = Siamou
  TRUETYPE_TAG('s','i','g', 0 ), // sig = Paasaal
  TRUETYPE_TAG('s','i','h', 0 ), // sih = Zire
  TRUETYPE_TAG('s','i','i', 0 ), // sii = Shom Peng
  TRUETYPE_TAG('s','i','j', 0 ), // sij = Numbami
  TRUETYPE_TAG('s','i','k', 0 ), // sik = Sikiana
  TRUETYPE_TAG('s','i','l', 0 ), // sil = Tumulung Sisaala
  TRUETYPE_TAG('s','i','m', 0 ), // sim = Mende (Papua New Guinea)
  TRUETYPE_TAG('s','i','o', 0 ), // sio = Siouan languages
  TRUETYPE_TAG('s','i','p', 0 ), // sip = Sikkimese
  TRUETYPE_TAG('s','i','q', 0 ), // siq = Sonia
  TRUETYPE_TAG('s','i','r', 0 ), // sir = Siri
  TRUETYPE_TAG('s','i','s', 0 ), // sis = Siuslaw
  TRUETYPE_TAG('s','i','t', 0 ), // sit = Sino-Tibetan languages
  TRUETYPE_TAG('s','i','u', 0 ), // siu = Sinagen
  TRUETYPE_TAG('s','i','v', 0 ), // siv = Sumariup
  TRUETYPE_TAG('s','i','w', 0 ), // siw = Siwai
  TRUETYPE_TAG('s','i','x', 0 ), // six = Sumau
  TRUETYPE_TAG('s','i','y', 0 ), // siy = Sivandi
  TRUETYPE_TAG('s','i','z', 0 ), // siz = Siwi
  TRUETYPE_TAG('s','j','a', 0 ), // sja = Epena
  TRUETYPE_TAG('s','j','b', 0 ), // sjb = Sajau Basap
  TRUETYPE_TAG('s','j','d', 0 ), // sjd = Kildin Sami
  TRUETYPE_TAG('s','j','e', 0 ), // sje = Pite Sami
  TRUETYPE_TAG('s','j','g', 0 ), // sjg = Assangori
  TRUETYPE_TAG('s','j','k', 0 ), // sjk = Kemi Sami
  TRUETYPE_TAG('s','j','l', 0 ), // sjl = Sajalong
  TRUETYPE_TAG('s','j','m', 0 ), // sjm = Mapun
  TRUETYPE_TAG('s','j','n', 0 ), // sjn = Sindarin
  TRUETYPE_TAG('s','j','o', 0 ), // sjo = Xibe
  TRUETYPE_TAG('s','j','p', 0 ), // sjp = Surjapuri
  TRUETYPE_TAG('s','j','r', 0 ), // sjr = Siar-Lak
  TRUETYPE_TAG('s','j','s', 0 ), // sjs = Senhaja De Srair
  TRUETYPE_TAG('s','j','t', 0 ), // sjt = Ter Sami
  TRUETYPE_TAG('s','j','u', 0 ), // sju = Ume Sami
  TRUETYPE_TAG('s','j','w', 0 ), // sjw = Shawnee
  TRUETYPE_TAG('s','k','a', 0 ), // ska = Skagit
  TRUETYPE_TAG('s','k','b', 0 ), // skb = Saek
  TRUETYPE_TAG('s','k','c', 0 ), // skc = Sauk
  TRUETYPE_TAG('s','k','d', 0 ), // skd = Southern Sierra Miwok
  TRUETYPE_TAG('s','k','e', 0 ), // ske = Seke (Vanuatu)
  TRUETYPE_TAG('s','k','f', 0 ), // skf = Sakirabiá
  TRUETYPE_TAG('s','k','g', 0 ), // skg = Sakalava Malagasy
  TRUETYPE_TAG('s','k','h', 0 ), // skh = Sikule
  TRUETYPE_TAG('s','k','i', 0 ), // ski = Sika
  TRUETYPE_TAG('s','k','j', 0 ), // skj = Seke (Nepal)
  TRUETYPE_TAG('s','k','k', 0 ), // skk = Sok
  TRUETYPE_TAG('s','k','m', 0 ), // skm = Sakam
  TRUETYPE_TAG('s','k','n', 0 ), // skn = Kolibugan Subanon
  TRUETYPE_TAG('s','k','o', 0 ), // sko = Seko Tengah
  TRUETYPE_TAG('s','k','p', 0 ), // skp = Sekapan
  TRUETYPE_TAG('s','k','q', 0 ), // skq = Sininkere
  TRUETYPE_TAG('s','k','r', 0 ), // skr = Seraiki
  TRUETYPE_TAG('s','k','s', 0 ), // sks = Maia
  TRUETYPE_TAG('s','k','t', 0 ), // skt = Sakata
  TRUETYPE_TAG('s','k','u', 0 ), // sku = Sakao
  TRUETYPE_TAG('s','k','v', 0 ), // skv = Skou
  TRUETYPE_TAG('s','k','w', 0 ), // skw = Skepi Creole Dutch
  TRUETYPE_TAG('s','k','x', 0 ), // skx = Seko Padang
  TRUETYPE_TAG('s','k','y', 0 ), // sky = Sikaiana
  TRUETYPE_TAG('s','k','z', 0 ), // skz = Sekar
  TRUETYPE_TAG('s','l','a', 0 ), // sla = Slavic languages
  TRUETYPE_TAG('s','l','c', 0 ), // slc = Sáliba
  TRUETYPE_TAG('s','l','d', 0 ), // sld = Sissala
  TRUETYPE_TAG('s','l','e', 0 ), // sle = Sholaga
  TRUETYPE_TAG('s','l','f', 0 ), // slf = Swiss-Italian Sign Language
  TRUETYPE_TAG('s','l','g', 0 ), // slg = Selungai Murut
  TRUETYPE_TAG('s','l','h', 0 ), // slh = Southern Puget Sound Salish
  TRUETYPE_TAG('s','l','i', 0 ), // sli = Lower Silesian
  TRUETYPE_TAG('s','l','j', 0 ), // slj = Salumá
  TRUETYPE_TAG('s','l','l', 0 ), // sll = Salt-Yui
  TRUETYPE_TAG('s','l','m', 0 ), // slm = Pangutaran Sama
  TRUETYPE_TAG('s','l','n', 0 ), // sln = Salinan
  TRUETYPE_TAG('s','l','p', 0 ), // slp = Lamaholot
  TRUETYPE_TAG('s','l','q', 0 ), // slq = Salchuq
  TRUETYPE_TAG('s','l','r', 0 ), // slr = Salar
  TRUETYPE_TAG('s','l','s', 0 ), // sls = Singapore Sign Language
  TRUETYPE_TAG('s','l','t', 0 ), // slt = Sila
  TRUETYPE_TAG('s','l','u', 0 ), // slu = Selaru
  TRUETYPE_TAG('s','l','w', 0 ), // slw = Sialum
  TRUETYPE_TAG('s','l','x', 0 ), // slx = Salampasu
  TRUETYPE_TAG('s','l','y', 0 ), // sly = Selayar
  TRUETYPE_TAG('s','l','z', 0 ), // slz = Ma'ya
  TRUETYPE_TAG('s','m','a', 0 ), // sma = Southern Sami
  TRUETYPE_TAG('s','m','b', 0 ), // smb = Simbari
  TRUETYPE_TAG('s','m','c', 0 ), // smc = Som
  TRUETYPE_TAG('s','m','d', 0 ), // smd = Sama
  TRUETYPE_TAG('s','m','f', 0 ), // smf = Auwe
  TRUETYPE_TAG('s','m','g', 0 ), // smg = Simbali
  TRUETYPE_TAG('s','m','h', 0 ), // smh = Samei
  TRUETYPE_TAG('s','m','i', 0 ), // smi = Sami languages
  TRUETYPE_TAG('s','m','j', 0 ), // smj = Lule Sami
  TRUETYPE_TAG('s','m','k', 0 ), // smk = Bolinao
  TRUETYPE_TAG('s','m','l', 0 ), // sml = Central Sama
  TRUETYPE_TAG('s','m','m', 0 ), // smm = Musasa
  TRUETYPE_TAG('s','m','n', 0 ), // smn = Inari Sami
  TRUETYPE_TAG('s','m','p', 0 ), // smp = Samaritan
  TRUETYPE_TAG('s','m','q', 0 ), // smq = Samo
  TRUETYPE_TAG('s','m','r', 0 ), // smr = Simeulue
  TRUETYPE_TAG('s','m','s', 0 ), // sms = Skolt Sami
  TRUETYPE_TAG('s','m','t', 0 ), // smt = Simte
  TRUETYPE_TAG('s','m','u', 0 ), // smu = Somray
  TRUETYPE_TAG('s','m','v', 0 ), // smv = Samvedi
  TRUETYPE_TAG('s','m','w', 0 ), // smw = Sumbawa
  TRUETYPE_TAG('s','m','x', 0 ), // smx = Samba
  TRUETYPE_TAG('s','m','y', 0 ), // smy = Semnani
  TRUETYPE_TAG('s','m','z', 0 ), // smz = Simeku
  TRUETYPE_TAG('s','n','b', 0 ), // snb = Sebuyau
  TRUETYPE_TAG('s','n','c', 0 ), // snc = Sinaugoro
  TRUETYPE_TAG('s','n','e', 0 ), // sne = Bau Bidayuh
  TRUETYPE_TAG('s','n','f', 0 ), // snf = Noon
  TRUETYPE_TAG('s','n','g', 0 ), // sng = Sanga (Democratic Republic of Congo)
  TRUETYPE_TAG('s','n','h', 0 ), // snh = Shinabo
  TRUETYPE_TAG('s','n','i', 0 ), // sni = Sensi
  TRUETYPE_TAG('s','n','j', 0 ), // snj = Riverain Sango
  TRUETYPE_TAG('s','n','k', 0 ), // snk = Soninke
  TRUETYPE_TAG('s','n','l', 0 ), // snl = Sangil
  TRUETYPE_TAG('s','n','m', 0 ), // snm = Southern Ma'di
  TRUETYPE_TAG('s','n','n', 0 ), // snn = Siona
  TRUETYPE_TAG('s','n','o', 0 ), // sno = Snohomish
  TRUETYPE_TAG('s','n','p', 0 ), // snp = Siane
  TRUETYPE_TAG('s','n','q', 0 ), // snq = Sangu (Gabon)
  TRUETYPE_TAG('s','n','r', 0 ), // snr = Sihan
  TRUETYPE_TAG('s','n','s', 0 ), // sns = South West Bay
  TRUETYPE_TAG('s','n','u', 0 ), // snu = Senggi
  TRUETYPE_TAG('s','n','v', 0 ), // snv = Sa'ban
  TRUETYPE_TAG('s','n','w', 0 ), // snw = Selee
  TRUETYPE_TAG('s','n','x', 0 ), // snx = Sam
  TRUETYPE_TAG('s','n','y', 0 ), // sny = Saniyo-Hiyewe
  TRUETYPE_TAG('s','n','z', 0 ), // snz = Sinsauru
  TRUETYPE_TAG('s','o','a', 0 ), // soa = Thai Song
  TRUETYPE_TAG('s','o','b', 0 ), // sob = Sobei
  TRUETYPE_TAG('s','o','c', 0 ), // soc = So (Democratic Republic of Congo)
  TRUETYPE_TAG('s','o','d', 0 ), // sod = Songoora
  TRUETYPE_TAG('s','o','e', 0 ), // soe = Songomeno
  TRUETYPE_TAG('s','o','g', 0 ), // sog = Sogdian
  TRUETYPE_TAG('s','o','h', 0 ), // soh = Aka
  TRUETYPE_TAG('s','o','i', 0 ), // soi = Sonha
  TRUETYPE_TAG('s','o','j', 0 ), // soj = Soi
  TRUETYPE_TAG('s','o','k', 0 ), // sok = Sokoro
  TRUETYPE_TAG('s','o','l', 0 ), // sol = Solos
  TRUETYPE_TAG('s','o','n', 0 ), // son = Songhai languages
  TRUETYPE_TAG('s','o','o', 0 ), // soo = Songo
  TRUETYPE_TAG('s','o','p', 0 ), // sop = Songe
  TRUETYPE_TAG('s','o','q', 0 ), // soq = Kanasi
  TRUETYPE_TAG('s','o','r', 0 ), // sor = Somrai
  TRUETYPE_TAG('s','o','s', 0 ), // sos = Seeku
  TRUETYPE_TAG('s','o','u', 0 ), // sou = Southern Thai
  TRUETYPE_TAG('s','o','v', 0 ), // sov = Sonsorol
  TRUETYPE_TAG('s','o','w', 0 ), // sow = Sowanda
  TRUETYPE_TAG('s','o','x', 0 ), // sox = So (Cameroon)
  TRUETYPE_TAG('s','o','y', 0 ), // soy = Miyobe
  TRUETYPE_TAG('s','o','z', 0 ), // soz = Temi
  TRUETYPE_TAG('s','p','b', 0 ), // spb = Sepa (Indonesia)
  TRUETYPE_TAG('s','p','c', 0 ), // spc = Sapé
  TRUETYPE_TAG('s','p','d', 0 ), // spd = Saep
  TRUETYPE_TAG('s','p','e', 0 ), // spe = Sepa (Papua New Guinea)
  TRUETYPE_TAG('s','p','g', 0 ), // spg = Sian
  TRUETYPE_TAG('s','p','i', 0 ), // spi = Saponi
  TRUETYPE_TAG('s','p','k', 0 ), // spk = Sengo
  TRUETYPE_TAG('s','p','l', 0 ), // spl = Selepet
  TRUETYPE_TAG('s','p','m', 0 ), // spm = Sepen
  TRUETYPE_TAG('s','p','o', 0 ), // spo = Spokane
  TRUETYPE_TAG('s','p','p', 0 ), // spp = Supyire Senoufo
  TRUETYPE_TAG('s','p','q', 0 ), // spq = Loreto-Ucayali Spanish
  TRUETYPE_TAG('s','p','r', 0 ), // spr = Saparua
  TRUETYPE_TAG('s','p','s', 0 ), // sps = Saposa
  TRUETYPE_TAG('s','p','t', 0 ), // spt = Spiti Bhoti
  TRUETYPE_TAG('s','p','u', 0 ), // spu = Sapuan
  TRUETYPE_TAG('s','p','x', 0 ), // spx = South Picene
  TRUETYPE_TAG('s','p','y', 0 ), // spy = Sabaot
  TRUETYPE_TAG('s','q','a', 0 ), // sqa = Shama-Sambuga
  TRUETYPE_TAG('s','q','h', 0 ), // sqh = Shau
  TRUETYPE_TAG('s','q','j', 0 ), // sqj = Albanian languages
  TRUETYPE_TAG('s','q','m', 0 ), // sqm = Suma
  TRUETYPE_TAG('s','q','n', 0 ), // sqn = Susquehannock
  TRUETYPE_TAG('s','q','o', 0 ), // sqo = Sorkhei
  TRUETYPE_TAG('s','q','q', 0 ), // sqq = Sou
  TRUETYPE_TAG('s','q','r', 0 ), // sqr = Siculo Arabic
  TRUETYPE_TAG('s','q','s', 0 ), // sqs = Sri Lankan Sign Language
  TRUETYPE_TAG('s','q','t', 0 ), // sqt = Soqotri
  TRUETYPE_TAG('s','q','u', 0 ), // squ = Squamish
  TRUETYPE_TAG('s','r','a', 0 ), // sra = Saruga
  TRUETYPE_TAG('s','r','b', 0 ), // srb = Sora
  TRUETYPE_TAG('s','r','c', 0 ), // src = Logudorese Sardinian
  TRUETYPE_TAG('s','r','e', 0 ), // sre = Sara
  TRUETYPE_TAG('s','r','f', 0 ), // srf = Nafi
  TRUETYPE_TAG('s','r','g', 0 ), // srg = Sulod
  TRUETYPE_TAG('s','r','h', 0 ), // srh = Sarikoli
  TRUETYPE_TAG('s','r','i', 0 ), // sri = Siriano
  TRUETYPE_TAG('s','r','k', 0 ), // srk = Serudung Murut
  TRUETYPE_TAG('s','r','l', 0 ), // srl = Isirawa
  TRUETYPE_TAG('s','r','m', 0 ), // srm = Saramaccan
  TRUETYPE_TAG('s','r','n', 0 ), // srn = Sranan Tongo
  TRUETYPE_TAG('s','r','o', 0 ), // sro = Campidanese Sardinian
  TRUETYPE_TAG('s','r','q', 0 ), // srq = Sirionó
  TRUETYPE_TAG('s','r','r', 0 ), // srr = Serer
  TRUETYPE_TAG('s','r','s', 0 ), // srs = Sarsi
  TRUETYPE_TAG('s','r','t', 0 ), // srt = Sauri
  TRUETYPE_TAG('s','r','u', 0 ), // sru = Suruí
  TRUETYPE_TAG('s','r','v', 0 ), // srv = Southern Sorsoganon
  TRUETYPE_TAG('s','r','w', 0 ), // srw = Serua
  TRUETYPE_TAG('s','r','x', 0 ), // srx = Sirmauri
  TRUETYPE_TAG('s','r','y', 0 ), // sry = Sera
  TRUETYPE_TAG('s','r','z', 0 ), // srz = Shahmirzadi
  TRUETYPE_TAG('s','s','a', 0 ), // ssa = Nilo-Saharan languages
  TRUETYPE_TAG('s','s','b', 0 ), // ssb = Southern Sama
  TRUETYPE_TAG('s','s','c', 0 ), // ssc = Suba-Simbiti
  TRUETYPE_TAG('s','s','d', 0 ), // ssd = Siroi
  TRUETYPE_TAG('s','s','e', 0 ), // sse = Balangingi
  TRUETYPE_TAG('s','s','f', 0 ), // ssf = Thao
  TRUETYPE_TAG('s','s','g', 0 ), // ssg = Seimat
  TRUETYPE_TAG('s','s','h', 0 ), // ssh = Shihhi Arabic
  TRUETYPE_TAG('s','s','i', 0 ), // ssi = Sansi
  TRUETYPE_TAG('s','s','j', 0 ), // ssj = Sausi
  TRUETYPE_TAG('s','s','k', 0 ), // ssk = Sunam
  TRUETYPE_TAG('s','s','l', 0 ), // ssl = Western Sisaala
  TRUETYPE_TAG('s','s','m', 0 ), // ssm = Semnam
  TRUETYPE_TAG('s','s','n', 0 ), // ssn = Waata
  TRUETYPE_TAG('s','s','o', 0 ), // sso = Sissano
  TRUETYPE_TAG('s','s','p', 0 ), // ssp = Spanish Sign Language
  TRUETYPE_TAG('s','s','q', 0 ), // ssq = So'a
  TRUETYPE_TAG('s','s','r', 0 ), // ssr = Swiss-French Sign Language
  TRUETYPE_TAG('s','s','s', 0 ), // sss = Sô
  TRUETYPE_TAG('s','s','t', 0 ), // sst = Sinasina
  TRUETYPE_TAG('s','s','u', 0 ), // ssu = Susuami
  TRUETYPE_TAG('s','s','v', 0 ), // ssv = Shark Bay
  TRUETYPE_TAG('s','s','x', 0 ), // ssx = Samberigi
  TRUETYPE_TAG('s','s','y', 0 ), // ssy = Saho
  TRUETYPE_TAG('s','s','z', 0 ), // ssz = Sengseng
  TRUETYPE_TAG('s','t','a', 0 ), // sta = Settla
  TRUETYPE_TAG('s','t','b', 0 ), // stb = Northern Subanen
  TRUETYPE_TAG('s','t','d', 0 ), // std = Sentinel
  TRUETYPE_TAG('s','t','e', 0 ), // ste = Liana-Seti
  TRUETYPE_TAG('s','t','f', 0 ), // stf = Seta
  TRUETYPE_TAG('s','t','g', 0 ), // stg = Trieng
  TRUETYPE_TAG('s','t','h', 0 ), // sth = Shelta
  TRUETYPE_TAG('s','t','i', 0 ), // sti = Bulo Stieng
  TRUETYPE_TAG('s','t','j', 0 ), // stj = Matya Samo
  TRUETYPE_TAG('s','t','k', 0 ), // stk = Arammba
  TRUETYPE_TAG('s','t','l', 0 ), // stl = Stellingwerfs
  TRUETYPE_TAG('s','t','m', 0 ), // stm = Setaman
  TRUETYPE_TAG('s','t','n', 0 ), // stn = Owa
  TRUETYPE_TAG('s','t','o', 0 ), // sto = Stoney
  TRUETYPE_TAG('s','t','p', 0 ), // stp = Southeastern Tepehuan
  TRUETYPE_TAG('s','t','q', 0 ), // stq = Saterfriesisch
  TRUETYPE_TAG('s','t','r', 0 ), // str = Straits Salish
  TRUETYPE_TAG('s','t','s', 0 ), // sts = Shumashti
  TRUETYPE_TAG('s','t','t', 0 ), // stt = Budeh Stieng
  TRUETYPE_TAG('s','t','u', 0 ), // stu = Samtao
  TRUETYPE_TAG('s','t','v', 0 ), // stv = Silt'e
  TRUETYPE_TAG('s','t','w', 0 ), // stw = Satawalese
  TRUETYPE_TAG('s','u','a', 0 ), // sua = Sulka
  TRUETYPE_TAG('s','u','b', 0 ), // sub = Suku
  TRUETYPE_TAG('s','u','c', 0 ), // suc = Western Subanon
  TRUETYPE_TAG('s','u','e', 0 ), // sue = Suena
  TRUETYPE_TAG('s','u','g', 0 ), // sug = Suganga
  TRUETYPE_TAG('s','u','i', 0 ), // sui = Suki
  TRUETYPE_TAG('s','u','j', 0 ), // suj = Shubi
  TRUETYPE_TAG('s','u','k', 0 ), // suk = Sukuma
  TRUETYPE_TAG('s','u','l', 0 ), // sul = Surigaonon
  TRUETYPE_TAG('s','u','m', 0 ), // sum = Sumo-Mayangna
  TRUETYPE_TAG('s','u','q', 0 ), // suq = Suri
  TRUETYPE_TAG('s','u','r', 0 ), // sur = Mwaghavul
  TRUETYPE_TAG('s','u','s', 0 ), // sus = Susu
  TRUETYPE_TAG('s','u','t', 0 ), // sut = Subtiaba
  TRUETYPE_TAG('s','u','v', 0 ), // suv = Sulung
  TRUETYPE_TAG('s','u','w', 0 ), // suw = Sumbwa
  TRUETYPE_TAG('s','u','x', 0 ), // sux = Sumerian
  TRUETYPE_TAG('s','u','y', 0 ), // suy = Suyá
  TRUETYPE_TAG('s','u','z', 0 ), // suz = Sunwar
  TRUETYPE_TAG('s','v','a', 0 ), // sva = Svan
  TRUETYPE_TAG('s','v','b', 0 ), // svb = Ulau-Suain
  TRUETYPE_TAG('s','v','c', 0 ), // svc = Vincentian Creole English
  TRUETYPE_TAG('s','v','e', 0 ), // sve = Serili
  TRUETYPE_TAG('s','v','k', 0 ), // svk = Slovakian Sign Language
  TRUETYPE_TAG('s','v','r', 0 ), // svr = Savara
  TRUETYPE_TAG('s','v','s', 0 ), // svs = Savosavo
  TRUETYPE_TAG('s','v','x', 0 ), // svx = Skalvian
  TRUETYPE_TAG('s','w','b', 0 ), // swb = Maore Comorian
  TRUETYPE_TAG('s','w','c', 0 ), // swc = Congo Swahili
  TRUETYPE_TAG('s','w','f', 0 ), // swf = Sere
  TRUETYPE_TAG('s','w','g', 0 ), // swg = Swabian
  TRUETYPE_TAG('s','w','h', 0 ), // swh = Swahili (individual language)
  TRUETYPE_TAG('s','w','i', 0 ), // swi = Sui
  TRUETYPE_TAG('s','w','j', 0 ), // swj = Sira
  TRUETYPE_TAG('s','w','k', 0 ), // swk = Malawi Sena
  TRUETYPE_TAG('s','w','l', 0 ), // swl = Swedish Sign Language
  TRUETYPE_TAG('s','w','m', 0 ), // swm = Samosa
  TRUETYPE_TAG('s','w','n', 0 ), // swn = Sawknah
  TRUETYPE_TAG('s','w','o', 0 ), // swo = Shanenawa
  TRUETYPE_TAG('s','w','p', 0 ), // swp = Suau
  TRUETYPE_TAG('s','w','q', 0 ), // swq = Sharwa
  TRUETYPE_TAG('s','w','r', 0 ), // swr = Saweru
  TRUETYPE_TAG('s','w','s', 0 ), // sws = Seluwasan
  TRUETYPE_TAG('s','w','t', 0 ), // swt = Sawila
  TRUETYPE_TAG('s','w','u', 0 ), // swu = Suwawa
  TRUETYPE_TAG('s','w','v', 0 ), // swv = Shekhawati
  TRUETYPE_TAG('s','w','w', 0 ), // sww = Sowa
  TRUETYPE_TAG('s','w','x', 0 ), // swx = Suruahá
  TRUETYPE_TAG('s','w','y', 0 ), // swy = Sarua
  TRUETYPE_TAG('s','x','b', 0 ), // sxb = Suba
  TRUETYPE_TAG('s','x','c', 0 ), // sxc = Sicanian
  TRUETYPE_TAG('s','x','e', 0 ), // sxe = Sighu
  TRUETYPE_TAG('s','x','g', 0 ), // sxg = Shixing
  TRUETYPE_TAG('s','x','k', 0 ), // sxk = Southern Kalapuya
  TRUETYPE_TAG('s','x','l', 0 ), // sxl = Selian
  TRUETYPE_TAG('s','x','m', 0 ), // sxm = Samre
  TRUETYPE_TAG('s','x','n', 0 ), // sxn = Sangir
  TRUETYPE_TAG('s','x','o', 0 ), // sxo = Sorothaptic
  TRUETYPE_TAG('s','x','r', 0 ), // sxr = Saaroa
  TRUETYPE_TAG('s','x','s', 0 ), // sxs = Sasaru
  TRUETYPE_TAG('s','x','u', 0 ), // sxu = Upper Saxon
  TRUETYPE_TAG('s','x','w', 0 ), // sxw = Saxwe Gbe
  TRUETYPE_TAG('s','y','a', 0 ), // sya = Siang
  TRUETYPE_TAG('s','y','b', 0 ), // syb = Central Subanen
  TRUETYPE_TAG('s','y','c', 0 ), // syc = Classical Syriac
  TRUETYPE_TAG('s','y','d', 0 ), // syd = Samoyedic languages
  TRUETYPE_TAG('s','y','i', 0 ), // syi = Seki
  TRUETYPE_TAG('s','y','k', 0 ), // syk = Sukur
  TRUETYPE_TAG('s','y','l', 0 ), // syl = Sylheti
  TRUETYPE_TAG('s','y','m', 0 ), // sym = Maya Samo
  TRUETYPE_TAG('s','y','n', 0 ), // syn = Senaya
  TRUETYPE_TAG('s','y','o', 0 ), // syo = Suoy
  TRUETYPE_TAG('s','y','r', 0 ), // syr = Syriac
  TRUETYPE_TAG('s','y','s', 0 ), // sys = Sinyar
  TRUETYPE_TAG('s','y','w', 0 ), // syw = Kagate
  TRUETYPE_TAG('s','y','y', 0 ), // syy = Al-Sayyid Bedouin Sign Language
  TRUETYPE_TAG('s','z','a', 0 ), // sza = Semelai
  TRUETYPE_TAG('s','z','b', 0 ), // szb = Ngalum
  TRUETYPE_TAG('s','z','c', 0 ), // szc = Semaq Beri
  TRUETYPE_TAG('s','z','d', 0 ), // szd = Seru
  TRUETYPE_TAG('s','z','e', 0 ), // sze = Seze
  TRUETYPE_TAG('s','z','g', 0 ), // szg = Sengele
  TRUETYPE_TAG('s','z','l', 0 ), // szl = Silesian
  TRUETYPE_TAG('s','z','n', 0 ), // szn = Sula
  TRUETYPE_TAG('s','z','p', 0 ), // szp = Suabo
  TRUETYPE_TAG('s','z','v', 0 ), // szv = Isu (Fako Division)
  TRUETYPE_TAG('s','z','w', 0 ), // szw = Sawai
  TRUETYPE_TAG('t','a','a', 0 ), // taa = Lower Tanana
  TRUETYPE_TAG('t','a','b', 0 ), // tab = Tabassaran
  TRUETYPE_TAG('t','a','c', 0 ), // tac = Lowland Tarahumara
  TRUETYPE_TAG('t','a','d', 0 ), // tad = Tause
  TRUETYPE_TAG('t','a','e', 0 ), // tae = Tariana
  TRUETYPE_TAG('t','a','f', 0 ), // taf = Tapirapé
  TRUETYPE_TAG('t','a','g', 0 ), // tag = Tagoi
  TRUETYPE_TAG('t','a','i', 0 ), // tai = Tai languages
  TRUETYPE_TAG('t','a','j', 0 ), // taj = Eastern Tamang
  TRUETYPE_TAG('t','a','k', 0 ), // tak = Tala
  TRUETYPE_TAG('t','a','l', 0 ), // tal = Tal
  TRUETYPE_TAG('t','a','n', 0 ), // tan = Tangale
  TRUETYPE_TAG('t','a','o', 0 ), // tao = Yami
  TRUETYPE_TAG('t','a','p', 0 ), // tap = Taabwa
  TRUETYPE_TAG('t','a','q', 0 ), // taq = Tamasheq
  TRUETYPE_TAG('t','a','r', 0 ), // tar = Central Tarahumara
  TRUETYPE_TAG('t','a','s', 0 ), // tas = Tay Boi
  TRUETYPE_TAG('t','a','u', 0 ), // tau = Upper Tanana
  TRUETYPE_TAG('t','a','v', 0 ), // tav = Tatuyo
  TRUETYPE_TAG('t','a','w', 0 ), // taw = Tai
  TRUETYPE_TAG('t','a','x', 0 ), // tax = Tamki
  TRUETYPE_TAG('t','a','y', 0 ), // tay = Atayal
  TRUETYPE_TAG('t','a','z', 0 ), // taz = Tocho
  TRUETYPE_TAG('t','b','a', 0 ), // tba = Aikanã
  TRUETYPE_TAG('t','b','b', 0 ), // tbb = Tapeba
  TRUETYPE_TAG('t','b','c', 0 ), // tbc = Takia
  TRUETYPE_TAG('t','b','d', 0 ), // tbd = Kaki Ae
  TRUETYPE_TAG('t','b','e', 0 ), // tbe = Tanimbili
  TRUETYPE_TAG('t','b','f', 0 ), // tbf = Mandara
  TRUETYPE_TAG('t','b','g', 0 ), // tbg = North Tairora
  TRUETYPE_TAG('t','b','h', 0 ), // tbh = Thurawal
  TRUETYPE_TAG('t','b','i', 0 ), // tbi = Gaam
  TRUETYPE_TAG('t','b','j', 0 ), // tbj = Tiang
  TRUETYPE_TAG('t','b','k', 0 ), // tbk = Calamian Tagbanwa
  TRUETYPE_TAG('t','b','l', 0 ), // tbl = Tboli
  TRUETYPE_TAG('t','b','m', 0 ), // tbm = Tagbu
  TRUETYPE_TAG('t','b','n', 0 ), // tbn = Barro Negro Tunebo
  TRUETYPE_TAG('t','b','o', 0 ), // tbo = Tawala
  TRUETYPE_TAG('t','b','p', 0 ), // tbp = Taworta
  TRUETYPE_TAG('t','b','q', 0 ), // tbq = Tibeto-Burman languages
  TRUETYPE_TAG('t','b','r', 0 ), // tbr = Tumtum
  TRUETYPE_TAG('t','b','s', 0 ), // tbs = Tanguat
  TRUETYPE_TAG('t','b','t', 0 ), // tbt = Tembo (Kitembo)
  TRUETYPE_TAG('t','b','u', 0 ), // tbu = Tubar
  TRUETYPE_TAG('t','b','v', 0 ), // tbv = Tobo
  TRUETYPE_TAG('t','b','w', 0 ), // tbw = Tagbanwa
  TRUETYPE_TAG('t','b','x', 0 ), // tbx = Kapin
  TRUETYPE_TAG('t','b','y', 0 ), // tby = Tabaru
  TRUETYPE_TAG('t','b','z', 0 ), // tbz = Ditammari
  TRUETYPE_TAG('t','c','a', 0 ), // tca = Ticuna
  TRUETYPE_TAG('t','c','b', 0 ), // tcb = Tanacross
  TRUETYPE_TAG('t','c','c', 0 ), // tcc = Datooga
  TRUETYPE_TAG('t','c','d', 0 ), // tcd = Tafi
  TRUETYPE_TAG('t','c','e', 0 ), // tce = Southern Tutchone
  TRUETYPE_TAG('t','c','f', 0 ), // tcf = Malinaltepec Me'phaa
  TRUETYPE_TAG('t','c','g', 0 ), // tcg = Tamagario
  TRUETYPE_TAG('t','c','h', 0 ), // tch = Turks And Caicos Creole English
  TRUETYPE_TAG('t','c','i', 0 ), // tci = Wára
  TRUETYPE_TAG('t','c','k', 0 ), // tck = Tchitchege
  TRUETYPE_TAG('t','c','l', 0 ), // tcl = Taman (Myanmar)
  TRUETYPE_TAG('t','c','m', 0 ), // tcm = Tanahmerah
  TRUETYPE_TAG('t','c','n', 0 ), // tcn = Tichurong
  TRUETYPE_TAG('t','c','o', 0 ), // tco = Taungyo
  TRUETYPE_TAG('t','c','p', 0 ), // tcp = Tawr Chin
  TRUETYPE_TAG('t','c','q', 0 ), // tcq = Kaiy
  TRUETYPE_TAG('t','c','s', 0 ), // tcs = Torres Strait Creole
  TRUETYPE_TAG('t','c','t', 0 ), // tct = T'en
  TRUETYPE_TAG('t','c','u', 0 ), // tcu = Southeastern Tarahumara
  TRUETYPE_TAG('t','c','w', 0 ), // tcw = Tecpatlán Totonac
  TRUETYPE_TAG('t','c','x', 0 ), // tcx = Toda
  TRUETYPE_TAG('t','c','y', 0 ), // tcy = Tulu
  TRUETYPE_TAG('t','c','z', 0 ), // tcz = Thado Chin
  TRUETYPE_TAG('t','d','a', 0 ), // tda = Tagdal
  TRUETYPE_TAG('t','d','b', 0 ), // tdb = Panchpargania
  TRUETYPE_TAG('t','d','c', 0 ), // tdc = Emberá-Tadó
  TRUETYPE_TAG('t','d','d', 0 ), // tdd = Tai Nüa
  TRUETYPE_TAG('t','d','e', 0 ), // tde = Tiranige Diga Dogon
  TRUETYPE_TAG('t','d','f', 0 ), // tdf = Talieng
  TRUETYPE_TAG('t','d','g', 0 ), // tdg = Western Tamang
  TRUETYPE_TAG('t','d','h', 0 ), // tdh = Thulung
  TRUETYPE_TAG('t','d','i', 0 ), // tdi = Tomadino
  TRUETYPE_TAG('t','d','j', 0 ), // tdj = Tajio
  TRUETYPE_TAG('t','d','k', 0 ), // tdk = Tambas
  TRUETYPE_TAG('t','d','l', 0 ), // tdl = Sur
  TRUETYPE_TAG('t','d','n', 0 ), // tdn = Tondano
  TRUETYPE_TAG('t','d','o', 0 ), // tdo = Teme
  TRUETYPE_TAG('t','d','q', 0 ), // tdq = Tita
  TRUETYPE_TAG('t','d','r', 0 ), // tdr = Todrah
  TRUETYPE_TAG('t','d','s', 0 ), // tds = Doutai
  TRUETYPE_TAG('t','d','t', 0 ), // tdt = Tetun Dili
  TRUETYPE_TAG('t','d','u', 0 ), // tdu = Tempasuk Dusun
  TRUETYPE_TAG('t','d','v', 0 ), // tdv = Toro
  TRUETYPE_TAG('t','d','x', 0 ), // tdx = Tandroy-Mahafaly Malagasy
  TRUETYPE_TAG('t','d','y', 0 ), // tdy = Tadyawan
  TRUETYPE_TAG('t','e','a', 0 ), // tea = Temiar
  TRUETYPE_TAG('t','e','b', 0 ), // teb = Tetete
  TRUETYPE_TAG('t','e','c', 0 ), // tec = Terik
  TRUETYPE_TAG('t','e','d', 0 ), // ted = Tepo Krumen
  TRUETYPE_TAG('t','e','e', 0 ), // tee = Huehuetla Tepehua
  TRUETYPE_TAG('t','e','f', 0 ), // tef = Teressa
  TRUETYPE_TAG('t','e','g', 0 ), // teg = Teke-Tege
  TRUETYPE_TAG('t','e','h', 0 ), // teh = Tehuelche
  TRUETYPE_TAG('t','e','i', 0 ), // tei = Torricelli
  TRUETYPE_TAG('t','e','k', 0 ), // tek = Ibali Teke
  TRUETYPE_TAG('t','e','m', 0 ), // tem = Timne
  TRUETYPE_TAG('t','e','n', 0 ), // ten = Tama (Colombia)
  TRUETYPE_TAG('t','e','o', 0 ), // teo = Teso
  TRUETYPE_TAG('t','e','p', 0 ), // tep = Tepecano
  TRUETYPE_TAG('t','e','q', 0 ), // teq = Temein
  TRUETYPE_TAG('t','e','r', 0 ), // ter = Tereno
  TRUETYPE_TAG('t','e','s', 0 ), // tes = Tengger
  TRUETYPE_TAG('t','e','t', 0 ), // tet = Tetum
  TRUETYPE_TAG('t','e','u', 0 ), // teu = Soo
  TRUETYPE_TAG('t','e','v', 0 ), // tev = Teor
  TRUETYPE_TAG('t','e','w', 0 ), // tew = Tewa (USA)
  TRUETYPE_TAG('t','e','x', 0 ), // tex = Tennet
  TRUETYPE_TAG('t','e','y', 0 ), // tey = Tulishi
  TRUETYPE_TAG('t','f','i', 0 ), // tfi = Tofin Gbe
  TRUETYPE_TAG('t','f','n', 0 ), // tfn = Tanaina
  TRUETYPE_TAG('t','f','o', 0 ), // tfo = Tefaro
  TRUETYPE_TAG('t','f','r', 0 ), // tfr = Teribe
  TRUETYPE_TAG('t','f','t', 0 ), // tft = Ternate
  TRUETYPE_TAG('t','g','a', 0 ), // tga = Sagalla
  TRUETYPE_TAG('t','g','b', 0 ), // tgb = Tobilung
  TRUETYPE_TAG('t','g','c', 0 ), // tgc = Tigak
  TRUETYPE_TAG('t','g','d', 0 ), // tgd = Ciwogai
  TRUETYPE_TAG('t','g','e', 0 ), // tge = Eastern Gorkha Tamang
  TRUETYPE_TAG('t','g','f', 0 ), // tgf = Chalikha
  TRUETYPE_TAG('t','g','g', 0 ), // tgg = Tangga
  TRUETYPE_TAG('t','g','h', 0 ), // tgh = Tobagonian Creole English
  TRUETYPE_TAG('t','g','i', 0 ), // tgi = Lawunuia
  TRUETYPE_TAG('t','g','n', 0 ), // tgn = Tandaganon
  TRUETYPE_TAG('t','g','o', 0 ), // tgo = Sudest
  TRUETYPE_TAG('t','g','p', 0 ), // tgp = Tangoa
  TRUETYPE_TAG('t','g','q', 0 ), // tgq = Tring
  TRUETYPE_TAG('t','g','r', 0 ), // tgr = Tareng
  TRUETYPE_TAG('t','g','s', 0 ), // tgs = Nume
  TRUETYPE_TAG('t','g','t', 0 ), // tgt = Central Tagbanwa
  TRUETYPE_TAG('t','g','u', 0 ), // tgu = Tanggu
  TRUETYPE_TAG('t','g','v', 0 ), // tgv = Tingui-Boto
  TRUETYPE_TAG('t','g','w', 0 ), // tgw = Tagwana Senoufo
  TRUETYPE_TAG('t','g','x', 0 ), // tgx = Tagish
  TRUETYPE_TAG('t','g','y', 0 ), // tgy = Togoyo
  TRUETYPE_TAG('t','h','c', 0 ), // thc = Tai Hang Tong
  TRUETYPE_TAG('t','h','d', 0 ), // thd = Thayore
  TRUETYPE_TAG('t','h','e', 0 ), // the = Chitwania Tharu
  TRUETYPE_TAG('t','h','f', 0 ), // thf = Thangmi
  TRUETYPE_TAG('t','h','h', 0 ), // thh = Northern Tarahumara
  TRUETYPE_TAG('t','h','i', 0 ), // thi = Tai Long
  TRUETYPE_TAG('t','h','k', 0 ), // thk = Tharaka
  TRUETYPE_TAG('t','h','l', 0 ), // thl = Dangaura Tharu
  TRUETYPE_TAG('t','h','m', 0 ), // thm = Aheu
  TRUETYPE_TAG('t','h','n', 0 ), // thn = Thachanadan
  TRUETYPE_TAG('t','h','p', 0 ), // thp = Thompson
  TRUETYPE_TAG('t','h','q', 0 ), // thq = Kochila Tharu
  TRUETYPE_TAG('t','h','r', 0 ), // thr = Rana Tharu
  TRUETYPE_TAG('t','h','s', 0 ), // ths = Thakali
  TRUETYPE_TAG('t','h','t', 0 ), // tht = Tahltan
  TRUETYPE_TAG('t','h','u', 0 ), // thu = Thuri
  TRUETYPE_TAG('t','h','v', 0 ), // thv = Tahaggart Tamahaq
  TRUETYPE_TAG('t','h','w', 0 ), // thw = Thudam
  TRUETYPE_TAG('t','h','x', 0 ), // thx = The
  TRUETYPE_TAG('t','h','y', 0 ), // thy = Tha
  TRUETYPE_TAG('t','h','z', 0 ), // thz = Tayart Tamajeq
  TRUETYPE_TAG('t','i','a', 0 ), // tia = Tidikelt Tamazight
  TRUETYPE_TAG('t','i','c', 0 ), // tic = Tira
  TRUETYPE_TAG('t','i','d', 0 ), // tid = Tidong
  TRUETYPE_TAG('t','i','e', 0 ), // tie = Tingal
  TRUETYPE_TAG('t','i','f', 0 ), // tif = Tifal
  TRUETYPE_TAG('t','i','g', 0 ), // tig = Tigre
  TRUETYPE_TAG('t','i','h', 0 ), // tih = Timugon Murut
  TRUETYPE_TAG('t','i','i', 0 ), // tii = Tiene
  TRUETYPE_TAG('t','i','j', 0 ), // tij = Tilung
  TRUETYPE_TAG('t','i','k', 0 ), // tik = Tikar
  TRUETYPE_TAG('t','i','l', 0 ), // til = Tillamook
  TRUETYPE_TAG('t','i','m', 0 ), // tim = Timbe
  TRUETYPE_TAG('t','i','n', 0 ), // tin = Tindi
  TRUETYPE_TAG('t','i','o', 0 ), // tio = Teop
  TRUETYPE_TAG('t','i','p', 0 ), // tip = Trimuris
  TRUETYPE_TAG('t','i','q', 0 ), // tiq = Tiéfo
  TRUETYPE_TAG('t','i','s', 0 ), // tis = Masadiit Itneg
  TRUETYPE_TAG('t','i','t', 0 ), // tit = Tinigua
  TRUETYPE_TAG('t','i','u', 0 ), // tiu = Adasen
  TRUETYPE_TAG('t','i','v', 0 ), // tiv = Tiv
  TRUETYPE_TAG('t','i','w', 0 ), // tiw = Tiwi
  TRUETYPE_TAG('t','i','x', 0 ), // tix = Southern Tiwa
  TRUETYPE_TAG('t','i','y', 0 ), // tiy = Tiruray
  TRUETYPE_TAG('t','i','z', 0 ), // tiz = Tai Hongjin
  TRUETYPE_TAG('t','j','a', 0 ), // tja = Tajuasohn
  TRUETYPE_TAG('t','j','g', 0 ), // tjg = Tunjung
  TRUETYPE_TAG('t','j','i', 0 ), // tji = Northern Tujia
  TRUETYPE_TAG('t','j','m', 0 ), // tjm = Timucua
  TRUETYPE_TAG('t','j','n', 0 ), // tjn = Tonjon
  TRUETYPE_TAG('t','j','o', 0 ), // tjo = Temacine Tamazight
  TRUETYPE_TAG('t','j','s', 0 ), // tjs = Southern Tujia
  TRUETYPE_TAG('t','j','u', 0 ), // tju = Tjurruru
  TRUETYPE_TAG('t','k','a', 0 ), // tka = Truká
  TRUETYPE_TAG('t','k','b', 0 ), // tkb = Buksa
  TRUETYPE_TAG('t','k','d', 0 ), // tkd = Tukudede
  TRUETYPE_TAG('t','k','e', 0 ), // tke = Takwane
  TRUETYPE_TAG('t','k','f', 0 ), // tkf = Tukumanféd
  TRUETYPE_TAG('t','k','g', 0 ), // tkg = Tesaka Malagasy
  TRUETYPE_TAG('t','k','k', 0 ), // tkk = Takpa
  TRUETYPE_TAG('t','k','l', 0 ), // tkl = Tokelau
  TRUETYPE_TAG('t','k','m', 0 ), // tkm = Takelma
  TRUETYPE_TAG('t','k','n', 0 ), // tkn = Toku-No-Shima
  TRUETYPE_TAG('t','k','p', 0 ), // tkp = Tikopia
  TRUETYPE_TAG('t','k','q', 0 ), // tkq = Tee
  TRUETYPE_TAG('t','k','r', 0 ), // tkr = Tsakhur
  TRUETYPE_TAG('t','k','s', 0 ), // tks = Takestani
  TRUETYPE_TAG('t','k','t', 0 ), // tkt = Kathoriya Tharu
  TRUETYPE_TAG('t','k','u', 0 ), // tku = Upper Necaxa Totonac
  TRUETYPE_TAG('t','k','w', 0 ), // tkw = Teanu
  TRUETYPE_TAG('t','k','x', 0 ), // tkx = Tangko
  TRUETYPE_TAG('t','k','z', 0 ), // tkz = Takua
  TRUETYPE_TAG('t','l','a', 0 ), // tla = Southwestern Tepehuan
  TRUETYPE_TAG('t','l','b', 0 ), // tlb = Tobelo
  TRUETYPE_TAG('t','l','c', 0 ), // tlc = Yecuatla Totonac
  TRUETYPE_TAG('t','l','d', 0 ), // tld = Talaud
  TRUETYPE_TAG('t','l','f', 0 ), // tlf = Telefol
  TRUETYPE_TAG('t','l','g', 0 ), // tlg = Tofanma
  TRUETYPE_TAG('t','l','h', 0 ), // tlh = Klingon
  TRUETYPE_TAG('t','l','i', 0 ), // tli = Tlingit
  TRUETYPE_TAG('t','l','j', 0 ), // tlj = Talinga-Bwisi
  TRUETYPE_TAG('t','l','k', 0 ), // tlk = Taloki
  TRUETYPE_TAG('t','l','l', 0 ), // tll = Tetela
  TRUETYPE_TAG('t','l','m', 0 ), // tlm = Tolomako
  TRUETYPE_TAG('t','l','n', 0 ), // tln = Talondo'
  TRUETYPE_TAG('t','l','o', 0 ), // tlo = Talodi
  TRUETYPE_TAG('t','l','p', 0 ), // tlp = Filomena Mata-Coahuitlán Totonac
  TRUETYPE_TAG('t','l','q', 0 ), // tlq = Tai Loi
  TRUETYPE_TAG('t','l','r', 0 ), // tlr = Talise
  TRUETYPE_TAG('t','l','s', 0 ), // tls = Tambotalo
  TRUETYPE_TAG('t','l','t', 0 ), // tlt = Teluti
  TRUETYPE_TAG('t','l','u', 0 ), // tlu = Tulehu
  TRUETYPE_TAG('t','l','v', 0 ), // tlv = Taliabu
  TRUETYPE_TAG('t','l','w', 0 ), // tlw = South Wemale
  TRUETYPE_TAG('t','l','x', 0 ), // tlx = Khehek
  TRUETYPE_TAG('t','l','y', 0 ), // tly = Talysh
  TRUETYPE_TAG('t','m','a', 0 ), // tma = Tama (Chad)
  TRUETYPE_TAG('t','m','b', 0 ), // tmb = Katbol
  TRUETYPE_TAG('t','m','c', 0 ), // tmc = Tumak
  TRUETYPE_TAG('t','m','d', 0 ), // tmd = Haruai
  TRUETYPE_TAG('t','m','e', 0 ), // tme = Tremembé
  TRUETYPE_TAG('t','m','f', 0 ), // tmf = Toba-Maskoy
  TRUETYPE_TAG('t','m','g', 0 ), // tmg = Ternateño
  TRUETYPE_TAG('t','m','h', 0 ), // tmh = Tamashek
  TRUETYPE_TAG('t','m','i', 0 ), // tmi = Tutuba
  TRUETYPE_TAG('t','m','j', 0 ), // tmj = Samarokena
  TRUETYPE_TAG('t','m','k', 0 ), // tmk = Northwestern Tamang
  TRUETYPE_TAG('t','m','l', 0 ), // tml = Tamnim Citak
  TRUETYPE_TAG('t','m','m', 0 ), // tmm = Tai Thanh
  TRUETYPE_TAG('t','m','n', 0 ), // tmn = Taman (Indonesia)
  TRUETYPE_TAG('t','m','o', 0 ), // tmo = Temoq
  TRUETYPE_TAG('t','m','p', 0 ), // tmp = Tai Mène
  TRUETYPE_TAG('t','m','q', 0 ), // tmq = Tumleo
  TRUETYPE_TAG('t','m','r', 0 ), // tmr = Jewish Babylonian Aramaic (ca. 200-1200 CE)
  TRUETYPE_TAG('t','m','s', 0 ), // tms = Tima
  TRUETYPE_TAG('t','m','t', 0 ), // tmt = Tasmate
  TRUETYPE_TAG('t','m','u', 0 ), // tmu = Iau
  TRUETYPE_TAG('t','m','v', 0 ), // tmv = Tembo (Motembo)
  TRUETYPE_TAG('t','m','w', 0 ), // tmw = Temuan
  TRUETYPE_TAG('t','m','y', 0 ), // tmy = Tami
  TRUETYPE_TAG('t','m','z', 0 ), // tmz = Tamanaku
  TRUETYPE_TAG('t','n','a', 0 ), // tna = Tacana
  TRUETYPE_TAG('t','n','b', 0 ), // tnb = Western Tunebo
  TRUETYPE_TAG('t','n','c', 0 ), // tnc = Tanimuca-Retuarã
  TRUETYPE_TAG('t','n','d', 0 ), // tnd = Angosturas Tunebo
  TRUETYPE_TAG('t','n','e', 0 ), // tne = Tinoc Kallahan
  TRUETYPE_TAG('t','n','f', 0 ), // tnf = Tangshewi
  TRUETYPE_TAG('t','n','g', 0 ), // tng = Tobanga
  TRUETYPE_TAG('t','n','h', 0 ), // tnh = Maiani
  TRUETYPE_TAG('t','n','i', 0 ), // tni = Tandia
  TRUETYPE_TAG('t','n','k', 0 ), // tnk = Kwamera
  TRUETYPE_TAG('t','n','l', 0 ), // tnl = Lenakel
  TRUETYPE_TAG('t','n','m', 0 ), // tnm = Tabla
  TRUETYPE_TAG('t','n','n', 0 ), // tnn = North Tanna
  TRUETYPE_TAG('t','n','o', 0 ), // tno = Toromono
  TRUETYPE_TAG('t','n','p', 0 ), // tnp = Whitesands
  TRUETYPE_TAG('t','n','q', 0 ), // tnq = Taino
  TRUETYPE_TAG('t','n','r', 0 ), // tnr = Bedik
  TRUETYPE_TAG('t','n','s', 0 ), // tns = Tenis
  TRUETYPE_TAG('t','n','t', 0 ), // tnt = Tontemboan
  TRUETYPE_TAG('t','n','u', 0 ), // tnu = Tay Khang
  TRUETYPE_TAG('t','n','v', 0 ), // tnv = Tangchangya
  TRUETYPE_TAG('t','n','w', 0 ), // tnw = Tonsawang
  TRUETYPE_TAG('t','n','x', 0 ), // tnx = Tanema
  TRUETYPE_TAG('t','n','y', 0 ), // tny = Tongwe
  TRUETYPE_TAG('t','n','z', 0 ), // tnz = Tonga (Thailand)
  TRUETYPE_TAG('t','o','b', 0 ), // tob = Toba
  TRUETYPE_TAG('t','o','c', 0 ), // toc = Coyutla Totonac
  TRUETYPE_TAG('t','o','d', 0 ), // tod = Toma
  TRUETYPE_TAG('t','o','e', 0 ), // toe = Tomedes
  TRUETYPE_TAG('t','o','f', 0 ), // tof = Gizrra
  TRUETYPE_TAG('t','o','g', 0 ), // tog = Tonga (Nyasa)
  TRUETYPE_TAG('t','o','h', 0 ), // toh = Gitonga
  TRUETYPE_TAG('t','o','i', 0 ), // toi = Tonga (Zambia)
  TRUETYPE_TAG('t','o','j', 0 ), // toj = Tojolabal
  TRUETYPE_TAG('t','o','l', 0 ), // tol = Tolowa
  TRUETYPE_TAG('t','o','m', 0 ), // tom = Tombulu
  TRUETYPE_TAG('t','o','o', 0 ), // too = Xicotepec De Juárez Totonac
  TRUETYPE_TAG('t','o','p', 0 ), // top = Papantla Totonac
  TRUETYPE_TAG('t','o','q', 0 ), // toq = Toposa
  TRUETYPE_TAG('t','o','r', 0 ), // tor = Togbo-Vara Banda
  TRUETYPE_TAG('t','o','s', 0 ), // tos = Highland Totonac
  TRUETYPE_TAG('t','o','u', 0 ), // tou = Tho
  TRUETYPE_TAG('t','o','v', 0 ), // tov = Upper Taromi
  TRUETYPE_TAG('t','o','w', 0 ), // tow = Jemez
  TRUETYPE_TAG('t','o','x', 0 ), // tox = Tobian
  TRUETYPE_TAG('t','o','y', 0 ), // toy = Topoiyo
  TRUETYPE_TAG('t','o','z', 0 ), // toz = To
  TRUETYPE_TAG('t','p','a', 0 ), // tpa = Taupota
  TRUETYPE_TAG('t','p','c', 0 ), // tpc = Azoyú Me'phaa
  TRUETYPE_TAG('t','p','e', 0 ), // tpe = Tippera
  TRUETYPE_TAG('t','p','f', 0 ), // tpf = Tarpia
  TRUETYPE_TAG('t','p','g', 0 ), // tpg = Kula
  TRUETYPE_TAG('t','p','i', 0 ), // tpi = Tok Pisin
  TRUETYPE_TAG('t','p','j', 0 ), // tpj = Tapieté
  TRUETYPE_TAG('t','p','k', 0 ), // tpk = Tupinikin
  TRUETYPE_TAG('t','p','l', 0 ), // tpl = Tlacoapa Me'phaa
  TRUETYPE_TAG('t','p','m', 0 ), // tpm = Tampulma
  TRUETYPE_TAG('t','p','n', 0 ), // tpn = Tupinambá
  TRUETYPE_TAG('t','p','o', 0 ), // tpo = Tai Pao
  TRUETYPE_TAG('t','p','p', 0 ), // tpp = Pisaflores Tepehua
  TRUETYPE_TAG('t','p','q', 0 ), // tpq = Tukpa
  TRUETYPE_TAG('t','p','r', 0 ), // tpr = Tuparí
  TRUETYPE_TAG('t','p','t', 0 ), // tpt = Tlachichilco Tepehua
  TRUETYPE_TAG('t','p','u', 0 ), // tpu = Tampuan
  TRUETYPE_TAG('t','p','v', 0 ), // tpv = Tanapag
  TRUETYPE_TAG('t','p','w', 0 ), // tpw = Tupí
  TRUETYPE_TAG('t','p','x', 0 ), // tpx = Acatepec Me'phaa
  TRUETYPE_TAG('t','p','y', 0 ), // tpy = Trumai
  TRUETYPE_TAG('t','p','z', 0 ), // tpz = Tinputz
  TRUETYPE_TAG('t','q','b', 0 ), // tqb = Tembé
  TRUETYPE_TAG('t','q','l', 0 ), // tql = Lehali
  TRUETYPE_TAG('t','q','m', 0 ), // tqm = Turumsa
  TRUETYPE_TAG('t','q','n', 0 ), // tqn = Tenino
  TRUETYPE_TAG('t','q','o', 0 ), // tqo = Toaripi
  TRUETYPE_TAG('t','q','p', 0 ), // tqp = Tomoip
  TRUETYPE_TAG('t','q','q', 0 ), // tqq = Tunni
  TRUETYPE_TAG('t','q','r', 0 ), // tqr = Torona
  TRUETYPE_TAG('t','q','t', 0 ), // tqt = Western Totonac
  TRUETYPE_TAG('t','q','u', 0 ), // tqu = Touo
  TRUETYPE_TAG('t','q','w', 0 ), // tqw = Tonkawa
  TRUETYPE_TAG('t','r','a', 0 ), // tra = Tirahi
  TRUETYPE_TAG('t','r','b', 0 ), // trb = Terebu
  TRUETYPE_TAG('t','r','c', 0 ), // trc = Copala Triqui
  TRUETYPE_TAG('t','r','d', 0 ), // trd = Turi
  TRUETYPE_TAG('t','r','e', 0 ), // tre = East Tarangan
  TRUETYPE_TAG('t','r','f', 0 ), // trf = Trinidadian Creole English
  TRUETYPE_TAG('t','r','g', 0 ), // trg = Lishán Didán
  TRUETYPE_TAG('t','r','h', 0 ), // trh = Turaka
  TRUETYPE_TAG('t','r','i', 0 ), // tri = Trió
  TRUETYPE_TAG('t','r','j', 0 ), // trj = Toram
  TRUETYPE_TAG('t','r','k', 0 ), // trk = Turkic languages
  TRUETYPE_TAG('t','r','l', 0 ), // trl = Traveller Scottish
  TRUETYPE_TAG('t','r','m', 0 ), // trm = Tregami
  TRUETYPE_TAG('t','r','n', 0 ), // trn = Trinitario
  TRUETYPE_TAG('t','r','o', 0 ), // tro = Tarao Naga
  TRUETYPE_TAG('t','r','p', 0 ), // trp = Kok Borok
  TRUETYPE_TAG('t','r','q', 0 ), // trq = San Martín Itunyoso Triqui
  TRUETYPE_TAG('t','r','r', 0 ), // trr = Taushiro
  TRUETYPE_TAG('t','r','s', 0 ), // trs = Chicahuaxtla Triqui
  TRUETYPE_TAG('t','r','t', 0 ), // trt = Tunggare
  TRUETYPE_TAG('t','r','u', 0 ), // tru = Turoyo
  TRUETYPE_TAG('t','r','v', 0 ), // trv = Taroko
  TRUETYPE_TAG('t','r','w', 0 ), // trw = Torwali
  TRUETYPE_TAG('t','r','x', 0 ), // trx = Tringgus-Sembaan Bidayuh
  TRUETYPE_TAG('t','r','y', 0 ), // try = Turung
  TRUETYPE_TAG('t','r','z', 0 ), // trz = Torá
  TRUETYPE_TAG('t','s','a', 0 ), // tsa = Tsaangi
  TRUETYPE_TAG('t','s','b', 0 ), // tsb = Tsamai
  TRUETYPE_TAG('t','s','c', 0 ), // tsc = Tswa
  TRUETYPE_TAG('t','s','d', 0 ), // tsd = Tsakonian
  TRUETYPE_TAG('t','s','e', 0 ), // tse = Tunisian Sign Language
  TRUETYPE_TAG('t','s','f', 0 ), // tsf = Southwestern Tamang
  TRUETYPE_TAG('t','s','g', 0 ), // tsg = Tausug
  TRUETYPE_TAG('t','s','h', 0 ), // tsh = Tsuvan
  TRUETYPE_TAG('t','s','i', 0 ), // tsi = Tsimshian
  TRUETYPE_TAG('t','s','j', 0 ), // tsj = Tshangla
  TRUETYPE_TAG('t','s','k', 0 ), // tsk = Tseku
  TRUETYPE_TAG('t','s','l', 0 ), // tsl = Ts'ün-Lao
  TRUETYPE_TAG('t','s','m', 0 ), // tsm = Turkish Sign Language
  TRUETYPE_TAG('t','s','p', 0 ), // tsp = Northern Toussian
  TRUETYPE_TAG('t','s','q', 0 ), // tsq = Thai Sign Language
  TRUETYPE_TAG('t','s','r', 0 ), // tsr = Akei
  TRUETYPE_TAG('t','s','s', 0 ), // tss = Taiwan Sign Language
  TRUETYPE_TAG('t','s','t', 0 ), // tst = Tondi Songway Kiini
  TRUETYPE_TAG('t','s','u', 0 ), // tsu = Tsou
  TRUETYPE_TAG('t','s','v', 0 ), // tsv = Tsogo
  TRUETYPE_TAG('t','s','w', 0 ), // tsw = Tsishingini
  TRUETYPE_TAG('t','s','x', 0 ), // tsx = Mubami
  TRUETYPE_TAG('t','s','y', 0 ), // tsy = Tebul Sign Language
  TRUETYPE_TAG('t','s','z', 0 ), // tsz = Purepecha
  TRUETYPE_TAG('t','t','a', 0 ), // tta = Tutelo
  TRUETYPE_TAG('t','t','b', 0 ), // ttb = Gaa
  TRUETYPE_TAG('t','t','c', 0 ), // ttc = Tektiteko
  TRUETYPE_TAG('t','t','d', 0 ), // ttd = Tauade
  TRUETYPE_TAG('t','t','e', 0 ), // tte = Bwanabwana
  TRUETYPE_TAG('t','t','f', 0 ), // ttf = Tuotomb
  TRUETYPE_TAG('t','t','g', 0 ), // ttg = Tutong
  TRUETYPE_TAG('t','t','h', 0 ), // tth = Upper Ta'oih
  TRUETYPE_TAG('t','t','i', 0 ), // tti = Tobati
  TRUETYPE_TAG('t','t','j', 0 ), // ttj = Tooro
  TRUETYPE_TAG('t','t','k', 0 ), // ttk = Totoro
  TRUETYPE_TAG('t','t','l', 0 ), // ttl = Totela
  TRUETYPE_TAG('t','t','m', 0 ), // ttm = Northern Tutchone
  TRUETYPE_TAG('t','t','n', 0 ), // ttn = Towei
  TRUETYPE_TAG('t','t','o', 0 ), // tto = Lower Ta'oih
  TRUETYPE_TAG('t','t','p', 0 ), // ttp = Tombelala
  TRUETYPE_TAG('t','t','q', 0 ), // ttq = Tawallammat Tamajaq
  TRUETYPE_TAG('t','t','r', 0 ), // ttr = Tera
  TRUETYPE_TAG('t','t','s', 0 ), // tts = Northeastern Thai
  TRUETYPE_TAG('t','t','t', 0 ), // ttt = Muslim Tat
  TRUETYPE_TAG('t','t','u', 0 ), // ttu = Torau
  TRUETYPE_TAG('t','t','v', 0 ), // ttv = Titan
  TRUETYPE_TAG('t','t','w', 0 ), // ttw = Long Wat
  TRUETYPE_TAG('t','t','y', 0 ), // tty = Sikaritai
  TRUETYPE_TAG('t','t','z', 0 ), // ttz = Tsum
  TRUETYPE_TAG('t','u','a', 0 ), // tua = Wiarumus
  TRUETYPE_TAG('t','u','b', 0 ), // tub = Tübatulabal
  TRUETYPE_TAG('t','u','c', 0 ), // tuc = Mutu
  TRUETYPE_TAG('t','u','d', 0 ), // tud = Tuxá
  TRUETYPE_TAG('t','u','e', 0 ), // tue = Tuyuca
  TRUETYPE_TAG('t','u','f', 0 ), // tuf = Central Tunebo
  TRUETYPE_TAG('t','u','g', 0 ), // tug = Tunia
  TRUETYPE_TAG('t','u','h', 0 ), // tuh = Taulil
  TRUETYPE_TAG('t','u','i', 0 ), // tui = Tupuri
  TRUETYPE_TAG('t','u','j', 0 ), // tuj = Tugutil
  TRUETYPE_TAG('t','u','l', 0 ), // tul = Tula
  TRUETYPE_TAG('t','u','m', 0 ), // tum = Tumbuka
  TRUETYPE_TAG('t','u','n', 0 ), // tun = Tunica
  TRUETYPE_TAG('t','u','o', 0 ), // tuo = Tucano
  TRUETYPE_TAG('t','u','p', 0 ), // tup = Tupi languages
  TRUETYPE_TAG('t','u','q', 0 ), // tuq = Tedaga
  TRUETYPE_TAG('t','u','s', 0 ), // tus = Tuscarora
  TRUETYPE_TAG('t','u','t', 0 ), // tut = Altaic languages
  TRUETYPE_TAG('t','u','u', 0 ), // tuu = Tututni
  TRUETYPE_TAG('t','u','v', 0 ), // tuv = Turkana
  TRUETYPE_TAG('t','u','w', 0 ), // tuw = Tungus languages
  TRUETYPE_TAG('t','u','x', 0 ), // tux = Tuxináwa
  TRUETYPE_TAG('t','u','y', 0 ), // tuy = Tugen
  TRUETYPE_TAG('t','u','z', 0 ), // tuz = Turka
  TRUETYPE_TAG('t','v','a', 0 ), // tva = Vaghua
  TRUETYPE_TAG('t','v','d', 0 ), // tvd = Tsuvadi
  TRUETYPE_TAG('t','v','e', 0 ), // tve = Te'un
  TRUETYPE_TAG('t','v','k', 0 ), // tvk = Southeast Ambrym
  TRUETYPE_TAG('t','v','l', 0 ), // tvl = Tuvalu
  TRUETYPE_TAG('t','v','m', 0 ), // tvm = Tela-Masbuar
  TRUETYPE_TAG('t','v','n', 0 ), // tvn = Tavoyan
  TRUETYPE_TAG('t','v','o', 0 ), // tvo = Tidore
  TRUETYPE_TAG('t','v','s', 0 ), // tvs = Taveta
  TRUETYPE_TAG('t','v','t', 0 ), // tvt = Tutsa Naga
  TRUETYPE_TAG('t','v','w', 0 ), // tvw = Sedoa
  TRUETYPE_TAG('t','v','y', 0 ), // tvy = Timor Pidgin
  TRUETYPE_TAG('t','w','a', 0 ), // twa = Twana
  TRUETYPE_TAG('t','w','b', 0 ), // twb = Western Tawbuid
  TRUETYPE_TAG('t','w','c', 0 ), // twc = Teshenawa
  TRUETYPE_TAG('t','w','d', 0 ), // twd = Twents
  TRUETYPE_TAG('t','w','e', 0 ), // twe = Tewa (Indonesia)
  TRUETYPE_TAG('t','w','f', 0 ), // twf = Northern Tiwa
  TRUETYPE_TAG('t','w','g', 0 ), // twg = Tereweng
  TRUETYPE_TAG('t','w','h', 0 ), // twh = Tai Dón
  TRUETYPE_TAG('t','w','l', 0 ), // twl = Tawara
  TRUETYPE_TAG('t','w','m', 0 ), // twm = Tawang Monpa
  TRUETYPE_TAG('t','w','n', 0 ), // twn = Twendi
  TRUETYPE_TAG('t','w','o', 0 ), // two = Tswapong
  TRUETYPE_TAG('t','w','p', 0 ), // twp = Ere
  TRUETYPE_TAG('t','w','q', 0 ), // twq = Tasawaq
  TRUETYPE_TAG('t','w','r', 0 ), // twr = Southwestern Tarahumara
  TRUETYPE_TAG('t','w','t', 0 ), // twt = Turiwára
  TRUETYPE_TAG('t','w','u', 0 ), // twu = Termanu
  TRUETYPE_TAG('t','w','w', 0 ), // tww = Tuwari
  TRUETYPE_TAG('t','w','x', 0 ), // twx = Tewe
  TRUETYPE_TAG('t','w','y', 0 ), // twy = Tawoyan
  TRUETYPE_TAG('t','x','a', 0 ), // txa = Tombonuo
  TRUETYPE_TAG('t','x','b', 0 ), // txb = Tokharian B
  TRUETYPE_TAG('t','x','c', 0 ), // txc = Tsetsaut
  TRUETYPE_TAG('t','x','e', 0 ), // txe = Totoli
  TRUETYPE_TAG('t','x','g', 0 ), // txg = Tangut
  TRUETYPE_TAG('t','x','h', 0 ), // txh = Thracian
  TRUETYPE_TAG('t','x','i', 0 ), // txi = Ikpeng
  TRUETYPE_TAG('t','x','m', 0 ), // txm = Tomini
  TRUETYPE_TAG('t','x','n', 0 ), // txn = West Tarangan
  TRUETYPE_TAG('t','x','o', 0 ), // txo = Toto
  TRUETYPE_TAG('t','x','q', 0 ), // txq = Tii
  TRUETYPE_TAG('t','x','r', 0 ), // txr = Tartessian
  TRUETYPE_TAG('t','x','s', 0 ), // txs = Tonsea
  TRUETYPE_TAG('t','x','t', 0 ), // txt = Citak
  TRUETYPE_TAG('t','x','u', 0 ), // txu = Kayapó
  TRUETYPE_TAG('t','x','x', 0 ), // txx = Tatana
  TRUETYPE_TAG('t','x','y', 0 ), // txy = Tanosy Malagasy
  TRUETYPE_TAG('t','y','a', 0 ), // tya = Tauya
  TRUETYPE_TAG('t','y','e', 0 ), // tye = Kyenga
  TRUETYPE_TAG('t','y','h', 0 ), // tyh = O'du
  TRUETYPE_TAG('t','y','i', 0 ), // tyi = Teke-Tsaayi
  TRUETYPE_TAG('t','y','j', 0 ), // tyj = Tai Do
  TRUETYPE_TAG('t','y','l', 0 ), // tyl = Thu Lao
  TRUETYPE_TAG('t','y','n', 0 ), // tyn = Kombai
  TRUETYPE_TAG('t','y','p', 0 ), // typ = Thaypan
  TRUETYPE_TAG('t','y','r', 0 ), // tyr = Tai Daeng
  TRUETYPE_TAG('t','y','s', 0 ), // tys = Tày Sa Pa
  TRUETYPE_TAG('t','y','t', 0 ), // tyt = Tày Tac
  TRUETYPE_TAG('t','y','u', 0 ), // tyu = Kua
  TRUETYPE_TAG('t','y','v', 0 ), // tyv = Tuvinian
  TRUETYPE_TAG('t','y','x', 0 ), // tyx = Teke-Tyee
  TRUETYPE_TAG('t','y','z', 0 ), // tyz = Tày
  TRUETYPE_TAG('t','z','a', 0 ), // tza = Tanzanian Sign Language
  TRUETYPE_TAG('t','z','h', 0 ), // tzh = Tzeltal
  TRUETYPE_TAG('t','z','j', 0 ), // tzj = Tz'utujil
  TRUETYPE_TAG('t','z','m', 0 ), // tzm = Central Atlas Tamazight
  TRUETYPE_TAG('t','z','n', 0 ), // tzn = Tugun
  TRUETYPE_TAG('t','z','o', 0 ), // tzo = Tzotzil
  TRUETYPE_TAG('t','z','x', 0 ), // tzx = Tabriak
  TRUETYPE_TAG('u','a','m', 0 ), // uam = Uamué
  TRUETYPE_TAG('u','a','n', 0 ), // uan = Kuan
  TRUETYPE_TAG('u','a','r', 0 ), // uar = Tairuma
  TRUETYPE_TAG('u','b','a', 0 ), // uba = Ubang
  TRUETYPE_TAG('u','b','i', 0 ), // ubi = Ubi
  TRUETYPE_TAG('u','b','l', 0 ), // ubl = Buhi'non Bikol
  TRUETYPE_TAG('u','b','r', 0 ), // ubr = Ubir
  TRUETYPE_TAG('u','b','u', 0 ), // ubu = Umbu-Ungu
  TRUETYPE_TAG('u','b','y', 0 ), // uby = Ubykh
  TRUETYPE_TAG('u','d','a', 0 ), // uda = Uda
  TRUETYPE_TAG('u','d','e', 0 ), // ude = Udihe
  TRUETYPE_TAG('u','d','g', 0 ), // udg = Muduga
  TRUETYPE_TAG('u','d','i', 0 ), // udi = Udi
  TRUETYPE_TAG('u','d','j', 0 ), // udj = Ujir
  TRUETYPE_TAG('u','d','l', 0 ), // udl = Wuzlam
  TRUETYPE_TAG('u','d','m', 0 ), // udm = Udmurt
  TRUETYPE_TAG('u','d','u', 0 ), // udu = Uduk
  TRUETYPE_TAG('u','e','s', 0 ), // ues = Kioko
  TRUETYPE_TAG('u','f','i', 0 ), // ufi = Ufim
  TRUETYPE_TAG('u','g','a', 0 ), // uga = Ugaritic
  TRUETYPE_TAG('u','g','b', 0 ), // ugb = Kuku-Ugbanh
  TRUETYPE_TAG('u','g','e', 0 ), // uge = Ughele
  TRUETYPE_TAG('u','g','n', 0 ), // ugn = Ugandan Sign Language
  TRUETYPE_TAG('u','g','o', 0 ), // ugo = Ugong
  TRUETYPE_TAG('u','g','y', 0 ), // ugy = Uruguayan Sign Language
  TRUETYPE_TAG('u','h','a', 0 ), // uha = Uhami
  TRUETYPE_TAG('u','h','n', 0 ), // uhn = Damal
  TRUETYPE_TAG('u','i','s', 0 ), // uis = Uisai
  TRUETYPE_TAG('u','i','v', 0 ), // uiv = Iyive
  TRUETYPE_TAG('u','j','i', 0 ), // uji = Tanjijili
  TRUETYPE_TAG('u','k','a', 0 ), // uka = Kaburi
  TRUETYPE_TAG('u','k','g', 0 ), // ukg = Ukuriguma
  TRUETYPE_TAG('u','k','h', 0 ), // ukh = Ukhwejo
  TRUETYPE_TAG('u','k','l', 0 ), // ukl = Ukrainian Sign Language
  TRUETYPE_TAG('u','k','p', 0 ), // ukp = Ukpe-Bayobiri
  TRUETYPE_TAG('u','k','q', 0 ), // ukq = Ukwa
  TRUETYPE_TAG('u','k','s', 0 ), // uks = Urubú-Kaapor Sign Language
  TRUETYPE_TAG('u','k','u', 0 ), // uku = Ukue
  TRUETYPE_TAG('u','k','w', 0 ), // ukw = Ukwuani-Aboh-Ndoni
  TRUETYPE_TAG('u','l','a', 0 ), // ula = Fungwa
  TRUETYPE_TAG('u','l','b', 0 ), // ulb = Ulukwumi
  TRUETYPE_TAG('u','l','c', 0 ), // ulc = Ulch
  TRUETYPE_TAG('u','l','f', 0 ), // ulf = Usku
  TRUETYPE_TAG('u','l','i', 0 ), // uli = Ulithian
  TRUETYPE_TAG('u','l','k', 0 ), // ulk = Meriam
  TRUETYPE_TAG('u','l','l', 0 ), // ull = Ullatan
  TRUETYPE_TAG('u','l','m', 0 ), // ulm = Ulumanda'
  TRUETYPE_TAG('u','l','n', 0 ), // uln = Unserdeutsch
  TRUETYPE_TAG('u','l','u', 0 ), // ulu = Uma' Lung
  TRUETYPE_TAG('u','l','w', 0 ), // ulw = Ulwa
  TRUETYPE_TAG('u','m','a', 0 ), // uma = Umatilla
  TRUETYPE_TAG('u','m','b', 0 ), // umb = Umbundu
  TRUETYPE_TAG('u','m','c', 0 ), // umc = Marrucinian
  TRUETYPE_TAG('u','m','d', 0 ), // umd = Umbindhamu
  TRUETYPE_TAG('u','m','g', 0 ), // umg = Umbuygamu
  TRUETYPE_TAG('u','m','i', 0 ), // umi = Ukit
  TRUETYPE_TAG('u','m','m', 0 ), // umm = Umon
  TRUETYPE_TAG('u','m','n', 0 ), // umn = Makyan Naga
  TRUETYPE_TAG('u','m','o', 0 ), // umo = Umotína
  TRUETYPE_TAG('u','m','p', 0 ), // ump = Umpila
  TRUETYPE_TAG('u','m','r', 0 ), // umr = Umbugarla
  TRUETYPE_TAG('u','m','s', 0 ), // ums = Pendau
  TRUETYPE_TAG('u','m','u', 0 ), // umu = Munsee
  TRUETYPE_TAG('u','n','a', 0 ), // una = North Watut
  TRUETYPE_TAG('u','n','d', 0 ), // und = Undetermined
  TRUETYPE_TAG('u','n','e', 0 ), // une = Uneme
  TRUETYPE_TAG('u','n','g', 0 ), // ung = Ngarinyin
  TRUETYPE_TAG('u','n','k', 0 ), // unk = Enawené-Nawé
  TRUETYPE_TAG('u','n','m', 0 ), // unm = Unami
  TRUETYPE_TAG('u','n','p', 0 ), // unp = Worora
  TRUETYPE_TAG('u','n','r', 0 ), // unr = Mundari
  TRUETYPE_TAG('u','n','x', 0 ), // unx = Munda
  TRUETYPE_TAG('u','n','z', 0 ), // unz = Unde Kaili
  TRUETYPE_TAG('u','o','k', 0 ), // uok = Uokha
  TRUETYPE_TAG('u','p','i', 0 ), // upi = Umeda
  TRUETYPE_TAG('u','p','v', 0 ), // upv = Uripiv-Wala-Rano-Atchin
  TRUETYPE_TAG('u','r','a', 0 ), // ura = Urarina
  TRUETYPE_TAG('u','r','b', 0 ), // urb = Urubú-Kaapor
  TRUETYPE_TAG('u','r','c', 0 ), // urc = Urningangg
  TRUETYPE_TAG('u','r','e', 0 ), // ure = Uru
  TRUETYPE_TAG('u','r','f', 0 ), // urf = Uradhi
  TRUETYPE_TAG('u','r','g', 0 ), // urg = Urigina
  TRUETYPE_TAG('u','r','h', 0 ), // urh = Urhobo
  TRUETYPE_TAG('u','r','i', 0 ), // uri = Urim
  TRUETYPE_TAG('u','r','j', 0 ), // urj = Uralic languages
  TRUETYPE_TAG('u','r','k', 0 ), // urk = Urak Lawoi'
  TRUETYPE_TAG('u','r','l', 0 ), // url = Urali
  TRUETYPE_TAG('u','r','m', 0 ), // urm = Urapmin
  TRUETYPE_TAG('u','r','n', 0 ), // urn = Uruangnirin
  TRUETYPE_TAG('u','r','o', 0 ), // uro = Ura (Papua New Guinea)
  TRUETYPE_TAG('u','r','p', 0 ), // urp = Uru-Pa-In
  TRUETYPE_TAG('u','r','r', 0 ), // urr = Lehalurup
  TRUETYPE_TAG('u','r','t', 0 ), // urt = Urat
  TRUETYPE_TAG('u','r','u', 0 ), // uru = Urumi
  TRUETYPE_TAG('u','r','v', 0 ), // urv = Uruava
  TRUETYPE_TAG('u','r','w', 0 ), // urw = Sop
  TRUETYPE_TAG('u','r','x', 0 ), // urx = Urimo
  TRUETYPE_TAG('u','r','y', 0 ), // ury = Orya
  TRUETYPE_TAG('u','r','z', 0 ), // urz = Uru-Eu-Wau-Wau
  TRUETYPE_TAG('u','s','a', 0 ), // usa = Usarufa
  TRUETYPE_TAG('u','s','h', 0 ), // ush = Ushojo
  TRUETYPE_TAG('u','s','i', 0 ), // usi = Usui
  TRUETYPE_TAG('u','s','k', 0 ), // usk = Usaghade
  TRUETYPE_TAG('u','s','p', 0 ), // usp = Uspanteco
  TRUETYPE_TAG('u','s','u', 0 ), // usu = Uya
  TRUETYPE_TAG('u','t','a', 0 ), // uta = Otank
  TRUETYPE_TAG('u','t','e', 0 ), // ute = Ute-Southern Paiute
  TRUETYPE_TAG('u','t','p', 0 ), // utp = Amba (Solomon Islands)
  TRUETYPE_TAG('u','t','r', 0 ), // utr = Etulo
  TRUETYPE_TAG('u','t','u', 0 ), // utu = Utu
  TRUETYPE_TAG('u','u','m', 0 ), // uum = Urum
  TRUETYPE_TAG('u','u','n', 0 ), // uun = Kulon-Pazeh
  TRUETYPE_TAG('u','u','r', 0 ), // uur = Ura (Vanuatu)
  TRUETYPE_TAG('u','u','u', 0 ), // uuu = U
  TRUETYPE_TAG('u','v','e', 0 ), // uve = West Uvean
  TRUETYPE_TAG('u','v','h', 0 ), // uvh = Uri
  TRUETYPE_TAG('u','v','l', 0 ), // uvl = Lote
  TRUETYPE_TAG('u','w','a', 0 ), // uwa = Kuku-Uwanh
  TRUETYPE_TAG('u','y','a', 0 ), // uya = Doko-Uyanga
  TRUETYPE_TAG('u','z','n', 0 ), // uzn = Northern Uzbek
  TRUETYPE_TAG('u','z','s', 0 ), // uzs = Southern Uzbek
  TRUETYPE_TAG('v','a','a', 0 ), // vaa = Vaagri Booli
  TRUETYPE_TAG('v','a','e', 0 ), // vae = Vale
  TRUETYPE_TAG('v','a','f', 0 ), // vaf = Vafsi
  TRUETYPE_TAG('v','a','g', 0 ), // vag = Vagla
  TRUETYPE_TAG('v','a','h', 0 ), // vah = Varhadi-Nagpuri
  TRUETYPE_TAG('v','a','i', 0 ), // vai = Vai
  TRUETYPE_TAG('v','a','j', 0 ), // vaj = Vasekela Bushman
  TRUETYPE_TAG('v','a','l', 0 ), // val = Vehes
  TRUETYPE_TAG('v','a','m', 0 ), // vam = Vanimo
  TRUETYPE_TAG('v','a','n', 0 ), // van = Valman
  TRUETYPE_TAG('v','a','o', 0 ), // vao = Vao
  TRUETYPE_TAG('v','a','p', 0 ), // vap = Vaiphei
  TRUETYPE_TAG('v','a','r', 0 ), // var = Huarijio
  TRUETYPE_TAG('v','a','s', 0 ), // vas = Vasavi
  TRUETYPE_TAG('v','a','u', 0 ), // vau = Vanuma
  TRUETYPE_TAG('v','a','v', 0 ), // vav = Varli
  TRUETYPE_TAG('v','a','y', 0 ), // vay = Wayu
  TRUETYPE_TAG('v','b','b', 0 ), // vbb = Southeast Babar
  TRUETYPE_TAG('v','b','k', 0 ), // vbk = Southwestern Bontok
  TRUETYPE_TAG('v','e','c', 0 ), // vec = Venetian
  TRUETYPE_TAG('v','e','d', 0 ), // ved = Veddah
  TRUETYPE_TAG('v','e','l', 0 ), // vel = Veluws
  TRUETYPE_TAG('v','e','m', 0 ), // vem = Vemgo-Mabas
  TRUETYPE_TAG('v','e','o', 0 ), // veo = Ventureño
  TRUETYPE_TAG('v','e','p', 0 ), // vep = Veps
  TRUETYPE_TAG('v','e','r', 0 ), // ver = Mom Jango
  TRUETYPE_TAG('v','g','r', 0 ), // vgr = Vaghri
  TRUETYPE_TAG('v','g','t', 0 ), // vgt = Vlaamse Gebarentaal
  TRUETYPE_TAG('v','i','c', 0 ), // vic = Virgin Islands Creole English
  TRUETYPE_TAG('v','i','d', 0 ), // vid = Vidunda
  TRUETYPE_TAG('v','i','f', 0 ), // vif = Vili
  TRUETYPE_TAG('v','i','g', 0 ), // vig = Viemo
  TRUETYPE_TAG('v','i','l', 0 ), // vil = Vilela
  TRUETYPE_TAG('v','i','n', 0 ), // vin = Vinza
  TRUETYPE_TAG('v','i','s', 0 ), // vis = Vishavan
  TRUETYPE_TAG('v','i','t', 0 ), // vit = Viti
  TRUETYPE_TAG('v','i','v', 0 ), // viv = Iduna
  TRUETYPE_TAG('v','k','a', 0 ), // vka = Kariyarra
  TRUETYPE_TAG('v','k','i', 0 ), // vki = Ija-Zuba
  TRUETYPE_TAG('v','k','j', 0 ), // vkj = Kujarge
  TRUETYPE_TAG('v','k','k', 0 ), // vkk = Kaur
  TRUETYPE_TAG('v','k','l', 0 ), // vkl = Kulisusu
  TRUETYPE_TAG('v','k','m', 0 ), // vkm = Kamakan
  TRUETYPE_TAG('v','k','o', 0 ), // vko = Kodeoha
  TRUETYPE_TAG('v','k','p', 0 ), // vkp = Korlai Creole Portuguese
  TRUETYPE_TAG('v','k','t', 0 ), // vkt = Tenggarong Kutai Malay
  TRUETYPE_TAG('v','k','u', 0 ), // vku = Kurrama
  TRUETYPE_TAG('v','l','p', 0 ), // vlp = Valpei
  TRUETYPE_TAG('v','l','s', 0 ), // vls = Vlaams
  TRUETYPE_TAG('v','m','a', 0 ), // vma = Martuyhunira
  TRUETYPE_TAG('v','m','b', 0 ), // vmb = Mbabaram
  TRUETYPE_TAG('v','m','c', 0 ), // vmc = Juxtlahuaca Mixtec
  TRUETYPE_TAG('v','m','d', 0 ), // vmd = Mudu Koraga
  TRUETYPE_TAG('v','m','e', 0 ), // vme = East Masela
  TRUETYPE_TAG('v','m','f', 0 ), // vmf = Mainfränkisch
  TRUETYPE_TAG('v','m','g', 0 ), // vmg = Minigir
  TRUETYPE_TAG('v','m','h', 0 ), // vmh = Maraghei
  TRUETYPE_TAG('v','m','i', 0 ), // vmi = Miwa
  TRUETYPE_TAG('v','m','j', 0 ), // vmj = Ixtayutla Mixtec
  TRUETYPE_TAG('v','m','k', 0 ), // vmk = Makhuwa-Shirima
  TRUETYPE_TAG('v','m','l', 0 ), // vml = Malgana
  TRUETYPE_TAG('v','m','m', 0 ), // vmm = Mitlatongo Mixtec
  TRUETYPE_TAG('v','m','p', 0 ), // vmp = Soyaltepec Mazatec
  TRUETYPE_TAG('v','m','q', 0 ), // vmq = Soyaltepec Mixtec
  TRUETYPE_TAG('v','m','r', 0 ), // vmr = Marenje
  TRUETYPE_TAG('v','m','s', 0 ), // vms = Moksela
  TRUETYPE_TAG('v','m','u', 0 ), // vmu = Muluridyi
  TRUETYPE_TAG('v','m','v', 0 ), // vmv = Valley Maidu
  TRUETYPE_TAG('v','m','w', 0 ), // vmw = Makhuwa
  TRUETYPE_TAG('v','m','x', 0 ), // vmx = Tamazola Mixtec
  TRUETYPE_TAG('v','m','y', 0 ), // vmy = Ayautla Mazatec
  TRUETYPE_TAG('v','m','z', 0 ), // vmz = Mazatlán Mazatec
  TRUETYPE_TAG('v','n','k', 0 ), // vnk = Vano
  TRUETYPE_TAG('v','n','m', 0 ), // vnm = Vinmavis
  TRUETYPE_TAG('v','n','p', 0 ), // vnp = Vunapu
  TRUETYPE_TAG('v','o','r', 0 ), // vor = Voro
  TRUETYPE_TAG('v','o','t', 0 ), // vot = Votic
  TRUETYPE_TAG('v','r','a', 0 ), // vra = Vera'a
  TRUETYPE_TAG('v','r','o', 0 ), // vro = Võro
  TRUETYPE_TAG('v','r','s', 0 ), // vrs = Varisi
  TRUETYPE_TAG('v','r','t', 0 ), // vrt = Burmbar
  TRUETYPE_TAG('v','s','i', 0 ), // vsi = Moldova Sign Language
  TRUETYPE_TAG('v','s','l', 0 ), // vsl = Venezuelan Sign Language
  TRUETYPE_TAG('v','s','v', 0 ), // vsv = Valencian Sign Language
  TRUETYPE_TAG('v','t','o', 0 ), // vto = Vitou
  TRUETYPE_TAG('v','u','m', 0 ), // vum = Vumbu
  TRUETYPE_TAG('v','u','n', 0 ), // vun = Vunjo
  TRUETYPE_TAG('v','u','t', 0 ), // vut = Vute
  TRUETYPE_TAG('v','w','a', 0 ), // vwa = Awa (China)
  TRUETYPE_TAG('w','a','a', 0 ), // waa = Walla Walla
  TRUETYPE_TAG('w','a','b', 0 ), // wab = Wab
  TRUETYPE_TAG('w','a','c', 0 ), // wac = Wasco-Wishram
  TRUETYPE_TAG('w','a','d', 0 ), // wad = Wandamen
  TRUETYPE_TAG('w','a','e', 0 ), // wae = Walser
  TRUETYPE_TAG('w','a','f', 0 ), // waf = Wakoná
  TRUETYPE_TAG('w','a','g', 0 ), // wag = Wa'ema
  TRUETYPE_TAG('w','a','h', 0 ), // wah = Watubela
  TRUETYPE_TAG('w','a','i', 0 ), // wai = Wares
  TRUETYPE_TAG('w','a','j', 0 ), // waj = Waffa
  TRUETYPE_TAG('w','a','k', 0 ), // wak = Wakashan languages
  TRUETYPE_TAG('w','a','l', 0 ), // wal = Wolaytta
  TRUETYPE_TAG('w','a','m', 0 ), // wam = Wampanoag
  TRUETYPE_TAG('w','a','n', 0 ), // wan = Wan
  TRUETYPE_TAG('w','a','o', 0 ), // wao = Wappo
  TRUETYPE_TAG('w','a','p', 0 ), // wap = Wapishana
  TRUETYPE_TAG('w','a','q', 0 ), // waq = Wageman
  TRUETYPE_TAG('w','a','r', 0 ), // war = Waray (Philippines)
  TRUETYPE_TAG('w','a','s', 0 ), // was = Washo
  TRUETYPE_TAG('w','a','t', 0 ), // wat = Kaninuwa
  TRUETYPE_TAG('w','a','u', 0 ), // wau = Waurá
  TRUETYPE_TAG('w','a','v', 0 ), // wav = Waka
  TRUETYPE_TAG('w','a','w', 0 ), // waw = Waiwai
  TRUETYPE_TAG('w','a','x', 0 ), // wax = Watam
  TRUETYPE_TAG('w','a','y', 0 ), // way = Wayana
  TRUETYPE_TAG('w','a','z', 0 ), // waz = Wampur
  TRUETYPE_TAG('w','b','a', 0 ), // wba = Warao
  TRUETYPE_TAG('w','b','b', 0 ), // wbb = Wabo
  TRUETYPE_TAG('w','b','e', 0 ), // wbe = Waritai
  TRUETYPE_TAG('w','b','f', 0 ), // wbf = Wara
  TRUETYPE_TAG('w','b','h', 0 ), // wbh = Wanda
  TRUETYPE_TAG('w','b','i', 0 ), // wbi = Vwanji
  TRUETYPE_TAG('w','b','j', 0 ), // wbj = Alagwa
  TRUETYPE_TAG('w','b','k', 0 ), // wbk = Waigali
  TRUETYPE_TAG('w','b','l', 0 ), // wbl = Wakhi
  TRUETYPE_TAG('w','b','m', 0 ), // wbm = Wa
  TRUETYPE_TAG('w','b','p', 0 ), // wbp = Warlpiri
  TRUETYPE_TAG('w','b','q', 0 ), // wbq = Waddar
  TRUETYPE_TAG('w','b','r', 0 ), // wbr = Wagdi
  TRUETYPE_TAG('w','b','t', 0 ), // wbt = Wanman
  TRUETYPE_TAG('w','b','v', 0 ), // wbv = Wajarri
  TRUETYPE_TAG('w','b','w', 0 ), // wbw = Woi
  TRUETYPE_TAG('w','c','a', 0 ), // wca = Yanomámi
  TRUETYPE_TAG('w','c','i', 0 ), // wci = Waci Gbe
  TRUETYPE_TAG('w','d','d', 0 ), // wdd = Wandji
  TRUETYPE_TAG('w','d','g', 0 ), // wdg = Wadaginam
  TRUETYPE_TAG('w','d','j', 0 ), // wdj = Wadjiginy
  TRUETYPE_TAG('w','d','u', 0 ), // wdu = Wadjigu
  TRUETYPE_TAG('w','e','a', 0 ), // wea = Wewaw
  TRUETYPE_TAG('w','e','c', 0 ), // wec = Wè Western
  TRUETYPE_TAG('w','e','d', 0 ), // wed = Wedau
  TRUETYPE_TAG('w','e','h', 0 ), // weh = Weh
  TRUETYPE_TAG('w','e','i', 0 ), // wei = Kiunum
  TRUETYPE_TAG('w','e','m', 0 ), // wem = Weme Gbe
  TRUETYPE_TAG('w','e','n', 0 ), // wen = Sorbian languages
  TRUETYPE_TAG('w','e','o', 0 ), // weo = North Wemale
  TRUETYPE_TAG('w','e','p', 0 ), // wep = Westphalien
  TRUETYPE_TAG('w','e','r', 0 ), // wer = Weri
  TRUETYPE_TAG('w','e','s', 0 ), // wes = Cameroon Pidgin
  TRUETYPE_TAG('w','e','t', 0 ), // wet = Perai
  TRUETYPE_TAG('w','e','u', 0 ), // weu = Welaung
  TRUETYPE_TAG('w','e','w', 0 ), // wew = Wejewa
  TRUETYPE_TAG('w','f','g', 0 ), // wfg = Yafi
  TRUETYPE_TAG('w','g','a', 0 ), // wga = Wagaya
  TRUETYPE_TAG('w','g','b', 0 ), // wgb = Wagawaga
  TRUETYPE_TAG('w','g','g', 0 ), // wgg = Wangganguru
  TRUETYPE_TAG('w','g','i', 0 ), // wgi = Wahgi
  TRUETYPE_TAG('w','g','o', 0 ), // wgo = Waigeo
  TRUETYPE_TAG('w','g','w', 0 ), // wgw = Wagawaga
  TRUETYPE_TAG('w','g','y', 0 ), // wgy = Warrgamay
  TRUETYPE_TAG('w','h','a', 0 ), // wha = Manusela
  TRUETYPE_TAG('w','h','g', 0 ), // whg = North Wahgi
  TRUETYPE_TAG('w','h','k', 0 ), // whk = Wahau Kenyah
  TRUETYPE_TAG('w','h','u', 0 ), // whu = Wahau Kayan
  TRUETYPE_TAG('w','i','b', 0 ), // wib = Southern Toussian
  TRUETYPE_TAG('w','i','c', 0 ), // wic = Wichita
  TRUETYPE_TAG('w','i','e', 0 ), // wie = Wik-Epa
  TRUETYPE_TAG('w','i','f', 0 ), // wif = Wik-Keyangan
  TRUETYPE_TAG('w','i','g', 0 ), // wig = Wik-Ngathana
  TRUETYPE_TAG('w','i','h', 0 ), // wih = Wik-Me'anha
  TRUETYPE_TAG('w','i','i', 0 ), // wii = Minidien
  TRUETYPE_TAG('w','i','j', 0 ), // wij = Wik-Iiyanh
  TRUETYPE_TAG('w','i','k', 0 ), // wik = Wikalkan
  TRUETYPE_TAG('w','i','l', 0 ), // wil = Wilawila
  TRUETYPE_TAG('w','i','m', 0 ), // wim = Wik-Mungkan
  TRUETYPE_TAG('w','i','n', 0 ), // win = Ho-Chunk
  TRUETYPE_TAG('w','i','r', 0 ), // wir = Wiraféd
  TRUETYPE_TAG('w','i','t', 0 ), // wit = Wintu
  TRUETYPE_TAG('w','i','u', 0 ), // wiu = Wiru
  TRUETYPE_TAG('w','i','v', 0 ), // wiv = Muduapa
  TRUETYPE_TAG('w','i','w', 0 ), // wiw = Wirangu
  TRUETYPE_TAG('w','i','y', 0 ), // wiy = Wiyot
  TRUETYPE_TAG('w','j','a', 0 ), // wja = Waja
  TRUETYPE_TAG('w','j','i', 0 ), // wji = Warji
  TRUETYPE_TAG('w','k','a', 0 ), // wka = Kw'adza
  TRUETYPE_TAG('w','k','b', 0 ), // wkb = Kumbaran
  TRUETYPE_TAG('w','k','d', 0 ), // wkd = Wakde
  TRUETYPE_TAG('w','k','l', 0 ), // wkl = Kalanadi
  TRUETYPE_TAG('w','k','u', 0 ), // wku = Kunduvadi
  TRUETYPE_TAG('w','k','w', 0 ), // wkw = Wakawaka
  TRUETYPE_TAG('w','l','a', 0 ), // wla = Walio
  TRUETYPE_TAG('w','l','c', 0 ), // wlc = Mwali Comorian
  TRUETYPE_TAG('w','l','e', 0 ), // wle = Wolane
  TRUETYPE_TAG('w','l','g', 0 ), // wlg = Kunbarlang
  TRUETYPE_TAG('w','l','i', 0 ), // wli = Waioli
  TRUETYPE_TAG('w','l','k', 0 ), // wlk = Wailaki
  TRUETYPE_TAG('w','l','l', 0 ), // wll = Wali (Sudan)
  TRUETYPE_TAG('w','l','m', 0 ), // wlm = Middle Welsh
  TRUETYPE_TAG('w','l','o', 0 ), // wlo = Wolio
  TRUETYPE_TAG('w','l','r', 0 ), // wlr = Wailapa
  TRUETYPE_TAG('w','l','s', 0 ), // wls = Wallisian
  TRUETYPE_TAG('w','l','u', 0 ), // wlu = Wuliwuli
  TRUETYPE_TAG('w','l','v', 0 ), // wlv = Wichí Lhamtés Vejoz
  TRUETYPE_TAG('w','l','w', 0 ), // wlw = Walak
  TRUETYPE_TAG('w','l','x', 0 ), // wlx = Wali (Ghana)
  TRUETYPE_TAG('w','l','y', 0 ), // wly = Waling
  TRUETYPE_TAG('w','m','a', 0 ), // wma = Mawa (Nigeria)
  TRUETYPE_TAG('w','m','b', 0 ), // wmb = Wambaya
  TRUETYPE_TAG('w','m','c', 0 ), // wmc = Wamas
  TRUETYPE_TAG('w','m','d', 0 ), // wmd = Mamaindé
  TRUETYPE_TAG('w','m','e', 0 ), // wme = Wambule
  TRUETYPE_TAG('w','m','h', 0 ), // wmh = Waima'a
  TRUETYPE_TAG('w','m','i', 0 ), // wmi = Wamin
  TRUETYPE_TAG('w','m','m', 0 ), // wmm = Maiwa (Indonesia)
  TRUETYPE_TAG('w','m','n', 0 ), // wmn = Waamwang
  TRUETYPE_TAG('w','m','o', 0 ), // wmo = Wom (Papua New Guinea)
  TRUETYPE_TAG('w','m','s', 0 ), // wms = Wambon
  TRUETYPE_TAG('w','m','t', 0 ), // wmt = Walmajarri
  TRUETYPE_TAG('w','m','w', 0 ), // wmw = Mwani
  TRUETYPE_TAG('w','m','x', 0 ), // wmx = Womo
  TRUETYPE_TAG('w','n','b', 0 ), // wnb = Wanambre
  TRUETYPE_TAG('w','n','c', 0 ), // wnc = Wantoat
  TRUETYPE_TAG('w','n','d', 0 ), // wnd = Wandarang
  TRUETYPE_TAG('w','n','e', 0 ), // wne = Waneci
  TRUETYPE_TAG('w','n','g', 0 ), // wng = Wanggom
  TRUETYPE_TAG('w','n','i', 0 ), // wni = Ndzwani Comorian
  TRUETYPE_TAG('w','n','k', 0 ), // wnk = Wanukaka
  TRUETYPE_TAG('w','n','m', 0 ), // wnm = Wanggamala
  TRUETYPE_TAG('w','n','o', 0 ), // wno = Wano
  TRUETYPE_TAG('w','n','p', 0 ), // wnp = Wanap
  TRUETYPE_TAG('w','n','u', 0 ), // wnu = Usan
  TRUETYPE_TAG('w','o','a', 0 ), // woa = Tyaraity
  TRUETYPE_TAG('w','o','b', 0 ), // wob = Wè Northern
  TRUETYPE_TAG('w','o','c', 0 ), // woc = Wogeo
  TRUETYPE_TAG('w','o','d', 0 ), // wod = Wolani
  TRUETYPE_TAG('w','o','e', 0 ), // woe = Woleaian
  TRUETYPE_TAG('w','o','f', 0 ), // wof = Gambian Wolof
  TRUETYPE_TAG('w','o','g', 0 ), // wog = Wogamusin
  TRUETYPE_TAG('w','o','i', 0 ), // woi = Kamang
  TRUETYPE_TAG('w','o','k', 0 ), // wok = Longto
  TRUETYPE_TAG('w','o','m', 0 ), // wom = Wom (Nigeria)
  TRUETYPE_TAG('w','o','n', 0 ), // won = Wongo
  TRUETYPE_TAG('w','o','o', 0 ), // woo = Manombai
  TRUETYPE_TAG('w','o','r', 0 ), // wor = Woria
  TRUETYPE_TAG('w','o','s', 0 ), // wos = Hanga Hundi
  TRUETYPE_TAG('w','o','w', 0 ), // wow = Wawonii
  TRUETYPE_TAG('w','o','y', 0 ), // woy = Weyto
  TRUETYPE_TAG('w','p','c', 0 ), // wpc = Maco
  TRUETYPE_TAG('w','r','a', 0 ), // wra = Warapu
  TRUETYPE_TAG('w','r','b', 0 ), // wrb = Warluwara
  TRUETYPE_TAG('w','r','d', 0 ), // wrd = Warduji
  TRUETYPE_TAG('w','r','g', 0 ), // wrg = Warungu
  TRUETYPE_TAG('w','r','h', 0 ), // wrh = Wiradhuri
  TRUETYPE_TAG('w','r','i', 0 ), // wri = Wariyangga
  TRUETYPE_TAG('w','r','l', 0 ), // wrl = Warlmanpa
  TRUETYPE_TAG('w','r','m', 0 ), // wrm = Warumungu
  TRUETYPE_TAG('w','r','n', 0 ), // wrn = Warnang
  TRUETYPE_TAG('w','r','p', 0 ), // wrp = Waropen
  TRUETYPE_TAG('w','r','r', 0 ), // wrr = Wardaman
  TRUETYPE_TAG('w','r','s', 0 ), // wrs = Waris
  TRUETYPE_TAG('w','r','u', 0 ), // wru = Waru
  TRUETYPE_TAG('w','r','v', 0 ), // wrv = Waruna
  TRUETYPE_TAG('w','r','w', 0 ), // wrw = Gugu Warra
  TRUETYPE_TAG('w','r','x', 0 ), // wrx = Wae Rana
  TRUETYPE_TAG('w','r','y', 0 ), // wry = Merwari
  TRUETYPE_TAG('w','r','z', 0 ), // wrz = Waray (Australia)
  TRUETYPE_TAG('w','s','a', 0 ), // wsa = Warembori
  TRUETYPE_TAG('w','s','i', 0 ), // wsi = Wusi
  TRUETYPE_TAG('w','s','k', 0 ), // wsk = Waskia
  TRUETYPE_TAG('w','s','r', 0 ), // wsr = Owenia
  TRUETYPE_TAG('w','s','s', 0 ), // wss = Wasa
  TRUETYPE_TAG('w','s','u', 0 ), // wsu = Wasu
  TRUETYPE_TAG('w','s','v', 0 ), // wsv = Wotapuri-Katarqalai
  TRUETYPE_TAG('w','t','f', 0 ), // wtf = Watiwa
  TRUETYPE_TAG('w','t','i', 0 ), // wti = Berta
  TRUETYPE_TAG('w','t','k', 0 ), // wtk = Watakataui
  TRUETYPE_TAG('w','t','m', 0 ), // wtm = Mewati
  TRUETYPE_TAG('w','t','w', 0 ), // wtw = Wotu
  TRUETYPE_TAG('w','u','a', 0 ), // wua = Wikngenchera
  TRUETYPE_TAG('w','u','b', 0 ), // wub = Wunambal
  TRUETYPE_TAG('w','u','d', 0 ), // wud = Wudu
  TRUETYPE_TAG('w','u','h', 0 ), // wuh = Wutunhua
  TRUETYPE_TAG('w','u','l', 0 ), // wul = Silimo
  TRUETYPE_TAG('w','u','m', 0 ), // wum = Wumbvu
  TRUETYPE_TAG('w','u','n', 0 ), // wun = Bungu
  TRUETYPE_TAG('w','u','r', 0 ), // wur = Wurrugu
  TRUETYPE_TAG('w','u','t', 0 ), // wut = Wutung
  TRUETYPE_TAG('w','u','u', 0 ), // wuu = Wu Chinese
  TRUETYPE_TAG('w','u','v', 0 ), // wuv = Wuvulu-Aua
  TRUETYPE_TAG('w','u','x', 0 ), // wux = Wulna
  TRUETYPE_TAG('w','u','y', 0 ), // wuy = Wauyai
  TRUETYPE_TAG('w','w','a', 0 ), // wwa = Waama
  TRUETYPE_TAG('w','w','o', 0 ), // wwo = Wetamut
  TRUETYPE_TAG('w','w','r', 0 ), // wwr = Warrwa
  TRUETYPE_TAG('w','w','w', 0 ), // www = Wawa
  TRUETYPE_TAG('w','x','a', 0 ), // wxa = Waxianghua
  TRUETYPE_TAG('w','y','a', 0 ), // wya = Wyandot
  TRUETYPE_TAG('w','y','b', 0 ), // wyb = Wangaaybuwan-Ngiyambaa
  TRUETYPE_TAG('w','y','m', 0 ), // wym = Wymysorys
  TRUETYPE_TAG('w','y','r', 0 ), // wyr = Wayoró
  TRUETYPE_TAG('w','y','y', 0 ), // wyy = Western Fijian
  TRUETYPE_TAG('x','a','a', 0 ), // xaa = Andalusian Arabic
  TRUETYPE_TAG('x','a','b', 0 ), // xab = Sambe
  TRUETYPE_TAG('x','a','c', 0 ), // xac = Kachari
  TRUETYPE_TAG('x','a','d', 0 ), // xad = Adai
  TRUETYPE_TAG('x','a','e', 0 ), // xae = Aequian
  TRUETYPE_TAG('x','a','g', 0 ), // xag = Aghwan
  TRUETYPE_TAG('x','a','i', 0 ), // xai = Kaimbé
  TRUETYPE_TAG('x','a','l', 0 ), // xal = Kalmyk
  TRUETYPE_TAG('x','a','m', 0 ), // xam = /Xam
  TRUETYPE_TAG('x','a','n', 0 ), // xan = Xamtanga
  TRUETYPE_TAG('x','a','o', 0 ), // xao = Khao
  TRUETYPE_TAG('x','a','p', 0 ), // xap = Apalachee
  TRUETYPE_TAG('x','a','q', 0 ), // xaq = Aquitanian
  TRUETYPE_TAG('x','a','r', 0 ), // xar = Karami
  TRUETYPE_TAG('x','a','s', 0 ), // xas = Kamas
  TRUETYPE_TAG('x','a','t', 0 ), // xat = Katawixi
  TRUETYPE_TAG('x','a','u', 0 ), // xau = Kauwera
  TRUETYPE_TAG('x','a','v', 0 ), // xav = Xavánte
  TRUETYPE_TAG('x','a','w', 0 ), // xaw = Kawaiisu
  TRUETYPE_TAG('x','a','y', 0 ), // xay = Kayan Mahakam
  TRUETYPE_TAG('x','b','a', 0 ), // xba = Kamba (Brazil)
  TRUETYPE_TAG('x','b','b', 0 ), // xbb = Lower Burdekin
  TRUETYPE_TAG('x','b','c', 0 ), // xbc = Bactrian
  TRUETYPE_TAG('x','b','i', 0 ), // xbi = Kombio
  TRUETYPE_TAG('x','b','m', 0 ), // xbm = Middle Breton
  TRUETYPE_TAG('x','b','n', 0 ), // xbn = Kenaboi
  TRUETYPE_TAG('x','b','o', 0 ), // xbo = Bolgarian
  TRUETYPE_TAG('x','b','r', 0 ), // xbr = Kambera
  TRUETYPE_TAG('x','b','w', 0 ), // xbw = Kambiwá
  TRUETYPE_TAG('x','b','x', 0 ), // xbx = Kabixí
  TRUETYPE_TAG('x','c','b', 0 ), // xcb = Cumbric
  TRUETYPE_TAG('x','c','c', 0 ), // xcc = Camunic
  TRUETYPE_TAG('x','c','e', 0 ), // xce = Celtiberian
  TRUETYPE_TAG('x','c','g', 0 ), // xcg = Cisalpine Gaulish
  TRUETYPE_TAG('x','c','h', 0 ), // xch = Chemakum
  TRUETYPE_TAG('x','c','l', 0 ), // xcl = Classical Armenian
  TRUETYPE_TAG('x','c','m', 0 ), // xcm = Comecrudo
  TRUETYPE_TAG('x','c','n', 0 ), // xcn = Cotoname
  TRUETYPE_TAG('x','c','o', 0 ), // xco = Chorasmian
  TRUETYPE_TAG('x','c','r', 0 ), // xcr = Carian
  TRUETYPE_TAG('x','c','t', 0 ), // xct = Classical Tibetan
  TRUETYPE_TAG('x','c','u', 0 ), // xcu = Curonian
  TRUETYPE_TAG('x','c','v', 0 ), // xcv = Chuvantsy
  TRUETYPE_TAG('x','c','w', 0 ), // xcw = Coahuilteco
  TRUETYPE_TAG('x','c','y', 0 ), // xcy = Cayuse
  TRUETYPE_TAG('x','d','c', 0 ), // xdc = Dacian
  TRUETYPE_TAG('x','d','m', 0 ), // xdm = Edomite
  TRUETYPE_TAG('x','d','y', 0 ), // xdy = Malayic Dayak
  TRUETYPE_TAG('x','e','b', 0 ), // xeb = Eblan
  TRUETYPE_TAG('x','e','d', 0 ), // xed = Hdi
  TRUETYPE_TAG('x','e','g', 0 ), // xeg = //Xegwi
  TRUETYPE_TAG('x','e','l', 0 ), // xel = Kelo
  TRUETYPE_TAG('x','e','m', 0 ), // xem = Kembayan
  TRUETYPE_TAG('x','e','p', 0 ), // xep = Epi-Olmec
  TRUETYPE_TAG('x','e','r', 0 ), // xer = Xerénte
  TRUETYPE_TAG('x','e','s', 0 ), // xes = Kesawai
  TRUETYPE_TAG('x','e','t', 0 ), // xet = Xetá
  TRUETYPE_TAG('x','e','u', 0 ), // xeu = Keoru-Ahia
  TRUETYPE_TAG('x','f','a', 0 ), // xfa = Faliscan
  TRUETYPE_TAG('x','g','a', 0 ), // xga = Galatian
  TRUETYPE_TAG('x','g','f', 0 ), // xgf = Gabrielino-Fernandeño
  TRUETYPE_TAG('x','g','l', 0 ), // xgl = Galindan
  TRUETYPE_TAG('x','g','n', 0 ), // xgn = Mongolian languages
  TRUETYPE_TAG('x','g','r', 0 ), // xgr = Garza
  TRUETYPE_TAG('x','h','a', 0 ), // xha = Harami
  TRUETYPE_TAG('x','h','c', 0 ), // xhc = Hunnic
  TRUETYPE_TAG('x','h','d', 0 ), // xhd = Hadrami
  TRUETYPE_TAG('x','h','e', 0 ), // xhe = Khetrani
  TRUETYPE_TAG('x','h','r', 0 ), // xhr = Hernican
  TRUETYPE_TAG('x','h','t', 0 ), // xht = Hattic
  TRUETYPE_TAG('x','h','u', 0 ), // xhu = Hurrian
  TRUETYPE_TAG('x','h','v', 0 ), // xhv = Khua
  TRUETYPE_TAG('x','i','a', 0 ), // xia = Xiandao
  TRUETYPE_TAG('x','i','b', 0 ), // xib = Iberian
  TRUETYPE_TAG('x','i','i', 0 ), // xii = Xiri
  TRUETYPE_TAG('x','i','l', 0 ), // xil = Illyrian
  TRUETYPE_TAG('x','i','n', 0 ), // xin = Xinca
  TRUETYPE_TAG('x','i','p', 0 ), // xip = Xipináwa
  TRUETYPE_TAG('x','i','r', 0 ), // xir = Xiriâna
  TRUETYPE_TAG('x','i','v', 0 ), // xiv = Indus Valley Language
  TRUETYPE_TAG('x','i','y', 0 ), // xiy = Xipaya
  TRUETYPE_TAG('x','k','a', 0 ), // xka = Kalkoti
  TRUETYPE_TAG('x','k','b', 0 ), // xkb = Northern Nago
  TRUETYPE_TAG('x','k','c', 0 ), // xkc = Kho'ini
  TRUETYPE_TAG('x','k','d', 0 ), // xkd = Mendalam Kayan
  TRUETYPE_TAG('x','k','e', 0 ), // xke = Kereho
  TRUETYPE_TAG('x','k','f', 0 ), // xkf = Khengkha
  TRUETYPE_TAG('x','k','g', 0 ), // xkg = Kagoro
  TRUETYPE_TAG('x','k','h', 0 ), // xkh = Karahawyana
  TRUETYPE_TAG('x','k','i', 0 ), // xki = Kenyan Sign Language
  TRUETYPE_TAG('x','k','j', 0 ), // xkj = Kajali
  TRUETYPE_TAG('x','k','k', 0 ), // xkk = Kaco'
  TRUETYPE_TAG('x','k','l', 0 ), // xkl = Mainstream Kenyah
  TRUETYPE_TAG('x','k','n', 0 ), // xkn = Kayan River Kayan
  TRUETYPE_TAG('x','k','o', 0 ), // xko = Kiorr
  TRUETYPE_TAG('x','k','p', 0 ), // xkp = Kabatei
  TRUETYPE_TAG('x','k','q', 0 ), // xkq = Koroni
  TRUETYPE_TAG('x','k','r', 0 ), // xkr = Xakriabá
  TRUETYPE_TAG('x','k','s', 0 ), // xks = Kumbewaha
  TRUETYPE_TAG('x','k','t', 0 ), // xkt = Kantosi
  TRUETYPE_TAG('x','k','u', 0 ), // xku = Kaamba
  TRUETYPE_TAG('x','k','v', 0 ), // xkv = Kgalagadi
  TRUETYPE_TAG('x','k','w', 0 ), // xkw = Kembra
  TRUETYPE_TAG('x','k','x', 0 ), // xkx = Karore
  TRUETYPE_TAG('x','k','y', 0 ), // xky = Uma' Lasan
  TRUETYPE_TAG('x','k','z', 0 ), // xkz = Kurtokha
  TRUETYPE_TAG('x','l','a', 0 ), // xla = Kamula
  TRUETYPE_TAG('x','l','b', 0 ), // xlb = Loup B
  TRUETYPE_TAG('x','l','c', 0 ), // xlc = Lycian
  TRUETYPE_TAG('x','l','d', 0 ), // xld = Lydian
  TRUETYPE_TAG('x','l','e', 0 ), // xle = Lemnian
  TRUETYPE_TAG('x','l','g', 0 ), // xlg = Ligurian (Ancient)
  TRUETYPE_TAG('x','l','i', 0 ), // xli = Liburnian
  TRUETYPE_TAG('x','l','n', 0 ), // xln = Alanic
  TRUETYPE_TAG('x','l','o', 0 ), // xlo = Loup A
  TRUETYPE_TAG('x','l','p', 0 ), // xlp = Lepontic
  TRUETYPE_TAG('x','l','s', 0 ), // xls = Lusitanian
  TRUETYPE_TAG('x','l','u', 0 ), // xlu = Cuneiform Luwian
  TRUETYPE_TAG('x','l','y', 0 ), // xly = Elymian
  TRUETYPE_TAG('x','m','a', 0 ), // xma = Mushungulu
  TRUETYPE_TAG('x','m','b', 0 ), // xmb = Mbonga
  TRUETYPE_TAG('x','m','c', 0 ), // xmc = Makhuwa-Marrevone
  TRUETYPE_TAG('x','m','d', 0 ), // xmd = Mbudum
  TRUETYPE_TAG('x','m','e', 0 ), // xme = Median
  TRUETYPE_TAG('x','m','f', 0 ), // xmf = Mingrelian
  TRUETYPE_TAG('x','m','g', 0 ), // xmg = Mengaka
  TRUETYPE_TAG('x','m','h', 0 ), // xmh = Kuku-Muminh
  TRUETYPE_TAG('x','m','j', 0 ), // xmj = Majera
  TRUETYPE_TAG('x','m','k', 0 ), // xmk = Ancient Macedonian
  TRUETYPE_TAG('x','m','l', 0 ), // xml = Malaysian Sign Language
  TRUETYPE_TAG('x','m','m', 0 ), // xmm = Manado Malay
  TRUETYPE_TAG('x','m','n', 0 ), // xmn = Manichaean Middle Persian
  TRUETYPE_TAG('x','m','o', 0 ), // xmo = Morerebi
  TRUETYPE_TAG('x','m','p', 0 ), // xmp = Kuku-Mu'inh
  TRUETYPE_TAG('x','m','q', 0 ), // xmq = Kuku-Mangk
  TRUETYPE_TAG('x','m','r', 0 ), // xmr = Meroitic
  TRUETYPE_TAG('x','m','s', 0 ), // xms = Moroccan Sign Language
  TRUETYPE_TAG('x','m','t', 0 ), // xmt = Matbat
  TRUETYPE_TAG('x','m','u', 0 ), // xmu = Kamu
  TRUETYPE_TAG('x','m','v', 0 ), // xmv = Antankarana Malagasy
  TRUETYPE_TAG('x','m','w', 0 ), // xmw = Tsimihety Malagasy
  TRUETYPE_TAG('x','m','x', 0 ), // xmx = Maden
  TRUETYPE_TAG('x','m','y', 0 ), // xmy = Mayaguduna
  TRUETYPE_TAG('x','m','z', 0 ), // xmz = Mori Bawah
  TRUETYPE_TAG('x','n','a', 0 ), // xna = Ancient North Arabian
  TRUETYPE_TAG('x','n','b', 0 ), // xnb = Kanakanabu
  TRUETYPE_TAG('x','n','d', 0 ), // xnd = Na-Dene languages
  TRUETYPE_TAG('x','n','g', 0 ), // xng = Middle Mongolian
  TRUETYPE_TAG('x','n','h', 0 ), // xnh = Kuanhua
  TRUETYPE_TAG('x','n','n', 0 ), // xnn = Northern Kankanay
  TRUETYPE_TAG('x','n','o', 0 ), // xno = Anglo-Norman
  TRUETYPE_TAG('x','n','r', 0 ), // xnr = Kangri
  TRUETYPE_TAG('x','n','s', 0 ), // xns = Kanashi
  TRUETYPE_TAG('x','n','t', 0 ), // xnt = Narragansett
  TRUETYPE_TAG('x','o','c', 0 ), // xoc = O'chi'chi'
  TRUETYPE_TAG('x','o','d', 0 ), // xod = Kokoda
  TRUETYPE_TAG('x','o','g', 0 ), // xog = Soga
  TRUETYPE_TAG('x','o','i', 0 ), // xoi = Kominimung
  TRUETYPE_TAG('x','o','k', 0 ), // xok = Xokleng
  TRUETYPE_TAG('x','o','m', 0 ), // xom = Komo (Sudan)
  TRUETYPE_TAG('x','o','n', 0 ), // xon = Konkomba
  TRUETYPE_TAG('x','o','o', 0 ), // xoo = Xukurú
  TRUETYPE_TAG('x','o','p', 0 ), // xop = Kopar
  TRUETYPE_TAG('x','o','r', 0 ), // xor = Korubo
  TRUETYPE_TAG('x','o','w', 0 ), // xow = Kowaki
  TRUETYPE_TAG('x','p','c', 0 ), // xpc = Pecheneg
  TRUETYPE_TAG('x','p','e', 0 ), // xpe = Liberia Kpelle
  TRUETYPE_TAG('x','p','g', 0 ), // xpg = Phrygian
  TRUETYPE_TAG('x','p','i', 0 ), // xpi = Pictish
  TRUETYPE_TAG('x','p','k', 0 ), // xpk = Kulina Pano
  TRUETYPE_TAG('x','p','m', 0 ), // xpm = Pumpokol
  TRUETYPE_TAG('x','p','n', 0 ), // xpn = Kapinawá
  TRUETYPE_TAG('x','p','o', 0 ), // xpo = Pochutec
  TRUETYPE_TAG('x','p','p', 0 ), // xpp = Puyo-Paekche
  TRUETYPE_TAG('x','p','q', 0 ), // xpq = Mohegan-Pequot
  TRUETYPE_TAG('x','p','r', 0 ), // xpr = Parthian
  TRUETYPE_TAG('x','p','s', 0 ), // xps = Pisidian
  TRUETYPE_TAG('x','p','u', 0 ), // xpu = Punic
  TRUETYPE_TAG('x','p','y', 0 ), // xpy = Puyo
  TRUETYPE_TAG('x','q','a', 0 ), // xqa = Karakhanid
  TRUETYPE_TAG('x','q','t', 0 ), // xqt = Qatabanian
  TRUETYPE_TAG('x','r','a', 0 ), // xra = Krahô
  TRUETYPE_TAG('x','r','b', 0 ), // xrb = Eastern Karaboro
  TRUETYPE_TAG('x','r','e', 0 ), // xre = Kreye
  TRUETYPE_TAG('x','r','i', 0 ), // xri = Krikati-Timbira
  TRUETYPE_TAG('x','r','m', 0 ), // xrm = Armazic
  TRUETYPE_TAG('x','r','n', 0 ), // xrn = Arin
  TRUETYPE_TAG('x','r','r', 0 ), // xrr = Raetic
  TRUETYPE_TAG('x','r','t', 0 ), // xrt = Aranama-Tamique
  TRUETYPE_TAG('x','r','u', 0 ), // xru = Marriammu
  TRUETYPE_TAG('x','r','w', 0 ), // xrw = Karawa
  TRUETYPE_TAG('x','s','a', 0 ), // xsa = Sabaean
  TRUETYPE_TAG('x','s','b', 0 ), // xsb = Tinà Sambal
  TRUETYPE_TAG('x','s','c', 0 ), // xsc = Scythian
  TRUETYPE_TAG('x','s','d', 0 ), // xsd = Sidetic
  TRUETYPE_TAG('x','s','e', 0 ), // xse = Sempan
  TRUETYPE_TAG('x','s','h', 0 ), // xsh = Shamang
  TRUETYPE_TAG('x','s','i', 0 ), // xsi = Sio
  TRUETYPE_TAG('x','s','j', 0 ), // xsj = Subi
  TRUETYPE_TAG('x','s','l', 0 ), // xsl = South Slavey
  TRUETYPE_TAG('x','s','m', 0 ), // xsm = Kasem
  TRUETYPE_TAG('x','s','n', 0 ), // xsn = Sanga (Nigeria)
  TRUETYPE_TAG('x','s','o', 0 ), // xso = Solano
  TRUETYPE_TAG('x','s','p', 0 ), // xsp = Silopi
  TRUETYPE_TAG('x','s','q', 0 ), // xsq = Makhuwa-Saka
  TRUETYPE_TAG('x','s','r', 0 ), // xsr = Sherpa
  TRUETYPE_TAG('x','s','s', 0 ), // xss = Assan
  TRUETYPE_TAG('x','s','u', 0 ), // xsu = Sanumá
  TRUETYPE_TAG('x','s','v', 0 ), // xsv = Sudovian
  TRUETYPE_TAG('x','s','y', 0 ), // xsy = Saisiyat
  TRUETYPE_TAG('x','t','a', 0 ), // xta = Alcozauca Mixtec
  TRUETYPE_TAG('x','t','b', 0 ), // xtb = Chazumba Mixtec
  TRUETYPE_TAG('x','t','c', 0 ), // xtc = Katcha-Kadugli-Miri
  TRUETYPE_TAG('x','t','d', 0 ), // xtd = Diuxi-Tilantongo Mixtec
  TRUETYPE_TAG('x','t','e', 0 ), // xte = Ketengban
  TRUETYPE_TAG('x','t','g', 0 ), // xtg = Transalpine Gaulish
  TRUETYPE_TAG('x','t','i', 0 ), // xti = Sinicahua Mixtec
  TRUETYPE_TAG('x','t','j', 0 ), // xtj = San Juan Teita Mixtec
  TRUETYPE_TAG('x','t','l', 0 ), // xtl = Tijaltepec Mixtec
  TRUETYPE_TAG('x','t','m', 0 ), // xtm = Magdalena Peñasco Mixtec
  TRUETYPE_TAG('x','t','n', 0 ), // xtn = Northern Tlaxiaco Mixtec
  TRUETYPE_TAG('x','t','o', 0 ), // xto = Tokharian A
  TRUETYPE_TAG('x','t','p', 0 ), // xtp = San Miguel Piedras Mixtec
  TRUETYPE_TAG('x','t','q', 0 ), // xtq = Tumshuqese
  TRUETYPE_TAG('x','t','r', 0 ), // xtr = Early Tripuri
  TRUETYPE_TAG('x','t','s', 0 ), // xts = Sindihui Mixtec
  TRUETYPE_TAG('x','t','t', 0 ), // xtt = Tacahua Mixtec
  TRUETYPE_TAG('x','t','u', 0 ), // xtu = Cuyamecalco Mixtec
  TRUETYPE_TAG('x','t','w', 0 ), // xtw = Tawandê
  TRUETYPE_TAG('x','t','y', 0 ), // xty = Yoloxochitl Mixtec
  TRUETYPE_TAG('x','t','z', 0 ), // xtz = Tasmanian
  TRUETYPE_TAG('x','u','a', 0 ), // xua = Alu Kurumba
  TRUETYPE_TAG('x','u','b', 0 ), // xub = Betta Kurumba
  TRUETYPE_TAG('x','u','g', 0 ), // xug = Kunigami
  TRUETYPE_TAG('x','u','j', 0 ), // xuj = Jennu Kurumba
  TRUETYPE_TAG('x','u','m', 0 ), // xum = Umbrian
  TRUETYPE_TAG('x','u','o', 0 ), // xuo = Kuo
  TRUETYPE_TAG('x','u','p', 0 ), // xup = Upper Umpqua
  TRUETYPE_TAG('x','u','r', 0 ), // xur = Urartian
  TRUETYPE_TAG('x','u','t', 0 ), // xut = Kuthant
  TRUETYPE_TAG('x','u','u', 0 ), // xuu = Kxoe
  TRUETYPE_TAG('x','v','e', 0 ), // xve = Venetic
  TRUETYPE_TAG('x','v','i', 0 ), // xvi = Kamviri
  TRUETYPE_TAG('x','v','n', 0 ), // xvn = Vandalic
  TRUETYPE_TAG('x','v','o', 0 ), // xvo = Volscian
  TRUETYPE_TAG('x','v','s', 0 ), // xvs = Vestinian
  TRUETYPE_TAG('x','w','a', 0 ), // xwa = Kwaza
  TRUETYPE_TAG('x','w','c', 0 ), // xwc = Woccon
  TRUETYPE_TAG('x','w','e', 0 ), // xwe = Xwela Gbe
  TRUETYPE_TAG('x','w','g', 0 ), // xwg = Kwegu
  TRUETYPE_TAG('x','w','l', 0 ), // xwl = Western Xwla Gbe
  TRUETYPE_TAG('x','w','o', 0 ), // xwo = Written Oirat
  TRUETYPE_TAG('x','w','r', 0 ), // xwr = Kwerba Mamberamo
  TRUETYPE_TAG('x','x','b', 0 ), // xxb = Boro (Ghana)
  TRUETYPE_TAG('x','x','k', 0 ), // xxk = Ke'o
  TRUETYPE_TAG('x','x','r', 0 ), // xxr = Koropó
  TRUETYPE_TAG('x','x','t', 0 ), // xxt = Tambora
  TRUETYPE_TAG('x','y','l', 0 ), // xyl = Yalakalore
  TRUETYPE_TAG('x','z','h', 0 ), // xzh = Zhang-Zhung
  TRUETYPE_TAG('x','z','m', 0 ), // xzm = Zemgalian
  TRUETYPE_TAG('x','z','p', 0 ), // xzp = Ancient Zapotec
  TRUETYPE_TAG('y','a','a', 0 ), // yaa = Yaminahua
  TRUETYPE_TAG('y','a','b', 0 ), // yab = Yuhup
  TRUETYPE_TAG('y','a','c', 0 ), // yac = Pass Valley Yali
  TRUETYPE_TAG('y','a','d', 0 ), // yad = Yagua
  TRUETYPE_TAG('y','a','e', 0 ), // yae = Pumé
  TRUETYPE_TAG('y','a','f', 0 ), // yaf = Yaka (Democratic Republic of Congo)
  TRUETYPE_TAG('y','a','g', 0 ), // yag = Yámana
  TRUETYPE_TAG('y','a','h', 0 ), // yah = Yazgulyam
  TRUETYPE_TAG('y','a','i', 0 ), // yai = Yagnobi
  TRUETYPE_TAG('y','a','j', 0 ), // yaj = Banda-Yangere
  TRUETYPE_TAG('y','a','k', 0 ), // yak = Yakama
  TRUETYPE_TAG('y','a','l', 0 ), // yal = Yalunka
  TRUETYPE_TAG('y','a','m', 0 ), // yam = Yamba
  TRUETYPE_TAG('y','a','n', 0 ), // yan = Mayangna
  TRUETYPE_TAG('y','a','o', 0 ), // yao = Yao
  TRUETYPE_TAG('y','a','p', 0 ), // yap = Yapese
  TRUETYPE_TAG('y','a','q', 0 ), // yaq = Yaqui
  TRUETYPE_TAG('y','a','r', 0 ), // yar = Yabarana
  TRUETYPE_TAG('y','a','s', 0 ), // yas = Nugunu (Cameroon)
  TRUETYPE_TAG('y','a','t', 0 ), // yat = Yambeta
  TRUETYPE_TAG('y','a','u', 0 ), // yau = Yuwana
  TRUETYPE_TAG('y','a','v', 0 ), // yav = Yangben
  TRUETYPE_TAG('y','a','w', 0 ), // yaw = Yawalapití
  TRUETYPE_TAG('y','a','x', 0 ), // yax = Yauma
  TRUETYPE_TAG('y','a','y', 0 ), // yay = Agwagwune
  TRUETYPE_TAG('y','a','z', 0 ), // yaz = Lokaa
  TRUETYPE_TAG('y','b','a', 0 ), // yba = Yala
  TRUETYPE_TAG('y','b','b', 0 ), // ybb = Yemba
  TRUETYPE_TAG('y','b','d', 0 ), // ybd = Yangbye
  TRUETYPE_TAG('y','b','e', 0 ), // ybe = West Yugur
  TRUETYPE_TAG('y','b','h', 0 ), // ybh = Yakha
  TRUETYPE_TAG('y','b','i', 0 ), // ybi = Yamphu
  TRUETYPE_TAG('y','b','j', 0 ), // ybj = Hasha
  TRUETYPE_TAG('y','b','k', 0 ), // ybk = Bokha
  TRUETYPE_TAG('y','b','l', 0 ), // ybl = Yukuben
  TRUETYPE_TAG('y','b','m', 0 ), // ybm = Yaben
  TRUETYPE_TAG('y','b','n', 0 ), // ybn = Yabaâna
  TRUETYPE_TAG('y','b','o', 0 ), // ybo = Yabong
  TRUETYPE_TAG('y','b','x', 0 ), // ybx = Yawiyo
  TRUETYPE_TAG('y','b','y', 0 ), // yby = Yaweyuha
  TRUETYPE_TAG('y','c','h', 0 ), // ych = Chesu
  TRUETYPE_TAG('y','c','l', 0 ), // ycl = Lolopo
  TRUETYPE_TAG('y','c','n', 0 ), // ycn = Yucuna
  TRUETYPE_TAG('y','c','p', 0 ), // ycp = Chepya
  TRUETYPE_TAG('y','d','d', 0 ), // ydd = Eastern Yiddish
  TRUETYPE_TAG('y','d','e', 0 ), // yde = Yangum Dey
  TRUETYPE_TAG('y','d','g', 0 ), // ydg = Yidgha
  TRUETYPE_TAG('y','d','k', 0 ), // ydk = Yoidik
  TRUETYPE_TAG('y','d','s', 0 ), // yds = Yiddish Sign Language
  TRUETYPE_TAG('y','e','a', 0 ), // yea = Ravula
  TRUETYPE_TAG('y','e','c', 0 ), // yec = Yeniche
  TRUETYPE_TAG('y','e','e', 0 ), // yee = Yimas
  TRUETYPE_TAG('y','e','i', 0 ), // yei = Yeni
  TRUETYPE_TAG('y','e','j', 0 ), // yej = Yevanic
  TRUETYPE_TAG('y','e','l', 0 ), // yel = Yela
  TRUETYPE_TAG('y','e','n', 0 ), // yen = Yendang
  TRUETYPE_TAG('y','e','r', 0 ), // yer = Tarok
  TRUETYPE_TAG('y','e','s', 0 ), // yes = Yeskwa
  TRUETYPE_TAG('y','e','t', 0 ), // yet = Yetfa
  TRUETYPE_TAG('y','e','u', 0 ), // yeu = Yerukula
  TRUETYPE_TAG('y','e','v', 0 ), // yev = Yapunda
  TRUETYPE_TAG('y','e','y', 0 ), // yey = Yeyi
  TRUETYPE_TAG('y','g','l', 0 ), // ygl = Yangum Gel
  TRUETYPE_TAG('y','g','m', 0 ), // ygm = Yagomi
  TRUETYPE_TAG('y','g','p', 0 ), // ygp = Gepo
  TRUETYPE_TAG('y','g','r', 0 ), // ygr = Yagaria
  TRUETYPE_TAG('y','g','w', 0 ), // ygw = Yagwoia
  TRUETYPE_TAG('y','h','a', 0 ), // yha = Baha Buyang
  TRUETYPE_TAG('y','h','d', 0 ), // yhd = Judeo-Iraqi Arabic
  TRUETYPE_TAG('y','h','l', 0 ), // yhl = Hlepho Phowa
  TRUETYPE_TAG('y','i','a', 0 ), // yia = Yinggarda
  TRUETYPE_TAG('y','i','f', 0 ), // yif = Ache
  TRUETYPE_TAG('y','i','g', 0 ), // yig = Wusa Nasu
  TRUETYPE_TAG('y','i','h', 0 ), // yih = Western Yiddish
  TRUETYPE_TAG('y','i','i', 0 ), // yii = Yidiny
  TRUETYPE_TAG('y','i','j', 0 ), // yij = Yindjibarndi
  TRUETYPE_TAG('y','i','k', 0 ), // yik = Dongshanba Lalo
  TRUETYPE_TAG('y','i','l', 0 ), // yil = Yindjilandji
  TRUETYPE_TAG('y','i','m', 0 ), // yim = Yimchungru Naga
  TRUETYPE_TAG('y','i','n', 0 ), // yin = Yinchia
  TRUETYPE_TAG('y','i','p', 0 ), // yip = Pholo
  TRUETYPE_TAG('y','i','q', 0 ), // yiq = Miqie
  TRUETYPE_TAG('y','i','r', 0 ), // yir = North Awyu
  TRUETYPE_TAG('y','i','s', 0 ), // yis = Yis
  TRUETYPE_TAG('y','i','t', 0 ), // yit = Eastern Lalu
  TRUETYPE_TAG('y','i','u', 0 ), // yiu = Awu
  TRUETYPE_TAG('y','i','v', 0 ), // yiv = Northern Nisu
  TRUETYPE_TAG('y','i','x', 0 ), // yix = Axi Yi
  TRUETYPE_TAG('y','i','y', 0 ), // yiy = Yir Yoront
  TRUETYPE_TAG('y','i','z', 0 ), // yiz = Azhe
  TRUETYPE_TAG('y','k','a', 0 ), // yka = Yakan
  TRUETYPE_TAG('y','k','g', 0 ), // ykg = Northern Yukaghir
  TRUETYPE_TAG('y','k','i', 0 ), // yki = Yoke
  TRUETYPE_TAG('y','k','k', 0 ), // ykk = Yakaikeke
  TRUETYPE_TAG('y','k','l', 0 ), // ykl = Khlula
  TRUETYPE_TAG('y','k','m', 0 ), // ykm = Kap
  TRUETYPE_TAG('y','k','o', 0 ), // yko = Yasa
  TRUETYPE_TAG('y','k','r', 0 ), // ykr = Yekora
  TRUETYPE_TAG('y','k','t', 0 ), // ykt = Kathu
  TRUETYPE_TAG('y','k','y', 0 ), // yky = Yakoma
  TRUETYPE_TAG('y','l','a', 0 ), // yla = Yaul
  TRUETYPE_TAG('y','l','b', 0 ), // ylb = Yaleba
  TRUETYPE_TAG('y','l','e', 0 ), // yle = Yele
  TRUETYPE_TAG('y','l','g', 0 ), // ylg = Yelogu
  TRUETYPE_TAG('y','l','i', 0 ), // yli = Angguruk Yali
  TRUETYPE_TAG('y','l','l', 0 ), // yll = Yil
  TRUETYPE_TAG('y','l','m', 0 ), // ylm = Limi
  TRUETYPE_TAG('y','l','n', 0 ), // yln = Langnian Buyang
  TRUETYPE_TAG('y','l','o', 0 ), // ylo = Naluo Yi
  TRUETYPE_TAG('y','l','r', 0 ), // ylr = Yalarnnga
  TRUETYPE_TAG('y','l','u', 0 ), // ylu = Aribwaung
  TRUETYPE_TAG('y','l','y', 0 ), // yly = Nyâlayu
  TRUETYPE_TAG('y','m','a', 0 ), // yma = Yamphe
  TRUETYPE_TAG('y','m','b', 0 ), // ymb = Yambes
  TRUETYPE_TAG('y','m','c', 0 ), // ymc = Southern Muji
  TRUETYPE_TAG('y','m','d', 0 ), // ymd = Muda
  TRUETYPE_TAG('y','m','e', 0 ), // yme = Yameo
  TRUETYPE_TAG('y','m','g', 0 ), // ymg = Yamongeri
  TRUETYPE_TAG('y','m','h', 0 ), // ymh = Mili
  TRUETYPE_TAG('y','m','i', 0 ), // ymi = Moji
  TRUETYPE_TAG('y','m','k', 0 ), // ymk = Makwe
  TRUETYPE_TAG('y','m','l', 0 ), // yml = Iamalele
  TRUETYPE_TAG('y','m','m', 0 ), // ymm = Maay
  TRUETYPE_TAG('y','m','n', 0 ), // ymn = Yamna
  TRUETYPE_TAG('y','m','o', 0 ), // ymo = Yangum Mon
  TRUETYPE_TAG('y','m','p', 0 ), // ymp = Yamap
  TRUETYPE_TAG('y','m','q', 0 ), // ymq = Qila Muji
  TRUETYPE_TAG('y','m','r', 0 ), // ymr = Malasar
  TRUETYPE_TAG('y','m','s', 0 ), // yms = Mysian
  TRUETYPE_TAG('y','m','t', 0 ), // ymt = Mator-Taygi-Karagas
  TRUETYPE_TAG('y','m','x', 0 ), // ymx = Northern Muji
  TRUETYPE_TAG('y','m','z', 0 ), // ymz = Muzi
  TRUETYPE_TAG('y','n','a', 0 ), // yna = Aluo
  TRUETYPE_TAG('y','n','d', 0 ), // ynd = Yandruwandha
  TRUETYPE_TAG('y','n','e', 0 ), // yne = Lang'e
  TRUETYPE_TAG('y','n','g', 0 ), // yng = Yango
  TRUETYPE_TAG('y','n','h', 0 ), // ynh = Yangho
  TRUETYPE_TAG('y','n','k', 0 ), // ynk = Naukan Yupik
  TRUETYPE_TAG('y','n','l', 0 ), // ynl = Yangulam
  TRUETYPE_TAG('y','n','n', 0 ), // ynn = Yana
  TRUETYPE_TAG('y','n','o', 0 ), // yno = Yong
  TRUETYPE_TAG('y','n','s', 0 ), // yns = Yansi
  TRUETYPE_TAG('y','n','u', 0 ), // ynu = Yahuna
  TRUETYPE_TAG('y','o','b', 0 ), // yob = Yoba
  TRUETYPE_TAG('y','o','g', 0 ), // yog = Yogad
  TRUETYPE_TAG('y','o','i', 0 ), // yoi = Yonaguni
  TRUETYPE_TAG('y','o','k', 0 ), // yok = Yokuts
  TRUETYPE_TAG('y','o','l', 0 ), // yol = Yola
  TRUETYPE_TAG('y','o','m', 0 ), // yom = Yombe
  TRUETYPE_TAG('y','o','n', 0 ), // yon = Yongkom
  TRUETYPE_TAG('y','o','s', 0 ), // yos = Yos
  TRUETYPE_TAG('y','o','x', 0 ), // yox = Yoron
  TRUETYPE_TAG('y','o','y', 0 ), // yoy = Yoy
  TRUETYPE_TAG('y','p','a', 0 ), // ypa = Phala
  TRUETYPE_TAG('y','p','b', 0 ), // ypb = Labo Phowa
  TRUETYPE_TAG('y','p','g', 0 ), // ypg = Phola
  TRUETYPE_TAG('y','p','h', 0 ), // yph = Phupha
  TRUETYPE_TAG('y','p','k', 0 ), // ypk = Yupik languages
  TRUETYPE_TAG('y','p','m', 0 ), // ypm = Phuma
  TRUETYPE_TAG('y','p','n', 0 ), // ypn = Ani Phowa
  TRUETYPE_TAG('y','p','o', 0 ), // ypo = Alo Phola
  TRUETYPE_TAG('y','p','p', 0 ), // ypp = Phupa
  TRUETYPE_TAG('y','p','z', 0 ), // ypz = Phuza
  TRUETYPE_TAG('y','r','a', 0 ), // yra = Yerakai
  TRUETYPE_TAG('y','r','b', 0 ), // yrb = Yareba
  TRUETYPE_TAG('y','r','e', 0 ), // yre = Yaouré
  TRUETYPE_TAG('y','r','i', 0 ), // yri = Yarí
  TRUETYPE_TAG('y','r','k', 0 ), // yrk = Nenets
  TRUETYPE_TAG('y','r','l', 0 ), // yrl = Nhengatu
  TRUETYPE_TAG('y','r','n', 0 ), // yrn = Yerong
  TRUETYPE_TAG('y','r','s', 0 ), // yrs = Yarsun
  TRUETYPE_TAG('y','r','w', 0 ), // yrw = Yarawata
  TRUETYPE_TAG('y','s','c', 0 ), // ysc = Yassic
  TRUETYPE_TAG('y','s','d', 0 ), // ysd = Samatao
  TRUETYPE_TAG('y','s','l', 0 ), // ysl = Yugoslavian Sign Language
  TRUETYPE_TAG('y','s','n', 0 ), // ysn = Sani
  TRUETYPE_TAG('y','s','o', 0 ), // yso = Nisi (China)
  TRUETYPE_TAG('y','s','p', 0 ), // ysp = Southern Lolopo
  TRUETYPE_TAG('y','s','r', 0 ), // ysr = Sirenik Yupik
  TRUETYPE_TAG('y','s','s', 0 ), // yss = Yessan-Mayo
  TRUETYPE_TAG('y','s','y', 0 ), // ysy = Sanie
  TRUETYPE_TAG('y','t','a', 0 ), // yta = Talu
  TRUETYPE_TAG('y','t','l', 0 ), // ytl = Tanglang
  TRUETYPE_TAG('y','t','p', 0 ), // ytp = Thopho
  TRUETYPE_TAG('y','t','w', 0 ), // ytw = Yout Wam
  TRUETYPE_TAG('y','u','a', 0 ), // yua = Yucateco
  TRUETYPE_TAG('y','u','b', 0 ), // yub = Yugambal
  TRUETYPE_TAG('y','u','c', 0 ), // yuc = Yuchi
  TRUETYPE_TAG('y','u','d', 0 ), // yud = Judeo-Tripolitanian Arabic
  TRUETYPE_TAG('y','u','e', 0 ), // yue = Yue Chinese
  TRUETYPE_TAG('y','u','f', 0 ), // yuf = Havasupai-Walapai-Yavapai
  TRUETYPE_TAG('y','u','g', 0 ), // yug = Yug
  TRUETYPE_TAG('y','u','i', 0 ), // yui = Yurutí
  TRUETYPE_TAG('y','u','j', 0 ), // yuj = Karkar-Yuri
  TRUETYPE_TAG('y','u','k', 0 ), // yuk = Yuki
  TRUETYPE_TAG('y','u','l', 0 ), // yul = Yulu
  TRUETYPE_TAG('y','u','m', 0 ), // yum = Quechan
  TRUETYPE_TAG('y','u','n', 0 ), // yun = Bena (Nigeria)
  TRUETYPE_TAG('y','u','p', 0 ), // yup = Yukpa
  TRUETYPE_TAG('y','u','q', 0 ), // yuq = Yuqui
  TRUETYPE_TAG('y','u','r', 0 ), // yur = Yurok
  TRUETYPE_TAG('y','u','t', 0 ), // yut = Yopno
  TRUETYPE_TAG('y','u','u', 0 ), // yuu = Yugh
  TRUETYPE_TAG('y','u','w', 0 ), // yuw = Yau (Morobe Province)
  TRUETYPE_TAG('y','u','x', 0 ), // yux = Southern Yukaghir
  TRUETYPE_TAG('y','u','y', 0 ), // yuy = East Yugur
  TRUETYPE_TAG('y','u','z', 0 ), // yuz = Yuracare
  TRUETYPE_TAG('y','v','a', 0 ), // yva = Yawa
  TRUETYPE_TAG('y','v','t', 0 ), // yvt = Yavitero
  TRUETYPE_TAG('y','w','a', 0 ), // ywa = Kalou
  TRUETYPE_TAG('y','w','l', 0 ), // ywl = Western Lalu
  TRUETYPE_TAG('y','w','n', 0 ), // ywn = Yawanawa
  TRUETYPE_TAG('y','w','q', 0 ), // ywq = Wuding-Luquan Yi
  TRUETYPE_TAG('y','w','r', 0 ), // ywr = Yawuru
  TRUETYPE_TAG('y','w','t', 0 ), // ywt = Xishanba Lalo
  TRUETYPE_TAG('y','w','u', 0 ), // ywu = Wumeng Nasu
  TRUETYPE_TAG('y','w','w', 0 ), // yww = Yawarawarga
  TRUETYPE_TAG('y','y','u', 0 ), // yyu = Yau (Sandaun Province)
  TRUETYPE_TAG('y','y','z', 0 ), // yyz = Ayizi
  TRUETYPE_TAG('y','z','g', 0 ), // yzg = E'ma Buyang
  TRUETYPE_TAG('y','z','k', 0 ), // yzk = Zokhuo
  TRUETYPE_TAG('z','a','a', 0 ), // zaa = Sierra de Juárez Zapotec
  TRUETYPE_TAG('z','a','b', 0 ), // zab = San Juan Guelavía Zapotec
  TRUETYPE_TAG('z','a','c', 0 ), // zac = Ocotlán Zapotec
  TRUETYPE_TAG('z','a','d', 0 ), // zad = Cajonos Zapotec
  TRUETYPE_TAG('z','a','e', 0 ), // zae = Yareni Zapotec
  TRUETYPE_TAG('z','a','f', 0 ), // zaf = Ayoquesco Zapotec
  TRUETYPE_TAG('z','a','g', 0 ), // zag = Zaghawa
  TRUETYPE_TAG('z','a','h', 0 ), // zah = Zangwal
  TRUETYPE_TAG('z','a','i', 0 ), // zai = Isthmus Zapotec
  TRUETYPE_TAG('z','a','j', 0 ), // zaj = Zaramo
  TRUETYPE_TAG('z','a','k', 0 ), // zak = Zanaki
  TRUETYPE_TAG('z','a','l', 0 ), // zal = Zauzou
  TRUETYPE_TAG('z','a','m', 0 ), // zam = Miahuatlán Zapotec
  TRUETYPE_TAG('z','a','o', 0 ), // zao = Ozolotepec Zapotec
  TRUETYPE_TAG('z','a','p', 0 ), // zap = Zapotec
  TRUETYPE_TAG('z','a','q', 0 ), // zaq = Aloápam Zapotec
  TRUETYPE_TAG('z','a','r', 0 ), // zar = Rincón Zapotec
  TRUETYPE_TAG('z','a','s', 0 ), // zas = Santo Domingo Albarradas Zapotec
  TRUETYPE_TAG('z','a','t', 0 ), // zat = Tabaa Zapotec
  TRUETYPE_TAG('z','a','u', 0 ), // zau = Zangskari
  TRUETYPE_TAG('z','a','v', 0 ), // zav = Yatzachi Zapotec
  TRUETYPE_TAG('z','a','w', 0 ), // zaw = Mitla Zapotec
  TRUETYPE_TAG('z','a','x', 0 ), // zax = Xadani Zapotec
  TRUETYPE_TAG('z','a','y', 0 ), // zay = Zayse-Zergulla
  TRUETYPE_TAG('z','a','z', 0 ), // zaz = Zari
  TRUETYPE_TAG('z','b','c', 0 ), // zbc = Central Berawan
  TRUETYPE_TAG('z','b','e', 0 ), // zbe = East Berawan
  TRUETYPE_TAG('z','b','l', 0 ), // zbl = Blissymbols
  TRUETYPE_TAG('z','b','t', 0 ), // zbt = Batui
  TRUETYPE_TAG('z','b','w', 0 ), // zbw = West Berawan
  TRUETYPE_TAG('z','c','a', 0 ), // zca = Coatecas Altas Zapotec
  TRUETYPE_TAG('z','c','h', 0 ), // zch = Central Hongshuihe Zhuang
  TRUETYPE_TAG('z','d','j', 0 ), // zdj = Ngazidja Comorian
  TRUETYPE_TAG('z','e','a', 0 ), // zea = Zeeuws
  TRUETYPE_TAG('z','e','g', 0 ), // zeg = Zenag
  TRUETYPE_TAG('z','e','h', 0 ), // zeh = Eastern Hongshuihe Zhuang
  TRUETYPE_TAG('z','e','n', 0 ), // zen = Zenaga
  TRUETYPE_TAG('z','g','a', 0 ), // zga = Kinga
  TRUETYPE_TAG('z','g','b', 0 ), // zgb = Guibei Zhuang
  TRUETYPE_TAG('z','g','m', 0 ), // zgm = Minz Zhuang
  TRUETYPE_TAG('z','g','n', 0 ), // zgn = Guibian Zhuang
  TRUETYPE_TAG('z','g','r', 0 ), // zgr = Magori
  TRUETYPE_TAG('z','h','b', 0 ), // zhb = Zhaba
  TRUETYPE_TAG('z','h','d', 0 ), // zhd = Dai Zhuang
  TRUETYPE_TAG('z','h','i', 0 ), // zhi = Zhire
  TRUETYPE_TAG('z','h','n', 0 ), // zhn = Nong Zhuang
  TRUETYPE_TAG('z','h','w', 0 ), // zhw = Zhoa
  TRUETYPE_TAG('z','h','x', 0 ), // zhx = Chinese (family)
  TRUETYPE_TAG('z','i','a', 0 ), // zia = Zia
  TRUETYPE_TAG('z','i','b', 0 ), // zib = Zimbabwe Sign Language
  TRUETYPE_TAG('z','i','k', 0 ), // zik = Zimakani
  TRUETYPE_TAG('z','i','l', 0 ), // zil = Zialo
  TRUETYPE_TAG('z','i','m', 0 ), // zim = Mesme
  TRUETYPE_TAG('z','i','n', 0 ), // zin = Zinza
  TRUETYPE_TAG('z','i','r', 0 ), // zir = Ziriya
  TRUETYPE_TAG('z','i','w', 0 ), // ziw = Zigula
  TRUETYPE_TAG('z','i','z', 0 ), // ziz = Zizilivakan
  TRUETYPE_TAG('z','k','a', 0 ), // zka = Kaimbulawa
  TRUETYPE_TAG('z','k','b', 0 ), // zkb = Koibal
  TRUETYPE_TAG('z','k','g', 0 ), // zkg = Koguryo
  TRUETYPE_TAG('z','k','h', 0 ), // zkh = Khorezmian
  TRUETYPE_TAG('z','k','k', 0 ), // zkk = Karankawa
  TRUETYPE_TAG('z','k','o', 0 ), // zko = Kott
  TRUETYPE_TAG('z','k','p', 0 ), // zkp = São Paulo Kaingáng
  TRUETYPE_TAG('z','k','r', 0 ), // zkr = Zakhring
  TRUETYPE_TAG('z','k','t', 0 ), // zkt = Kitan
  TRUETYPE_TAG('z','k','u', 0 ), // zku = Kaurna
  TRUETYPE_TAG('z','k','v', 0 ), // zkv = Krevinian
  TRUETYPE_TAG('z','k','z', 0 ), // zkz = Khazar
  TRUETYPE_TAG('z','l','e', 0 ), // zle = East Slavic languages
  TRUETYPE_TAG('z','l','j', 0 ), // zlj = Liujiang Zhuang
  TRUETYPE_TAG('z','l','m', 0 ), // zlm = Malay (individual language)
  TRUETYPE_TAG('z','l','n', 0 ), // zln = Lianshan Zhuang
  TRUETYPE_TAG('z','l','q', 0 ), // zlq = Liuqian Zhuang
  TRUETYPE_TAG('z','l','s', 0 ), // zls = South Slavic languages
  TRUETYPE_TAG('z','l','w', 0 ), // zlw = West Slavic languages
  TRUETYPE_TAG('z','m','a', 0 ), // zma = Manda (Australia)
  TRUETYPE_TAG('z','m','b', 0 ), // zmb = Zimba
  TRUETYPE_TAG('z','m','c', 0 ), // zmc = Margany
  TRUETYPE_TAG('z','m','d', 0 ), // zmd = Maridan
  TRUETYPE_TAG('z','m','e', 0 ), // zme = Mangerr
  TRUETYPE_TAG('z','m','f', 0 ), // zmf = Mfinu
  TRUETYPE_TAG('z','m','g', 0 ), // zmg = Marti Ke
  TRUETYPE_TAG('z','m','h', 0 ), // zmh = Makolkol
  TRUETYPE_TAG('z','m','i', 0 ), // zmi = Negeri Sembilan Malay
  TRUETYPE_TAG('z','m','j', 0 ), // zmj = Maridjabin
  TRUETYPE_TAG('z','m','k', 0 ), // zmk = Mandandanyi
  TRUETYPE_TAG('z','m','l', 0 ), // zml = Madngele
  TRUETYPE_TAG('z','m','m', 0 ), // zmm = Marimanindji
  TRUETYPE_TAG('z','m','n', 0 ), // zmn = Mbangwe
  TRUETYPE_TAG('z','m','o', 0 ), // zmo = Molo
  TRUETYPE_TAG('z','m','p', 0 ), // zmp = Mpuono
  TRUETYPE_TAG('z','m','q', 0 ), // zmq = Mituku
  TRUETYPE_TAG('z','m','r', 0 ), // zmr = Maranunggu
  TRUETYPE_TAG('z','m','s', 0 ), // zms = Mbesa
  TRUETYPE_TAG('z','m','t', 0 ), // zmt = Maringarr
  TRUETYPE_TAG('z','m','u', 0 ), // zmu = Muruwari
  TRUETYPE_TAG('z','m','v', 0 ), // zmv = Mbariman-Gudhinma
  TRUETYPE_TAG('z','m','w', 0 ), // zmw = Mbo (Democratic Republic of Congo)
  TRUETYPE_TAG('z','m','x', 0 ), // zmx = Bomitaba
  TRUETYPE_TAG('z','m','y', 0 ), // zmy = Mariyedi
  TRUETYPE_TAG('z','m','z', 0 ), // zmz = Mbandja
  TRUETYPE_TAG('z','n','a', 0 ), // zna = Zan Gula
  TRUETYPE_TAG('z','n','d', 0 ), // znd = Zande languages
  TRUETYPE_TAG('z','n','e', 0 ), // zne = Zande (individual language)
  TRUETYPE_TAG('z','n','g', 0 ), // zng = Mang
  TRUETYPE_TAG('z','n','k', 0 ), // znk = Manangkari
  TRUETYPE_TAG('z','n','s', 0 ), // zns = Mangas
  TRUETYPE_TAG('z','o','c', 0 ), // zoc = Copainalá Zoque
  TRUETYPE_TAG('z','o','h', 0 ), // zoh = Chimalapa Zoque
  TRUETYPE_TAG('z','o','m', 0 ), // zom = Zou
  TRUETYPE_TAG('z','o','o', 0 ), // zoo = Asunción Mixtepec Zapotec
  TRUETYPE_TAG('z','o','q', 0 ), // zoq = Tabasco Zoque
  TRUETYPE_TAG('z','o','r', 0 ), // zor = Rayón Zoque
  TRUETYPE_TAG('z','o','s', 0 ), // zos = Francisco León Zoque
  TRUETYPE_TAG('z','p','a', 0 ), // zpa = Lachiguiri Zapotec
  TRUETYPE_TAG('z','p','b', 0 ), // zpb = Yautepec Zapotec
  TRUETYPE_TAG('z','p','c', 0 ), // zpc = Choapan Zapotec
  TRUETYPE_TAG('z','p','d', 0 ), // zpd = Southeastern Ixtlán Zapotec
  TRUETYPE_TAG('z','p','e', 0 ), // zpe = Petapa Zapotec
  TRUETYPE_TAG('z','p','f', 0 ), // zpf = San Pedro Quiatoni Zapotec
  TRUETYPE_TAG('z','p','g', 0 ), // zpg = Guevea De Humboldt Zapotec
  TRUETYPE_TAG('z','p','h', 0 ), // zph = Totomachapan Zapotec
  TRUETYPE_TAG('z','p','i', 0 ), // zpi = Santa María Quiegolani Zapotec
  TRUETYPE_TAG('z','p','j', 0 ), // zpj = Quiavicuzas Zapotec
  TRUETYPE_TAG('z','p','k', 0 ), // zpk = Tlacolulita Zapotec
  TRUETYPE_TAG('z','p','l', 0 ), // zpl = Lachixío Zapotec
  TRUETYPE_TAG('z','p','m', 0 ), // zpm = Mixtepec Zapotec
  TRUETYPE_TAG('z','p','n', 0 ), // zpn = Santa Inés Yatzechi Zapotec
  TRUETYPE_TAG('z','p','o', 0 ), // zpo = Amatlán Zapotec
  TRUETYPE_TAG('z','p','p', 0 ), // zpp = El Alto Zapotec
  TRUETYPE_TAG('z','p','q', 0 ), // zpq = Zoogocho Zapotec
  TRUETYPE_TAG('z','p','r', 0 ), // zpr = Santiago Xanica Zapotec
  TRUETYPE_TAG('z','p','s', 0 ), // zps = Coatlán Zapotec
  TRUETYPE_TAG('z','p','t', 0 ), // zpt = San Vicente Coatlán Zapotec
  TRUETYPE_TAG('z','p','u', 0 ), // zpu = Yalálag Zapotec
  TRUETYPE_TAG('z','p','v', 0 ), // zpv = Chichicapan Zapotec
  TRUETYPE_TAG('z','p','w', 0 ), // zpw = Zaniza Zapotec
  TRUETYPE_TAG('z','p','x', 0 ), // zpx = San Baltazar Loxicha Zapotec
  TRUETYPE_TAG('z','p','y', 0 ), // zpy = Mazaltepec Zapotec
  TRUETYPE_TAG('z','p','z', 0 ), // zpz = Texmelucan Zapotec
  TRUETYPE_TAG('z','q','e', 0 ), // zqe = Qiubei Zhuang
  TRUETYPE_TAG('z','r','a', 0 ), // zra = Kara (Korea)
  TRUETYPE_TAG('z','r','g', 0 ), // zrg = Mirgan
  TRUETYPE_TAG('z','r','n', 0 ), // zrn = Zerenkel
  TRUETYPE_TAG('z','r','o', 0 ), // zro = Záparo
  TRUETYPE_TAG('z','r','p', 0 ), // zrp = Zarphatic
  TRUETYPE_TAG('z','r','s', 0 ), // zrs = Mairasi
  TRUETYPE_TAG('z','s','a', 0 ), // zsa = Sarasira
  TRUETYPE_TAG('z','s','k', 0 ), // zsk = Kaskean
  TRUETYPE_TAG('z','s','l', 0 ), // zsl = Zambian Sign Language
  TRUETYPE_TAG('z','s','m', 0 ), // zsm = Standard Malay
  TRUETYPE_TAG('z','s','r', 0 ), // zsr = Southern Rincon Zapotec
  TRUETYPE_TAG('z','s','u', 0 ), // zsu = Sukurum
  TRUETYPE_TAG('z','t','e', 0 ), // zte = Elotepec Zapotec
  TRUETYPE_TAG('z','t','g', 0 ), // ztg = Xanaguía Zapotec
  TRUETYPE_TAG('z','t','l', 0 ), // ztl = Lapaguía-Guivini Zapotec
  TRUETYPE_TAG('z','t','m', 0 ), // ztm = San Agustín Mixtepec Zapotec
  TRUETYPE_TAG('z','t','n', 0 ), // ztn = Santa Catarina Albarradas Zapotec
  TRUETYPE_TAG('z','t','p', 0 ), // ztp = Loxicha Zapotec
  TRUETYPE_TAG('z','t','q', 0 ), // ztq = Quioquitani-Quierí Zapotec
  TRUETYPE_TAG('z','t','s', 0 ), // zts = Tilquiapan Zapotec
  TRUETYPE_TAG('z','t','t', 0 ), // ztt = Tejalapan Zapotec
  TRUETYPE_TAG('z','t','u', 0 ), // ztu = Güilá Zapotec
  TRUETYPE_TAG('z','t','x', 0 ), // ztx = Zaachila Zapotec
  TRUETYPE_TAG('z','t','y', 0 ), // zty = Yatee Zapotec
  TRUETYPE_TAG('z','u','a', 0 ), // zua = Zeem
  TRUETYPE_TAG('z','u','h', 0 ), // zuh = Tokano
  TRUETYPE_TAG('z','u','m', 0 ), // zum = Kumzari
  TRUETYPE_TAG('z','u','n', 0 ), // zun = Zuni
  TRUETYPE_TAG('z','u','y', 0 ), // zuy = Zumaya
  TRUETYPE_TAG('z','w','a', 0 ), // zwa = Zay
  TRUETYPE_TAG('z','x','x', 0 ), // zxx = No linguistic content
  TRUETYPE_TAG('z','y','b', 0 ), // zyb = Yongbei Zhuang
  TRUETYPE_TAG('z','y','g', 0 ), // zyg = Yang Zhuang
  TRUETYPE_TAG('z','y','j', 0 ), // zyj = Youjiang Zhuang
  TRUETYPE_TAG('z','y','n', 0 ), // zyn = Yongnan Zhuang
  TRUETYPE_TAG('z','y','p', 0 ), // zyp = Zyphe
  TRUETYPE_TAG('z','z','a', 0 ), // zza = Zaza
  TRUETYPE_TAG('z','z','j', 0 ), // zzj = Zuojiang Zhuang
  0x0 // end of language code list
};

/*
 * * * * * This file contains MACHINE-GENERATED DATA, do not edit! * * * * *
 */
