Match using Linux Socket Filter. Expects a BPF program in decimal format. This
is the format generated by the \fBnfbpf_compile\fP utility.
.TP
\fB\-\-bytecode\fP \fIcode\fP
Pass the BPF byte code format (described in the example below).
.PP
The code format is similar to the output of the tcpdump -ddd command: one line
that stores the number of instructions, followed by one line for each
instruction. Instruction lines follow the pattern 'u16 u8 u8 u32' in decimal
notation. Fields encode the operation, jump offset if true, jump offset if
false and generic multiuse field 'K'. Comments are not supported.
.PP
For example, to read only packets matching 'ip proto 6', insert the following,
without the comments or trailing whitespace:
.IP
4               # number of instructions
.br
48 0 0 9        # load byte  ip->proto
.br
21 0 1 6        # jump equal IPPROTO_TCP
.br
6 0 0 1         # return     pass (non-zero)
.br
6 0 0 0         # return     fail (zero)
.PP
You can pass this filter to the bpf match with the following command:
.IP
iptables \-A OUTPUT \-m bpf \-\-bytecode '4,48 0 0 9,21 0 1 6,6 0 0 1,6 0 0 0' \-j ACCEPT
.PP
Or instead, you can invoke the nfbpf_compile utility.
.IP
iptables \-A OUTPUT \-m bpf \-\-bytecode "`nfbpf_compile RAW 'ip proto 6'`" \-j ACCEPT
.PP
You may want to learn more about BPF from FreeBSD's bpf(4) manpage.
