/*****************************************************************************/
/*									     */
/*									     */
/*	CP/M emulator version 0.1					     */
/*									     */
/*	written by Michael Bischoff (mbi@mo.math.nat.tu-bs.de)		     */
/*	June-1994							     */
/*									     */
/*	This file is distributed under the GNU COPYRIGHT		     */
/*	see COPYRIGHT.GNU for Copyright details				     */
/*									     */
/*									     */
/*****************************************************************************/
#define _POSIX_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>

#define BIOS 0xfe00U
#define BDOS (BIOS-0xdfaU)

/* io.c functions */
int setup_io(const char *);
void putch(int);
int getch(void);
int kbhit(void);
void putmes(const char *);
void vt52(int c);

/* assembler modules */
void emulate(void);
void singlestep(void);

/* z80out.c */
/* char *disassemble(unsigned pc); */
const unsigned char *disz80(const unsigned char *PC, char *s, unsigned);
void disassem(unsigned *loc, int num);
void dispregs(unsigned pc);
void dispregs2(void);
void memdump(unsigned addr, int lines);


/* emulate() sees only this: */
struct z80regs {
    unsigned pc, sp, bc, de, hl, af, ir, clks;
    unsigned ix, iy, bc2, de2, hl2, af2, iff, dummy;
};
extern struct z80regs z80regs;
extern unsigned char z80mem[65536L+6];
typedef unsigned char uchar;
typedef unsigned short ushrt;

/* bios.c */

struct dpb {
    ushrt spt;
    uchar bsh;
    uchar blm;
    uchar exm;
    ushrt dsm;
    ushrt drm;
    uchar alloc0;
    uchar alloc1;
    ushrt cks;	/* (drm+1)/4 if media is removable */
    ushrt off;
};

void loadfile(const char *);
void cpm_init(const char *, const char *, struct dpb *);
int check_BIOS_hook(void);
void cpminit2(int argc, char *argv[]);

/* bdos.c */
void check_BDOS_hook(void);

/* running.c */
void z80step(int);
void z80run(void);
#define NBREAKS 9
extern struct breakpoint {
    unsigned where;
    unsigned byte;
    unsigned maxcnt;
    unsigned curcnt;
    int action;	/* inactive; break; print; ... */
} breakpoint[NBREAKS+1];
#define AC_NONE  0
#define AC_BREAK 1
#define AC_LIST  2
extern int debug;	/* enter debug mode? */
extern int prompt;	/* display debugging prompt? */
extern jmp_buf mainloop;
extern int break_at_BIOS;
extern int silent_exit;
extern int bdos_emulate;
extern int restricted_mode;
/* commands.c */
void commandloop(void);

int conin(void);
int getdig(int mindig);
char *rdcmdline(int, int);
unsigned gethex(void);
