# $Id: makefile.sol,v 4.4 1996/04/05 18:06:44 mikes Exp $
#
#   Michael Seibel
#   Networks and Distributed Computing
#   Computing and Communications
#   University of Washington
#   Administration Builiding, AG-44
#   Seattle, Washington, 98195, USA
#   Internet: mikes@cac.washington.edu
#
#   Please address all bugs and comments to "pine-bugs@cac.washington.edu"
#
#
#   Pine and Pico are registered trademarks of the University of Washington.
#   No commercial use of these trademarks may be made without prior written
#   permission of the University of Washington.
#
#   Pine, Pico, and Pilot software and its included text are Copyright
#   1989-1996 by the University of Washington.
#
#   The full text of our legal notices is contained in the file called
#   CPYRIGHT, included with this distribution.
#

#
# Makefile for SVR4 version of the PINE composer library and 
# stand-alone editor pico.
#
# [Port courtesy of Marc Unangst <mju@mudos.ann-arbor.mi.us> - mss, 921020]
#

#for GNU C
#CC= 		gcc
# LDCC= /usr/bin/cc
# If you don't have /usr/bin/cc (our Solaris 2.2 doesn't seem to have it,
# it only has /usr/ucb/cc) then change LDCC to the following line and
# give that a try.  This is still using the Solaris compiler but
# leaving out the UCB compatibility includes and libraries.
LDCC= cc5.sol

#STDCFLAGS=	-Dsv4 -DPOSIX -DJOB_CONTROL -ansi -DMOUSE
#otherwise
STDCFLAGS=		-Dsv4 -DPOSIX -DJOB_CONTROL -DMOUSE

#includes symbol info for debugging 
#DASHO=		-g
#for normal build
DASHO=		-O

CFLAGS=		$(EXTRACFLAGS) $(DASHO) $(STDCFLAGS)

# switches for library building
LIBCMD=		ar
LIBARGS=	ru
RANLIB=		true

LIB=		$(EXTRALIBES) -ltermlib

OFILES=		attach.o ansi.o basic.o bind.o browse.o buffer.o \
		composer.o display.o file.o fileio.o line.o osdep.o \
		pico.o random.o region.o search.o spell.o tinfo.o \
		window.o word.o

CFILES=		attach.c ansi.c basic.c bind.c browse.c buffer.c \
		composer.c display.c file.c fileio.c line.c osdep.c \
		pico.c random.c region.c search.c spell.c tinfo.c \
		window.c word.c

HFILES=		estruct.h edef.h efunc.h ebind.h pico.h


#
# dependencies for the Unix versions of pico and libpico.a
#
all:		pico pilot

osdep.c:	os_unix.c
		rm -f osdep.c
		cp os_unix.c osdep.c

osdep.h:	os_unix.h
		rm -f osdep.h
		cp os_unix.h osdep.h

libpico.a:	$& osdep.c osdep.h $(OFILES)
		$(LIBCMD) $(LIBARGS) libpico.a $(OFILES)
		$(RANLIB) libpico.a

pico:		main.c libpico.a
		$(LDCC) $(CFLAGS) main.c libpico.a $(LIB) -o pico

pilot:		pilot.c libpico.a
		$(LDCC) $(CFLAGS) pilot.c libpico.a $(LIB) -o pilot

.c.o:		; $(CC) -c $(CFLAGS) $*.c

$(OFILES):	$(HFILES)

clean:
		rm -f *.a *.o *~ osdep.c osdep.h pico pilot
