/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.ProtocolConstants;
import gnu.java.rmi.server.RMIObjectInputStream;
import gnu.java.rmi.server.TripleKey;
import gnu.java.rmi.server.UnicastConnection;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.util.Hashtable;

public class UnicastConnectionManager
implements Runnable,
ProtocolConstants {
    private static String localhost;
    private static Hashtable servers;
    private Thread serverThread;
    private ServerSocket ssock;
    String serverName;
    int serverPort;
    private RMIServerSocketFactory serverFactory;
    private RMIClientSocketFactory clientFactory;

    private UnicastConnectionManager(String host, int port, RMIClientSocketFactory csf) {
        this.ssock = null;
        this.serverName = host;
        this.serverPort = port;
        this.serverFactory = null;
        this.clientFactory = csf;
    }

    private UnicastConnectionManager(int port, RMIServerSocketFactory ssf) {
        try {
            this.ssock = ssf.createServerSocket(port);
            this.serverPort = this.ssock.getLocalPort();
        }
        catch (IOException _) {
            try {
                this.ssock = ssf.createServerSocket(0);
                this.serverPort = this.ssock.getLocalPort();
            }
            catch (IOException __) {
                this.ssock = null;
                this.serverPort = 0;
            }
        }
        this.serverName = localhost;
        this.serverFactory = ssf;
        this.clientFactory = null;
    }

    public static synchronized UnicastConnectionManager getInstance(String host, int port, RMIClientSocketFactory csf) {
        TripleKey key;
        UnicastConnectionManager man;
        if (csf == null) {
            csf = RMISocketFactory.getSocketFactory();
        }
        if ((man = (UnicastConnectionManager)servers.get(key = new TripleKey(host, port, csf))) == null) {
            man = new UnicastConnectionManager(host, port, csf);
            servers.put(key, man);
        }
        return man;
    }

    public static synchronized UnicastConnectionManager getInstance(int port, RMIServerSocketFactory ssf) {
        TripleKey key;
        UnicastConnectionManager man;
        if (ssf == null) {
            ssf = RMISocketFactory.getSocketFactory();
        }
        if ((man = (UnicastConnectionManager)servers.get(key = new TripleKey(localhost, port, ssf))) == null) {
            man = new UnicastConnectionManager(port, ssf);
            key.port = man.serverPort;
            servers.put(key, man);
        }
        return man;
    }

    public UnicastConnection getConnection() throws IOException {
        if (this.ssock == null) {
            return this.getClientConnection();
        }
        return this.getServerConnection();
    }

    private UnicastConnection getServerConnection() throws IOException {
        Socket sock = this.ssock.accept();
        UnicastConnection conn = new UnicastConnection(this, sock);
        conn.acceptConnection();
        return conn;
    }

    private UnicastConnection getClientConnection() throws IOException {
        Socket sock = this.clientFactory.createSocket(this.serverName, this.serverPort);
        UnicastConnection conn = new UnicastConnection(this, sock);
        conn.makeConnection(75);
        return conn;
    }

    public void discardConnection(UnicastConnection conn) {
        conn.disconnect();
    }

    public void startServer() {
        UnicastConnectionManager unicastConnectionManager = this;
        synchronized (unicastConnectionManager) {
            try {
                block6: {
                    block5: {
                        if (this.ssock == null) break block5;
                        if (this.serverThread == null) break block6;
                    }
                    Object var2_2 = null;
                    return;
                }
                this.serverThread = new Thread(this);
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                throw throwable;
            }
            Object var2_3 = null;
        }
        this.serverThread.start();
    }

    public void run() {
        while (true) {
            try {
                UnicastConnection conn = this.getServerConnection();
                new Thread(conn).start();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    void write(ObjectOutput out) throws IOException {
        out.writeUTF(this.serverName);
        out.writeInt(this.serverPort);
    }

    static UnicastConnectionManager read(ObjectInput in) throws IOException {
        String host = in.readUTF();
        int port = in.readInt();
        RMIClientSocketFactory csf = ((RMIObjectInputStream)in).manager.clientFactory;
        return UnicastConnectionManager.getInstance(host, port, csf);
    }

    static {
        servers = new Hashtable();
        try {
            localhost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException _) {
            localhost = "localhost";
        }
    }
}

