/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;

public class SecureClassLoader
extends ClassLoader {
    protected SecureClassLoader(ClassLoader parent) {
        super(parent);
    }

    protected SecureClassLoader() {
    }

    protected final Class defineClass(String name, byte[] b, int off, int len, CodeSource cs) {
        ProtectionDomain protectionDomain = new ProtectionDomain(cs, this.getPermissions(cs));
        try {
            return super.defineClass(name, b, off, len, protectionDomain);
        }
        catch (ClassFormatError cfe) {
            return null;
        }
    }

    protected PermissionCollection getPermissions(CodeSource cs) {
        Policy policy = Policy.getPolicy();
        return policy.getPermissions(cs);
    }
}

