/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;

public abstract class ResourceBundle {
    protected ResourceBundle parent;
    private Locale locale;
    static Security security = (Security)AccessController.doPrivileged(new PrivilegedAction(null){
        private /* synthetic */ ResourceBundle this$0;
        {
            this.this$0 = this$0;
        }

        public Object run() {
            return new Security();
        }
    });
    private static Map resourceBundleCache = new HashMap();
    private static final Locale emptyLocale = new Locale("", "");

    public final String getString(String key) throws MissingResourceException {
        return (String)this.getObject(key);
    }

    public final String[] getStringArray(String key) throws MissingResourceException {
        return (String[])this.getObject(key);
    }

    public final Object getObject(String key) throws MissingResourceException {
        ResourceBundle bundle = this;
        while (bundle != null) {
            try {
                Object o = bundle.handleGetObject(key);
                if (o != null) {
                    return o;
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            bundle = bundle.parent;
        }
        throw new MissingResourceException("Key not found", this.getClass().getName(), key);
    }

    public static final ResourceBundle getBundle(String baseName) throws MissingResourceException {
        return ResourceBundle.getBundle(baseName, Locale.getDefault(), security.getCallingClassLoader());
    }

    public static final ResourceBundle getBundle(String baseName, Locale locale) throws MissingResourceException {
        return ResourceBundle.getBundle(baseName, locale, security.getCallingClassLoader());
    }

    private static final ResourceBundle tryBundle(String localizedName, Locale locale, ClassLoader classloader, ResourceBundle bundle, HashMap cache) {
        ResourceBundle rb;
        Reference ref = (Reference)cache.get(localizedName);
        if (ref != null && (rb = (ResourceBundle)ref.get()) != null) {
            return rb;
        }
        ResourceBundle foundBundle = null;
        try {
            String resourceName = localizedName.replace('.', '/') + ".properties";
            InputStream is = classloader == null ? ClassLoader.getSystemResourceAsStream(resourceName) : classloader.getResourceAsStream(resourceName);
            if (is != null) {
                foundBundle = new PropertyResourceBundle(is);
                foundBundle.parent = bundle;
                foundBundle.locale = locale;
            }
        }
        catch (IOException rbClass) {
            // empty catch block
        }
        try {
            Class rbClass = classloader == null ? Class.forName(localizedName) : classloader.loadClass(localizedName);
            foundBundle = (ResourceBundle)rbClass.newInstance();
            foundBundle.parent = bundle;
            foundBundle.locale = locale;
        }
        catch (ClassNotFoundException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (InstantiationException ex) {
            // empty catch block
        }
        if (foundBundle != null) {
            cache.put(localizedName, new SoftReference(foundBundle));
        }
        if (foundBundle != null) {
            return foundBundle;
        }
        return bundle;
    }

    private static final ResourceBundle tryLocalBundle(String baseName, Locale locale, ClassLoader classloader, ResourceBundle bundle, HashMap cache) {
        String language = locale.getLanguage();
        if (language.length() > 0) {
            String country = locale.getCountry();
            String name = baseName + "_" + language;
            if (country.length() != 0) {
                bundle = ResourceBundle.tryBundle(name, new Locale(language, ""), classloader, bundle, cache);
                name = name + new StringBuffer("_").append(country);
                String variant = locale.getVariant();
                if (variant.length() != 0) {
                    bundle = ResourceBundle.tryBundle(name, new Locale(language, country), classloader, bundle, cache);
                    name = name + new StringBuffer("_").append(variant);
                }
            }
            bundle = ResourceBundle.tryBundle(name, locale, classloader, bundle, cache);
        }
        return bundle;
    }

    public static final synchronized ResourceBundle getBundle(String baseName, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        HashMap cache = (HashMap)resourceBundleCache.get(classLoader);
        if (cache == null) {
            cache = new HashMap();
            resourceBundleCache.put(classLoader, cache);
        } else {
            ResourceBundle rb;
            String name = baseName + "_" + locale.toString();
            Reference ref = (Reference)cache.get(name);
            if (ref != null && (rb = (ResourceBundle)ref.get()) != null) {
                return rb;
            }
        }
        ResourceBundle baseBundle = ResourceBundle.tryBundle(baseName, emptyLocale, classLoader, null, cache);
        if (baseBundle == null) {
            throw new MissingResourceException("Bundle " + baseName + " not found", baseName, "");
        }
        ResourceBundle bundle = ResourceBundle.tryLocalBundle(baseName, locale, classLoader, baseBundle, cache);
        if (bundle == baseBundle && !locale.equals(Locale.getDefault())) {
            bundle = ResourceBundle.tryLocalBundle(baseName, Locale.getDefault(), classLoader, baseBundle, cache);
        }
        return bundle;
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected void setParent(ResourceBundle parent) {
        this.parent = parent;
    }

    protected abstract Object handleGetObject(String var1) throws MissingResourceException;

    public abstract Enumeration getKeys();

    static class Security
    extends SecurityManager {
        static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
            try {
                return Class.forName(type$);
            }
            catch (ClassNotFoundException write_parm_value$) {
                throw new NoClassDefFoundError(write_parm_value$.getMessage());
            }
        }

        ClassLoader getCallingClassLoader() {
            Class[] stack = super.getClassContext();
            for (int i = 0; i < stack.length; ++i) {
                if (stack[i] == Security.class$("java.util.ResourceBundle$Security") || stack[i] == Security.class$("java.util.ResourceBundle")) continue;
                return stack[i].getClassLoader();
            }
            return null;
        }

        Security() {
        }
    }
}

