/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InvalidNameException;
import javax.naming.Name;

public class CompoundName
implements Name,
Cloneable,
Serializable {
    protected transient Properties mySyntax;
    private transient Vector elts = new Vector();
    private transient int direction;
    private transient String separator;
    private transient boolean ignoreCase;
    private transient String escape;
    private transient String beginQuote;
    private transient String endQuote;
    private transient String beginQuote2;
    private transient String endQuote2;
    private transient boolean trimBlanks;
    private static final int RIGHT_TO_LEFT = -1;
    private static final int LEFT_TO_RIGHT = 1;
    private static final int FLAT = 0;

    private CompoundName(Properties syntax) {
        this.mySyntax = syntax;
        this.initializeSyntax();
    }

    protected CompoundName(Enumeration comps, Properties syntax) {
        this.mySyntax = syntax;
        this.initializeSyntax();
        try {
            while (comps.hasMoreElements()) {
                this.elts.add(comps.nextElement());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public CompoundName(String n, Properties syntax) throws InvalidNameException {
        this.mySyntax = syntax;
        this.initializeSyntax();
        StringBuffer new_element = new StringBuffer();
        int i = 0;
        String quote = null;
        while (i < n.length()) {
            block16: {
                String special = this.isSpecial(n, i);
                if (special == this.escape && this.escape != null) {
                    if (n.length() == i + special.length()) {
                        new_element.append(special);
                        i += special.length();
                        break block16;
                    } else {
                        String eSpecial = this.isSpecial(n, i + special.length());
                        if (eSpecial != null) {
                            new_element.append(eSpecial);
                            i += special.length() + eSpecial.length();
                            continue;
                        }
                        new_element.append(special);
                        i += special.length();
                        continue;
                    }
                }
                if (quote != null) {
                    if (quote == special) {
                        if (i + quote.length() < n.length() && !n.startsWith(this.separator, i + quote.length())) {
                            throw new InvalidNameException("close quote before end of component");
                        }
                        this.elts.add(new_element.toString());
                        new_element.setLength(0);
                        i += quote.length();
                        quote = null;
                        continue;
                    }
                } else {
                    if (new_element.length() == 0 && special == this.beginQuote) {
                        quote = this.endQuote;
                        i += special.length();
                        continue;
                    }
                    if (new_element.length() == 0 && special == this.beginQuote2) {
                        quote = this.endQuote2;
                        i += special.length();
                        continue;
                    }
                    if (special == this.separator) {
                        this.elts.add(new_element.toString());
                        new_element.setLength(0);
                        i += special.length();
                        continue;
                    }
                }
            }
            new_element.append(n.charAt(i));
            ++i;
        }
        if (new_element.length() != 0) {
            this.elts.add(new_element.toString());
        }
        if (this.direction == -1) {
            int len = this.elts.size();
            for (i = 0; i < len / 2; ++i) {
                Object t = this.elts.set(i, this.elts.get(len - i - 1));
                this.elts.set(len - i - 1, t);
            }
        }
        if (quote != null) {
            throw new InvalidNameException("unterminated quote");
        }
    }

    public Name add(int posn, String comp) throws InvalidNameException {
        this.elts.add(posn, comp);
        return this;
    }

    public Name add(String comp) throws InvalidNameException {
        this.elts.add(comp);
        return this;
    }

    public Name addAll(int posn, Name n) throws InvalidNameException {
        Enumeration e = n.getAll();
        try {
            while (e.hasMoreElements()) {
                this.elts.add(posn, e.nextElement());
                ++posn;
            }
        }
        catch (NoSuchElementException ignore) {
            // empty catch block
        }
        return this;
    }

    public Name addAll(Name suffix) throws InvalidNameException {
        Enumeration e = suffix.getAll();
        try {
            while (e.hasMoreElements()) {
                this.elts.add(e.nextElement());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    public Object clone() {
        return new CompoundName(this.elts.elements(), this.mySyntax);
    }

    public int compareTo(Object obj) {
        if (obj == null || !(obj instanceof CompoundName)) {
            throw new ClassCastException("CompoundName.compareTo() expected CompoundName");
        }
        CompoundName cn = (CompoundName)obj;
        int last = Math.min(cn.elts.size(), this.elts.size());
        for (int i = 0; i < last; ++i) {
            String f = this.canonicalize((String)this.elts.get(i));
            int comp = f.compareTo(this.canonicalize((String)cn.elts.get(i)));
            if (comp == 0) continue;
            return comp;
        }
        return this.elts.size() - cn.elts.size();
    }

    public boolean endsWith(Name n) {
        if (!(n instanceof CompoundName)) {
            return false;
        }
        CompoundName cn = (CompoundName)n;
        if (cn.elts.size() > this.elts.size()) {
            return false;
        }
        int delta = this.elts.size() - cn.elts.size();
        for (int i = 0; i < cn.elts.size(); ++i) {
            String f = this.canonicalize((String)this.elts.get(i));
            if (f.equals(this.canonicalize((String)cn.elts.get(i)))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CompoundName)) {
            return false;
        }
        return this.compareTo(obj) == 0;
    }

    public String get(int posn) {
        return (String)this.elts.get(posn);
    }

    public Enumeration getAll() {
        return this.elts.elements();
    }

    public Name getPrefix(int posn) {
        CompoundName cn = new CompoundName(this.mySyntax);
        for (int i = 0; i < posn; ++i) {
            cn.elts.add(this.elts.get(i));
        }
        return cn;
    }

    public Name getSuffix(int posn) {
        if (posn > this.elts.size()) {
            throw new ArrayIndexOutOfBoundsException(posn);
        }
        CompoundName cn = new CompoundName(this.mySyntax);
        for (int i = posn; i < this.elts.size(); ++i) {
            cn.elts.add(this.elts.get(i));
        }
        return cn;
    }

    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.elts.size(); ++i) {
            h += this.canonicalize((String)this.elts.get(i)).hashCode();
        }
        return h;
    }

    public boolean isEmpty() {
        return this.elts.isEmpty();
    }

    public Object remove(int posn) throws InvalidNameException {
        return this.elts.remove(posn);
    }

    public int size() {
        return this.elts.size();
    }

    public boolean startsWith(Name n) {
        if (!(n instanceof CompoundName)) {
            return false;
        }
        CompoundName cn = (CompoundName)n;
        if (cn.elts.size() > this.elts.size()) {
            return false;
        }
        for (int i = 0; i < cn.elts.size(); ++i) {
            String f = this.canonicalize((String)this.elts.get(i));
            if (f.equals(this.canonicalize((String)cn.elts.get(i)))) continue;
            return false;
        }
        return true;
    }

    private String isSpecial(String element, int offset) {
        String special = null;
        if (this.separator != null && element.startsWith(this.separator, offset)) {
            special = this.separator;
        } else if (this.escape != null && element.startsWith(this.escape, offset)) {
            special = this.escape;
        } else if (this.beginQuote != null && element.startsWith(this.beginQuote, offset)) {
            special = this.beginQuote;
        } else if (this.endQuote != null && element.startsWith(this.endQuote, offset)) {
            special = this.endQuote;
        } else if (this.beginQuote2 != null && element.startsWith(this.beginQuote2, offset)) {
            special = this.beginQuote2;
        } else if (this.endQuote2 != null && element.startsWith(this.endQuote2, offset)) {
            special = this.endQuote2;
        }
        return special;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        int size = this.elts.size();
        for (int i = 0; i < size; ++i) {
            int offset = this.direction == -1 ? size - i - 1 : i;
            String element = (String)this.elts.get(offset);
            if (i > 0 || i == size - 1 && element.equals("")) {
                result.append(this.separator);
            }
            int k = 0;
            while (k < element.length()) {
                String special = this.isSpecial(element, k);
                if (special != null) {
                    result.append(this.escape);
                    result.append(special);
                    k += special.length();
                    continue;
                }
                result.append(element.charAt(k));
                ++k;
            }
        }
        return result.toString();
    }

    private String canonicalize(String element) {
        String ret = element;
        if (this.ignoreCase) {
            ret = ret.toLowerCase();
        }
        if (this.trimBlanks) {
            int last;
            int first;
            for (first = 0; first < ret.length() && Character.isWhitespace(ret.charAt(first)); ++first) {
            }
            for (last = ret.length() - 1; last >= first && Character.isWhitespace(ret.charAt(last)); --last) {
            }
            ret = ret.substring(first, last);
        }
        return ret;
    }

    private void initializeSyntax() {
        String t = this.mySyntax.getProperty("jndi.syntax.direction", "flat");
        this.direction = t.equals("right_to_left") ? -1 : (t.equals("left_to_right") ? 1 : 0);
        this.separator = this.mySyntax.getProperty("jndi.syntax.separator", "");
        this.ignoreCase = Boolean.valueOf(this.mySyntax.getProperty("jndi.syntax.ignorecase", "false"));
        this.escape = this.mySyntax.getProperty("jndi.syntax.escape", null);
        this.beginQuote = this.mySyntax.getProperty("jndi.syntax.beginquote", null);
        this.endQuote = this.mySyntax.getProperty("jndi.syntax.endquote", this.beginQuote);
        this.beginQuote2 = this.mySyntax.getProperty("jndi.syntax.beginquote2", null);
        this.endQuote2 = this.mySyntax.getProperty("jndi.syntax.endquote2", this.beginQuote2);
        this.trimBlanks = Boolean.valueOf(this.mySyntax.getProperty("jndi.syntax.trimblanks", "false"));
    }
}

