/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import COM.rsa.jsafe.SunJSSE_a7;
import COM.rsa.jsafe.SunJSSE_a8;
import COM.rsa.jsafe.SunJSSE_aa;
import COM.rsa.jsafe.SunJSSE_ae;
import COM.rsa.jsafe.SunJSSE_al;
import COM.rsa.jsafe.SunJSSE_dc;
import com.sun.net.ssl.internal.ssl.JS_PrivateKey;
import com.sun.net.ssl.internal.ssl.JS_PublicKey;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;

public abstract class JS_Signature
extends SignatureSpi
implements Cloneable,
Serializable {
    protected SunJSSE_al jsafeSignature;
    protected SunJSSE_dc jsafeParams;
    protected int[] signatureParams;
    private String a;
    private boolean b;

    public JS_Signature(String string, String string2, String string3) throws NoSuchAlgorithmException {
        try {
            this.jsafeSignature = SunJSSE_al.a(string, "Java");
        }
        catch (SunJSSE_ae sunJSSE_ae) {
            throw new NoSuchAlgorithmException("JSAFE provider does not perform " + string);
        }
        this.a = string3;
    }

    protected abstract SunJSSE_dc getSystemParameters(AlgorithmParameterSpec var1) throws InvalidAlgorithmParameterException;

    protected abstract int[] getSignatureParameters(AlgorithmParameterSpec var1) throws InvalidAlgorithmParameterException;

    protected boolean needSignRandom() {
        return false;
    }

    protected boolean needVerifyRandom() {
        return false;
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        SunJSSE_dc sunJSSE_dc = this.getSystemParameters(algorithmParameterSpec);
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        if (secureRandom != null) {
            this.appRandom = secureRandom;
        }
        this.engineInitSign(privateKey);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.b = true;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(this.a, "SunJSSE");
            JS_PrivateKey jS_PrivateKey = (JS_PrivateKey)keyFactory.translateKey(privateKey);
            SunJSSE_a7 sunJSSE_a7 = jS_PrivateKey.a();
            SecureRandom secureRandom = null;
            if (this.needSignRandom()) {
                if (this.appRandom != null) {
                    secureRandom = this.appRandom;
                } else {
                    try {
                        SecureRandom secureRandom2;
                        secureRandom = secureRandom2 = SunJSSE_a8.getInstance("SHA1Random", "Java");
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new InvalidKeyException(noSuchAlgorithmException.getMessage());
                    }
                }
            }
            this.jsafeSignature.a(sunJSSE_a7, this.jsafeParams, secureRandom);
            sunJSSE_a7.a();
            jS_PrivateKey.b();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeyException("Could not initialize for signing with the given key.");
        }
        catch (SunJSSE_ae sunJSSE_ae) {
            throw new InvalidKeyException(sunJSSE_ae.getMessage());
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.b = false;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(this.a, "SunJSSE");
            JS_PublicKey jS_PublicKey = (JS_PublicKey)keyFactory.translateKey(publicKey);
            SunJSSE_aa sunJSSE_aa = jS_PublicKey.a();
            SecureRandom secureRandom = null;
            if (this.needVerifyRandom()) {
                if (this.appRandom != null) {
                    secureRandom = this.appRandom;
                } else {
                    try {
                        SecureRandom secureRandom2 = SunJSSE_a8.getInstance("SHA1Random", "Java");
                        secureRandom = this.appRandom;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new InvalidKeyException(noSuchAlgorithmException.getMessage());
                    }
                }
            }
            this.jsafeSignature.a(sunJSSE_aa, this.jsafeParams, secureRandom);
            sunJSSE_aa.a();
            jS_PublicKey.b();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeyException("Could not initialize for verifying with the given key.");
        }
        catch (SunJSSE_ae sunJSSE_ae) {
            throw new InvalidKeyException(sunJSSE_ae.getMessage());
        }
    }

    protected void engineUpdate(byte by) throws SignatureException {
        try {
            byte[] byArray = new byte[]{by};
            if (this.b) {
                this.jsafeSignature.a(byArray, 0, 1);
            } else {
                this.jsafeSignature.c(byArray, 0, 1);
            }
        }
        catch (SunJSSE_ae sunJSSE_ae) {
            throw new SignatureException(sunJSSE_ae.getMessage());
        }
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        try {
            if (this.b) {
                this.jsafeSignature.a(byArray, n, n2);
            } else {
                this.jsafeSignature.c(byArray, n, n2);
            }
        }
        catch (SunJSSE_ae sunJSSE_ae) {
            throw new SignatureException(sunJSSE_ae.getMessage());
        }
    }

    protected byte[] engineSign() throws SignatureException {
        if (!this.b) {
            throw new SignatureException("Object initialized for verify.");
        }
        try {
            byte[] byArray = this.jsafeSignature.j();
            this.jsafeSignature.k();
            return byArray;
        }
        catch (SunJSSE_ae sunJSSE_ae) {
            throw new SignatureException(sunJSSE_ae.getMessage());
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (this.b) {
            throw new SignatureException("Object initialized for signing.");
        }
        try {
            boolean bl = this.jsafeSignature.b(byArray, 0, byArray.length);
            this.jsafeSignature.l();
            return bl;
        }
        catch (SunJSSE_ae sunJSSE_ae) {
            throw new SignatureException(sunJSSE_ae.getMessage());
        }
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("JSAFE provider does not support deprecated methods.");
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("JSAFE provider does not support deprecated methods.");
    }

    protected String getSubclassName() {
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            Class<?> clazz = Class.forName(this.getSubclassName());
            JS_Signature jS_Signature = (JS_Signature)clazz.newInstance();
            return jS_Signature;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CloneNotSupportedException();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CloneNotSupportedException();
        }
        catch (InstantiationException instantiationException) {
            throw new CloneNotSupportedException();
        }
    }

    void a() {
        if (this.jsafeSignature != null) {
            this.jsafeSignature.a();
        }
        this.jsafeSignature = null;
    }

    protected void finalize() {
        this.a();
    }
}

