/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.jpeg;

import com.sun.imageio.plugins.jpeg.AdobeMarkerSegment;
import com.sun.imageio.plugins.jpeg.DHTMarkerSegment;
import com.sun.imageio.plugins.jpeg.DQTMarkerSegment;
import com.sun.imageio.plugins.jpeg.DRIMarkerSegment;
import com.sun.imageio.plugins.jpeg.JFIFMarkerSegment;
import com.sun.imageio.plugins.jpeg.JPEG;
import com.sun.imageio.plugins.jpeg.JPEGMetadata;
import com.sun.imageio.plugins.jpeg.MarkerSegment;
import com.sun.imageio.plugins.jpeg.SOFMarkerSegment;
import com.sun.imageio.plugins.jpeg.SOSMarkerSegment;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.plugins.jpeg.JPEGQTable;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.Node;
import sun.security.action.LoadLibraryAction;

public class JPEGImageWriter
extends ImageWriter {
    private boolean debug = false;
    private long structPointer = this.initJPEGImageWriter();
    private ImageOutputStream ios = null;
    private Raster srcRas = null;
    private WritableRaster raster = null;
    private boolean indexed = false;
    private IndexColorModel indexCM = null;
    private boolean convertTosRGB = false;
    private WritableRaster converted = null;
    private List thumbnails = null;
    private ICC_Profile iccProfile = null;
    private int sourceXOffset = 0;
    private int sourceYOffset = 0;
    private int sourceWidth = 0;
    private int[] srcBands = null;
    private int sourceHeight = 0;
    private int currentImage = 0;
    private ColorConvertOp convertOp = null;
    private JPEGQTable[] streamQTables = null;
    private JPEGHuffmanTable[] streamDCHuffmanTables = null;
    private JPEGHuffmanTable[] streamACHuffmanTables = null;
    private boolean ignoreJFIF = false;
    private boolean forceJFIF = false;
    private boolean ignoreAdobe = false;
    private int newAdobeTransform = -1;
    private boolean writeDefaultJFIF = false;
    private boolean writeAdobe = false;
    private JPEGMetadata metadata = null;
    private boolean sequencePrepared = false;
    private int numScans = 0;
    protected static final int WARNING_DEST_IGNORED = 0;
    protected static final int WARNING_STREAM_METADATA_IGNORED = 1;
    protected static final int WARNING_DEST_METADATA_COMP_MISMATCH = 2;
    protected static final int WARNING_DEST_METADATA_JFIF_MISMATCH = 3;
    protected static final int WARNING_DEST_METADATA_ADOBE_MISMATCH = 4;
    protected static final int WARNING_IMAGE_METADATA_JFIF_MISMATCH = 5;
    protected static final int WARNING_IMAGE_METADATA_ADOBE_MISMATCH = 6;
    protected static final int WARNING_METADATA_NOT_JPEG_FOR_RASTER = 7;
    protected static final int WARNING_NO_BANDS_ON_INDEXED = 8;
    protected static final int WARNING_ILLEGAL_THUMBNAIL = 9;
    protected static final int WARNING_IGNORING_THUMBS = 10;
    protected static final int WARNING_FORCING_JFIF = 11;
    protected static final int WARNING_THUMB_CLIPPED = 12;
    protected static final int WARNING_METADATA_ADJUSTED_FOR_THUMB = 13;
    protected static final int WARNING_NO_RGB_THUMB_AS_INDEXED = 14;
    protected static final int WARNING_NO_GRAY_THUMB_AS_INDEXED = 15;
    private static final int MAX_WARNING = 15;
    static final Dimension[] preferredThumbSizes;
    static /* synthetic */ Class class$javax$imageio$stream$ImageOutputStream;
    static /* synthetic */ Class class$javax$imageio$plugins$jpeg$JPEGQTable;
    static /* synthetic */ Class class$javax$imageio$plugins$jpeg$JPEGHuffmanTable;
    static /* synthetic */ Class class$com$sun$imageio$plugins$jpeg$JFIFMarkerSegment;
    static /* synthetic */ Class class$com$sun$imageio$plugins$jpeg$AdobeMarkerSegment;
    static /* synthetic */ Class class$com$sun$imageio$plugins$jpeg$SOFMarkerSegment;
    static /* synthetic */ Class class$com$sun$imageio$plugins$jpeg$DQTMarkerSegment;
    static /* synthetic */ Class class$com$sun$imageio$plugins$jpeg$DHTMarkerSegment;
    static /* synthetic */ Class class$com$sun$imageio$plugins$jpeg$DRIMarkerSegment;

    public JPEGImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public void setOutput(Object object) {
        super.setOutput(object);
        this.ios = (ImageOutputStream)object;
        this.setDest(this.structPointer, this.ios);
        this.srcRas = null;
        this.raster = null;
        this.currentImage = 0;
        System.gc();
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new JPEGImageWriteParam(null);
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return new JPEGMetadata(imageWriteParam, this);
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return new JPEGMetadata(imageTypeSpecifier, imageWriteParam, this);
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        if (iIOMetadata instanceof JPEGMetadata) {
            JPEGMetadata jPEGMetadata = (JPEGMetadata)iIOMetadata;
            if (jPEGMetadata.isStream) {
                return iIOMetadata;
            }
        }
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        String string;
        Node node;
        if (iIOMetadata instanceof JPEGMetadata) {
            JPEGMetadata jPEGMetadata = (JPEGMetadata)iIOMetadata;
            if (!jPEGMetadata.isStream) {
                return iIOMetadata;
            }
            return null;
        }
        if (iIOMetadata.isStandardMetadataFormatSupported() && (node = iIOMetadata.getAsTree(string = "javax_imageio_1.0")) != null) {
            JPEGMetadata jPEGMetadata = new JPEGMetadata(imageTypeSpecifier, imageWriteParam, this);
            try {
                jPEGMetadata.setFromTree(string, node);
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                return null;
            }
            return jPEGMetadata;
        }
        return null;
    }

    public int getNumThumbnailsSupported(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam, IIOMetadata iIOMetadata, IIOMetadata iIOMetadata2) {
        if (this.jfifOK(imageTypeSpecifier, imageWriteParam, iIOMetadata, iIOMetadata2)) {
            return Integer.MAX_VALUE;
        }
        return 0;
    }

    public Dimension[] getPreferredThumbnailSizes(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam, IIOMetadata iIOMetadata, IIOMetadata iIOMetadata2) {
        if (this.jfifOK(imageTypeSpecifier, imageWriteParam, iIOMetadata, iIOMetadata2)) {
            return (Dimension[])preferredThumbSizes.clone();
        }
        return null;
    }

    private boolean jfifOK(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam, IIOMetadata iIOMetadata, IIOMetadata iIOMetadata2) {
        if (imageTypeSpecifier != null && !JPEG.isJFIFcompliant(imageTypeSpecifier, true)) {
            return false;
        }
        if (iIOMetadata2 != null) {
            JPEGMetadata jPEGMetadata = null;
            jPEGMetadata = iIOMetadata2 instanceof JPEGMetadata ? (JPEGMetadata)iIOMetadata2 : (JPEGMetadata)this.convertImageMetadata(iIOMetadata2, imageTypeSpecifier, imageWriteParam);
            if (jPEGMetadata.findMarkerSegment(class$com$sun$imageio$plugins$jpeg$JFIFMarkerSegment == null ? (class$com$sun$imageio$plugins$jpeg$JFIFMarkerSegment = JPEGImageWriter.class$("com.sun.imageio.plugins.jpeg.JFIFMarkerSegment")) : class$com$sun$imageio$plugins$jpeg$JFIFMarkerSegment, true) == null) {
                return false;
            }
        }
        return true;
    }

    public boolean canWriteRasters() {
        return true;
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        int n2;
        Object object;
        boolean bl2;
        int n3;
        int n4;
        Object object2;
        int n5;
        int[] nArray;
        int[] nArray2;
        if (this.ios == null) {
            throw new IllegalStateException("Output has not been set!");
        }
        if (iIOMetadata != null) {
            this.warningOccurred(1);
        }
        boolean bl3 = iIOImage.hasRaster();
        RenderedImage renderedImage = null;
        this.srcRas = bl3 ? iIOImage.getRaster() : ((renderedImage = iIOImage.getRenderedImage()) instanceof BufferedImage ? ((BufferedImage)renderedImage).getRaster() : renderedImage.getData());
        int n6 = this.srcRas.getNumBands();
        this.indexed = false;
        this.indexCM = null;
        ColorModel colorModel = null;
        ColorSpace colorSpace = null;
        if (!bl3 && (colorModel = renderedImage.getColorModel()) != null) {
            colorSpace = colorModel.getColorSpace();
            if (colorModel instanceof IndexColorModel) {
                this.indexed = true;
                this.indexCM = (IndexColorModel)colorModel;
                n6 = colorModel.getNumComponents();
            }
        }
        this.srcBands = JPEG.bandOffsets[n6 - 1];
        int n7 = n6;
        if (imageWriteParam != null && (nArray2 = imageWriteParam.getSourceBands()) != null) {
            if (this.indexed) {
                this.warningOccurred(8);
            } else {
                this.srcBands = nArray2;
                n7 = this.srcBands.length;
                if (n7 > n6) {
                    throw new IIOException("ImageWriteParam specifies too many source bands");
                }
            }
        }
        boolean bl4 = n7 != n6;
        boolean bl5 = !bl3 && !bl4;
        int[] nArray3 = null;
        if (!this.indexed) {
            nArray3 = this.srcRas.getSampleModel().getSampleSize();
            if (bl4) {
                nArray = new int[n7];
                n5 = 0;
                while (n5 < n7) {
                    nArray[n5] = nArray3[this.srcBands[n5]];
                    ++n5;
                }
                nArray3 = nArray;
            }
        } else {
            nArray = this.srcRas.getSampleModel().getSampleSize();
            nArray3 = new int[n6];
            n5 = 0;
            while (n5 < n6) {
                nArray3[n5] = nArray[0];
                ++n5;
            }
        }
        if (this.debug) {
            System.out.println("numSrcBands is " + n6);
            System.out.println("numBandsUsed is " + n7);
            System.out.println("usingBandSubset is " + bl4);
            System.out.println("fullImage is " + bl5);
            System.out.print("Band sizes:");
            int n8 = 0;
            while (n8 < nArray3.length) {
                System.out.print(" " + nArray3[n8]);
                ++n8;
            }
            System.out.println();
        }
        ImageTypeSpecifier imageTypeSpecifier = null;
        if (imageWriteParam != null) {
            imageTypeSpecifier = imageWriteParam.getDestinationType();
            if (bl5 && imageTypeSpecifier != null) {
                this.warningOccurred(0);
                imageTypeSpecifier = null;
            }
        }
        this.sourceXOffset = 0;
        this.sourceYOffset = 0;
        n5 = this.srcRas.getWidth();
        int n9 = this.srcRas.getHeight();
        this.sourceWidth = n5;
        this.sourceHeight = n9;
        int n10 = 1;
        int n11 = 1;
        int n12 = 0;
        int n13 = 0;
        JPEGQTable[] jPEGQTableArray = null;
        JPEGHuffmanTable[] jPEGHuffmanTableArray = null;
        JPEGHuffmanTable[] jPEGHuffmanTableArray2 = null;
        boolean bl6 = false;
        JPEGImageWriteParam jPEGImageWriteParam = null;
        int n14 = 0;
        if (imageWriteParam != null) {
            object2 = imageWriteParam.getSourceRegion();
            if (object2 != null) {
                this.sourceXOffset = ((Rectangle)object2).x;
                this.sourceYOffset = ((Rectangle)object2).y;
                this.sourceWidth = ((Rectangle)object2).width;
                this.sourceHeight = ((Rectangle)object2).height;
            }
            if (this.sourceWidth + this.sourceXOffset > n5) {
                this.sourceWidth = n5 - this.sourceXOffset;
            }
            if (this.sourceHeight + this.sourceYOffset > n9) {
                this.sourceHeight = n9 - this.sourceYOffset;
            }
            n10 = imageWriteParam.getSourceXSubsampling();
            n11 = imageWriteParam.getSourceYSubsampling();
            n12 = imageWriteParam.getSubsamplingXOffset();
            n13 = imageWriteParam.getSubsamplingYOffset();
            switch (imageWriteParam.getCompressionMode()) {
                case 0: {
                    throw new IIOException("JPEG compression cannot be disabled");
                }
                case 2: {
                    float f2 = imageWriteParam.getCompressionQuality();
                    jPEGQTableArray = new JPEGQTable[]{JPEGQTable.K1Div2Luminance.getScaledInstance(f2, true), JPEGQTable.K2Div2Chrominance.getScaledInstance(f2, true)};
                    break;
                }
                case 1: {
                    jPEGQTableArray = new JPEGQTable[]{JPEGQTable.K1Div2Luminance, JPEGQTable.K2Div2Chrominance};
                }
            }
            n14 = imageWriteParam.getProgressiveMode();
            if (imageWriteParam instanceof JPEGImageWriteParam) {
                jPEGImageWriteParam = (JPEGImageWriteParam)imageWriteParam;
                bl6 = jPEGImageWriteParam.getOptimizeHuffmanTables();
            }
        }
        if ((object2 = iIOImage.getMetadata()) != null) {
            if (object2 instanceof JPEGMetadata) {
                this.metadata = (JPEGMetadata)object2;
                if (this.debug) {
                    System.out.println("We have metadata, and it's JPEG metadata");
                }
            } else if (!bl3) {
                ImageTypeSpecifier imageTypeSpecifier2 = imageTypeSpecifier;
                if (imageTypeSpecifier2 == null) {
                    imageTypeSpecifier2 = new ImageTypeSpecifier(renderedImage);
                }
                this.metadata = (JPEGMetadata)this.convertImageMetadata((IIOMetadata)object2, imageTypeSpecifier2, imageWriteParam);
            } else {
                this.warningOccurred(7);
            }
        }
        this.ignoreJFIF = false;
        this.ignoreAdobe = false;
        this.newAdobeTransform = -1;
        this.writeDefaultJFIF = false;
        this.writeAdobe = false;
        int n15 = 0;
        int n16 = 0;
        JFIFMarkerSegment jFIFMarkerSegment = null;
        AdobeMarkerSegment adobeMarkerSegment = null;
        SOFMarkerSegment sOFMarkerSegment = null;
        if (this.metadata != null) {
            jFIFMarkerSegment = (JFIFMarkerSegment)this.metadata.findMarkerSegment(class$com$sun$imageio$plugins$jpeg$JFIFMarkerSegment == null ? (class$com$sun$imageio$plugins$jpeg$JFIFMarkerSegment = JPEGImageWriter.class$("com.sun.imageio.plugins.jpeg.JFIFMarkerSegment")) : class$com$sun$imageio$plugins$jpeg$JFIFMarkerSegment, true);
            adobeMarkerSegment = (AdobeMarkerSegment)this.metadata.findMarkerSegment(class$com$sun$imageio$plugins$jpeg$AdobeMarkerSegment == null ? (class$com$sun$imageio$plugins$jpeg$AdobeMarkerSegment = JPEGImageWriter.class$("com.sun.imageio.plugins.jpeg.AdobeMarkerSegment")) : class$com$sun$imageio$plugins$jpeg$AdobeMarkerSegment, true);
            sOFMarkerSegment = (SOFMarkerSegment)this.metadata.findMarkerSegment(class$com$sun$imageio$plugins$jpeg$SOFMarkerSegment == null ? (class$com$sun$imageio$plugins$jpeg$SOFMarkerSegment = JPEGImageWriter.class$("com.sun.imageio.plugins.jpeg.SOFMarkerSegment")) : class$com$sun$imageio$plugins$jpeg$SOFMarkerSegment, true);
        }
        this.iccProfile = null;
        this.convertTosRGB = false;
        this.converted = null;
        if (imageTypeSpecifier != null) {
            if (n7 != imageTypeSpecifier.getNumBands()) {
                throw new IIOException("Number of source bands != number of destination bands");
            }
            colorSpace = imageTypeSpecifier.getColorModel().getColorSpace();
            if (this.metadata != null) {
                this.checkSOFBands(sOFMarkerSegment, n7);
                this.checkJFIF(jFIFMarkerSegment, imageTypeSpecifier, false);
                if (jFIFMarkerSegment != null && !this.ignoreJFIF && JPEG.isNonStandardICC(colorSpace)) {
                    this.iccProfile = ((ICC_ColorSpace)colorSpace).getProfile();
                }
                this.checkAdobe(adobeMarkerSegment, imageTypeSpecifier, false);
            } else if (JPEG.isJFIFcompliant(imageTypeSpecifier, false)) {
                this.writeDefaultJFIF = true;
                if (JPEG.isNonStandardICC(colorSpace)) {
                    this.iccProfile = ((ICC_ColorSpace)colorSpace).getProfile();
                }
            } else {
                n4 = JPEG.transformForType(imageTypeSpecifier, false);
                if (n4 != -1) {
                    this.writeAdobe = true;
                    this.newAdobeTransform = n4;
                }
            }
        } else if (this.metadata == null) {
            if (bl5) {
                this.metadata = new JPEGMetadata(new ImageTypeSpecifier(renderedImage), imageWriteParam, this);
                if (this.metadata.findMarkerSegment(class$com$sun$imageio$plugins$jpeg$JFIFMarkerSegment == null ? (class$com$sun$imageio$plugins$jpeg$JFIFMarkerSegment = JPEGImageWriter.class$("com.sun.imageio.plugins.jpeg.JFIFMarkerSegment")) : class$com$sun$imageio$plugins$jpeg$JFIFMarkerSegment, true) != null && JPEG.isNonStandardICC(colorSpace = renderedImage.getColorModel().getColorSpace())) {
                    this.iccProfile = ((ICC_ColorSpace)colorSpace).getProfile();
                }
                n15 = this.getSrcCSType(renderedImage);
                n16 = this.getDefaultDestCSType(renderedImage);
            }
        } else {
            this.checkSOFBands(sOFMarkerSegment, n7);
            if (bl5) {
                ImageTypeSpecifier imageTypeSpecifier3 = new ImageTypeSpecifier(renderedImage);
                n15 = this.getSrcCSType(renderedImage);
                if (colorModel != null) {
                    boolean bl7 = colorModel.hasAlpha();
                    block5 : switch (colorSpace.getType()) {
                        case 6: {
                            if (!bl7) {
                                n16 = 1;
                            } else if (jFIFMarkerSegment != null) {
                                this.ignoreJFIF = true;
                                this.warningOccurred(5);
                            }
                            if (adobeMarkerSegment == null || adobeMarkerSegment.transform == 0) break;
                            this.newAdobeTransform = 0;
                            this.warningOccurred(6);
                            break;
                        }
                        case 5: {
                            if (!bl7) {
                                if (jFIFMarkerSegment != null) {
                                    n16 = 3;
                                    if (!JPEG.isNonStandardICC(colorSpace) && (!(colorSpace instanceof ICC_ColorSpace) || jFIFMarkerSegment.iccSegment == null)) break;
                                    this.iccProfile = ((ICC_ColorSpace)colorSpace).getProfile();
                                    break;
                                }
                                if (adobeMarkerSegment != null) {
                                    switch (adobeMarkerSegment.transform) {
                                        case 0: {
                                            n16 = 2;
                                            break block5;
                                        }
                                        case 1: {
                                            n16 = 3;
                                            break block5;
                                        }
                                    }
                                    this.warningOccurred(6);
                                    this.newAdobeTransform = 0;
                                    n16 = 2;
                                    break;
                                }
                                n3 = sOFMarkerSegment.getIDencodedCSType();
                                if (n3 != 0) {
                                    n16 = n3;
                                    break;
                                }
                                bl2 = this.isSubsampled(sOFMarkerSegment.componentSpecs);
                                if (bl2) {
                                    n16 = 3;
                                    break;
                                }
                                n16 = 2;
                                break;
                            }
                            if (jFIFMarkerSegment != null) {
                                this.ignoreJFIF = true;
                                this.warningOccurred(5);
                            }
                            if (adobeMarkerSegment != null) {
                                if (adobeMarkerSegment.transform != 0) {
                                    this.newAdobeTransform = 0;
                                    this.warningOccurred(6);
                                }
                                n16 = 6;
                                break;
                            }
                            n3 = sOFMarkerSegment.getIDencodedCSType();
                            if (n3 != 0) {
                                n16 = n3;
                                break;
                            }
                            bl2 = this.isSubsampled(sOFMarkerSegment.componentSpecs);
                            n16 = bl2 ? 7 : 6;
                            break;
                        }
                        case 13: {
                            if (colorSpace != JPEG.YCC) break;
                            if (!bl7) {
                                if (jFIFMarkerSegment != null) {
                                    this.convertTosRGB = true;
                                    this.convertOp = new ColorConvertOp(colorSpace, JPEG.sRGB, null);
                                    n16 = 3;
                                    break;
                                }
                                if (adobeMarkerSegment != null) {
                                    if (adobeMarkerSegment.transform != 1) {
                                        this.newAdobeTransform = 1;
                                        this.warningOccurred(6);
                                    }
                                    n16 = 5;
                                    break;
                                }
                                n16 = 5;
                                break;
                            }
                            if (jFIFMarkerSegment != null) {
                                this.ignoreJFIF = true;
                                this.warningOccurred(5);
                            } else if (adobeMarkerSegment != null && adobeMarkerSegment.transform != 0) {
                                this.newAdobeTransform = 0;
                                this.warningOccurred(6);
                            }
                            n16 = 10;
                        }
                    }
                }
            }
        }
        n4 = 0;
        int[] nArray4 = null;
        if (this.metadata != null) {
            if (sOFMarkerSegment == null) {
                sOFMarkerSegment = (SOFMarkerSegment)this.metadata.findMarkerSegment(class$com$sun$imageio$plugins$jpeg$SOFMarkerSegment == null ? (class$com$sun$imageio$plugins$jpeg$SOFMarkerSegment = JPEGImageWriter.class$("com.sun.imageio.plugins.jpeg.SOFMarkerSegment")) : class$com$sun$imageio$plugins$jpeg$SOFMarkerSegment, true);
            }
            if (sOFMarkerSegment != null && sOFMarkerSegment.tag == 194) {
                n4 = 1;
                if (n14 == 3) {
                    nArray4 = this.collectScans(this.metadata, sOFMarkerSegment);
                } else {
                    this.numScans = 0;
                }
            }
            if (jFIFMarkerSegment == null) {
                jFIFMarkerSegment = (JFIFMarkerSegment)this.metadata.findMarkerSegment(class$com$sun$imageio$plugins$jpeg$JFIFMarkerSegment == null ? (class$com$sun$imageio$plugins$jpeg$JFIFMarkerSegment = JPEGImageWriter.class$("com.sun.imageio.plugins.jpeg.JFIFMarkerSegment")) : class$com$sun$imageio$plugins$jpeg$JFIFMarkerSegment, true);
            }
        }
        this.thumbnails = iIOImage.getThumbnails();
        n3 = iIOImage.getNumThumbnails();
        this.forceJFIF = false;
        if (!this.writeDefaultJFIF) {
            if (this.metadata == null) {
                this.thumbnails = null;
                if (n3 != 0) {
                    this.warningOccurred(10);
                }
            } else if (!bl5) {
                if (jFIFMarkerSegment == null) {
                    this.thumbnails = null;
                    if (n3 != 0) {
                        this.warningOccurred(10);
                    }
                }
            } else if (jFIFMarkerSegment == null) {
                if (n16 == 1 || n16 == 3) {
                    if (n3 != 0) {
                        this.forceJFIF = true;
                        this.warningOccurred(11);
                    }
                } else {
                    this.thumbnails = null;
                    if (n3 != 0) {
                        this.warningOccurred(10);
                    }
                }
            }
        }
        bl2 = this.metadata != null || this.writeDefaultJFIF || this.writeAdobe;
        boolean bl8 = true;
        boolean bl9 = true;
        DQTMarkerSegment dQTMarkerSegment = null;
        DHTMarkerSegment dHTMarkerSegment = null;
        int n17 = 0;
        if (this.metadata != null) {
            dQTMarkerSegment = (DQTMarkerSegment)this.metadata.findMarkerSegment(class$com$sun$imageio$plugins$jpeg$DQTMarkerSegment == null ? (class$com$sun$imageio$plugins$jpeg$DQTMarkerSegment = JPEGImageWriter.class$("com.sun.imageio.plugins.jpeg.DQTMarkerSegment")) : class$com$sun$imageio$plugins$jpeg$DQTMarkerSegment, true);
            dHTMarkerSegment = (DHTMarkerSegment)this.metadata.findMarkerSegment(class$com$sun$imageio$plugins$jpeg$DHTMarkerSegment == null ? (class$com$sun$imageio$plugins$jpeg$DHTMarkerSegment = JPEGImageWriter.class$("com.sun.imageio.plugins.jpeg.DHTMarkerSegment")) : class$com$sun$imageio$plugins$jpeg$DHTMarkerSegment, true);
            object = (DRIMarkerSegment)this.metadata.findMarkerSegment(class$com$sun$imageio$plugins$jpeg$DRIMarkerSegment == null ? (class$com$sun$imageio$plugins$jpeg$DRIMarkerSegment = JPEGImageWriter.class$("com.sun.imageio.plugins.jpeg.DRIMarkerSegment")) : class$com$sun$imageio$plugins$jpeg$DRIMarkerSegment, true);
            if (object != null) {
                n17 = object.restartInterval;
            }
            if (dQTMarkerSegment == null) {
                bl8 = false;
            }
            if (dHTMarkerSegment == null) {
                bl9 = false;
            }
        }
        if (jPEGQTableArray == null) {
            jPEGQTableArray = dQTMarkerSegment != null ? this.collectQTablesFromMetadata(this.metadata) : (this.streamQTables != null ? this.streamQTables : (jPEGImageWriteParam != null && jPEGImageWriteParam.areTablesSet() ? jPEGImageWriteParam.getQTables() : JPEG.getDefaultQTables()));
        }
        if (!bl6) {
            if (dHTMarkerSegment != null && n4 == 0) {
                jPEGHuffmanTableArray = this.collectHTablesFromMetadata(this.metadata, true);
                jPEGHuffmanTableArray2 = this.collectHTablesFromMetadata(this.metadata, false);
            } else if (this.streamDCHuffmanTables != null) {
                jPEGHuffmanTableArray = this.streamDCHuffmanTables;
                jPEGHuffmanTableArray2 = this.streamACHuffmanTables;
            } else if (jPEGImageWriteParam != null && jPEGImageWriteParam.areTablesSet()) {
                jPEGHuffmanTableArray = jPEGImageWriteParam.getDCHuffmanTables();
                jPEGHuffmanTableArray2 = jPEGImageWriteParam.getACHuffmanTables();
            } else {
                jPEGHuffmanTableArray = JPEG.getDefaultHuffmanTables(true);
                jPEGHuffmanTableArray2 = JPEG.getDefaultHuffmanTables(false);
            }
        }
        object = new int[n7];
        int[] nArray5 = new int[n7];
        int[] nArray6 = new int[n7];
        int[] nArray7 = new int[n7];
        int n18 = 0;
        while (n18 < n7) {
            object[n18] = n18 + 1;
            nArray5[n18] = 1;
            nArray6[n18] = 1;
            nArray7[n18] = 0;
            ++n18;
        }
        if (sOFMarkerSegment != null) {
            n2 = 0;
            while (n2 < n7) {
                if (!this.forceJFIF) {
                    object[n2] = sOFMarkerSegment.componentSpecs[n2].componentId;
                }
                nArray5[n2] = sOFMarkerSegment.componentSpecs[n2].HsamplingFactor;
                nArray6[n2] = sOFMarkerSegment.componentSpecs[n2].VsamplingFactor;
                nArray7[n2] = sOFMarkerSegment.componentSpecs[n2].QtableSelector;
                ++n2;
            }
        }
        this.sourceXOffset += n12;
        this.sourceWidth -= n12;
        this.sourceYOffset += n13;
        this.sourceHeight -= n13;
        n2 = (this.sourceWidth + n10 - 1) / n10;
        int n19 = (this.sourceHeight + n11 - 1) / n11;
        int n20 = this.sourceWidth * n7;
        DataBufferByte dataBufferByte = new DataBufferByte(n20);
        int[] nArray8 = JPEG.bandOffsets[n7 - 1];
        this.raster = Raster.createInterleavedRaster(dataBufferByte, this.sourceWidth, 1, n20, n7, nArray8, null);
        this.processImageStarted(this.currentImage);
        boolean bl10 = false;
        if (this.debug) {
            System.out.println("inCsType: " + n15);
            System.out.println("outCsType: " + n16);
        }
        if (bl10 = this.writeImage(this.structPointer, dataBufferByte.getData(), n15, n16, n7, nArray3, this.sourceWidth, n2, n19, n10, n11, jPEGQTableArray, bl8, jPEGHuffmanTableArray, jPEGHuffmanTableArray2, bl9, bl6, n14 != 0, this.numScans, nArray4, (int[])object, nArray5, nArray6, nArray7, bl2, n17)) {
            this.processWriteAborted();
        } else {
            this.processImageComplete();
        }
        this.ios.flush();
        ++this.currentImage;
    }

    public void prepareWriteSequence(IIOMetadata iIOMetadata) throws IOException {
        if (this.ios == null) {
            throw new IllegalStateException("Output has not been set!");
        }
        if (iIOMetadata != null) {
            if (iIOMetadata instanceof JPEGMetadata) {
                JPEGMetadata jPEGMetadata = (JPEGMetadata)iIOMetadata;
                if (!jPEGMetadata.isStream) {
                    throw new IllegalArgumentException("Invalid stream metadata object.");
                }
                if (this.currentImage != 0) {
                    throw new IIOException("JPEG Stream metadata must precede all images");
                }
                if (this.sequencePrepared) {
                    throw new IIOException("Stream metadata already written!");
                }
                this.streamQTables = this.collectQTablesFromMetadata(jPEGMetadata);
                if (this.debug) {
                    System.out.println("after collecting from stream metadata, streamQTables.length is " + this.streamQTables.length);
                }
                if (this.streamQTables == null) {
                    this.streamQTables = JPEG.getDefaultQTables();
                }
                this.streamDCHuffmanTables = this.collectHTablesFromMetadata(jPEGMetadata, true);
                if (this.streamDCHuffmanTables == null) {
                    this.streamDCHuffmanTables = JPEG.getDefaultHuffmanTables(true);
                }
                this.streamACHuffmanTables = this.collectHTablesFromMetadata(jPEGMetadata, false);
                if (this.streamACHuffmanTables == null) {
                    this.streamACHuffmanTables = JPEG.getDefaultHuffmanTables(false);
                }
                this.writeTables(this.structPointer, this.streamQTables, this.streamDCHuffmanTables, this.streamACHuffmanTables);
            } else {
                throw new IIOException("Stream metadata must be JPEG metadata");
            }
        }
        this.sequencePrepared = true;
    }

    public void writeToSequence(IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        if (!this.sequencePrepared) {
            throw new IllegalStateException("sequencePrepared not called!");
        }
        this.write(null, iIOImage, imageWriteParam);
    }

    public void endWriteSequence() throws IOException {
        if (!this.sequencePrepared) {
            throw new IllegalStateException("sequencePrepared not called!");
        }
        this.sequencePrepared = false;
    }

    public synchronized void abort() {
        super.abort();
        this.abortWrite(this.structPointer);
    }

    public void reset() {
        this.resetWriter(this.structPointer);
        super.reset();
        this.ios = null;
        this.srcRas = null;
        this.raster = null;
        this.convertTosRGB = false;
        this.currentImage = 0;
        this.numScans = 0;
        System.gc();
    }

    public void dispose() {
        if (this.structPointer != 0L) {
            this.disposeWriter(this.structPointer);
            this.structPointer = 0L;
        }
    }

    public void finalize() {
        this.dispose();
    }

    void warningOccurred(int n2) {
        if (n2 < 0 || n2 > 15) {
            throw new InternalError("Invalid warning index");
        }
        this.processWarningOccurred(this.currentImage, "com.sun.imageio.plugins.jpeg.JPEGImageWriterResources", Integer.toString(n2));
    }

    void warningWithMessage(String string) {
        this.processWarningOccurred(this.currentImage, string);
    }

    void thumbnailStarted(int n2) {
        this.processThumbnailStarted(this.currentImage, n2);
    }

    void thumbnailProgress(float f2) {
        this.processThumbnailProgress(f2);
    }

    void thumbnailComplete() {
        this.processThumbnailComplete();
    }

    private void checkSOFBands(SOFMarkerSegment sOFMarkerSegment, int n2) throws IIOException {
        if (sOFMarkerSegment != null && sOFMarkerSegment.componentSpecs.length != n2) {
            throw new IIOException("Metadata components != number of destination bands");
        }
    }

    private void checkJFIF(JFIFMarkerSegment jFIFMarkerSegment, ImageTypeSpecifier imageTypeSpecifier, boolean bl2) {
        if (jFIFMarkerSegment != null && !JPEG.isJFIFcompliant(imageTypeSpecifier, bl2)) {
            this.ignoreJFIF = true;
            this.warningOccurred(bl2 ? 5 : 3);
        }
    }

    private void checkAdobe(AdobeMarkerSegment adobeMarkerSegment, ImageTypeSpecifier imageTypeSpecifier, boolean bl2) {
        int n2;
        if (adobeMarkerSegment != null && adobeMarkerSegment.transform != (n2 = JPEG.transformForType(imageTypeSpecifier, bl2))) {
            this.warningOccurred(bl2 ? 6 : 4);
            if (n2 == -1) {
                this.ignoreAdobe = true;
            } else {
                this.newAdobeTransform = n2;
            }
        }
    }

    private int[] collectScans(JPEGMetadata jPEGMetadata, SOFMarkerSegment sOFMarkerSegment) {
        Object object;
        ArrayList arrayList = new ArrayList();
        int n2 = 9;
        int n3 = 4;
        Iterator iterator = jPEGMetadata.markerSequence.iterator();
        while (iterator.hasNext()) {
            object = (MarkerSegment)iterator.next();
            if (!(object instanceof SOSMarkerSegment)) continue;
            arrayList.add(object);
        }
        object = null;
        this.numScans = 0;
        if (!arrayList.isEmpty()) {
            this.numScans = arrayList.size();
            object = new int[this.numScans * n2];
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.numScans) {
                SOSMarkerSegment sOSMarkerSegment = (SOSMarkerSegment)arrayList.get(n5);
                object[n4++] = sOSMarkerSegment.componentSpecs.length;
                int n6 = 0;
                while (n6 < n3) {
                    if (n6 < sOSMarkerSegment.componentSpecs.length) {
                        int n7 = sOSMarkerSegment.componentSpecs[n6].componentSelector;
                        int n8 = 0;
                        while (n8 < sOFMarkerSegment.componentSpecs.length) {
                            if (n7 == sOFMarkerSegment.componentSpecs[n8].componentId) {
                                object[n4++] = n8;
                                break;
                            }
                            ++n8;
                        }
                    } else {
                        object[n4++] = false;
                    }
                    ++n6;
                }
                object[n4++] = sOSMarkerSegment.startSpectralSelection;
                object[n4++] = sOSMarkerSegment.endSpectralSelection;
                object[n4++] = sOSMarkerSegment.approxHigh;
                object[n4++] = sOSMarkerSegment.approxLow;
                ++n5;
            }
        }
        return object;
    }

    private JPEGQTable[] collectQTablesFromMetadata(JPEGMetadata jPEGMetadata) {
        JPEGQTable[] jPEGQTableArray;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = jPEGMetadata.markerSequence.iterator();
        while (iterator.hasNext()) {
            jPEGQTableArray = (JPEGQTable[])iterator.next();
            if (!(jPEGQTableArray instanceof DQTMarkerSegment)) continue;
            DQTMarkerSegment dQTMarkerSegment = (DQTMarkerSegment)jPEGQTableArray;
            arrayList.addAll(dQTMarkerSegment.tables);
        }
        jPEGQTableArray = null;
        if (arrayList.size() != 0) {
            jPEGQTableArray = new JPEGQTable[arrayList.size()];
            int n2 = 0;
            while (n2 < jPEGQTableArray.length) {
                jPEGQTableArray[n2] = new JPEGQTable(((DQTMarkerSegment.Qtable)arrayList.get((int)n2)).data);
                ++n2;
            }
        }
        return jPEGQTableArray;
    }

    private JPEGHuffmanTable[] collectHTablesFromMetadata(JPEGMetadata jPEGMetadata, boolean bl2) throws IIOException {
        int n2;
        Object[] objectArray;
        JPEGHuffmanTable[] jPEGHuffmanTableArray;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = jPEGMetadata.markerSequence.iterator();
        while (iterator.hasNext()) {
            jPEGHuffmanTableArray = (JPEGHuffmanTable[])iterator.next();
            if (!(jPEGHuffmanTableArray instanceof DHTMarkerSegment)) continue;
            objectArray = (DHTMarkerSegment)jPEGHuffmanTableArray;
            n2 = 0;
            while (n2 < objectArray.tables.size()) {
                DHTMarkerSegment.Htable htable = (DHTMarkerSegment.Htable)objectArray.tables.get(n2);
                if (htable.tableClass == (bl2 ? 0 : 1)) {
                    arrayList.add(htable);
                }
                ++n2;
            }
        }
        jPEGHuffmanTableArray = null;
        if (arrayList.size() != 0) {
            objectArray = new DHTMarkerSegment.Htable[arrayList.size()];
            arrayList.toArray(objectArray);
            jPEGHuffmanTableArray = new JPEGHuffmanTable[arrayList.size()];
            n2 = 0;
            while (n2 < jPEGHuffmanTableArray.length) {
                jPEGHuffmanTableArray[n2] = null;
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    if (((DHTMarkerSegment.Htable)objectArray[n3]).tableID == n2) {
                        if (jPEGHuffmanTableArray[n2] != null) {
                            throw new IIOException("Metadata has duplicate Htables!");
                        }
                        jPEGHuffmanTableArray[n2] = new JPEGHuffmanTable(((DHTMarkerSegment.Htable)objectArray[n3]).numCodes, ((DHTMarkerSegment.Htable)objectArray[n3]).values);
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        return jPEGHuffmanTableArray;
    }

    private int getSrcCSType(RenderedImage renderedImage) {
        int n2 = 0;
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel != null) {
            boolean bl2 = colorModel.hasAlpha();
            ColorSpace colorSpace = colorModel.getColorSpace();
            switch (colorSpace.getType()) {
                case 6: {
                    n2 = 1;
                    break;
                }
                case 5: {
                    if (bl2) {
                        n2 = 6;
                        break;
                    }
                    n2 = 2;
                    break;
                }
                case 3: {
                    if (bl2) {
                        n2 = 7;
                        break;
                    }
                    n2 = 3;
                    break;
                }
                case 13: {
                    if (colorSpace == JPEG.YCC) {
                        n2 = bl2 ? 10 : 5;
                    }
                }
                case 9: {
                    n2 = 4;
                }
            }
        }
        return n2;
    }

    private int getDestCSType(ImageTypeSpecifier imageTypeSpecifier) {
        ColorModel colorModel = imageTypeSpecifier.getColorModel();
        boolean bl2 = colorModel.hasAlpha();
        ColorSpace colorSpace = colorModel.getColorSpace();
        int n2 = 0;
        switch (colorSpace.getType()) {
            case 6: {
                n2 = 1;
                break;
            }
            case 5: {
                if (bl2) {
                    n2 = 6;
                    break;
                }
                n2 = 2;
                break;
            }
            case 3: {
                if (bl2) {
                    n2 = 7;
                    break;
                }
                n2 = 3;
                break;
            }
            case 13: {
                if (colorSpace == JPEG.YCC) {
                    n2 = bl2 ? 10 : 5;
                }
            }
            case 9: {
                n2 = 4;
            }
        }
        return n2;
    }

    private int getDefaultDestCSType(RenderedImage renderedImage) {
        int n2 = 0;
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel != null) {
            boolean bl2 = colorModel.hasAlpha();
            ColorSpace colorSpace = colorModel.getColorSpace();
            switch (colorSpace.getType()) {
                case 6: {
                    n2 = 1;
                    break;
                }
                case 5: {
                    if (bl2) {
                        n2 = 7;
                        break;
                    }
                    n2 = 3;
                    break;
                }
                case 3: {
                    if (bl2) {
                        n2 = 7;
                        break;
                    }
                    n2 = 3;
                    break;
                }
                case 13: {
                    if (colorSpace == JPEG.YCC) {
                        n2 = bl2 ? 10 : 5;
                    }
                }
                case 9: {
                    n2 = 11;
                }
            }
        }
        return n2;
    }

    private boolean isSubsampled(SOFMarkerSegment.ComponentSpec[] componentSpecArray) {
        int n2 = componentSpecArray[0].HsamplingFactor;
        int n3 = componentSpecArray[0].VsamplingFactor;
        int n4 = 1;
        while (n4 < componentSpecArray.length) {
            if (componentSpecArray[n4].HsamplingFactor != n2 || componentSpecArray[n4].HsamplingFactor != n2) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    private static native void initWriterIDs(Class var0, Class var1, Class var2);

    private native long initJPEGImageWriter();

    private native void setDest(long var1, ImageOutputStream var3);

    private native boolean writeImage(long var1, byte[] var3, int var4, int var5, int var6, int[] var7, int var8, int var9, int var10, int var11, int var12, JPEGQTable[] var13, boolean var14, JPEGHuffmanTable[] var15, JPEGHuffmanTable[] var16, boolean var17, boolean var18, boolean var19, int var20, int[] var21, int[] var22, int[] var23, int[] var24, int[] var25, boolean var26, int var27);

    private void writeMetadata() throws IOException {
        if (this.metadata == null) {
            if (this.writeDefaultJFIF) {
                JFIFMarkerSegment.writeDefaultJFIF(this.ios, this.thumbnails, this.iccProfile, this);
            }
            if (this.writeAdobe) {
                AdobeMarkerSegment.writeAdobeSegment(this.ios, this.newAdobeTransform);
            }
        } else {
            this.metadata.writeToStream(this.ios, this.ignoreJFIF, this.forceJFIF, this.thumbnails, this.iccProfile, this.ignoreAdobe, this.newAdobeTransform, this);
        }
    }

    private native void writeTables(long var1, JPEGQTable[] var3, JPEGHuffmanTable[] var4, JPEGHuffmanTable[] var5);

    private void grabPixels(int n2) {
        Raster raster = null;
        if (this.indexed) {
            raster = this.srcRas.createChild(this.sourceXOffset, this.sourceYOffset + n2, this.sourceWidth, 1, 0, 0, new int[]{0});
            BufferedImage bufferedImage = this.indexCM.convertToIntDiscrete(raster, false);
            raster = bufferedImage.getRaster();
        } else {
            raster = this.srcRas.createChild(this.sourceXOffset, this.sourceYOffset + n2, this.sourceWidth, 1, 0, 0, this.srcBands);
        }
        if (this.convertTosRGB) {
            if (this.debug) {
                System.out.println("Converting to sRGB");
            }
            this.converted = this.convertOp.filter(raster, this.converted);
            raster = this.converted;
        }
        this.raster.setRect(raster);
        if (n2 > 7 && n2 % 8 == 0) {
            this.processImageProgress((float)n2 / (float)this.sourceHeight * 100.0f);
        }
    }

    private native void abortWrite(long var1);

    private native void resetWriter(long var1);

    private native void disposeWriter(long var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("jpeg"));
        JPEGImageWriter.initWriterIDs(class$javax$imageio$stream$ImageOutputStream == null ? (class$javax$imageio$stream$ImageOutputStream = JPEGImageWriter.class$("javax.imageio.stream.ImageOutputStream")) : class$javax$imageio$stream$ImageOutputStream, class$javax$imageio$plugins$jpeg$JPEGQTable == null ? (class$javax$imageio$plugins$jpeg$JPEGQTable = JPEGImageWriter.class$("javax.imageio.plugins.jpeg.JPEGQTable")) : class$javax$imageio$plugins$jpeg$JPEGQTable, class$javax$imageio$plugins$jpeg$JPEGHuffmanTable == null ? (class$javax$imageio$plugins$jpeg$JPEGHuffmanTable = JPEGImageWriter.class$("javax.imageio.plugins.jpeg.JPEGHuffmanTable")) : class$javax$imageio$plugins$jpeg$JPEGHuffmanTable);
        preferredThumbSizes = new Dimension[]{new Dimension(1, 1), new Dimension(255, 255)};
    }
}

