/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.toolkit.url.Uri;
import com.sun.jndi.toolkit.url.UrlUtil;
import java.net.MalformedURLException;
import java.util.StringTokenizer;

public class DnsUrl
extends Uri {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 53;
    public static final String DEFAULT_DOMAIN = ".";
    private String domain;

    public static DnsUrl[] fromList(String string) throws MalformedURLException {
        DnsUrl[] dnsUrlArray = new DnsUrl[(string.length() + 1) / 2];
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            dnsUrlArray[n2++] = new DnsUrl(stringTokenizer.nextToken());
        }
        DnsUrl[] dnsUrlArray2 = new DnsUrl[n2];
        System.arraycopy(dnsUrlArray, 0, dnsUrlArray2, 0, n2);
        return dnsUrlArray2;
    }

    public DnsUrl(String string) throws MalformedURLException {
        super(string);
        if (!this.scheme.equals("dns")) {
            throw new MalformedURLException(string + " is not a valid DNS pseudo-URL");
        }
        if (this.host == null) {
            this.host = DEFAULT_HOST;
        }
        if (this.port == -1) {
            this.port = 53;
        }
        this.domain = this.path.startsWith("/") ? this.path.substring(1) : this.path;
        this.domain = this.domain.equals("") ? DEFAULT_DOMAIN : UrlUtil.decode(this.domain);
    }

    public String getDomain() {
        return this.domain;
    }

    public String getHostPort() {
        return this.port == 53 ? this.host : this.host + ":" + this.port;
    }
}

