/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPathIterator;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import sun.awt.geom.Crossings;
import sun.awt.geom.Curve;

public final class GeneralPath
implements Shape,
Cloneable {
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    private static final byte SEG_MOVETO = 0;
    private static final byte SEG_LINETO = 1;
    private static final byte SEG_QUADTO = 2;
    private static final byte SEG_CUBICTO = 3;
    private static final byte SEG_CLOSE = 4;
    byte[] pointTypes;
    float[] pointCoords;
    int numTypes;
    int numCoords;
    int windingRule;
    static final int INIT_SIZE = 20;
    static final int EXPAND_MAX = 500;

    public GeneralPath() {
        this(1, 20, 20);
    }

    public GeneralPath(int n2) {
        this(n2, 20, 20);
    }

    public GeneralPath(int n2, int n3) {
        this(n2, n3, n3);
    }

    GeneralPath(int n2, int n3, int n4) {
        this.setWindingRule(n2);
        this.pointTypes = new byte[n3];
        this.pointCoords = new float[n4 * 2];
    }

    public GeneralPath(Shape shape) {
        this(1, 20, 20);
        PathIterator pathIterator = shape.getPathIterator(null);
        this.setWindingRule(pathIterator.getWindingRule());
        this.append(pathIterator, false);
    }

    private void needRoom(int n2, int n3, boolean bl2) {
        Object[] objectArray;
        int n4;
        if (bl2 && this.numTypes == 0) {
            throw new IllegalPathStateException("missing initial moveto in path definition");
        }
        int n5 = this.pointCoords.length;
        if (this.numCoords + n3 > n5) {
            n4 = n5;
            if (n4 > 1000) {
                n4 = 1000;
            }
            if (n4 < n3) {
                n4 = n3;
            }
            objectArray = new float[n5 + n4];
            System.arraycopy(this.pointCoords, 0, objectArray, 0, this.numCoords);
            this.pointCoords = objectArray;
        }
        if (this.numTypes + n2 > (n5 = this.pointTypes.length)) {
            n4 = n5;
            if (n4 > 500) {
                n4 = 500;
            }
            if (n4 < n2) {
                n4 = n2;
            }
            objectArray = new byte[n5 + n4];
            System.arraycopy(this.pointTypes, 0, objectArray, 0, this.numTypes);
            this.pointTypes = (byte[])objectArray;
        }
    }

    public synchronized void moveTo(float f2, float f3) {
        if (this.numTypes > 0 && this.pointTypes[this.numTypes - 1] == 0) {
            this.pointCoords[this.numCoords - 2] = f2;
            this.pointCoords[this.numCoords - 1] = f3;
        } else {
            this.needRoom(1, 2, false);
            this.pointTypes[this.numTypes++] = 0;
            this.pointCoords[this.numCoords++] = f2;
            this.pointCoords[this.numCoords++] = f3;
        }
    }

    public synchronized void lineTo(float f2, float f3) {
        this.needRoom(1, 2, true);
        this.pointTypes[this.numTypes++] = 1;
        this.pointCoords[this.numCoords++] = f2;
        this.pointCoords[this.numCoords++] = f3;
    }

    public synchronized void quadTo(float f2, float f3, float f4, float f5) {
        this.needRoom(1, 4, true);
        this.pointTypes[this.numTypes++] = 2;
        this.pointCoords[this.numCoords++] = f2;
        this.pointCoords[this.numCoords++] = f3;
        this.pointCoords[this.numCoords++] = f4;
        this.pointCoords[this.numCoords++] = f5;
    }

    public synchronized void curveTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.needRoom(1, 6, true);
        this.pointTypes[this.numTypes++] = 3;
        this.pointCoords[this.numCoords++] = f2;
        this.pointCoords[this.numCoords++] = f3;
        this.pointCoords[this.numCoords++] = f4;
        this.pointCoords[this.numCoords++] = f5;
        this.pointCoords[this.numCoords++] = f6;
        this.pointCoords[this.numCoords++] = f7;
    }

    public synchronized void closePath() {
        if (this.numTypes == 0 || this.pointTypes[this.numTypes - 1] != 4) {
            this.needRoom(1, 0, true);
            this.pointTypes[this.numTypes++] = 4;
        }
    }

    public void append(Shape shape, boolean bl2) {
        PathIterator pathIterator = shape.getPathIterator(null);
        this.append(pathIterator, bl2);
    }

    public void append(PathIterator pathIterator, boolean bl2) {
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    if (!bl2 || this.numTypes < 1 || this.numCoords < 2) {
                        this.moveTo(fArray[0], fArray[1]);
                        break;
                    }
                    if (this.pointTypes[this.numTypes - 1] != 4 && this.pointCoords[this.numCoords - 2] == fArray[0] && this.pointCoords[this.numCoords - 1] == fArray[1]) break;
                }
                case 1: {
                    this.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    this.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    this.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    this.closePath();
                }
            }
            pathIterator.next();
            bl2 = false;
        }
    }

    public synchronized int getWindingRule() {
        return this.windingRule;
    }

    public void setWindingRule(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("winding rule must be WIND_EVEN_ODD or WIND_NON_ZERO");
        }
        this.windingRule = n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized Point2D getCurrentPoint() {
        if (this.numTypes < 1) return null;
        if (this.numCoords < 2) {
            return null;
        }
        int n2 = this.numCoords;
        if (this.pointTypes[this.numTypes - 1] != 4) return new Point2D.Float(this.pointCoords[n2 - 2], this.pointCoords[n2 - 1]);
        int n3 = this.numTypes - 2;
        while (n3 > 0) {
            switch (this.pointTypes[n3]) {
                case 0: {
                    return new Point2D.Float(this.pointCoords[n2 - 2], this.pointCoords[n2 - 1]);
                }
                case 1: {
                    n2 -= 2;
                    break;
                }
                case 2: {
                    n2 -= 4;
                    break;
                }
                case 3: {
                    n2 -= 6;
                }
            }
            --n3;
        }
        return new Point2D.Float(this.pointCoords[n2 - 2], this.pointCoords[n2 - 1]);
    }

    public synchronized void reset() {
        this.numCoords = 0;
        this.numTypes = 0;
    }

    public void transform(AffineTransform affineTransform) {
        affineTransform.transform(this.pointCoords, 0, this.pointCoords, 0, this.numCoords / 2);
    }

    public synchronized Shape createTransformedShape(AffineTransform affineTransform) {
        GeneralPath generalPath = (GeneralPath)this.clone();
        if (affineTransform != null) {
            generalPath.transform(affineTransform);
        }
        return generalPath;
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public synchronized Rectangle2D getBounds2D() {
        float f2;
        float f3;
        float f4;
        float f5;
        int n2 = this.numCoords;
        if (n2 > 0) {
            f4 = f5 = this.pointCoords[--n2];
            f2 = f3 = this.pointCoords[--n2];
            while (n2 > 0) {
                float f6;
                float f7 = this.pointCoords[--n2];
                if ((f6 = this.pointCoords[--n2]) < f2) {
                    f2 = f6;
                }
                if (f7 < f4) {
                    f4 = f7;
                }
                if (f6 > f3) {
                    f3 = f6;
                }
                if (!(f7 > f5)) continue;
                f5 = f7;
            }
        } else {
            f5 = 0.0f;
            f3 = 0.0f;
            f4 = 0.0f;
            f2 = 0.0f;
        }
        return new Rectangle2D.Float(f2, f4, f3 - f2, f5 - f4);
    }

    public boolean contains(double d2, double d3) {
        if (this.numTypes < 2) {
            return false;
        }
        int n2 = Curve.crossingsForPath(this.getPathIterator(null), d2, d3);
        if (this.windingRule == 1) {
            return n2 != 0;
        }
        return (n2 & 1) != 0;
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean contains(double d2, double d3, double d4, double d5) {
        Crossings crossings = Crossings.findCrossings(this.getPathIterator(null), d2, d3, d2 + d4, d3 + d5);
        return crossings != null && crossings.covers(d3, d3 + d5);
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean intersects(double d2, double d3, double d4, double d5) {
        Crossings crossings = Crossings.findCrossings(this.getPathIterator(null), d2, d3, d2 + d4, d3 + d5);
        return crossings == null || !crossings.isEmpty();
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new GeneralPathIterator(this, affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d2) {
        return new FlatteningPathIterator(this.getPathIterator(affineTransform), d2);
    }

    public Object clone() {
        try {
            GeneralPath generalPath = (GeneralPath)super.clone();
            generalPath.pointTypes = (byte[])this.pointTypes.clone();
            generalPath.pointCoords = (float[])this.pointCoords.clone();
            return generalPath;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    GeneralPath(int n2, byte[] byArray, int n3, float[] fArray, int n4) {
        this.windingRule = n2;
        this.pointTypes = byArray;
        this.numTypes = n3;
        this.pointCoords = fArray;
        this.numCoords = n4;
    }
}

