/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class LineNumberReader
extends BufferedReader {
    private int lineNumber = 0;
    private int markedLineNumber;
    private boolean skipLF;
    private boolean markedSkipLF;
    private static final int maxSkipBufferSize = 8192;
    private char[] skipBuffer = null;

    public LineNumberReader(Reader reader) {
        super(reader);
    }

    public LineNumberReader(Reader reader, int n2) {
        super(reader, n2);
    }

    public void setLineNumber(int n2) {
        this.lineNumber = n2;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n2 = super.read();
            if (this.skipLF) {
                if (n2 == 10) {
                    n2 = super.read();
                }
                this.skipLF = false;
            }
            switch (n2) {
                case 13: {
                    this.skipLF = true;
                }
                case 10: {
                    ++this.lineNumber;
                    int n3 = 10;
                    return n3;
                }
            }
            int n4 = n2;
            return n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n2, int n3) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n4;
            int n5 = super.read(cArray, n2, n3);
            int n6 = n2;
            while (n6 < n2 + n5) {
                block11: {
                    block10: {
                        n4 = cArray[n6];
                        if (!this.skipLF) break block10;
                        this.skipLF = false;
                        if (n4 == 10) break block11;
                    }
                    switch (n4) {
                        case 13: {
                            this.skipLF = true;
                        }
                        case 10: {
                            ++this.lineNumber;
                        }
                    }
                }
                ++n6;
            }
            n4 = n5;
            return n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            String string = super.readLine(this.skipLF);
            this.skipLF = false;
            if (string != null) {
                ++this.lineNumber;
            }
            String string2 = string;
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l2) throws IOException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("skip() value is negative");
        }
        int n2 = (int)Math.min(l2, 8192L);
        Object object = this.lock;
        synchronized (object) {
            if (this.skipBuffer == null || this.skipBuffer.length < n2) {
                this.skipBuffer = new char[n2];
            }
            long l3 = l2;
            while (l3 > 0L) {
                int n3 = this.read(this.skipBuffer, 0, (int)Math.min(l3, (long)n2));
                if (n3 == -1) break;
                l3 -= (long)n3;
            }
            long l4 = l2 - l3;
            return l4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            super.mark(n2);
            this.markedLineNumber = this.lineNumber;
            this.markedSkipLF = this.skipLF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            super.reset();
            this.lineNumber = this.markedLineNumber;
            this.skipLF = this.markedSkipLF;
        }
    }
}

