/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.SpinnerUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.DocumentFilter;
import javax.swing.text.NumberFormatter;

public class JSpinner
extends JComponent {
    private static final String uiClassID = "SpinnerUI";
    private transient SpinnerModel model;
    private JComponent editor;
    private ChangeListener modelListener;
    private transient ChangeEvent changeEvent;
    private boolean editorExplicitlySet = false;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public JSpinner(SpinnerModel spinnerModel) {
        this.model = spinnerModel;
        this.editor = this.createEditor(spinnerModel);
        this.updateUI();
    }

    public JSpinner() {
        this(new SpinnerNumberModel());
    }

    public SpinnerUI getUI() {
        return (SpinnerUI)this.ui;
    }

    public void setUI(SpinnerUI spinnerUI) {
        super.setUI(spinnerUI);
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void updateUI() {
        this.setUI((SpinnerUI)UIManager.getUI(this));
        this.invalidate();
    }

    protected JComponent createEditor(SpinnerModel spinnerModel) {
        if (spinnerModel instanceof SpinnerDateModel) {
            return new DateEditor(this);
        }
        if (spinnerModel instanceof SpinnerListModel) {
            return new ListEditor(this);
        }
        if (spinnerModel instanceof SpinnerNumberModel) {
            return new NumberEditor(this);
        }
        return new DefaultEditor(this);
    }

    public void setModel(SpinnerModel spinnerModel) {
        if (spinnerModel == null) {
            throw new IllegalArgumentException("null model");
        }
        if (!spinnerModel.equals(this.model)) {
            SpinnerModel spinnerModel2 = this.model;
            this.model = spinnerModel;
            if (this.modelListener != null) {
                this.model.addChangeListener(this.modelListener);
            }
            this.firePropertyChange("model", spinnerModel2, spinnerModel);
            if (!this.editorExplicitlySet) {
                this.setEditor(this.createEditor(spinnerModel));
                this.editorExplicitlySet = false;
            }
            this.repaint();
            this.revalidate();
        }
    }

    public SpinnerModel getModel() {
        return this.model;
    }

    public Object getValue() {
        return this.getModel().getValue();
    }

    public void setValue(Object object) {
        this.getModel().setValue(object);
    }

    public Object getNextValue() {
        return this.getModel().getNextValue();
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.modelListener == null) {
            this.modelListener = new ModelListener();
            this.getModel().addChangeListener(this.modelListener);
        }
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JSpinner.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JSpinner.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JSpinner.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$ChangeListener == null ? JSpinner.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n2 + 1]).stateChanged(this.changeEvent);
            }
            n2 -= 2;
        }
    }

    public Object getPreviousValue() {
        return this.getModel().getPreviousValue();
    }

    public void setEditor(JComponent jComponent) {
        if (jComponent == null) {
            throw new IllegalArgumentException("null editor");
        }
        if (!jComponent.equals(this.editor)) {
            JComponent jComponent2 = this.editor;
            this.editor = jComponent;
            if (jComponent2 instanceof DefaultEditor) {
                ((DefaultEditor)jComponent2).dismiss(this);
            }
            this.editorExplicitlySet = true;
            this.firePropertyChange("editor", jComponent2, jComponent);
            this.revalidate();
            this.repaint();
        }
    }

    public JComponent getEditor() {
        return this.editor;
    }

    public void commitEdit() throws ParseException {
        JComponent jComponent = this.getEditor();
        if (jComponent instanceof DefaultEditor) {
            ((DefaultEditor)jComponent).commitEdit();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        HashMap hashMap = new HashMap(1);
        SpinnerModel spinnerModel = this.getModel();
        if (spinnerModel instanceof Serializable) {
            hashMap.put("model", spinnerModel);
        }
        objectOutputStream.writeObject(hashMap);
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Map map = (Map)objectInputStream.readObject();
        this.model = (SpinnerModel)map.get("model");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ListEditor
    extends DefaultEditor {
        public ListEditor(JSpinner jSpinner) {
            super(jSpinner);
            if (!(jSpinner.getModel() instanceof SpinnerListModel)) {
                throw new IllegalArgumentException("model not a SpinnerListModel");
            }
            this.getTextField().setEditable(true);
            this.getTextField().setFormatterFactory(new DefaultFormatterFactory(new ListFormatter()));
        }

        public SpinnerListModel getModel() {
            return (SpinnerListModel)this.getSpinner().getModel();
        }

        private class ListFormatter
        extends JFormattedTextField.AbstractFormatter {
            private DocumentFilter filter;

            private ListFormatter() {
            }

            public String valueToString(Object object) throws ParseException {
                if (object == null) {
                    return "";
                }
                return object.toString();
            }

            public Object stringToValue(String string) throws ParseException {
                return string;
            }

            protected DocumentFilter getDocumentFilter() {
                if (this.filter == null) {
                    this.filter = new Filter();
                }
                return this.filter;
            }

            private class Filter
            extends DocumentFilter {
                private Filter() {
                }

                public void replace(DocumentFilter.FilterBypass filterBypass, int n2, int n3, String string, AttributeSet attributeSet) throws BadLocationException {
                    if (string != null && n2 + n3 == filterBypass.getDocument().getLength()) {
                        String string2;
                        Object object = ListEditor.this.getModel().findNextMatch(filterBypass.getDocument().getText(0, n2) + string);
                        String string3 = string2 = object != null ? object.toString() : null;
                        if (string2 != null) {
                            filterBypass.remove(0, n2 + n3);
                            filterBypass.insertString(0, string2, null);
                            ListFormatter.this.getFormattedTextField().select(n2 + string.length(), string2.length());
                            return;
                        }
                    }
                    super.replace(filterBypass, n2, n3, string, attributeSet);
                }

                public void insertString(DocumentFilter.FilterBypass filterBypass, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                    this.replace(filterBypass, n2, 0, string, attributeSet);
                }
            }
        }
    }

    public static class NumberEditor
    extends DefaultEditor {
        public NumberEditor(JSpinner jSpinner) {
            this(jSpinner, new DecimalFormat());
        }

        public NumberEditor(JSpinner jSpinner, String string) {
            this(jSpinner, new DecimalFormat(string));
        }

        private NumberEditor(JSpinner jSpinner, DecimalFormat decimalFormat) {
            super(jSpinner);
            if (!(jSpinner.getModel() instanceof SpinnerNumberModel)) {
                throw new IllegalArgumentException("model not a SpinnerNumberModel");
            }
            SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)jSpinner.getModel();
            NumberEditorFormatter numberEditorFormatter = new NumberEditorFormatter(spinnerNumberModel, decimalFormat);
            DefaultFormatterFactory defaultFormatterFactory = new DefaultFormatterFactory(numberEditorFormatter);
            JFormattedTextField jFormattedTextField = this.getTextField();
            jFormattedTextField.setEditable(true);
            jFormattedTextField.setFormatterFactory(defaultFormatterFactory);
            jFormattedTextField.setHorizontalAlignment(4);
            try {
                String string = numberEditorFormatter.valueToString(spinnerNumberModel.getMinimum());
                String string2 = numberEditorFormatter.valueToString(spinnerNumberModel.getMaximum());
                jFormattedTextField.setColumns(Math.max(string.length(), string2.length()));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }

        public DecimalFormat getFormat() {
            return (DecimalFormat)((NumberFormatter)this.getTextField().getFormatter()).getFormat();
        }

        public SpinnerNumberModel getModel() {
            return (SpinnerNumberModel)this.getSpinner().getModel();
        }
    }

    private static class NumberEditorFormatter
    extends NumberFormatter {
        private final SpinnerNumberModel model;

        NumberEditorFormatter(SpinnerNumberModel spinnerNumberModel, NumberFormat numberFormat) {
            super(numberFormat);
            this.model = spinnerNumberModel;
            this.setValueClass(spinnerNumberModel.getValue().getClass());
        }

        public void setMinimum(Comparable comparable) {
            this.model.setMinimum(comparable);
        }

        public Comparable getMinimum() {
            return this.model.getMinimum();
        }

        public void setMaximum(Comparable comparable) {
            this.model.setMaximum(comparable);
        }

        public Comparable getMaximum() {
            return this.model.getMaximum();
        }
    }

    public static class DateEditor
    extends DefaultEditor {
        public DateEditor(JSpinner jSpinner) {
            this(jSpinner, new SimpleDateFormat());
        }

        public DateEditor(JSpinner jSpinner, String string) {
            this(jSpinner, new SimpleDateFormat(string));
        }

        private DateEditor(JSpinner jSpinner, DateFormat dateFormat) {
            super(jSpinner);
            if (!(jSpinner.getModel() instanceof SpinnerDateModel)) {
                throw new IllegalArgumentException("model not a SpinnerDateModel");
            }
            SpinnerDateModel spinnerDateModel = (SpinnerDateModel)jSpinner.getModel();
            DateEditorFormatter dateEditorFormatter = new DateEditorFormatter(spinnerDateModel, dateFormat);
            DefaultFormatterFactory defaultFormatterFactory = new DefaultFormatterFactory(dateEditorFormatter);
            JFormattedTextField jFormattedTextField = this.getTextField();
            jFormattedTextField.setEditable(true);
            jFormattedTextField.setFormatterFactory(defaultFormatterFactory);
            try {
                String string = dateEditorFormatter.valueToString(spinnerDateModel.getStart());
                String string2 = dateEditorFormatter.valueToString(spinnerDateModel.getEnd());
                jFormattedTextField.setColumns(Math.max(string.length(), string2.length()));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }

        public SimpleDateFormat getFormat() {
            return (SimpleDateFormat)((DateFormatter)this.getTextField().getFormatter()).getFormat();
        }

        public SpinnerDateModel getModel() {
            return (SpinnerDateModel)this.getSpinner().getModel();
        }
    }

    private static class DateEditorFormatter
    extends DateFormatter {
        private final SpinnerDateModel model;

        DateEditorFormatter(SpinnerDateModel spinnerDateModel, DateFormat dateFormat) {
            super(dateFormat);
            this.model = spinnerDateModel;
        }

        public void setMinimum(Comparable comparable) {
            this.model.setStart(comparable);
        }

        public Comparable getMinimum() {
            return this.model.getStart();
        }

        public void setMaximum(Comparable comparable) {
            this.model.setEnd(comparable);
        }

        public Comparable getMaximum() {
            return this.model.getEnd();
        }
    }

    public static class DefaultEditor
    extends JPanel
    implements ChangeListener,
    PropertyChangeListener,
    LayoutManager {
        private static final Action SharedIncrementAction = new IncrementAction("increment", true);
        private static final Action SharedDecrementAction = new IncrementAction("decrement", false);

        public DefaultEditor(JSpinner jSpinner) {
            super(null);
            JFormattedTextField jFormattedTextField = new JFormattedTextField();
            jFormattedTextField.setValue(jSpinner.getValue());
            jFormattedTextField.addPropertyChangeListener(this);
            jFormattedTextField.setEditable(false);
            this.add(jFormattedTextField);
            this.setLayout(this);
            jSpinner.addChangeListener(this);
            ActionMap actionMap = SwingUtilities.getUIActionMap(jSpinner);
            if (actionMap == null) {
                actionMap = new ActionMapUIResource();
                SwingUtilities.replaceUIActionMap(jSpinner, actionMap);
            }
            actionMap.clear();
            actionMap.put("increment", SharedIncrementAction);
            actionMap.put("decrement", SharedDecrementAction);
        }

        public void dismiss(JSpinner jSpinner) {
            jSpinner.removeChangeListener(this);
        }

        public JSpinner getSpinner() {
            Container container = this;
            while (container != null) {
                if (container instanceof JSpinner) {
                    return (JSpinner)container;
                }
                container = container.getParent();
            }
            return null;
        }

        public JFormattedTextField getTextField() {
            return (JFormattedTextField)this.getComponent(0);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSpinner jSpinner = (JSpinner)changeEvent.getSource();
            this.getTextField().setValue(jSpinner.getValue());
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JSpinner jSpinner = this.getSpinner();
            if (jSpinner == null) {
                return;
            }
            Object object = propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if (object instanceof JFormattedTextField && "value".equals(string)) {
                Object object2 = jSpinner.getValue();
                try {
                    jSpinner.setValue(this.getTextField().getValue());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    try {
                        ((JFormattedTextField)object).setValue(object2);
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        // empty catch block
                    }
                }
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        private Dimension insetSize(Container container) {
            Insets insets = container.getInsets();
            int n2 = insets.left + insets.right;
            int n3 = insets.top + insets.bottom;
            return new Dimension(n2, n3);
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = this.insetSize(container);
            if (container.getComponentCount() > 0) {
                Dimension dimension2 = this.getComponent(0).getPreferredSize();
                dimension.width += dimension2.width;
                dimension.height += dimension2.height;
            }
            return dimension;
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = this.insetSize(container);
            if (container.getComponentCount() > 0) {
                Dimension dimension2 = this.getComponent(0).getMinimumSize();
                dimension.width += dimension2.width;
                dimension.height += dimension2.height;
            }
            return dimension;
        }

        public void layoutContainer(Container container) {
            if (container.getComponentCount() > 0) {
                Insets insets = container.getInsets();
                int n2 = container.getWidth() - (insets.left + insets.right);
                int n3 = container.getHeight() - (insets.top + insets.bottom);
                this.getComponent(0).setBounds(insets.left, insets.top, n2, n3);
            }
        }

        public void commitEdit() throws ParseException {
            JFormattedTextField jFormattedTextField = this.getTextField();
            jFormattedTextField.commitEdit();
        }

        private static class IncrementAction
        extends AbstractAction {
            private boolean isNext;

            IncrementAction(String string, boolean bl2) {
                super(string);
                this.isNext = bl2;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JSpinner jSpinner;
                Object object = actionEvent.getSource();
                if (object instanceof JSpinner && (jSpinner = (JSpinner)object).getEditor() instanceof DefaultEditor) {
                    try {
                        Object object2;
                        jSpinner.commitEdit();
                        Object object3 = object2 = this.isNext ? jSpinner.getNextValue() : jSpinner.getPreviousValue();
                        if (object2 != null) {
                            jSpinner.setValue(object2);
                        }
                    }
                    catch (ParseException parseException) {
                        UIManager.getLookAndFeel().provideErrorFeedback(jSpinner);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        UIManager.getLookAndFeel().provideErrorFeedback(jSpinner);
                    }
                }
            }
        }
    }

    private class ModelListener
    implements ChangeListener,
    Serializable {
        private ModelListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSpinner.this.fireStateChanged();
        }
    }
}

