/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class Popup {
    private Component component;

    protected Popup(Component component, Component component2, int n2, int n3) {
        this();
        if (component2 == null) {
            throw new IllegalArgumentException("Contents must be non-null");
        }
        this.reset(component, component2, n2, n3);
    }

    protected Popup() {
    }

    public void show() {
        Component component = this.getComponent();
        if (component != null) {
            component.show();
        }
    }

    public void hide() {
        Component component = this.getComponent();
        if (component instanceof JWindow) {
            component.hide();
            ((JWindow)component).getContentPane().removeAll();
        }
        this.dispose();
    }

    void dispose() {
        Component component = this.getComponent();
        if (component instanceof JWindow) {
            ((Window)component).dispose();
            component = null;
        }
    }

    void reset(Component component, Component component2, int n2, int n3) {
        Component component3;
        if (this.getComponent() == null) {
            this.component = this.createComponent(component);
        }
        if ((component3 = this.getComponent()) instanceof JWindow) {
            JWindow jWindow = (JWindow)this.getComponent();
            jWindow.setLocation(n2, n3);
            jWindow.getContentPane().add(component2, "Center");
            component2.invalidate();
            this.pack();
        }
    }

    void pack() {
        Component component = this.getComponent();
        if (component instanceof Window) {
            ((Window)component).pack();
        }
    }

    private Window getParentWindow(Component component) {
        Window window = null;
        if (component instanceof Window) {
            window = (Window)component;
        } else if (component != null) {
            window = SwingUtilities.getWindowAncestor(component);
        }
        if (window == null) {
            window = new DefaultFrame();
        }
        return window;
    }

    Component createComponent(Component component) {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        return new HeavyWeightWindow(this.getParentWindow(component));
    }

    Component getComponent() {
        return this.component;
    }

    static class DefaultFrame
    extends Frame {
        DefaultFrame() {
        }
    }

    static class HeavyWeightWindow
    extends JWindow {
        HeavyWeightWindow(Window window) {
            super(window);
            this.setFocusableWindowState(false);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void show() {
            super.show();
            this.pack();
        }
    }
}

