/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import org.apache.xalan.res.XSLMessages;

final class ChunkedIntArray {
    final int slotsize = 4;
    static final int lowbits = 10;
    static final int chunkalloc = 1024;
    static final int lowmask = 1023;
    ChunksVector chunks = new ChunksVector();
    final int[] fastArray = new int[1024];
    int lastUsed = 0;

    ChunkedIntArray(int n2) {
        if (4 < n2) {
            throw new ArrayIndexOutOfBoundsException(XSLMessages.createMessage(157, new Object[]{Integer.toString(n2)}));
        }
        if (4 > n2) {
            System.out.println("*****WARNING: ChunkedIntArray(" + n2 + ") wasting " + (4 - n2) + " words per slot");
        }
        this.chunks.addElement(this.fastArray);
    }

    int appendSlot(int n2, int n3, int n4, int n5) {
        int n6 = (this.lastUsed + 1) * 4;
        int n7 = n6 >> 10;
        int n8 = n6 & 0x3FF;
        if (n7 > this.chunks.size() - 1) {
            this.chunks.addElement(new int[1024]);
        }
        int[] nArray = this.chunks.elementAt(n7);
        nArray[n8] = n2;
        nArray[n8 + 1] = n3;
        nArray[n8 + 2] = n4;
        nArray[n8 + 3] = n5;
        return ++this.lastUsed;
    }

    int readEntry(int n2, int n3) throws ArrayIndexOutOfBoundsException {
        if (n3 >= 4) {
            throw new ArrayIndexOutOfBoundsException(XSLMessages.createMessage(158, null));
        }
        int n4 = (n2 *= 4) >> 10;
        int n5 = n2 & 0x3FF;
        int[] nArray = this.chunks.elementAt(n4);
        return nArray[n5 + n3];
    }

    int specialFind(int n2, int n3) {
        int n4 = n2;
        while (n4 > 0) {
            int n5 = (n4 *= 4) >> 10;
            int n6 = n4 & 0x3FF;
            int[] nArray = this.chunks.elementAt(n5);
            n4 = nArray[n6 + 1];
            if (n4 == n3) break;
        }
        if (n4 <= 0) {
            return n3;
        }
        return -1;
    }

    int slotsUsed() {
        return this.lastUsed;
    }

    void discardLast() {
        --this.lastUsed;
    }

    void writeEntry(int n2, int n3, int n4) throws ArrayIndexOutOfBoundsException {
        if (n3 >= 4) {
            throw new ArrayIndexOutOfBoundsException(XSLMessages.createMessage(158, null));
        }
        int n5 = (n2 *= 4) >> 10;
        int n6 = n2 & 0x3FF;
        int[] nArray = this.chunks.elementAt(n5);
        nArray[n6 + n3] = n4;
    }

    void writeSlot(int n2, int n3, int n4, int n5, int n6) {
        int n7 = (n2 *= 4) >> 10;
        int n8 = n2 & 0x3FF;
        if (n7 > this.chunks.size() - 1) {
            this.chunks.addElement(new int[1024]);
        }
        int[] nArray = this.chunks.elementAt(n7);
        nArray[n8] = n3;
        nArray[n8 + 1] = n4;
        nArray[n8 + 2] = n5;
        nArray[n8 + 3] = n6;
    }

    void readSlot(int n2, int[] nArray) {
        int n3 = (n2 *= 4) >> 10;
        int n4 = n2 & 0x3FF;
        if (n3 > this.chunks.size() - 1) {
            this.chunks.addElement(new int[1024]);
        }
        int[] nArray2 = this.chunks.elementAt(n3);
        System.arraycopy(nArray2, n4, nArray, 0, 4);
    }

    class ChunksVector {
        final int BLOCKSIZE = 64;
        int[][] m_map = new int[64][];
        int m_mapSize = 64;
        int pos = 0;

        ChunksVector() {
        }

        final int size() {
            return this.pos;
        }

        void addElement(int[] nArray) {
            if (this.pos >= this.m_mapSize) {
                int n2 = this.m_mapSize;
                while (this.pos >= this.m_mapSize) {
                    this.m_mapSize += 64;
                }
                int[][] nArrayArray = new int[this.m_mapSize][];
                System.arraycopy(this.m_map, 0, nArrayArray, 0, n2);
                this.m_map = nArrayArray;
            }
            this.m_map[this.pos] = nArray;
            ++this.pos;
        }

        final int[] elementAt(int n2) {
            return this.m_map[n2];
        }
    }
}

