/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import sun.awt.DebugHelper;
import sun.awt.X11GraphicsDevice;
import sun.awt.font.NativeFontWrapper;
import sun.awt.motif.MFontProperties;
import sun.java2d.SunGraphicsEnvironment;
import sun.print.PSPrinterJob;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

public class X11GraphicsEnvironment
extends SunGraphicsEnvironment {
    private static final DebugHelper dbg = DebugHelper.create(class$sun$awt$X11GraphicsEnvironment == null ? (class$sun$awt$X11GraphicsEnvironment = X11GraphicsEnvironment.class$("sun.awt.X11GraphicsEnvironment")) : class$sun$awt$X11GraphicsEnvironment);
    static Boolean xinerState = null;
    private HashSet fontPropDirs;
    Map fontNameMap;
    Map xFontDirsMap;
    Map xlfdMap;
    private static boolean registerNativeFonts = false;
    private static String display;
    private static boolean isDisplayLocal;
    private Vector nativeFonts;
    static /* synthetic */ Class class$sun$awt$X11GraphicsEnvironment;

    private static native int checkShmExt();

    private static native String getDisplayString();

    private static synchronized native void initDisplay();

    protected native int getNumScreens();

    protected GraphicsDevice makeScreenDevice(int n2) {
        return new X11GraphicsDevice(n2);
    }

    protected native int getDefaultScreenNum();

    public GraphicsDevice getDefaultScreenDevice() {
        return this.getScreenDevices()[this.getDefaultScreenNum()];
    }

    protected boolean isLocalHead() {
        return X11GraphicsEnvironment.isDisplayLocal();
    }

    public static synchronized boolean isDisplayLocal() {
        if (display != null) {
            return isDisplayLocal;
        }
        if (GraphicsEnvironment.isHeadless()) {
            display = "";
            isDisplayLocal = true;
            return true;
        }
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("sun.java2d.remote"));
        if (string != null) {
            display = "";
            isDisplayLocal = string.equals("false");
            return isDisplayLocal;
        }
        int n2 = X11GraphicsEnvironment.checkShmExt();
        if (n2 != -1) {
            display = "";
            isDisplayLocal = n2 == 1;
            return isDisplayLocal;
        }
        display = X11GraphicsEnvironment.getDisplayString();
        int n3 = display.indexOf(":");
        final String string2 = display.substring(0, n3);
        if (n3 <= 0) {
            isDisplayLocal = true;
            return true;
        }
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * Unable to fully structure code
             */
            public Object run() {
                var1_1 = null;
                var2_2 = null;
                var3_3 = null;
                try {
                    var3_3 = NetworkInterface.getNetworkInterfaces();
                    var1_1 = InetAddress.getAllByName(string2);
                    if (var1_1 == null) {
                        return Boolean.FALSE;
                    }
                    ** GOTO lbl25
                }
                catch (UnknownHostException var4_4) {
                    System.err.println("Unknown host: " + string2);
                    return Boolean.FALSE;
                }
                catch (SocketException var5_6) {
                    System.err.println(var5_6.getMessage());
                    return Boolean.FALSE;
                }
lbl-1000:
                // 1 sources

                {
                    var2_2 = ((NetworkInterface)var3_3.nextElement()).getInetAddresses();
                    while (var2_2.hasMoreElements()) {
                        var4_5 = 0;
                        while (var4_5 < var1_1.length) {
                            if (var2_2.nextElement().equals(var1_1[var4_5])) {
                                return Boolean.TRUE;
                            }
                            ++var4_5;
                        }
                    }
lbl25:
                    // 2 sources

                    ** while (var3_3.hasMoreElements())
                }
lbl26:
                // 1 sources

                return Boolean.FALSE;
            }
        });
        isDisplayLocal = bl2;
        return isDisplayLocal;
    }

    public PrinterJob getPrinterJob() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new PSPrinterJob();
    }

    protected boolean platformReady() {
        return true;
    }

    protected String getFontPropertyFD(String string) {
        return string;
    }

    protected String getFileNameFromPlatformName(String string) {
        String string2 = null;
        String string3 = this.specificFontIDForName(string);
        if (this.fontNameMap == null) {
            this.fontNameMap = new Hashtable();
        }
        if (this.fontNameMap != null && string3 != null && (string2 = (String)this.fontNameMap.get(string3)) == null) {
            string3 = this.switchFontIDForName(string);
            string2 = (String)this.fontNameMap.get(string3);
        }
        return string2;
    }

    protected String parseFamilyNameProperty(String string) {
        String string2 = "default";
        String string3 = this.specificFontIDForName(string);
        if (this.fontNameMap != null && string3 != null) {
            String string4;
            String string5 = (String)this.fontNameMap.get(string3);
            if (string5 == null) {
                string3 = this.switchFontIDForName(string);
                string5 = (String)this.fontNameMap.get(string3);
            }
            if (string5 != null && (string4 = NativeFontWrapper.getFullNameByFileName(string5)) != null) {
                string2 = string4;
            }
        }
        return string2;
    }

    private String switchFontIDForName(String string) {
        String string2 = this.getFontField(string, 3);
        String string3 = this.getFontField(string, 4);
        String string4 = this.getFontField(string, 5);
        String string5 = this.getFontField(string, 6);
        String string6 = this.getFontField(string, 14);
        String string7 = this.getFontField(string, 15);
        if (string4.equals("i")) {
            string4 = "o";
        } else if (string4.equals("o")) {
            string4 = "i";
        }
        if (string2.equals("itc zapfdingbats") && string6.equals("sun") && string7.equals("fontspecific")) {
            string6 = "adobe";
        }
        String string8 = string2 + "-" + string3 + "-" + string4 + "-" + string5 + "-" + string6 + "-" + string7;
        return string8.toLowerCase(Locale.ENGLISH);
    }

    private String specificFontIDForName(String string) {
        String string2 = this.getFontField(string, 3);
        String string3 = this.getFontField(string, 4);
        String string4 = this.getFontField(string, 5);
        String string5 = this.getFontField(string, 6);
        String string6 = this.getFontField(string, 14);
        String string7 = this.getFontField(string, 15);
        String string8 = string2 + "-" + string3 + "-" + string4 + "-" + string5 + "-" + string6 + "-" + string7;
        return string8.toLowerCase(Locale.ENGLISH);
    }

    private String getFontField(String string, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (--n2 > 0 && n3 >= 0) {
            n3 = string.indexOf("-", n3) + 1;
        }
        if (n3 == -1) {
            return "";
        }
        n4 = string.indexOf("-", n3);
        if (n4 == -1) {
            return string.substring(n3);
        }
        return string.substring(n3, n4);
    }

    protected void registerFontPath(String string) {
        final File file = new File(string + File.separator + "fonts.dir");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    X11GraphicsEnvironment.this.parseFontDir(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    private native String[] getNativeFonts();

    protected Vector getNativeNames(String string) {
        Vector vector;
        if (this.xlfdMap == null || (vector = (Vector)this.xlfdMap.get(string)) == null) {
            Vector vector2 = new Vector();
            return vector2;
        }
        return vector;
    }

    protected void registerNative(String string) {
        Vector vector = new Vector(1, 1);
        vector.addElement(string);
        this.registeredFonts.put(string, string);
        NativeFontWrapper.registerFonts(vector, vector.size(), vector, 5, false);
    }

    private void initNativeFonts() {
        if (this.nativeFonts != null || GraphicsEnvironment.isHeadless()) {
            return;
        }
        String[] stringArray = this.getNativeFonts();
        if (stringArray != null) {
            this.nativeFonts = new Vector();
            if (this.fontNameMap == null) {
                this.fontNameMap = new Hashtable();
            }
            if (this.xlfdMap == null) {
                this.xlfdMap = new Hashtable();
            }
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string = this.specificFontIDForName(stringArray[n2]);
                String string2 = (String)this.fontNameMap.get(string);
                if (string2 == null) {
                    this.nativeFonts.addElement(stringArray[n2]);
                    this.fontNameMap.put(string, stringArray[n2]);
                    Vector vector = new Vector();
                    vector.add(stringArray[n2]);
                    this.xlfdMap.put(stringArray[n2], vector);
                }
                ++n2;
            }
        }
    }

    protected void addToFontPath(String string) {
        NativeFontWrapper.setNativeFontPath(string);
    }

    protected void addPlatformNameForFontProperties(String string) {
        String string2;
        String string3;
        if (this.fontPropDirs == null) {
            this.fontPropDirs = new HashSet();
        }
        if ((string3 = (String)this.xFontDirsMap.get(string2 = this.specificFontIDForName(string))) != null && !this.fontPropDirs.contains(string3)) {
            this.fontPropDirs.add(string3);
        }
    }

    protected void registerFontPropertiesFonts(TreeMap treeMap) {
        String[] stringArray;
        Object[] objectArray = treeMap.keySet().toArray();
        int n2 = 0;
        while (n2 < objectArray.length) {
            stringArray = (String[])objectArray[n2];
            HashSet hashSet = (HashSet)treeMap.get(stringArray);
            Vector vector = this.getNativeNames((String)stringArray);
            String[] stringArray2 = (String[])hashSet.toArray(new String[0]);
            Vector vector2 = new Vector();
            int n3 = 0;
            while (n3 < stringArray2.length) {
                vector2.add(this.specificFontIDForName(stringArray2[n3]));
                ++n3;
            }
            Vector vector3 = new Vector(hashSet);
            int n4 = 0;
            while (n4 < vector.size()) {
                String string = (String)vector.elementAt(n4);
                String string2 = this.specificFontIDForName(string);
                if (!vector2.contains(string2)) {
                    vector3.add(string);
                }
                ++n4;
            }
            this.registerFontFile((String)stringArray, vector3);
            ++n2;
        }
        stringArray = (String[])this.fontPropDirs.toArray(new String[0]);
        int n5 = 0;
        while (n5 < stringArray.length) {
            if (SunGraphicsEnvironment.debugMapping) {
                System.out.println("Add " + stringArray[n5] + " to X11 fontpath");
            }
            this.addToFontPath(stringArray[n5]);
            ++n5;
        }
        this.fontPropDirs = null;
        this.xFontDirsMap = null;
    }

    protected void registerFontFile(String string, Vector vector) {
        int n2;
        if (this.registeredFonts.containsKey(string)) {
            return;
        }
        if (new SunGraphicsEnvironment.TTFilter().accept(null, string)) {
            n2 = 0;
        } else if (new SunGraphicsEnvironment.T1Filter().accept(null, string)) {
            n2 = 1;
        } else if (new SunGraphicsEnvironment.T2KFilter().accept(null, string)) {
            n2 = 2;
        } else {
            this.registerNative(string);
            return;
        }
        File file = new File(string);
        if (file.canRead()) {
            Vector vector2 = new Vector(1, 1);
            Vector vector3 = new Vector(1, 1);
            vector3.addElement(vector);
            String string2 = null;
            try {
                string2 = file.getCanonicalPath();
                file = new File(string2);
            }
            catch (IOException iOException) {
                string2 = file.getAbsolutePath();
            }
            vector2.addElement(string2);
            this.registeredFonts.put(string, string);
            NativeFontWrapper.registerFonts(vector2, vector2.size(), vector3, n2, false);
        }
    }

    protected boolean registerNativeFonts() {
        if (!registerNativeFonts) {
            return false;
        }
        if (this.nativeFonts != null) {
            Vector vector = new Vector(20, 10);
            int n2 = 0;
            while (n2 < this.nativeFonts.size()) {
                String string = (String)this.nativeFonts.elementAt(n2);
                if (!this.registeredFonts.containsKey(string)) {
                    vector.addElement(string);
                    this.registeredFonts.put(string, string);
                }
                ++n2;
            }
            NativeFontWrapper.registerFonts(vector, vector.size(), vector, 5, false);
            return true;
        }
        return false;
    }

    protected void registerFontPaths(String string) {
        boolean bl2 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.registerFontPath(string2);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println(noSuchElementException);
        }
        if (this.loadNativeFonts) {
            this.initNativeFonts();
        }
    }

    private void parseFontDir(File file) throws FileNotFoundException, IOException {
        String string = file.getParent();
        if (SunGraphicsEnvironment.debugMapping) {
            System.out.println("ParseFontDir " + string);
        }
        if (file.canRead()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 8192);
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedInputStream);
            streamTokenizer.eolIsSignificant(true);
            int n2 = streamTokenizer.nextToken();
            if (n2 == -2) {
                int n3 = (int)streamTokenizer.nval;
                n2 = streamTokenizer.nextToken();
                if (n2 == 10) {
                    if (this.fontNameMap == null) {
                        this.fontNameMap = new Hashtable();
                    }
                    if (this.xlfdMap == null) {
                        this.xlfdMap = new Hashtable();
                    }
                    if (this.xFontDirsMap == null) {
                        this.xFontDirsMap = new Hashtable();
                    }
                    streamTokenizer.resetSyntax();
                    streamTokenizer.wordChars(32, 127);
                    streamTokenizer.wordChars(160, 255);
                    streamTokenizer.whitespaceChars(0, 31);
                    int n4 = 0;
                    while (n4 < n3) {
                        Serializable serializable;
                        int n5;
                        n2 = streamTokenizer.nextToken();
                        if (n2 == -1 || n2 != -3 || (n5 = streamTokenizer.sval.indexOf(" ")) <= 0) break;
                        String string2 = streamTokenizer.sval.substring(0, n5);
                        String string3 = streamTokenizer.sval.substring(n5 + 1);
                        if (SunGraphicsEnvironment.debugMapping) {
                            System.out.println("file=" + string2 + " xlfd=" + string3);
                        }
                        String string4 = this.specificFontIDForName(string3);
                        String string5 = (String)this.fontNameMap.get(string4);
                        String string6 = null;
                        try {
                            serializable = new File(string, string2);
                            File file2 = ((File)serializable).getParentFile();
                            if (file2 != null) {
                                this.xFontDirsMap.put(string4, file2.getAbsolutePath());
                            }
                            string6 = ((File)serializable).getCanonicalPath();
                        }
                        catch (IOException iOException) {
                            string6 = string + File.separator + string2;
                        }
                        serializable = (Vector)this.xlfdMap.get(string6);
                        if (!(serializable != null && ((Vector)serializable).contains(string3) || string5 != null)) {
                            if (SunGraphicsEnvironment.debugMapping) {
                                System.out.println("Map fontID:" + string4 + "to file:" + string6);
                            }
                            this.fontNameMap.put(string4, string6);
                            if (serializable == null) {
                                serializable = new Vector();
                                this.xlfdMap.put(string6, serializable);
                            }
                            ((Vector)serializable).add(string3);
                        }
                        if ((n2 = streamTokenizer.nextToken()) != 10) break;
                        ++n4;
                    }
                }
            }
        }
    }

    public native boolean validPropertiesFile(String var1, String var2);

    protected void initializeProps() {
        this.fprops = new MFontProperties();
    }

    private static native boolean pRunningXinerama();

    private static native Point getXineramaCenterPoint();

    public Point getCenterPoint() {
        Point point;
        if (this.runningXinerama() && (point = X11GraphicsEnvironment.getXineramaCenterPoint()) != null) {
            return point;
        }
        return super.getCenterPoint();
    }

    public Rectangle getMaximumWindowBounds() {
        if (this.runningXinerama()) {
            return this.getXineramaWindowBounds();
        }
        return super.getMaximumWindowBounds();
    }

    private synchronized boolean runningXinerama() {
        if (xinerState == null) {
            xinerState = new Boolean(X11GraphicsEnvironment.pRunningXinerama());
        }
        return xinerState;
    }

    protected Rectangle getXineramaWindowBounds() {
        Point point = this.getCenterPoint();
        GraphicsDevice[] graphicsDeviceArray = this.getScreenDevices();
        Rectangle rectangle = null;
        Rectangle rectangle2 = SunGraphicsEnvironment.getUsableBounds(graphicsDeviceArray[0]);
        int n2 = 0;
        while (n2 < graphicsDeviceArray.length) {
            Rectangle rectangle3 = SunGraphicsEnvironment.getUsableBounds(graphicsDeviceArray[n2]);
            if (rectangle == null && rectangle3.width / 2 + rectangle3.x > point.x - 1 && rectangle3.height / 2 + rectangle3.y > point.y - 1 && rectangle3.width / 2 + rectangle3.x < point.x + 1 && rectangle3.height / 2 + rectangle3.y < point.y + 1) {
                rectangle = rectangle3;
            }
            rectangle2 = rectangle2.union(rectangle3);
            ++n2;
        }
        if (rectangle2.width / 2 + rectangle2.x > point.x - 1 && rectangle2.height / 2 + rectangle2.y > point.y - 1 && rectangle2.width / 2 + rectangle2.x < point.x + 1 && rectangle2.height / 2 + rectangle2.y < point.y + 1) {
            return rectangle2;
        }
        if (rectangle != null) {
            return rectangle;
        }
        return rectangle2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
        if (!GraphicsEnvironment.isHeadless()) {
            X11GraphicsEnvironment.initDisplay();
            String string = (String)AccessController.doPrivileged(new GetPropertyAction("sun.java2d.registerNativeFonts"));
            if (string != null) {
                registerNativeFonts = true;
            }
        }
        display = null;
        isDisplayLocal = false;
    }
}

