/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.AccessController;
import java.sql.DataTruncation;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcSQLWarning;
import sun.jdbc.odbc.OdbcDef;
import sun.security.action.LoadLibraryAction;

class JdbcOdbc
extends JdbcOdbcObject {
    public static final int MajorVersion = 2;
    public static final int MinorVersion = 1;
    public String charSet;
    public String odbcDriverName;

    JdbcOdbc(String string) throws SQLException {
        try {
            if (JdbcOdbcObject.isTracing()) {
                Date date = new Date();
                String string2 = "";
                int n2 = 1;
                if (n2 < 1000) {
                    string2 = string2 + "0";
                }
                if (n2 < 100) {
                    string2 = string2 + "0";
                }
                if (n2 < 10) {
                    string2 = string2 + "0";
                }
                string2 = string2 + "" + n2;
                JdbcOdbcObject.trace("JDBC to ODBC Bridge 2." + string2);
                JdbcOdbcObject.trace("Current Date/Time: " + date.toString());
                JdbcOdbcObject.trace("Loading " + string + "JdbcOdbc library");
            }
            AccessController.doPrivileged(new LoadLibraryAction(string + "JdbcOdbc"));
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("Unable to load " + string + "JdbcOdbc library");
            }
            throw new SQLException("Unable to load " + string + "JdbcOdbc library");
        }
    }

    public long SQLAllocConnect(long l2) throws SQLException {
        long l3 = 0L;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Allocating Connection handle (SQLAllocConnect)");
        }
        byte[] byArray = new byte[1];
        l3 = this.allocConnect(l2, byArray);
        if (byArray[0] != 0) {
            this.throwGenericSQLException();
        } else if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("hDbc=" + l3);
        }
        return l3;
    }

    public long SQLAllocEnv() throws SQLException {
        long l2 = 0L;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Allocating Environment handle (SQLAllocEnv)");
        }
        byte[] byArray = new byte[1];
        l2 = this.allocEnv(byArray);
        if (byArray[0] != 0) {
            this.throwGenericSQLException();
        } else if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("hEnv=" + l2);
        }
        return l2;
    }

    public long SQLAllocStmt(long l2) throws SQLException {
        long l3 = 0L;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Allocating Statement Handle (SQLAllocStmt), hDbc=" + l2);
        }
        byte[] byArray = new byte[1];
        l3 = this.allocStmt(l2, byArray);
        if (byArray[0] != 0) {
            this.throwGenericSQLException();
        } else if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("hStmt=" + l3);
        }
        return l3;
    }

    public void SQLBindColAtExec(long l2, int n2, int n3, int[] nArray, byte[] byArray, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding Column DATA_AT_EXEC (SQLBindCol), hStmt=" + l2 + ", icol=" + n2 + ", SQLtype=" + n3);
        }
        byte[] byArray2 = new byte[1];
        this.bindColAtExec(l2, n2, n3, nArray, byArray, lArray, byArray2);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l2);
        }
    }

    public void SQLBindColBinary(long l2, int n2, Object[] objectArray, int[] nArray, int n3, byte[] byArray, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Bind column binary (SQLBindColBinary), hStmt=" + l2 + ", icol=" + n2);
        }
        byte[] byArray2 = new byte[1];
        this.bindColBinary(l2, n2, objectArray, nArray, n3, byArray, lArray, byArray2);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l2);
        }
    }

    public void SQLBindColDate(long l2, int n2, Object[] objectArray, int[] nArray, byte[] byArray, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Bound Column Date (SQLBindColDate), hStmt=" + l2 + ", icol=" + n2);
        }
        java.sql.Date date = null;
        int n3 = objectArray.length;
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n3];
        byte[] byArray2 = new byte[1];
        Calendar calendar = Calendar.getInstance();
        int n4 = 0;
        while (n4 < n3) {
            if (objectArray[n4] != null) {
                date = (java.sql.Date)objectArray[n4];
                calendar.setTime(date);
                nArray2[n4] = calendar.get(1);
                nArray3[n4] = calendar.get(2) + 1;
                nArray4[n4] = calendar.get(5);
            }
            ++n4;
        }
        this.bindColDate(l2, n2, nArray2, nArray3, nArray4, nArray, byArray, lArray, byArray2);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l2);
        }
    }

    public void SQLBindColDefault(long l2, int n2, byte[] byArray, byte[] byArray2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding default column (SQLBindCol), hStmt=" + l2 + ", ipar=" + n2 + ", \t\t\tlength=" + byArray.length);
        }
        byte[] byArray3 = new byte[1];
        this.bindColDefault(l2, n2, byArray, byArray2, byArray3);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l2);
        }
    }

    public void SQLBindColDouble(long l2, int n2, Object[] objectArray, int[] nArray, byte[] byArray, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Bind column Double (SQLBindColDouble), hStmt=" + l2 + ", icol=" + n2);
        }
        double[] dArray = new double[objectArray.length];
        int n3 = 0;
        while (n3 < objectArray.length) {
            if (objectArray[n3] != null) {
                dArray[n3] = (Double)objectArray[n3];
            }
            ++n3;
        }
        byte[] byArray2 = new byte[1];
        this.bindColDouble(l2, n2, dArray, nArray, byArray, lArray, byArray2);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l2);
        }
    }

    public void SQLBindColFloat(long l2, int n2, Object[] objectArray, int[] nArray, byte[] byArray, long[] lArray) throws SQLException {
        float[] fArray = new float[objectArray.length];
        int n3 = 0;
        while (n3 < objectArray.length) {
            if (objectArray[n3] != null) {
                fArray[n3] = ((Float)objectArray[n3]).floatValue();
            }
            ++n3;
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding default column (SQLBindCol Float), hStmt=" + l2 + ", icol=" + n2);
        }
        byte[] byArray2 = new byte[1];
        this.bindColFloat(l2, n2, fArray, nArray, byArray, lArray, byArray2);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l2);
        }
    }

    public void SQLBindColInteger(long l2, int n2, Object[] objectArray, int[] nArray, byte[] byArray, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding default column (SQLBindCol Integer), hStmt=" + l2 + ", icol=" + n2);
        }
        int[] nArray2 = new int[objectArray.length];
        int n3 = 0;
        while (n3 < objectArray.length) {
            if (objectArray[n3] != null) {
                nArray2[n3] = (Integer)objectArray[n3];
            }
            ++n3;
        }
        byte[] byArray2 = new byte[1];
        this.bindColInteger(l2, n2, nArray2, nArray, byArray, lArray, byArray2);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l2);
        }
    }

    public void SQLBindColString(long l2, int n2, int n3, Object[] objectArray, int n4, int[] nArray, byte[] byArray, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding string/decimal Column (SQLBindColString), hStmt=" + l2 + ", icol=" + n2 + ", SQLtype=" + n3 + ", rgbValue=" + objectArray);
        }
        byte[] byArray2 = new byte[1];
        this.bindColString(l2, n2, OdbcDef.jdbcTypeToOdbc(n3), objectArray, n4, nArray, byArray, lArray, byArray2);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l2);
        }
    }

    public void SQLBindColTime(long l2, int n2, Object[] objectArray, int[] nArray, byte[] byArray, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Bind column Time (SQLBindColTime), hStmt=" + l2 + ", icol=" + n2);
        }
        Time time = null;
        int n3 = objectArray.length;
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n3];
        byte[] byArray2 = new byte[1];
        Calendar calendar = Calendar.getInstance();
        int n4 = 0;
        while (n4 < n3) {
            if (objectArray[n4] != null) {
                time = (Time)objectArray[n4];
                calendar.setTime(time);
                nArray2[n4] = calendar.get(11);
                nArray3[n4] = calendar.get(12);
                nArray4[n4] = calendar.get(13);
            }
            ++n4;
        }
        this.bindColTime(l2, n2, nArray2, nArray3, nArray4, nArray, byArray, lArray, byArray2);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l2);
        }
    }

    public void SQLBindColTimestamp(long l2, int n2, Object[] objectArray, int[] nArray, byte[] byArray, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Bind Column Timestamp (SQLBindColTimestamp), hStmt=" + l2 + ", icol=" + n2);
        }
        Timestamp timestamp = null;
        int n3 = objectArray.length;
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n3];
        int[] nArray5 = new int[n3];
        int[] nArray6 = new int[n3];
        int[] nArray7 = new int[n3];
        int[] nArray8 = new int[n3];
        byte[] byArray2 = new byte[1];
        Calendar calendar = Calendar.getInstance();
        int n4 = 0;
        while (n4 < n3) {
            if (objectArray[n4] != null) {
                timestamp = (Timestamp)objectArray[n4];
                calendar.setTime(timestamp);
                nArray2[n4] = calendar.get(1);
                nArray3[n4] = calendar.get(2) + 1;
                nArray4[n4] = calendar.get(5);
                nArray5[n4] = calendar.get(11);
                nArray6[n4] = calendar.get(12);
                nArray7[n4] = calendar.get(13);
                nArray8[n4] = timestamp.getNanos();
            }
            ++n4;
        }
        this.bindColTimestamp(l2, n2, nArray2, nArray3, nArray4, nArray5, nArray6, nArray7, nArray8, nArray, byArray, lArray, byArray2);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInParameterAtExec(long l2, int n2, int n3, int n4, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding DATA_AT_EXEC parameter (SQLBindParameter), hStmt=" + l2 + ", ipar=" + n2 + ", SQLtype=" + n3 + ", len=" + n4);
        }
        byte[] byArray3 = new byte[1];
        this.bindInParameterAtExec(l2, n2, n3, n4, byArray, byArray2, byArray3, lArray);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInParameterBinary(long l2, int n2, int n3, byte[] byArray, byte[] byArray2, byte[] byArray3, long[] lArray) throws SQLException {
        int n4 = 0;
        n4 = byArray2.length < 8000 ? byArray2.length : 8000;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN binary parameter (SQLBindParameter), hStmt=" + l2 + ", ipar=" + n2 + ", SQLtype=" + n3);
            JdbcOdbcObject.dumpByte(byArray, byArray.length);
        }
        byte[] byArray4 = new byte[1];
        this.bindInParameterBinary(l2, n2, OdbcDef.jdbcTypeToOdbc(n3), byArray, n4, byArray2, byArray3, byArray4, lArray);
        if (byArray4[0] != 0) {
            this.standardError(byArray4[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInParameterDate(long l2, int n2, java.sql.Date date, byte[] byArray, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN parameter date (SQLBindParameter), hStmt=" + l2 + ", ipar=" + n2 + ", rgbValue=" + date.toString());
        }
        byte[] byArray2 = new byte[1];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.bindInParameterDate(l2, n2, calendar.get(1), calendar.get(2) + 1, calendar.get(5), byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInParameterCalendarDate(long l2, int n2, Calendar calendar, byte[] byArray, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN parameter date (SQLBindParameter), hStmt=" + l2 + ", ipar=" + n2 + ", rgbValue=" + calendar.toString());
        }
        byte[] byArray2 = new byte[1];
        this.bindInParameterDate(l2, n2, calendar.get(1), calendar.get(2) + 1, calendar.get(5), byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInParameterDouble(long l2, int n2, int n3, int n4, double d2, byte[] byArray, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN parameter double (SQLBindParameter), hStmt=" + l2 + ", ipar=" + n2 + ", SQLtype=" + n3 + ", scale=" + n4 + ", rgbValue=" + d2);
        }
        byte[] byArray2 = new byte[1];
        this.bindInParameterDouble(l2, n2, OdbcDef.jdbcTypeToOdbc(n3), n4, d2, byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInParameterFloat(long l2, int n2, int n3, int n4, float f2, byte[] byArray, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN parameter float (SQLBindParameter), hStmt=" + l2 + ", ipar=" + n2 + ", SQLtype=" + n3 + ", scale=" + n4 + ", rgbValue=" + f2);
        }
        byte[] byArray2 = new byte[1];
        this.bindInParameterFloat(l2, n2, OdbcDef.jdbcTypeToOdbc(n3), n4, f2, byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInParameterInteger(long l2, int n2, int n3, int n4, byte[] byArray, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN parameter integer (SQLBindParameter), hStmt=" + l2 + ", ipar=" + n2 + "SQLtype=" + n3 + ", rgbValue=" + n4);
        }
        byte[] byArray2 = new byte[1];
        this.bindInParameterInteger(l2, n2, OdbcDef.jdbcTypeToOdbc(n3), n4, byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInParameterNull(long l2, int n2, int n3, int n4, int n5, byte[] byArray, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN NULL parameter (SQLBindParameter), hStmt=" + l2 + ", ipar=" + n2 + ", SQLtype=" + n3);
        }
        byte[] byArray2 = new byte[1];
        this.bindInParameterNull(l2, n2, OdbcDef.jdbcTypeToOdbc(n3), n4, n5, byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInParameterString(long l2, int n2, int n3, int n4, int n5, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN string parameter (SQLBindParameter), hStmt=" + l2 + ", ipar=" + n2 + ", SQLtype=" + n3 + ", precision=" + n4 + ", scale=" + n5 + ", rgbValue=" + byArray);
        }
        byte[] byArray3 = new byte[1];
        this.bindInParameterString(l2, n2, OdbcDef.jdbcTypeToOdbc(n3), byArray, n4, n5, byArray2, byArray3, lArray);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInParameterTime(long l2, int n2, Time time, byte[] byArray, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN parameter time (SQLBindParameter), hStmt=" + l2 + ", ipar=" + n2 + ", rgbValue=" + time.toString());
        }
        byte[] byArray2 = new byte[1];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        this.bindInParameterTime(l2, n2, calendar.get(11), calendar.get(12), calendar.get(13), byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInParameterCalendarTime(long l2, int n2, Calendar calendar, byte[] byArray, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN parameter time (SQLBindParameter), hStmt=" + l2 + ", ipar=" + n2 + ", rgbValue=" + calendar.toString());
        }
        byte[] byArray2 = new byte[1];
        this.bindInParameterTime(l2, n2, calendar.get(11), calendar.get(12), calendar.get(13), byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInParameterTimestamp(long l2, int n2, Timestamp timestamp, byte[] byArray, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN parameter timestamp (SQLBindParameter), hStmt=" + l2 + ", ipar=" + n2 + ", rgbValue=" + timestamp.toString());
        }
        byte[] byArray2 = new byte[1];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        this.bindInParameterTimestamp(l2, n2, calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), timestamp.getNanos(), byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInParameterCalendarTimestamp(long l2, int n2, Calendar calendar, byte[] byArray, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN parameter timestamp (SQLBindParameter), hStmt=" + l2 + ", ipar=" + n2 + ", rgbValue=" + calendar.toString());
        }
        byte[] byArray2 = new byte[1];
        this.bindInParameterTimestamp(l2, n2, calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14), byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l2);
        }
    }

    public void SQLBindOutParameterString(long l2, int n2, int n3, int n4, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding OUT string parameter (SQLBindParameter), hStmt=" + l2 + ", ipar=" + n2 + ", SQLtype=" + n3 + ", prec=" + (byArray.length - 1) + ", scale=" + n4);
        }
        byte[] byArray3 = new byte[1];
        this.bindOutParameterString(l2, n2, n3, n4, byArray, byArray2, byArray3, lArray);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInOutParameterString(long l2, int n2, int n3, int n4, int n5, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding INOUT string parameter (SQLBindParameter), hStmt=" + l2 + ", ipar=" + n2 + ", SQLtype=" + n3 + ", precision=" + n4 + ", scale=" + n5 + ", rgbValue=" + byArray + ", lenBuf=" + byArray2);
        }
        byte[] byArray3 = new byte[1];
        this.bindInOutParameterString(l2, n2, OdbcDef.jdbcTypeToOdbc(n3), n4, n5, byArray, byArray2, byArray3, lArray);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInOutParameterBinary(long l2, int n2, int n3, int n4, int n5, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding INOUT binary parameter (SQLBindParameter), hStmt=" + l2 + ", ipar=" + n2 + ", SQLtype=" + n3 + ", precision=" + n4 + ", scale=" + n5 + ", rgbValue=" + byArray + ", lenBuf=" + byArray2);
        }
        byte[] byArray3 = new byte[1];
        this.bindInOutParameterBinary(l2, n2, OdbcDef.jdbcTypeToOdbc(n3), n4, n5, byArray, byArray2, byArray3, lArray);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInOutParameterTimeStamp(long l2, int n2, int n3, int n4, int n5, byte[] byArray, byte[] byArray2, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding INOUT string parameter (SQLBindParameter), hStmt=" + l2 + ", ipar=" + n2 + ", SQLtype=" + n3 + ", precision=" + n4 + ", scale=" + n5 + ", rgbValue=" + byArray + ", lenBuf=" + byArray2);
        }
        byte[] byArray3 = new byte[1];
        this.bindInOutParameterTimeStamp(l2, n2, OdbcDef.jdbcTypeToOdbc(n3), n4, n5, byArray, byArray2, byArray3, lArray);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInOutParameter(long l2, int n2, int n3, int n4, int n5, double d2, byte[] byArray, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding INOUT parameter (SQLBindParameter), hStmt=" + l2 + ", ipar=" + n2 + ", SQLtype=" + n3 + ", precision=" + n4 + ", scale=" + n5 + ", rgbValue=" + d2);
        }
        byte[] byArray2 = new byte[1];
        this.bindInOutParameter(l2, n2, OdbcDef.jdbcTypeToOdbc(n3), n4, n5, d2, byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInOutParameterNull(long l2, int n2, int n3, int n4, int n5, byte[] byArray, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN NULL parameter (SQLBindParameter), hStmt=" + l2 + ", ipar=" + n2 + ", SQLtype=" + n3);
        }
        byte[] byArray2 = new byte[1];
        this.bindInOutParameterNull(l2, n2, OdbcDef.jdbcTypeToOdbc(n3), n4, n5, byArray, byArray2, lArray);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInParameterStringArray(long l2, int n2, int n3, Object[] objectArray, int n4, int n5, int[] nArray) throws SQLException {
        Object object;
        int n6 = objectArray.length;
        Object[] objectArray2 = new Object[n6];
        if (n3 == 2 || n3 == 3) {
            int n7 = 0;
            while (n7 < n6) {
                if (objectArray[n7] != null) {
                    String string;
                    int n8;
                    object = (BigDecimal)objectArray[n7];
                    String string2 = ((BigDecimal)object).toString();
                    int n9 = string2.indexOf(46);
                    if (n9 != -1 && (n8 = (string = string2.substring(n9 + 1, string2.length())).length()) < n5) {
                        int n10 = 0;
                        while (n10 < n5 - n8) {
                            string2 = string2 + "0";
                            ++n10;
                        }
                    }
                    objectArray2[n7] = string2;
                }
                ++n7;
            }
        } else {
            objectArray2 = objectArray;
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN parameter timestamp (SQLBindParameter), hStmt=" + l2 + ", ipar=" + n2);
        }
        byte[] byArray = new byte[1];
        object = new byte[(n4 + 1) * n6];
        this.bindInParameterStringArray(l2, n2, OdbcDef.jdbcTypeToOdbc(n3), objectArray2, (byte[])object, n4, n5, nArray, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInParameterIntegerArray(long l2, int n2, int n3, Object[] objectArray, int[] nArray) throws SQLException {
        int[] nArray2 = new int[objectArray.length];
        int n4 = 0;
        while (n4 < objectArray.length) {
            if (objectArray[n4] != null) {
                nArray2[n4] = (Integer)objectArray[n4];
            }
            ++n4;
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN parameter Integer Array (SQLBindParameter), hStmt=" + l2 + ", ipar=" + n2);
        }
        byte[] byArray = new byte[1];
        this.bindInParameterIntegerArray(l2, n2, OdbcDef.jdbcTypeToOdbc(n3), nArray2, nArray, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInParameterFloatArray(long l2, int n2, int n3, Object[] objectArray, int[] nArray) throws SQLException {
        float[] fArray = new float[objectArray.length];
        int n4 = 0;
        while (n4 < objectArray.length) {
            if (objectArray[n4] != null) {
                fArray[n4] = ((Float)objectArray[n4]).floatValue();
            }
            ++n4;
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN parameter timestamp (SQLBindParameter), hStmt=" + l2 + ", ipar=" + n2);
        }
        byte[] byArray = new byte[1];
        this.bindInParameterFloatArray(l2, n2, OdbcDef.jdbcTypeToOdbc(n3), 0, fArray, nArray, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInParameterDoubleArray(long l2, int n2, int n3, Object[] objectArray, int[] nArray) throws SQLException {
        double[] dArray = new double[objectArray.length];
        int n4 = 0;
        while (n4 < objectArray.length) {
            if (objectArray[n4] != null) {
                dArray[n4] = (Double)objectArray[n4];
            }
            ++n4;
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN parameter timestamp (SQLBindParameter), hStmt=" + l2 + ", ipar=" + n2);
        }
        byte[] byArray = new byte[1];
        this.bindInParameterDoubleArray(l2, n2, OdbcDef.jdbcTypeToOdbc(n3), 0, dArray, nArray, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInParameterDateArray(long l2, int n2, Object[] objectArray, int[] nArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN parameter timestamp (SQLBindParameterDateArray), hStmt=" + l2 + ", ipar=" + n2);
        }
        int n3 = objectArray.length;
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n3];
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[11 * n3];
        if ((java.sql.Date)objectArray[0] != null) {
            Calendar calendar = Calendar.getInstance();
            java.sql.Date date = null;
            int n4 = 0;
            while (n4 < n3) {
                if (objectArray[n4] != null) {
                    date = (java.sql.Date)objectArray[n4];
                    calendar.setTime(date);
                    nArray2[n4] = calendar.get(1);
                    nArray3[n4] = calendar.get(2) + 1;
                    nArray4[n4] = calendar.get(5);
                }
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n3) {
                if (objectArray[n5] != null) {
                    Calendar calendar = (Calendar)objectArray[n5];
                    nArray2[n5] = calendar.get(1);
                    nArray3[n5] = calendar.get(2) + 1;
                    nArray4[n5] = calendar.get(5);
                }
                ++n5;
            }
        }
        this.bindInParameterDateArray(l2, n2, nArray2, nArray3, nArray4, byArray2, byArray, nArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInParameterTimeArray(long l2, int n2, Object[] objectArray, int[] nArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN parameter timestamp (SQLBindParameterTimeArray), hStmt=" + l2 + ", ipar=" + n2);
        }
        int n3 = objectArray.length;
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n3];
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[9 * n3];
        if ((Time)objectArray[0] != null) {
            Calendar calendar = Calendar.getInstance();
            Time time = null;
            int n4 = 0;
            while (n4 < n3) {
                if (objectArray[n4] != null) {
                    time = (Time)objectArray[n4];
                    calendar.setTime(time);
                    nArray2[n4] = calendar.get(11);
                    nArray3[n4] = calendar.get(12);
                    nArray4[n4] = calendar.get(13);
                }
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n3) {
                if (objectArray[n5] != null) {
                    Calendar calendar = (Calendar)objectArray[n5];
                    nArray2[n5] = calendar.get(11);
                    nArray3[n5] = calendar.get(12);
                    nArray4[n5] = calendar.get(13);
                }
                ++n5;
            }
        }
        this.bindInParameterTimeArray(l2, n2, nArray2, nArray3, nArray4, byArray2, byArray, nArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInParameterTimestampArray(long l2, int n2, Object[] objectArray, int[] nArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN parameter timestamp (SQLBindParameterTimestampArray), hStmt=" + l2 + ", ipar=" + n2);
        }
        int n3 = objectArray.length;
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[n3];
        int[] nArray5 = new int[n3];
        int[] nArray6 = new int[n3];
        int[] nArray7 = new int[n3];
        int[] nArray8 = new int[n3];
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[30 * n3];
        if ((Timestamp)objectArray[0] != null) {
            Calendar calendar = Calendar.getInstance();
            Timestamp timestamp = null;
            int n4 = 0;
            while (n4 < n3) {
                if (objectArray[n4] != null) {
                    timestamp = (Timestamp)objectArray[n4];
                    calendar.setTime(timestamp);
                    nArray2[n4] = calendar.get(1);
                    nArray3[n4] = calendar.get(2) + 1;
                    nArray4[n4] = calendar.get(5);
                    nArray5[n4] = calendar.get(11);
                    nArray6[n4] = calendar.get(12);
                    nArray7[n4] = calendar.get(13);
                    nArray8[n4] = timestamp.getNanos();
                }
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n3) {
                if (objectArray[n5] != null) {
                    Calendar calendar = (Calendar)objectArray[n5];
                    nArray2[n5] = calendar.get(1);
                    nArray3[n5] = calendar.get(2) + 1;
                    nArray4[n5] = calendar.get(5);
                    nArray5[n5] = calendar.get(11);
                    nArray6[n5] = calendar.get(12);
                    nArray7[n5] = calendar.get(13);
                    nArray8[n5] = calendar.get(14);
                }
                ++n5;
            }
        }
        this.bindInParameterTimestampArray(l2, n2, nArray2, nArray3, nArray4, nArray5, nArray6, nArray7, nArray8, byArray2, byArray, nArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInParameterBinaryArray(long l2, int n2, int n3, Object[] objectArray, int n4, int[] nArray) throws SQLException {
        int n5 = objectArray.length;
        int n6 = 8000;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding IN binary parameter (SQLBindParameterBinaryArray), hStmt=" + l2 + ", ipar=" + n2 + ", SQLtype=" + n3);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[n4 * n5];
        this.bindInParameterBinaryArray(l2, n2, OdbcDef.jdbcTypeToOdbc(n3), objectArray, n4, byArray2, nArray, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public void SQLBindInParameterAtExecArray(long l2, int n2, int n3, int n4, int[] nArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Binding DATA_AT_EXEC Array parameter (SQLBindParameter), hStmt=" + l2 + ", ipar=" + n2 + ", SQLtype=" + n3 + ", len=" + n4);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[nArray.length];
        this.bindInParameterAtExecArray(l2, n2, n3, n4, byArray2, nArray, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public String SQLBrowseConnect(long l2, String string) throws SQLException, SQLWarning {
        String string2 = null;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Connecting (SQLBrowseConnect), hDbc=" + l2 + ", szConnStrIn=" + string);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[2000];
        byte[] byArray3 = null;
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        try {
            if (string != null) {
                byArray3 = this.CharsToBytes(this.charSet, cArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.browseConnect(l2, byArray3, byArray2, byArray);
        if (byArray[0] == 99) {
            string2 = new String(byArray2);
            string2 = string2.trim();
            byArray[0] = 0;
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, l2, 0L);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Attributes=" + string2);
        }
        return string2;
    }

    public void SQLCancel(long l2) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Cancelling (SQLCancel), hStmt=" + l2);
        }
        byte[] byArray = new byte[1];
        this.cancel(l2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public int SQLColAttributes(long l2, int n2, int n3) throws SQLException, JdbcOdbcSQLWarning {
        int n4 = 0;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Column attributes (SQLColAttributes), hStmt=" + l2 + ", icol=" + n2 + ", type=" + n3);
        }
        byte[] byArray = new byte[1];
        n4 = this.colAttributes(l2, n2, n3, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l2);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("value (int)=" + n4);
                }
                jdbcOdbcSQLWarning.value = BigDecimal.valueOf(n4);
                throw jdbcOdbcSQLWarning;
            }
        } else if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("value (int)=" + n4);
        }
        return n4;
    }

    public String SQLColAttributesString(long l2, int n2, int n3) throws SQLException, JdbcOdbcSQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Column attributes (SQLColAttributes), hStmt=" + l2 + ", icol=" + n2 + ", type=" + n3);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[300];
        this.colAttributesString(l2, n2, n3, byArray2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l2);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                String string = new String();
                try {
                    string = this.BytesToChars(this.charSet, byArray2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.out.println(unsupportedEncodingException);
                }
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("value (String)=" + string.trim());
                }
                jdbcOdbcSQLWarning.value = string.trim();
                throw jdbcOdbcSQLWarning;
            }
        }
        String string = new String();
        try {
            string = this.BytesToChars(this.charSet, byArray2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(unsupportedEncodingException);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("value (String)=" + string.trim());
        }
        return string.trim();
    }

    public void SQLColumns(long l2, String string, String string2, String string3, String string4) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("(SQLColumns), hStmt=" + l2 + ", catalog=" + string + ", schema=" + string2 + ", table=" + string3 + ", column=" + string4);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        char[] cArray4 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        if (string4 != null) {
            cArray4 = string4.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray3 = this.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray4 = this.CharsToBytes(this.charSet, cArray3);
            }
            if (string4 != null) {
                byArray5 = this.CharsToBytes(this.charSet, cArray4);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.columns(l2, byArray2, string == null, byArray3, string2 == null, byArray4, string3 == null, byArray5, string4 == null, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public void SQLColumnPrivileges(long l2, String string, String string2, String string3, String string4) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("(SQLColumnPrivileges), hStmt=" + l2 + ", catalog=" + string + ", schema=" + string2 + ", table=" + string3 + ", column=" + string4);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        char[] cArray4 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        if (string4 != null) {
            cArray4 = string4.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray3 = this.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray4 = this.CharsToBytes(this.charSet, cArray3);
            }
            if (string4 != null) {
                byArray5 = this.CharsToBytes(this.charSet, cArray4);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.columnPrivileges(l2, byArray2, string == null, byArray3, string2 == null, byArray4, string3 == null, byArray5, string4 == null, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public boolean SQLDescribeParamNullable(long l2, int n2) throws SQLException, JdbcOdbcSQLWarning {
        boolean bl2 = false;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Parameter nullable (SQLDescribeParam), hStmt=" + l2 + ", ipar=" + n2);
        }
        byte[] byArray = new byte[1];
        int n3 = this.describeParam(l2, n2, 4, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
        if (n3 == 1) {
            bl2 = true;
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("nullable=" + bl2);
        }
        return bl2;
    }

    public int SQLDescribeParamPrecision(long l2, int n2) throws SQLException, JdbcOdbcSQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Parameter precision (SQLDescribeParam), hStmt=" + l2 + ", ipar=" + n2);
        }
        byte[] byArray = new byte[1];
        int n3 = this.describeParam(l2, n2, 2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("precision=" + n3);
        }
        return n3;
    }

    public int SQLDescribeParamScale(long l2, int n2) throws SQLException, JdbcOdbcSQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Parameter scale (SQLDescribeParam), hStmt=" + l2 + ", ipar=" + n2);
        }
        byte[] byArray = new byte[1];
        int n3 = this.describeParam(l2, n2, 3, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("scale=" + n3);
        }
        return n3;
    }

    public int SQLDescribeParamType(long l2, int n2) throws SQLException, JdbcOdbcSQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Parameter type (SQLDescribeParam), hStmt=" + l2 + ", ipar=" + n2);
        }
        byte[] byArray = new byte[1];
        int n3 = this.describeParam(l2, n2, 1, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("type=" + n3);
        }
        return n3;
    }

    public void SQLDisconnect(long l2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Disconnecting (SQLDisconnect), hDbc=" + l2);
        }
        byte[] byArray = new byte[1];
        this.disconnect(l2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, l2, 0L);
        }
    }

    public void SQLDriverConnect(long l2, String string) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Connecting (SQLDriverConnect), hDbc=" + l2 + ", szConnStrIn=" + string);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.driverConnect(l2, byArray2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, l2, 0L);
        }
    }

    public void SQLExecDirect(long l2, String string) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Executing (SQLExecDirect), hStmt=" + l2 + ", szSqlStr=" + string);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.execDirect(l2, byArray2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public boolean SQLExecute(long l2) throws SQLException, SQLWarning {
        boolean bl2 = false;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Executing (SQLExecute), hStmt=" + l2);
        }
        byte[] byArray = new byte[1];
        this.execute(l2, byArray);
        if (byArray[0] == 99) {
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("SQL_NEED_DATA returned");
            }
            bl2 = true;
            byArray[0] = 0;
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
        return bl2;
    }

    public boolean SQLFetch(long l2) throws SQLException, SQLWarning {
        boolean bl2 = true;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Fetching (SQLFetch), hStmt=" + l2);
        }
        byte[] byArray = new byte[1];
        this.fetch(l2, byArray);
        if (byArray[0] == 100) {
            bl2 = false;
            byArray[0] = 0;
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("End of result set (SQL_NO_DATA)");
            }
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
        return bl2;
    }

    public boolean SQLFetchScroll(long l2, short s2, int n2) throws SQLException, SQLWarning {
        boolean bl2 = true;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Fetching (SQLFetchScroll), hStmt=" + l2);
        }
        byte[] byArray = new byte[1];
        this.fetchScroll(l2, s2, n2, byArray);
        if (byArray[0] == 100) {
            bl2 = false;
            byArray[0] = 0;
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("End of result set (SQL_NO_DATA)");
            }
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
        return bl2;
    }

    public void SQLForeignKeys(long l2, String string, String string2, String string3, String string4, String string5, String string6) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("(SQLForeignKeys), hStmt=" + l2 + ", Pcatalog=" + string + ", Pschema=" + string2 + ", Ptable=" + string3 + ", Fcatalog=" + string4 + ", Fschema=" + string5 + ", Ftable=" + string6);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        byte[] byArray6 = null;
        byte[] byArray7 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        char[] cArray4 = null;
        char[] cArray5 = null;
        char[] cArray6 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        if (string4 != null) {
            cArray4 = string4.toCharArray();
        }
        if (string5 != null) {
            cArray5 = string5.toCharArray();
        }
        if (string6 != null) {
            cArray6 = string6.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray3 = this.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray4 = this.CharsToBytes(this.charSet, cArray3);
            }
            if (string4 != null) {
                byArray5 = this.CharsToBytes(this.charSet, cArray4);
            }
            if (string5 != null) {
                byArray6 = this.CharsToBytes(this.charSet, cArray5);
            }
            if (string6 != null) {
                byArray7 = this.CharsToBytes(this.charSet, cArray6);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.foreignKeys(l2, byArray2, string == null, byArray3, string2 == null, byArray4, string3 == null, byArray5, string4 == null, byArray6, string5 == null, byArray7, string6 == null, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public void SQLFreeConnect(long l2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Closing connection (SQLFreeConnect), hDbc=" + l2);
        }
        byte[] byArray = new byte[1];
        this.freeConnect(l2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, l2, 0L);
        }
    }

    public void SQLFreeEnv(long l2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Closing environment (SQLFreeEnv), hEnv=" + l2);
        }
        byte[] byArray = new byte[1];
        this.freeEnv(l2, byArray);
        if (byArray[0] != 0) {
            this.throwGenericSQLException();
        }
    }

    public void SQLFreeStmt(long l2, int n2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Free statement (SQLFreeStmt), hStmt=" + l2 + ", fOption=" + n2);
        }
        byte[] byArray = new byte[1];
        this.freeStmt(l2, n2, byArray);
        if (byArray[0] != 0) {
            this.throwGenericSQLException();
        }
    }

    public long SQLGetConnectOption(long l2, short s2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Connection Option (SQLGetConnectOption), hDbc=" + l2 + ", fOption=" + s2);
        }
        byte[] byArray = new byte[1];
        long l3 = this.getConnectOption(l2, s2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, l2, 0L);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("option value (int)=" + l3);
        }
        return l3;
    }

    public String SQLGetConnectOptionString(long l2, short s2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Connection Option (SQLGetConnectOption), hDbc=" + l2 + ", fOption=" + s2);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[300];
        this.getConnectOptionString(l2, s2, byArray2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, l2, 0L);
        }
        String string = new String();
        try {
            string = this.BytesToChars(this.charSet, byArray2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("option value (int)=" + string.trim());
        }
        return string.trim();
    }

    public String SQLGetCursorName(long l2) throws SQLException, JdbcOdbcSQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Cursor name (SQLGetCursorName), hStmt=" + l2);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[300];
        this.getCursorName(l2, byArray2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l2);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                String string = new String();
                try {
                    string = this.BytesToChars(this.charSet, byArray2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("value=" + string.trim());
                }
                jdbcOdbcSQLWarning.value = string.trim();
                throw jdbcOdbcSQLWarning;
            }
        }
        String string = new String(byArray2);
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("value=" + string.trim());
        }
        return string.trim();
    }

    public int SQLGetDataBinary(long l2, int n2, byte[] byArray) throws SQLException, JdbcOdbcSQLWarning {
        return this.SQLGetDataBinary(l2, n2, -2, byArray, byArray.length);
    }

    public int SQLGetDataBinary(long l2, int n2, int n3, byte[] byArray, int n4) throws SQLException, JdbcOdbcSQLWarning {
        int n5 = 0;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get binary data (SQLGetData), hStmt=" + l2 + ", column=" + n2 + ", type=" + n3 + ", length=" + n4);
        }
        byte[] byArray2 = new byte[2];
        n5 = this.getDataBinary(l2, n2, n3, byArray, n4, byArray2);
        if (byArray2[0] == 100) {
            n5 = -1;
            byArray2[0] = 0;
        }
        if (byArray2[0] != 0) {
            try {
                this.standardError(byArray2[0], 0L, 0L, l2);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (JdbcOdbcObject.isTracing()) {
                    if (n5 == -1) {
                        JdbcOdbcObject.trace("NULL");
                    } else if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace("Bytes: " + n5);
                    }
                }
                jdbcOdbcSQLWarning.value = new Integer(n5);
                throw jdbcOdbcSQLWarning;
            }
        }
        if (JdbcOdbcObject.isTracing()) {
            if (n5 == -1) {
                JdbcOdbcObject.trace("NULL");
            } else if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("Bytes: " + n5);
            }
        }
        return n5;
    }

    public Double SQLGetDataDouble(long l2, int n2) throws SQLException, JdbcOdbcSQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get double data (SQLGetData), hStmt=" + l2 + ", column=" + n2);
        }
        byte[] byArray = new byte[2];
        double d2 = this.getDataDouble(l2, n2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l2);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (byArray[1] == 0) {
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace("value=" + d2);
                    }
                    jdbcOdbcSQLWarning.value = new Double(d2);
                } else {
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace("NULL");
                    }
                    jdbcOdbcSQLWarning.value = null;
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (byArray[1] == 0) {
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("value=" + d2);
            }
            return new Double(d2);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("NULL");
        }
        return null;
    }

    public Float SQLGetDataFloat(long l2, int n2) throws SQLException, JdbcOdbcSQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get float data (SQLGetData), hStmt=" + l2 + ", column=" + n2);
        }
        byte[] byArray = new byte[2];
        float f2 = this.getDataFloat(l2, n2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l2);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (byArray[1] == 0) {
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace("value=" + f2);
                    }
                    jdbcOdbcSQLWarning.value = new Float(f2);
                } else {
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace("NULL");
                    }
                    jdbcOdbcSQLWarning.value = null;
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (byArray[1] == 0) {
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("value=" + f2);
            }
            return new Float(f2);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("NULL");
        }
        return null;
    }

    public Integer SQLGetDataInteger(long l2, int n2) throws SQLException, JdbcOdbcSQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get integer data (SQLGetData), hStmt=" + l2 + ", column=" + n2);
        }
        byte[] byArray = new byte[2];
        int n3 = this.getDataInteger(l2, n2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l2);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (byArray[1] == 0) {
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace("value=" + n3);
                    }
                    jdbcOdbcSQLWarning.value = new Integer(n3);
                } else {
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace("NULL");
                    }
                    jdbcOdbcSQLWarning.value = null;
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (byArray[1] == 0) {
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("value=" + n3);
            }
            return new Integer(n3);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("NULL");
        }
        return null;
    }

    public String SQLGetDataString(long l2, int n2, int n3, boolean bl2) throws SQLException, JdbcOdbcSQLWarning {
        byte[] byArray;
        byte[] byArray2;
        int n4;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get string data (SQLGetData), hStmt=" + l2 + ", column=" + n2 + ", maxLen=" + n3);
        }
        if ((n4 = this.getDataString(l2, n2, byArray2 = new byte[n3], byArray = new byte[2])) < 0) {
            byArray[1] = 1;
        }
        if (n4 > n3) {
            n4 = n3;
        }
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l2);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (byArray[1] == 0) {
                    char[] cArray = new char[n4];
                    String string = new String();
                    if (n4 > 0) {
                        try {
                            string = this.BytesToChars(this.charSet, byArray2);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            System.out.println(unsupportedEncodingException);
                        }
                    } else {
                        try {
                            string = this.BytesToChars(this.charSet, byArray2);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            System.out.println(unsupportedEncodingException);
                        }
                    }
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace(string.trim());
                    }
                    jdbcOdbcSQLWarning.value = bl2 ? string.trim() : string;
                } else {
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace("NULL");
                    }
                    jdbcOdbcSQLWarning.value = null;
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (byArray[1] == 0) {
            String string = new String();
            char[] cArray = new char[n4];
            if (n4 > 0) {
                try {
                    string = this.BytesToChars(this.charSet, byArray2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.out.println(unsupportedEncodingException);
                }
            } else {
                try {
                    string = this.BytesToChars(this.charSet, byArray2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.out.println(unsupportedEncodingException);
                }
            }
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace(string.trim());
            }
            if (bl2) {
                return string.trim();
            }
            return string;
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("NULL");
        }
        return null;
    }

    public String SQLGetDataStringDate(long l2, int n2) throws SQLException, JdbcOdbcSQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get date data (SQLGetData), hStmt=" + l2 + ", column=" + n2);
        }
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[11];
        this.getDataStringDate(l2, n2, byArray2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l2);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (byArray[1] == 0) {
                    String string = new String();
                    try {
                        string = this.BytesToChars(this.charSet, byArray2);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace(string.trim());
                    }
                    jdbcOdbcSQLWarning.value = string.trim();
                } else {
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace("NULL");
                    }
                    jdbcOdbcSQLWarning.value = null;
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (byArray[1] == 0) {
            String string = new String();
            try {
                string = this.BytesToChars(this.charSet, byArray2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace(string.trim());
            }
            return string.trim();
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("NULL");
        }
        return null;
    }

    public String SQLGetDataStringTime(long l2, int n2) throws SQLException, JdbcOdbcSQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get time data (SQLGetData), hStmt=" + l2 + ", column=" + n2);
        }
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[9];
        this.getDataStringTime(l2, n2, byArray2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l2);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (byArray[1] == 0) {
                    String string = new String();
                    try {
                        string = this.BytesToChars(this.charSet, byArray2);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace(string.trim());
                    }
                    jdbcOdbcSQLWarning.value = string.trim();
                } else {
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace("NULL");
                    }
                    jdbcOdbcSQLWarning.value = null;
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (byArray[1] == 0) {
            String string = new String();
            try {
                string = this.BytesToChars(this.charSet, byArray2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace(string.trim());
            }
            return string.trim();
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("NULL");
        }
        return null;
    }

    public String SQLGetDataStringTimestamp(long l2, int n2) throws SQLException, JdbcOdbcSQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get timestamp data (SQLGetData), hStmt=" + l2 + ", column=" + n2);
        }
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[30];
        this.getDataStringTimestamp(l2, n2, byArray2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l2);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (byArray[1] == 0) {
                    String string = new String();
                    try {
                        string = this.BytesToChars(this.charSet, byArray2);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace(string.trim());
                    }
                    jdbcOdbcSQLWarning.value = string.trim();
                } else {
                    if (JdbcOdbcObject.isTracing()) {
                        JdbcOdbcObject.trace("NULL");
                    }
                    jdbcOdbcSQLWarning.value = null;
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (byArray[1] == 0) {
            String string = new String();
            try {
                string = this.BytesToChars(this.charSet, byArray2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace(string.trim());
            }
            return string.trim();
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("NULL");
        }
        return null;
    }

    public int SQLGetInfo(long l2, short s2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get connection info (SQLGetInfo), hDbc=" + l2 + ", fInfoType=" + s2);
        }
        byte[] byArray = new byte[1];
        int n2 = this.getInfo(l2, s2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, l2, 0L);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace(" int value=" + n2);
        }
        return n2;
    }

    public int SQLGetInfoShort(long l2, short s2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get connection info (SQLGetInfo), hDbc=" + l2 + ", fInfoType=" + s2);
        }
        byte[] byArray = new byte[1];
        int n2 = this.getInfoShort(l2, s2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, l2, 0L);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace(" short value=" + n2);
        }
        return n2;
    }

    public String SQLGetInfoString(long l2, short s2) throws SQLException {
        return this.SQLGetInfoString(l2, s2, 300);
    }

    public String SQLGetInfoString(long l2, short s2, int n2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get connection info string (SQLGetInfo), hDbc=" + l2 + ", fInfoType=" + s2 + ", len=" + n2);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[n2];
        this.getInfoString(l2, s2, byArray2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, l2, 0L);
        }
        String string = new String();
        try {
            string = this.BytesToChars(this.charSet, byArray2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace(string.trim());
        }
        return string.trim();
    }

    public long SQLGetStmtOption(long l2, short s2) throws SQLException, JdbcOdbcSQLWarning {
        long l3 = 0L;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get statement option (SQLGetStmtOption), hStmt=" + l2 + ", fOption=" + s2);
        }
        byte[] byArray = new byte[1];
        l3 = this.getStmtOption(l2, s2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l2);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("value=" + l3);
                }
                jdbcOdbcSQLWarning.value = BigDecimal.valueOf(l3);
                throw jdbcOdbcSQLWarning;
            }
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("value=" + l3);
        }
        return l3;
    }

    public int SQLGetStmtAttr(long l2, int n2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get Statement Attribute (SQLGetStmtAttr), hDbc=" + l2 + ", AttrType=" + n2);
        }
        byte[] byArray = new byte[1];
        int n3 = this.getStmtAttr(l2, n2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l2);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("value=" + n3);
                }
                jdbcOdbcSQLWarning.value = BigDecimal.valueOf(n3);
                throw jdbcOdbcSQLWarning;
            }
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace(" int value=" + n3);
        }
        return n3;
    }

    public void SQLGetTypeInfo(long l2, short s2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get type info (SQLGetTypeInfo), hStmt=" + l2 + ", fSqlType=" + s2);
        }
        byte[] byArray = new byte[1];
        this.getTypeInfo(l2, s2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public boolean SQLMoreResults(long l2) throws SQLException, SQLWarning {
        boolean bl2 = true;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get more results (SQLMoreResults), hStmt=" + l2);
        }
        byte[] byArray = new byte[1];
        this.moreResults(l2, byArray);
        if (byArray[0] == 100) {
            bl2 = false;
            byArray[0] = 0;
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("More results: " + bl2);
        }
        return bl2;
    }

    public String SQLNativeSql(long l2, String string) throws SQLException {
        byte[] byArray = new byte[1];
        int n2 = 1024;
        if (string.length() * 4 > n2 && (n2 = string.length() * 4) > 32768) {
            n2 = 32768;
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Convert native SQL (SQLNativeSql), hDbc=" + l2 + ", nativeLen=" + n2 + ", SQL=" + string);
        }
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = null;
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        try {
            if (string != null) {
                byArray3 = this.CharsToBytes(this.charSet, cArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.nativeSql(l2, byArray3, byArray2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, l2, 0L);
        }
        String string2 = new String();
        try {
            string2 = this.BytesToChars(this.charSet, byArray2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Native SQL=" + string2.trim());
        }
        return string2.trim();
    }

    public int SQLNumParams(long l2) throws SQLException, JdbcOdbcSQLWarning {
        int n2 = 0;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Number of parameter markers (SQLNumParams), hStmt=" + l2);
        }
        byte[] byArray = new byte[1];
        n2 = this.numParams(l2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("value=" + n2);
        }
        return n2;
    }

    public int SQLNumResultCols(long l2) throws SQLException, JdbcOdbcSQLWarning {
        int n2 = 0;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Number of result columns (SQLNumResultCols), hStmt=" + l2);
        }
        byte[] byArray = new byte[1];
        n2 = this.numResultCols(l2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l2);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("value=" + n2);
                }
                jdbcOdbcSQLWarning.value = BigDecimal.valueOf(n2);
                throw jdbcOdbcSQLWarning;
            }
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("value=" + n2);
        }
        return n2;
    }

    public int SQLParamData(long l2) throws SQLException, JdbcOdbcSQLWarning {
        int n2 = 0;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get parameter number (SQLParamData), hStmt=" + l2);
        }
        byte[] byArray = new byte[1];
        n2 = this.paramData(l2, byArray);
        if (byArray[0] == 99) {
            byArray[0] = 0;
        } else {
            n2 = -1;
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Parameter needing data=" + n2);
        }
        return n2;
    }

    public int SQLParamDataInBlock(long l2, int n2) throws SQLException, JdbcOdbcSQLWarning {
        int n3 = 0;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Get parameter number (SQLParamData in block-cursor), hStmt=" + l2);
        }
        byte[] byArray = new byte[1];
        n3 = this.paramDataInBlock(l2, n2, byArray);
        if (byArray[0] == 99) {
            byArray[0] = 0;
        } else {
            n3 = -1;
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Parameter needing data=" + n3);
        }
        return n3;
    }

    public void SQLPrepare(long l2, String string) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Preparing (SQLPrepare), hStmt=" + l2 + ", szSqlStr=" + string);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.prepare(l2, byArray2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public void SQLPutData(long l2, byte[] byArray, int n2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Putting data (SQLPutData), hStmt=" + l2 + ", len=" + n2);
        }
        byte[] byArray2 = new byte[1];
        this.putData(l2, byArray, n2, byArray2);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0L, 0L, l2);
        }
    }

    public void SQLPrimaryKeys(long l2, String string, String string2, String string3) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Primary keys (SQLPrimaryKeys), hStmt=" + l2 + ", catalog=" + string + ", schema=" + string2 + ", table=" + string3);
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        try {
            if (string != null) {
                byArray = this.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray3 = this.CharsToBytes(this.charSet, cArray3);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byte[] byArray4 = new byte[1];
        this.primaryKeys(l2, byArray, string == null, byArray2, string2 == null, byArray3, string3 == null, byArray4);
        if (byArray4[0] != 0) {
            this.standardError(byArray4[0], 0L, 0L, l2);
        }
    }

    public void SQLProcedures(long l2, String string, String string2, String string3) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Procedures (SQLProcedures), hStmt=" + l2 + ", catalog=" + string + ", schema=" + string2 + ", procedure=" + string3);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray3 = this.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray4 = this.CharsToBytes(this.charSet, cArray3);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.procedures(l2, byArray2, string == null, byArray3, string2 == null, byArray4, string3 == null, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public void SQLProcedureColumns(long l2, String string, String string2, String string3, String string4) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Procedure columns (SQLProcedureColumns), hStmt=" + l2 + ", catalog=" + string + ", schema=" + string2 + ", procedure=" + string3 + ", column=" + string4);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        char[] cArray4 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        if (string4 != null) {
            cArray4 = string4.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray3 = this.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray4 = this.CharsToBytes(this.charSet, cArray3);
            }
            if (string4 != null) {
                byArray5 = this.CharsToBytes(this.charSet, cArray4);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.procedureColumns(l2, byArray2, string == null, byArray3, string2 == null, byArray4, string3 == null, byArray5, string4 == null, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public int SQLRowCount(long l2) throws SQLException, JdbcOdbcSQLWarning {
        int n2 = 0;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Number of affected rows (SQLRowCount), hStmt=" + l2);
        }
        byte[] byArray = new byte[1];
        n2 = this.rowCount(l2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0L, 0L, l2);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("value=" + n2);
                }
                jdbcOdbcSQLWarning.value = BigDecimal.valueOf(n2);
                throw jdbcOdbcSQLWarning;
            }
        }
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("value=" + n2);
        }
        return n2;
    }

    public void SQLSetConnectOption(long l2, short s2, int n2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Setting connection option (SQLSetConnectOption), hDbc=" + l2 + ", fOption=" + s2 + ", vParam=" + n2);
        }
        byte[] byArray = new byte[1];
        this.setConnectOption(l2, s2, n2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, l2, 0L);
        }
    }

    public void SQLSetConnectOption(long l2, short s2, String string) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Setting connection option string (SQLSetConnectOption), hDbc=" + l2 + ", fOption=" + s2 + ", vParam=" + string);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.setConnectOptionString(l2, s2, byArray2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, l2, 0L);
        }
    }

    public void SQLSetCursorName(long l2, String string) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Setting cursor name (SQLSetCursorName), hStmt=" + l2 + ", szCursor=" + string);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.setCursorName(l2, byArray2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public void SQLSetStmtOption(long l2, short s2, int n2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Setting statement option (SQLSetStmtOption), hStmt=" + l2 + ", fOption=" + s2 + ", vParam=" + n2);
        }
        byte[] byArray = new byte[1];
        this.setStmtOption(l2, s2, n2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public void SQLSetStmtAttr(long l2, int n2, int n3, int n4) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Setting statement option (SQLSetStmtAttr), hStmt=" + l2 + ", fOption=" + n2 + ", vParam=" + n3);
        }
        byte[] byArray = new byte[1];
        this.setStmtAttr(l2, n2, n3, n4, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public void SQLSetStmtAttrPtr(long l2, int n2, int[] nArray, int n3, long[] lArray) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Setting statement option (SQLSetStmtAttr), hStmt=" + l2 + ", fOption=" + n2);
        }
        byte[] byArray = new byte[1];
        this.setStmtAttrPtr(l2, n2, nArray, n3, byArray, lArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public boolean SQLSetPos(long l2, int n2, int n3, int n4) throws SQLException {
        boolean bl2 = false;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Setting row position (SQLSetPos), hStmt=" + l2 + ", operation = " + n3);
        }
        byte[] byArray = new byte[1];
        this.setPos(l2, n2, n3, n4, byArray);
        if (byArray[0] == 99) {
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("SQL_NEED_DATA returned");
            }
            bl2 = true;
            byArray[0] = 0;
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
        return bl2;
    }

    public void SQLSpecialColumns(long l2, short s2, String string, String string2, String string3, int n2, boolean bl2) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Special columns (SQLSpecialColumns), hStmt=" + l2 + ", fColType=" + s2 + ",catalog=" + string + ", schema=" + string2 + ", table=" + string3 + ", fScope=" + n2 + ", fNullable=" + bl2);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray3 = this.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray4 = this.CharsToBytes(this.charSet, cArray3);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.specialColumns(l2, s2, byArray2, string == null, byArray3, string2 == null, byArray4, string3 == null, n2, bl2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public void SQLStatistics(long l2, String string, String string2, String string3, boolean bl2, boolean bl3) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Statistics (SQLStatistics), hStmt=" + l2 + ",catalog=" + string + ", schema=" + string2 + ", table=" + string3 + ", unique=" + bl2 + ", approximate=" + bl3);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray3 = this.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray4 = this.CharsToBytes(this.charSet, cArray3);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.statistics(l2, byArray2, string == null, byArray3, string2 == null, byArray4, string3 == null, bl2, bl3, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public void SQLTables(long l2, String string, String string2, String string3, String string4) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Tables (SQLTables), hStmt=" + l2 + ",catalog=" + string + ", schema=" + string2 + ", table=" + string3 + ", types=" + string4);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        char[] cArray4 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        if (string4 != null) {
            cArray4 = string4.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray3 = this.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray4 = this.CharsToBytes(this.charSet, cArray3);
            }
            if (string4 != null) {
                byArray5 = this.CharsToBytes(this.charSet, cArray4);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.tables(l2, byArray2, string == null, byArray3, string2 == null, byArray4, string3 == null, byArray5, string4 == null, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public void SQLTablePrivileges(long l2, String string, String string2, String string3) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Tables (SQLTables), hStmt=" + l2 + ",catalog=" + string + ", schema=" + string2 + ", table=" + string3);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = this.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray3 = this.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray4 = this.CharsToBytes(this.charSet, cArray3);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.tablePrivileges(l2, byArray2, string == null, byArray3, string2 == null, byArray4, string3 == null, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0L, 0L, l2);
        }
    }

    public void SQLTransact(long l2, long l3, short s2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Transaction (SQLTransact), hEnv=" + l2 + ", hDbc=" + l3 + ", fType=" + s2);
        }
        byte[] byArray = new byte[1];
        this.transact(l2, l3, s2, byArray);
        if (byArray[0] != 0) {
            this.throwGenericSQLException();
        }
    }

    public native int bufferToInt(byte[] var1);

    public static SQLWarning convertWarning(JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
        SQLWarning sQLWarning = jdbcOdbcSQLWarning;
        if (jdbcOdbcSQLWarning.getSQLState().equals("01004")) {
            DataTruncation dataTruncation = new DataTruncation(-1, false, true, 0, 0);
            sQLWarning = dataTruncation;
        }
        return sQLWarning;
    }

    protected native long allocConnect(long var1, byte[] var3);

    protected native long allocEnv(byte[] var1);

    protected native long allocStmt(long var1, byte[] var3);

    protected native void cancel(long var1, byte[] var3);

    protected native void bindColAtExec(long var1, int var3, int var4, int[] var5, byte[] var6, long[] var7, byte[] var8);

    protected native void bindColBinary(long var1, int var3, Object[] var4, int[] var5, int var6, byte[] var7, long[] var8, byte[] var9);

    protected native void bindColDate(long var1, int var3, int[] var4, int[] var5, int[] var6, int[] var7, byte[] var8, long[] var9, byte[] var10);

    protected native void bindColDefault(long var1, int var3, byte[] var4, byte[] var5, byte[] var6);

    protected native void bindColDouble(long var1, int var3, double[] var4, int[] var5, byte[] var6, long[] var7, byte[] var8);

    protected native void bindColFloat(long var1, int var3, float[] var4, int[] var5, byte[] var6, long[] var7, byte[] var8);

    protected native void bindColInteger(long var1, int var3, int[] var4, int[] var5, byte[] var6, long[] var7, byte[] var8);

    protected native void bindColString(long var1, int var3, int var4, Object[] var5, int var6, int[] var7, byte[] var8, long[] var9, byte[] var10);

    protected native void bindColTime(long var1, int var3, int[] var4, int[] var5, int[] var6, int[] var7, byte[] var8, long[] var9, byte[] var10);

    protected native void bindColTimestamp(long var1, int var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8, int[] var9, int[] var10, int[] var11, byte[] var12, long[] var13, byte[] var14);

    protected native void bindInParameterAtExec(long var1, int var3, int var4, int var5, byte[] var6, byte[] var7, byte[] var8, long[] var9);

    protected native void bindInParameterBinary(long var1, int var3, int var4, byte[] var5, int var6, byte[] var7, byte[] var8, byte[] var9, long[] var10);

    protected native void bindInParameterDate(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, long[] var9);

    protected native void bindInParameterDouble(long var1, int var3, int var4, int var5, double var6, byte[] var8, byte[] var9, long[] var10);

    protected native void bindInParameterFloat(long var1, int var3, int var4, int var5, float var6, byte[] var7, byte[] var8, long[] var9);

    protected native void bindInParameterInteger(long var1, int var3, int var4, int var5, byte[] var6, byte[] var7, long[] var8);

    protected native void bindInParameterNull(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, long[] var9);

    protected native void bindInParameterString(long var1, int var3, int var4, byte[] var5, int var6, int var7, byte[] var8, byte[] var9, long[] var10);

    protected native void bindInParameterTime(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, long[] var9);

    protected native void bindInParameterTimestamp(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, byte[] var11, byte[] var12, long[] var13);

    protected native void bindOutParameterString(long var1, int var3, int var4, int var5, byte[] var6, byte[] var7, byte[] var8, long[] var9);

    protected native void bindInOutParameterString(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, byte[] var9, long[] var10);

    protected native void bindInOutParameterBinary(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, byte[] var9, long[] var10);

    protected native void bindInOutParameterTimeStamp(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, byte[] var9, long[] var10);

    protected native void bindInOutParameter(long var1, int var3, int var4, int var5, int var6, double var7, byte[] var9, byte[] var10, long[] var11);

    protected native void bindInOutParameterNull(long var1, int var3, int var4, int var5, int var6, byte[] var7, byte[] var8, long[] var9);

    protected native void bindInParameterStringArray(long var1, int var3, int var4, Object[] var5, byte[] var6, int var7, int var8, int[] var9, byte[] var10);

    protected native void bindInParameterIntegerArray(long var1, int var3, int var4, int[] var5, int[] var6, byte[] var7);

    protected native void bindInParameterFloatArray(long var1, int var3, int var4, int var5, float[] var6, int[] var7, byte[] var8);

    protected native void bindInParameterDoubleArray(long var1, int var3, int var4, int var5, double[] var6, int[] var7, byte[] var8);

    protected native void bindInParameterDateArray(long var1, int var3, int[] var4, int[] var5, int[] var6, byte[] var7, byte[] var8, int[] var9);

    protected native void bindInParameterTimeArray(long var1, int var3, int[] var4, int[] var5, int[] var6, byte[] var7, byte[] var8, int[] var9);

    protected native void bindInParameterTimestampArray(long var1, int var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8, int[] var9, int[] var10, byte[] var11, byte[] var12, int[] var13);

    protected native void bindInParameterBinaryArray(long var1, int var3, int var4, Object[] var5, int var6, byte[] var7, int[] var8, byte[] var9);

    protected native void bindInParameterAtExecArray(long var1, int var3, int var4, int var5, byte[] var6, int[] var7, byte[] var8);

    protected native void browseConnect(long var1, byte[] var3, byte[] var4, byte[] var5);

    protected native int colAttributes(long var1, int var3, int var4, byte[] var5);

    protected native void colAttributesString(long var1, int var3, int var4, byte[] var5, byte[] var6);

    protected native void columns(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, byte[] var9, boolean var10, byte[] var11);

    protected native void columnPrivileges(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, byte[] var9, boolean var10, byte[] var11);

    protected native int describeParam(long var1, int var3, int var4, byte[] var5);

    protected native void disconnect(long var1, byte[] var3);

    protected native void driverConnect(long var1, byte[] var3, byte[] var4);

    protected native int error(long var1, long var3, long var5, byte[] var7, byte[] var8, byte[] var9);

    protected native void execDirect(long var1, byte[] var3, byte[] var4);

    protected native void execute(long var1, byte[] var3);

    protected native void fetch(long var1, byte[] var3);

    protected native void fetchScroll(long var1, short var3, int var4, byte[] var5);

    protected native void foreignKeys(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, byte[] var9, boolean var10, byte[] var11, boolean var12, byte[] var13, boolean var14, byte[] var15);

    protected native void freeConnect(long var1, byte[] var3);

    protected native void freeEnv(long var1, byte[] var3);

    protected native void freeStmt(long var1, int var3, byte[] var4);

    protected native long getConnectOption(long var1, short var3, byte[] var4);

    protected native void getConnectOptionString(long var1, short var3, byte[] var4, byte[] var5);

    protected native void getCursorName(long var1, byte[] var3, byte[] var4);

    protected native long getStmtOption(long var1, short var3, byte[] var4);

    protected native int getStmtAttr(long var1, int var3, byte[] var4);

    protected native int getDataBinary(long var1, int var3, int var4, byte[] var5, int var6, byte[] var7);

    protected native double getDataDouble(long var1, int var3, byte[] var4);

    protected native float getDataFloat(long var1, int var3, byte[] var4);

    protected native int getDataInteger(long var1, int var3, byte[] var4);

    protected native int getDataString(long var1, int var3, byte[] var4, byte[] var5);

    protected native void getDataStringDate(long var1, int var3, byte[] var4, byte[] var5);

    protected native void getDataStringTime(long var1, int var3, byte[] var4, byte[] var5);

    protected native void getDataStringTimestamp(long var1, int var3, byte[] var4, byte[] var5);

    protected native int getInfo(long var1, short var3, byte[] var4);

    protected native int getInfoShort(long var1, short var3, byte[] var4);

    protected native void getInfoString(long var1, short var3, byte[] var4, byte[] var5);

    protected native void getTypeInfo(long var1, short var3, byte[] var4);

    protected native void moreResults(long var1, byte[] var3);

    protected native void nativeSql(long var1, byte[] var3, byte[] var4, byte[] var5);

    protected native int numParams(long var1, byte[] var3);

    protected native int numResultCols(long var1, byte[] var3);

    protected native int paramData(long var1, byte[] var3);

    protected native int paramDataInBlock(long var1, int var3, byte[] var4);

    protected native void prepare(long var1, byte[] var3, byte[] var4);

    protected native void primaryKeys(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, byte[] var9);

    protected native void procedures(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, byte[] var9);

    protected native void procedureColumns(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, byte[] var9, boolean var10, byte[] var11);

    protected native void putData(long var1, byte[] var3, int var4, byte[] var5);

    protected native int rowCount(long var1, byte[] var3);

    protected native void setConnectOption(long var1, short var3, int var4, byte[] var5);

    protected native void setConnectOptionString(long var1, short var3, byte[] var4, byte[] var5);

    protected native void setCursorName(long var1, byte[] var3, byte[] var4);

    protected native void setStmtOption(long var1, short var3, int var4, byte[] var5);

    protected native void setStmtAttr(long var1, int var3, int var4, int var5, byte[] var6);

    protected native void setStmtAttrPtr(long var1, int var3, int[] var4, int var5, byte[] var6, long[] var7);

    protected native void setPos(long var1, int var3, int var4, int var5, byte[] var6);

    protected native void specialColumns(long var1, short var3, byte[] var4, boolean var5, byte[] var6, boolean var7, byte[] var8, boolean var9, int var10, boolean var11, byte[] var12);

    protected native void statistics(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, boolean var9, boolean var10, byte[] var11);

    protected native void tables(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, byte[] var9, boolean var10, byte[] var11);

    protected native void tablePrivileges(long var1, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, byte[] var9);

    protected native void transact(long var1, long var3, short var5, byte[] var6);

    protected static native void ReleaseStoredBytes(long var0, long var2);

    protected static native void ReleaseStoredChars(long var0, long var2);

    protected static native void ReleaseStoredIntegers(long var0, long var2);

    SQLException createSQLException(long l2, long l3, long l4) {
        String string;
        Object object;
        boolean bl2 = false;
        Object object2 = null;
        Object object3 = null;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("ERROR - Generating SQLException...");
        }
        while (!bl2) {
            byte[] byArray = new byte[1];
            byte[] byArray2 = new byte[6];
            byte[] byArray3 = new byte[300];
            int n2 = this.error(l2, l3, l4, byArray2, byArray3, byArray);
            if (byArray[0] != 0) {
                bl2 = true;
                continue;
            }
            object = null;
            string = new String();
            String string2 = new String();
            try {
                string = this.BytesToChars(this.charSet, byArray3);
                string2 = this.BytesToChars(this.charSet, byArray2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            object = new SQLException(string.trim(), string2.trim(), n2);
            if (object2 == null) {
                object2 = object;
            } else {
                ((SQLException)object3).setNextException((SQLException)object);
            }
            object3 = object;
        }
        if (object2 == null) {
            object = "General error";
            string = "S1000";
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("ERROR - " + string + " " + (String)object);
            }
            object2 = new SQLException((String)object, string);
        }
        return object2;
    }

    SQLWarning createSQLWarning(long l2, long l3, long l4) {
        String string;
        Object object;
        boolean bl2 = false;
        Object object2 = null;
        Object object3 = null;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("WARNING - Generating SQLWarning...");
        }
        while (!bl2) {
            byte[] byArray = new byte[1];
            byte[] byArray2 = new byte[6];
            byte[] byArray3 = new byte[300];
            int n2 = this.error(l2, l3, l4, byArray2, byArray3, byArray);
            if (byArray[0] != 0) {
                bl2 = true;
                continue;
            }
            object = null;
            string = new String();
            String string2 = new String();
            try {
                string = this.BytesToChars(this.charSet, byArray3);
                string2 = this.BytesToChars(this.charSet, byArray2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            object = new JdbcOdbcSQLWarning(string.trim(), string2.trim(), n2);
            if (object2 == null) {
                object2 = object;
            } else {
                ((SQLWarning)object3).setNextWarning((SQLWarning)object);
            }
            object3 = object;
        }
        if (object2 == null) {
            object = "General warning";
            string = "S1000";
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("WARNING - " + string + " " + (String)object);
            }
            object2 = new JdbcOdbcSQLWarning((String)object, string);
        }
        return object2;
    }

    void throwGenericSQLException() throws SQLException {
        String string = "General error";
        String string2 = "S1000";
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("ERROR - " + string2 + " " + string);
        }
        throw new SQLException(string, string2);
    }

    void standardError(short s2, long l2, long l3, long l4) throws SQLException, SQLWarning {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("RETCODE = " + s2);
        }
        switch (s2) {
            case -1: {
                throw this.createSQLException(l2, l3, l4);
            }
            case 1: {
                throw this.createSQLWarning(l2, l3, l4);
            }
            case -2: {
                String string = "Invalid handle";
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("ERROR - " + string);
                }
                throw new SQLException(string);
            }
            case 100: {
                String string = "No data found";
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("ERROR - " + string);
                }
                throw new SQLException(string);
            }
        }
        this.throwGenericSQLException();
    }
}

