/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.AlreadyBoundException;
import sun.nio.ch.DatagramDispatcher;
import sun.nio.ch.DatagramSocketAdaptor;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SocketOpts;
import sun.nio.ch.SocketOptsImpl;
import sun.nio.ch.Util;

class DatagramChannelImpl
extends DatagramChannel
implements SelChImpl {
    FileDescriptor fd = null;
    private static int ST_UNCONNECTED;
    private static int ST_CONNECTED;
    private volatile int state = -1;
    private static NativeDispatcher nd;
    private InetAddress cachedSenderInetAddress = null;
    private int cachedSenderPort = 0;
    private volatile SocketAddress localAddress = null;
    private volatile SocketAddress remoteAddress = null;
    private volatile SocketOpts.IP options = null;
    private DatagramSocket socket = null;
    private Object readLock = new Object();
    private Object writeLock = new Object();
    private boolean isKilled = false;
    SoftReference bufferReference = null;
    int fdVal;
    int bufSize = 0;
    private SocketAddress sender;
    private int bytesReceived;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$sun$nio$ch$DatagramChannelImpl;

    ByteBuffer getDirectBuffer(int n2) {
        ByteBuffer byteBuffer = null;
        if (this.bufferReference == null || (byteBuffer = (ByteBuffer)this.bufferReference.get()) == null || this.bufSize < n2) {
            byteBuffer = ByteBuffer.allocateDirect(n2);
            this.bufferReference = new SoftReference(byteBuffer);
            this.bufSize = n2;
        } else {
            byteBuffer.rewind();
            byteBuffer.limit(n2);
        }
        return byteBuffer;
    }

    public DatagramChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.fd = Net.socket(false);
        this.fdVal = IOUtil.fdVal(this.fd);
        this.state = ST_UNCONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramSocket socket() {
        Object object = this.readLock;
        synchronized (object) {
            if (this.socket == null) {
                this.socket = DatagramSocketAdaptor.create(this);
            }
            DatagramSocket datagramSocket = this.socket;
            return datagramSocket;
        }
    }

    private void ensureOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SocketAddress receive(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        synchronized (object) {
            Object object2;
            int n2;
            block16: {
                boolean bl2;
                SocketAddress socketAddress;
                block15: {
                    this.ensureOpen();
                    n2 = 0;
                    try {
                        this.begin();
                        SecurityManager securityManager = System.getSecurityManager();
                        if (this.isConnected() || securityManager == null) {
                            n2 = this.receive(this.fd, byteBuffer);
                        } else {
                            object2 = this.getDirectBuffer(byteBuffer.remaining());
                            while (true) {
                                if ((n2 = this.receive(this.fd, (ByteBuffer)object2)) == -2) {
                                    socketAddress = null;
                                    Object var10_9 = null;
                                    bl2 = n2 > 0;
                                    break block15;
                                }
                                InetSocketAddress inetSocketAddress = (InetSocketAddress)this.sender;
                                try {
                                    securityManager.checkAccept(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                                }
                                catch (SecurityException securityException) {
                                    ((Buffer)object2).clear();
                                    continue;
                                }
                                break;
                            }
                            ((Buffer)object2).flip();
                            byteBuffer.put((ByteBuffer)object2);
                        }
                        object2 = this.sender;
                        break block16;
                    }
                    catch (Throwable throwable) {
                        Object var10_11 = null;
                        this.end(n2 > 0);
                        if (n2 <= 0 && !this.isOpen()) {
                            throw new AsynchronousCloseException();
                        }
                        throw throwable;
                    }
                }
                this.end(bl2);
                if (n2 <= 0 && !this.isOpen()) {
                    throw new AsynchronousCloseException();
                }
                return socketAddress;
            }
            Object var10_10 = null;
            this.end(n2 > 0);
            if (n2 <= 0 && !this.isOpen()) {
                throw new AsynchronousCloseException();
            }
            return object2;
        }
    }

    private int receive(FileDescriptor fileDescriptor, ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer instanceof DirectBuffer) {
            return this.receiveIntoNativeBuffer(fileDescriptor, byteBuffer);
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(byteBuffer.remaining());
        int n2 = this.receiveIntoNativeBuffer(fileDescriptor, byteBuffer2);
        byteBuffer2.flip();
        if (n2 > 0) {
            byteBuffer.put(byteBuffer2);
        }
        return n2;
    }

    private int receiveIntoNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer) throws IOException {
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        int n5 = this.receive0(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2, n4);
        if (n5 > 0) {
            byteBuffer.position(n2 + n5);
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int send(ByteBuffer byteBuffer, SocketAddress socketAddress) throws IOException {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            boolean bl2;
            int n2;
            SecurityManager securityManager;
            if (!this.isConnected() && (securityManager = System.getSecurityManager()) != null) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
                if (inetSocketAddress.getAddress().isMulticastAddress()) {
                    securityManager.checkMulticast(inetSocketAddress.getAddress());
                } else {
                    securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                }
            }
            this.ensureOpen();
            if (this.isConnected()) {
                if (socketAddress == null) {
                    socketAddress = this.remoteAddress;
                } else if (!socketAddress.equals(this.remoteAddress)) {
                    throw new IllegalArgumentException("Connected address not equal to  target address");
                }
            } else if (socketAddress == null) {
                throw new NullPointerException();
            }
            int n3 = 0;
            try {
                this.begin();
                n2 = n3 = this.send(this.fd, byteBuffer, socketAddress);
                Object var7_8 = null;
                bl2 = n3 > 0;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.end(n3 > 0);
                if (n3 <= 0 && !this.isOpen()) {
                    throw new AsynchronousCloseException();
                }
                throw throwable;
            }
            this.end(bl2);
            if (n3 <= 0 && !this.isOpen()) {
                throw new AsynchronousCloseException();
            }
            return n2;
        }
    }

    private int send(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, SocketAddress socketAddress) throws IOException {
        if (byteBuffer instanceof DirectBuffer) {
            return this.sendFromNativeBuffer(fileDescriptor, byteBuffer, socketAddress);
        }
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n4);
        byteBuffer2.put(byteBuffer);
        byteBuffer2.flip();
        byteBuffer.position(n2);
        int n5 = this.sendFromNativeBuffer(fileDescriptor, byteBuffer2, socketAddress);
        if (n5 > 0) {
            byteBuffer.position(n2 + n5);
        }
        return n5;
    }

    private int sendFromNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, SocketAddress socketAddress) throws IOException {
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        int n5 = this.send0(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2, n4, socketAddress);
        if (n5 > 0) {
            byteBuffer.position(n2 + n5);
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        synchronized (object) {
            boolean bl2;
            int n2;
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            this.ensureOpen();
            int n3 = 0;
            try {
                this.begin();
                n2 = n3 = IOUtil.read(this.fd, byteBuffer, -1L, nd, this.readLock);
                Object var6_5 = null;
                bl2 = n3 > 0;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.end(n3 > 0);
                if (n3 <= 0 && !this.isOpen()) {
                    throw new AsynchronousCloseException();
                }
                throw throwable;
            }
            this.end(bl2);
            if (n3 <= 0 && !this.isOpen()) {
                throw new AsynchronousCloseException();
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int read0(ByteBuffer[] byteBufferArray) throws IOException {
        if (byteBufferArray == null) {
            throw new NullPointerException();
        }
        Object object = this.readLock;
        synchronized (object) {
            boolean bl2;
            int n2;
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            this.ensureOpen();
            int n3 = 0;
            try {
                this.begin();
                n2 = n3 = IOUtil.read(this.fd, byteBufferArray, nd);
                Object var6_5 = null;
                bl2 = n3 > 0;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.end(n3 > 0);
                if (n3 <= 0 && !this.isOpen()) {
                    throw new AsynchronousCloseException();
                }
                throw throwable;
            }
            this.end(bl2);
            if (n3 <= 0 && !this.isOpen()) {
                throw new AsynchronousCloseException();
            }
            return n2;
        }
    }

    public long read(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        return this.read0(Util.subsequence(byteBufferArray, n2, n3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            boolean bl2;
            int n2;
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            this.ensureOpen();
            int n3 = 0;
            try {
                this.begin();
                n2 = n3 = IOUtil.write(this.fd, byteBuffer, -1L, nd, this.writeLock);
                Object var6_5 = null;
                bl2 = n3 > 0;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.end(n3 > 0);
                if (n3 <= 0 && !this.isOpen()) {
                    throw new AsynchronousCloseException();
                }
                throw throwable;
            }
            this.end(bl2);
            if (n3 <= 0 && !this.isOpen()) {
                throw new AsynchronousCloseException();
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int write0(ByteBuffer[] byteBufferArray) throws IOException {
        if (byteBufferArray == null) {
            throw new NullPointerException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            boolean bl2;
            int n2;
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            this.ensureOpen();
            int n3 = 0;
            try {
                this.begin();
                n2 = n3 = IOUtil.write(this.fd, byteBufferArray, nd);
                Object var6_5 = null;
                bl2 = n3 > 0;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.end(n3 > 0);
                if (n3 <= 0 && !this.isOpen()) {
                    throw new AsynchronousCloseException();
                }
                throw throwable;
            }
            this.end(bl2);
            if (n3 <= 0 && !this.isOpen()) {
                throw new AsynchronousCloseException();
            }
            return n2;
        }
    }

    public long write(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        return this.write0(Util.subsequence(byteBufferArray, n2, n3));
    }

    protected void implConfigureBlocking(boolean bl2) throws IOException {
        IOUtil.configureBlocking(this.fd, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketOpts options() {
        if (this.options != null) {
            return this.options;
        }
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                Object object3;
                if (this.options == null) {
                    object3 = new SocketOptsImpl.Dispatcher(){

                        int getInt(int n2) throws IOException {
                            return Net.getIntOption(DatagramChannelImpl.this.fd, n2);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        void setInt(int n2, int n3) throws IOException {
                            Object object = DatagramChannelImpl.this.readLock;
                            synchronized (object) {
                                Object object2 = DatagramChannelImpl.this.writeLock;
                                synchronized (object2) {
                                    Net.setIntOption(DatagramChannelImpl.this.fd, n2, n3);
                                }
                            }
                        }
                    };
                    this.options = new SocketOptsImpl.IP((SocketOptsImpl.Dispatcher)object3);
                }
                object3 = this.options;
                return object3;
            }
        }
    }

    public boolean isBound() {
        return Net.localPortNumber(this.fd) != 0;
    }

    public SocketAddress localAddress() {
        SecurityManager securityManager;
        if (this.isConnected() && this.localAddress == null) {
            this.localAddress = Net.localAddress(this.fd);
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)this.localAddress;
            securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), -1);
        }
        return this.localAddress;
    }

    public SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress socketAddress) throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                this.ensureOpen();
                if (this.isBound()) {
                    throw new AlreadyBoundException();
                }
                SecurityManager securityManager = System.getSecurityManager();
                InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
                if (securityManager != null) {
                    securityManager.checkListen(inetSocketAddress.getPort());
                }
                Net.bind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                this.localAddress = Net.localAddress(this.fd);
            }
        }
    }

    public boolean isConnected() {
        return this.state == ST_CONNECTED;
    }

    void ensureOpenAndUnconnected() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.state != ST_UNCONNECTED) {
            throw new IllegalStateException("Connect already invoked");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatagramChannel connect(SocketAddress socketAddress) throws IOException {
        int n2 = 0;
        boolean bl2 = false;
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                boolean bl3;
                this.ensureOpenAndUnconnected();
                InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                }
                if (!(bl3 = Net.connect(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort(), n2))) {
                    throw new Error();
                }
                this.state = ST_CONNECTED;
                this.remoteAddress = socketAddress;
                this.sender = inetSocketAddress;
                this.cachedSenderInetAddress = inetSocketAddress.getAddress();
                this.cachedSenderPort = inetSocketAddress.getPort();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DatagramChannel disconnect() throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            Object object2 = this.writeLock;
            synchronized (object2) {
                if (!this.isConnected()) return this;
                if (!this.isOpen()) {
                    return this;
                }
                InetSocketAddress inetSocketAddress = (InetSocketAddress)this.remoteAddress;
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkConnect(inetSocketAddress.getAddress().getHostAddress(), inetSocketAddress.getPort());
                }
                DatagramChannelImpl.disconnect0(this.fd);
                this.remoteAddress = null;
                this.state = ST_UNCONNECTED;
                return this;
            }
        }
    }

    protected void implCloseSelectableChannel() throws IOException {
        if (!this.isRegistered()) {
            this.kill();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws IOException {
        Object object = this.readLock;
        synchronized (object) {
            if (this.isKilled) {
                return;
            }
            if (!$assertionsDisabled && (this.isOpen() || this.isRegistered())) {
                throw new AssertionError();
            }
            nd.close(this.fd);
            this.isKilled = true;
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public void translateAndSetReadyOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = 0;
        if ((n2 & 0x20) != 0) {
            throw new Error("POLLNVAL detected");
        }
        if (((n2 & 1) != 0 || (n2 & 8) != 0) && (selectionKeyImpl.interestOps() & 1) != 0) {
            n3 |= 1;
        }
        if (((n2 & 4) != 0 || (n2 & 8) != 0) && (selectionKeyImpl.interestOps() & 4) != 0) {
            n3 |= 4;
        }
        selectionKeyImpl.readyOps(n3);
    }

    public void translateAndSetInterestOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = 0;
        if ((n2 & 1) != 0) {
            n3 |= 1;
        }
        if ((n2 & 4) != 0) {
            n3 |= 4;
        }
        if ((n2 & 8) != 0) {
            n3 |= 1;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n3);
    }

    public FileDescriptor getFD() {
        return this.fd;
    }

    public int getFDVal() {
        return this.fdVal;
    }

    private static native void initIDs();

    private static native void disconnect0(FileDescriptor var0) throws IOException;

    private native int receive0(FileDescriptor var1, long var2, int var4) throws IOException;

    private native int send0(FileDescriptor var1, long var2, int var4, SocketAddress var5) throws IOException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$sun$nio$ch$DatagramChannelImpl == null ? (class$sun$nio$ch$DatagramChannelImpl = DatagramChannelImpl.class$("sun.nio.ch.DatagramChannelImpl")) : class$sun$nio$ch$DatagramChannelImpl).desiredAssertionStatus();
        ST_UNCONNECTED = 0;
        ST_CONNECTED = 2;
        nd = new DatagramDispatcher();
        Util.load();
        DatagramChannelImpl.initIDs();
    }
}

