/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.ByteArrayInputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.LDAPCertStoreParameters;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.security.auth.x500.X500Principal;
import sun.misc.HexDumpEncoder;
import sun.security.provider.certpath.X509CertificatePair;
import sun.security.util.Debug;

public class LDAPCertStore
extends CertStoreSpi {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final String USER_CERT = "userCertificate;binary";
    private static final String CA_CERT = "cACertificate;binary";
    private static final String CROSS_CERT = "crossCertificatePair;binary";
    private static final String CRL = "certificateRevocationList;binary";
    private static final String ARL = "authorityRevocationList;binary";
    private static final String DELTA_CRL = "deltaRevocationList;binary";
    private CertificateFactory cf;
    private DirContext ctx;

    public LDAPCertStore(CertStoreParameters certStoreParameters) throws InvalidAlgorithmParameterException {
        super(certStoreParameters);
        if (!(certStoreParameters instanceof LDAPCertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("parameters must be LDAPCertStoreParameters");
        }
        LDAPCertStoreParameters lDAPCertStoreParameters = (LDAPCertStoreParameters)certStoreParameters;
        this.createInitialDirContext(lDAPCertStoreParameters.getServerName(), lDAPCertStoreParameters.getPort());
        try {
            this.cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new InvalidAlgorithmParameterException("unable to create CertificateFactory for X.509");
        }
    }

    private void createInitialDirContext(String string, int n2) throws InvalidAlgorithmParameterException {
        String string2 = "ldap://" + string + ":" + n2;
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        properties.put("java.naming.provider.url", string2);
        try {
            this.ctx = new InitialDirContext(properties);
            Hashtable hashtable = this.ctx.getEnvironment();
            if (hashtable.get("java.naming.referral") == null) {
                this.ctx.addToEnvironment("java.naming.referral", "follow");
            }
        }
        catch (NamingException namingException) {
            if (debug != null) {
                debug.println("LDAPCertStore.engineInit about to throw InvalidAlgorithmParameterException");
                namingException.printStackTrace();
            }
            throw new InvalidAlgorithmParameterException("unable to create InitialDirContext using supplied parameters");
        }
    }

    private byte[][] getAttrValues(String string, String string2) throws NamingException {
        if (debug != null) {
            debug.println("LDAPCertStore.getAttrValues(" + string + ", " + string2 + ")...");
        }
        byte[][] byArrayArray = null;
        int n2 = 0;
        Attribute attribute = null;
        try {
            attribute = this.getAttr(string, string2);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("LDAPCertStore.getAttrValues exception on getAttr(" + string + "," + string2 + ") call");
                exception.printStackTrace();
            }
            NamingException namingException = new NamingException("LDAPCertStore.getAttrValues exception");
            namingException.setRootCause(exception);
            throw namingException;
        }
        if (attribute != null) {
            byArrayArray = new byte[attribute.size()][];
            NamingEnumeration namingEnumeration = attribute.getAll();
            while (namingEnumeration.hasMore()) {
                Object object = namingEnumeration.next();
                if (object instanceof String && debug != null) {
                    debug.println("LDAPCertStore.getAttrValues() enum.next is a string!: " + (String)object);
                }
                byte[] byArray = (byte[])object;
                byArrayArray[n2++] = byArray;
            }
        }
        return byArrayArray;
    }

    private Attribute getAttr(String string, String string2) throws NamingException {
        String[] stringArray = new String[]{string2};
        Attributes attributes = null;
        try {
            attributes = this.ctx.getAttributes(string, stringArray);
        }
        catch (ServiceUnavailableException serviceUnavailableException) {
            if (debug != null) {
                debug.println("LDAPCertStore.getAttr got ServiceUnavailableException:");
                serviceUnavailableException.printStackTrace();
            }
            throw serviceUnavailableException;
        }
        return attributes.get(string2);
    }

    private Collection getCertificates(String string, String string2, CertSelector certSelector) throws CertStoreException {
        byte[][] byArray;
        Vector vector = new Vector();
        try {
            byArray = this.getAttrValues(string, string2);
        }
        catch (NamingException namingException) {
            throw new CertStoreException(namingException);
        }
        if (byArray == null) {
            return vector;
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            block7: {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray[n2]);
                try {
                    Certificate certificate = this.cf.generateCertificate(byteArrayInputStream);
                    if (certSelector.match(certificate)) {
                        vector.add(certificate);
                    }
                }
                catch (CertificateException certificateException) {
                    if (debug == null) break block7;
                    debug.println("LDAPCertStore.getCertificates() encountered exception while parsing cert, skipping the bad data: ");
                    HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                    debug.println("[ " + hexDumpEncoder.encodeBuffer(byArray[n2]) + " ]");
                }
            }
            ++n2;
        }
        return vector;
    }

    private Collection getCertPairs(String string, String string2) throws CertStoreException {
        byte[][] byArray;
        Vector vector = new Vector();
        try {
            byArray = this.getAttrValues(string, string2);
        }
        catch (NamingException namingException) {
            throw new CertStoreException(namingException);
        }
        if (byArray == null) {
            return vector;
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            block6: {
                try {
                    X509CertificatePair x509CertificatePair = new X509CertificatePair(byArray[n2]);
                    vector.add(x509CertificatePair);
                }
                catch (CertificateException certificateException) {
                    if (debug == null) break block6;
                    debug.println("LDAPCertStore.getCertPairs() encountered exception while parsing cert, skipping the bad data: ");
                    HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                    debug.println("[ " + hexDumpEncoder.encodeBuffer(byArray[n2]) + " ]");
                }
            }
            ++n2;
        }
        return vector;
    }

    private Collection getMatchingCrossCerts(String string, CertSelector certSelector, CertSelector certSelector2) throws CertStoreException {
        Collection collection = this.getCertPairs(string, CROSS_CERT);
        ArrayList arrayList = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate;
            X509CertificatePair x509CertificatePair = (X509CertificatePair)iterator.next();
            if (certSelector != null && (x509Certificate = x509CertificatePair.getForward()) != null && certSelector.match(x509Certificate)) {
                arrayList.add(x509Certificate);
            }
            if (certSelector2 == null || (x509Certificate = x509CertificatePair.getReverse()) == null || !certSelector2.match(x509Certificate)) continue;
            arrayList.add(x509Certificate);
        }
        return arrayList;
    }

    public synchronized Collection engineGetCertificates(CertSelector certSelector) throws CertStoreException {
        if (debug != null) {
            debug.println("LDAPCertStore.engineGetCertificates() selector: " + String.valueOf(certSelector));
        }
        if (certSelector == null) {
            certSelector = new X509CertSelector();
        }
        if (!(certSelector instanceof X509CertSelector)) {
            throw new CertStoreException("LDAPCertStore needs an X509CertSelector to find certs");
        }
        X509CertSelector x509CertSelector = (X509CertSelector)certSelector;
        int n2 = x509CertSelector.getBasicConstraints();
        String string = x509CertSelector.getSubjectAsString();
        String string2 = x509CertSelector.getIssuerAsString();
        HashSet hashSet = new HashSet();
        if (debug != null) {
            debug.println("LDAPCertStore.engineGetCertificates() basicConstraints: " + n2);
        }
        if (string != null) {
            if (debug != null) {
                debug.println("LDAPCertStore.engineGetCertificates() subject is not null");
            }
            if (n2 > -2) {
                hashSet.addAll(this.getMatchingCrossCerts(string, x509CertSelector, null));
                if (debug != null) {
                    debug.println("LDAPCertStore.engineGetCertificates() after getMatchingCrossCerts(subject,xsel,null),certs.size(): " + hashSet.size());
                }
                hashSet.addAll(this.getCertificates(string, CA_CERT, x509CertSelector));
                if (debug != null) {
                    debug.println("LDAPCertStore.engineGetCertificates() after getCertificates(subject,CA_CERT,xsel),certs.size(): " + hashSet.size());
                }
            }
            if (n2 < 0) {
                hashSet.addAll(this.getCertificates(string, USER_CERT, x509CertSelector));
                if (debug != null) {
                    debug.println("LDAPCertStore.engineGetCertificates() after getCertificates(subject,USER_CERT, xsel),certs.size(): " + hashSet.size());
                }
            }
        } else {
            if (debug != null) {
                debug.println("LDAPCertStore.engineGetCertificates() subject is null");
            }
            if (n2 == -2) {
                throw new CertStoreException("need subject to find EE certs");
            }
            if (string2 == null) {
                throw new CertStoreException("need subject or issuer to find certs");
            }
        }
        if (debug != null) {
            debug.println("LDAPCertStore.engineGetCertificates() about to getMatchingCrossCerts...");
        }
        if (string2 != null && n2 > -2) {
            hashSet.addAll(this.getMatchingCrossCerts(string2, null, x509CertSelector));
            if (debug != null) {
                debug.println("LDAPCertStore.engineGetCertificates() after getMatchingCrossCerts(issuer,null,xsel),certs.size(): " + hashSet.size());
            }
            hashSet.addAll(this.getCertificates(string2, CA_CERT, x509CertSelector));
            if (debug != null) {
                debug.println("LDAPCertStore.engineGetCertificates() after getCertificates(issuer,CA_CERT,xsel),certs.size(): " + hashSet.size());
            }
        }
        if (debug != null) {
            debug.println("LDAPCertStore.engineGetCertificates() returning certs");
        }
        return hashSet;
    }

    private Collection getCRLs(String string, String string2, CRLSelector cRLSelector) throws CertStoreException {
        byte[][] byArray;
        Vector vector = new Vector();
        try {
            byArray = this.getAttrValues(string, string2);
        }
        catch (NamingException namingException) {
            throw new CertStoreException(namingException);
        }
        if (byArray == null) {
            return vector;
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            block7: {
                try {
                    CRL cRL = this.cf.generateCRL(new ByteArrayInputStream(byArray[n2]));
                    if (cRLSelector.match(cRL)) {
                        vector.add(cRL);
                    }
                }
                catch (CRLException cRLException) {
                    if (debug == null) break block7;
                    debug.println("LDAPCertStore.getCRLs() encountered exception while parsing CRL, skipping the bad data: ");
                    HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                    debug.println("[ " + hexDumpEncoder.encodeBuffer(byArray[n2]) + " ]");
                }
            }
            ++n2;
        }
        return vector;
    }

    public synchronized Collection engineGetCRLs(CRLSelector cRLSelector) throws CertStoreException {
        Object object;
        Collection collection;
        if (debug != null) {
            debug.println("LDAPCertStore.engineGetCRLs() selector: " + String.valueOf(cRLSelector));
        }
        if (cRLSelector == null) {
            cRLSelector = new X509CRLSelector();
        }
        if (!(cRLSelector instanceof X509CRLSelector)) {
            throw new CertStoreException("need X509CRLSelector to find CRLs");
        }
        X509CRLSelector x509CRLSelector = (X509CRLSelector)cRLSelector;
        HashSet hashSet = new HashSet();
        X509Certificate x509Certificate = x509CRLSelector.getCertificateChecking();
        if (x509Certificate != null) {
            collection = new HashSet();
            object = x509Certificate.getIssuerX500Principal();
            collection.add(((X500Principal)object).getName("RFC2253"));
        } else {
            collection = x509CRLSelector.getIssuerNames();
            if (collection == null) {
                throw new CertStoreException("need issuerNames or certChecking to find CRLs");
            }
        }
        object = collection.iterator();
        while (object.hasNext()) {
            String string;
            Object object2;
            block15: {
                block14: {
                    Object object3 = object.next();
                    if (object3 instanceof byte[]) {
                        try {
                            object2 = new X500Principal((byte[])object3);
                            string = ((X500Principal)object2).getName("RFC2253");
                            break block14;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            continue;
                        }
                    }
                    string = (String)object3;
                }
                object2 = null;
                if (x509Certificate == null || x509Certificate.getBasicConstraints() != -1) {
                    try {
                        object2 = this.getCRLs(string, ARL, x509CRLSelector);
                    }
                    catch (CertStoreException certStoreException) {
                        if (debug == null) break block15;
                        debug.println("LDAPCertStore.engineGetCRLs non-fatal error retrieving ARLs:" + certStoreException);
                        certStoreException.printStackTrace();
                    }
                }
            }
            if (object2 == null || object2.isEmpty() || x509Certificate == null) {
                object2 = this.getCRLs(string, CRL, x509CRLSelector);
            }
            hashSet.addAll((Collection)object2);
        }
        return hashSet;
    }
}

