/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.Gregorian;
import sun.util.calendar.ZoneInfoFile;

public class ZoneInfo
extends TimeZone {
    private static final long OFFSET_MASK = 15L;
    private static final long DST_MASK = 240L;
    private static final int DST_NSHIFT = 4;
    private static final long ABBR_MASK = 3840L;
    private static final int TRANSITION_NSHIFT = 12;
    private int rawOffset;
    private int rawOffsetDiff = 0;
    private int checksum;
    private int dstSavings;
    private long[] transitions;
    private int[] offsets;
    private int[] simpleTimeZoneParams;
    private boolean willGMTOffsetChange = false;
    private static final long serialVersionUID = 2653134537216586139L;
    private transient SimpleTimeZone lastRule;
    private static transient SoftReference aliasTable;

    public ZoneInfo() {
    }

    public ZoneInfo(String string, int n2) {
        this(string, n2, 0, 0, null, null, null, false);
    }

    ZoneInfo(String string, int n2, int n3, int n4, long[] lArray, int[] nArray, int[] nArray2, boolean bl2) {
        this.setID(string);
        this.rawOffset = n2;
        this.dstSavings = n3;
        this.checksum = n4;
        this.transitions = lArray;
        this.offsets = nArray;
        this.simpleTimeZoneParams = nArray2;
        this.willGMTOffsetChange = bl2;
    }

    public int getOffset(long l2) {
        return this.getOffsets(l2, null, false);
    }

    public int getOffsets(long l2, int[] nArray) {
        return this.getOffsets(l2, nArray, false);
    }

    public int getOffsetsByWall(long l2, int[] nArray) {
        return this.getOffsets(l2, nArray, true);
    }

    private int getOffsets(long l2, int[] nArray, boolean bl2) {
        if (this.transitions == null) {
            int n2 = this.getLastRawOffset();
            if (nArray != null) {
                nArray[0] = n2;
                nArray[1] = 0;
            }
            return n2;
        }
        int n3 = this.getTransitionIndex(l2 -= (long)this.rawOffsetDiff, bl2);
        if (n3 < 0) {
            int n4 = this.getLastRawOffset();
            if (nArray != null) {
                nArray[0] = n4;
                nArray[1] = 0;
            }
            return n4;
        }
        if (n3 < this.transitions.length) {
            long l3 = this.transitions[n3];
            int n5 = this.offsets[(int)(l3 & 0xFL)] + this.rawOffsetDiff;
            if (nArray != null) {
                int n6 = (int)(l3 >>> 4 & 0xFL);
                int n7 = n6 == 0 ? 0 : this.offsets[n6];
                nArray[0] = n5 - n7;
                nArray[1] = n7;
            }
            return n5;
        }
        SimpleTimeZone simpleTimeZone = this.getLastRule();
        if (simpleTimeZone != null) {
            int n8;
            int n9 = simpleTimeZone.getRawOffset();
            long l4 = l2;
            if (bl2) {
                l4 -= (long)this.rawOffset;
            }
            int n10 = n8 = simpleTimeZone.inDaylightTime(new Date(l4)) ? simpleTimeZone.getDSTSavings() : 0;
            if (nArray != null) {
                nArray[0] = n9;
                nArray[1] = n8;
            }
            return n9 + n8;
        }
        int n11 = this.getLastRawOffset();
        if (nArray != null) {
            nArray[0] = n11;
            nArray[1] = 0;
        }
        return n11;
    }

    private final int getTransitionIndex(long l2, boolean bl2) {
        int n2 = 0;
        int n3 = this.transitions.length - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            long l3 = this.transitions[n4];
            long l4 = l3 >> 12;
            if (bl2) {
                l4 += (long)this.offsets[(int)(l3 & 0xFL)];
            }
            if (l4 < l2) {
                n2 = n4 + 1;
                continue;
            }
            if (l4 > l2) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        if (n2 >= this.transitions.length) {
            return n2;
        }
        return n2 - 1;
    }

    public int getOffset(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n7 < 0 || n7 >= 86400000) {
            throw new IllegalArgumentException();
        }
        if (n2 == 0) {
            n3 = 1 - n3;
        } else if (n2 != 1) {
            throw new IllegalArgumentException();
        }
        CalendarDate calendarDate = new CalendarDate(n3, n4, n5);
        if (!Gregorian.validate(calendarDate)) {
            throw new IllegalArgumentException();
        }
        if (n6 < 1 || n6 > 7) {
            throw new IllegalArgumentException();
        }
        if (this.transitions == null) {
            return this.getLastRawOffset();
        }
        long l2 = Gregorian.dateToMillis(calendarDate) + (long)n7;
        return this.getOffsets(l2 -= (long)this.rawOffset, null, false);
    }

    public synchronized void setRawOffset(int n2) {
        this.rawOffsetDiff = n2 - this.rawOffset;
        if (this.lastRule != null) {
            this.lastRule.setRawOffset(n2);
        }
    }

    public int getRawOffset() {
        if (!this.willGMTOffsetChange) {
            return this.rawOffset + this.rawOffsetDiff;
        }
        int[] nArray = new int[2];
        this.getOffsets(System.currentTimeMillis(), nArray, false);
        return nArray[0];
    }

    private int getLastRawOffset() {
        return this.rawOffset + this.rawOffsetDiff;
    }

    public boolean useDaylightTime() {
        return this.simpleTimeZoneParams != null;
    }

    public boolean inDaylightTime(Date date) {
        if (date == null) {
            throw new NullPointerException();
        }
        if (this.transitions == null) {
            return false;
        }
        long l2 = date.getTime() - (long)this.rawOffsetDiff;
        int n2 = this.getTransitionIndex(l2, false);
        if (n2 < 0) {
            return false;
        }
        if (n2 < this.transitions.length) {
            return (this.transitions[n2] & 0xF0L) != 0L;
        }
        SimpleTimeZone simpleTimeZone = this.getLastRule();
        if (simpleTimeZone != null) {
            return simpleTimeZone.inDaylightTime(date);
        }
        return false;
    }

    public int getDSTSavings() {
        return this.dstSavings;
    }

    public String toString() {
        return this.getClass().getName() + "[id=\"" + this.getID() + "\"" + ",offset=" + this.getLastRawOffset() + ",dstSavings=" + this.dstSavings + ",useDaylight=" + this.useDaylightTime() + ",transitions=" + (this.transitions != null ? this.transitions.length : 0) + ",lastRule=" + this.getLastRuleInstance() + "]";
    }

    public static String[] getAvailableIDs() {
        return ZoneInfoFile.getZoneIDs();
    }

    public static String[] getAvailableIDs(int n2) {
        ArrayList arrayList = new ArrayList();
        String[] stringArray = ZoneInfo.getAvailableIDs();
        int[] nArray = ZoneInfoFile.getRawOffsets();
        int n3 = 0;
        block0: while (n3 < nArray.length) {
            if (nArray[n3] == n2) {
                byte[] byArray = ZoneInfoFile.getRawOffsetIndices();
                int n4 = 0;
                while (n4 < byArray.length) {
                    if (byArray[n4] == n3) {
                        arrayList.add(stringArray[n4++]);
                        while (n4 < byArray.length && byArray[n4] == n3) {
                            arrayList.add(stringArray[n4++]);
                        }
                        break block0;
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        Object[] objectArray = new String[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    public static TimeZone getTimeZone(String string) {
        ZoneInfo zoneInfo = null;
        zoneInfo = ZoneInfoFile.getZoneInfo(string);
        if (zoneInfo == null) {
            try {
                HashMap hashMap = ZoneInfo.getAliasTable();
                String string2 = string;
                while ((string2 = (String)hashMap.get(string2)) != null) {
                    zoneInfo = ZoneInfoFile.getZoneInfo(string2);
                    if (zoneInfo == null) continue;
                    zoneInfo.setID(string);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return zoneInfo;
    }

    private synchronized SimpleTimeZone getLastRule() {
        if (this.lastRule == null) {
            this.lastRule = this.getLastRuleInstance();
        }
        return this.lastRule;
    }

    public SimpleTimeZone getLastRuleInstance() {
        if (this.simpleTimeZoneParams == null) {
            return null;
        }
        if (this.simpleTimeZoneParams.length == 10) {
            return new SimpleTimeZone(this.getLastRawOffset(), this.getID(), this.simpleTimeZoneParams[0], this.simpleTimeZoneParams[1], this.simpleTimeZoneParams[2], this.simpleTimeZoneParams[3], this.simpleTimeZoneParams[4], this.simpleTimeZoneParams[5], this.simpleTimeZoneParams[6], this.simpleTimeZoneParams[7], this.simpleTimeZoneParams[8], this.simpleTimeZoneParams[9], this.dstSavings);
        }
        return new SimpleTimeZone(this.getLastRawOffset(), this.getID(), this.simpleTimeZoneParams[0], this.simpleTimeZoneParams[1], this.simpleTimeZoneParams[2], this.simpleTimeZoneParams[3], this.simpleTimeZoneParams[4], this.simpleTimeZoneParams[5], this.simpleTimeZoneParams[6], this.simpleTimeZoneParams[7], this.dstSavings);
    }

    public int hashCode() {
        return this.getLastRawOffset() ^ this.checksum;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ZoneInfo)) {
            return false;
        }
        ZoneInfo zoneInfo = (ZoneInfo)object;
        return this.getID().equals(zoneInfo.getID()) && this.getLastRawOffset() == zoneInfo.getLastRawOffset() && this.checksum == zoneInfo.checksum;
    }

    public boolean hasSameRules(TimeZone timeZone) {
        if (this == timeZone) {
            return true;
        }
        if (timeZone == null) {
            return false;
        }
        if (!(timeZone instanceof ZoneInfo)) {
            if (this.getRawOffset() != timeZone.getRawOffset()) {
                return false;
            }
            return this.transitions == null && !this.useDaylightTime() && !timeZone.useDaylightTime();
        }
        if (this.getLastRawOffset() != ((ZoneInfo)timeZone).getLastRawOffset()) {
            return false;
        }
        return this.checksum == ((ZoneInfo)timeZone).checksum;
    }

    private static synchronized HashMap getAliasTable() {
        HashMap hashMap = null;
        if (aliasTable != null && (hashMap = (HashMap)aliasTable.get()) != null) {
            return hashMap;
        }
        hashMap = ZoneInfoFile.getZoneAliases();
        if (hashMap != null) {
            aliasTable = new SoftReference(hashMap);
        }
        return hashMap;
    }
}

