//////////////////////////////////////////////////////////////////////////
// 	$Id: packageInfo.h,v 1.13 2001/09/26 16:33:31 mlaurent Exp $	
// File  : packageInfo.h
// Author: Damyan Pepper
// Author: Toivo Pedaste
//
// This file contains the definition of the class packageInfo
//
// packageInfo is used to store information regarding an  package.
// This information is normally gained by querying the  database or
// by querying an  package.
//
// The package information consists of a set of properties.  These 
// properties are stored in a dictionary that is passed to the 
// constructor.  The properties can be accessed using the function
// `getProperty'.
//
// In addition, packageInfo objects can place themselves inside
// a tree list with the function `place'.  Doing this creates
// a tree list item object that can be accessed with the function
// `item'.
//////////////////////////////////////////////////////////////////////////

#ifndef PACKAGEINFO_H
#define PACKAGEINFO_H
#include "../config.h"

#include <qdict.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qptrlist.h>
#include <qlistview.h>

class pkgInterface;
class KPLVItem;
class KPQListView;

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
class packageInfo
{
public:
  packageInfo(QDict<QString> *_info, pkgInterface *type);
  // Constructor: create a packageInfo object using the property
  // dictionary from _info

  packageInfo(QDict<QString> *_info, QString _filename);
  // Constructor: same as above, but also sets filename to _filename.
  // This is used in the case that the package info was obtained from
  // an uninstalled package.

  ~packageInfo();
  // Distructor

  /**
   *  Look ups the property `property' from the dictionary
   */
  QString getProperty(const QString &property);

  /**
   *  Checks whether the property `property' is defined in the dictionary
   */
  bool hasProperty(const QString &property);

  void fixup();
  // Initialize fields if missing

  KPLVItem *place(KPQListView *tree, bool InsertI=FALSE);
  // places the object in the treelist `tree' and initialises
  // `item'.  If necessary, new groups will be added to `tree'.

  KPLVItem  *getItem();
  // returns the treelist item object for this package or
  // NULL if the object hasn't been placed

  QDict<QString> *getDict();
  // returns the property dictionary for the package

  void setFilename(QString f);
  QString getUrl();
  QString getFilename();

  QString fetchFilename();
  // gets the filename, fetching package if necessary

  int newer(packageInfo *p);
  // if package p is newer

  void pkgFileIns(QString fileName);
  // Insert a package from a file into package tree

  bool pkgInsert(QPtrList<packageInfo> *pki, const QString &exp, bool installed,
	      bool infoPackage = FALSE);
  // insert packgeInfo either installed or not installed

  QDict<QString> *info;
  // This stores the property dictionary of the package

  KPLVItem *item;
  // This stores the tree list item for this package (or NULL if
  // the package hasn't been placed in a tree list)

  pkgInterface *interface;
  // interface points to the class of the package (deb, rpm etc)

  bool smerge( const QString &exp);
  // merge with already existing NOLIST package info

  bool display(int treeType);
  // if this package is to be should in the tree list

  enum {UNSET, AVAILABLE,  INSTALLED, BAD_INSTALL, UPDATED,
	NEW, NOLIST, HIDDEN};
  int packageState;

  bool updated;

private:
  int getDigElement(QString s, int *pos);
  QString getNdigElement(QString s, int *pos);
  // break up version string

  int pnewer(QString s, QString sp);
  // compare parts of a version string
  
  QString url;
  // This stores the filename of the package the info was obtained from.
  // If it is empty then the info was obtained from an installed package.

};

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
#endif

