/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>
		2001      by Stanislav Visnovsky <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#ifndef CATALOGMANAGER_H
#define CATALOGMANAGER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qdict.h>
#include <qlistview.h>
#include <qdatetime.h>
#include <qfileinfo.h>
#include <qguardedptr.h>

#include <kmainwindow.h>
#include <kdirwatch.h>
#include <kprocess.h>
#include <qlist.h>

#include "settings.h"
#include "catalogmanagerview.h"

class CatManListItem;
class QPixmap;
class QPopupMenu;
class QTimer;
class KProgress;
class KAction;
class KBabel;
class CatManPreferences;
class FindDialog;
struct PoInfo;

class CatalogManager : public KMainWindow
{
   Q_OBJECT
public:
   CatalogManager();
   CatalogManager(CatManSettings settings);
   ~CatalogManager();

   CatManSettings settings() const;
   /**
   * Sets the window, in which the files should be opened.
   * This is set by KBabel::openCatalogManager
   */
   void setPreferredWindow(WId id);

   /** updates the file fileWithPath in the @ref CatalogManagerView */
   void updateFile(QString fileWithPath);
   void updateAfterSave(QString fileWithPath, PoInfo &info);
   
   CatalogManagerView *view();
   
   void pause(bool flag) { if( _catalogManager ) _catalogManager->pause (flag); }

   static QStringList _foundFilesList;
   static QStringList _toBeSearched;

public slots:
   void setSettings(CatManSettings newSettings);
   void enableMenuForFiles(bool enable);
   virtual void slotHelp();

   virtual void find();
   virtual void replace();
   virtual void stopSearching();
   virtual void optionsPreferences();
   virtual void optionsKeys();
   virtual void optionsEditToolbars();
   virtual void optionsShowToolbar(bool on);
   virtual void optionsShowStatusbar(bool on);
   virtual void dummySlot() {}
   
   virtual void clearProgressBar();
   virtual void prepareProgressBar(QString msg, int max);

   virtual void clearStatusProgressBar();
   virtual void prepareStatusProgressBar(QString msg, int max);
   virtual void prepareStatusProgressBar(int max);
   
   virtual void setNumberOfFound( int toBeSent, int total );
   virtual void decreaseNumberOfFound();
      
protected slots:
   virtual void findNextFile();
   virtual bool queryClose();
   virtual void quit();

signals:
   void settingsChanged(CatManSettings);
   void signalQuit();
   void searchStopped();

private:
   void init();
   
   void restoreView();
   void saveView();
   
   void saveSettings();
   void restoreSettings();

   void setupActions();
   void setupStatusBar();
   
   bool startKBabel();
   
private slots:
   /**
   * calls @ref KBabel::open where as preferred windos _preferredWindow
   * is used. If this is deleted meanwhile, the first window in
   * @ref KMainWindow::memberList is used.
   */
   void openFile(QString filename);
   /**
   * calls @ref KBabel::openTemplate where as preferred windos _preferredWindow
   * is used. If this is deleted meanwhile, the first window in
   * @ref KMainWindow::memberList is used.
   */
   void openTemplate(QString openFilename,QString saveFileName);
   
   // calls stop on _catalogManager
   void stopForQuit(bool);
   
private:
   CatalogManagerView* _catalogManager;
   
   WId _preferredWindow;

   bool _openNewWindow;

   FindDialog* _findDialog;
   FindDialog* _replaceDialog;
   KDialogBase* _prefDialog;
   CatManPreferences* _prefWidget;
   
   // update progress bar
   KProgress* _progressBar;
   QLabel* _progressLabel;
   
   // statusbar progress bar
   KProgress* _statusProgressBar;
   QLabel* _statusProgressLabel;
   QLabel* _foundLabel;
   int _foundToBeSent;
   int _totalFound;
   
   QTimer* _timerFind;
   bool _searchStopped;
   
   CatManSettings _settings;
   MiscSettings _miscSettings;
   
    // options used in findNextFile
   FindOptions _findOptions;
};

#endif // CATALOGMANAGER_H
