/*****************************************************************
 * flread.c: FBM Release 1.0 25-Feb-90 Michael Mauldin
 *
 * Copyright (C) 1989,1990 by Michael Mauldin.  Permission is granted
 * to use this file in whole or in part for any purpose, educational,
 * recreational or commercial, provided that this copyright notice
 * is retained unchanged.  This software is available to all free of
 * charge by anonymous FTP and in the UUNET archives.
 *
 * flread.c: 
 *
 * CONTENTS
 *	read_bitmap (image, rfname)
 *	write_bitmap (image, wfile, type)
 *
 * EDITLOG
 *	LastEditDate = Mon Jun 25 00:17:56 1990 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/flread.c
 *
 * HISTORY
 * 25-Jun-90  Michael Mauldin (mlm@cs.cmu.edu) Carnegie Mellon
 *	Package for Release 1.0
 *
 * 26-Aug-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.96) mlm@cs.cmu.edu
 *
 * 28-Nov-88  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Created.
 *****************************************************************/

# include <stdio.h>
# include "fbm.h"

# define BM_MAGC	'!'	/* bm format (!!) */
# define FBM_MAGC	'%'	/* fbm format (%bitmap) */
# define SUN_MAGC	0x59	/* Sun rasterfile (0x59a66a95) */
# define PBM_MAGC	'P'	/* pbm file (P1) */
# define ATK_MAGC	'\\'	/* ATK file (\begindata{raster,length}) */
# define MP_MAGC	'\0'	/* MacPaint (titlength in short) */
# define X11_MAGC	'#'	/* X bitmaps (#define) */
# define PCX_MAGC	0xa	/* PCX, PC Paintbrush files */
# define IFF_MAGC	'F'	/* Amiga IFF format ("FORM") */
# define GIF_MAGC	'G'	/* GIF format (CompuServe) */
# define GIF_MAGC	'G'	/* GIF format (CompuServe) */
# define RLE_MAGC	0x52	/* Utah RLE file (0x52 0xcc) */

# define COMPRESSED_CHAR 0x1f	/* Compressed file (0x1f9d) */

#ifndef lint
static char *fbmid =
"$FBM flread.c <1.0> 25-Jun-90  (C) 1989,1990 by Michael Mauldin, source \
code available free from MLM@CS.CMU.EDU and from UUNET archives$";
#endif

read_bitmap (image, fname)
FBM *image;
char *fname;
{ int peekch, result = 0, do_pclose = 0;
  FILE *rfile;
  char cmd[256], magic[32], mlen = 0;

  /* Open the file if name given, otherwise assume stdin */
  if (fname == NULL || *fname == '\0' || !strcmp (fname, "-"))
  { rfile = stdin; }
  else
  { if ((rfile = fopen (fname, "r")) == NULL)
    { perror (fname);  return (0); }
  }

  /* Guess image type by reading the first character */
  peekch = fgetc (rfile);

  /* If the image is compressed, uncompress it while reading */  
  if (peekch == COMPRESSED_CHAR)
  { if (rfile == stdin)
    { if (lseek (fileno (rfile), 0L, 0) < 0)  perror ("lseek");
      rfile = popen ("uncompress", "r");
    }
    else
    { fclose (rfile);
      sprintf (cmd, "uncompress < %s", fname);
      rfile = popen (cmd, "r");
    }
    do_pclose++;

    peekch = fgetc (rfile);
  }
  
  magic[0] = peekch;
  mlen = 1;

  /* Dispatch on the magic character */
  switch (peekch)
  { case BM_MAGC:	result = read_face (image, rfile, magic, mlen); break;
    case FBM_MAGC:	result = read_fbm (image, rfile, magic, mlen); break;
    case SUN_MAGC:	result = read_sun (image, rfile, magic, mlen); break;
    case PBM_MAGC:	result = read_pbm (image, rfile, magic, mlen); break;
    case PCX_MAGC:	result = read_pcx (image, rfile, magic, mlen); break;
    case GIF_MAGC:	result = read_gif (image, rfile, magic, mlen); break;
    case IFF_MAGC:	result = read_iff (image, rfile, magic, mlen); break;
    case ATK_MAGC:	fprintf (stderr, "Can't read Andrew rasters\n"); break;
    case MP_MAGC:	fprintf (stderr, "Can't read MacPaint files\n"); break;
    case X11_MAGC:	fprintf (stderr, "Can't read X bitmaps\n"); break;
    case RLE_MAGC:	result = read_rle (image, rfile, magic, mlen); break;
    case EOF:		fprintf (stderr, "Empty file"); break;
    default:		fprintf (stderr, "Unknown magic char %03o\n", peekch);
  }
  
  if (do_pclose)	pclose (rfile);
  else			fclose (rfile);
  
  return (result);
}

/****************************************************************
 * write_bitmap: Write a specified format
 ****************************************************************/

write_bitmap (image, wfile, type)
FBM *image;
FILE *wfile;
int type;
{
  switch (type)
  {
    case FMT_PBM:	if (! write_pbm (image, wfile)) return (0); break;
    case FMT_FBM:	if (! write_fbm (image, wfile)) return (0); break;
    case FMT_FACE:	if (! write_face (image, wfile)) return (0); break;
    case FMT_SUN:	if (! write_sun (image, wfile)) return (0); break;
    case FMT_GIF:	if (! write_gif (image, wfile)) return (0); break;
    case FMT_IFF:	if (! write_iff (image, wfile)) return (0); break;
    case FMT_RLE:	if (! write_rle (image, wfile)) return (0); break;
    case FMT_PCX:	if (! write_pcx (image, wfile)) return (0); break;
    default:		fprintf (stderr,  
				 "write_bitmap: unknown format type %d\n",
				 type);
		        return (0);
  }

  return (1);
}
