.TH sane-hp 5 "04 Sep 2001"
.IX sane-hp
.SH NAME
sane-hp - SANE backend for HP ScanJet scanners
.SH DESCRIPTION
The
.B sane-hp
library implements a SANE (Scanner Access Now Easy) backend that
provides access to HP ScanJet scanners and OfficeJet multi-function
peripherals (MFPs) which support SCL (Scanner Control Language by HP).
At present, the following
scanners are known positively to work with this backend:
.PP
.RS
Model:         Product id:     Interface:
.br
----------     -----------     ----------
.br
ScanJet Plus   C9195A          HP Parallel Interface Card
.br
ScanJet IIc    C1750A 3226     SCSI
.br
ScanJet IIcx   C2500A 3332     SCSI
.br
ScanJet IIp    C1790A          SCSI
.br
ScanJet 3C     C2520A 3503     SCSI
.br
ScanJet 3P     C2570A 3406     SCSI
.br
ScanJet 4C     C2520A          SCSI
.br
ScanJet 4P     C1130A 3540     SCSI
.br
ScanJet 4100C  C6290A          USB
.br
ScanJet 5P     C5110A          SCSI
.br
ScanJet 5100C  C5190A          parallel port
.br
ScanJet 5200C  C7190A 3846     parallel port/USB
.br
ScanJet 6100C  C2520A 3644     SCSI
.br
ScanJet 6200C  C6270A 3828     SCSI/USB
.br
ScanJet 6250C  C6270A 3828     SCSI/USB
.br
ScanJet 6300C  C7670A          SCSI/USB
.br
ScanJet 6350C  C7670A          SCSI/USB
.br
ScanJet 6390C  C7670A          SCSI/USB
.br
PhotoSmart     C5100A R029,R030,R032    SCSI
.br
OfficeJet Pro 1150C            PTAL
.br
OfficeJet Pro 1170C/1175C      PTAL
.br
OfficeJet R series             PTAL
.br
PSC 500 series                 PTAL
.br
OfficeJet G series             PTAL
.br
PSC 700 series                 PTAL
.br
PSC 900 series                 PTAL
.br
OfficeJet K series             PTAL
.br
OfficeJet V series             PTAL
.RE
.PP
Support for models 5100C/5200C connected to the parallel port requires
the ppSCSI driver available at http://www.torque.net/parport/ppscsi.html
(under development)
.PP
Support for models 5200C/6200C/6250C/6300C/6350C connected to the USB requires
an USB driver available at http://www.jump.net/~dnelson/linux/usb
(under development)
.PP
Support for OfficeJet MFPs requires the "HP OfficeJet Linux driver",
available at "http://hpoj.sourceforge.net".  The "PTAL" (peripheral
transport abstraction library) interface supports peripherals connected to a
parallel port or USB (using the user-mode "ptal-mlcd" driver provided with
hpoj-0.8 or later), or to a LAN with an HP JetDirect external print server.
Supported parallel-port JetDirects include the 70X, 170X, 300X, and 500X
(with firmware x.07.xx or later; x.08.xx or later required for
the G and K series).  The JetDirect 175X is supported for USB peripherals.
.PP
If you own a ScanJet scanner other than the ones listed above, please
let us know if your model works with this backend.  To do this, please
subscribe to the sane-devel mailing list and send a
mail with the relevant information for your scanner to
.IR sane\-devel@mostang.com .
For instructions how to subscribe see
.IR http://www.mostang.com/sane/mail.html .
.SH "DEVICE NAMES"
This backend expects device names of the form:
.PP
.RS
.I special
.RE
.PP
Where
.I special
is the UNIX path-name for the special device that corresponds to the
scanner.  For SCSI scanners the special device name must be a generic SCSI
device or a symlink to such a device.  Under Linux, such a device name could be
.I /dev/sga
or
.IR /dev/sg2 ,
for example. For the HP ScanJet Plus the special device name must be the device
that corresponds to the parallel interface card that was shipped with the
scanner. That is
.I /dev/hpscan
A special driver is required for this card.
See ftp://rvs.ctrl-c.liu.se/pub/wingel/hpscan for details. If the link
does not work, try ftp://sunsite.unc.edu/pub/Linux/kernel/patches/scanners.
.PP
For OfficeJets connected to a parallel port or USB, the format of
.I special
is
.RS
.I mlc:par:0
.RE
or
.RS
.I mlc:usb:0
.RE
respectively, substituting if necessary for "0" the suffix specified when
invoking the ptal-mlcd driver.
.PP
For OfficeJets connected to an HP JetDirect print server, the format of
.I special
is
.RS
.I hpjd:HOSTNAME_OR_IP_ADDRESS[:PORT_NUMBER]
.RE
where
.RS
.I HOSTNAME_OR_IP_ADDRESS
.RE
is the hostname or dotted-decimal IP address of the JetDirect, and
.RS
.I PORT_NUMBER
.RE
is either 1, 2, or 3 to select the port number on a three-port
JetDirect 500X.  The default is port 1.
.SH CONFIGURATION
The contents of the
.I hp.conf
file is a list of options and device names that correspond to HP ScanJet
scanners.  Empty lines and lines starting with a hash mark
(#) are ignored. See sane-scsi(5) on details of what constitutes
a valid device name.
.PP
Options specified infront of the first line that keeps a device name 
are defaults for all devices. Options specified below a line that
keeps a device name apply just to the most recently mentioned device.
.PP
Supported options are
.BR connect-scsi ,
.BR connect-device ,
.BR connect-ptal
and
.BR enable-image-buffering .

Option
.B connect-scsi
specifies that the scanner is connected to the system by SCSI.
Input/output is performed using SCSI-commands.
This is the default.

Option
.B connect-device
specifies that the scanner is connected to the system by a special
device. Input/output is performed by read()/write()-operations
on the device. This option must be used for HP ScanJet Plus and
scanners connected to the USB. However if the scanner requires an USB
driver that simulates a SCSI device, connect-scsi might be used.

Option
.B connect-ptal
specifies that the scanner uses the PTAL interface via the libptal
shared library.  This option must be used for the OfficeJet MFPs.
Support for OfficeJet MFPs is added to the backend at compile time.
If you get the error message "hp-backend not compiled with PTAL support",
you need to install PTAL (see above) and rebuild SANE (running configure
and make).

Option
.B enable-image-buffering
stores the scanned image in memory before passing it to the frontend. Could be
used in case of forward/backward moving scanner lamp.
.PP
  A sample configuration file is shown below:
.PP
.RS
/dev/scanner
.br
# this is a comment
.br
/dev/hpscan
.br
  option connect-device
.RE
.PP
/dev/scanner is typically a symlink to the actual scanner device.
.PP
  A sample configuration file for OfficeJets is shown below:
.PP
.RS
# SCSI scanner:
.br
/dev/scanner
.PP
# Parallel-port-connected MFP:
.br
mlc:par:0
.br
option connect-ptal
.PP
# USB-connected MFP:
.br
mlc:usb:0
.br
option connect-ptal
.PP
# JetDirect-connected MFPs:
.br
hpjd:my-jdex.my-domain.com
.br
option connect-ptal
.br
hpjd:my-500x.my-domain.com:3
.br
option connect-ptal
.br
hpjd:10.10.10.35:2
.br
option connect-ptal
.RE
.SH FILES
.TP
.I @CONFIGDIR@/hp.conf
The backend configuration file (see also description of
.B SANE_CONFIG_DIR
below).
.TP
.I @LIBDIR@/libsane-hp.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane-hp.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.TP
.I $HOME/.sane/calib-hp:<device>.dat
Calibration data for HP PhotoSmart PhotoScanner that is retrieved from the
scanner after calibration. The data is uploaded to the scanner at start
of the backend if it is in media mode 'print media' or if the media mode is
changed to 'print media'.
.SH ENVIRONMENT
.TP
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may
contain the configuration file.  Under UNIX, the directories are
separated by a colon (`:'), under OS/2, they are separated by a
semi-colon (`;').  If this variable is not set, the configuration file
is searched in two default directories: first, the current working
directory (".") and then in @CONFIGDIR@.  If the value of the
environment variable ends with the directory separator character, then
the default directories are searched after the explicitly specified
directories.  For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories "tmp/config", ".", and
"@CONFIGDIR@" being searched (in this order).
.TP
.B SANE_DEBUG_HP
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  E.g.,
a value of 128 requests all debug output to be printed.  Smaller
levels reduce verbosity.

.SH BUGS
.TP
.B HP PhotoSmart PhotoScanner
In media mode 'slide' and 'negative', scan resolutions are rounded to
multiple of 300 dpi. The scanner does not scale the data correctly
on other resolutions. Some newer models (firmware code R030 and later)
do not support adjustment of contrast/intensity level and tone map.
The backend will simulate this by software, but only for gray
and 24 bit color.
.TP
.B Automatic Document Feeder (ADF)
For use of the ADF with xscanimage(1), first place paper in the ADF and
then change option scan source to 'ADF'. Press 'change document'
to load a sheet. Then press 'scan' to start a scan. 
Maybe it is sufficient to press 'scan' without 'change document'
for repeated scans. The use of the preview window is not recommended
when working with the ADF.
Setting a window to scan from ADF is not supported with xscanimage(1).
Try xsane(1).
.TP
.B Immediate actions
Some actions in xscanimage(1) (i.e. unload, select media, calibrate)
have an immediate effect on the scanner without starting a scan.
These options can not be used with scanimage.
.TP
.B Advertised but unsupported commands
Some actions, such as mirror, are advertised by the OfficeJets but actually
have no effect.  Contrast and brightness are simulated by the backend
for these devices.  >8-bit scans, which require xsane(1) anyway, may
not work.
.TP
.B OfficeJet ADF issues
The OfficeJet R and G series are capable of scanning 8.5"x14" documents
in the ADF using a two-pass scanning method, but this is not currently
supported in the backend.  The OfficeJet 1175 and R series refuse to
unload an ADF-loaded document after scanning, and instead display a
message on the front panel prompting the user to remove the document
from the glass and press a button to continue; the OfficeJet G series
doesn't have this problem, however.  The OfficeJet G, K, and V series
automatically unload an ADF-loaded document when the scan channel is closed,
particularly after an idle timeout when connected to an HP JetDirect.
.TP
.B OfficeJet K series and V series
The K and V series feature a "scrollfed" scanner, where the paper is fed
across a stationary scanhead, as opposed to flatbed, where the scanhead
moves across the page.  A consequence of this difference is that the
document length is not known in advance; the scan stops when the end
of the document is reached.  To perform a scan, you must first click
on "Change document", and then start your preview or regular scan.
If necessary, click on "Cancel" when the scan stops.  If there are more
documents to scan, click on "Change document" again to advance to the
next page and repeat the procedure; otherwise, click on "Unload" to
completely unload the page.  An alternative for non-preview scans is
to set the page length (option "br-y") to slightly less than the known
page length, for example, 10.5 inches for an 8.5"x11" page.  This will
eliminate the need to cancel the scan, but you still need to click on
"Change document" before each scan and "Unload" after the last page.
Note that due to the use of the "Change document" and "Unload" options,
you will probably not be able to use the command-line "scanimage" program
with the K or V series, not even the "-T" or "--test" parameters.

.SH TODO
.TP
.B HP PhotoSmart PhotoScanner
PhotoScanners with firmware release R030 and up have
no firmware support for contrast/brightness/gamma table. In the current
backend this is simulated by software on 24 bits data.
Simulation on 30 bits should give better results.
.TP
.B Data widths greater than 8 bits
Custom gamma table does not work.
.TP
.B Parallel scanner support
Beside the ScanJet Plus which came with its own parallel interface card,
currently only the HP ScanJet 5100C/5200C are supported.
These scanners are using an internal parallel-to-SCSI converter which
is supported by the ppSCSI-driver (see above).
.TP
.B Scrollfed MFP support
A separate backend is planned to properly support the OfficeJet K and V
series, as well as other non-SCL HP MFPs, such as the OfficeJet 500, 600,
700, T, and PSC 300 series and the LaserJet 1100A, 1220, and 3200.
For now, scanning on these non-SCL scrollfed models is supported by the
"ptal-hp scan" command-line application in version 0.8 or later of the
HP OfficeJet Linux driver, available from http://hpoj.sourceforge.net.
.TP
.B LaserJet 3100 and 3150
Support for the LaserJet 3100 and 3150 is NOT planned, because programming
information for these models is not available.  However, if you have a
LaserJet 3150 connected to a JetDirect 70X/170X/300X/500X with firmware
x.08.xx or later, you can scan using the JetDirect's embedded web server.

.SH "SEE ALSO"
sane(7), sane\-scsi(5)
.SH AUTHOR
The sane-hp backend was written by Geoffrey T. Dairiki. HP PhotoSmart
PhotoScanner support by Peter Kirchgessner.
HP OfficeJet support by David Paschal.
