/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.ClientId;
import com.sun.jndi.ldap.DigestClientId;
import com.sun.jndi.ldap.LdapClient;
import com.sun.jndi.ldap.LdapClientFactory;
import com.sun.jndi.ldap.SimpleClientId;
import com.sun.jndi.ldap.pool.Pool;
import com.sun.jndi.ldap.pool.PoolCleaner;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.ldap.Control;

public final class LdapPoolManager {
    private static final String DEBUG = "com.sun.jndi.ldap.connect.pool.debug";
    public static final boolean debug = "all".equalsIgnoreCase(LdapPoolManager.getProperty("com.sun.jndi.ldap.connect.pool.debug", null));
    public static final boolean trace = debug || "fine".equalsIgnoreCase(LdapPoolManager.getProperty("com.sun.jndi.ldap.connect.pool.debug", null));
    private static final String POOL_AUTH = "com.sun.jndi.ldap.connect.pool.authentication";
    private static final String POOL_PROTOCOL = "com.sun.jndi.ldap.connect.pool.protocol";
    private static final String MAX_POOL_SIZE = "com.sun.jndi.ldap.connect.pool.maxsize";
    private static final String PREF_POOL_SIZE = "com.sun.jndi.ldap.connect.pool.prefsize";
    private static final String INIT_POOL_SIZE = "com.sun.jndi.ldap.connect.pool.initsize";
    private static final String POOL_TIMEOUT = "com.sun.jndi.ldap.connect.pool.timeout";
    private static final String SASL_CALLBACK = "java.naming.security.sasl.callback";
    private static final int DEFAULT_MAX_POOL_SIZE = 0;
    private static final int DEFAULT_PREF_POOL_SIZE = 0;
    private static final int DEFAULT_INIT_POOL_SIZE = 1;
    private static final int DEFAULT_TIMEOUT = 0;
    private static final String DEFAULT_AUTH_MECHS = "none simple";
    private static final String DEFAULT_PROTOCOLS = "plain";
    private static final int NONE = 0;
    private static final int SIMPLE = 1;
    private static final int DIGEST = 2;
    private static final long idleTimeout;
    private static final int maxSize;
    private static final int prefSize;
    private static final int initSize;
    private static boolean supportPlainProtocol;
    private static boolean supportSslProtocol;
    private static final Pool[] pools;

    private LdapPoolManager() {
    }

    private static int findPool(String string) {
        if ("none".equalsIgnoreCase(string)) {
            return 0;
        }
        if ("simple".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("digest-md5".equalsIgnoreCase(string)) {
            return 2;
        }
        return -1;
    }

    static boolean isPoolingAllowed(String string, OutputStream outputStream, String string2, String string3, Hashtable hashtable) {
        if (string != null && !string.equals("javax.net.ssl.SSLSocketFactory") || outputStream != null && !debug || string3 == null && !supportPlainProtocol || "ssl".equalsIgnoreCase(string3) && !supportSslProtocol) {
            LdapPoolManager.d("Pooling disallowed due to socketFactory or tracing");
            return false;
        }
        int n2 = LdapPoolManager.findPool(string2);
        if (n2 < 0 || pools[n2] == null) {
            LdapPoolManager.d("authmech not found: ", string2);
            return false;
        }
        LdapPoolManager.d("using authmech: ", string2);
        switch (n2) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return hashtable == null || hashtable.get(SASL_CALLBACK) == null;
            }
        }
        return false;
    }

    static LdapClient getLdapClient(String string, int n2, String string2, int n3, OutputStream outputStream, int n4, String string3, Control[] controlArray, String string4, String string5, Object object, Hashtable hashtable) throws NamingException {
        Pool pool;
        ClientId clientId = null;
        int n5 = LdapPoolManager.findPool(string3);
        if (n5 < 0 || (pool = pools[n5]) == null) {
            throw new IllegalArgumentException("Attempting to use pooling for an unsupported mechanism: " + string3);
        }
        switch (n5) {
            case 0: {
                clientId = new ClientId(n4, string, n2, string4, controlArray, outputStream);
                break;
            }
            case 1: {
                clientId = new SimpleClientId(n4, string, n2, string4, controlArray, outputStream, string5, object);
                break;
            }
            case 2: {
                clientId = new DigestClientId(n4, string, n2, string4, controlArray, outputStream, string5, object, hashtable);
            }
        }
        return (LdapClient)pool.getPooledConnection(clientId, n3, new LdapClientFactory(string, n2, string2, n3, outputStream));
    }

    public static void showStats(PrintStream printStream) {
        printStream.println("***** start *****");
        printStream.println("idle timeout: " + idleTimeout);
        printStream.println("maximum pool size: " + maxSize);
        printStream.println("preferred pool size: " + prefSize);
        printStream.println("initial pool size: " + initSize);
        printStream.println("protocol types: " + (supportPlainProtocol ? "plain " : "") + (supportSslProtocol ? "ssl" : ""));
        printStream.println("authentication types: " + (pools[0] != null ? "none " : "") + (pools[1] != null ? "simple " : "") + (pools[2] != null ? "DIGEST-MD5 " : ""));
        int n2 = 0;
        while (n2 < pools.length) {
            if (pools[n2] != null) {
                printStream.println((n2 == 0 ? "anonymous pools" : (n2 == 1 ? "simple auth pools" : (n2 == 2 ? "digest pools" : ""))) + ":");
                pools[n2].showStats(printStream);
            }
            ++n2;
        }
        printStream.println("***** end *****");
    }

    public static void expire(long l2) {
        int n2 = 0;
        while (n2 < pools.length) {
            if (pools[n2] != null) {
                pools[n2].expire(l2);
            }
            ++n2;
        }
    }

    private static void d(String string) {
        if (debug) {
            System.err.println("LdapPoolManager: " + string);
        }
    }

    private static void d(String string, String string2) {
        if (debug) {
            System.err.println("LdapPoolManager: " + string + string2);
        }
    }

    private static final String getProperty(final String string, final String string2) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty(string, string2);
                }
                catch (SecurityException securityException) {
                    return string2;
                }
            }
        });
    }

    private static final int getInteger(final String string, final int n2) {
        Integer n3 = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Integer.getInteger(string, n2);
                }
                catch (SecurityException securityException) {
                    return new Integer(n2);
                }
            }
        });
        return n3;
    }

    private static final long getLong(final String string, final long l2) {
        Long l3 = (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Long.getLong(string, l2);
                }
                catch (SecurityException securityException) {
                    return new Long(l2);
                }
            }
        });
        return l3;
    }

    static {
        supportPlainProtocol = false;
        supportSslProtocol = false;
        pools = new Pool[3];
        maxSize = LdapPoolManager.getInteger(MAX_POOL_SIZE, 0);
        prefSize = LdapPoolManager.getInteger(PREF_POOL_SIZE, 0);
        initSize = LdapPoolManager.getInteger(INIT_POOL_SIZE, 1);
        idleTimeout = LdapPoolManager.getLong(POOL_TIMEOUT, 0L);
        String string = LdapPoolManager.getProperty(POOL_AUTH, DEFAULT_AUTH_MECHS);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n2 = stringTokenizer.countTokens();
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            String string2 = stringTokenizer.nextToken().toLowerCase();
            if (string2.equals("anonymous")) {
                string2 = "none";
            }
            if ((n4 = LdapPoolManager.findPool(string2)) >= 0 && pools[n4] == null) {
                LdapPoolManager.pools[n4] = new Pool(initSize, prefSize, maxSize);
            }
            ++n3;
        }
        string = LdapPoolManager.getProperty(POOL_PROTOCOL, DEFAULT_PROTOCOLS);
        stringTokenizer = new StringTokenizer(string);
        n2 = stringTokenizer.countTokens();
        int n5 = 0;
        while (n5 < n2) {
            String string3 = stringTokenizer.nextToken();
            if (DEFAULT_PROTOCOLS.equalsIgnoreCase(string3)) {
                supportPlainProtocol = true;
            } else if ("ssl".equalsIgnoreCase(string3)) {
                supportSslProtocol = true;
            }
            ++n5;
        }
        if (idleTimeout > 0L) {
            new PoolCleaner(idleTimeout, pools).start();
        }
        if (debug) {
            LdapPoolManager.showStats(System.err);
        }
    }
}

