/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.lang.ref.WeakReference;
import sun.awt.image.IntegerComponentRaster;

class GradientPaintContext
implements PaintContext {
    static ColorModel xrgbmodel = new DirectColorModel(24, 0xFF0000, 65280, 255);
    static ColorModel xbgrmodel = new DirectColorModel(24, 255, 65280, 0xFF0000);
    static ColorModel cachedModel;
    static WeakReference cached;
    double x1;
    double y1;
    double dx;
    double dy;
    boolean cyclic;
    int[] interp;
    Raster saved;
    ColorModel model;

    static synchronized Raster getCachedRaster(ColorModel colorModel, int n2, int n3) {
        Raster raster;
        if (colorModel == cachedModel && cached != null && (raster = (Raster)cached.get()) != null && raster.getWidth() >= n2 && raster.getHeight() >= n3) {
            cached = null;
            return raster;
        }
        return colorModel.createCompatibleWritableRaster(n2, n3);
    }

    static synchronized void putCachedRaster(ColorModel colorModel, Raster raster) {
        Raster raster2;
        if (cached != null && (raster2 = (Raster)cached.get()) != null) {
            int n2 = raster2.getWidth();
            int n3 = raster2.getHeight();
            int n4 = raster.getWidth();
            int n5 = raster.getHeight();
            if (n2 >= n4 && n3 >= n5) {
                return;
            }
            if (n2 * n3 >= n4 * n5) {
                return;
            }
        }
        cachedModel = colorModel;
        cached = new WeakReference(raster);
    }

    public GradientPaintContext(ColorModel colorModel, Point2D point2D, Point2D point2D2, AffineTransform affineTransform, Color color, Color color2, boolean bl2) {
        Point2D point2D3;
        Point2D.Double double_ = new Point2D.Double(1.0, 0.0);
        Point2D.Double double_2 = new Point2D.Double(0.0, 1.0);
        try {
            AffineTransform affineTransform2 = affineTransform.createInverse();
            affineTransform2.deltaTransform(double_, double_);
            affineTransform2.deltaTransform(double_2, double_2);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            ((Point2D)double_).setLocation(0.0, 0.0);
            ((Point2D)double_2).setLocation(0.0, 0.0);
        }
        double d2 = point2D2.getX() - point2D.getX();
        double d3 = point2D2.getY() - point2D.getY();
        double d4 = d2 * d2 + d3 * d3;
        if (d4 <= Double.MIN_VALUE) {
            this.dx = 0.0;
            this.dy = 0.0;
        } else {
            this.dx = (((Point2D)double_).getX() * d2 + ((Point2D)double_).getY() * d3) / d4;
            this.dy = (((Point2D)double_2).getX() * d2 + ((Point2D)double_2).getY() * d3) / d4;
            if (bl2) {
                this.dx %= 1.0;
                this.dy %= 1.0;
            } else if (this.dx < 0.0) {
                point2D3 = point2D;
                point2D = point2D2;
                point2D2 = point2D3;
                Color color3 = color;
                color = color2;
                color2 = color3;
                this.dx = -this.dx;
                this.dy = -this.dy;
            }
        }
        point2D3 = affineTransform.transform(point2D, null);
        this.x1 = point2D3.getX();
        this.y1 = point2D3.getY();
        this.cyclic = bl2;
        int n2 = color.getRGB();
        int n3 = color2.getRGB();
        int n4 = n2 >> 24 & 0xFF;
        int n5 = n2 >> 16 & 0xFF;
        int n6 = n2 >> 8 & 0xFF;
        int n7 = n2 & 0xFF;
        int n8 = (n3 >> 24 & 0xFF) - n4;
        int n9 = (n3 >> 16 & 0xFF) - n5;
        int n10 = (n3 >> 8 & 0xFF) - n6;
        int n11 = (n3 & 0xFF) - n7;
        if (n4 == 255 && n8 == 0) {
            DirectColorModel directColorModel;
            int n12;
            this.model = xrgbmodel;
            if (colorModel instanceof DirectColorModel && ((n12 = (directColorModel = (DirectColorModel)colorModel).getAlphaMask()) == 0 || n12 == 255) && directColorModel.getRedMask() == 255 && directColorModel.getGreenMask() == 65280 && directColorModel.getBlueMask() == 0xFF0000) {
                this.model = xbgrmodel;
                n12 = n5;
                n5 = n7;
                n7 = n12;
                n12 = n9;
                n9 = n11;
                n11 = n12;
            }
        } else {
            this.model = ColorModel.getRGBdefault();
        }
        this.interp = new int[bl2 ? 513 : 257];
        int n13 = 0;
        while (n13 <= 256) {
            int n14;
            float f2 = (float)n13 / 256.0f;
            this.interp[n13] = n14 = (int)((float)n4 + (float)n8 * f2) << 24 | (int)((float)n5 + (float)n9 * f2) << 16 | (int)((float)n6 + (float)n10 * f2) << 8 | (int)((float)n7 + (float)n11 * f2);
            if (bl2) {
                this.interp[512 - n13] = n14;
            }
            ++n13;
        }
    }

    public void dispose() {
        if (this.saved != null) {
            GradientPaintContext.putCachedRaster(this.model, this.saved);
            this.saved = null;
        }
    }

    public ColorModel getColorModel() {
        return this.model;
    }

    public Raster getRaster(int n2, int n3, int n4, int n5) {
        double d2 = ((double)n2 - this.x1) * this.dx + ((double)n3 - this.y1) * this.dy;
        Raster raster = this.saved;
        if (raster == null || raster.getWidth() < n4 || raster.getHeight() < n5) {
            this.saved = raster = GradientPaintContext.getCachedRaster(this.model, n4, n5);
        }
        IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)raster;
        int n6 = integerComponentRaster.getDataOffset(0);
        int n7 = integerComponentRaster.getScanlineStride() - n4;
        int[] nArray = integerComponentRaster.getDataStorage();
        if (this.cyclic) {
            this.cycleFillRaster(nArray, n6, n7, n4, n5, d2, this.dx, this.dy);
        } else {
            this.clipFillRaster(nArray, n6, n7, n4, n5, d2, this.dx, this.dy);
        }
        return raster;
    }

    void cycleFillRaster(int[] nArray, int n2, int n3, int n4, int n5, double d2, double d3, double d4) {
        int n6 = (int)((d2 %= 2.0) * 1.073741824E9) << 1;
        int n7 = (int)(-d3 * -2.147483648E9);
        int n8 = (int)(-d4 * -2.147483648E9);
        while (--n5 >= 0) {
            int n9 = n6;
            int n10 = n4;
            while (n10 > 0) {
                nArray[n2++] = this.interp[n9 >>> 23];
                n9 += n7;
                --n10;
            }
            n2 += n3;
            n6 += n8;
        }
    }

    void clipFillRaster(int[] nArray, int n2, int n3, int n4, int n5, double d2, double d3, double d4) {
        while (--n5 >= 0) {
            int n6;
            double d5 = d2;
            int n7 = n4;
            if (d5 <= 0.0) {
                n6 = this.interp[0];
                do {
                    nArray[n2++] = n6;
                } while (--n7 > 0 && (d5 += d3) <= 0.0);
            }
            while (d5 < 1.0 && --n7 >= 0) {
                nArray[n2++] = this.interp[(int)(d5 * 256.0)];
                d5 += d3;
            }
            if (n7 > 0) {
                n6 = this.interp[256];
                do {
                    nArray[n2++] = n6;
                } while (--n7 > 0);
            }
            n2 += n3;
            d2 += d4;
        }
    }
}

