/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.font.TextHitInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.AttributedCharacterIterator;

public class InputMethodEvent
extends AWTEvent {
    private static final long serialVersionUID = 4727190874778922661L;
    public static final int INPUT_METHOD_FIRST = 1100;
    public static final int INPUT_METHOD_TEXT_CHANGED = 1100;
    public static final int CARET_POSITION_CHANGED = 1101;
    public static final int INPUT_METHOD_LAST = 1101;
    long when;
    private transient AttributedCharacterIterator text;
    private transient int committedCharacterCount;
    private transient TextHitInfo caret;
    private transient TextHitInfo visiblePosition;

    public InputMethodEvent(Component component, int n2, long l2, AttributedCharacterIterator attributedCharacterIterator, int n3, TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        super(component, n2);
        if (n2 < 1100 || n2 > 1101) {
            throw new IllegalArgumentException("id outside of valid range");
        }
        if (n2 == 1101 && attributedCharacterIterator != null) {
            throw new IllegalArgumentException("text must be null for CARET_POSITION_CHANGED");
        }
        this.when = l2;
        this.text = attributedCharacterIterator;
        int n4 = 0;
        if (attributedCharacterIterator != null) {
            n4 = attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex();
        }
        if (n3 < 0 || n3 > n4) {
            throw new IllegalArgumentException("committedCharacterCount outside of valid range");
        }
        this.committedCharacterCount = n3;
        this.caret = textHitInfo;
        this.visiblePosition = textHitInfo2;
    }

    public InputMethodEvent(Component component, int n2, AttributedCharacterIterator attributedCharacterIterator, int n3, TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        this(component, n2, EventQueue.getMostRecentEventTime(), attributedCharacterIterator, n3, textHitInfo, textHitInfo2);
    }

    public InputMethodEvent(Component component, int n2, TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        this(component, n2, EventQueue.getMostRecentEventTime(), null, 0, textHitInfo, textHitInfo2);
    }

    public AttributedCharacterIterator getText() {
        return this.text;
    }

    public int getCommittedCharacterCount() {
        return this.committedCharacterCount;
    }

    public TextHitInfo getCaret() {
        return this.caret;
    }

    public TextHitInfo getVisiblePosition() {
        return this.visiblePosition;
    }

    public void consume() {
        this.consumed = true;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public long getWhen() {
        return this.when;
    }

    public String paramString() {
        CharSequence charSequence;
        String string;
        String string2;
        switch (this.id) {
            case 1100: {
                string2 = "INPUT_METHOD_TEXT_CHANGED";
                break;
            }
            case 1101: {
                string2 = "CARET_POSITION_CHANGED";
                break;
            }
            default: {
                string2 = "unknown type";
            }
        }
        if (this.text == null) {
            string = "no text";
        } else {
            charSequence = new StringBuffer("\"");
            int n2 = this.committedCharacterCount;
            char c2 = this.text.first();
            while (n2-- > 0) {
                ((StringBuffer)charSequence).append(c2);
                c2 = this.text.next();
            }
            ((StringBuffer)charSequence).append("\" + \"");
            while (c2 != '\uffff') {
                ((StringBuffer)charSequence).append(c2);
                c2 = this.text.next();
            }
            ((StringBuffer)charSequence).append("\"");
            string = ((StringBuffer)charSequence).toString();
        }
        charSequence = this.committedCharacterCount + " characters committed";
        String string3 = this.caret == null ? "no caret" : "caret: " + this.caret.toString();
        String string4 = this.visiblePosition == null ? "no visible position" : "visible position: " + this.visiblePosition.toString();
        return string2 + ", " + string + ", " + (String)charSequence + ", " + string3 + ", " + string4;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.when == 0L) {
            this.when = EventQueue.getMostRecentEventTime();
        }
    }
}

