/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Byte
extends Number
implements Comparable {
    public static final byte MIN_VALUE = -128;
    public static final byte MAX_VALUE = 127;
    public static final Class TYPE = Class.getPrimitiveClass("byte");
    private byte value;
    private static final long serialVersionUID = -7183698231559129828L;

    public static String toString(byte by) {
        return Integer.toString(by, 10);
    }

    public static byte parseByte(String string) throws NumberFormatException {
        return Byte.parseByte(string, 10);
    }

    public static byte parseByte(String string, int n2) throws NumberFormatException {
        int n3 = Integer.parseInt(string, n2);
        if (n3 < -128 || n3 > 127) {
            throw new NumberFormatException("Value out of range. Value:\"" + string + "\" Radix:" + n2);
        }
        return (byte)n3;
    }

    public static Byte valueOf(String string, int n2) throws NumberFormatException {
        return new Byte(Byte.parseByte(string, n2));
    }

    public static Byte valueOf(String string) throws NumberFormatException {
        return Byte.valueOf(string, 10);
    }

    public static Byte decode(String string) throws NumberFormatException {
        Byte by;
        int n2 = 10;
        int n3 = 0;
        boolean bl2 = false;
        if (string.startsWith("-")) {
            bl2 = true;
            ++n3;
        }
        if (string.startsWith("0x", n3) || string.startsWith("0X", n3)) {
            n3 += 2;
            n2 = 16;
        } else if (string.startsWith("#", n3)) {
            ++n3;
            n2 = 16;
        } else if (string.startsWith("0", n3) && string.length() > 1 + n3) {
            ++n3;
            n2 = 8;
        }
        if (string.startsWith("-", n3)) {
            throw new NumberFormatException("Negative sign in wrong position");
        }
        try {
            by = Byte.valueOf(string.substring(n3), n2);
            by = bl2 ? new Byte(-by.byteValue()) : by;
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = bl2 ? new String("-" + string.substring(n3)) : string.substring(n3);
            by = Byte.valueOf(string2, n2);
        }
        return by;
    }

    public Byte(byte by) {
        this.value = by;
    }

    public Byte(String string) throws NumberFormatException {
        this.value = Byte.parseByte(string, 10);
    }

    public byte byteValue() {
        return this.value;
    }

    public short shortValue() {
        return this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof Byte) {
            return this.value == (Byte)object;
        }
        return false;
    }

    public int compareTo(Byte by) {
        return this.value - by.value;
    }

    public int compareTo(Object object) {
        return this.compareTo((Byte)object);
    }
}

