/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.security.AccessController;
import java.util.zip.Checksum;
import sun.security.action.LoadLibraryAction;

public class CRC32
implements Checksum {
    private int crc;

    public void update(int n2) {
        this.crc = CRC32.update(this.crc, n2);
    }

    public void update(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0 || n2 > byArray.length - n3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.crc = CRC32.updateBytes(this.crc, byArray, n2, n3);
    }

    public void update(byte[] byArray) {
        this.crc = CRC32.updateBytes(this.crc, byArray, 0, byArray.length);
    }

    public void reset() {
        this.crc = 0;
    }

    public long getValue() {
        return (long)this.crc & 0xFFFFFFFFL;
    }

    private static native int update(int var0, int var1);

    private static native int updateBytes(int var0, byte[] var1, int var2, int var3);

    static {
        AccessController.doPrivileged(new LoadLibraryAction("zip"));
    }
}

