/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;

public class JTabbedPane
extends JComponent
implements Serializable,
Accessible,
SwingConstants {
    public static final int WRAP_TAB_LAYOUT = 0;
    public static final int SCROLL_TAB_LAYOUT = 1;
    private static final String uiClassID = "TabbedPaneUI";
    protected int tabPlacement = 1;
    private int tabLayoutPolicy;
    protected SingleSelectionModel model;
    private boolean haveRegistered;
    protected ChangeListener changeListener = null;
    Vector pages;
    protected transient ChangeEvent changeEvent = null;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public JTabbedPane() {
        this(1, 0);
    }

    public JTabbedPane(int n2) {
        this(n2, 0);
    }

    public JTabbedPane(int n2, int n3) {
        this.setTabPlacement(n2);
        this.setTabLayoutPolicy(n3);
        this.pages = new Vector(1);
        this.setModel(new DefaultSingleSelectionModel());
        this.updateUI();
    }

    public TabbedPaneUI getUI() {
        return (TabbedPaneUI)this.ui;
    }

    public void setUI(TabbedPaneUI tabbedPaneUI) {
        super.setUI(tabbedPaneUI);
    }

    public void updateUI() {
        this.setUI((TabbedPaneUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected ChangeListener createChangeListener() {
        return new ModelListener();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JTabbedPane.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JTabbedPane.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = JTabbedPane.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$ChangeListener == null ? JTabbedPane.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n2 + 1]).stateChanged(this.changeEvent);
            }
            n2 -= 2;
        }
    }

    public SingleSelectionModel getModel() {
        return this.model;
    }

    public void setModel(SingleSelectionModel singleSelectionModel) {
        SingleSelectionModel singleSelectionModel2 = this.getModel();
        if (singleSelectionModel2 != null) {
            singleSelectionModel2.removeChangeListener(this.changeListener);
            this.changeListener = null;
        }
        this.model = singleSelectionModel;
        if (singleSelectionModel != null) {
            this.changeListener = this.createChangeListener();
            singleSelectionModel.addChangeListener(this.changeListener);
        }
        this.firePropertyChange("model", singleSelectionModel2, singleSelectionModel);
        this.repaint();
    }

    public int getTabPlacement() {
        return this.tabPlacement;
    }

    public void setTabPlacement(int n2) {
        if (n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4) {
            throw new IllegalArgumentException("illegal tab placement: must be TOP, BOTTOM, LEFT, or RIGHT");
        }
        if (this.tabPlacement != n2) {
            int n3 = this.tabPlacement;
            this.tabPlacement = n2;
            this.firePropertyChange("tabPlacement", n3, n2);
            this.revalidate();
            this.repaint();
        }
    }

    public int getTabLayoutPolicy() {
        return this.tabLayoutPolicy;
    }

    public void setTabLayoutPolicy(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("illegal tab layout policy: must be WRAP_TAB_LAYOUT or SCROLL_TAB_LAYOUT");
        }
        if (this.tabLayoutPolicy != n2) {
            int n3 = this.tabLayoutPolicy;
            this.tabLayoutPolicy = n2;
            this.firePropertyChange("tabLayoutPolicy", n3, n2);
            this.revalidate();
            this.repaint();
        }
    }

    public int getSelectedIndex() {
        return this.model.getSelectedIndex();
    }

    public void setSelectedIndex(int n2) {
        if (n2 != -1) {
            this.checkIndex(n2);
        }
        this.setSelectedIndexImpl(n2);
    }

    private void setSelectedIndexImpl(int n2) {
        Page page;
        int n3 = this.model.getSelectedIndex();
        this.model.setSelectedIndex(n2);
        if (n3 >= 0 && n3 != n2) {
            page = (Page)this.pages.elementAt(n3);
            page.firePropertyChange("AccessibleState", AccessibleState.SELECTED, null);
        }
        if (n2 >= 0 && n3 != n2) {
            page = (Page)this.pages.elementAt(n2);
            page.firePropertyChange("AccessibleState", null, AccessibleState.SELECTED);
        }
    }

    public Component getSelectedComponent() {
        int n2 = this.getSelectedIndex();
        if (n2 == -1) {
            return null;
        }
        return this.getComponentAt(n2);
    }

    public void setSelectedComponent(Component component) {
        int n2 = this.indexOfComponent(component);
        if (n2 == -1) {
            throw new IllegalArgumentException("component not found in tabbed pane");
        }
        this.setSelectedIndex(n2);
    }

    public void insertTab(String string, Icon icon, Component component, String string2, int n2) {
        int n3 = n2;
        ImageIcon imageIcon = null;
        if (icon != null && icon instanceof ImageIcon) {
            imageIcon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
        }
        int n4 = this.indexOfComponent(component);
        if (component != null && n4 != -1) {
            this.removeTabAt(n4);
            if (n3 > n4) {
                --n3;
            }
        }
        this.pages.insertElementAt(new Page(this, string != null ? string : "", icon, imageIcon, component, string2), n3);
        if (component != null) {
            component.setVisible(false);
            this.addImpl(component, null, -1);
        }
        if (this.pages.size() == 1) {
            this.setSelectedIndex(0);
        }
        if (!this.haveRegistered && string2 != null) {
            ToolTipManager.sharedInstance().registerComponent(this);
            this.haveRegistered = true;
        }
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", null, component);
        }
        this.revalidate();
        this.repaint();
    }

    public void addTab(String string, Icon icon, Component component, String string2) {
        this.insertTab(string, icon, component, string2, this.pages.size());
    }

    public void addTab(String string, Icon icon, Component component) {
        this.insertTab(string, icon, component, null, this.pages.size());
    }

    public void addTab(String string, Component component) {
        this.insertTab(string, null, component, null, this.pages.size());
    }

    public Component add(Component component) {
        if (!(component instanceof UIResource)) {
            this.addTab(component.getName(), component);
        } else {
            super.add(component);
        }
        return component;
    }

    public Component add(String string, Component component) {
        if (!(component instanceof UIResource)) {
            this.addTab(string, component);
        } else {
            super.add(string, component);
        }
        return component;
    }

    public Component add(Component component, int n2) {
        if (!(component instanceof UIResource)) {
            this.insertTab(component.getName(), null, component, null, n2 == -1 ? this.getTabCount() : n2);
        } else {
            super.add(component, n2);
        }
        return component;
    }

    public void add(Component component, Object object) {
        if (!(component instanceof UIResource)) {
            if (object instanceof String) {
                this.addTab((String)object, component);
            } else if (object instanceof Icon) {
                this.addTab(null, (Icon)object, component);
            } else {
                this.add(component);
            }
        } else {
            super.add(component, object);
        }
    }

    public void add(Component component, Object object, int n2) {
        if (!(component instanceof UIResource)) {
            Icon icon = object instanceof Icon ? (Icon)object : null;
            String string = object instanceof String ? (String)object : null;
            this.insertTab(string, icon, component, null, n2 == -1 ? this.getTabCount() : n2);
        } else {
            super.add(component, object, n2);
        }
    }

    public void removeTabAt(int n2) {
        this.checkIndex(n2);
        int n3 = this.getTabCount();
        int n4 = this.getSelectedIndex();
        if (n4 >= n3 - 1) {
            this.setSelectedIndexImpl(n4 - 1);
        }
        Component component = this.getComponentAt(n2);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", component, null);
        }
        this.pages.removeElementAt(n2);
        this.putClientProperty("__index_to_remove__", new Integer(n2));
        if (component != null) {
            Component[] componentArray = this.getComponents();
            int n5 = componentArray.length;
            while (--n5 >= 0) {
                if (componentArray[n5] != component) continue;
                super.remove(n5);
                component.setVisible(true);
                break;
            }
        }
        this.revalidate();
        this.repaint();
    }

    public void remove(Component component) {
        int n2 = this.indexOfComponent(component);
        if (n2 != -1) {
            this.removeTabAt(n2);
        } else {
            Component[] componentArray = this.getComponents();
            int n3 = 0;
            while (n3 < componentArray.length) {
                if (component == componentArray[n3]) {
                    super.remove(n3);
                    break;
                }
                ++n3;
            }
        }
    }

    public void remove(int n2) {
        this.removeTabAt(n2);
    }

    public void removeAll() {
        this.setSelectedIndexImpl(-1);
        int n2 = this.getTabCount();
        while (n2-- > 0) {
            this.removeTabAt(n2);
        }
    }

    public int getTabCount() {
        return this.pages.size();
    }

    public int getTabRunCount() {
        if (this.ui != null) {
            return ((TabbedPaneUI)this.ui).getTabRunCount(this);
        }
        return 0;
    }

    public String getTitleAt(int n2) {
        return ((Page)this.pages.elementAt((int)n2)).title;
    }

    public Icon getIconAt(int n2) {
        return ((Page)this.pages.elementAt((int)n2)).icon;
    }

    public Icon getDisabledIconAt(int n2) {
        return ((Page)this.pages.elementAt((int)n2)).disabledIcon;
    }

    public String getToolTipTextAt(int n2) {
        return ((Page)this.pages.elementAt((int)n2)).tip;
    }

    public Color getBackgroundAt(int n2) {
        return ((Page)this.pages.elementAt(n2)).getBackground();
    }

    public Color getForegroundAt(int n2) {
        return ((Page)this.pages.elementAt(n2)).getForeground();
    }

    public boolean isEnabledAt(int n2) {
        return ((Page)this.pages.elementAt(n2)).isEnabled();
    }

    public Component getComponentAt(int n2) {
        return ((Page)this.pages.elementAt((int)n2)).component;
    }

    public int getMnemonicAt(int n2) {
        this.checkIndex(n2);
        Page page = (Page)this.pages.elementAt(n2);
        return page.getMnemonic();
    }

    public int getDisplayedMnemonicIndexAt(int n2) {
        this.checkIndex(n2);
        Page page = (Page)this.pages.elementAt(n2);
        return page.getDisplayedMnemonicIndex();
    }

    public Rectangle getBoundsAt(int n2) {
        this.checkIndex(n2);
        if (this.ui != null) {
            return ((TabbedPaneUI)this.ui).getTabBounds(this, n2);
        }
        return null;
    }

    public void setTitleAt(int n2, String string) {
        Page page = (Page)this.pages.elementAt(n2);
        String string2 = page.title;
        page.title = string;
        if (string2 != string) {
            this.firePropertyChange("indexForTitle", -1, n2);
        }
        page.updateDisplayedMnemonicIndex();
        if (string2 != string && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", string2, string);
        }
        if (string == null || string2 == null || !string.equals(string2)) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setIconAt(int n2, Icon icon) {
        Icon icon2 = ((Page)this.pages.elementAt((int)n2)).icon;
        ((Page)this.pages.elementAt((int)n2)).icon = icon;
        AccessibleContext accessibleContext = this.getAccessibleContext();
        if (icon2 != icon && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
        }
        if (icon != icon2) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setDisabledIconAt(int n2, Icon icon) {
        Icon icon2 = ((Page)this.pages.elementAt((int)n2)).disabledIcon;
        ((Page)this.pages.elementAt((int)n2)).disabledIcon = icon;
        if (icon != icon2 && !this.isEnabledAt(n2)) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setToolTipTextAt(int n2, String string) {
        String string2 = ((Page)this.pages.elementAt((int)n2)).tip;
        ((Page)this.pages.elementAt((int)n2)).tip = string;
        if (string2 != string && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", string2, string);
        }
        if (!this.haveRegistered && string != null) {
            ToolTipManager.sharedInstance().registerComponent(this);
            this.haveRegistered = true;
        }
    }

    public void setBackgroundAt(int n2, Color color) {
        Rectangle rectangle;
        Color color2 = ((Page)this.pages.elementAt((int)n2)).background;
        ((Page)this.pages.elementAt(n2)).setBackground(color);
        if (!(color != null && color2 != null && color.equals(color2) || (rectangle = this.getBoundsAt(n2)) == null)) {
            this.repaint(rectangle);
        }
    }

    public void setForegroundAt(int n2, Color color) {
        Rectangle rectangle;
        Color color2 = ((Page)this.pages.elementAt((int)n2)).foreground;
        ((Page)this.pages.elementAt(n2)).setForeground(color);
        if (!(color != null && color2 != null && color.equals(color2) || (rectangle = this.getBoundsAt(n2)) == null)) {
            this.repaint(rectangle);
        }
    }

    public void setEnabledAt(int n2, boolean bl2) {
        boolean bl3 = ((Page)this.pages.elementAt(n2)).isEnabled();
        ((Page)this.pages.elementAt(n2)).setEnabled(bl2);
        if (bl2 != bl3) {
            this.revalidate();
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComponentAt(int n2, Component component) {
        Page page = (Page)this.pages.elementAt(n2);
        if (component != page.component) {
            if (page.component != null) {
                Object object = this.getTreeLock();
                synchronized (object) {
                    int n3 = this.getComponentCount();
                    Component[] componentArray = this.getComponents();
                    int n4 = 0;
                    while (n4 < n3) {
                        if (componentArray[n4] == page.component) {
                            super.remove(n4);
                        }
                        ++n4;
                    }
                }
            }
            page.component = component;
            component.setVisible(this.getSelectedIndex() == n2);
            this.addImpl(component, null, -1);
            this.revalidate();
        }
    }

    public void setDisplayedMnemonicIndexAt(int n2, int n3) {
        this.checkIndex(n2);
        Page page = (Page)this.pages.elementAt(n2);
        page.setDisplayedMnemonicIndex(n3);
    }

    public void setMnemonicAt(int n2, int n3) {
        this.checkIndex(n2);
        Page page = (Page)this.pages.elementAt(n2);
        page.setMnemonic(n3);
        this.firePropertyChange("mnemonicAt", null, null);
    }

    public int indexOfTab(String string) {
        int n2 = 0;
        while (n2 < this.getTabCount()) {
            if (this.getTitleAt(n2).equals(string == null ? "" : string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int indexOfTab(Icon icon) {
        int n2 = 0;
        while (n2 < this.getTabCount()) {
            Icon icon2 = this.getIconAt(n2);
            if (icon2 != null && icon2.equals(icon) || icon2 == null && icon2 == icon) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int indexOfComponent(Component component) {
        int n2 = 0;
        while (n2 < this.getTabCount()) {
            Component component2 = this.getComponentAt(n2);
            if (component2 != null && component2.equals(component) || component2 == null && component2 == component) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int indexAtLocation(int n2, int n3) {
        if (this.ui != null) {
            return ((TabbedPaneUI)this.ui).tabForCoordinate(this, n2, n3);
        }
        return -1;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n2;
        if (this.ui != null && (n2 = ((TabbedPaneUI)this.ui).tabForCoordinate(this, mouseEvent.getX(), mouseEvent.getY())) != -1) {
            return ((Page)this.pages.elementAt((int)n2)).tip;
        }
        return super.getToolTipText(mouseEvent);
    }

    private void checkIndex(int n2) {
        if (n2 < 0 || n2 >= this.pages.size()) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Tab count: " + this.pages.size());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    void compWriteObjectNotify() {
        super.compWriteObjectNotify();
        if (this.getToolTipText() == null && this.haveRegistered) {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
        if (this.getToolTipText() == null && this.haveRegistered) {
            ToolTipManager.sharedInstance().registerComponent(this);
        }
    }

    protected String paramString() {
        String string = this.tabPlacement == 1 ? "TOP" : (this.tabPlacement == 3 ? "BOTTOM" : (this.tabPlacement == 2 ? "LEFT" : (this.tabPlacement == 4 ? "RIGHT" : "")));
        String string2 = this.haveRegistered ? "true" : "false";
        return super.paramString() + ",haveRegistered=" + string2 + ",tabPlacement=" + string;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTabbedPane();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Page
    extends AccessibleContext
    implements Serializable,
    Accessible,
    AccessibleComponent {
        String title;
        Color background;
        Color foreground;
        Icon icon;
        Icon disabledIcon;
        JTabbedPane parent;
        Component component;
        String tip;
        boolean enabled = true;
        boolean needsUIUpdate;
        int mnemonic;
        int mnemonicIndex = -1;

        Page(JTabbedPane jTabbedPane2, String string, Icon icon, Icon icon2, Component component, String string2) {
            AccessibleContext accessibleContext;
            this.title = string;
            this.icon = icon;
            this.disabledIcon = icon2;
            this.parent = jTabbedPane2;
            this.setAccessibleParent(jTabbedPane2);
            this.component = component;
            this.tip = string2;
            if (component instanceof Accessible && (accessibleContext = ((Accessible)((Object)component)).getAccessibleContext()) != null) {
                accessibleContext.setAccessibleParent(this);
            }
        }

        void setMnemonic(int n2) {
            this.mnemonic = n2;
            this.updateDisplayedMnemonicIndex();
        }

        int getMnemonic() {
            return this.mnemonic;
        }

        void setDisplayedMnemonicIndex(int n2) {
            if (this.mnemonicIndex != n2) {
                if (n2 != -1 && (this.title == null || n2 < 0 || n2 >= this.title.length())) {
                    throw new IllegalArgumentException("Invalid mnemonic index: " + n2);
                }
                this.mnemonicIndex = n2;
                JTabbedPane.this.firePropertyChange("displayedMnemonicIndexAt", null, null);
            }
        }

        int getDisplayedMnemonicIndex() {
            return this.mnemonicIndex;
        }

        void updateDisplayedMnemonicIndex() {
            this.setDisplayedMnemonicIndex(SwingUtilities.findDisplayedMnemonicIndex(this.title, this.mnemonic));
        }

        public AccessibleContext getAccessibleContext() {
            return this;
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (this.title != null) {
                return this.title;
            }
            return null;
        }

        public String getAccessibleDescription() {
            if (this.accessibleDescription != null) {
                return this.accessibleDescription;
            }
            if (this.tip != null) {
                return this.tip;
            }
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = this.parent.getAccessibleContext().getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.SELECTABLE);
            int n2 = this.parent.indexOfTab(this.title);
            if (n2 == this.parent.getSelectedIndex()) {
                accessibleStateSet.add(AccessibleState.SELECTED);
            }
            return accessibleStateSet;
        }

        public int getAccessibleIndexInParent() {
            return this.parent.indexOfTab(this.title);
        }

        public int getAccessibleChildrenCount() {
            if (this.component instanceof Accessible) {
                return 1;
            }
            return 0;
        }

        public Accessible getAccessibleChild(int n2) {
            if (this.component instanceof Accessible) {
                return (Accessible)((Object)this.component);
            }
            return null;
        }

        public Locale getLocale() {
            return this.parent.getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            return this.background != null ? this.background : this.parent.getBackground();
        }

        public void setBackground(Color color) {
            this.background = color;
        }

        public Color getForeground() {
            return this.foreground != null ? this.foreground : this.parent.getForeground();
        }

        public void setForeground(Color color) {
            this.foreground = color;
        }

        public Cursor getCursor() {
            return this.parent.getCursor();
        }

        public void setCursor(Cursor cursor) {
            this.parent.setCursor(cursor);
        }

        public Font getFont() {
            return this.parent.getFont();
        }

        public void setFont(Font font) {
            this.parent.setFont(font);
        }

        public FontMetrics getFontMetrics(Font font) {
            return this.parent.getFontMetrics(font);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl2) {
            this.enabled = bl2;
        }

        public boolean isVisible() {
            return this.parent.isVisible();
        }

        public void setVisible(boolean bl2) {
            this.parent.setVisible(bl2);
        }

        public boolean isShowing() {
            return this.parent.isShowing();
        }

        public boolean contains(Point point) {
            Rectangle rectangle = this.getBounds();
            return rectangle.contains(point);
        }

        public Point getLocationOnScreen() {
            Point point = this.parent.getLocationOnScreen();
            Point point2 = this.getLocation();
            point2.translate(point.x, point.y);
            return point2;
        }

        public Point getLocation() {
            Rectangle rectangle = this.getBounds();
            return new Point(rectangle.x, rectangle.y);
        }

        public void setLocation(Point point) {
        }

        public Rectangle getBounds() {
            return this.parent.getUI().getTabBounds(this.parent, this.parent.indexOfTab(this.title));
        }

        public void setBounds(Rectangle rectangle) {
        }

        public Dimension getSize() {
            Rectangle rectangle = this.getBounds();
            return new Dimension(rectangle.width, rectangle.height);
        }

        public void setSize(Dimension dimension) {
        }

        public Accessible getAccessibleAt(Point point) {
            if (this.component instanceof Accessible) {
                return (Accessible)((Object)this.component);
            }
            return null;
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
        }

        public void addFocusListener(FocusListener focusListener) {
        }

        public void removeFocusListener(FocusListener focusListener) {
        }
    }

    protected class AccessibleJTabbedPane
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    ChangeListener {
        public AccessibleJTabbedPane() {
            JTabbedPane.this.model.addChangeListener(this);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            this.firePropertyChange("AccessibleSelection", null, object);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB_LIST;
        }

        public int getAccessibleChildrenCount() {
            return JTabbedPane.this.getTabCount();
        }

        public Accessible getAccessibleChild(int n2) {
            if (n2 < 0 || n2 >= JTabbedPane.this.getTabCount()) {
                return null;
            }
            return (Accessible)JTabbedPane.this.pages.elementAt(n2);
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleAt(Point point) {
            int n2 = ((TabbedPaneUI)JTabbedPane.this.ui).tabForCoordinate(JTabbedPane.this, point.x, point.y);
            if (n2 == -1) {
                n2 = JTabbedPane.this.getSelectedIndex();
            }
            return this.getAccessibleChild(n2);
        }

        public int getAccessibleSelectionCount() {
            return 1;
        }

        public Accessible getAccessibleSelection(int n2) {
            int n3 = JTabbedPane.this.getSelectedIndex();
            if (n3 == -1) {
                return null;
            }
            return (Accessible)JTabbedPane.this.pages.elementAt(n3);
        }

        public boolean isAccessibleChildSelected(int n2) {
            return n2 == JTabbedPane.this.getSelectedIndex();
        }

        public void addAccessibleSelection(int n2) {
            JTabbedPane.this.setSelectedIndex(n2);
        }

        public void removeAccessibleSelection(int n2) {
        }

        public void clearAccessibleSelection() {
        }

        public void selectAllAccessibleSelection() {
        }
    }

    protected class ModelListener
    implements ChangeListener,
    Serializable {
        protected ModelListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane.this.fireStateChanged();
        }
    }
}

