/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.NativeLibLoader;
import sun.awt.image.SunWritableRaster;

public class BytePackedRaster
extends SunWritableRaster {
    int dataBitOffset;
    int scanlineStride;
    int pixelBitStride;
    int bitMask;
    byte[] data;
    int shiftOffset;
    int type;
    private int maxX;
    private int maxY;

    private static native void initIDs();

    public BytePackedRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public BytePackedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public BytePackedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, BytePackedRaster bytePackedRaster) {
        super(sampleModel, dataBuffer, rectangle, point, bytePackedRaster);
        this.maxX = this.minX + this.width;
        this.maxY = this.minY + this.height;
        if (!(dataBuffer instanceof DataBufferByte)) {
            throw new RasterFormatException("BytePackedRasters must havebyte DataBuffers");
        }
        DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
        this.data = dataBufferByte.getData();
        if (dataBufferByte.getNumBanks() != 1) {
            throw new RasterFormatException("DataBuffer for BytePackedRasters must only have 1 bank.");
        }
        int n2 = dataBufferByte.getOffset();
        if (sampleModel instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
            this.type = 11;
            this.pixelBitStride = multiPixelPackedSampleModel.getPixelBitStride();
            if (this.pixelBitStride != 1 && this.pixelBitStride != 2 && this.pixelBitStride != 4) {
                throw new RasterFormatException("BytePackedRasters must have a bit depth of 1, 2, or 4");
            }
            this.scanlineStride = multiPixelPackedSampleModel.getScanlineStride();
            this.dataBitOffset = multiPixelPackedSampleModel.getDataBitOffset() + n2 * 8;
            int n3 = rectangle.x - point.x;
            int n4 = rectangle.y - point.y;
            this.dataBitOffset += n3 * this.pixelBitStride + n4 * this.scanlineStride * 8;
        } else {
            throw new RasterFormatException("BytePackedRasters must haveMultiPixelPackedSampleModel");
        }
        this.bitMask = (1 << this.pixelBitStride) - 1;
        this.shiftOffset = 8 - this.pixelBitStride;
        this.verify(false);
    }

    public int getDataBitOffset() {
        return this.dataBitOffset;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getPixelBitStride() {
        return this.pixelBitStride;
    }

    public byte[] getDataStorage() {
        return this.data;
    }

    public Object getDataElements(int n2, int n3, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 >= this.maxX || n3 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = object == null ? new byte[this.numDataElements] : (byte[])object;
        int n4 = this.dataBitOffset + (n2 - this.minX) * this.pixelBitStride;
        int n5 = this.data[(n3 - this.minY) * this.scanlineStride + (n4 >> 3)] & 0xFF;
        int n6 = this.shiftOffset - (n4 & 7);
        byArray[0] = (byte)(n5 >> n6 & this.bitMask);
        return byArray;
    }

    public Object getDataElements(int n2, int n3, int n4, int n5, Object object) {
        return this.getByteData(n2, n3, n4, n5, (byte[])object);
    }

    public Object getPixelData(int n2, int n3, int n4, int n5, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = object == null ? new byte[this.numDataElements * n4 * n5] : (byte[])object;
        int n6 = this.pixelBitStride;
        int n7 = this.dataBitOffset + (n2 - this.minX) * n6;
        int n8 = (n3 - this.minY) * this.scanlineStride;
        int n9 = 0;
        byte[] byArray2 = this.data;
        int n10 = 0;
        while (n10 < n5) {
            int n11 = n7;
            int n12 = 0;
            while (n12 < n4) {
                int n13 = this.shiftOffset - (n11 & 7);
                byArray[n9++] = (byte)(this.bitMask & byArray2[n8 + (n11 >> 3)] >> n13);
                n11 += n6;
                ++n12;
            }
            n8 += this.scanlineStride;
            ++n10;
        }
        return byArray;
    }

    public byte[] getByteData(int n2, int n3, int n4, int n5, int n6, byte[] byArray) {
        return this.getByteData(n2, n3, n4, n5, byArray);
    }

    public byte[] getByteData(int n2, int n3, int n4, int n5, byte[] byArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (byArray == null) {
            byArray = new byte[n4 * n5];
        }
        int n6 = this.pixelBitStride;
        int n7 = this.dataBitOffset + (n2 - this.minX) * n6;
        int n8 = (n3 - this.minY) * this.scanlineStride;
        int n9 = 0;
        byte[] byArray2 = this.data;
        int n10 = 0;
        while (n10 < n5) {
            int n11;
            int n12 = n7;
            int n13 = 0;
            while (n13 < n4 && (n12 & 7) != 0) {
                n11 = this.shiftOffset - (n12 & 7);
                byArray[n9++] = (byte)(this.bitMask & byArray2[n8 + (n12 >> 3)] >> n11);
                n12 += n6;
                ++n13;
            }
            n11 = n8 + (n12 >> 3);
            switch (n6) {
                case 1: {
                    byte by;
                    while (n13 < n4 - 7) {
                        by = byArray2[n11++];
                        byArray[n9++] = (byte)(by >> 7 & 1);
                        byArray[n9++] = (byte)(by >> 6 & 1);
                        byArray[n9++] = (byte)(by >> 5 & 1);
                        byArray[n9++] = (byte)(by >> 4 & 1);
                        byArray[n9++] = (byte)(by >> 3 & 1);
                        byArray[n9++] = (byte)(by >> 2 & 1);
                        byArray[n9++] = (byte)(by >> 1 & 1);
                        byArray[n9++] = (byte)(by & 1);
                        n12 += 8;
                        n13 += 8;
                    }
                    break;
                }
                case 2: {
                    byte by;
                    while (n13 < n4 - 7) {
                        by = byArray2[n11++];
                        byArray[n9++] = (byte)(by >> 6 & 3);
                        byArray[n9++] = (byte)(by >> 4 & 3);
                        byArray[n9++] = (byte)(by >> 2 & 3);
                        byArray[n9++] = (byte)(by & 3);
                        by = byArray2[n11++];
                        byArray[n9++] = (byte)(by >> 6 & 3);
                        byArray[n9++] = (byte)(by >> 4 & 3);
                        byArray[n9++] = (byte)(by >> 2 & 3);
                        byArray[n9++] = (byte)(by & 3);
                        n12 += 16;
                        n13 += 8;
                    }
                    break;
                }
                case 4: {
                    byte by;
                    while (n13 < n4 - 7) {
                        by = byArray2[n11++];
                        byArray[n9++] = (byte)(by >> 4 & 0xF);
                        byArray[n9++] = (byte)(by & 0xF);
                        by = byArray2[n11++];
                        byArray[n9++] = (byte)(by >> 4 & 0xF);
                        byArray[n9++] = (byte)(by & 0xF);
                        by = byArray2[n11++];
                        byArray[n9++] = (byte)(by >> 4 & 0xF);
                        byArray[n9++] = (byte)(by & 0xF);
                        by = byArray2[n11++];
                        byArray[n9++] = (byte)(by >> 4 & 0xF);
                        byArray[n9++] = (byte)(by & 0xF);
                        n12 += 32;
                        n13 += 8;
                    }
                    break;
                }
            }
            while (n13 < n4) {
                int n14 = this.shiftOffset - (n12 & 7);
                byArray[n9++] = (byte)(this.bitMask & byArray2[n8 + (n12 >> 3)] >> n14);
                n12 += n6;
                ++n13;
            }
            n8 += this.scanlineStride;
            ++n10;
        }
        return byArray;
    }

    public void setDataElements(int n2, int n3, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 >= this.maxX || n3 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        byte[] byArray = (byte[])object;
        int n4 = this.dataBitOffset + (n2 - this.minX) * this.pixelBitStride;
        int n5 = (n3 - this.minY) * this.scanlineStride + (n4 >> 3);
        int n6 = this.shiftOffset - (n4 & 7);
        byte by = this.data[n5];
        by = (byte)(by & ~(this.bitMask << n6));
        this.data[n5] = by = (byte)(by | (byArray[0] & this.bitMask) << n6);
        this.notifyChanged();
    }

    public void setDataElements(int n2, int n3, Raster raster) {
        if (!(raster instanceof BytePackedRaster) || ((BytePackedRaster)raster).pixelBitStride != this.pixelBitStride) {
            super.setDataElements(n2, n3, raster);
            return;
        }
        int n4 = raster.getMinX();
        int n5 = raster.getMinY();
        int n6 = n4 + n2;
        int n7 = n5 + n3;
        int n8 = raster.getWidth();
        int n9 = raster.getHeight();
        if (n6 < this.minX || n7 < this.minY || n6 + n8 > this.maxX || n7 + n9 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        this.setDataElements(n6, n7, n4, n5, n8, n9, (BytePackedRaster)raster);
    }

    private void setDataElements(int n2, int n3, int n4, int n5, int n6, int n7, BytePackedRaster bytePackedRaster) {
        block20: {
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            int n18;
            int n19;
            int n20;
            int n21;
            int n22;
            int n23;
            byte[] byArray;
            byte[] byArray2;
            block19: {
                int n24;
                int n25;
                int n26;
                int n27;
                int n28;
                if (n6 <= 0 || n7 <= 0) {
                    return;
                }
                byArray2 = bytePackedRaster.data;
                byArray = this.data;
                n23 = bytePackedRaster.scanlineStride;
                n22 = this.scanlineStride;
                n21 = bytePackedRaster.dataBitOffset + 8 * (n5 - bytePackedRaster.minY) * n23 + (n4 - bytePackedRaster.minX) * bytePackedRaster.pixelBitStride;
                n20 = this.dataBitOffset + 8 * (n3 - this.minY) * n22 + (n2 - this.minX) * this.pixelBitStride;
                n19 = n6 * this.pixelBitStride;
                if ((n21 & 7) != (n20 & 7)) break block19;
                int n29 = n20 & 7;
                if (n29 != 0) {
                    n28 = 8 - n29;
                    n27 = n21 >> 3;
                    n26 = n20 >> 3;
                    n25 = 255 >> n29;
                    if (n19 < n28) {
                        n25 &= 255 << n28 - n19;
                        n28 = n19;
                    }
                    n24 = 0;
                    while (n24 < n7) {
                        int n30 = byArray[n26];
                        n30 &= ~n25;
                        byArray[n26] = (byte)(n30 |= byArray2[n27] & n25);
                        n27 += n23;
                        n26 += n22;
                        ++n24;
                    }
                    n21 += n28;
                    n20 += n28;
                    n19 -= n28;
                }
                if (n19 >= 8) {
                    n28 = n21 >> 3;
                    n27 = n20 >> 3;
                    n26 = n19 >> 3;
                    if (n26 == n23 && n23 == n22) {
                        System.arraycopy(byArray2, n28, byArray, n27, n23 * n7);
                    } else {
                        n25 = 0;
                        while (n25 < n7) {
                            System.arraycopy(byArray2, n28, byArray, n27, n26);
                            n28 += n23;
                            n27 += n22;
                            ++n25;
                        }
                    }
                    n25 = n26 * 8;
                    n21 += n25;
                    n20 += n25;
                    n19 -= n25;
                }
                if (n19 <= 0) break block20;
                n28 = n21 >> 3;
                n27 = n20 >> 3;
                n26 = 65280 >> n19 & 0xFF;
                n25 = 0;
                while (n25 < n7) {
                    n24 = byArray[n27];
                    n24 &= ~n26;
                    byArray[n27] = (byte)(n24 |= byArray2[n28] & n26);
                    n28 += n23;
                    n27 += n22;
                    ++n25;
                }
                break block20;
            }
            int n31 = n20 & 7;
            if (n31 != 0 || n19 < 8) {
                n18 = 8 - n31;
                n17 = n21 >> 3;
                n16 = n20 >> 3;
                n15 = n21 & 7;
                n14 = 8 - n15;
                n13 = 255 >> n31;
                if (n19 < n18) {
                    n13 &= 255 << n18 - n19;
                    n18 = n19;
                }
                n12 = byArray2.length - 1;
                n11 = 0;
                while (n11 < n7) {
                    n10 = byArray2[n17];
                    n9 = 0;
                    if (n17 < n12) {
                        n9 = byArray2[n17 + 1];
                    }
                    n8 = byArray[n16];
                    n8 &= ~n13;
                    byArray[n16] = (byte)(n8 |= (n10 << n15 | (n9 & 0xFF) >> n14) >> n31 & n13);
                    n17 += n23;
                    n16 += n22;
                    ++n11;
                }
                n21 += n18;
                n20 += n18;
                n19 -= n18;
            }
            if (n19 >= 8) {
                n18 = n21 >> 3;
                n17 = n20 >> 3;
                n16 = n19 >> 3;
                n15 = n21 & 7;
                n14 = 8 - n15;
                n13 = 0;
                while (n13 < n7) {
                    n12 = n18 + n13 * n23;
                    n11 = n17 + n13 * n22;
                    n10 = byArray2[n12];
                    n9 = 0;
                    while (n9 < n16) {
                        n8 = byArray2[n12 + 1];
                        int n32 = n10 << n15 | (n8 & 0xFF) >> n14;
                        byArray[n11] = (byte)n32;
                        n10 = n8;
                        ++n12;
                        ++n11;
                        ++n9;
                    }
                    ++n13;
                }
                n12 = n16 * 8;
                n21 += n12;
                n20 += n12;
                n19 -= n12;
            }
            if (n19 > 0) {
                n18 = n21 >> 3;
                n17 = n20 >> 3;
                n16 = 65280 >> n19 & 0xFF;
                n15 = n21 & 7;
                n14 = 8 - n15;
                n13 = byArray2.length - 1;
                n12 = 0;
                while (n12 < n7) {
                    n11 = byArray2[n18];
                    n10 = 0;
                    if (n18 < n13) {
                        n10 = byArray2[n18 + 1];
                    }
                    n9 = byArray[n17];
                    n9 &= ~n16;
                    byArray[n17] = (byte)(n9 |= (n11 << n15 | (n10 & 0xFF) >> n14) & n16);
                    n18 += n23;
                    n17 += n22;
                    ++n12;
                }
            }
        }
    }

    public void setRect(int n2, int n3, Raster raster) {
        int n4;
        if (!(raster instanceof BytePackedRaster) || ((BytePackedRaster)raster).pixelBitStride != this.pixelBitStride) {
            super.setRect(n2, n3, raster);
            return;
        }
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        int n7 = raster.getMinX();
        int n8 = raster.getMinY();
        int n9 = n2 + n7;
        int n10 = n3 + n8;
        if (n9 < this.minX) {
            n4 = this.minX - n9;
            n5 -= n4;
            n7 += n4;
            n9 = this.minX;
        }
        if (n10 < this.minY) {
            n4 = this.minY - n10;
            n6 -= n4;
            n8 += n4;
            n10 = this.minY;
        }
        if (n9 + n5 > this.maxX) {
            n5 = this.maxX - n9;
        }
        if (n10 + n6 > this.maxY) {
            n6 = this.maxY - n10;
        }
        this.setDataElements(n9, n10, n7, n8, n5, n6, (BytePackedRaster)raster);
        this.notifyChanged();
    }

    public void setDataElements(int n2, int n3, int n4, int n5, Object object) {
        this.putByteData(n2, n3, n4, n5, (byte[])object);
    }

    public void putByteData(int n2, int n3, int n4, int n5, int n6, byte[] byArray) {
        this.putByteData(n2, n3, n4, n5, byArray);
    }

    public void putByteData(int n2, int n3, int n4, int n5, byte[] byArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (n4 == 0 || n5 == 0) {
            return;
        }
        int n6 = this.pixelBitStride;
        int n7 = this.dataBitOffset + (n2 - this.minX) * n6;
        int n8 = (n3 - this.minY) * this.scanlineStride;
        int n9 = 0;
        byte[] byArray2 = this.data;
        int n10 = 0;
        while (n10 < n5) {
            int n11;
            int n12;
            int n13 = n7;
            int n14 = 0;
            while (n14 < n4 && (n13 & 7) != 0) {
                n12 = this.shiftOffset - (n13 & 7);
                n11 = byArray2[n8 + (n13 >> 3)];
                n11 &= ~(this.bitMask << n12);
                byArray2[n8 + (n13 >> 3)] = (byte)(n11 |= (byArray[n9++] & this.bitMask) << n12);
                n13 += n6;
                ++n14;
            }
            n12 = n8 + (n13 >> 3);
            switch (n6) {
                case 1: {
                    while (n14 < n4 - 7) {
                        n11 = (byArray[n9++] & 1) << 7;
                        n11 |= (byArray[n9++] & 1) << 6;
                        n11 |= (byArray[n9++] & 1) << 5;
                        n11 |= (byArray[n9++] & 1) << 4;
                        n11 |= (byArray[n9++] & 1) << 3;
                        n11 |= (byArray[n9++] & 1) << 2;
                        n11 |= (byArray[n9++] & 1) << 1;
                        byArray2[n12++] = (byte)(n11 |= byArray[n9++] & 1);
                        n13 += 8;
                        n14 += 8;
                    }
                    break;
                }
                case 2: {
                    while (n14 < n4 - 7) {
                        n11 = (byArray[n9++] & 3) << 6;
                        n11 |= (byArray[n9++] & 3) << 4;
                        n11 |= (byArray[n9++] & 3) << 2;
                        byArray2[n12++] = (byte)(n11 |= byArray[n9++] & 3);
                        n11 = (byArray[n9++] & 3) << 6;
                        n11 |= (byArray[n9++] & 3) << 4;
                        n11 |= (byArray[n9++] & 3) << 2;
                        byArray2[n12++] = (byte)(n11 |= byArray[n9++] & 3);
                        n13 += 16;
                        n14 += 8;
                    }
                    break;
                }
                case 4: {
                    while (n14 < n4 - 7) {
                        n11 = (byArray[n9++] & 0xF) << 4;
                        byArray2[n12++] = (byte)(n11 |= byArray[n9++] & 0xF);
                        n11 = (byArray[n9++] & 0xF) << 4;
                        byArray2[n12++] = (byte)(n11 |= byArray[n9++] & 0xF);
                        n11 = (byArray[n9++] & 0xF) << 4;
                        byArray2[n12++] = (byte)(n11 |= byArray[n9++] & 0xF);
                        n11 = (byArray[n9++] & 0xF) << 4;
                        byArray2[n12++] = (byte)(n11 |= byArray[n9++] & 0xF);
                        n13 += 32;
                        n14 += 8;
                    }
                    break;
                }
            }
            while (n14 < n4) {
                int n15 = this.shiftOffset - (n13 & 7);
                n11 = byArray2[n8 + (n13 >> 3)];
                n11 &= ~(this.bitMask << n15);
                byArray2[n8 + (n13 >> 3)] = (byte)(n11 |= (byArray[n9++] & this.bitMask) << n15);
                n13 += n6;
                ++n14;
            }
            n8 += this.scanlineStride;
            ++n10;
        }
        this.notifyChanged();
    }

    public int[] getPixels(int n2, int n3, int n4, int n5, int[] nArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (nArray == null) {
            nArray = new int[n4 * n5];
        }
        int n6 = this.pixelBitStride;
        int n7 = this.dataBitOffset + (n2 - this.minX) * n6;
        int n8 = (n3 - this.minY) * this.scanlineStride;
        int n9 = 0;
        byte[] byArray = this.data;
        int n10 = 0;
        while (n10 < n5) {
            int n11;
            int n12 = n7;
            int n13 = 0;
            while (n13 < n4 && (n12 & 7) != 0) {
                n11 = this.shiftOffset - (n12 & 7);
                nArray[n9++] = this.bitMask & byArray[n8 + (n12 >> 3)] >> n11;
                n12 += n6;
                ++n13;
            }
            n11 = n8 + (n12 >> 3);
            switch (n6) {
                case 1: {
                    byte by;
                    while (n13 < n4 - 7) {
                        by = byArray[n11++];
                        nArray[n9++] = by >> 7 & 1;
                        nArray[n9++] = by >> 6 & 1;
                        nArray[n9++] = by >> 5 & 1;
                        nArray[n9++] = by >> 4 & 1;
                        nArray[n9++] = by >> 3 & 1;
                        nArray[n9++] = by >> 2 & 1;
                        nArray[n9++] = by >> 1 & 1;
                        nArray[n9++] = by & 1;
                        n12 += 8;
                        n13 += 8;
                    }
                    break;
                }
                case 2: {
                    byte by;
                    while (n13 < n4 - 7) {
                        by = byArray[n11++];
                        nArray[n9++] = by >> 6 & 3;
                        nArray[n9++] = by >> 4 & 3;
                        nArray[n9++] = by >> 2 & 3;
                        nArray[n9++] = by & 3;
                        by = byArray[n11++];
                        nArray[n9++] = by >> 6 & 3;
                        nArray[n9++] = by >> 4 & 3;
                        nArray[n9++] = by >> 2 & 3;
                        nArray[n9++] = by & 3;
                        n12 += 16;
                        n13 += 8;
                    }
                    break;
                }
                case 4: {
                    byte by;
                    while (n13 < n4 - 7) {
                        by = byArray[n11++];
                        nArray[n9++] = by >> 4 & 0xF;
                        nArray[n9++] = by & 0xF;
                        by = byArray[n11++];
                        nArray[n9++] = by >> 4 & 0xF;
                        nArray[n9++] = by & 0xF;
                        by = byArray[n11++];
                        nArray[n9++] = by >> 4 & 0xF;
                        nArray[n9++] = by & 0xF;
                        by = byArray[n11++];
                        nArray[n9++] = by >> 4 & 0xF;
                        nArray[n9++] = by & 0xF;
                        n12 += 32;
                        n13 += 8;
                    }
                    break;
                }
            }
            while (n13 < n4) {
                int n14 = this.shiftOffset - (n12 & 7);
                nArray[n9++] = this.bitMask & byArray[n8 + (n12 >> 3)] >> n14;
                n12 += n6;
                ++n13;
            }
            n8 += this.scanlineStride;
            ++n10;
        }
        return nArray;
    }

    public void setPixels(int n2, int n3, int n4, int n5, int[] nArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = this.pixelBitStride;
        int n7 = this.dataBitOffset + (n2 - this.minX) * n6;
        int n8 = (n3 - this.minY) * this.scanlineStride;
        int n9 = 0;
        byte[] byArray = this.data;
        int n10 = 0;
        while (n10 < n5) {
            int n11;
            int n12;
            int n13 = n7;
            int n14 = 0;
            while (n14 < n4 && (n13 & 7) != 0) {
                n12 = this.shiftOffset - (n13 & 7);
                n11 = byArray[n8 + (n13 >> 3)];
                n11 &= ~(this.bitMask << n12);
                byArray[n8 + (n13 >> 3)] = (byte)(n11 |= (nArray[n9++] & this.bitMask) << n12);
                n13 += n6;
                ++n14;
            }
            n12 = n8 + (n13 >> 3);
            switch (n6) {
                case 1: {
                    while (n14 < n4 - 7) {
                        n11 = (nArray[n9++] & 1) << 7;
                        n11 |= (nArray[n9++] & 1) << 6;
                        n11 |= (nArray[n9++] & 1) << 5;
                        n11 |= (nArray[n9++] & 1) << 4;
                        n11 |= (nArray[n9++] & 1) << 3;
                        n11 |= (nArray[n9++] & 1) << 2;
                        n11 |= (nArray[n9++] & 1) << 1;
                        byArray[n12++] = (byte)(n11 |= nArray[n9++] & 1);
                        n13 += 8;
                        n14 += 8;
                    }
                    break;
                }
                case 2: {
                    while (n14 < n4 - 7) {
                        n11 = (nArray[n9++] & 3) << 6;
                        n11 |= (nArray[n9++] & 3) << 4;
                        n11 |= (nArray[n9++] & 3) << 2;
                        byArray[n12++] = (byte)(n11 |= nArray[n9++] & 3);
                        n11 = (nArray[n9++] & 3) << 6;
                        n11 |= (nArray[n9++] & 3) << 4;
                        n11 |= (nArray[n9++] & 3) << 2;
                        byArray[n12++] = (byte)(n11 |= nArray[n9++] & 3);
                        n13 += 16;
                        n14 += 8;
                    }
                    break;
                }
                case 4: {
                    while (n14 < n4 - 7) {
                        n11 = (nArray[n9++] & 0xF) << 4;
                        byArray[n12++] = (byte)(n11 |= nArray[n9++] & 0xF);
                        n11 = (nArray[n9++] & 0xF) << 4;
                        byArray[n12++] = (byte)(n11 |= nArray[n9++] & 0xF);
                        n11 = (nArray[n9++] & 0xF) << 4;
                        byArray[n12++] = (byte)(n11 |= nArray[n9++] & 0xF);
                        n11 = (nArray[n9++] & 0xF) << 4;
                        byArray[n12++] = (byte)(n11 |= nArray[n9++] & 0xF);
                        n13 += 32;
                        n14 += 8;
                    }
                    break;
                }
            }
            while (n14 < n4) {
                int n15 = this.shiftOffset - (n13 & 7);
                n11 = byArray[n8 + (n13 >> 3)];
                n11 &= ~(this.bitMask << n15);
                byArray[n8 + (n13 >> 3)] = (byte)(n11 |= (nArray[n9++] & this.bitMask) << n15);
                n13 += n6;
                ++n14;
            }
            n8 += this.scanlineStride;
            ++n10;
        }
    }

    public Raster createChild(int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        WritableRaster writableRaster = this.createWritableChild(n2, n3, n4, n5, n6, n7, nArray);
        return writableRaster;
    }

    public WritableRaster createWritableChild(int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        if (n2 < this.minX) {
            throw new RasterFormatException("x lies outside the raster");
        }
        if (n3 < this.minY) {
            throw new RasterFormatException("y lies outside the raster");
        }
        if (n2 + n4 < n2 || n2 + n4 > this.minX + this.width) {
            throw new RasterFormatException("(x + width) is outside of Raster");
        }
        if (n3 + n5 < n3 || n3 + n5 > this.minY + this.height) {
            throw new RasterFormatException("(y + height) is outside of Raster");
        }
        SampleModel sampleModel = nArray != null ? this.sampleModel.createSubsetSampleModel(nArray) : this.sampleModel;
        int n8 = n6 - n2;
        int n9 = n7 - n3;
        this.notifyStolen();
        return new BytePackedRaster(sampleModel, this.dataBuffer, new Rectangle(n6, n7, n4, n5), new Point(this.sampleModelTranslateX + n8, this.sampleModelTranslateY + n9), this);
    }

    public WritableRaster createCompatibleWritableRaster(int n2, int n3) {
        if (n2 <= 0 || n3 <= 0) {
            throw new RasterFormatException("negative " + (n2 <= 0 ? "width" : "height"));
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(n2, n3);
        return new BytePackedRaster(sampleModel, new Point(0, 0));
    }

    public WritableRaster createCompatibleWritableRaster() {
        return this.createCompatibleWritableRaster(this.width, this.height);
    }

    private void verify(boolean bl2) {
        if (this.dataBitOffset < 0) {
            throw new RasterFormatException("Data offsets must be >= 0");
        }
        int n2 = this.dataBitOffset + (this.height - 1) * this.scanlineStride * 8 + (this.width - 1) * this.pixelBitStride + this.pixelBitStride - 1;
        if (n2 / 8 >= this.data.length) {
            throw new RasterFormatException("raster dimensions overflow array bounds");
        }
        if (bl2 && this.height > 1 && (n2 = this.width * this.pixelBitStride - 1) / 8 >= this.scanlineStride) {
            throw new RasterFormatException("data for adjacent scanlines overlaps");
        }
    }

    public String toString() {
        return new String("BytePackedRaster: width = " + this.width + " height = " + this.height + " #channels " + this.numBands + " xOff = " + this.sampleModelTranslateX + " yOff = " + this.sampleModelTranslateY);
    }

    static {
        NativeLibLoader.loadLibraries();
        BytePackedRaster.initIDs();
    }
}

