/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.peer.CheckboxPeer;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MToolkit;

public class MCheckboxPeer
extends MComponentPeer
implements CheckboxPeer {
    private boolean inUpCall = false;
    private boolean inInit = false;
    static final int SIZE = 19;
    static final int BORDER = 4;
    static final int SIZ = 10;

    native void create(MComponentPeer var1);

    native void pSetState(boolean var1);

    native boolean pGetState();

    public native void setLabel(String var1);

    public native void setCheckboxGroup(CheckboxGroup var1);

    void initialize() {
        Checkbox checkbox = (Checkbox)this.target;
        this.inInit = true;
        this.setState(checkbox.getState());
        this.setCheckboxGroup(checkbox.getCheckboxGroup());
        super.initialize();
        this.inInit = false;
    }

    public MCheckboxPeer(Checkbox checkbox) {
        super(checkbox);
    }

    public boolean isFocusable() {
        return true;
    }

    public void setState(boolean bl2) {
        if (this.inInit) {
            this.pSetState(bl2);
        } else if (!this.inUpCall && bl2 != this.pGetState()) {
            this.pSetState(bl2);
        }
    }

    private native int getIndicatorSize();

    private native int getSpacing();

    public Dimension getMinimumSize() {
        String string = ((Checkbox)this.target).getLabel();
        if (string == null) {
            string = "";
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        int n2 = fontMetrics.stringWidth(string) + this.getIndicatorSize() + this.getSpacing() + 8;
        int n3 = Math.max(fontMetrics.getHeight() + 8, 15);
        return new Dimension(n2, n3);
    }

    void notifyStateChanged(boolean bl2) {
        Checkbox checkbox = (Checkbox)this.target;
        ItemEvent itemEvent = new ItemEvent(checkbox, 701, checkbox.getLabel(), bl2 ? 1 : 2);
        this.postEvent(itemEvent);
    }

    void action(boolean bl2) {
        final Checkbox checkbox = (Checkbox)this.target;
        final boolean bl3 = bl2;
        MToolkit.executeOnEventHandlerThread(checkbox, new Runnable(){

            public void run() {
                CheckboxGroup checkboxGroup = checkbox.getCheckboxGroup();
                if (checkboxGroup != null && checkboxGroup.getSelectedCheckbox() == checkbox && checkbox.getState()) {
                    MCheckboxPeer.this.inUpCall = false;
                    checkbox.setState(true);
                    return;
                }
                checkbox.setState(bl3);
                MCheckboxPeer.this.notifyStateChanged(bl3);
            }
        });
    }

    public void print(Graphics graphics) {
        Checkbox checkbox = (Checkbox)this.target;
        Dimension dimension = checkbox.size();
        Color color = checkbox.getBackground();
        Color color2 = checkbox.getForeground();
        Color color3 = color.darker();
        int n2 = 4;
        int n3 = (dimension.height - 19) / 2 + 4;
        graphics.setColor(checkbox.getState() ? color3 : color);
        if (checkbox.getCheckboxGroup() != null) {
            graphics.fillOval(n2, n3, 10, 10);
            this.draw3DOval(graphics, color, n2, n3, 10, 10, !checkbox.getState());
            if (checkbox.getState()) {
                graphics.setColor(color2);
                graphics.fillOval(n2 + 3, n3 + 3, 4, 4);
            }
        } else {
            graphics.fillRect(n2, n3, 10, 10);
            this.draw3DRect(graphics, color, n2, n3, 10, 10, !checkbox.getState());
            if (checkbox.getState()) {
                graphics.setColor(color2);
                graphics.drawLine(n2 + 1, n3 + 1, n2 + 10 - 1, n3 + 10 - 1);
                graphics.drawLine(n2 + 1, n3 + 10 - 1, n2 + 10 - 1, n3 + 1);
            }
        }
        graphics.setColor(color2);
        String string = checkbox.getLabel();
        if (string != null) {
            graphics.setFont(checkbox.getFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.drawString(string, 19, (dimension.height + fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent()) / 2);
        }
        this.target.print(graphics);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }
}

