/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.peer.ScrollbarPeer;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MToolkit;

class MScrollbarPeer
extends MComponentPeer
implements ScrollbarPeer {
    private boolean inUpCall = false;
    private boolean dragInProgress = false;

    native void create(MComponentPeer var1);

    MScrollbarPeer(Scrollbar scrollbar) {
        super(scrollbar);
    }

    private static native void initIDs();

    public native void pSetValues(int var1, int var2, int var3, int var4);

    public native void setLineIncrement(int var1);

    public native void setPageIncrement(int var1);

    public Dimension getMinimumSize() {
        if (((Scrollbar)this.target).getOrientation() == 1) {
            return new Dimension(18, 50);
        }
        return new Dimension(50, 18);
    }

    private void postAdjustmentEvent(final int n2, final int n3, final boolean bl2) {
        final Scrollbar scrollbar = (Scrollbar)this.target;
        MToolkit.executeOnEventHandlerThread(scrollbar, new Runnable(){

            public void run() {
                MScrollbarPeer.this.inUpCall = true;
                scrollbar.setValueIsAdjusting(bl2);
                scrollbar.setValue(n3);
                MScrollbarPeer.this.postEvent(new AdjustmentEvent(scrollbar, 601, n2, n3, bl2));
                MScrollbarPeer.this.inUpCall = false;
            }
        });
    }

    void lineUp(int n2) {
        this.postAdjustmentEvent(2, n2, false);
    }

    void lineDown(int n2) {
        this.postAdjustmentEvent(1, n2, false);
    }

    void pageUp(int n2) {
        this.postAdjustmentEvent(3, n2, false);
    }

    void pageDown(int n2) {
        this.postAdjustmentEvent(4, n2, false);
    }

    void warp(int n2) {
        this.postAdjustmentEvent(5, n2, false);
    }

    void drag(int n2) {
        if (!this.dragInProgress) {
            this.dragInProgress = true;
        }
        this.postAdjustmentEvent(5, n2, true);
    }

    void dragEnd(final int n2) {
        final Scrollbar scrollbar = (Scrollbar)this.target;
        if (!this.dragInProgress) {
            return;
        }
        this.dragInProgress = false;
        MToolkit.executeOnEventHandlerThread(scrollbar, new Runnable(){

            public void run() {
                MScrollbarPeer.this.inUpCall = true;
                scrollbar.setValueIsAdjusting(false);
                MScrollbarPeer.this.postEvent(new AdjustmentEvent(scrollbar, 601, 5, n2, false));
                MScrollbarPeer.this.inUpCall = false;
            }
        });
    }

    public void setValues(int n2, int n3, int n4, int n5) {
        if (!this.inUpCall) {
            this.pSetValues(n2, n3, n4, n5);
        }
    }

    public void print(Graphics graphics) {
        Scrollbar scrollbar = (Scrollbar)this.target;
        Dimension dimension = scrollbar.size();
        Color color = scrollbar.getBackground();
        boolean bl2 = scrollbar.getOrientation() == 0;
        this.drawScrollbar(graphics, color, bl2 ? dimension.height : dimension.width, bl2 ? dimension.width : dimension.height, scrollbar.getMinimum(), scrollbar.getMaximum(), scrollbar.getValue(), scrollbar.getVisible(), bl2);
        this.target.print(graphics);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public boolean isFocusable() {
        return true;
    }

    static {
        MScrollbarPeer.initIDs();
    }
}

